/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.values.CollectionValue;

public class CollectIteration
extends AbstractIteration {
    @NonNull
    public static final CollectIteration INSTANCE = new CollectIteration();

    @NonNull
    public CollectionValue.Accumulator createAccumulatorValue(@NonNull DomainEvaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return CollectIteration.createCollectionAccumulatorValue((CollectionTypeId)((CollectionTypeId)accumulatorTypeId));
    }

    @Nullable
    protected Object updateAccumulator(@NonNull DomainIterationManager iterationManager) {
        Object bodyVal = iterationManager.evaluateBody();
        CollectionValue.Accumulator accumulatorValue = (CollectionValue.Accumulator)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        if (bodyVal == null) {
            accumulatorValue.add(bodyVal);
        } else if (bodyVal instanceof CollectionValue) {
            CollectionValue bodyColl = (CollectionValue)bodyVal;
            for (Object value : bodyColl.flatten().iterable()) {
                if (value == null) continue;
                accumulatorValue.add(value);
            }
        } else {
            accumulatorValue.add(bodyVal);
        }
        return CARRY_ON;
    }
}

