/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.oclany;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractUntypedBinaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

public abstract class OclComparableComparisonOperation
extends AbstractUntypedBinaryOperation {
    @NonNull
    public Boolean evaluate(@NonNull DomainEvaluator evaluator, @Nullable Object left, @Nullable Object right) {
        DomainStandardLibrary standardLibrary = evaluator.getStandardLibrary();
        DomainInheritance leftType = evaluator.getIdResolver().getDynamicTypeOf(left).getInheritance(standardLibrary);
        DomainInheritance rightType = evaluator.getIdResolver().getDynamicTypeOf(right).getInheritance(standardLibrary);
        DomainInheritance commonType = leftType.getCommonInheritance(rightType);
        DomainInheritance comparableType = standardLibrary.getOclComparableType().getInheritance(standardLibrary);
        DomainInheritance selfType = standardLibrary.getOclSelfType().getInheritance(standardLibrary);
        DomainOperation staticOperation = comparableType.lookupLocalOperation(standardLibrary, "compareTo", new DomainInheritance[]{selfType});
        LibraryBinaryOperation implementation = null;
        try {
            if (staticOperation != null) {
                implementation = (LibraryBinaryOperation)commonType.lookupImplementation(standardLibrary, staticOperation);
            }
        }
        catch (Exception e) {
            throw new InvalidValueException(e, "No 'compareTo' implementation");
        }
        if (implementation != null) {
            Object comparison = implementation.evaluate(evaluator, (TypeId)TypeId.INTEGER, left, right);
            int intComparison = ValuesUtil.asInteger((Object)comparison);
            return this.getResultValue(intComparison);
        }
        throw new InvalidValueException("Unsupported compareTo for ''{0}''", new Object[]{left != null ? left.getClass().getName() : "null"});
    }

    protected abstract boolean getResultValue(Integer var1);
}

