/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.internal.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.values.IntegerRange;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.library.classifier.OclTypeConformsToOperation;
import org.eclipse.ocl.examples.library.collection.CollectionSizeOperation;
import org.eclipse.ocl.examples.library.collection.OrderedCollectionAtOperation;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.PivotTables;
import org.eclipse.ocl.examples.pivot.ReferringElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.internal.impl.FeatureCallExpImpl;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationCallExpImpl
extends FeatureCallExpImpl
implements OperationCallExp {
    protected EList<OCLExpression> argument;
    protected Operation referredOperation;

    protected OperationCallExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.OPERATION_CALL_EXP;
    }

    @Override
    @NonNull
    public List<OCLExpression> getArgument() {
        if (this.argument == null) {
            this.argument = new EObjectContainmentEList(OCLExpression.class, (InternalEObject)this, 10);
        }
        return this.argument;
    }

    @Override
    public Operation getReferredOperation() {
        if (this.referredOperation != null && this.referredOperation.eIsProxy()) {
            InternalEObject oldReferredOperation = (InternalEObject)this.referredOperation;
            this.referredOperation = (Operation)this.eResolveProxy(oldReferredOperation);
            if (this.referredOperation != oldReferredOperation && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 11, (Object)oldReferredOperation, (Object)this.referredOperation));
            }
        }
        return this.referredOperation;
    }

    public Operation basicGetReferredOperation() {
        return this.referredOperation;
    }

    @Override
    public void setReferredOperation(Operation newReferredOperation) {
        Operation oldReferredOperation = this.referredOperation;
        this.referredOperation = newReferredOperation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldReferredOperation, (Object)this.referredOperation));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getExtension()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getOwnedAnnotation()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getOwnedComment()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return this.basicSetSource(null, msgs);
            }
            case 10: {
                return ((InternalEList)this.getArgument()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return this.eDynamicInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getExtension();
            }
            case 1: {
                return this.getOwnedAnnotation();
            }
            case 2: {
                return this.getOwnedComment();
            }
            case 3: {
                return this.isStatic();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.isRequired();
            }
            case 6: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 7: {
                return this.isImplicit();
            }
            case 8: {
                return this.getSource();
            }
            case 9: {
                return this.isPre();
            }
            case 10: {
                return this.getArgument();
            }
            case 11: {
                if (resolve) {
                    return this.getReferredOperation();
                }
                return this.basicGetReferredOperation();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getExtension().clear();
                this.getExtension().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getOwnedAnnotation().clear();
                this.getOwnedAnnotation().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedComment().clear();
                this.getOwnedComment().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setIsStatic((Boolean)newValue);
                return;
            }
            case 4: {
                this.setName((String)newValue);
                return;
            }
            case 5: {
                this.setIsRequired((Boolean)newValue);
                return;
            }
            case 6: {
                this.setType((Type)newValue);
                return;
            }
            case 7: {
                this.setImplicit((Boolean)newValue);
                return;
            }
            case 8: {
                this.setSource((OCLExpression)newValue);
                return;
            }
            case 9: {
                this.setIsPre((Boolean)newValue);
                return;
            }
            case 10: {
                this.getArgument().clear();
                this.getArgument().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setReferredOperation((Operation)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getExtension().clear();
                return;
            }
            case 1: {
                this.getOwnedAnnotation().clear();
                return;
            }
            case 2: {
                this.getOwnedComment().clear();
                return;
            }
            case 3: {
                this.setIsStatic(false);
                return;
            }
            case 4: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 5: {
                this.setIsRequired(true);
                return;
            }
            case 6: {
                this.setType(null);
                return;
            }
            case 7: {
                this.setImplicit(false);
                return;
            }
            case 8: {
                this.setSource(null);
                return;
            }
            case 9: {
                this.setIsPre(false);
                return;
            }
            case 10: {
                this.getArgument().clear();
                return;
            }
            case 11: {
                this.setReferredOperation(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.extension != null && !this.extension.isEmpty();
            }
            case 1: {
                return this.ownedAnnotation != null && !this.ownedAnnotation.isEmpty();
            }
            case 2: {
                return this.ownedComment != null && !this.ownedComment.isEmpty();
            }
            case 3: {
                return (this.eFlags & 0x100) != 0;
            }
            case 4: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 5: {
                return (this.eFlags & 0x200) == 0;
            }
            case 6: {
                return this.type != null;
            }
            case 7: {
                return (this.eFlags & 0x400) != 0;
            }
            case 8: {
                return this.source != null;
            }
            case 9: {
                return (this.eFlags & 0x800) != 0;
            }
            case 10: {
                return this.argument != null && !this.argument.isEmpty();
            }
            case 11: {
                return this.referredOperation != null;
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
        if (baseClass == ReferringElement.class) {
            switch (baseOperationID) {
                case 0: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.getReferredElement();
            }
            case 3: {
                return this.validateArgumentCount((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 4: {
                return this.validateArgumentTypeIsConformant((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitOperationCallExp(this);
    }

    @Override
    public Element getReferredElement() {
        return this.getReferredOperation();
    }

    @Override
    public boolean validateArgumentTypeIsConformant(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_forAll;
        try {
            boolean forAll;
            Operation operation = this.getReferredOperation();
            if (operation == null) {
                throw new InvalidValueException("Null source for 'pivot::Operation::ownedParameter'", new Object[0]);
            }
            List parameters = operation.getOwnedParameter();
            DomainType selfType_1 = operation.getOwningType();
            DomainEvaluator evaluator = PivotUtil.getEvaluator(this);
            IdResolver idResolver = evaluator.getIdResolver();
            List<OCLExpression> argument = this.getArgument();
            OrderedSetValue BOXED_argument = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_OCLExpression, argument);
            IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate((Object)BOXED_argument);
            IntegerRange RNG = ValuesUtil.createRange((IntegerValue)PivotTables.INT_1, (IntegerValue)size);
            SequenceValue Sequence = ValuesUtil.createSequenceRange((CollectionTypeId)PivotTables.SEQ_PRIMid_Integer, (IntegerRange)RNG);
            Object accumulator = ValuesUtil.TRUE_VALUE;
            Iterator ITERATOR_i = Sequence.iterator();
            while (true) {
                Object CAUGHT_conformsTo;
                if (!ITERATOR_i.hasNext()) {
                    if (accumulator == ValuesUtil.TRUE_VALUE) {
                        forAll = accumulator;
                        break;
                    }
                    throw (InvalidValueException)((Object)accumulator);
                }
                IntegerValue i = (IntegerValue)ITERATOR_i.next();
                try {
                    DomainExpression argument_1 = (DomainExpression)OrderedCollectionAtOperation.INSTANCE.evaluate((Object)BOXED_argument, (Object)i);
                    OrderedSetValue BOXED_parameters = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Parameter, (Iterable)parameters);
                    DomainTypedElement parameter = (DomainTypedElement)OrderedCollectionAtOperation.INSTANCE.evaluate((Object)BOXED_parameters, (Object)i);
                    if (parameter == null) {
                        throw new InvalidValueException("Null source for 'pivot::TypedElement::type'", new Object[0]);
                    }
                    DomainType parameterType = parameter.getType();
                    if (argument_1 == null) {
                        throw new InvalidValueException("Null source for 'pivot::TypedElement::type'", new Object[0]);
                    }
                    DomainType type = argument_1.getType();
                    if (parameterType == null) {
                        throw new InvalidValueException("Null source for 'pivot::Type::specializeIn(pivot::OCLExpression,pivot::Type) : pivot::Type'", new Object[0]);
                    }
                    DomainType specializeIn = parameterType.specializeIn((DomainCallExp)this, (DomainType)((Type)selfType_1));
                    boolean conformsTo = OclTypeConformsToOperation.INSTANCE.evaluate(evaluator, (Object)type, (Object)specializeIn);
                    CAUGHT_conformsTo = conformsTo;
                }
                catch (Exception e) {
                    CAUGHT_conformsTo = ValuesUtil.createInvalidValue((Exception)e);
                }
                if (CAUGHT_conformsTo == ValuesUtil.FALSE_VALUE) {
                    forAll = ValuesUtil.FALSE_VALUE;
                    break;
                }
                if (CAUGHT_conformsTo == ValuesUtil.TRUE_VALUE) continue;
                if (CAUGHT_conformsTo instanceof InvalidValueException) {
                    accumulator = CAUGHT_conformsTo;
                    continue;
                }
                accumulator = new InvalidValueException(EvaluatorMessages.NonBooleanBody, new Object[]{"forAll"});
            }
            CAUGHT_forAll = forAll;
        }
        catch (Exception e) {
            CAUGHT_forAll = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_forAll == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"OperationCallExp", "ArgumentTypeIsConformant", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 56, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateArgumentCount(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_eq;
        DomainEvaluator evaluator = PivotUtil.getEvaluator(this);
        IdResolver idResolver = evaluator.getIdResolver();
        try {
            List<OCLExpression> argument = this.getArgument();
            OrderedSetValue BOXED_argument = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_OCLExpression, argument);
            IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate((Object)BOXED_argument);
            Operation referredOperation = this.getReferredOperation();
            if (referredOperation == null) {
                throw new InvalidValueException("Null source for 'pivot::Operation::ownedParameter'", new Object[0]);
            }
            List ownedParameter = referredOperation.getOwnedParameter();
            OrderedSetValue BOXED_ownedParameter = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Parameter, (Iterable)ownedParameter);
            IntegerValue size_0 = CollectionSizeOperation.INSTANCE.evaluate((Object)BOXED_ownedParameter);
            boolean eq = size.equals(size_0);
            CAUGHT_eq = eq;
        }
        catch (Exception e) {
            CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_eq == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"OperationCallExp", "ArgumentCount", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 55, message, new Object[]{this}));
        }
        return false;
    }
}

