/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.compatibility.UML_4_2;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.IdVisitor;
import org.eclipse.ocl.examples.domain.ids.NsURIPackageId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.types.DomainInvalidTypeImpl;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.library.executor.AbstractIdResolver;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Stereotype;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;
import org.eclipse.ocl.examples.pivot.manager.TupleTypeManager;
import org.eclipse.ocl.examples.pivot.uml.UMLElementExtension;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;

public class PivotIdResolver
extends AbstractIdResolver {
    private static final Logger logger = Logger.getLogger(PivotIdResolver.class);
    @NonNull
    protected final MetaModelManager metaModelManager;

    public PivotIdResolver(@NonNull MetaModelManager metaModelManager) {
        super((DomainStandardLibrary)metaModelManager);
        this.metaModelManager = metaModelManager;
    }

    @NonNull
    public DomainType getDynamicTypeOf(@Nullable Object value) {
        if (value instanceof UMLElementExtension) {
            org.eclipse.uml2.uml.Stereotype umlStereotype = ((UMLElementExtension)((Object)value)).getDynamicStereotype();
            try {
                Stereotype asStereotype = this.metaModelManager.getPivotOf(Stereotype.class, (EObject)umlStereotype);
                return asStereotype != null ? asStereotype : this.metaModelManager.getOclInvalidType();
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        return super.getDynamicTypeOf(value);
    }

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value) {
        if (value instanceof org.eclipse.uml2.uml.Element) {
            try {
                this.metaModelManager.getPivotOf(Element.class, (EObject)((org.eclipse.uml2.uml.Element)value));
            }
            catch (ParserException parserException) {}
        } else if (value instanceof UMLElementExtension) {
            org.eclipse.uml2.uml.Stereotype umlStereotype = ((UMLElementExtension)((Object)value)).getStaticStereotype();
            try {
                Stereotype asStereotype = this.metaModelManager.getPivotOf(Stereotype.class, (EObject)umlStereotype);
                return asStereotype != null ? asStereotype : this.metaModelManager.getOclInvalidType();
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        return super.getStaticTypeOf(value);
    }

    @NonNull
    public TupleType getTupleType(@NonNull TupleTypeId typeId) {
        TupleTypeManager tupleManager = this.metaModelManager.getTupleManager();
        return tupleManager.getTupleType((IdResolver)this, typeId);
    }

    @NonNull
    public DomainType getType(@NonNull EClassifier eClassifier) {
        PackageServer packageServer;
        Type pivotType;
        DomainPackage asMetamodel;
        String typeName;
        EClassifier eType = eClassifier;
        EPackage ePackage = eClassifier.getEPackage();
        if (ePackage == UMLPackage.eINSTANCE) {
            typeName = eClassifier.getName();
            if (typeName != null && (asMetamodel = this.metaModelManager.getASMetamodel()) != null && (pivotType = (packageServer = this.metaModelManager.getPackageServer(asMetamodel)).getMemberType(typeName)) != null) {
                return pivotType;
            }
        } else if (ePackage.eContainer() instanceof EAnnotation && ePackage.eContainer().eContainer() instanceof Profile) {
            Profile umlProfile = (Profile)ePackage.eContainer().eContainer();
            String stereotypeName = UML_4_2.UMLUtil.getOriginalName((ENamedElement)eClassifier);
            org.eclipse.uml2.uml.Stereotype umlStereotype = umlProfile.getOwnedStereotype(stereotypeName);
            try {
                Stereotype stereotype = this.metaModelManager.getPivotOf(Stereotype.class, (EObject)umlStereotype);
                if (stereotype != null) {
                    return stereotype;
                }
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        if (ePackage == PivotPackage.eINSTANCE && (typeName = eClassifier.getName()) != null && (asMetamodel = this.metaModelManager.getASMetamodel()) != null && (pivotType = (packageServer = this.metaModelManager.getPackageServer(asMetamodel)).getMemberType(typeName)) != null) {
            return pivotType;
        }
        try {
            Type pivotType2 = this.metaModelManager.getPivotOf(Type.class, (EObject)eType);
            if (pivotType2 != null) {
                return this.metaModelManager.getPrimaryType(pivotType2);
            }
        }
        catch (ParserException e) {
            logger.error((Object)("Failed to convert '" + eType + "'"), (Throwable)e);
        }
        return new DomainInvalidTypeImpl(this.standardLibrary, "No object created by Ecore2Pivot");
    }

    @NonNull
    public Type getType(@NonNull TypeId typeId, @Nullable Object context) {
        DomainElement type = (DomainElement)typeId.accept((IdVisitor)this);
        if (type instanceof TemplateParameter) {
            type = ((TemplateParameter)type).getParameteredElement();
        }
        assert (type != null);
        return (Type)type;
    }

    @NonNull
    public DomainPackage visitNsURIPackageId(@NonNull NsURIPackageId id) {
        String nsURI = id.getNsURI();
        DomainPackage nsURIPackage = this.metaModelManager.getNsURIPackage(nsURI);
        if (nsURIPackage == null) {
            this.metaModelManager.setAutoLoadASMetamodel(true);
            DomainPackage asMetamodel = this.metaModelManager.getASMetamodel();
            if (asMetamodel != null && "http://www.eclipse.org/ocl/3.1.0/Pivot".equals(nsURI)) {
                return asMetamodel;
            }
            nsURIPackage = this.metaModelManager.getNsURIPackage(nsURI);
            if (nsURIPackage == null) {
                throw new UnsupportedOperationException();
            }
        }
        return nsURIPackage;
    }
}

