/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypeParameters;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.AbstractTypeServer;
import org.eclipse.ocl.examples.pivot.manager.ExtensibleTypeServer;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.Orphanage;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateableTypeServer
extends ExtensibleTypeServer {
    @Nullable
    private Map<DomainTypeParameters, WeakReference<Type>> specializations = null;

    protected TemplateableTypeServer(@NonNull PackageServer packageServer, @NonNull DomainType domainType) {
        super(packageServer, domainType);
    }

    @NonNull
    protected Type createSpecialization(@NonNull DomainTypeParameters templateArguments) {
        Type unspecializedType = this.getPivotType();
        String typeName = unspecializedType.getName();
        TemplateSignature templateSignature = unspecializedType.getOwnedTemplateSignature();
        List<TemplateParameter> templateParameters = templateSignature.getOwnedParameter();
        EClass eClass = unspecializedType.eClass();
        EFactory eFactoryInstance = eClass.getEPackage().getEFactoryInstance();
        Type specializedType = (Type)eFactoryInstance.create(eClass);
        specializedType.setName(typeName);
        TemplateBinding templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
        templateBinding.setSignature(templateSignature);
        HashMap<TemplateParameter, ParameterableElement> allBindings = new HashMap<TemplateParameter, ParameterableElement>();
        int i = 0;
        while (i < templateParameters.size()) {
            DomainElement templateArgument;
            TemplateParameter formalParameter = templateParameters.get(i);
            if (formalParameter != null && (templateArgument = templateArguments.get(i)) instanceof ParameterableElement) {
                ParameterableElement actualType = (ParameterableElement)templateArgument;
                allBindings.put(formalParameter, actualType);
                TemplateParameterSubstitution templateParameterSubstitution = AbstractTypeServer.createTemplateParameterSubstitution(formalParameter, actualType);
                templateBinding.getParameterSubstitution().add(templateParameterSubstitution);
            }
            ++i;
        }
        specializedType.getTemplateBinding().add(templateBinding);
        this.packageManager.resolveSuperClasses(specializedType, unspecializedType, allBindings);
        specializedType.setUnspecializedElement(unspecializedType);
        MetaModelManager metaModelManager = this.packageManager.getMetaModelManager();
        Orphanage orphanage = Orphanage.getOrphanage(metaModelManager.getASResourceSet());
        specializedType.setPackage(orphanage);
        return specializedType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public synchronized Type findSpecializedType(@NonNull DomainTypeParameters templateArguments) {
        TemplateSignature templateSignature = this.getPivotType().getOwnedTemplateSignature();
        List<TemplateParameter> templateParameters = templateSignature.getOwnedParameter();
        int iMax = templateParameters.size();
        if (templateArguments.parametersSize() != iMax) {
            return null;
        }
        Map<DomainTypeParameters, WeakReference<Type>> specializations2 = this.specializations;
        if (specializations2 == null) {
            return null;
        }
        WeakReference<Type> weakReference = specializations2.get(templateArguments);
        if (weakReference == null) {
            return null;
        }
        Type type = (Type)weakReference.get();
        if (type == null) {
            Map<DomainTypeParameters, WeakReference<Type>> map = specializations2;
            synchronized (map) {
                type = (Type)weakReference.get();
                if (type == null) {
                    specializations2.remove(templateArguments);
                }
            }
        }
        return type;
    }

    @NonNull
    public synchronized Type getSpecializedType(@NonNull List<? extends DomainElement> templateArguments) {
        return this.getSpecializedType(new DomainTypeParameters(templateArguments));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public synchronized Type getSpecializedType(@NonNull DomainTypeParameters templateArguments) {
        Object object;
        TemplateSignature templateSignature = this.getPivotType().getOwnedTemplateSignature();
        List<TemplateParameter> templateParameters = templateSignature.getOwnedParameter();
        int iMax = templateParameters.size();
        if (templateArguments.parametersSize() != iMax) {
            throw new IllegalArgumentException("Incompatible template argument count");
        }
        Map<DomainTypeParameters, WeakReference<Type>> specializations2 = this.specializations;
        if (specializations2 == null) {
            object = this;
            synchronized (object) {
                specializations2 = this.specializations;
                if (specializations2 == null) {
                    specializations2 = this.specializations = new HashMap<DomainTypeParameters, WeakReference<Type>>();
                }
            }
        }
        object = specializations2;
        synchronized (object) {
            Type specializedType = null;
            WeakReference<Type> weakReference = specializations2.get(templateArguments);
            if (weakReference != null) {
                specializedType = (Type)weakReference.get();
            }
            if (specializedType == null) {
                specializedType = this.createSpecialization(templateArguments);
                specializations2.put(templateArguments, new WeakReference<Type>(specializedType));
            }
            return specializedType;
        }
    }
}

