/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.values.Unlimited;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.ConstructorExp;
import org.eclipse.ocl.examples.pivot.Detail;
import org.eclipse.ocl.examples.pivot.EnumLiteralExp;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotConstants;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExp;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.AS2Moniker;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AS2MonikerVisitor
extends AbstractExtendingVisitor<Object, AS2Moniker>
implements PivotConstants {
    private static boolean initialized = false;
    @Nullable
    protected final Map<TemplateParameter, ParameterableElement> templateBindings;

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            roleNames.put(PivotPackage.Literals.LOOP_EXP__BODY, "argument");
        }
    }

    public AS2MonikerVisitor(@NonNull AS2Moniker context) {
        super(context);
        this.templateBindings = null;
        if (!initialized) {
            AS2MonikerVisitor.initialize();
        }
    }

    public AS2MonikerVisitor(@NonNull AS2Moniker context, @Nullable Map<TemplateParameter, ParameterableElement> templateBindings) {
        super(context);
        this.templateBindings = templateBindings;
    }

    public void appendExpPrefix(@NonNull NamedElement object) {
        CallExp callExpParent;
        EObject parent = object.eContainer();
        if (parent instanceof CallExp && (callExpParent = (CallExp)parent).isImplicit()) {
            if (callExpParent instanceof IteratorExp) {
                if (callExpParent.getSource() == object) {
                    ((AS2Moniker)this.context).appendElement(((IteratorExp)callExpParent).getBody());
                    ((AS2Moniker)this.context).append("!");
                    ((AS2Moniker)this.context).appendRole(object);
                    ((AS2Moniker)this.context).append("~");
                    return;
                }
                ((AS2Moniker)this.context).appendParent(callExpParent, "!");
                ((AS2Moniker)this.context).appendRole(callExpParent);
                ((AS2Moniker)this.context).append("~");
                return;
            }
            if (callExpParent.getSource() == object) {
                object = callExpParent;
            }
        }
        ((AS2Moniker)this.context).appendParent(object, "!");
        ((AS2Moniker)this.context).appendRole(object);
        ((AS2Moniker)this.context).append("~");
    }

    public String toString() {
        return ((AS2Moniker)this.context).toString();
    }

    @Override
    public Object visitAnnotation(@NonNull Annotation object) {
        ((AS2Moniker)this.context).appendParent(object, "!");
        ((AS2Moniker)this.context).append("'");
        ((AS2Moniker)this.context).append(String.valueOf(object.getName()));
        ((AS2Moniker)this.context).append("'");
        Object container = object.eContainer().eGet(object.eContainingFeature());
        if (container instanceof List) {
            int index = 0;
            for (Object element : (List)container) {
                if (element == object) break;
                if (!(element instanceof Annotation) || !((Annotation)element).getName().equals(object.getName())) continue;
                ++index;
            }
            if (index > 0) {
                ((AS2Moniker)this.context).append(index);
            }
        }
        return true;
    }

    @Override
    public Object visitBooleanLiteralExp(@NonNull BooleanLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append(Boolean.toString(object.isBooleanSymbol()));
        return true;
    }

    @Override
    public Object visitClass(@NonNull Class object) {
        TemplateParameter owningTemplateParameter = object.getOwningTemplateParameter();
        if (owningTemplateParameter != null) {
            ParameterableElement parameterableElement;
            if (this.templateBindings != null && (parameterableElement = this.templateBindings.get(owningTemplateParameter)) != null && parameterableElement != object) {
                ((AS2Moniker)this.context).appendElement(parameterableElement);
                return true;
            }
            TemplateableElement owningTemplateElement = owningTemplateParameter.getSignature().getTemplate();
            if (!((AS2Moniker)this.context).hasEmitted(owningTemplateParameter)) {
                ((AS2Moniker)this.context).appendElement(owningTemplateElement);
                ((AS2Moniker)this.context).append("?");
            }
            ((AS2Moniker)this.context).appendName(object);
        } else if (!object.getTemplateBinding().isEmpty()) {
            Type templateableClass = PivotUtil.getUnspecializedTemplateableElement(object);
            ((AS2Moniker)this.context).appendParent(templateableClass, "!");
            ((AS2Moniker)this.context).appendName(templateableClass);
            ((AS2Moniker)this.context).appendTemplateBindings(object, this.templateBindings);
        } else if (object.eContainer() instanceof TemplateParameterSubstitution) {
            TemplateParameter formal = ((TemplateParameterSubstitution)object.eContainer()).getFormal();
            int index = formal.getSignature().getOwnedParameter().indexOf(formal);
            ((AS2Moniker)this.context).appendParent(object, "!");
            ((AS2Moniker)this.context).append("?" + index);
        } else {
            ((AS2Moniker)this.context).appendParent(object, "!");
            ((AS2Moniker)this.context).appendName(object);
            ((AS2Moniker)this.context).appendTemplateParameters(object);
        }
        if (object instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)object;
            Number lower = collectionType.getLower();
            Number upper = collectionType.getUpper();
            if (lower.longValue() != 0L || !(upper instanceof Unlimited)) {
                ((AS2Moniker)this.context).append("_" + lower);
                if (!(upper instanceof Unlimited)) {
                    ((AS2Moniker)this.context).append("_" + upper);
                }
            }
        }
        return true;
    }

    @Override
    public Object visitCollectionLiteralExp(@NonNull CollectionLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).appendName(object.getType());
        return true;
    }

    @Override
    public Object visitCollectionLiteralPart(@NonNull CollectionLiteralPart object) {
        ((AS2Moniker)this.context).appendParent(object, "@");
        ((AS2Moniker)this.context).appendIndex(object);
        return true;
    }

    @Override
    public Object visitConstraint(@NonNull Constraint object) {
        ((AS2Moniker)this.context).appendParent(object, "!");
        ((AS2Moniker)this.context).append(PivotUtil.getStereotype(object));
        Object container = object.eContainer().eGet(object.eContainingFeature());
        if (container instanceof List) {
            int index = 0;
            String name2 = object.getName();
            for (Object content : (List)container) {
                Constraint sibling;
                if (content == object) break;
                if (!(content instanceof Constraint) || !PivotUtil.getStereotype(sibling = (Constraint)content).equals(PivotUtil.getStereotype(object))) continue;
                String name1 = sibling.getName();
                if (name1 != name2 && (name1 == null || !name1.equals(name2))) break;
                ++index;
            }
            ((AS2Moniker)this.context).append("~");
            if (name2 != null) {
                ((AS2Moniker)this.context).append(name2);
            }
            if (index != 0) {
                ((AS2Moniker)this.context).append("~");
                ((AS2Moniker)this.context).append(index);
            }
        }
        return true;
    }

    @Override
    public String visitConstructorExp(@NonNull ConstructorExp constructorExp) {
        this.appendExpPrefix(constructorExp);
        ((AS2Moniker)this.context).append("tuple");
        return null;
    }

    @Override
    public Object visitDetail(@NonNull Detail object) {
        ((AS2Moniker)this.context).appendParent(object, "/");
        ((AS2Moniker)this.context).append(object.getName());
        return true;
    }

    @Override
    public Object visitEnumLiteralExp(@NonNull EnumLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).appendName(object.getReferredEnumLiteral());
        return true;
    }

    @Override
    public Object visitExpressionInOCL(@NonNull ExpressionInOCL object) {
        if (object.eContainer() != null) {
            ((AS2Moniker)this.context).appendParent(object, "!");
            ((AS2Moniker)this.context).appendRole(object);
        } else {
            ((AS2Moniker)this.context).append("root");
        }
        return true;
    }

    @Override
    public Object visitIfExp(@NonNull IfExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append("if");
        return true;
    }

    @Override
    public Object visitIntegerLiteralExp(@NonNull IntegerLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append(object.getIntegerSymbol().toString());
        return true;
    }

    @Override
    public Object visitInvalidLiteralExp(@NonNull InvalidLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append("invalid");
        return true;
    }

    @Override
    public Object visitLambdaType(@NonNull LambdaType object) {
        ((AS2Moniker)this.context).append(object.getName());
        Map<TemplateParameter, ParameterableElement> bindings = PivotUtil.getAllTemplateParameterSubstitutions(null, object);
        ((AS2Moniker)this.context).appendLambdaType(object.getContextType(), object.getParameterType(), object.getResultType(), bindings);
        return true;
    }

    @Override
    public Object visitLetExp(@NonNull LetExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append("let");
        return true;
    }

    @Override
    public Object visitLoopExp(@NonNull LoopExp object) {
        OCLExpression body;
        this.appendExpPrefix(object);
        if (object.isImplicit() && (body = object.getBody()) instanceof CallExp) {
            Feature referredFeature = PivotUtil.getReferredFeature((CallExp)body);
            ((AS2Moniker)this.context).appendName(referredFeature);
            return true;
        }
        ((AS2Moniker)this.context).appendName(object.getReferredIteration());
        return true;
    }

    @Override
    public Object visitNamedElement(@NonNull NamedElement object) {
        ((AS2Moniker)this.context).appendParent(object, "!");
        ((AS2Moniker)this.context).appendName(object);
        return true;
    }

    @Override
    public Object visitNullLiteralExp(@NonNull NullLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append("null");
        return true;
    }

    @Override
    public Object visitOperation(@NonNull Operation object) {
        TemplateParameter owningTemplateParameter = object.getOwningTemplateParameter();
        if (owningTemplateParameter != null) {
            TemplateableElement owningTemplateElement = owningTemplateParameter.getSignature().getTemplate();
            if (!((AS2Moniker)this.context).hasEmitted(owningTemplateParameter)) {
                ((AS2Moniker)this.context).appendElement(owningTemplateElement);
                ((AS2Moniker)this.context).append("?");
            }
            ((AS2Moniker)this.context).appendName(object);
        } else {
            if (!object.getTemplateBinding().isEmpty()) {
                ((AS2Moniker)this.context).appendParent(object, "!");
                ((AS2Moniker)this.context).appendName(object);
                Map<TemplateParameter, ParameterableElement> bindings = PivotUtil.getAllTemplateParameterSubstitutions(null, object);
                if (this.templateBindings != null && bindings == null) {
                    bindings = this.templateBindings;
                }
                ((AS2Moniker)this.context).appendTemplateBindings(object, bindings);
                ((AS2Moniker)this.context).appendParameters(object, bindings);
                return true;
            }
            ((AS2Moniker)this.context).appendParent(object, "!");
            ((AS2Moniker)this.context).appendName(object);
            ((AS2Moniker)this.context).appendTemplateParameters(object);
            ((AS2Moniker)this.context).appendParameters(object, null);
        }
        return true;
    }

    @Override
    public Object visitOperationCallExp(@NonNull OperationCallExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).appendName(object.getReferredOperation());
        return true;
    }

    @Override
    public Object visitOppositePropertyCallExp(@NonNull OppositePropertyCallExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append("~");
        ((AS2Moniker)this.context).appendName(object.getReferredProperty());
        return true;
    }

    @Override
    public Object visitPackage(@NonNull Package object) {
        ((AS2Moniker)this.context).append(PivotUtil.getNsURI(object));
        return true;
    }

    @Override
    public Object visitPrecedence(@NonNull Precedence object) {
        ((AS2Moniker)this.context).appendParent(object, "~");
        ((AS2Moniker)this.context).appendName(object);
        return true;
    }

    @Override
    public Object visitPrimitiveType(@NonNull PrimitiveType object) {
        ((AS2Moniker)this.context).appendName(object);
        return true;
    }

    @Override
    public Object visitPropertyCallExp(@NonNull PropertyCallExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).appendName(object.getReferredProperty());
        return true;
    }

    @Override
    public Object visitRealLiteralExp(@NonNull RealLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append(object.getRealSymbol().toString());
        return true;
    }

    @Override
    public Object visitRoot(@NonNull Root object) {
        ((AS2Moniker)this.context).append("ROOT");
        return true;
    }

    @Override
    public Object visitStringLiteralExp(@NonNull StringLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append("string");
        return true;
    }

    @Override
    public Object visitTemplateBinding(@NonNull TemplateBinding object) {
        TemplateSignature signature = object.getSignature();
        if (signature != null) {
            ((AS2Moniker)this.context).appendElement(signature.getTemplate());
        }
        ((AS2Moniker)this.context).append("/");
        return true;
    }

    @Override
    public Object visitTemplateParameter(@NonNull TemplateParameter object) {
        TemplateableElement owningTemplateElement = object.getSignature().getTemplate();
        ((AS2Moniker)this.context).appendElement(owningTemplateElement);
        ((AS2Moniker)this.context).append("?");
        ((AS2Moniker)this.context).appendName(object.getParameteredElement());
        return true;
    }

    @Override
    public Object visitTemplateParameterSubstitution(@NonNull TemplateParameterSubstitution object) {
        ((AS2Moniker)this.context).appendElement(object.getTemplateBinding());
        ((AS2Moniker)this.context).appendName(object.getFormal().getParameteredElement());
        return true;
    }

    @Override
    public Object visitTemplateSignature(@NonNull TemplateSignature object) {
        ((AS2Moniker)this.context).appendParent(object, "!");
        return true;
    }

    @Override
    public Object visitTupleLiteralExp(@NonNull TupleLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append("tuple");
        return true;
    }

    @Override
    public Object visitTupleType(@NonNull TupleType object) {
        List<Property> ownedAttributes = object.getOwnedAttribute();
        if (ownedAttributes.isEmpty()) {
            super.visitTupleType(object);
        } else {
            ((AS2Moniker)this.context).appendName(object);
            ((AS2Moniker)this.context).appendTupleType(ownedAttributes);
        }
        return true;
    }

    @Override
    public Object visitTypeExp(@NonNull TypeExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).appendName(object.getReferredType());
        return true;
    }

    @Override
    public Object visitUnlimitedNaturalLiteralExp(@NonNull UnlimitedNaturalLiteralExp object) {
        this.appendExpPrefix(object);
        Number unlimitedNaturalSymbol = object.getUnlimitedNaturalSymbol();
        ((AS2Moniker)this.context).append(unlimitedNaturalSymbol.toString());
        return true;
    }

    @Override
    public Object visitVariable(@NonNull Variable object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).appendName(object);
        return true;
    }

    @Override
    public Object visitVariableExp(@NonNull VariableExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).appendName(object.getReferredVariable());
        return true;
    }

    @Override
    public Object visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for " + this.getClass().getSimpleName());
    }
}

