/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.Orphanage;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.AS2Moniker;
import org.eclipse.ocl.examples.pivot.utilities.ASSaverLocateVisitor;
import org.eclipse.ocl.examples.pivot.utilities.ASSaverNormalizeVisitor;
import org.eclipse.ocl.examples.pivot.utilities.ASSaverResolveVisitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASSaver {
    @NonNull
    protected final Resource resource;
    private Map<String, Operation> operations = new HashMap<String, Operation>();
    @NonNull
    private List<Element> specializingElements = new ArrayList<Element>();
    private Package orphanage = null;
    @NonNull
    private Map<Type, Type> specializations = new HashMap<Type, Type>();
    private Type orphanageClass = null;

    public ASSaver(@NonNull Resource resource) {
        this.resource = resource;
    }

    public void addSpecializingElement(@NonNull Element object) {
        this.specializingElements.add(object);
    }

    public boolean addSpecializingElement(@NonNull Element object, @NonNull Operation referredOperation) {
        if (!this.isOrphanOperation(referredOperation)) {
            return false;
        }
        this.specializingElements.add(object);
        return true;
    }

    public boolean addSpecializingElement(@NonNull Element object, @NonNull Type referredType) {
        if (PivotUtil.isLibraryType(referredType)) {
            return false;
        }
        this.specializingElements.add(object);
        return true;
    }

    @NonNull
    protected ASSaverLocateVisitor getLocateVisitor(@NonNull EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource instanceof ASResource) {
            return ((ASResource)resource).getASResourceFactory().createASSaverLocateVisitor(this);
        }
        if (resource == null) {
            throw new IllegalStateException("Cannot locate " + ASSaverLocateVisitor.class.getName() + " for resource-less " + eObject.eClass().getName());
        }
        throw new IllegalStateException("Cannot locate " + ASSaverLocateVisitor.class.getName() + " for non-OCL " + resource.getClass().getName());
    }

    @NonNull
    protected ASSaverNormalizeVisitor getNormalizeVisitor(@NonNull EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource instanceof ASResource) {
            return ((ASResource)resource).getASResourceFactory().createASSaverNormalizeVisitor(this);
        }
        if (resource == null) {
            throw new IllegalStateException("Cannot locate " + ASSaverLocateVisitor.class.getName() + " for resource-less " + eObject.eClass().getName());
        }
        throw new IllegalStateException("Cannot locate " + ASSaverLocateVisitor.class.getName() + " for non-OCL " + resource.getClass().getName());
    }

    @NonNull
    protected Type getOrphanClass(@NonNull Package orphanagePackage) {
        Type orphanageClass2 = this.orphanageClass;
        if (orphanageClass2 == null) {
            this.orphanageClass = orphanageClass2 = PivotFactory.eINSTANCE.createAnyType();
            orphanageClass2.setName("$$");
            orphanagePackage.getOwnedType().add(orphanageClass2);
        }
        return orphanageClass2;
    }

    @NonNull
    protected Package getOrphanPackage(@NonNull Resource resource) {
        Package orphanage2 = this.orphanage;
        if (orphanage2 == null) {
            this.orphanage = orphanage2 = PivotFactory.eINSTANCE.createPackage();
            orphanage2.setName("$$");
            orphanage2.setNsPrefix("orphanage");
            orphanage2.setNsURI("http://www.eclipse.org/ocl/3.1.0/orphanage");
            EList contents = resource.getContents();
            if (contents.size() > 0 && contents.get(0) instanceof Root) {
                ((Root)contents.get(0)).getNestedPackage().add(orphanage2);
            } else {
                contents.add((Object)orphanage2);
            }
        }
        return orphanage2;
    }

    @NonNull
    protected ASSaverResolveVisitor getResolveVisitor(@NonNull EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource instanceof ASResource) {
            return ((ASResource)resource).getASResourceFactory().createASSaverResolveVisitor(this);
        }
        if (resource == null) {
            throw new IllegalStateException("Cannot locate " + ASSaverResolveVisitor.class.getName() + " for resource-less " + eObject.eClass().getName());
        }
        throw new IllegalStateException("Cannot locate " + ASSaverResolveVisitor.class.getName() + " for non-OCL " + resource.getClass().getName());
    }

    protected boolean isOrphanOperation(@NonNull Operation operation) {
        return operation.getTemplateBinding().size() > 0;
    }

    public void localizeSpecializations() {
        this.locateSpecializations((List<? extends EObject>)this.resource.getContents());
        if (this.specializingElements.size() > 0) {
            this.loadOrphanage(this.resource);
            int i = 0;
            while (i < this.specializingElements.size()) {
                Element element = this.specializingElements.get(i);
                if (element != null) {
                    ASSaverResolveVisitor resolveVisitor = this.getResolveVisitor(element);
                    resolveVisitor.safeVisit(element);
                }
                ++i;
            }
        }
    }

    protected void loadOrphanage(@NonNull Resource resource) {
        Root root = null;
        Package orphanage2 = this.orphanage;
        if (orphanage2 == null) {
            for (EObject eRoot : resource.getContents()) {
                if (eRoot instanceof Root) {
                    if (root == null) {
                        root = (Root)eRoot;
                    }
                    if (orphanage2 == null) {
                        for (Package asPackage : ((Root)eRoot).getNestedPackage()) {
                            if (!Orphanage.isTypeOrphanage(asPackage)) continue;
                            this.orphanage = orphanage2 = asPackage;
                            for (Type asType : orphanage2.getOwnedType()) {
                                if ("$$".equals(asType.getName())) {
                                    this.orphanageClass = asType;
                                    continue;
                                }
                                this.specializations.put(asType, asType);
                            }
                        }
                    }
                }
                if (!(eRoot instanceof Package) || !Orphanage.isTypeOrphanage((Package)eRoot)) continue;
                this.orphanage = orphanage2 = (Package)eRoot;
                for (Type asType : orphanage2.getOwnedType()) {
                    if ("$$".equals(asType.getName())) {
                        this.orphanageClass = asType;
                        continue;
                    }
                    this.specializations.put(asType, asType);
                }
            }
        }
    }

    protected void locateSpecializations(List<? extends EObject> eObjects) {
        for (EObject eObject : eObjects) {
            if (eObject instanceof Visitable) {
                ASSaverLocateVisitor locateVisitor = this.getLocateVisitor(eObject);
                locateVisitor.safeVisit((Visitable)eObject);
            }
            this.locateSpecializations((List<? extends EObject>)eObject.eContents());
        }
    }

    public void normalizeContents() {
        TreeIterator tit = this.resource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            ASSaverNormalizeVisitor normalizeVisitor = this.getNormalizeVisitor(eObject);
            if (!(eObject instanceof Visitable)) continue;
            normalizeVisitor.safeVisit((Visitable)eObject);
        }
    }

    @NonNull
    public <T extends Operation> T resolveOperation(@NonNull T referredOperation) {
        if (!this.isOrphanOperation(referredOperation)) {
            return referredOperation;
        }
        String moniker = AS2Moniker.toString(referredOperation);
        Operation operation = this.operations.get(moniker);
        if (operation != null) {
            Operation castOperation = operation;
            return (T)castOperation;
        }
        Operation resolvedOperation = (Operation)DomainUtil.nonNullEMF((Object)((Operation)EcoreUtil.copy(referredOperation)));
        if (this.orphanageClass == null) {
            Package orphanage2 = this.orphanage;
            if (orphanage2 == null) {
                orphanage2 = this.getOrphanPackage(this.resource);
            }
            this.orphanageClass = this.getOrphanClass(orphanage2);
        }
        this.orphanageClass.getOwnedOperation().add(resolvedOperation);
        this.operations.put(moniker, resolvedOperation);
        String newMoniker = AS2Moniker.toString(resolvedOperation);
        assert (moniker.equals(newMoniker));
        this.locateSpecializations(Collections.singletonList(resolvedOperation));
        return (T)resolvedOperation;
    }

    @NonNull
    public <T extends Type> T resolveType(@NonNull T referredType) {
        if (PivotUtil.isLibraryType(referredType)) {
            return referredType;
        }
        Type resolvedType = this.specializations.get(referredType);
        if (resolvedType == null) {
            resolvedType = (Type)DomainUtil.nonNullEMF((Object)((Type)EcoreUtil.copy(referredType)));
            this.specializations.put(referredType, resolvedType);
            this.specializations.put(resolvedType, resolvedType);
            EObject eContainer = resolvedType.eContainer();
            if (eContainer == null) {
                Package orphanage2 = this.orphanage;
                if (orphanage2 == null) {
                    orphanage2 = this.getOrphanPackage(this.resource);
                }
                this.orphanage.getOwnedType().add(resolvedType);
            }
        }
        this.locateSpecializations(Collections.singletonList(resolvedType));
        return (T)resolvedType;
    }
}

