/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.ui.commands;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.impl.EValidatorRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.uml.UMLOCLEValidator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;

public class ValidateCommand
extends ValidateAction {
    private static Boolean diagnosticianHasDoValidate = null;

    protected static boolean diagnosticianHasDoValidate() {
        Method[] methodArray = Diagnostician.class.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if ("doValidate".equals(method.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected Diagnostician createDiagnostician(AdapterFactory adapterFactory, IProgressMonitor progressMonitor) {
        ResourceSet resourceSet = this.domain.getResourceSet();
        EValidatorRegistryImpl registry = new EValidatorRegistryImpl();
        registry.put((Object)UMLPackage.eINSTANCE, (Object)UMLOCLEValidator.NO_NEW_LINES);
        if (diagnosticianHasDoValidate == null) {
            diagnosticianHasDoValidate = false;
            Method[] methodArray = Diagnostician.class.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if ("doValidate".equals(method.getName())) {
                    diagnosticianHasDoValidate = true;
                }
                ++n2;
            }
        }
        if (diagnosticianHasDoValidate.booleanValue()) {
            return new Diagnostician_2_9((EValidator.Registry)registry, resourceSet, adapterFactory, progressMonitor);
        }
        return new Diagnostician_2_8((EValidator.Registry)registry, resourceSet, adapterFactory);
    }

    protected void fireHandlerChanged(HandlerEvent handlerEvent) {
        if (handlerEvent == null) {
            throw new NullPointerException();
        }
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IHandlerListener listener = (IHandlerListener)listeners[i];
            listener.handlerChanged(handlerEvent);
            ++i;
        }
    }

    protected void handleDiagnostic(Diagnostic diagnostic) {
        List data;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        int severity = diagnostic.getSeverity();
        String title = null;
        String message = null;
        if (severity == 4 || severity == 2) {
            title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_title");
            message = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_message");
        } else {
            title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationResults_title");
            message = EMFEditUIPlugin.INSTANCE.getString(severity == 0 ? "_UI_ValidationOK_message" : "_UI_ValidationResults_message");
        }
        int result = 0;
        if (diagnostic.getSeverity() == 0) {
            MessageDialog.openInformation((Shell)activeWorkbenchWindow.getShell(), (String)title, (String)message);
            result = 1;
        } else {
            result = DiagnosticDialog.open((Shell)activeWorkbenchWindow.getShell(), (String)title, (String)message, (Diagnostic)diagnostic);
        }
        ResourceSet resourceSet = this.domain.getResourceSet();
        Resource resource = null;
        if (this.eclipseResourcesUtil != null) {
            Object object;
            data = diagnostic.getData();
            if (data != null && data.size() >= 1 && (object = data.get(0)) instanceof EObject) {
                resource = ((EObject)object).eResource();
            }
            if (resource == null) {
                resource = (Resource)resourceSet.getResources().get(0);
            }
        }
        if (resource != null) {
            this.eclipseResourcesUtil.deleteMarkers(resource);
        }
        if (result == 0) {
            if (!diagnostic.getChildren().isEmpty() && !(data = ((Diagnostic)diagnostic.getChildren().get(0)).getData()).isEmpty() && data.get(0) instanceof EObject) {
                Viewer viewer;
                IWorkbenchPart part = activeWorkbenchWindow.getActivePage().getActivePart();
                if (part instanceof ISetSelectionTarget) {
                    ((ISetSelectionTarget)part).selectReveal((ISelection)new StructuredSelection(data.get(0)));
                } else if (part instanceof IViewerProvider && (viewer = ((IViewerProvider)part).getViewer()) != null) {
                    viewer.setSelection((ISelection)new StructuredSelection(data.get(0)), true);
                }
            }
            if (resource != null) {
                for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                    this.eclipseResourcesUtil.createMarkers(resource, childDiagnostic);
                }
            }
        } else {
            resource = null;
        }
        if (resource == null) {
            BasicDiagnostic resourceSetDiagnostic = new BasicDiagnostic("org.eclipse.emf.ecore", 0, null, new Object[]{resourceSet});
            LinkedHashMap<Resource, BasicDiagnostic> resourceDiagnostics = new LinkedHashMap<Resource, BasicDiagnostic>();
            for (Resource r : resourceSet.getResources()) {
                BasicDiagnostic resourceDiagnostic = new BasicDiagnostic("org.eclipse.emf.ecore", 0, null, new Object[]{r});
                resourceDiagnostics.put(r, resourceDiagnostic);
            }
            if (result == 0) {
                for (Diagnostic child : diagnostic.getChildren()) {
                    BasicDiagnostic resourceDiagnostic;
                    Object object;
                    List data2 = child.getData();
                    if (data2.isEmpty() || !((object = data2.get(0)) instanceof EObject) || (resourceDiagnostic = (BasicDiagnostic)resourceDiagnostics.get(((EObject)object).eResource())) == null) continue;
                    resourceDiagnostic.add(child);
                }
            }
            for (Diagnostic resourceDiagnostic : resourceDiagnostics.values()) {
                resourceSetDiagnostic.add(resourceDiagnostic);
            }
            if (diagnosticianHasDoValidate.booleanValue()) {
                Diagnostician_2_9.update(resourceSet, resourceSetDiagnostic);
            }
        }
    }

    protected boolean hasListeners() {
        return this.isListenerAttached();
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        Object object = workbenchPart.getAdapter(EditingDomain.class);
        if (object instanceof EditingDomain) {
            this.domain = (EditingDomain)object;
            return;
        }
        object = workbenchPart.getAdapter(IEditingDomainProvider.class);
        if (object instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)object).getEditingDomain();
            return;
        }
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this.selectedObjects = new ArrayList();
        Iterator objects = selection.iterator();
        while (objects.hasNext()) {
            Object object = AdapterFactoryEditingDomain.unwrap(objects.next());
            if (object instanceof IAdaptable) {
                object = ((IAdaptable)object).getAdapter(EObject.class);
            }
            if (object instanceof EObject) {
                this.selectedObjects.add((EObject)object);
                continue;
            }
            if (object instanceof Resource) {
                this.selectedObjects.addAll(((Resource)object).getContents());
                continue;
            }
            return false;
        }
        this.selectedObjects = EcoreUtil.filterDescendants((Collection)this.selectedObjects);
        return !this.selectedObjects.isEmpty();
    }

    protected static final class Diagnostician_2_8
    extends PivotDiagnostician {
        protected Diagnostician_2_8(@NonNull EValidator.Registry eValidatorRegistry, ResourceSet resourceSet, AdapterFactory adapterFactory) {
            super(eValidatorRegistry, resourceSet, adapterFactory);
        }

        public String getObjectLabel(EObject eObject) {
            IItemLabelProvider itemLabelProvider;
            if (this.adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                return itemLabelProvider.getText((Object)eObject);
            }
            return super.getObjectLabel(eObject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Diagnostician_2_9
    extends PivotDiagnostician {
        private final ResourceSet resourceSet;
        private final IProgressMonitor progressMonitor;

        public static void update(ResourceSet resourceSet, BasicDiagnostic resourceSetDiagnostic) {
            DiagnosticDecorator.DiagnosticAdapter.update((Notifier)resourceSet, (Diagnostic)resourceSetDiagnostic);
        }

        protected Diagnostician_2_9(@NonNull EValidator.Registry eValidatorRegistry, ResourceSet resourceSet, AdapterFactory adapterFactory, IProgressMonitor progressMonitor) {
            super(eValidatorRegistry, resourceSet, adapterFactory);
            this.resourceSet = resourceSet;
            this.progressMonitor = progressMonitor;
        }

        public String getObjectLabel(EObject eObject) {
            IItemLabelProvider itemLabelProvider;
            if (this.adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                return itemLabelProvider.getText((Object)eObject);
            }
            return super.getObjectLabel(eObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doValidate(EValidator eValidator, EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
            this.progressMonitor.worked(1);
            ResourceSet resourceSet = this.resourceSet;
            synchronized (resourceSet) {
                return super.doValidate(eValidator, eClass, eObject, diagnostics, context);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PivotDiagnostician
    extends Diagnostician {
        protected final AdapterFactory adapterFactory;

        protected PivotDiagnostician(@NonNull EValidator.Registry eValidatorRegistry, ResourceSet resourceSet, AdapterFactory adapterFactory) {
            super(eValidatorRegistry);
            this.adapterFactory = adapterFactory;
            if (resourceSet != null) {
                OCLDelegateDomain.initializePivotOnlyDiagnosticianResourceSet((ResourceSet)resourceSet);
            }
        }

        public Map<Object, Object> createDefaultContext() {
            Map context = super.createDefaultContext();
            if (context != null) {
                OCLDelegateDomain.initializePivotOnlyDiagnosticianContext((Map)context);
            }
            return context;
        }

        public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
            EObject eContainerContainer;
            EObject eContainer;
            EPackage ePackage;
            if (eClass != null && (ePackage = eClass.getEPackage()) != null && (eContainer = ePackage.eContainer()) instanceof EAnnotation && (eContainerContainer = eContainer.eContainer()) instanceof Profile) {
                return true;
            }
            return super.validate(eClass, eObject, diagnostics, context);
        }
    }
}

