/*******************************************************************************
 * Copyright (c) 2014 E.D.Willink and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *******************************************************************************/
/*
* generated by Xtext
*/
package org.eclipse.ocl.examples.xtext.completeocl.services;

import com.google.inject.Singleton;
import com.google.inject.Inject;

import java.util.List;

import org.eclipse.xtext.*;
import org.eclipse.xtext.service.GrammarProvider;
import org.eclipse.xtext.service.AbstractElementFinder.*;

import org.eclipse.ocl.examples.xtext.essentialocl.services.EssentialOCLGrammarAccess;

@Singleton
public class CompleteOCLGrammarAccess extends AbstractGrammarElementFinder {
	
	
	public class CompleteOCLDocumentCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "CompleteOCLDocumentCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Alternatives cAlternatives_0 = (Alternatives)cGroup.eContents().get(0);
		private final Assignment cOwnedImportAssignment_0_0 = (Assignment)cAlternatives_0.eContents().get(0);
		private final RuleCall cOwnedImportImportCSParserRuleCall_0_0_0 = (RuleCall)cOwnedImportAssignment_0_0.eContents().get(0);
		private final Assignment cOwnedIncludeAssignment_0_1 = (Assignment)cAlternatives_0.eContents().get(1);
		private final RuleCall cOwnedIncludeIncludeCSParserRuleCall_0_1_0 = (RuleCall)cOwnedIncludeAssignment_0_1.eContents().get(0);
		private final Assignment cOwnedLibraryAssignment_0_2 = (Assignment)cAlternatives_0.eContents().get(2);
		private final RuleCall cOwnedLibraryLibraryCSParserRuleCall_0_2_0 = (RuleCall)cOwnedLibraryAssignment_0_2.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Assignment cPackagesAssignment_1_0 = (Assignment)cAlternatives_1.eContents().get(0);
		private final RuleCall cPackagesPackageDeclarationCSParserRuleCall_1_0_0 = (RuleCall)cPackagesAssignment_1_0.eContents().get(0);
		private final Assignment cContextsAssignment_1_1 = (Assignment)cAlternatives_1.eContents().get(1);
		private final RuleCall cContextsContextDeclCSParserRuleCall_1_1_0 = (RuleCall)cContextsAssignment_1_1.eContents().get(0);
		
		////generate completeOCL "http://www.eclipse.org/ocl/examples/xtext/completeocl/CompleteOCL"
		// CompleteOCLDocumentCS:
		//	(ownedImport+=ImportCS | ownedInclude+=IncludeCS | ownedLibrary+=LibraryCS)* (packages+=PackageDeclarationCS |
		//	contexts+=ContextDeclCS)*;
		public ParserRule getRule() { return rule; }

		//(ownedImport+=ImportCS | ownedInclude+=IncludeCS | ownedLibrary+=LibraryCS)* (packages+=PackageDeclarationCS |
		//contexts+=ContextDeclCS)*
		public Group getGroup() { return cGroup; }

		//(ownedImport+=ImportCS | ownedInclude+=IncludeCS | ownedLibrary+=LibraryCS)*
		public Alternatives getAlternatives_0() { return cAlternatives_0; }

		//ownedImport+=ImportCS
		public Assignment getOwnedImportAssignment_0_0() { return cOwnedImportAssignment_0_0; }

		//ImportCS
		public RuleCall getOwnedImportImportCSParserRuleCall_0_0_0() { return cOwnedImportImportCSParserRuleCall_0_0_0; }

		//ownedInclude+=IncludeCS
		public Assignment getOwnedIncludeAssignment_0_1() { return cOwnedIncludeAssignment_0_1; }

		//IncludeCS
		public RuleCall getOwnedIncludeIncludeCSParserRuleCall_0_1_0() { return cOwnedIncludeIncludeCSParserRuleCall_0_1_0; }

		//ownedLibrary+=LibraryCS
		public Assignment getOwnedLibraryAssignment_0_2() { return cOwnedLibraryAssignment_0_2; }

		//LibraryCS
		public RuleCall getOwnedLibraryLibraryCSParserRuleCall_0_2_0() { return cOwnedLibraryLibraryCSParserRuleCall_0_2_0; }

		//(packages+=PackageDeclarationCS | contexts+=ContextDeclCS)*
		public Alternatives getAlternatives_1() { return cAlternatives_1; }

		//packages+=PackageDeclarationCS
		public Assignment getPackagesAssignment_1_0() { return cPackagesAssignment_1_0; }

		//PackageDeclarationCS
		public RuleCall getPackagesPackageDeclarationCSParserRuleCall_1_0_0() { return cPackagesPackageDeclarationCSParserRuleCall_1_0_0; }

		//contexts+=ContextDeclCS
		public Assignment getContextsAssignment_1_1() { return cContextsAssignment_1_1; }

		//ContextDeclCS
		public RuleCall getContextsContextDeclCSParserRuleCall_1_1_0() { return cContextsContextDeclCSParserRuleCall_1_1_0; }
	}

	public class CompleteOCLNavigationOperatorCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "CompleteOCLNavigationOperatorCS");
		private final Assignment cNameAssignment = (Assignment)rule.eContents().get(1);
		private final Alternatives cNameAlternatives_0 = (Alternatives)cNameAssignment.eContents().get(0);
		private final Keyword cNameCircumflexAccentKeyword_0_0 = (Keyword)cNameAlternatives_0.eContents().get(0);
		private final Keyword cNameCircumflexAccentCircumflexAccentKeyword_0_1 = (Keyword)cNameAlternatives_0.eContents().get(1);
		
		//CompleteOCLNavigationOperatorCS returns essentialocl::NavigationOperatorCS:
		//	name=("^" | "^^");
		public ParserRule getRule() { return rule; }

		//name=("^" | "^^")
		public Assignment getNameAssignment() { return cNameAssignment; }

		//"^" | "^^"
		public Alternatives getNameAlternatives_0() { return cNameAlternatives_0; }

		//"^"
		public Keyword getNameCircumflexAccentKeyword_0_0() { return cNameCircumflexAccentKeyword_0_0; }

		//"^^"
		public Keyword getNameCircumflexAccentCircumflexAccentKeyword_0_1() { return cNameCircumflexAccentCircumflexAccentKeyword_0_1; }
	}

	public class NavigationOperatorCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "NavigationOperatorCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cEssentialOCLNavigationOperatorCSParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cCompleteOCLNavigationOperatorCSParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//NavigationOperatorCS returns essentialocl::NavigationOperatorCS:
		//	EssentialOCLNavigationOperatorCS | CompleteOCLNavigationOperatorCS;
		public ParserRule getRule() { return rule; }

		//EssentialOCLNavigationOperatorCS | CompleteOCLNavigationOperatorCS
		public Alternatives getAlternatives() { return cAlternatives; }

		//EssentialOCLNavigationOperatorCS
		public RuleCall getEssentialOCLNavigationOperatorCSParserRuleCall_0() { return cEssentialOCLNavigationOperatorCSParserRuleCall_0; }

		//CompleteOCLNavigationOperatorCS
		public RuleCall getCompleteOCLNavigationOperatorCSParserRuleCall_1() { return cCompleteOCLNavigationOperatorCSParserRuleCall_1; }
	}

	public class UnrestrictedNameElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "UnrestrictedName");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cEssentialOCLUnrestrictedNameParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final Keyword cDeriveKeyword_1 = (Keyword)cAlternatives.eContents().get(1);
		private final Keyword cImportKeyword_2 = (Keyword)cAlternatives.eContents().get(2);
		private final Keyword cIncludeKeyword_3 = (Keyword)cAlternatives.eContents().get(3);
		private final Keyword cInitKeyword_4 = (Keyword)cAlternatives.eContents().get(4);
		private final Keyword cLibraryKeyword_5 = (Keyword)cAlternatives.eContents().get(5);
		
		////|	'package'
		// //|	'post'
		// //|	'pre'
		// //|	'static'
		// UnrestrictedName returns ecore::EString:
		//	EssentialOCLUnrestrictedName //| 'body'
		// //| 'context'
		// //| 'def'
		// //|	'endpackage'
		// //| 'inv'
		// | "derive" | "import"
		//	| "include" | "init" | "library";
		public ParserRule getRule() { return rule; }

		//EssentialOCLUnrestrictedName //| 'body'
		// //| 'context'
		// //| 'def'
		// //|	'endpackage'
		// //| 'inv'
		// | "derive" | "import" |
		//"include" | "init" | "library"
		public Alternatives getAlternatives() { return cAlternatives; }

		//EssentialOCLUnrestrictedName
		public RuleCall getEssentialOCLUnrestrictedNameParserRuleCall_0() { return cEssentialOCLUnrestrictedNameParserRuleCall_0; }

		//"derive"
		public Keyword getDeriveKeyword_1() { return cDeriveKeyword_1; }

		//"import"
		public Keyword getImportKeyword_2() { return cImportKeyword_2; }

		//"include"
		public Keyword getIncludeKeyword_3() { return cIncludeKeyword_3; }

		//"init"
		public Keyword getInitKeyword_4() { return cInitKeyword_4; }

		//"library"
		public Keyword getLibraryKeyword_5() { return cLibraryKeyword_5; }
	}

	public class PrimitiveTypeIdentifierElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "PrimitiveTypeIdentifier");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Keyword cBooleanKeyword_0 = (Keyword)cAlternatives.eContents().get(0);
		private final Keyword cIntegerKeyword_1 = (Keyword)cAlternatives.eContents().get(1);
		private final Keyword cRealKeyword_2 = (Keyword)cAlternatives.eContents().get(2);
		private final Keyword cStringKeyword_3 = (Keyword)cAlternatives.eContents().get(3);
		private final Keyword cUnlimitedNaturalKeyword_4 = (Keyword)cAlternatives.eContents().get(4);
		private final Keyword cOclAnyKeyword_5 = (Keyword)cAlternatives.eContents().get(5);
		private final Keyword cOclInvalidKeyword_6 = (Keyword)cAlternatives.eContents().get(6);
		private final Keyword cOclMessageKeyword_7 = (Keyword)cAlternatives.eContents().get(7);
		private final Keyword cOclStateKeyword_8 = (Keyword)cAlternatives.eContents().get(8);
		private final Keyword cOclVoidKeyword_9 = (Keyword)cAlternatives.eContents().get(9);
		
		//PrimitiveTypeIdentifier:
		//	"Boolean" | "Integer" | "Real" | "String" | "UnlimitedNatural" | "OclAny" | "OclInvalid" | "OclMessage" | "OclState"
		//	| "OclVoid";
		public ParserRule getRule() { return rule; }

		//"Boolean" | "Integer" | "Real" | "String" | "UnlimitedNatural" | "OclAny" | "OclInvalid" | "OclMessage" | "OclState" |
		//"OclVoid"
		public Alternatives getAlternatives() { return cAlternatives; }

		//"Boolean"
		public Keyword getBooleanKeyword_0() { return cBooleanKeyword_0; }

		//"Integer"
		public Keyword getIntegerKeyword_1() { return cIntegerKeyword_1; }

		//"Real"
		public Keyword getRealKeyword_2() { return cRealKeyword_2; }

		//"String"
		public Keyword getStringKeyword_3() { return cStringKeyword_3; }

		//"UnlimitedNatural"
		public Keyword getUnlimitedNaturalKeyword_4() { return cUnlimitedNaturalKeyword_4; }

		//"OclAny"
		public Keyword getOclAnyKeyword_5() { return cOclAnyKeyword_5; }

		//"OclInvalid"
		public Keyword getOclInvalidKeyword_6() { return cOclInvalidKeyword_6; }

		//"OclMessage"
		public Keyword getOclMessageKeyword_7() { return cOclMessageKeyword_7; }

		//"OclState"
		public Keyword getOclStateKeyword_8() { return cOclStateKeyword_8; }

		//"OclVoid"
		public Keyword getOclVoidKeyword_9() { return cOclVoidKeyword_9; }
	}

	public class ClassifierContextDeclCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "ClassifierContextDeclCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cContextKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cSelfNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cSelfNameUnrestrictedNameParserRuleCall_1_0 = (RuleCall)cSelfNameAssignment_1.eContents().get(0);
		private final Assignment cPathNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cPathNamePathNameCSParserRuleCall_2_0 = (RuleCall)cPathNameAssignment_2.eContents().get(0);
		private final Alternatives cAlternatives_3 = (Alternatives)cGroup.eContents().get(3);
		private final Group cGroup_3_0 = (Group)cAlternatives_3.eContents().get(0);
		private final Keyword cInvKeyword_3_0_0 = (Keyword)cGroup_3_0.eContents().get(0);
		private final Assignment cInvariantsAssignment_3_0_1 = (Assignment)cGroup_3_0.eContents().get(1);
		private final RuleCall cInvariantsConstraintCSParserRuleCall_3_0_1_0 = (RuleCall)cInvariantsAssignment_3_0_1.eContents().get(0);
		private final Assignment cDefinitionsAssignment_3_1 = (Assignment)cAlternatives_3.eContents().get(1);
		private final RuleCall cDefinitionsDefCSParserRuleCall_3_1_0 = (RuleCall)cDefinitionsAssignment_3_1.eContents().get(0);
		
		//ClassifierContextDeclCS:
		//	"context" selfName=UnrestrictedName? pathName=PathNameCS ("inv" invariants+=ConstraintCS | definitions+=DefCS)+;
		public ParserRule getRule() { return rule; }

		//"context" selfName=UnrestrictedName? pathName=PathNameCS ("inv" invariants+=ConstraintCS | definitions+=DefCS)+
		public Group getGroup() { return cGroup; }

		//"context"
		public Keyword getContextKeyword_0() { return cContextKeyword_0; }

		//selfName=UnrestrictedName?
		public Assignment getSelfNameAssignment_1() { return cSelfNameAssignment_1; }

		//UnrestrictedName
		public RuleCall getSelfNameUnrestrictedNameParserRuleCall_1_0() { return cSelfNameUnrestrictedNameParserRuleCall_1_0; }

		//pathName=PathNameCS
		public Assignment getPathNameAssignment_2() { return cPathNameAssignment_2; }

		//PathNameCS
		public RuleCall getPathNamePathNameCSParserRuleCall_2_0() { return cPathNamePathNameCSParserRuleCall_2_0; }

		//("inv" invariants+=ConstraintCS | definitions+=DefCS)+
		public Alternatives getAlternatives_3() { return cAlternatives_3; }

		//"inv" invariants+=ConstraintCS
		public Group getGroup_3_0() { return cGroup_3_0; }

		//"inv"
		public Keyword getInvKeyword_3_0_0() { return cInvKeyword_3_0_0; }

		//invariants+=ConstraintCS
		public Assignment getInvariantsAssignment_3_0_1() { return cInvariantsAssignment_3_0_1; }

		//ConstraintCS
		public RuleCall getInvariantsConstraintCSParserRuleCall_3_0_1_0() { return cInvariantsConstraintCSParserRuleCall_3_0_1_0; }

		//definitions+=DefCS
		public Assignment getDefinitionsAssignment_3_1() { return cDefinitionsAssignment_3_1; }

		//DefCS
		public RuleCall getDefinitionsDefCSParserRuleCall_3_1_0() { return cDefinitionsDefCSParserRuleCall_3_1_0; }
	}

	public class ConstraintCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "ConstraintCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_0_0 = (Assignment)cGroup_0.eContents().get(0);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_0_0_0 = (RuleCall)cNameAssignment_0_0.eContents().get(0);
		private final Group cGroup_0_1 = (Group)cGroup_0.eContents().get(1);
		private final Keyword cLeftParenthesisKeyword_0_1_0 = (Keyword)cGroup_0_1.eContents().get(0);
		private final Assignment cMessageSpecificationAssignment_0_1_1 = (Assignment)cGroup_0_1.eContents().get(1);
		private final RuleCall cMessageSpecificationSpecificationCSParserRuleCall_0_1_1_0 = (RuleCall)cMessageSpecificationAssignment_0_1_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_0_1_2 = (Keyword)cGroup_0_1.eContents().get(2);
		private final Keyword cColonKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cSpecificationAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cSpecificationSpecificationCSParserRuleCall_2_0 = (RuleCall)cSpecificationAssignment_2.eContents().get(0);
		
		//ConstraintCS returns base::ConstraintCS:
		//	(name=UnrestrictedName ("(" messageSpecification=SpecificationCS ")")?)? ":" specification=SpecificationCS;
		public ParserRule getRule() { return rule; }

		//(name=UnrestrictedName ("(" messageSpecification=SpecificationCS ")")?)? ":" specification=SpecificationCS
		public Group getGroup() { return cGroup; }

		//(name=UnrestrictedName ("(" messageSpecification=SpecificationCS ")")?)?
		public Group getGroup_0() { return cGroup_0; }

		//name=UnrestrictedName
		public Assignment getNameAssignment_0_0() { return cNameAssignment_0_0; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_0_0_0() { return cNameUnrestrictedNameParserRuleCall_0_0_0; }

		//("(" messageSpecification=SpecificationCS ")")?
		public Group getGroup_0_1() { return cGroup_0_1; }

		//"("
		public Keyword getLeftParenthesisKeyword_0_1_0() { return cLeftParenthesisKeyword_0_1_0; }

		//messageSpecification=SpecificationCS
		public Assignment getMessageSpecificationAssignment_0_1_1() { return cMessageSpecificationAssignment_0_1_1; }

		//SpecificationCS
		public RuleCall getMessageSpecificationSpecificationCSParserRuleCall_0_1_1_0() { return cMessageSpecificationSpecificationCSParserRuleCall_0_1_1_0; }

		//")"
		public Keyword getRightParenthesisKeyword_0_1_2() { return cRightParenthesisKeyword_0_1_2; }

		//":"
		public Keyword getColonKeyword_1() { return cColonKeyword_1; }

		//specification=SpecificationCS
		public Assignment getSpecificationAssignment_2() { return cSpecificationAssignment_2; }

		//SpecificationCS
		public RuleCall getSpecificationSpecificationCSParserRuleCall_2_0() { return cSpecificationSpecificationCSParserRuleCall_2_0; }
	}

	public class ContextDeclCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "ContextDeclCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cPropertyContextDeclCSParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cClassifierContextDeclCSParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cOperationContextDeclCSParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//ContextDeclCS:
		//	PropertyContextDeclCS | ClassifierContextDeclCS | OperationContextDeclCS;
		public ParserRule getRule() { return rule; }

		//PropertyContextDeclCS | ClassifierContextDeclCS | OperationContextDeclCS
		public Alternatives getAlternatives() { return cAlternatives; }

		//PropertyContextDeclCS
		public RuleCall getPropertyContextDeclCSParserRuleCall_0() { return cPropertyContextDeclCSParserRuleCall_0; }

		//ClassifierContextDeclCS
		public RuleCall getClassifierContextDeclCSParserRuleCall_1() { return cClassifierContextDeclCSParserRuleCall_1; }

		//OperationContextDeclCS
		public RuleCall getOperationContextDeclCSParserRuleCall_2() { return cOperationContextDeclCSParserRuleCall_2; }
	}

	public class DefCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "DefCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cDefOperationCSParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cDefPropertyCSParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//DefCS:
		//	DefOperationCS | DefPropertyCS;
		public ParserRule getRule() { return rule; }

		//DefOperationCS | DefPropertyCS
		public Alternatives getAlternatives() { return cAlternatives; }

		//DefOperationCS
		public RuleCall getDefOperationCSParserRuleCall_0() { return cDefOperationCSParserRuleCall_0; }

		//DefPropertyCS
		public RuleCall getDefPropertyCSParserRuleCall_1() { return cDefPropertyCSParserRuleCall_1; }
	}

	public class DefOperationCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "DefOperationCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cStaticAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final Keyword cStaticStaticKeyword_0_0 = (Keyword)cStaticAssignment_0.eContents().get(0);
		private final Keyword cDefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final RuleCall cUnrestrictedNameParserRuleCall_2 = (RuleCall)cGroup.eContents().get(2);
		private final Keyword cColonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cNameAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_4_0 = (RuleCall)cNameAssignment_4.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Group cGroup_6 = (Group)cGroup.eContents().get(6);
		private final Assignment cParametersAssignment_6_0 = (Assignment)cGroup_6.eContents().get(0);
		private final RuleCall cParametersDefParameterCSParserRuleCall_6_0_0 = (RuleCall)cParametersAssignment_6_0.eContents().get(0);
		private final Group cGroup_6_1 = (Group)cGroup_6.eContents().get(1);
		private final Keyword cCommaKeyword_6_1_0 = (Keyword)cGroup_6_1.eContents().get(0);
		private final Assignment cParametersAssignment_6_1_1 = (Assignment)cGroup_6_1.eContents().get(1);
		private final RuleCall cParametersDefParameterCSParserRuleCall_6_1_1_0 = (RuleCall)cParametersAssignment_6_1_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_7 = (Keyword)cGroup.eContents().get(7);
		private final Keyword cColonKeyword_8 = (Keyword)cGroup.eContents().get(8);
		private final Assignment cOwnedTypeAssignment_9 = (Assignment)cGroup.eContents().get(9);
		private final RuleCall cOwnedTypeTypeExpCSParserRuleCall_9_0 = (RuleCall)cOwnedTypeAssignment_9.eContents().get(0);
		private final Keyword cEqualsSignKeyword_10 = (Keyword)cGroup.eContents().get(10);
		private final Assignment cSpecificationAssignment_11 = (Assignment)cGroup.eContents().get(11);
		private final RuleCall cSpecificationSpecificationCSParserRuleCall_11_0 = (RuleCall)cSpecificationAssignment_11.eContents().get(0);
		
		//DefOperationCS:
		//	static?="static"? "def" UnrestrictedName? ":" name=UnrestrictedName "(" (parameters+=DefParameterCS (","
		//	parameters+=DefParameterCS)*)? ")" ":" ownedType=TypeExpCS? "=" specification=SpecificationCS;
		public ParserRule getRule() { return rule; }

		//static?="static"? "def" UnrestrictedName? ":" name=UnrestrictedName "(" (parameters+=DefParameterCS (","
		//parameters+=DefParameterCS)*)? ")" ":" ownedType=TypeExpCS? "=" specification=SpecificationCS
		public Group getGroup() { return cGroup; }

		//static?="static"?
		public Assignment getStaticAssignment_0() { return cStaticAssignment_0; }

		//"static"
		public Keyword getStaticStaticKeyword_0_0() { return cStaticStaticKeyword_0_0; }

		//"def"
		public Keyword getDefKeyword_1() { return cDefKeyword_1; }

		//UnrestrictedName?
		public RuleCall getUnrestrictedNameParserRuleCall_2() { return cUnrestrictedNameParserRuleCall_2; }

		//":"
		public Keyword getColonKeyword_3() { return cColonKeyword_3; }

		//name=UnrestrictedName
		public Assignment getNameAssignment_4() { return cNameAssignment_4; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_4_0() { return cNameUnrestrictedNameParserRuleCall_4_0; }

		//"("
		public Keyword getLeftParenthesisKeyword_5() { return cLeftParenthesisKeyword_5; }

		//(parameters+=DefParameterCS ("," parameters+=DefParameterCS)*)?
		public Group getGroup_6() { return cGroup_6; }

		//parameters+=DefParameterCS
		public Assignment getParametersAssignment_6_0() { return cParametersAssignment_6_0; }

		//DefParameterCS
		public RuleCall getParametersDefParameterCSParserRuleCall_6_0_0() { return cParametersDefParameterCSParserRuleCall_6_0_0; }

		//("," parameters+=DefParameterCS)*
		public Group getGroup_6_1() { return cGroup_6_1; }

		//","
		public Keyword getCommaKeyword_6_1_0() { return cCommaKeyword_6_1_0; }

		//parameters+=DefParameterCS
		public Assignment getParametersAssignment_6_1_1() { return cParametersAssignment_6_1_1; }

		//DefParameterCS
		public RuleCall getParametersDefParameterCSParserRuleCall_6_1_1_0() { return cParametersDefParameterCSParserRuleCall_6_1_1_0; }

		//")"
		public Keyword getRightParenthesisKeyword_7() { return cRightParenthesisKeyword_7; }

		//":"
		public Keyword getColonKeyword_8() { return cColonKeyword_8; }

		//ownedType=TypeExpCS?
		public Assignment getOwnedTypeAssignment_9() { return cOwnedTypeAssignment_9; }

		//TypeExpCS
		public RuleCall getOwnedTypeTypeExpCSParserRuleCall_9_0() { return cOwnedTypeTypeExpCSParserRuleCall_9_0; }

		//"="
		public Keyword getEqualsSignKeyword_10() { return cEqualsSignKeyword_10; }

		//specification=SpecificationCS
		public Assignment getSpecificationAssignment_11() { return cSpecificationAssignment_11; }

		//SpecificationCS
		public RuleCall getSpecificationSpecificationCSParserRuleCall_11_0() { return cSpecificationSpecificationCSParserRuleCall_11_0; }
	}

	public class DefParameterCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "DefParameterCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Keyword cColonKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cOwnedTypeAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cOwnedTypeTypeExpCSParserRuleCall_2_0 = (RuleCall)cOwnedTypeAssignment_2.eContents().get(0);
		
		//DefParameterCS returns base::ParameterCS:
		//	name=UnrestrictedName ":" ownedType=TypeExpCS;
		public ParserRule getRule() { return rule; }

		//name=UnrestrictedName ":" ownedType=TypeExpCS
		public Group getGroup() { return cGroup; }

		//name=UnrestrictedName
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_0_0() { return cNameUnrestrictedNameParserRuleCall_0_0; }

		//":"
		public Keyword getColonKeyword_1() { return cColonKeyword_1; }

		//ownedType=TypeExpCS
		public Assignment getOwnedTypeAssignment_2() { return cOwnedTypeAssignment_2; }

		//TypeExpCS
		public RuleCall getOwnedTypeTypeExpCSParserRuleCall_2_0() { return cOwnedTypeTypeExpCSParserRuleCall_2_0; }
	}

	public class DefPropertyCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "DefPropertyCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cStaticAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final Keyword cStaticStaticKeyword_0_0 = (Keyword)cStaticAssignment_0.eContents().get(0);
		private final Keyword cDefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final RuleCall cUnrestrictedNameParserRuleCall_2 = (RuleCall)cGroup.eContents().get(2);
		private final Keyword cColonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cNameAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_4_0 = (RuleCall)cNameAssignment_4.eContents().get(0);
		private final Keyword cColonKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Assignment cOwnedTypeAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cOwnedTypeTypeExpCSParserRuleCall_6_0 = (RuleCall)cOwnedTypeAssignment_6.eContents().get(0);
		private final Keyword cEqualsSignKeyword_7 = (Keyword)cGroup.eContents().get(7);
		private final Assignment cSpecificationAssignment_8 = (Assignment)cGroup.eContents().get(8);
		private final RuleCall cSpecificationSpecificationCSParserRuleCall_8_0 = (RuleCall)cSpecificationAssignment_8.eContents().get(0);
		
		//DefPropertyCS:
		//	static?="static"? "def" UnrestrictedName? ":" name=UnrestrictedName ":" ownedType=TypeExpCS "="
		//	specification=SpecificationCS;
		public ParserRule getRule() { return rule; }

		//static?="static"? "def" UnrestrictedName? ":" name=UnrestrictedName ":" ownedType=TypeExpCS "="
		//specification=SpecificationCS
		public Group getGroup() { return cGroup; }

		//static?="static"?
		public Assignment getStaticAssignment_0() { return cStaticAssignment_0; }

		//"static"
		public Keyword getStaticStaticKeyword_0_0() { return cStaticStaticKeyword_0_0; }

		//"def"
		public Keyword getDefKeyword_1() { return cDefKeyword_1; }

		//UnrestrictedName?
		public RuleCall getUnrestrictedNameParserRuleCall_2() { return cUnrestrictedNameParserRuleCall_2; }

		//":"
		public Keyword getColonKeyword_3() { return cColonKeyword_3; }

		//name=UnrestrictedName
		public Assignment getNameAssignment_4() { return cNameAssignment_4; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_4_0() { return cNameUnrestrictedNameParserRuleCall_4_0; }

		//":"
		public Keyword getColonKeyword_5() { return cColonKeyword_5; }

		//ownedType=TypeExpCS
		public Assignment getOwnedTypeAssignment_6() { return cOwnedTypeAssignment_6; }

		//TypeExpCS
		public RuleCall getOwnedTypeTypeExpCSParserRuleCall_6_0() { return cOwnedTypeTypeExpCSParserRuleCall_6_0; }

		//"="
		public Keyword getEqualsSignKeyword_7() { return cEqualsSignKeyword_7; }

		//specification=SpecificationCS
		public Assignment getSpecificationAssignment_8() { return cSpecificationAssignment_8; }

		//SpecificationCS
		public RuleCall getSpecificationSpecificationCSParserRuleCall_8_0() { return cSpecificationSpecificationCSParserRuleCall_8_0; }
	}

	public class ImportCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "ImportCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cImportKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_1_0 = (Assignment)cGroup_1.eContents().get(0);
		private final RuleCall cNameIdentifierParserRuleCall_1_0_0 = (RuleCall)cNameAssignment_1_0.eContents().get(0);
		private final Keyword cColonKeyword_1_1 = (Keyword)cGroup_1.eContents().get(1);
		private final Assignment cPathNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cPathNameURIPathNameCSParserRuleCall_2_0 = (RuleCall)cPathNameAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Assignment cAllAssignment_3_0 = (Assignment)cGroup_3.eContents().get(0);
		private final Keyword cAllColonColonKeyword_3_0_0 = (Keyword)cAllAssignment_3_0.eContents().get(0);
		private final Keyword cAsteriskKeyword_3_1 = (Keyword)cGroup_3.eContents().get(1);
		
		//ImportCS returns base::ImportCS:
		//	"import" (name=Identifier ":")? pathName=URIPathNameCS (all?="::" "*")?;
		public ParserRule getRule() { return rule; }

		//"import" (name=Identifier ":")? pathName=URIPathNameCS (all?="::" "*")?
		public Group getGroup() { return cGroup; }

		//"import"
		public Keyword getImportKeyword_0() { return cImportKeyword_0; }

		//(name=Identifier ":")?
		public Group getGroup_1() { return cGroup_1; }

		//name=Identifier
		public Assignment getNameAssignment_1_0() { return cNameAssignment_1_0; }

		//Identifier
		public RuleCall getNameIdentifierParserRuleCall_1_0_0() { return cNameIdentifierParserRuleCall_1_0_0; }

		//":"
		public Keyword getColonKeyword_1_1() { return cColonKeyword_1_1; }

		//pathName=URIPathNameCS
		public Assignment getPathNameAssignment_2() { return cPathNameAssignment_2; }

		//URIPathNameCS
		public RuleCall getPathNameURIPathNameCSParserRuleCall_2_0() { return cPathNameURIPathNameCSParserRuleCall_2_0; }

		//(all?="::" "*")?
		public Group getGroup_3() { return cGroup_3; }

		//all?="::"
		public Assignment getAllAssignment_3_0() { return cAllAssignment_3_0; }

		//"::"
		public Keyword getAllColonColonKeyword_3_0_0() { return cAllColonColonKeyword_3_0_0; }

		//"*"
		public Keyword getAsteriskKeyword_3_1() { return cAsteriskKeyword_3_1; }
	}

	public class IncludeCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "IncludeCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cIncludeKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cNamespaceAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cNamespaceNamespaceCrossReference_1_0 = (CrossReference)cNamespaceAssignment_1.eContents().get(0);
		private final RuleCall cNamespaceNamespaceURIParserRuleCall_1_0_1 = (RuleCall)cNamespaceNamespaceCrossReference_1_0.eContents().get(1);
		
		//IncludeCS:
		//	"include" namespace=[pivot::Namespace|URI];
		public ParserRule getRule() { return rule; }

		//"include" namespace=[pivot::Namespace|URI]
		public Group getGroup() { return cGroup; }

		//"include"
		public Keyword getIncludeKeyword_0() { return cIncludeKeyword_0; }

		//namespace=[pivot::Namespace|URI]
		public Assignment getNamespaceAssignment_1() { return cNamespaceAssignment_1; }

		//[pivot::Namespace|URI]
		public CrossReference getNamespaceNamespaceCrossReference_1_0() { return cNamespaceNamespaceCrossReference_1_0; }

		//URI
		public RuleCall getNamespaceNamespaceURIParserRuleCall_1_0_1() { return cNamespaceNamespaceURIParserRuleCall_1_0_1; }
	}

	public class LibraryCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "LibraryCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLibraryKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cPackageAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cPackagePackageCrossReference_1_0 = (CrossReference)cPackageAssignment_1.eContents().get(0);
		private final RuleCall cPackagePackageURIParserRuleCall_1_0_1 = (RuleCall)cPackagePackageCrossReference_1_0.eContents().get(1);
		
		//LibraryCS returns base::LibraryCS:
		//	"library" package=[pivot::Package|URI];
		public ParserRule getRule() { return rule; }

		//"library" package=[pivot::Package|URI]
		public Group getGroup() { return cGroup; }

		//"library"
		public Keyword getLibraryKeyword_0() { return cLibraryKeyword_0; }

		//package=[pivot::Package|URI]
		public Assignment getPackageAssignment_1() { return cPackageAssignment_1; }

		//[pivot::Package|URI]
		public CrossReference getPackagePackageCrossReference_1_0() { return cPackagePackageCrossReference_1_0; }

		//URI
		public RuleCall getPackagePackageURIParserRuleCall_1_0_1() { return cPackagePackageURIParserRuleCall_1_0_1; }
	}

	public class OperationContextDeclCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "OperationContextDeclCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cContextKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cPathNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cPathNamePathNameCSParserRuleCall_1_0 = (RuleCall)cPathNameAssignment_1.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Assignment cParametersAssignment_3_0 = (Assignment)cGroup_3.eContents().get(0);
		private final RuleCall cParametersParameterCSParserRuleCall_3_0_0 = (RuleCall)cParametersAssignment_3_0.eContents().get(0);
		private final Group cGroup_3_1 = (Group)cGroup_3.eContents().get(1);
		private final Keyword cCommaKeyword_3_1_0 = (Keyword)cGroup_3_1.eContents().get(0);
		private final Assignment cParametersAssignment_3_1_1 = (Assignment)cGroup_3_1.eContents().get(1);
		private final RuleCall cParametersParameterCSParserRuleCall_3_1_1_0 = (RuleCall)cParametersAssignment_3_1_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Keyword cColonKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Assignment cOwnedTypeAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cOwnedTypeTypeExpCSParserRuleCall_6_0 = (RuleCall)cOwnedTypeAssignment_6.eContents().get(0);
		private final Alternatives cAlternatives_7 = (Alternatives)cGroup.eContents().get(7);
		private final Group cGroup_7_0 = (Group)cAlternatives_7.eContents().get(0);
		private final Keyword cPreKeyword_7_0_0 = (Keyword)cGroup_7_0.eContents().get(0);
		private final Assignment cPreconditionsAssignment_7_0_1 = (Assignment)cGroup_7_0.eContents().get(1);
		private final RuleCall cPreconditionsConstraintCSParserRuleCall_7_0_1_0 = (RuleCall)cPreconditionsAssignment_7_0_1.eContents().get(0);
		private final Group cGroup_7_1 = (Group)cAlternatives_7.eContents().get(1);
		private final Keyword cPostKeyword_7_1_0 = (Keyword)cGroup_7_1.eContents().get(0);
		private final Assignment cPostconditionsAssignment_7_1_1 = (Assignment)cGroup_7_1.eContents().get(1);
		private final RuleCall cPostconditionsConstraintCSParserRuleCall_7_1_1_0 = (RuleCall)cPostconditionsAssignment_7_1_1.eContents().get(0);
		private final Group cGroup_7_2 = (Group)cAlternatives_7.eContents().get(2);
		private final Keyword cBodyKeyword_7_2_0 = (Keyword)cGroup_7_2.eContents().get(0);
		private final RuleCall cUnrestrictedNameParserRuleCall_7_2_1 = (RuleCall)cGroup_7_2.eContents().get(1);
		private final Keyword cColonKeyword_7_2_2 = (Keyword)cGroup_7_2.eContents().get(2);
		private final Assignment cBodiesAssignment_7_2_3 = (Assignment)cGroup_7_2.eContents().get(3);
		private final RuleCall cBodiesSpecificationCSParserRuleCall_7_2_3_0 = (RuleCall)cBodiesAssignment_7_2_3.eContents().get(0);
		
		//OperationContextDeclCS:
		//	"context" pathName=PathNameCS "(" (parameters+=ParameterCS ("," parameters+=ParameterCS)*)? ")" ":"
		//	ownedType=TypeExpCS? ("pre" preconditions+=ConstraintCS | "post" postconditions+=ConstraintCS | "body"
		//	UnrestrictedName? ":" bodies+=SpecificationCS)*;
		public ParserRule getRule() { return rule; }

		//"context" pathName=PathNameCS "(" (parameters+=ParameterCS ("," parameters+=ParameterCS)*)? ")" ":" ownedType=TypeExpCS?
		//("pre" preconditions+=ConstraintCS | "post" postconditions+=ConstraintCS | "body" UnrestrictedName? ":"
		//bodies+=SpecificationCS)*
		public Group getGroup() { return cGroup; }

		//"context"
		public Keyword getContextKeyword_0() { return cContextKeyword_0; }

		//pathName=PathNameCS
		public Assignment getPathNameAssignment_1() { return cPathNameAssignment_1; }

		//PathNameCS
		public RuleCall getPathNamePathNameCSParserRuleCall_1_0() { return cPathNamePathNameCSParserRuleCall_1_0; }

		//"("
		public Keyword getLeftParenthesisKeyword_2() { return cLeftParenthesisKeyword_2; }

		//(parameters+=ParameterCS ("," parameters+=ParameterCS)*)?
		public Group getGroup_3() { return cGroup_3; }

		//parameters+=ParameterCS
		public Assignment getParametersAssignment_3_0() { return cParametersAssignment_3_0; }

		//ParameterCS
		public RuleCall getParametersParameterCSParserRuleCall_3_0_0() { return cParametersParameterCSParserRuleCall_3_0_0; }

		//("," parameters+=ParameterCS)*
		public Group getGroup_3_1() { return cGroup_3_1; }

		//","
		public Keyword getCommaKeyword_3_1_0() { return cCommaKeyword_3_1_0; }

		//parameters+=ParameterCS
		public Assignment getParametersAssignment_3_1_1() { return cParametersAssignment_3_1_1; }

		//ParameterCS
		public RuleCall getParametersParameterCSParserRuleCall_3_1_1_0() { return cParametersParameterCSParserRuleCall_3_1_1_0; }

		//")"
		public Keyword getRightParenthesisKeyword_4() { return cRightParenthesisKeyword_4; }

		//":"
		public Keyword getColonKeyword_5() { return cColonKeyword_5; }

		//ownedType=TypeExpCS?
		public Assignment getOwnedTypeAssignment_6() { return cOwnedTypeAssignment_6; }

		//TypeExpCS
		public RuleCall getOwnedTypeTypeExpCSParserRuleCall_6_0() { return cOwnedTypeTypeExpCSParserRuleCall_6_0; }

		//("pre" preconditions+=ConstraintCS | "post" postconditions+=ConstraintCS | "body" UnrestrictedName? ":"
		//bodies+=SpecificationCS)*
		public Alternatives getAlternatives_7() { return cAlternatives_7; }

		//"pre" preconditions+=ConstraintCS
		public Group getGroup_7_0() { return cGroup_7_0; }

		//"pre"
		public Keyword getPreKeyword_7_0_0() { return cPreKeyword_7_0_0; }

		//preconditions+=ConstraintCS
		public Assignment getPreconditionsAssignment_7_0_1() { return cPreconditionsAssignment_7_0_1; }

		//ConstraintCS
		public RuleCall getPreconditionsConstraintCSParserRuleCall_7_0_1_0() { return cPreconditionsConstraintCSParserRuleCall_7_0_1_0; }

		//"post" postconditions+=ConstraintCS
		public Group getGroup_7_1() { return cGroup_7_1; }

		//"post"
		public Keyword getPostKeyword_7_1_0() { return cPostKeyword_7_1_0; }

		//postconditions+=ConstraintCS
		public Assignment getPostconditionsAssignment_7_1_1() { return cPostconditionsAssignment_7_1_1; }

		//ConstraintCS
		public RuleCall getPostconditionsConstraintCSParserRuleCall_7_1_1_0() { return cPostconditionsConstraintCSParserRuleCall_7_1_1_0; }

		//"body" UnrestrictedName? ":" bodies+=SpecificationCS
		public Group getGroup_7_2() { return cGroup_7_2; }

		//"body"
		public Keyword getBodyKeyword_7_2_0() { return cBodyKeyword_7_2_0; }

		//UnrestrictedName?
		public RuleCall getUnrestrictedNameParserRuleCall_7_2_1() { return cUnrestrictedNameParserRuleCall_7_2_1; }

		//":"
		public Keyword getColonKeyword_7_2_2() { return cColonKeyword_7_2_2; }

		//bodies+=SpecificationCS
		public Assignment getBodiesAssignment_7_2_3() { return cBodiesAssignment_7_2_3; }

		//SpecificationCS
		public RuleCall getBodiesSpecificationCSParserRuleCall_7_2_3_0() { return cBodiesSpecificationCSParserRuleCall_7_2_3_0; }
	}

	public class PackageDeclarationCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "PackageDeclarationCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cPackageKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cPathNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cPathNamePathNameCSParserRuleCall_1_0 = (RuleCall)cPathNameAssignment_1.eContents().get(0);
		private final Assignment cContextsAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cContextsContextDeclCSParserRuleCall_2_0 = (RuleCall)cContextsAssignment_2.eContents().get(0);
		private final Keyword cEndpackageKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//PackageDeclarationCS:
		//	"package" pathName=PathNameCS contexts+=ContextDeclCS* "endpackage";
		public ParserRule getRule() { return rule; }

		//"package" pathName=PathNameCS contexts+=ContextDeclCS* "endpackage"
		public Group getGroup() { return cGroup; }

		//"package"
		public Keyword getPackageKeyword_0() { return cPackageKeyword_0; }

		//pathName=PathNameCS
		public Assignment getPathNameAssignment_1() { return cPathNameAssignment_1; }

		//PathNameCS
		public RuleCall getPathNamePathNameCSParserRuleCall_1_0() { return cPathNamePathNameCSParserRuleCall_1_0; }

		//contexts+=ContextDeclCS*
		public Assignment getContextsAssignment_2() { return cContextsAssignment_2; }

		//ContextDeclCS
		public RuleCall getContextsContextDeclCSParserRuleCall_2_0() { return cContextsContextDeclCSParserRuleCall_2_0; }

		//"endpackage"
		public Keyword getEndpackageKeyword_3() { return cEndpackageKeyword_3; }
	}

	public class ParameterCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "ParameterCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_0_0 = (Assignment)cGroup_0.eContents().get(0);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_0_0_0 = (RuleCall)cNameAssignment_0_0.eContents().get(0);
		private final Keyword cColonKeyword_0_1 = (Keyword)cGroup_0.eContents().get(1);
		private final Assignment cOwnedTypeAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cOwnedTypeTypeExpCSParserRuleCall_1_0 = (RuleCall)cOwnedTypeAssignment_1.eContents().get(0);
		
		//ParameterCS returns base::ParameterCS:
		//	(name=UnrestrictedName ":")? ownedType=TypeExpCS;
		public ParserRule getRule() { return rule; }

		//(name=UnrestrictedName ":")? ownedType=TypeExpCS
		public Group getGroup() { return cGroup; }

		//(name=UnrestrictedName ":")?
		public Group getGroup_0() { return cGroup_0; }

		//name=UnrestrictedName
		public Assignment getNameAssignment_0_0() { return cNameAssignment_0_0; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_0_0_0() { return cNameUnrestrictedNameParserRuleCall_0_0_0; }

		//":"
		public Keyword getColonKeyword_0_1() { return cColonKeyword_0_1; }

		//ownedType=TypeExpCS
		public Assignment getOwnedTypeAssignment_1() { return cOwnedTypeAssignment_1; }

		//TypeExpCS
		public RuleCall getOwnedTypeTypeExpCSParserRuleCall_1_0() { return cOwnedTypeTypeExpCSParserRuleCall_1_0; }
	}

	public class PropertyContextDeclCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "PropertyContextDeclCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cContextKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cPathNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cPathNamePathNameCSParserRuleCall_1_0 = (RuleCall)cPathNameAssignment_1.eContents().get(0);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cOwnedTypeAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cOwnedTypeTypeExpCSParserRuleCall_3_0 = (RuleCall)cOwnedTypeAssignment_3.eContents().get(0);
		private final Alternatives cAlternatives_4 = (Alternatives)cGroup.eContents().get(4);
		private final Group cGroup_4_0 = (Group)cAlternatives_4.eContents().get(0);
		private final Keyword cDeriveKeyword_4_0_0 = (Keyword)cGroup_4_0.eContents().get(0);
		private final Assignment cDerivedInvariantsAssignment_4_0_1 = (Assignment)cGroup_4_0.eContents().get(1);
		private final RuleCall cDerivedInvariantsConstraintCSParserRuleCall_4_0_1_0 = (RuleCall)cDerivedInvariantsAssignment_4_0_1.eContents().get(0);
		private final Group cGroup_4_1 = (Group)cAlternatives_4.eContents().get(1);
		private final Keyword cInitKeyword_4_1_0 = (Keyword)cGroup_4_1.eContents().get(0);
		private final Keyword cColonKeyword_4_1_1 = (Keyword)cGroup_4_1.eContents().get(1);
		private final Assignment cDefaultExpressionsAssignment_4_1_2 = (Assignment)cGroup_4_1.eContents().get(2);
		private final RuleCall cDefaultExpressionsSpecificationCSParserRuleCall_4_1_2_0 = (RuleCall)cDefaultExpressionsAssignment_4_1_2.eContents().get(0);
		
		//PropertyContextDeclCS:
		//	"context" pathName=PathNameCS ":" ownedType=TypeExpCS? ("derive" derivedInvariants+=ConstraintCS | "init" ":"
		//	defaultExpressions+=SpecificationCS)*;
		public ParserRule getRule() { return rule; }

		//"context" pathName=PathNameCS ":" ownedType=TypeExpCS? ("derive" derivedInvariants+=ConstraintCS | "init" ":"
		//defaultExpressions+=SpecificationCS)*
		public Group getGroup() { return cGroup; }

		//"context"
		public Keyword getContextKeyword_0() { return cContextKeyword_0; }

		//pathName=PathNameCS
		public Assignment getPathNameAssignment_1() { return cPathNameAssignment_1; }

		//PathNameCS
		public RuleCall getPathNamePathNameCSParserRuleCall_1_0() { return cPathNamePathNameCSParserRuleCall_1_0; }

		//":"
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }

		//ownedType=TypeExpCS?
		public Assignment getOwnedTypeAssignment_3() { return cOwnedTypeAssignment_3; }

		//TypeExpCS
		public RuleCall getOwnedTypeTypeExpCSParserRuleCall_3_0() { return cOwnedTypeTypeExpCSParserRuleCall_3_0; }

		//("derive" derivedInvariants+=ConstraintCS | "init" ":" defaultExpressions+=SpecificationCS)*
		public Alternatives getAlternatives_4() { return cAlternatives_4; }

		//"derive" derivedInvariants+=ConstraintCS
		public Group getGroup_4_0() { return cGroup_4_0; }

		//"derive"
		public Keyword getDeriveKeyword_4_0_0() { return cDeriveKeyword_4_0_0; }

		//derivedInvariants+=ConstraintCS
		public Assignment getDerivedInvariantsAssignment_4_0_1() { return cDerivedInvariantsAssignment_4_0_1; }

		//ConstraintCS
		public RuleCall getDerivedInvariantsConstraintCSParserRuleCall_4_0_1_0() { return cDerivedInvariantsConstraintCSParserRuleCall_4_0_1_0; }

		//"init" ":" defaultExpressions+=SpecificationCS
		public Group getGroup_4_1() { return cGroup_4_1; }

		//"init"
		public Keyword getInitKeyword_4_1_0() { return cInitKeyword_4_1_0; }

		//":"
		public Keyword getColonKeyword_4_1_1() { return cColonKeyword_4_1_1; }

		//defaultExpressions+=SpecificationCS
		public Assignment getDefaultExpressionsAssignment_4_1_2() { return cDefaultExpressionsAssignment_4_1_2; }

		//SpecificationCS
		public RuleCall getDefaultExpressionsSpecificationCSParserRuleCall_4_1_2_0() { return cDefaultExpressionsSpecificationCSParserRuleCall_4_1_2_0; }
	}

	public class SpecificationCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "SpecificationCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Assignment cOwnedExpressionAssignment_0 = (Assignment)cAlternatives.eContents().get(0);
		private final RuleCall cOwnedExpressionExpCSParserRuleCall_0_0 = (RuleCall)cOwnedExpressionAssignment_0.eContents().get(0);
		private final Assignment cExprStringAssignment_1 = (Assignment)cAlternatives.eContents().get(1);
		private final RuleCall cExprStringUNQUOTED_STRINGTerminalRuleCall_1_0 = (RuleCall)cExprStringAssignment_1.eContents().get(0);
		
		//SpecificationCS returns essentialocl::ExpSpecificationCS:
		//	ownedExpression=ExpCS | exprString=UNQUOTED_STRING;
		public ParserRule getRule() { return rule; }

		//ownedExpression=ExpCS | exprString=UNQUOTED_STRING
		public Alternatives getAlternatives() { return cAlternatives; }

		//ownedExpression=ExpCS
		public Assignment getOwnedExpressionAssignment_0() { return cOwnedExpressionAssignment_0; }

		//ExpCS
		public RuleCall getOwnedExpressionExpCSParserRuleCall_0_0() { return cOwnedExpressionExpCSParserRuleCall_0_0; }

		//exprString=UNQUOTED_STRING
		public Assignment getExprStringAssignment_1() { return cExprStringAssignment_1; }

		//UNQUOTED_STRING
		public RuleCall getExprStringUNQUOTED_STRINGTerminalRuleCall_1_0() { return cExprStringUNQUOTED_STRINGTerminalRuleCall_1_0; }
	}

	public class NavigatingArgExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "NavigatingArgExpCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cAlternatives.eContents().get(0);
		private final Action cOCLMessageArgCSAction_0_0 = (Action)cGroup_0.eContents().get(0);
		private final Keyword cQuestionMarkKeyword_0_1 = (Keyword)cGroup_0.eContents().get(1);
		private final RuleCall cExpCSParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		////---------------------------------------------------------------------------------
		// //	EssentialOCL overrides
		//
		////---------------------------------------------------------------------------------
		// NavigatingArgExpCS returns
		//essentialocl::ExpCS:
		//	{OCLMessageArgCS} "?" | ExpCS;
		public ParserRule getRule() { return rule; }

		//{OCLMessageArgCS} "?" | ExpCS
		public Alternatives getAlternatives() { return cAlternatives; }

		//{OCLMessageArgCS} "?"
		public Group getGroup_0() { return cGroup_0; }

		//{OCLMessageArgCS}
		public Action getOCLMessageArgCSAction_0_0() { return cOCLMessageArgCSAction_0_0; }

		//"?"
		public Keyword getQuestionMarkKeyword_0_1() { return cQuestionMarkKeyword_0_1; }

		//ExpCS
		public RuleCall getExpCSParserRuleCall_1() { return cExpCSParserRuleCall_1; }
	}
	
	
	private CompleteOCLDocumentCSElements pCompleteOCLDocumentCS;
	private TerminalRule tUNQUOTED_STRING;
	private CompleteOCLNavigationOperatorCSElements pCompleteOCLNavigationOperatorCS;
	private NavigationOperatorCSElements pNavigationOperatorCS;
	private UnrestrictedNameElements pUnrestrictedName;
	private PrimitiveTypeIdentifierElements pPrimitiveTypeIdentifier;
	private ClassifierContextDeclCSElements pClassifierContextDeclCS;
	private ConstraintCSElements pConstraintCS;
	private ContextDeclCSElements pContextDeclCS;
	private DefCSElements pDefCS;
	private DefOperationCSElements pDefOperationCS;
	private DefParameterCSElements pDefParameterCS;
	private DefPropertyCSElements pDefPropertyCS;
	private ImportCSElements pImportCS;
	private IncludeCSElements pIncludeCS;
	private LibraryCSElements pLibraryCS;
	private OperationContextDeclCSElements pOperationContextDeclCS;
	private PackageDeclarationCSElements pPackageDeclarationCS;
	private ParameterCSElements pParameterCS;
	private PropertyContextDeclCSElements pPropertyContextDeclCS;
	private SpecificationCSElements pSpecificationCS;
	private NavigatingArgExpCSElements pNavigatingArgExpCS;
	
	private final Grammar grammar;

	private EssentialOCLGrammarAccess gaEssentialOCL;

	@Inject
	public CompleteOCLGrammarAccess(GrammarProvider grammarProvider,
		EssentialOCLGrammarAccess gaEssentialOCL) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.gaEssentialOCL = gaEssentialOCL;
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("org.eclipse.ocl.examples.xtext.completeocl.CompleteOCL".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	
	public Grammar getGrammar() {
		return grammar;
	}
	

	public EssentialOCLGrammarAccess getEssentialOCLGrammarAccess() {
		return gaEssentialOCL;
	}

	
	////generate completeOCL "http://www.eclipse.org/ocl/examples/xtext/completeocl/CompleteOCL"
	// CompleteOCLDocumentCS:
	//	(ownedImport+=ImportCS | ownedInclude+=IncludeCS | ownedLibrary+=LibraryCS)* (packages+=PackageDeclarationCS |
	//	contexts+=ContextDeclCS)*;
	public CompleteOCLDocumentCSElements getCompleteOCLDocumentCSAccess() {
		return (pCompleteOCLDocumentCS != null) ? pCompleteOCLDocumentCS : (pCompleteOCLDocumentCS = new CompleteOCLDocumentCSElements());
	}
	
	public ParserRule getCompleteOCLDocumentCSRule() {
		return getCompleteOCLDocumentCSAccess().getRule();
	}

	//// Never forward parsed; just provides a placeholder
	// terminal UNQUOTED_STRING:
	////  for reverse serialisation of embedded OCL 
	// "£$%^£$%^";
	public TerminalRule getUNQUOTED_STRINGRule() {
		return (tUNQUOTED_STRING != null) ? tUNQUOTED_STRING : (tUNQUOTED_STRING = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "UNQUOTED_STRING"));
	} 

	//CompleteOCLNavigationOperatorCS returns essentialocl::NavigationOperatorCS:
	//	name=("^" | "^^");
	public CompleteOCLNavigationOperatorCSElements getCompleteOCLNavigationOperatorCSAccess() {
		return (pCompleteOCLNavigationOperatorCS != null) ? pCompleteOCLNavigationOperatorCS : (pCompleteOCLNavigationOperatorCS = new CompleteOCLNavigationOperatorCSElements());
	}
	
	public ParserRule getCompleteOCLNavigationOperatorCSRule() {
		return getCompleteOCLNavigationOperatorCSAccess().getRule();
	}

	//NavigationOperatorCS returns essentialocl::NavigationOperatorCS:
	//	EssentialOCLNavigationOperatorCS | CompleteOCLNavigationOperatorCS;
	public NavigationOperatorCSElements getNavigationOperatorCSAccess() {
		return (pNavigationOperatorCS != null) ? pNavigationOperatorCS : (pNavigationOperatorCS = new NavigationOperatorCSElements());
	}
	
	public ParserRule getNavigationOperatorCSRule() {
		return getNavigationOperatorCSAccess().getRule();
	}

	////|	'package'
	// //|	'post'
	// //|	'pre'
	// //|	'static'
	// UnrestrictedName returns ecore::EString:
	//	EssentialOCLUnrestrictedName //| 'body'
	// //| 'context'
	// //| 'def'
	// //|	'endpackage'
	// //| 'inv'
	// | "derive" | "import"
	//	| "include" | "init" | "library";
	public UnrestrictedNameElements getUnrestrictedNameAccess() {
		return (pUnrestrictedName != null) ? pUnrestrictedName : (pUnrestrictedName = new UnrestrictedNameElements());
	}
	
	public ParserRule getUnrestrictedNameRule() {
		return getUnrestrictedNameAccess().getRule();
	}

	//PrimitiveTypeIdentifier:
	//	"Boolean" | "Integer" | "Real" | "String" | "UnlimitedNatural" | "OclAny" | "OclInvalid" | "OclMessage" | "OclState"
	//	| "OclVoid";
	public PrimitiveTypeIdentifierElements getPrimitiveTypeIdentifierAccess() {
		return (pPrimitiveTypeIdentifier != null) ? pPrimitiveTypeIdentifier : (pPrimitiveTypeIdentifier = new PrimitiveTypeIdentifierElements());
	}
	
	public ParserRule getPrimitiveTypeIdentifierRule() {
		return getPrimitiveTypeIdentifierAccess().getRule();
	}

	//ClassifierContextDeclCS:
	//	"context" selfName=UnrestrictedName? pathName=PathNameCS ("inv" invariants+=ConstraintCS | definitions+=DefCS)+;
	public ClassifierContextDeclCSElements getClassifierContextDeclCSAccess() {
		return (pClassifierContextDeclCS != null) ? pClassifierContextDeclCS : (pClassifierContextDeclCS = new ClassifierContextDeclCSElements());
	}
	
	public ParserRule getClassifierContextDeclCSRule() {
		return getClassifierContextDeclCSAccess().getRule();
	}

	//ConstraintCS returns base::ConstraintCS:
	//	(name=UnrestrictedName ("(" messageSpecification=SpecificationCS ")")?)? ":" specification=SpecificationCS;
	public ConstraintCSElements getConstraintCSAccess() {
		return (pConstraintCS != null) ? pConstraintCS : (pConstraintCS = new ConstraintCSElements());
	}
	
	public ParserRule getConstraintCSRule() {
		return getConstraintCSAccess().getRule();
	}

	//ContextDeclCS:
	//	PropertyContextDeclCS | ClassifierContextDeclCS | OperationContextDeclCS;
	public ContextDeclCSElements getContextDeclCSAccess() {
		return (pContextDeclCS != null) ? pContextDeclCS : (pContextDeclCS = new ContextDeclCSElements());
	}
	
	public ParserRule getContextDeclCSRule() {
		return getContextDeclCSAccess().getRule();
	}

	//DefCS:
	//	DefOperationCS | DefPropertyCS;
	public DefCSElements getDefCSAccess() {
		return (pDefCS != null) ? pDefCS : (pDefCS = new DefCSElements());
	}
	
	public ParserRule getDefCSRule() {
		return getDefCSAccess().getRule();
	}

	//DefOperationCS:
	//	static?="static"? "def" UnrestrictedName? ":" name=UnrestrictedName "(" (parameters+=DefParameterCS (","
	//	parameters+=DefParameterCS)*)? ")" ":" ownedType=TypeExpCS? "=" specification=SpecificationCS;
	public DefOperationCSElements getDefOperationCSAccess() {
		return (pDefOperationCS != null) ? pDefOperationCS : (pDefOperationCS = new DefOperationCSElements());
	}
	
	public ParserRule getDefOperationCSRule() {
		return getDefOperationCSAccess().getRule();
	}

	//DefParameterCS returns base::ParameterCS:
	//	name=UnrestrictedName ":" ownedType=TypeExpCS;
	public DefParameterCSElements getDefParameterCSAccess() {
		return (pDefParameterCS != null) ? pDefParameterCS : (pDefParameterCS = new DefParameterCSElements());
	}
	
	public ParserRule getDefParameterCSRule() {
		return getDefParameterCSAccess().getRule();
	}

	//DefPropertyCS:
	//	static?="static"? "def" UnrestrictedName? ":" name=UnrestrictedName ":" ownedType=TypeExpCS "="
	//	specification=SpecificationCS;
	public DefPropertyCSElements getDefPropertyCSAccess() {
		return (pDefPropertyCS != null) ? pDefPropertyCS : (pDefPropertyCS = new DefPropertyCSElements());
	}
	
	public ParserRule getDefPropertyCSRule() {
		return getDefPropertyCSAccess().getRule();
	}

	//ImportCS returns base::ImportCS:
	//	"import" (name=Identifier ":")? pathName=URIPathNameCS (all?="::" "*")?;
	public ImportCSElements getImportCSAccess() {
		return (pImportCS != null) ? pImportCS : (pImportCS = new ImportCSElements());
	}
	
	public ParserRule getImportCSRule() {
		return getImportCSAccess().getRule();
	}

	//IncludeCS:
	//	"include" namespace=[pivot::Namespace|URI];
	public IncludeCSElements getIncludeCSAccess() {
		return (pIncludeCS != null) ? pIncludeCS : (pIncludeCS = new IncludeCSElements());
	}
	
	public ParserRule getIncludeCSRule() {
		return getIncludeCSAccess().getRule();
	}

	//LibraryCS returns base::LibraryCS:
	//	"library" package=[pivot::Package|URI];
	public LibraryCSElements getLibraryCSAccess() {
		return (pLibraryCS != null) ? pLibraryCS : (pLibraryCS = new LibraryCSElements());
	}
	
	public ParserRule getLibraryCSRule() {
		return getLibraryCSAccess().getRule();
	}

	//OperationContextDeclCS:
	//	"context" pathName=PathNameCS "(" (parameters+=ParameterCS ("," parameters+=ParameterCS)*)? ")" ":"
	//	ownedType=TypeExpCS? ("pre" preconditions+=ConstraintCS | "post" postconditions+=ConstraintCS | "body"
	//	UnrestrictedName? ":" bodies+=SpecificationCS)*;
	public OperationContextDeclCSElements getOperationContextDeclCSAccess() {
		return (pOperationContextDeclCS != null) ? pOperationContextDeclCS : (pOperationContextDeclCS = new OperationContextDeclCSElements());
	}
	
	public ParserRule getOperationContextDeclCSRule() {
		return getOperationContextDeclCSAccess().getRule();
	}

	//PackageDeclarationCS:
	//	"package" pathName=PathNameCS contexts+=ContextDeclCS* "endpackage";
	public PackageDeclarationCSElements getPackageDeclarationCSAccess() {
		return (pPackageDeclarationCS != null) ? pPackageDeclarationCS : (pPackageDeclarationCS = new PackageDeclarationCSElements());
	}
	
	public ParserRule getPackageDeclarationCSRule() {
		return getPackageDeclarationCSAccess().getRule();
	}

	//ParameterCS returns base::ParameterCS:
	//	(name=UnrestrictedName ":")? ownedType=TypeExpCS;
	public ParameterCSElements getParameterCSAccess() {
		return (pParameterCS != null) ? pParameterCS : (pParameterCS = new ParameterCSElements());
	}
	
	public ParserRule getParameterCSRule() {
		return getParameterCSAccess().getRule();
	}

	//PropertyContextDeclCS:
	//	"context" pathName=PathNameCS ":" ownedType=TypeExpCS? ("derive" derivedInvariants+=ConstraintCS | "init" ":"
	//	defaultExpressions+=SpecificationCS)*;
	public PropertyContextDeclCSElements getPropertyContextDeclCSAccess() {
		return (pPropertyContextDeclCS != null) ? pPropertyContextDeclCS : (pPropertyContextDeclCS = new PropertyContextDeclCSElements());
	}
	
	public ParserRule getPropertyContextDeclCSRule() {
		return getPropertyContextDeclCSAccess().getRule();
	}

	//SpecificationCS returns essentialocl::ExpSpecificationCS:
	//	ownedExpression=ExpCS | exprString=UNQUOTED_STRING;
	public SpecificationCSElements getSpecificationCSAccess() {
		return (pSpecificationCS != null) ? pSpecificationCS : (pSpecificationCS = new SpecificationCSElements());
	}
	
	public ParserRule getSpecificationCSRule() {
		return getSpecificationCSAccess().getRule();
	}

	////---------------------------------------------------------------------------------
	// //	EssentialOCL overrides
	//
	////---------------------------------------------------------------------------------
	// NavigatingArgExpCS returns
	//essentialocl::ExpCS:
	//	{OCLMessageArgCS} "?" | ExpCS;
	public NavigatingArgExpCSElements getNavigatingArgExpCSAccess() {
		return (pNavigatingArgExpCS != null) ? pNavigatingArgExpCS : (pNavigatingArgExpCS = new NavigatingArgExpCSElements());
	}
	
	public ParserRule getNavigatingArgExpCSRule() {
		return getNavigatingArgExpCSAccess().getRule();
	}

	////generate essentialOCLCST "http://www.eclipse.org/ocl/3.0.0/EssentialOCLCST"
	// Model returns ContextCS:
	//	ownedExpression=ExpCS;
	public EssentialOCLGrammarAccess.ModelElements getModelAccess() {
		return gaEssentialOCL.getModelAccess();
	}
	
	public ParserRule getModelRule() {
		return getModelAccess().getRule();
	}

	//terminal fragment ESCAPED_CHARACTER:
	//	"\\" ("b" | "t" | "n" | "f" | "r" | "u" | "\"" | "\'" | "\\");
	public TerminalRule getESCAPED_CHARACTERRule() {
		return gaEssentialOCL.getESCAPED_CHARACTERRule();
	} 

	//terminal fragment LETTER_CHARACTER:
	//	"a".."z" | "A".."Z" | "_";
	public TerminalRule getLETTER_CHARACTERRule() {
		return gaEssentialOCL.getLETTER_CHARACTERRule();
	} 

	//terminal DOUBLE_QUOTED_STRING:
	//	"\"" (ESCAPED_CHARACTER | !("\\" | "\""))* "\"";
	public TerminalRule getDOUBLE_QUOTED_STRINGRule() {
		return gaEssentialOCL.getDOUBLE_QUOTED_STRINGRule();
	} 

	//terminal SINGLE_QUOTED_STRING:
	//	"\'" (ESCAPED_CHARACTER | !("\\" | "\'"))* "\'";
	public TerminalRule getSINGLE_QUOTED_STRINGRule() {
		return gaEssentialOCL.getSINGLE_QUOTED_STRINGRule();
	} 

	//terminal ML_SINGLE_QUOTED_STRING:
	//	"/\'"->"\'/";
	public TerminalRule getML_SINGLE_QUOTED_STRINGRule() {
		return gaEssentialOCL.getML_SINGLE_QUOTED_STRINGRule();
	} 

	//terminal SIMPLE_ID:
	//	LETTER_CHARACTER (LETTER_CHARACTER | "0".."9")*;
	public TerminalRule getSIMPLE_IDRule() {
		return gaEssentialOCL.getSIMPLE_IDRule();
	} 

	//terminal ESCAPED_ID:
	//	"_" SINGLE_QUOTED_STRING;
	public TerminalRule getESCAPED_IDRule() {
		return gaEssentialOCL.getESCAPED_IDRule();
	} 

	//ID:
	//	SIMPLE_ID | ESCAPED_ID;
	public EssentialOCLGrammarAccess.IDElements getIDAccess() {
		return gaEssentialOCL.getIDAccess();
	}
	
	public ParserRule getIDRule() {
		return getIDAccess().getRule();
	}

	//// String to allow diverse re-use
	// // multiple leading zeroes occur as floating point fractional part
	// terminal INT:
	//	"0".."9"+;
	public TerminalRule getINTRule() {
		return gaEssentialOCL.getINTRule();
	} 

	//LOWER returns ecore::EInt:
	//	INT;
	public EssentialOCLGrammarAccess.LOWERElements getLOWERAccess() {
		return gaEssentialOCL.getLOWERAccess();
	}
	
	public ParserRule getLOWERRule() {
		return getLOWERAccess().getRule();
	}

	//UPPER returns ecore::EInt:
	//	INT | "*";
	public EssentialOCLGrammarAccess.UPPERElements getUPPERAccess() {
		return gaEssentialOCL.getUPPERAccess();
	}
	
	public ParserRule getUPPERRule() {
		return getUPPERAccess().getRule();
	}

	//// Not terminal to allow parser backtracking to sort out "5..7"
	//
	//// EssentialOCLTokenSource pieces this together ('.' INT)? (('e' | 'E') ('+' | '-')? INT)?;
	// NUMBER_LITERAL returns
	//BigNumber:
	//	INT;
	public EssentialOCLGrammarAccess.NUMBER_LITERALElements getNUMBER_LITERALAccess() {
		return gaEssentialOCL.getNUMBER_LITERALAccess();
	}
	
	public ParserRule getNUMBER_LITERALRule() {
		return getNUMBER_LITERALAccess().getRule();
	}

	//terminal ML_COMMENT:
	//	"/ *"->"* /";
	public TerminalRule getML_COMMENTRule() {
		return gaEssentialOCL.getML_COMMENTRule();
	} 

	//terminal SL_COMMENT:
	//	"--" !("\n" | "\r")* ("\r"? "\n")?;
	public TerminalRule getSL_COMMENTRule() {
		return gaEssentialOCL.getSL_COMMENTRule();
	} 

	//terminal WS:
	//	(" " | "\t" | "\r" | "\n")+;
	public TerminalRule getWSRule() {
		return gaEssentialOCL.getWSRule();
	} 

	//terminal ANY_OTHER:
	//	.;
	public TerminalRule getANY_OTHERRule() {
		return gaEssentialOCL.getANY_OTHERRule();
	} 

	//URI:
	//	SINGLE_QUOTED_STRING;
	public EssentialOCLGrammarAccess.URIElements getURIAccess() {
		return gaEssentialOCL.getURIAccess();
	}
	
	public ParserRule getURIRule() {
		return getURIAccess().getRule();
	}

	//EssentialOCLReservedKeyword:
	//	"and" | "else" | "endif" | "if" | "implies" | "in" | "let" | "not" | "or" | "then" | "xor";
	public EssentialOCLGrammarAccess.EssentialOCLReservedKeywordElements getEssentialOCLReservedKeywordAccess() {
		return gaEssentialOCL.getEssentialOCLReservedKeywordAccess();
	}
	
	public ParserRule getEssentialOCLReservedKeywordRule() {
		return getEssentialOCLReservedKeywordAccess().getRule();
	}

	//EssentialOCLUnaryOperatorCS returns UnaryOperatorCS:
	//	name=("-" | "not");
	public EssentialOCLGrammarAccess.EssentialOCLUnaryOperatorCSElements getEssentialOCLUnaryOperatorCSAccess() {
		return gaEssentialOCL.getEssentialOCLUnaryOperatorCSAccess();
	}
	
	public ParserRule getEssentialOCLUnaryOperatorCSRule() {
		return getEssentialOCLUnaryOperatorCSAccess().getRule();
	}

	//EssentialOCLInfixOperatorCS returns BinaryOperatorCS:
	//	name=("*" | "/" | "+" | "-" | ">" | "<" | ">=" | "<=" | "=" | "<>" | "and" | "or" | "xor" | "implies");
	public EssentialOCLGrammarAccess.EssentialOCLInfixOperatorCSElements getEssentialOCLInfixOperatorCSAccess() {
		return gaEssentialOCL.getEssentialOCLInfixOperatorCSAccess();
	}
	
	public ParserRule getEssentialOCLInfixOperatorCSRule() {
		return getEssentialOCLInfixOperatorCSAccess().getRule();
	}

	//EssentialOCLNavigationOperatorCS returns NavigationOperatorCS:
	//	name=("." | "->");
	public EssentialOCLGrammarAccess.EssentialOCLNavigationOperatorCSElements getEssentialOCLNavigationOperatorCSAccess() {
		return gaEssentialOCL.getEssentialOCLNavigationOperatorCSAccess();
	}
	
	public ParserRule getEssentialOCLNavigationOperatorCSRule() {
		return getEssentialOCLNavigationOperatorCSAccess().getRule();
	}

	//Identifier:
	//	ID;
	public EssentialOCLGrammarAccess.IdentifierElements getIdentifierAccess() {
		return gaEssentialOCL.getIdentifierAccess();
	}
	
	public ParserRule getIdentifierRule() {
		return getIdentifierAccess().getRule();
	}

	//StringLiteral:
	//	SINGLE_QUOTED_STRING;
	public EssentialOCLGrammarAccess.StringLiteralElements getStringLiteralAccess() {
		return gaEssentialOCL.getStringLiteralAccess();
	}
	
	public ParserRule getStringLiteralRule() {
		return getStringLiteralAccess().getRule();
	}

	//BinaryOperatorCS:
	//	InfixOperatorCS | NavigationOperatorCS;
	public EssentialOCLGrammarAccess.BinaryOperatorCSElements getBinaryOperatorCSAccess() {
		return gaEssentialOCL.getBinaryOperatorCSAccess();
	}
	
	public ParserRule getBinaryOperatorCSRule() {
		return getBinaryOperatorCSAccess().getRule();
	}

	//// Intended to be overrideable
	// InfixOperatorCS returns BinaryOperatorCS:
	//	EssentialOCLInfixOperatorCS;
	public EssentialOCLGrammarAccess.InfixOperatorCSElements getInfixOperatorCSAccess() {
		return gaEssentialOCL.getInfixOperatorCSAccess();
	}
	
	public ParserRule getInfixOperatorCSRule() {
		return getInfixOperatorCSAccess().getRule();
	}

	//// Intended to be overrideable
	// UnaryOperatorCS:
	//	EssentialOCLUnaryOperatorCS;
	public EssentialOCLGrammarAccess.UnaryOperatorCSElements getUnaryOperatorCSAccess() {
		return gaEssentialOCL.getUnaryOperatorCSAccess();
	}
	
	public ParserRule getUnaryOperatorCSRule() {
		return getUnaryOperatorCSAccess().getRule();
	}

	////---------------------------------------------------------------------
	// //  Names
	//
	////---------------------------------------------------------------------
	// EssentialOCLUnrestrictedName returns
	//ecore::EString:
	//	Identifier;
	public EssentialOCLGrammarAccess.EssentialOCLUnrestrictedNameElements getEssentialOCLUnrestrictedNameAccess() {
		return gaEssentialOCL.getEssentialOCLUnrestrictedNameAccess();
	}
	
	public ParserRule getEssentialOCLUnrestrictedNameRule() {
		return getEssentialOCLUnrestrictedNameAccess().getRule();
	}

	//EssentialOCLUnreservedName returns ecore::EString:
	//	UnrestrictedName | CollectionTypeIdentifier | PrimitiveTypeIdentifier | "Tuple";
	public EssentialOCLGrammarAccess.EssentialOCLUnreservedNameElements getEssentialOCLUnreservedNameAccess() {
		return gaEssentialOCL.getEssentialOCLUnreservedNameAccess();
	}
	
	public ParserRule getEssentialOCLUnreservedNameRule() {
		return getEssentialOCLUnreservedNameAccess().getRule();
	}

	//// Intended to be overridden
	// UnreservedName returns ecore::EString:
	//	EssentialOCLUnreservedName;
	public EssentialOCLGrammarAccess.UnreservedNameElements getUnreservedNameAccess() {
		return gaEssentialOCL.getUnreservedNameAccess();
	}
	
	public ParserRule getUnreservedNameRule() {
		return getUnreservedNameAccess().getRule();
	}

	//PathNameCS returns base::PathNameCS:
	//	path+=FirstPathElementCS ("::" path+=NextPathElementCS)*;
	public EssentialOCLGrammarAccess.PathNameCSElements getPathNameCSAccess() {
		return gaEssentialOCL.getPathNameCSAccess();
	}
	
	public ParserRule getPathNameCSRule() {
		return getPathNameCSAccess().getRule();
	}

	//FirstPathElementCS returns base::PathElementCS:
	//	element=[pivot::NamedElement|UnrestrictedName];
	public EssentialOCLGrammarAccess.FirstPathElementCSElements getFirstPathElementCSAccess() {
		return gaEssentialOCL.getFirstPathElementCSAccess();
	}
	
	public ParserRule getFirstPathElementCSRule() {
		return getFirstPathElementCSAccess().getRule();
	}

	//NextPathElementCS returns base::PathElementCS:
	//	element=[pivot::NamedElement|UnreservedName];
	public EssentialOCLGrammarAccess.NextPathElementCSElements getNextPathElementCSAccess() {
		return gaEssentialOCL.getNextPathElementCSAccess();
	}
	
	public ParserRule getNextPathElementCSRule() {
		return getNextPathElementCSAccess().getRule();
	}

	//URIPathNameCS returns base::PathNameCS:
	//	path+=URIFirstPathElementCS ("::" path+=NextPathElementCS)*;
	public EssentialOCLGrammarAccess.URIPathNameCSElements getURIPathNameCSAccess() {
		return gaEssentialOCL.getURIPathNameCSAccess();
	}
	
	public ParserRule getURIPathNameCSRule() {
		return getURIPathNameCSAccess().getRule();
	}

	//URIFirstPathElementCS returns base::PathElementCS:
	//	element=[pivot::NamedElement|UnrestrictedName] | {base::PathElementWithURICS} element=[pivot::Namespace|URI];
	public EssentialOCLGrammarAccess.URIFirstPathElementCSElements getURIFirstPathElementCSAccess() {
		return gaEssentialOCL.getURIFirstPathElementCSAccess();
	}
	
	public ParserRule getURIFirstPathElementCSRule() {
		return getURIFirstPathElementCSAccess().getRule();
	}

	//PrimitiveTypeCS returns base::PrimitiveTypeRefCS:
	//	name=PrimitiveTypeIdentifier;
	public EssentialOCLGrammarAccess.PrimitiveTypeCSElements getPrimitiveTypeCSAccess() {
		return gaEssentialOCL.getPrimitiveTypeCSAccess();
	}
	
	public ParserRule getPrimitiveTypeCSRule() {
		return getPrimitiveTypeCSAccess().getRule();
	}

	//CollectionTypeIdentifier returns ecore::EString:
	//	"Set" | "Bag" | "Sequence" | "Collection" | "OrderedSet";
	public EssentialOCLGrammarAccess.CollectionTypeIdentifierElements getCollectionTypeIdentifierAccess() {
		return gaEssentialOCL.getCollectionTypeIdentifierAccess();
	}
	
	public ParserRule getCollectionTypeIdentifierRule() {
		return getCollectionTypeIdentifierAccess().getRule();
	}

	//CollectionTypeCS:
	//	name=CollectionTypeIdentifier ("(" ownedType=TypeExpCS ")")?;
	public EssentialOCLGrammarAccess.CollectionTypeCSElements getCollectionTypeCSAccess() {
		return gaEssentialOCL.getCollectionTypeCSAccess();
	}
	
	public ParserRule getCollectionTypeCSRule() {
		return getCollectionTypeCSAccess().getRule();
	}

	//MultiplicityBoundsCS returns base::MultiplicityBoundsCS:
	//	lowerBound=LOWER (".." upperBound=UPPER)?;
	public EssentialOCLGrammarAccess.MultiplicityBoundsCSElements getMultiplicityBoundsCSAccess() {
		return gaEssentialOCL.getMultiplicityBoundsCSAccess();
	}
	
	public ParserRule getMultiplicityBoundsCSRule() {
		return getMultiplicityBoundsCSAccess().getRule();
	}

	//MultiplicityCS returns base::MultiplicityCS:
	//	"[" (MultiplicityBoundsCS | MultiplicityStringCS) "]";
	public EssentialOCLGrammarAccess.MultiplicityCSElements getMultiplicityCSAccess() {
		return gaEssentialOCL.getMultiplicityCSAccess();
	}
	
	public ParserRule getMultiplicityCSRule() {
		return getMultiplicityCSAccess().getRule();
	}

	//MultiplicityStringCS returns base::MultiplicityStringCS:
	//	stringBounds=("*" | "+" | "?");
	public EssentialOCLGrammarAccess.MultiplicityStringCSElements getMultiplicityStringCSAccess() {
		return gaEssentialOCL.getMultiplicityStringCSAccess();
	}
	
	public ParserRule getMultiplicityStringCSRule() {
		return getMultiplicityStringCSAccess().getRule();
	}

	//TupleTypeCS returns base::TupleTypeCS:
	//	name="Tuple" ("(" (ownedParts+=TuplePartCS ("," ownedParts+=TuplePartCS)*)? ")")?;
	public EssentialOCLGrammarAccess.TupleTypeCSElements getTupleTypeCSAccess() {
		return gaEssentialOCL.getTupleTypeCSAccess();
	}
	
	public ParserRule getTupleTypeCSRule() {
		return getTupleTypeCSAccess().getRule();
	}

	//TuplePartCS returns base::TuplePartCS:
	//	name=UnrestrictedName ":" ownedType=TypeExpCS;
	public EssentialOCLGrammarAccess.TuplePartCSElements getTuplePartCSAccess() {
		return gaEssentialOCL.getTuplePartCSAccess();
	}
	
	public ParserRule getTuplePartCSRule() {
		return getTuplePartCSAccess().getRule();
	}

	////---------------------------------------------------------------------
	// //  Literals
	//
	////---------------------------------------------------------------------
	// CollectionLiteralExpCS:
	//	ownedType=CollectionTypeCS "{" (ownedParts+=CollectionLiteralPartCS ("," ownedParts+=CollectionLiteralPartCS)*)? "}";
	public EssentialOCLGrammarAccess.CollectionLiteralExpCSElements getCollectionLiteralExpCSAccess() {
		return gaEssentialOCL.getCollectionLiteralExpCSAccess();
	}
	
	public ParserRule getCollectionLiteralExpCSRule() {
		return getCollectionLiteralExpCSAccess().getRule();
	}

	//CollectionLiteralPartCS:
	//	expressionCS=ExpCS (".." lastExpressionCS=ExpCS)?;
	public EssentialOCLGrammarAccess.CollectionLiteralPartCSElements getCollectionLiteralPartCSAccess() {
		return gaEssentialOCL.getCollectionLiteralPartCSAccess();
	}
	
	public ParserRule getCollectionLiteralPartCSRule() {
		return getCollectionLiteralPartCSAccess().getRule();
	}

	//ConstructorPartCS:
	//	property=[pivot::Property|UnrestrictedName] "=" initExpression=ExpCS;
	public EssentialOCLGrammarAccess.ConstructorPartCSElements getConstructorPartCSAccess() {
		return gaEssentialOCL.getConstructorPartCSAccess();
	}
	
	public ParserRule getConstructorPartCSRule() {
		return getConstructorPartCSAccess().getRule();
	}

	//PrimitiveLiteralExpCS:
	//	NumberLiteralExpCS | StringLiteralExpCS | BooleanLiteralExpCS | UnlimitedNaturalLiteralExpCS | InvalidLiteralExpCS |
	//	NullLiteralExpCS;
	public EssentialOCLGrammarAccess.PrimitiveLiteralExpCSElements getPrimitiveLiteralExpCSAccess() {
		return gaEssentialOCL.getPrimitiveLiteralExpCSAccess();
	}
	
	public ParserRule getPrimitiveLiteralExpCSRule() {
		return getPrimitiveLiteralExpCSAccess().getRule();
	}

	//TupleLiteralExpCS:
	//	"Tuple" "{" ownedParts+=TupleLiteralPartCS ("," ownedParts+=TupleLiteralPartCS)* "}";
	public EssentialOCLGrammarAccess.TupleLiteralExpCSElements getTupleLiteralExpCSAccess() {
		return gaEssentialOCL.getTupleLiteralExpCSAccess();
	}
	
	public ParserRule getTupleLiteralExpCSRule() {
		return getTupleLiteralExpCSAccess().getRule();
	}

	//TupleLiteralPartCS:
	//	name=UnrestrictedName (":" ownedType=TypeExpCS)? "=" initExpression=ExpCS;
	public EssentialOCLGrammarAccess.TupleLiteralPartCSElements getTupleLiteralPartCSAccess() {
		return gaEssentialOCL.getTupleLiteralPartCSAccess();
	}
	
	public ParserRule getTupleLiteralPartCSRule() {
		return getTupleLiteralPartCSAccess().getRule();
	}

	//NumberLiteralExpCS:
	//	name=NUMBER_LITERAL;
	public EssentialOCLGrammarAccess.NumberLiteralExpCSElements getNumberLiteralExpCSAccess() {
		return gaEssentialOCL.getNumberLiteralExpCSAccess();
	}
	
	public ParserRule getNumberLiteralExpCSRule() {
		return getNumberLiteralExpCSAccess().getRule();
	}

	//StringLiteralExpCS:
	//	name+=StringLiteral+;
	public EssentialOCLGrammarAccess.StringLiteralExpCSElements getStringLiteralExpCSAccess() {
		return gaEssentialOCL.getStringLiteralExpCSAccess();
	}
	
	public ParserRule getStringLiteralExpCSRule() {
		return getStringLiteralExpCSAccess().getRule();
	}

	//BooleanLiteralExpCS:
	//	name="true" | name="false";
	public EssentialOCLGrammarAccess.BooleanLiteralExpCSElements getBooleanLiteralExpCSAccess() {
		return gaEssentialOCL.getBooleanLiteralExpCSAccess();
	}
	
	public ParserRule getBooleanLiteralExpCSRule() {
		return getBooleanLiteralExpCSAccess().getRule();
	}

	//UnlimitedNaturalLiteralExpCS:
	//	{UnlimitedNaturalLiteralExpCS} "*";
	public EssentialOCLGrammarAccess.UnlimitedNaturalLiteralExpCSElements getUnlimitedNaturalLiteralExpCSAccess() {
		return gaEssentialOCL.getUnlimitedNaturalLiteralExpCSAccess();
	}
	
	public ParserRule getUnlimitedNaturalLiteralExpCSRule() {
		return getUnlimitedNaturalLiteralExpCSAccess().getRule();
	}

	//InvalidLiteralExpCS:
	//	{InvalidLiteralExpCS} "invalid";
	public EssentialOCLGrammarAccess.InvalidLiteralExpCSElements getInvalidLiteralExpCSAccess() {
		return gaEssentialOCL.getInvalidLiteralExpCSAccess();
	}
	
	public ParserRule getInvalidLiteralExpCSRule() {
		return getInvalidLiteralExpCSAccess().getRule();
	}

	//NullLiteralExpCS:
	//	{NullLiteralExpCS} "null";
	public EssentialOCLGrammarAccess.NullLiteralExpCSElements getNullLiteralExpCSAccess() {
		return gaEssentialOCL.getNullLiteralExpCSAccess();
	}
	
	public ParserRule getNullLiteralExpCSRule() {
		return getNullLiteralExpCSAccess().getRule();
	}

	//TypeLiteralCS returns base::TypedRefCS:
	//	PrimitiveTypeCS | CollectionTypeCS | TupleTypeCS;
	public EssentialOCLGrammarAccess.TypeLiteralCSElements getTypeLiteralCSAccess() {
		return gaEssentialOCL.getTypeLiteralCSAccess();
	}
	
	public ParserRule getTypeLiteralCSRule() {
		return getTypeLiteralCSAccess().getRule();
	}

	//TypeLiteralWithMultiplicityCS returns base::TypedRefCS:
	//	TypeLiteralCS multiplicity=MultiplicityCS?;
	public EssentialOCLGrammarAccess.TypeLiteralWithMultiplicityCSElements getTypeLiteralWithMultiplicityCSAccess() {
		return gaEssentialOCL.getTypeLiteralWithMultiplicityCSAccess();
	}
	
	public ParserRule getTypeLiteralWithMultiplicityCSRule() {
		return getTypeLiteralWithMultiplicityCSAccess().getRule();
	}

	//TypeLiteralExpCS:
	//	ownedType=TypeLiteralWithMultiplicityCS;
	public EssentialOCLGrammarAccess.TypeLiteralExpCSElements getTypeLiteralExpCSAccess() {
		return gaEssentialOCL.getTypeLiteralExpCSAccess();
	}
	
	public ParserRule getTypeLiteralExpCSRule() {
		return getTypeLiteralExpCSAccess().getRule();
	}

	//TypeNameExpCS:
	//	pathName=PathNameCS;
	public EssentialOCLGrammarAccess.TypeNameExpCSElements getTypeNameExpCSAccess() {
		return gaEssentialOCL.getTypeNameExpCSAccess();
	}
	
	public ParserRule getTypeNameExpCSRule() {
		return getTypeNameExpCSAccess().getRule();
	}

	//TypeExpCS returns base::TypedRefCS:
	//	(TypeNameExpCS | TypeLiteralCS) multiplicity=MultiplicityCS?;
	public EssentialOCLGrammarAccess.TypeExpCSElements getTypeExpCSAccess() {
		return gaEssentialOCL.getTypeExpCSAccess();
	}
	
	public ParserRule getTypeExpCSRule() {
		return getTypeExpCSAccess().getRule();
	}

	////---------------------------------------------------------------------
	// //  Expressions
	//
	////---------------------------------------------------------------------
	//
	//// An ExpCS permits a LetExpCS only in the final term to ensure
	//
	////  that let is right associative, whereas infix operators are left associative.
	//
	////   a = 64 / 16 / let b : Integer in 8 / let c : Integer in 4 
	// // is
	//
	////   a = (64 / 16) / (let b : Integer in 8 / (let c : Integer in 4 ))
	// ExpCS:
	//	PrefixedExpCS ({InfixExpCS.ownedExpression+=current} ownedOperator+=BinaryOperatorCS (ownedExpression+=PrefixedExpCS
	//	(ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)* (ownedOperator+=BinaryOperatorCS
	//	ownedExpression+=LetExpCS)? | ownedExpression+=LetExpCS))? | {PrefixExpCS} ownedOperator+=UnaryOperatorCS+
	//	ownedExpression=LetExpCS | LetExpCS;
	public EssentialOCLGrammarAccess.ExpCSElements getExpCSAccess() {
		return gaEssentialOCL.getExpCSAccess();
	}
	
	public ParserRule getExpCSRule() {
		return getExpCSAccess().getRule();
	}

	//PrefixedExpCS returns ExpCS:
	//	{PrefixExpCS} ownedOperator+=UnaryOperatorCS+ ownedExpression=PrimaryExpCS | PrimaryExpCS;
	public EssentialOCLGrammarAccess.PrefixedExpCSElements getPrefixedExpCSAccess() {
		return gaEssentialOCL.getPrefixedExpCSAccess();
	}
	
	public ParserRule getPrefixedExpCSRule() {
		return getPrefixedExpCSAccess().getRule();
	}

	//PrimaryExpCS returns ExpCS:
	//	NestedExpCS | IfExpCS | SelfExpCS | PrimitiveLiteralExpCS | TupleLiteralExpCS | CollectionLiteralExpCS |
	//	TypeLiteralExpCS | {NameExpCS} pathName=PathNameCS ({IndexExpCS.nameExp=current} "[" firstIndexes+=ExpCS (","
	//	firstIndexes+=ExpCS)* "]" ("[" secondIndexes+=ExpCS ("," secondIndexes+=ExpCS)* "]")? (atPre?="@" "pre")? |
	//	{ConstructorExpCS.nameExp=current} "{" ((ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)? |
	//	value=StringLiteral) "}" | (atPre?="@" "pre")? ({InvocationExpCS.nameExp=current} "(" (argument+=NavigatingArgCS
	//	argument+=NavigatingCommaArgCS* (argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)?
	//	(argument+=NavigatingBarArgCS argument+=NavigatingCommaArgCS*)?)? ")")?);
	public EssentialOCLGrammarAccess.PrimaryExpCSElements getPrimaryExpCSAccess() {
		return gaEssentialOCL.getPrimaryExpCSAccess();
	}
	
	public ParserRule getPrimaryExpCSRule() {
		return getPrimaryExpCSAccess().getRule();
	}

	//// Type-less init is an illegal infix expression
	// NavigatingArgCS:
	//	name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
	public EssentialOCLGrammarAccess.NavigatingArgCSElements getNavigatingArgCSAccess() {
		return gaEssentialOCL.getNavigatingArgCSAccess();
	}
	
	public ParserRule getNavigatingArgCSRule() {
		return getNavigatingArgCSAccess().getRule();
	}

	//// Type-less init is an illegal infix expression
	// NavigatingBarArgCS returns NavigatingArgCS:
	//	prefix="|" name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
	public EssentialOCLGrammarAccess.NavigatingBarArgCSElements getNavigatingBarArgCSAccess() {
		return gaEssentialOCL.getNavigatingBarArgCSAccess();
	}
	
	public ParserRule getNavigatingBarArgCSRule() {
		return getNavigatingBarArgCSAccess().getRule();
	}

	//// Type-less init is an illegal infix expression
	// NavigatingCommaArgCS returns NavigatingArgCS:
	//	prefix="," name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
	public EssentialOCLGrammarAccess.NavigatingCommaArgCSElements getNavigatingCommaArgCSAccess() {
		return gaEssentialOCL.getNavigatingCommaArgCSAccess();
	}
	
	public ParserRule getNavigatingCommaArgCSRule() {
		return getNavigatingCommaArgCSAccess().getRule();
	}

	//// Type-less init is an illegal infix expression
	// NavigatingSemiArgCS returns NavigatingArgCS:
	//	prefix=";" name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
	public EssentialOCLGrammarAccess.NavigatingSemiArgCSElements getNavigatingSemiArgCSAccess() {
		return gaEssentialOCL.getNavigatingSemiArgCSAccess();
	}
	
	public ParserRule getNavigatingSemiArgCSRule() {
		return getNavigatingSemiArgCSAccess().getRule();
	}

	//IfExpCS:
	//	"if" condition=ExpCS "then" thenExpression=ExpCS "else" elseExpression=ExpCS "endif";
	public EssentialOCLGrammarAccess.IfExpCSElements getIfExpCSAccess() {
		return gaEssentialOCL.getIfExpCSAccess();
	}
	
	public ParserRule getIfExpCSRule() {
		return getIfExpCSAccess().getRule();
	}

	//LetExpCS:
	//	"let" variable+=LetVariableCS ("," variable+=LetVariableCS)* "in" in=ExpCS;
	public EssentialOCLGrammarAccess.LetExpCSElements getLetExpCSAccess() {
		return gaEssentialOCL.getLetExpCSAccess();
	}
	
	public ParserRule getLetExpCSRule() {
		return getLetExpCSAccess().getRule();
	}

	//LetVariableCS:
	//	name=UnrestrictedName (":" ownedType=TypeExpCS)? "=" initExpression=ExpCS;
	public EssentialOCLGrammarAccess.LetVariableCSElements getLetVariableCSAccess() {
		return gaEssentialOCL.getLetVariableCSAccess();
	}
	
	public ParserRule getLetVariableCSRule() {
		return getLetVariableCSAccess().getRule();
	}

	//NestedExpCS:
	//	"(" source=ExpCS ")";
	public EssentialOCLGrammarAccess.NestedExpCSElements getNestedExpCSAccess() {
		return gaEssentialOCL.getNestedExpCSAccess();
	}
	
	public ParserRule getNestedExpCSRule() {
		return getNestedExpCSAccess().getRule();
	}

	//SelfExpCS:
	//	{SelfExpCS} "self";
	public EssentialOCLGrammarAccess.SelfExpCSElements getSelfExpCSAccess() {
		return gaEssentialOCL.getSelfExpCSAccess();
	}
	
	public ParserRule getSelfExpCSRule() {
		return getSelfExpCSAccess().getRule();
	}
}
