/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.basecs.ParameterCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.AliasAnalysis;
import org.eclipse.ocl.examples.xtext.base.scoping.QualifiedPath;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.ClassifierContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.CompleteOCLDocumentCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.DefCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.DefOperationCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.DefPropertyCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.OperationContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.PackageDeclarationCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.PropertyContextDeclCS;
import org.eclipse.ocl.examples.xtext.essentialocl.ui.labeling.EssentialOCLLabelProvider;

public class CompleteOCLLabelProvider
extends EssentialOCLLabelProvider {
    @Inject
    public CompleteOCLLabelProvider(@NonNull AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected String image(ClassifierContextDeclCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Class.gif";
    }

    protected String text(ClassifierContextDeclCS ele) {
        Type classifier = ele.getClassifier();
        if (classifier == null) {
            return "<<null>>";
        }
        if (classifier.eIsProxy()) {
            return "<<unresolved-proxy>>";
        }
        return classifier.getName();
    }

    protected String image(CompleteOCLDocumentCS ele) {
        return "/org.eclipse.ocl.examples.xtext.completeocl.ui/icons/OCLModelFile.gif";
    }

    protected String text(CompleteOCLDocumentCS ele) {
        Root root = (Root)PivotUtil.getPivot(Root.class, (Pivotable)ele);
        return root != null ? String.valueOf(root.getName()) : "null";
    }

    protected String image(DefCS ele) {
        return "/org.eclipse.ocl.examples.xtext.oclinecore.ui/icons/full/obj16/DefinitionConstraint.gif";
    }

    protected String text(DefCS ele) {
        StringBuilder s = new StringBuilder();
        s.append("def ");
        this.appendOptionalString(s, ele.getName());
        s.append(": ");
        return s.toString();
    }

    protected String text(DefOperationCS ele) {
        StringBuilder s = new StringBuilder();
        this.appendString(s, ele.getName());
        EList parameters = ele.getParameters();
        if (!parameters.isEmpty()) {
            s.append("(");
            String prefix = "";
            for (ParameterCS csParameter : parameters) {
                s.append(prefix);
                this.appendType(s, (TypeRefCS)csParameter.getOwnedType());
                prefix = ", ";
            }
            s.append(")");
        }
        s.append(" : ");
        TypedRefCS ownedType = ele.getOwnedType();
        if (ownedType != null) {
            this.appendType(s, (TypeRefCS)ownedType);
        }
        return s.toString();
    }

    protected String text(DefPropertyCS ele) {
        StringBuilder s = new StringBuilder();
        this.appendString(s, ele.getName());
        s.append(" : ");
        this.appendType(s, (TypeRefCS)ele.getOwnedType());
        return s.toString();
    }

    protected String image(OperationContextDeclCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Operation.gif";
    }

    protected String text(OperationContextDeclCS ele) {
        StringBuilder s = new StringBuilder();
        Operation operation = ele.getOperation();
        if (operation == null) {
            return "<<null>>";
        }
        if (operation.eIsProxy()) {
            return "<<unresolved-proxy>>";
        }
        this.appendName(s, (NamedElement)PivotUtil.getOwningType((Feature)operation));
        s.append("::");
        this.appendName(s, (NamedElement)operation);
        s.append("(");
        String prefix = "";
        for (Parameter parameter : operation.getOwnedParameter()) {
            s.append(prefix);
            this.appendType(s, parameter.getType());
            prefix = ", ";
        }
        s.append(")");
        s.append(" : ");
        this.appendType(s, operation.getType());
        return s.toString();
    }

    protected String image(PackageDeclarationCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Package.gif";
    }

    protected String text(PackageDeclarationCS ele) {
        assert (ele != null);
        Resource eResource = ele.eResource();
        if (eResource == null) {
            return "<<null>>";
        }
        MetaModelManager metaModelManager = PivotUtil.findMetaModelManager((Resource)eResource);
        if (metaModelManager == null) {
            return "<<null>>";
        }
        AliasAnalysis aliasAnalysis = AliasAnalysis.getAdapter((Resource)eResource, (MetaModelManager)metaModelManager);
        Package pivot = ele.getPackage();
        if (pivot == null) {
            return "<<null>>";
        }
        QualifiedPath contextPath = new QualifiedPath(aliasAnalysis.getPath((Element)pivot));
        return contextPath.toString();
    }

    protected String image(PropertyContextDeclCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Property.gif";
    }

    protected String text(PropertyContextDeclCS ele) {
        StringBuilder s = new StringBuilder();
        Property feature = ele.getProperty();
        if (feature == null) {
            return "<<null>>";
        }
        if (feature.eIsProxy()) {
            return "<<unresolved-proxy>>";
        }
        this.appendName(s, (NamedElement)PivotUtil.getOwningType((Feature)feature));
        s.append("::");
        this.appendName(s, (NamedElement)feature);
        s.append(" : ");
        this.appendType(s, feature.getType());
        return s.toString();
    }
}

