/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.ui.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.xtext.base.ui.wizards.AbstractFileDialog;
import org.eclipse.ocl.examples.xtext.base.ui.wizards.AbstractFileNewWizard;
import org.eclipse.ocl.examples.xtext.base.ui.wizards.AbstractFileNewWizardPage;
import org.eclipse.ocl.examples.xtext.completeocl.ui.messages.CompleteOCLUIMessages;
import org.eclipse.ocl.examples.xtext.completeocl.ui.wizards.CompleteOCLFileDialog;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class CompleteOCLFileNewWizard
extends AbstractFileNewWizard {
    @NonNull
    protected CompleteOCLFileDialog createDialog(@NonNull AbstractFileNewWizardPage wizardPage, @Nullable IResource initialSelection) {
        return new CompleteOCLFileDialog(this, wizardPage, initialSelection);
    }

    protected String getEditorId() {
        return "org.eclipse.ocl.examples.xtext.completeocl.CompleteOCL";
    }

    @NonNull
    public String getInitialContentsAsString(@NonNull IFile newFile, @NonNull AbstractFileDialog dialog) {
        String firstPackageName = null;
        String firstTypeName = null;
        String firstPropertyName = null;
        StringBuilder s = new StringBuilder();
        List uris = dialog.getURIs();
        if (uris.size() > 0) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI newURI = URI.createPlatformResourceURI((String)newFile.getFullPath().toString(), (boolean)true);
            block2: for (URI uri : uris) {
                URI deresolvedURI = uri.deresolve(newURI);
                try {
                    Resource resource = resourceSet.getResource(uri, true);
                    s.append("import '" + ValuesUtil.oclToString((Object)deresolvedURI) + "'\n");
                    if (firstPropertyName != null) continue;
                    for (EObject eObject : resource.getContents()) {
                        Iterator iterator;
                        if (eObject instanceof Package) {
                            Package umlPackage = (Package)eObject;
                            if (firstPackageName == null) {
                                firstPackageName = umlPackage.getName();
                            }
                            for (Type umlType : umlPackage.getOwnedTypes()) {
                                if (firstTypeName == null) {
                                    firstTypeName = umlType.getName();
                                    firstPackageName = umlPackage.getName();
                                }
                                if (umlType instanceof Class && (iterator = ((Class)umlType).getOwnedAttributes().iterator()).hasNext()) {
                                    Property umlProperty = (Property)iterator.next();
                                    firstPropertyName = umlProperty.getName();
                                    firstTypeName = umlType.getName();
                                    firstPackageName = umlPackage.getName();
                                }
                                if (firstPropertyName == null) {
                                    continue;
                                }
                                break;
                            }
                        } else if (eObject instanceof EPackage) {
                            EPackage ePackage = (EPackage)eObject;
                            if (firstPackageName == null) {
                                firstPackageName = ePackage.getName();
                            }
                            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                                if (firstTypeName == null) {
                                    firstTypeName = eClassifier.getName();
                                    firstPackageName = ePackage.getName();
                                }
                                if (eClassifier instanceof EClass && (iterator = ((EClass)eClassifier).getEAllStructuralFeatures().iterator()).hasNext()) {
                                    EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
                                    firstPropertyName = eStructuralFeature.getName();
                                    firstTypeName = eClassifier.getName();
                                    firstPackageName = ePackage.getName();
                                }
                                if (firstPropertyName == null) {
                                    continue;
                                }
                                break;
                            }
                        }
                        if (firstPropertyName != null) continue block2;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            s.append("\n");
        }
        if (firstPackageName == null) {
            firstPackageName = "undefined_root_package_name";
        }
        if (firstTypeName == null) {
            firstTypeName = "Example";
        }
        if (firstPropertyName == null) {
            firstPropertyName = "feature";
        }
        s.append("package " + firstPackageName + "\n");
        s.append("\n");
        s.append("context " + firstTypeName + "\n");
        s.append("--\n");
        s.append("-- example invariant with a custom error message to verify that\n");
        s.append("-- the '" + firstPropertyName + "' property of all '" + firstPackageName + "::" + firstTypeName + "' instances is non-null\n");
        s.append("--\n");
        s.append("inv NonNull_" + firstPropertyName + "('The \\'" + firstPropertyName + "\\' property of \"' + self.toString() + '\" is null'):\n");
        s.append("\t" + firstPropertyName + " <> null\n");
        s.append("\n");
        s.append("endpackage\n");
        String string = s.toString();
        return string;
    }

    @NonNull
    public String getNewFileExtension() {
        return "ocl";
    }

    @NonNull
    public String getNewFileName() {
        return CompleteOCLUIMessages.NewWizardPage_defaultFileName;
    }

    @NonNull
    public String getNewFileLabel() {
        return CompleteOCLUIMessages.NewWizardPage_fileNameLabel;
    }

    @NonNull
    public String getPageDescription() {
        return CompleteOCLUIMessages.NewWizardPage_pageDescription;
    }

    @NonNull
    public String getPageSummary() {
        return CompleteOCLUIMessages.NewWizardPage_pageSummary;
    }

    @NonNull
    public String getPageTitle() {
        return CompleteOCLUIMessages.NewWizardPage_pageTitle;
    }
}

