/*******************************************************************************
 * Copyright (c) 2014 E.D.Willink and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *******************************************************************************/
/*
* generated by Xtext
*/
package org.eclipse.ocl.examples.xtext.essentialocl.services;

import com.google.inject.Singleton;
import com.google.inject.Inject;

import java.util.List;

import org.eclipse.xtext.*;
import org.eclipse.xtext.service.GrammarProvider;
import org.eclipse.xtext.service.AbstractElementFinder.*;


@Singleton
public class EssentialOCLGrammarAccess extends AbstractGrammarElementFinder {
	
	
	public class ModelElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "Model");
		private final Assignment cOwnedExpressionAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cOwnedExpressionExpCSParserRuleCall_0 = (RuleCall)cOwnedExpressionAssignment.eContents().get(0);
		
		////generate essentialOCLCST "http://www.eclipse.org/ocl/3.0.0/EssentialOCLCST"
		// Model returns ContextCS:
		//	ownedExpression=ExpCS;
		public ParserRule getRule() { return rule; }

		//ownedExpression=ExpCS
		public Assignment getOwnedExpressionAssignment() { return cOwnedExpressionAssignment; }

		//ExpCS
		public RuleCall getOwnedExpressionExpCSParserRuleCall_0() { return cOwnedExpressionExpCSParserRuleCall_0; }
	}

	public class IDElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "ID");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cSIMPLE_IDTerminalRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cESCAPED_IDTerminalRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//ID:
		//	SIMPLE_ID | ESCAPED_ID;
		public ParserRule getRule() { return rule; }

		//SIMPLE_ID | ESCAPED_ID
		public Alternatives getAlternatives() { return cAlternatives; }

		//SIMPLE_ID
		public RuleCall getSIMPLE_IDTerminalRuleCall_0() { return cSIMPLE_IDTerminalRuleCall_0; }

		//ESCAPED_ID
		public RuleCall getESCAPED_IDTerminalRuleCall_1() { return cESCAPED_IDTerminalRuleCall_1; }
	}

	public class LOWERElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "LOWER");
		private final RuleCall cINTTerminalRuleCall = (RuleCall)rule.eContents().get(1);
		
		//LOWER returns ecore::EInt:
		//	INT;
		public ParserRule getRule() { return rule; }

		//INT
		public RuleCall getINTTerminalRuleCall() { return cINTTerminalRuleCall; }
	}

	public class UPPERElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "UPPER");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cINTTerminalRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final Keyword cAsteriskKeyword_1 = (Keyword)cAlternatives.eContents().get(1);
		
		//UPPER returns ecore::EInt:
		//	INT | "*";
		public ParserRule getRule() { return rule; }

		//INT | "*"
		public Alternatives getAlternatives() { return cAlternatives; }

		//INT
		public RuleCall getINTTerminalRuleCall_0() { return cINTTerminalRuleCall_0; }

		//"*"
		public Keyword getAsteriskKeyword_1() { return cAsteriskKeyword_1; }
	}

	public class NUMBER_LITERALElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "NUMBER_LITERAL");
		private final RuleCall cINTTerminalRuleCall = (RuleCall)rule.eContents().get(1);
		
		//// Not terminal to allow parser backtracking to sort out "5..7"
		//
		//// EssentialOCLTokenSource pieces this together ('.' INT)? (('e' | 'E') ('+' | '-')? INT)?;
		// NUMBER_LITERAL returns
		//BigNumber:
		//	INT;
		public ParserRule getRule() { return rule; }

		//INT
		public RuleCall getINTTerminalRuleCall() { return cINTTerminalRuleCall; }
	}

	public class URIElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "URI");
		private final RuleCall cSINGLE_QUOTED_STRINGTerminalRuleCall = (RuleCall)rule.eContents().get(1);
		
		//URI:
		//	SINGLE_QUOTED_STRING;
		public ParserRule getRule() { return rule; }

		//SINGLE_QUOTED_STRING
		public RuleCall getSINGLE_QUOTED_STRINGTerminalRuleCall() { return cSINGLE_QUOTED_STRINGTerminalRuleCall; }
	}

	public class EssentialOCLReservedKeywordElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "EssentialOCLReservedKeyword");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Keyword cAndKeyword_0 = (Keyword)cAlternatives.eContents().get(0);
		private final Keyword cElseKeyword_1 = (Keyword)cAlternatives.eContents().get(1);
		private final Keyword cEndifKeyword_2 = (Keyword)cAlternatives.eContents().get(2);
		private final Keyword cIfKeyword_3 = (Keyword)cAlternatives.eContents().get(3);
		private final Keyword cImpliesKeyword_4 = (Keyword)cAlternatives.eContents().get(4);
		private final Keyword cInKeyword_5 = (Keyword)cAlternatives.eContents().get(5);
		private final Keyword cLetKeyword_6 = (Keyword)cAlternatives.eContents().get(6);
		private final Keyword cNotKeyword_7 = (Keyword)cAlternatives.eContents().get(7);
		private final Keyword cOrKeyword_8 = (Keyword)cAlternatives.eContents().get(8);
		private final Keyword cThenKeyword_9 = (Keyword)cAlternatives.eContents().get(9);
		private final Keyword cXorKeyword_10 = (Keyword)cAlternatives.eContents().get(10);
		
		//EssentialOCLReservedKeyword:
		//	"and" | "else" | "endif" | "if" | "implies" | "in" | "let" | "not" | "or" | "then" | "xor";
		public ParserRule getRule() { return rule; }

		//"and" | "else" | "endif" | "if" | "implies" | "in" | "let" | "not" | "or" | "then" | "xor"
		public Alternatives getAlternatives() { return cAlternatives; }

		//"and"
		public Keyword getAndKeyword_0() { return cAndKeyword_0; }

		//"else"
		public Keyword getElseKeyword_1() { return cElseKeyword_1; }

		//"endif"
		public Keyword getEndifKeyword_2() { return cEndifKeyword_2; }

		//"if"
		public Keyword getIfKeyword_3() { return cIfKeyword_3; }

		//"implies"
		public Keyword getImpliesKeyword_4() { return cImpliesKeyword_4; }

		//"in"
		public Keyword getInKeyword_5() { return cInKeyword_5; }

		//"let"
		public Keyword getLetKeyword_6() { return cLetKeyword_6; }

		//"not"
		public Keyword getNotKeyword_7() { return cNotKeyword_7; }

		//"or"
		public Keyword getOrKeyword_8() { return cOrKeyword_8; }

		//"then"
		public Keyword getThenKeyword_9() { return cThenKeyword_9; }

		//"xor"
		public Keyword getXorKeyword_10() { return cXorKeyword_10; }
	}

	public class EssentialOCLUnaryOperatorCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "EssentialOCLUnaryOperatorCS");
		private final Assignment cNameAssignment = (Assignment)rule.eContents().get(1);
		private final Alternatives cNameAlternatives_0 = (Alternatives)cNameAssignment.eContents().get(0);
		private final Keyword cNameHyphenMinusKeyword_0_0 = (Keyword)cNameAlternatives_0.eContents().get(0);
		private final Keyword cNameNotKeyword_0_1 = (Keyword)cNameAlternatives_0.eContents().get(1);
		
		//EssentialOCLUnaryOperatorCS returns UnaryOperatorCS:
		//	name=("-" | "not");
		public ParserRule getRule() { return rule; }

		//name=("-" | "not")
		public Assignment getNameAssignment() { return cNameAssignment; }

		//"-" | "not"
		public Alternatives getNameAlternatives_0() { return cNameAlternatives_0; }

		//"-"
		public Keyword getNameHyphenMinusKeyword_0_0() { return cNameHyphenMinusKeyword_0_0; }

		//"not"
		public Keyword getNameNotKeyword_0_1() { return cNameNotKeyword_0_1; }
	}

	public class EssentialOCLInfixOperatorCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "EssentialOCLInfixOperatorCS");
		private final Assignment cNameAssignment = (Assignment)rule.eContents().get(1);
		private final Alternatives cNameAlternatives_0 = (Alternatives)cNameAssignment.eContents().get(0);
		private final Keyword cNameAsteriskKeyword_0_0 = (Keyword)cNameAlternatives_0.eContents().get(0);
		private final Keyword cNameSolidusKeyword_0_1 = (Keyword)cNameAlternatives_0.eContents().get(1);
		private final Keyword cNamePlusSignKeyword_0_2 = (Keyword)cNameAlternatives_0.eContents().get(2);
		private final Keyword cNameHyphenMinusKeyword_0_3 = (Keyword)cNameAlternatives_0.eContents().get(3);
		private final Keyword cNameGreaterThanSignKeyword_0_4 = (Keyword)cNameAlternatives_0.eContents().get(4);
		private final Keyword cNameLessThanSignKeyword_0_5 = (Keyword)cNameAlternatives_0.eContents().get(5);
		private final Keyword cNameGreaterThanSignEqualsSignKeyword_0_6 = (Keyword)cNameAlternatives_0.eContents().get(6);
		private final Keyword cNameLessThanSignEqualsSignKeyword_0_7 = (Keyword)cNameAlternatives_0.eContents().get(7);
		private final Keyword cNameEqualsSignKeyword_0_8 = (Keyword)cNameAlternatives_0.eContents().get(8);
		private final Keyword cNameLessThanSignGreaterThanSignKeyword_0_9 = (Keyword)cNameAlternatives_0.eContents().get(9);
		private final Keyword cNameAndKeyword_0_10 = (Keyword)cNameAlternatives_0.eContents().get(10);
		private final Keyword cNameOrKeyword_0_11 = (Keyword)cNameAlternatives_0.eContents().get(11);
		private final Keyword cNameXorKeyword_0_12 = (Keyword)cNameAlternatives_0.eContents().get(12);
		private final Keyword cNameImpliesKeyword_0_13 = (Keyword)cNameAlternatives_0.eContents().get(13);
		
		//EssentialOCLInfixOperatorCS returns BinaryOperatorCS:
		//	name=("*" | "/" | "+" | "-" | ">" | "<" | ">=" | "<=" | "=" | "<>" | "and" | "or" | "xor" | "implies");
		public ParserRule getRule() { return rule; }

		//name=("*" | "/" | "+" | "-" | ">" | "<" | ">=" | "<=" | "=" | "<>" | "and" | "or" | "xor" | "implies")
		public Assignment getNameAssignment() { return cNameAssignment; }

		//"*" | "/" | "+" | "-" | ">" | "<" | ">=" | "<=" | "=" | "<>" | "and" | "or" | "xor" | "implies"
		public Alternatives getNameAlternatives_0() { return cNameAlternatives_0; }

		//"*"
		public Keyword getNameAsteriskKeyword_0_0() { return cNameAsteriskKeyword_0_0; }

		//"/"
		public Keyword getNameSolidusKeyword_0_1() { return cNameSolidusKeyword_0_1; }

		//"+"
		public Keyword getNamePlusSignKeyword_0_2() { return cNamePlusSignKeyword_0_2; }

		//"-"
		public Keyword getNameHyphenMinusKeyword_0_3() { return cNameHyphenMinusKeyword_0_3; }

		//">"
		public Keyword getNameGreaterThanSignKeyword_0_4() { return cNameGreaterThanSignKeyword_0_4; }

		//"<"
		public Keyword getNameLessThanSignKeyword_0_5() { return cNameLessThanSignKeyword_0_5; }

		//">="
		public Keyword getNameGreaterThanSignEqualsSignKeyword_0_6() { return cNameGreaterThanSignEqualsSignKeyword_0_6; }

		//"<="
		public Keyword getNameLessThanSignEqualsSignKeyword_0_7() { return cNameLessThanSignEqualsSignKeyword_0_7; }

		//"="
		public Keyword getNameEqualsSignKeyword_0_8() { return cNameEqualsSignKeyword_0_8; }

		//"<>"
		public Keyword getNameLessThanSignGreaterThanSignKeyword_0_9() { return cNameLessThanSignGreaterThanSignKeyword_0_9; }

		//"and"
		public Keyword getNameAndKeyword_0_10() { return cNameAndKeyword_0_10; }

		//"or"
		public Keyword getNameOrKeyword_0_11() { return cNameOrKeyword_0_11; }

		//"xor"
		public Keyword getNameXorKeyword_0_12() { return cNameXorKeyword_0_12; }

		//"implies"
		public Keyword getNameImpliesKeyword_0_13() { return cNameImpliesKeyword_0_13; }
	}

	public class EssentialOCLNavigationOperatorCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "EssentialOCLNavigationOperatorCS");
		private final Assignment cNameAssignment = (Assignment)rule.eContents().get(1);
		private final Alternatives cNameAlternatives_0 = (Alternatives)cNameAssignment.eContents().get(0);
		private final Keyword cNameFullStopKeyword_0_0 = (Keyword)cNameAlternatives_0.eContents().get(0);
		private final Keyword cNameHyphenMinusGreaterThanSignKeyword_0_1 = (Keyword)cNameAlternatives_0.eContents().get(1);
		
		//EssentialOCLNavigationOperatorCS returns NavigationOperatorCS:
		//	name=("." | "->");
		public ParserRule getRule() { return rule; }

		//name=("." | "->")
		public Assignment getNameAssignment() { return cNameAssignment; }

		//"." | "->"
		public Alternatives getNameAlternatives_0() { return cNameAlternatives_0; }

		//"."
		public Keyword getNameFullStopKeyword_0_0() { return cNameFullStopKeyword_0_0; }

		//"->"
		public Keyword getNameHyphenMinusGreaterThanSignKeyword_0_1() { return cNameHyphenMinusGreaterThanSignKeyword_0_1; }
	}

	public class IdentifierElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "Identifier");
		private final RuleCall cIDParserRuleCall = (RuleCall)rule.eContents().get(1);
		
		//Identifier:
		//	ID;
		public ParserRule getRule() { return rule; }

		//ID
		public RuleCall getIDParserRuleCall() { return cIDParserRuleCall; }
	}

	public class StringLiteralElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "StringLiteral");
		private final RuleCall cSINGLE_QUOTED_STRINGTerminalRuleCall = (RuleCall)rule.eContents().get(1);
		
		//StringLiteral:
		//	SINGLE_QUOTED_STRING;
		public ParserRule getRule() { return rule; }

		//SINGLE_QUOTED_STRING
		public RuleCall getSINGLE_QUOTED_STRINGTerminalRuleCall() { return cSINGLE_QUOTED_STRINGTerminalRuleCall; }
	}

	public class BinaryOperatorCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "BinaryOperatorCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cInfixOperatorCSParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cNavigationOperatorCSParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//BinaryOperatorCS:
		//	InfixOperatorCS | NavigationOperatorCS;
		public ParserRule getRule() { return rule; }

		//InfixOperatorCS | NavigationOperatorCS
		public Alternatives getAlternatives() { return cAlternatives; }

		//InfixOperatorCS
		public RuleCall getInfixOperatorCSParserRuleCall_0() { return cInfixOperatorCSParserRuleCall_0; }

		//NavigationOperatorCS
		public RuleCall getNavigationOperatorCSParserRuleCall_1() { return cNavigationOperatorCSParserRuleCall_1; }
	}

	public class InfixOperatorCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "InfixOperatorCS");
		private final RuleCall cEssentialOCLInfixOperatorCSParserRuleCall = (RuleCall)rule.eContents().get(1);
		
		//// Intended to be overrideable
		// InfixOperatorCS returns BinaryOperatorCS:
		//	EssentialOCLInfixOperatorCS;
		public ParserRule getRule() { return rule; }

		//EssentialOCLInfixOperatorCS
		public RuleCall getEssentialOCLInfixOperatorCSParserRuleCall() { return cEssentialOCLInfixOperatorCSParserRuleCall; }
	}

	public class NavigationOperatorCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "NavigationOperatorCS");
		private final RuleCall cEssentialOCLNavigationOperatorCSParserRuleCall = (RuleCall)rule.eContents().get(1);
		
		//// Intended to be overrideable
		// NavigationOperatorCS:
		//	EssentialOCLNavigationOperatorCS;
		public ParserRule getRule() { return rule; }

		//EssentialOCLNavigationOperatorCS
		public RuleCall getEssentialOCLNavigationOperatorCSParserRuleCall() { return cEssentialOCLNavigationOperatorCSParserRuleCall; }
	}

	public class UnaryOperatorCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "UnaryOperatorCS");
		private final RuleCall cEssentialOCLUnaryOperatorCSParserRuleCall = (RuleCall)rule.eContents().get(1);
		
		//// Intended to be overrideable
		// UnaryOperatorCS:
		//	EssentialOCLUnaryOperatorCS;
		public ParserRule getRule() { return rule; }

		//EssentialOCLUnaryOperatorCS
		public RuleCall getEssentialOCLUnaryOperatorCSParserRuleCall() { return cEssentialOCLUnaryOperatorCSParserRuleCall; }
	}

	public class EssentialOCLUnrestrictedNameElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "EssentialOCLUnrestrictedName");
		private final RuleCall cIdentifierParserRuleCall = (RuleCall)rule.eContents().get(1);
		
		////---------------------------------------------------------------------
		// //  Names
		//
		////---------------------------------------------------------------------
		// EssentialOCLUnrestrictedName returns
		//ecore::EString:
		//	Identifier;
		public ParserRule getRule() { return rule; }

		//Identifier
		public RuleCall getIdentifierParserRuleCall() { return cIdentifierParserRuleCall; }
	}

	public class UnrestrictedNameElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "UnrestrictedName");
		private final RuleCall cEssentialOCLUnrestrictedNameParserRuleCall = (RuleCall)rule.eContents().get(1);
		
		//// Intended to be overridden
		// UnrestrictedName returns ecore::EString:
		//	EssentialOCLUnrestrictedName;
		public ParserRule getRule() { return rule; }

		//EssentialOCLUnrestrictedName
		public RuleCall getEssentialOCLUnrestrictedNameParserRuleCall() { return cEssentialOCLUnrestrictedNameParserRuleCall; }
	}

	public class EssentialOCLUnreservedNameElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "EssentialOCLUnreservedName");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cUnrestrictedNameParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cCollectionTypeIdentifierParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cPrimitiveTypeIdentifierParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final Keyword cTupleKeyword_3 = (Keyword)cAlternatives.eContents().get(3);
		
		//EssentialOCLUnreservedName returns ecore::EString:
		//	UnrestrictedName | CollectionTypeIdentifier | PrimitiveTypeIdentifier | "Tuple";
		public ParserRule getRule() { return rule; }

		//UnrestrictedName | CollectionTypeIdentifier | PrimitiveTypeIdentifier | "Tuple"
		public Alternatives getAlternatives() { return cAlternatives; }

		//UnrestrictedName
		public RuleCall getUnrestrictedNameParserRuleCall_0() { return cUnrestrictedNameParserRuleCall_0; }

		//CollectionTypeIdentifier
		public RuleCall getCollectionTypeIdentifierParserRuleCall_1() { return cCollectionTypeIdentifierParserRuleCall_1; }

		//PrimitiveTypeIdentifier
		public RuleCall getPrimitiveTypeIdentifierParserRuleCall_2() { return cPrimitiveTypeIdentifierParserRuleCall_2; }

		//"Tuple"
		public Keyword getTupleKeyword_3() { return cTupleKeyword_3; }
	}

	public class UnreservedNameElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "UnreservedName");
		private final RuleCall cEssentialOCLUnreservedNameParserRuleCall = (RuleCall)rule.eContents().get(1);
		
		//// Intended to be overridden
		// UnreservedName returns ecore::EString:
		//	EssentialOCLUnreservedName;
		public ParserRule getRule() { return rule; }

		//EssentialOCLUnreservedName
		public RuleCall getEssentialOCLUnreservedNameParserRuleCall() { return cEssentialOCLUnreservedNameParserRuleCall; }
	}

	public class PathNameCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "PathNameCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cPathAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cPathFirstPathElementCSParserRuleCall_0_0 = (RuleCall)cPathAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cColonColonKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cPathAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cPathNextPathElementCSParserRuleCall_1_1_0 = (RuleCall)cPathAssignment_1_1.eContents().get(0);
		
		//PathNameCS returns base::PathNameCS:
		//	path+=FirstPathElementCS ("::" path+=NextPathElementCS)*;
		public ParserRule getRule() { return rule; }

		//path+=FirstPathElementCS ("::" path+=NextPathElementCS)*
		public Group getGroup() { return cGroup; }

		//path+=FirstPathElementCS
		public Assignment getPathAssignment_0() { return cPathAssignment_0; }

		//FirstPathElementCS
		public RuleCall getPathFirstPathElementCSParserRuleCall_0_0() { return cPathFirstPathElementCSParserRuleCall_0_0; }

		//("::" path+=NextPathElementCS)*
		public Group getGroup_1() { return cGroup_1; }

		//"::"
		public Keyword getColonColonKeyword_1_0() { return cColonColonKeyword_1_0; }

		//path+=NextPathElementCS
		public Assignment getPathAssignment_1_1() { return cPathAssignment_1_1; }

		//NextPathElementCS
		public RuleCall getPathNextPathElementCSParserRuleCall_1_1_0() { return cPathNextPathElementCSParserRuleCall_1_1_0; }
	}

	public class FirstPathElementCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "FirstPathElementCS");
		private final Assignment cElementAssignment = (Assignment)rule.eContents().get(1);
		private final CrossReference cElementNamedElementCrossReference_0 = (CrossReference)cElementAssignment.eContents().get(0);
		private final RuleCall cElementNamedElementUnrestrictedNameParserRuleCall_0_1 = (RuleCall)cElementNamedElementCrossReference_0.eContents().get(1);
		
		//FirstPathElementCS returns base::PathElementCS:
		//	element=[pivot::NamedElement|UnrestrictedName];
		public ParserRule getRule() { return rule; }

		//element=[pivot::NamedElement|UnrestrictedName]
		public Assignment getElementAssignment() { return cElementAssignment; }

		//[pivot::NamedElement|UnrestrictedName]
		public CrossReference getElementNamedElementCrossReference_0() { return cElementNamedElementCrossReference_0; }

		//UnrestrictedName
		public RuleCall getElementNamedElementUnrestrictedNameParserRuleCall_0_1() { return cElementNamedElementUnrestrictedNameParserRuleCall_0_1; }
	}

	public class NextPathElementCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "NextPathElementCS");
		private final Assignment cElementAssignment = (Assignment)rule.eContents().get(1);
		private final CrossReference cElementNamedElementCrossReference_0 = (CrossReference)cElementAssignment.eContents().get(0);
		private final RuleCall cElementNamedElementUnreservedNameParserRuleCall_0_1 = (RuleCall)cElementNamedElementCrossReference_0.eContents().get(1);
		
		//NextPathElementCS returns base::PathElementCS:
		//	element=[pivot::NamedElement|UnreservedName];
		public ParserRule getRule() { return rule; }

		//element=[pivot::NamedElement|UnreservedName]
		public Assignment getElementAssignment() { return cElementAssignment; }

		//[pivot::NamedElement|UnreservedName]
		public CrossReference getElementNamedElementCrossReference_0() { return cElementNamedElementCrossReference_0; }

		//UnreservedName
		public RuleCall getElementNamedElementUnreservedNameParserRuleCall_0_1() { return cElementNamedElementUnreservedNameParserRuleCall_0_1; }
	}

	public class URIPathNameCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "URIPathNameCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cPathAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cPathURIFirstPathElementCSParserRuleCall_0_0 = (RuleCall)cPathAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cColonColonKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cPathAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cPathNextPathElementCSParserRuleCall_1_1_0 = (RuleCall)cPathAssignment_1_1.eContents().get(0);
		
		//URIPathNameCS returns base::PathNameCS:
		//	path+=URIFirstPathElementCS ("::" path+=NextPathElementCS)*;
		public ParserRule getRule() { return rule; }

		//path+=URIFirstPathElementCS ("::" path+=NextPathElementCS)*
		public Group getGroup() { return cGroup; }

		//path+=URIFirstPathElementCS
		public Assignment getPathAssignment_0() { return cPathAssignment_0; }

		//URIFirstPathElementCS
		public RuleCall getPathURIFirstPathElementCSParserRuleCall_0_0() { return cPathURIFirstPathElementCSParserRuleCall_0_0; }

		//("::" path+=NextPathElementCS)*
		public Group getGroup_1() { return cGroup_1; }

		//"::"
		public Keyword getColonColonKeyword_1_0() { return cColonColonKeyword_1_0; }

		//path+=NextPathElementCS
		public Assignment getPathAssignment_1_1() { return cPathAssignment_1_1; }

		//NextPathElementCS
		public RuleCall getPathNextPathElementCSParserRuleCall_1_1_0() { return cPathNextPathElementCSParserRuleCall_1_1_0; }
	}

	public class URIFirstPathElementCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "URIFirstPathElementCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Assignment cElementAssignment_0 = (Assignment)cAlternatives.eContents().get(0);
		private final CrossReference cElementNamedElementCrossReference_0_0 = (CrossReference)cElementAssignment_0.eContents().get(0);
		private final RuleCall cElementNamedElementUnrestrictedNameParserRuleCall_0_0_1 = (RuleCall)cElementNamedElementCrossReference_0_0.eContents().get(1);
		private final Group cGroup_1 = (Group)cAlternatives.eContents().get(1);
		private final Action cPathElementWithURICSAction_1_0 = (Action)cGroup_1.eContents().get(0);
		private final Assignment cElementAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final CrossReference cElementNamespaceCrossReference_1_1_0 = (CrossReference)cElementAssignment_1_1.eContents().get(0);
		private final RuleCall cElementNamespaceURIParserRuleCall_1_1_0_1 = (RuleCall)cElementNamespaceCrossReference_1_1_0.eContents().get(1);
		
		//URIFirstPathElementCS returns base::PathElementCS:
		//	element=[pivot::NamedElement|UnrestrictedName] | {base::PathElementWithURICS} element=[pivot::Namespace|URI];
		public ParserRule getRule() { return rule; }

		//element=[pivot::NamedElement|UnrestrictedName] | {base::PathElementWithURICS} element=[pivot::Namespace|URI]
		public Alternatives getAlternatives() { return cAlternatives; }

		//element=[pivot::NamedElement|UnrestrictedName]
		public Assignment getElementAssignment_0() { return cElementAssignment_0; }

		//[pivot::NamedElement|UnrestrictedName]
		public CrossReference getElementNamedElementCrossReference_0_0() { return cElementNamedElementCrossReference_0_0; }

		//UnrestrictedName
		public RuleCall getElementNamedElementUnrestrictedNameParserRuleCall_0_0_1() { return cElementNamedElementUnrestrictedNameParserRuleCall_0_0_1; }

		//{base::PathElementWithURICS} element=[pivot::Namespace|URI]
		public Group getGroup_1() { return cGroup_1; }

		//{base::PathElementWithURICS}
		public Action getPathElementWithURICSAction_1_0() { return cPathElementWithURICSAction_1_0; }

		//element=[pivot::Namespace|URI]
		public Assignment getElementAssignment_1_1() { return cElementAssignment_1_1; }

		//[pivot::Namespace|URI]
		public CrossReference getElementNamespaceCrossReference_1_1_0() { return cElementNamespaceCrossReference_1_1_0; }

		//URI
		public RuleCall getElementNamespaceURIParserRuleCall_1_1_0_1() { return cElementNamespaceURIParserRuleCall_1_1_0_1; }
	}

	public class PrimitiveTypeIdentifierElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "PrimitiveTypeIdentifier");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Keyword cBooleanKeyword_0 = (Keyword)cAlternatives.eContents().get(0);
		private final Keyword cIntegerKeyword_1 = (Keyword)cAlternatives.eContents().get(1);
		private final Keyword cRealKeyword_2 = (Keyword)cAlternatives.eContents().get(2);
		private final Keyword cStringKeyword_3 = (Keyword)cAlternatives.eContents().get(3);
		private final Keyword cUnlimitedNaturalKeyword_4 = (Keyword)cAlternatives.eContents().get(4);
		private final Keyword cOclAnyKeyword_5 = (Keyword)cAlternatives.eContents().get(5);
		private final Keyword cOclInvalidKeyword_6 = (Keyword)cAlternatives.eContents().get(6);
		private final Keyword cOclVoidKeyword_7 = (Keyword)cAlternatives.eContents().get(7);
		
		////---------------------------------------------------------------------
		// //  Types
		//
		////---------------------------------------------------------------------
		// PrimitiveTypeIdentifier:
		//	"Boolean" | "Integer" | "Real" | "String" | "UnlimitedNatural" | "OclAny" | "OclInvalid" | "OclVoid";
		public ParserRule getRule() { return rule; }

		//"Boolean" | "Integer" | "Real" | "String" | "UnlimitedNatural" | "OclAny" | "OclInvalid" | "OclVoid"
		public Alternatives getAlternatives() { return cAlternatives; }

		//"Boolean"
		public Keyword getBooleanKeyword_0() { return cBooleanKeyword_0; }

		//"Integer"
		public Keyword getIntegerKeyword_1() { return cIntegerKeyword_1; }

		//"Real"
		public Keyword getRealKeyword_2() { return cRealKeyword_2; }

		//"String"
		public Keyword getStringKeyword_3() { return cStringKeyword_3; }

		//"UnlimitedNatural"
		public Keyword getUnlimitedNaturalKeyword_4() { return cUnlimitedNaturalKeyword_4; }

		//"OclAny"
		public Keyword getOclAnyKeyword_5() { return cOclAnyKeyword_5; }

		//"OclInvalid"
		public Keyword getOclInvalidKeyword_6() { return cOclInvalidKeyword_6; }

		//"OclVoid"
		public Keyword getOclVoidKeyword_7() { return cOclVoidKeyword_7; }
	}

	public class PrimitiveTypeCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "PrimitiveTypeCS");
		private final Assignment cNameAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cNamePrimitiveTypeIdentifierParserRuleCall_0 = (RuleCall)cNameAssignment.eContents().get(0);
		
		//PrimitiveTypeCS returns base::PrimitiveTypeRefCS:
		//	name=PrimitiveTypeIdentifier;
		public ParserRule getRule() { return rule; }

		//name=PrimitiveTypeIdentifier
		public Assignment getNameAssignment() { return cNameAssignment; }

		//PrimitiveTypeIdentifier
		public RuleCall getNamePrimitiveTypeIdentifierParserRuleCall_0() { return cNamePrimitiveTypeIdentifierParserRuleCall_0; }
	}

	public class CollectionTypeIdentifierElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "CollectionTypeIdentifier");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Keyword cSetKeyword_0 = (Keyword)cAlternatives.eContents().get(0);
		private final Keyword cBagKeyword_1 = (Keyword)cAlternatives.eContents().get(1);
		private final Keyword cSequenceKeyword_2 = (Keyword)cAlternatives.eContents().get(2);
		private final Keyword cCollectionKeyword_3 = (Keyword)cAlternatives.eContents().get(3);
		private final Keyword cOrderedSetKeyword_4 = (Keyword)cAlternatives.eContents().get(4);
		
		//CollectionTypeIdentifier returns ecore::EString:
		//	"Set" | "Bag" | "Sequence" | "Collection" | "OrderedSet";
		public ParserRule getRule() { return rule; }

		//"Set" | "Bag" | "Sequence" | "Collection" | "OrderedSet"
		public Alternatives getAlternatives() { return cAlternatives; }

		//"Set"
		public Keyword getSetKeyword_0() { return cSetKeyword_0; }

		//"Bag"
		public Keyword getBagKeyword_1() { return cBagKeyword_1; }

		//"Sequence"
		public Keyword getSequenceKeyword_2() { return cSequenceKeyword_2; }

		//"Collection"
		public Keyword getCollectionKeyword_3() { return cCollectionKeyword_3; }

		//"OrderedSet"
		public Keyword getOrderedSetKeyword_4() { return cOrderedSetKeyword_4; }
	}

	public class CollectionTypeCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "CollectionTypeCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameCollectionTypeIdentifierParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cLeftParenthesisKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cOwnedTypeAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cOwnedTypeTypeExpCSParserRuleCall_1_1_0 = (RuleCall)cOwnedTypeAssignment_1_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_1_2 = (Keyword)cGroup_1.eContents().get(2);
		
		//CollectionTypeCS:
		//	name=CollectionTypeIdentifier ("(" ownedType=TypeExpCS ")")?;
		public ParserRule getRule() { return rule; }

		//name=CollectionTypeIdentifier ("(" ownedType=TypeExpCS ")")?
		public Group getGroup() { return cGroup; }

		//name=CollectionTypeIdentifier
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//CollectionTypeIdentifier
		public RuleCall getNameCollectionTypeIdentifierParserRuleCall_0_0() { return cNameCollectionTypeIdentifierParserRuleCall_0_0; }

		//("(" ownedType=TypeExpCS ")")?
		public Group getGroup_1() { return cGroup_1; }

		//"("
		public Keyword getLeftParenthesisKeyword_1_0() { return cLeftParenthesisKeyword_1_0; }

		//ownedType=TypeExpCS
		public Assignment getOwnedTypeAssignment_1_1() { return cOwnedTypeAssignment_1_1; }

		//TypeExpCS
		public RuleCall getOwnedTypeTypeExpCSParserRuleCall_1_1_0() { return cOwnedTypeTypeExpCSParserRuleCall_1_1_0; }

		//")"
		public Keyword getRightParenthesisKeyword_1_2() { return cRightParenthesisKeyword_1_2; }
	}

	public class MultiplicityBoundsCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "MultiplicityBoundsCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cLowerBoundAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cLowerBoundLOWERParserRuleCall_0_0 = (RuleCall)cLowerBoundAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cFullStopFullStopKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cUpperBoundAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cUpperBoundUPPERParserRuleCall_1_1_0 = (RuleCall)cUpperBoundAssignment_1_1.eContents().get(0);
		
		//MultiplicityBoundsCS returns base::MultiplicityBoundsCS:
		//	lowerBound=LOWER (".." upperBound=UPPER)?;
		public ParserRule getRule() { return rule; }

		//lowerBound=LOWER (".." upperBound=UPPER)?
		public Group getGroup() { return cGroup; }

		//lowerBound=LOWER
		public Assignment getLowerBoundAssignment_0() { return cLowerBoundAssignment_0; }

		//LOWER
		public RuleCall getLowerBoundLOWERParserRuleCall_0_0() { return cLowerBoundLOWERParserRuleCall_0_0; }

		//(".." upperBound=UPPER)?
		public Group getGroup_1() { return cGroup_1; }

		//".."
		public Keyword getFullStopFullStopKeyword_1_0() { return cFullStopFullStopKeyword_1_0; }

		//upperBound=UPPER
		public Assignment getUpperBoundAssignment_1_1() { return cUpperBoundAssignment_1_1; }

		//UPPER
		public RuleCall getUpperBoundUPPERParserRuleCall_1_1_0() { return cUpperBoundUPPERParserRuleCall_1_1_0; }
	}

	public class MultiplicityCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "MultiplicityCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLeftSquareBracketKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final RuleCall cMultiplicityBoundsCSParserRuleCall_1_0 = (RuleCall)cAlternatives_1.eContents().get(0);
		private final RuleCall cMultiplicityStringCSParserRuleCall_1_1 = (RuleCall)cAlternatives_1.eContents().get(1);
		private final Keyword cRightSquareBracketKeyword_2 = (Keyword)cGroup.eContents().get(2);
		
		//MultiplicityCS returns base::MultiplicityCS:
		//	"[" (MultiplicityBoundsCS | MultiplicityStringCS) "]";
		public ParserRule getRule() { return rule; }

		//"[" (MultiplicityBoundsCS | MultiplicityStringCS) "]"
		public Group getGroup() { return cGroup; }

		//"["
		public Keyword getLeftSquareBracketKeyword_0() { return cLeftSquareBracketKeyword_0; }

		//MultiplicityBoundsCS | MultiplicityStringCS
		public Alternatives getAlternatives_1() { return cAlternatives_1; }

		//MultiplicityBoundsCS
		public RuleCall getMultiplicityBoundsCSParserRuleCall_1_0() { return cMultiplicityBoundsCSParserRuleCall_1_0; }

		//MultiplicityStringCS
		public RuleCall getMultiplicityStringCSParserRuleCall_1_1() { return cMultiplicityStringCSParserRuleCall_1_1; }

		//"]"
		public Keyword getRightSquareBracketKeyword_2() { return cRightSquareBracketKeyword_2; }
	}

	public class MultiplicityStringCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "MultiplicityStringCS");
		private final Assignment cStringBoundsAssignment = (Assignment)rule.eContents().get(1);
		private final Alternatives cStringBoundsAlternatives_0 = (Alternatives)cStringBoundsAssignment.eContents().get(0);
		private final Keyword cStringBoundsAsteriskKeyword_0_0 = (Keyword)cStringBoundsAlternatives_0.eContents().get(0);
		private final Keyword cStringBoundsPlusSignKeyword_0_1 = (Keyword)cStringBoundsAlternatives_0.eContents().get(1);
		private final Keyword cStringBoundsQuestionMarkKeyword_0_2 = (Keyword)cStringBoundsAlternatives_0.eContents().get(2);
		
		//MultiplicityStringCS returns base::MultiplicityStringCS:
		//	stringBounds=("*" | "+" | "?");
		public ParserRule getRule() { return rule; }

		//stringBounds=("*" | "+" | "?")
		public Assignment getStringBoundsAssignment() { return cStringBoundsAssignment; }

		//"*" | "+" | "?"
		public Alternatives getStringBoundsAlternatives_0() { return cStringBoundsAlternatives_0; }

		//"*"
		public Keyword getStringBoundsAsteriskKeyword_0_0() { return cStringBoundsAsteriskKeyword_0_0; }

		//"+"
		public Keyword getStringBoundsPlusSignKeyword_0_1() { return cStringBoundsPlusSignKeyword_0_1; }

		//"?"
		public Keyword getStringBoundsQuestionMarkKeyword_0_2() { return cStringBoundsQuestionMarkKeyword_0_2; }
	}

	public class TupleTypeCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "TupleTypeCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final Keyword cNameTupleKeyword_0_0 = (Keyword)cNameAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cLeftParenthesisKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Group cGroup_1_1 = (Group)cGroup_1.eContents().get(1);
		private final Assignment cOwnedPartsAssignment_1_1_0 = (Assignment)cGroup_1_1.eContents().get(0);
		private final RuleCall cOwnedPartsTuplePartCSParserRuleCall_1_1_0_0 = (RuleCall)cOwnedPartsAssignment_1_1_0.eContents().get(0);
		private final Group cGroup_1_1_1 = (Group)cGroup_1_1.eContents().get(1);
		private final Keyword cCommaKeyword_1_1_1_0 = (Keyword)cGroup_1_1_1.eContents().get(0);
		private final Assignment cOwnedPartsAssignment_1_1_1_1 = (Assignment)cGroup_1_1_1.eContents().get(1);
		private final RuleCall cOwnedPartsTuplePartCSParserRuleCall_1_1_1_1_0 = (RuleCall)cOwnedPartsAssignment_1_1_1_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_1_2 = (Keyword)cGroup_1.eContents().get(2);
		
		//TupleTypeCS returns base::TupleTypeCS:
		//	name="Tuple" ("(" (ownedParts+=TuplePartCS ("," ownedParts+=TuplePartCS)*)? ")")?;
		public ParserRule getRule() { return rule; }

		//name="Tuple" ("(" (ownedParts+=TuplePartCS ("," ownedParts+=TuplePartCS)*)? ")")?
		public Group getGroup() { return cGroup; }

		//name="Tuple"
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//"Tuple"
		public Keyword getNameTupleKeyword_0_0() { return cNameTupleKeyword_0_0; }

		//("(" (ownedParts+=TuplePartCS ("," ownedParts+=TuplePartCS)*)? ")")?
		public Group getGroup_1() { return cGroup_1; }

		//"("
		public Keyword getLeftParenthesisKeyword_1_0() { return cLeftParenthesisKeyword_1_0; }

		//(ownedParts+=TuplePartCS ("," ownedParts+=TuplePartCS)*)?
		public Group getGroup_1_1() { return cGroup_1_1; }

		//ownedParts+=TuplePartCS
		public Assignment getOwnedPartsAssignment_1_1_0() { return cOwnedPartsAssignment_1_1_0; }

		//TuplePartCS
		public RuleCall getOwnedPartsTuplePartCSParserRuleCall_1_1_0_0() { return cOwnedPartsTuplePartCSParserRuleCall_1_1_0_0; }

		//("," ownedParts+=TuplePartCS)*
		public Group getGroup_1_1_1() { return cGroup_1_1_1; }

		//","
		public Keyword getCommaKeyword_1_1_1_0() { return cCommaKeyword_1_1_1_0; }

		//ownedParts+=TuplePartCS
		public Assignment getOwnedPartsAssignment_1_1_1_1() { return cOwnedPartsAssignment_1_1_1_1; }

		//TuplePartCS
		public RuleCall getOwnedPartsTuplePartCSParserRuleCall_1_1_1_1_0() { return cOwnedPartsTuplePartCSParserRuleCall_1_1_1_1_0; }

		//")"
		public Keyword getRightParenthesisKeyword_1_2() { return cRightParenthesisKeyword_1_2; }
	}

	public class TuplePartCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "TuplePartCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Keyword cColonKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cOwnedTypeAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cOwnedTypeTypeExpCSParserRuleCall_2_0 = (RuleCall)cOwnedTypeAssignment_2.eContents().get(0);
		
		//TuplePartCS returns base::TuplePartCS:
		//	name=UnrestrictedName ":" ownedType=TypeExpCS;
		public ParserRule getRule() { return rule; }

		//name=UnrestrictedName ":" ownedType=TypeExpCS
		public Group getGroup() { return cGroup; }

		//name=UnrestrictedName
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_0_0() { return cNameUnrestrictedNameParserRuleCall_0_0; }

		//":"
		public Keyword getColonKeyword_1() { return cColonKeyword_1; }

		//ownedType=TypeExpCS
		public Assignment getOwnedTypeAssignment_2() { return cOwnedTypeAssignment_2; }

		//TypeExpCS
		public RuleCall getOwnedTypeTypeExpCSParserRuleCall_2_0() { return cOwnedTypeTypeExpCSParserRuleCall_2_0; }
	}

	public class CollectionLiteralExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "CollectionLiteralExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cOwnedTypeAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cOwnedTypeCollectionTypeCSParserRuleCall_0_0 = (RuleCall)cOwnedTypeAssignment_0.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Assignment cOwnedPartsAssignment_2_0 = (Assignment)cGroup_2.eContents().get(0);
		private final RuleCall cOwnedPartsCollectionLiteralPartCSParserRuleCall_2_0_0 = (RuleCall)cOwnedPartsAssignment_2_0.eContents().get(0);
		private final Group cGroup_2_1 = (Group)cGroup_2.eContents().get(1);
		private final Keyword cCommaKeyword_2_1_0 = (Keyword)cGroup_2_1.eContents().get(0);
		private final Assignment cOwnedPartsAssignment_2_1_1 = (Assignment)cGroup_2_1.eContents().get(1);
		private final RuleCall cOwnedPartsCollectionLiteralPartCSParserRuleCall_2_1_1_0 = (RuleCall)cOwnedPartsAssignment_2_1_1.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		////---------------------------------------------------------------------
		// //  Literals
		//
		////---------------------------------------------------------------------
		// CollectionLiteralExpCS:
		//	ownedType=CollectionTypeCS "{" (ownedParts+=CollectionLiteralPartCS ("," ownedParts+=CollectionLiteralPartCS)*)? "}";
		public ParserRule getRule() { return rule; }

		//ownedType=CollectionTypeCS "{" (ownedParts+=CollectionLiteralPartCS ("," ownedParts+=CollectionLiteralPartCS)*)? "}"
		public Group getGroup() { return cGroup; }

		//ownedType=CollectionTypeCS
		public Assignment getOwnedTypeAssignment_0() { return cOwnedTypeAssignment_0; }

		//CollectionTypeCS
		public RuleCall getOwnedTypeCollectionTypeCSParserRuleCall_0_0() { return cOwnedTypeCollectionTypeCSParserRuleCall_0_0; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_1() { return cLeftCurlyBracketKeyword_1; }

		//(ownedParts+=CollectionLiteralPartCS ("," ownedParts+=CollectionLiteralPartCS)*)?
		public Group getGroup_2() { return cGroup_2; }

		//ownedParts+=CollectionLiteralPartCS
		public Assignment getOwnedPartsAssignment_2_0() { return cOwnedPartsAssignment_2_0; }

		//CollectionLiteralPartCS
		public RuleCall getOwnedPartsCollectionLiteralPartCSParserRuleCall_2_0_0() { return cOwnedPartsCollectionLiteralPartCSParserRuleCall_2_0_0; }

		//("," ownedParts+=CollectionLiteralPartCS)*
		public Group getGroup_2_1() { return cGroup_2_1; }

		//","
		public Keyword getCommaKeyword_2_1_0() { return cCommaKeyword_2_1_0; }

		//ownedParts+=CollectionLiteralPartCS
		public Assignment getOwnedPartsAssignment_2_1_1() { return cOwnedPartsAssignment_2_1_1; }

		//CollectionLiteralPartCS
		public RuleCall getOwnedPartsCollectionLiteralPartCSParserRuleCall_2_1_1_0() { return cOwnedPartsCollectionLiteralPartCSParserRuleCall_2_1_1_0; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_3() { return cRightCurlyBracketKeyword_3; }
	}

	public class CollectionLiteralPartCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "CollectionLiteralPartCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cExpressionCSAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cExpressionCSExpCSParserRuleCall_0_0 = (RuleCall)cExpressionCSAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cFullStopFullStopKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cLastExpressionCSAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cLastExpressionCSExpCSParserRuleCall_1_1_0 = (RuleCall)cLastExpressionCSAssignment_1_1.eContents().get(0);
		
		//CollectionLiteralPartCS:
		//	expressionCS=ExpCS (".." lastExpressionCS=ExpCS)?;
		public ParserRule getRule() { return rule; }

		//expressionCS=ExpCS (".." lastExpressionCS=ExpCS)?
		public Group getGroup() { return cGroup; }

		//expressionCS=ExpCS
		public Assignment getExpressionCSAssignment_0() { return cExpressionCSAssignment_0; }

		//ExpCS
		public RuleCall getExpressionCSExpCSParserRuleCall_0_0() { return cExpressionCSExpCSParserRuleCall_0_0; }

		//(".." lastExpressionCS=ExpCS)?
		public Group getGroup_1() { return cGroup_1; }

		//".."
		public Keyword getFullStopFullStopKeyword_1_0() { return cFullStopFullStopKeyword_1_0; }

		//lastExpressionCS=ExpCS
		public Assignment getLastExpressionCSAssignment_1_1() { return cLastExpressionCSAssignment_1_1; }

		//ExpCS
		public RuleCall getLastExpressionCSExpCSParserRuleCall_1_1_0() { return cLastExpressionCSExpCSParserRuleCall_1_1_0; }
	}

	public class ConstructorPartCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "ConstructorPartCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cPropertyAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cPropertyPropertyCrossReference_0_0 = (CrossReference)cPropertyAssignment_0.eContents().get(0);
		private final RuleCall cPropertyPropertyUnrestrictedNameParserRuleCall_0_0_1 = (RuleCall)cPropertyPropertyCrossReference_0_0.eContents().get(1);
		private final Keyword cEqualsSignKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cInitExpressionAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cInitExpressionExpCSParserRuleCall_2_0 = (RuleCall)cInitExpressionAssignment_2.eContents().get(0);
		
		//ConstructorPartCS:
		//	property=[pivot::Property|UnrestrictedName] "=" initExpression=ExpCS;
		public ParserRule getRule() { return rule; }

		//property=[pivot::Property|UnrestrictedName] "=" initExpression=ExpCS
		public Group getGroup() { return cGroup; }

		//property=[pivot::Property|UnrestrictedName]
		public Assignment getPropertyAssignment_0() { return cPropertyAssignment_0; }

		//[pivot::Property|UnrestrictedName]
		public CrossReference getPropertyPropertyCrossReference_0_0() { return cPropertyPropertyCrossReference_0_0; }

		//UnrestrictedName
		public RuleCall getPropertyPropertyUnrestrictedNameParserRuleCall_0_0_1() { return cPropertyPropertyUnrestrictedNameParserRuleCall_0_0_1; }

		//"="
		public Keyword getEqualsSignKeyword_1() { return cEqualsSignKeyword_1; }

		//initExpression=ExpCS
		public Assignment getInitExpressionAssignment_2() { return cInitExpressionAssignment_2; }

		//ExpCS
		public RuleCall getInitExpressionExpCSParserRuleCall_2_0() { return cInitExpressionExpCSParserRuleCall_2_0; }
	}

	public class PrimitiveLiteralExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "PrimitiveLiteralExpCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cNumberLiteralExpCSParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cStringLiteralExpCSParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cBooleanLiteralExpCSParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cUnlimitedNaturalLiteralExpCSParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		private final RuleCall cInvalidLiteralExpCSParserRuleCall_4 = (RuleCall)cAlternatives.eContents().get(4);
		private final RuleCall cNullLiteralExpCSParserRuleCall_5 = (RuleCall)cAlternatives.eContents().get(5);
		
		//PrimitiveLiteralExpCS:
		//	NumberLiteralExpCS | StringLiteralExpCS | BooleanLiteralExpCS | UnlimitedNaturalLiteralExpCS | InvalidLiteralExpCS |
		//	NullLiteralExpCS;
		public ParserRule getRule() { return rule; }

		//NumberLiteralExpCS | StringLiteralExpCS | BooleanLiteralExpCS | UnlimitedNaturalLiteralExpCS | InvalidLiteralExpCS |
		//NullLiteralExpCS
		public Alternatives getAlternatives() { return cAlternatives; }

		//NumberLiteralExpCS
		public RuleCall getNumberLiteralExpCSParserRuleCall_0() { return cNumberLiteralExpCSParserRuleCall_0; }

		//StringLiteralExpCS
		public RuleCall getStringLiteralExpCSParserRuleCall_1() { return cStringLiteralExpCSParserRuleCall_1; }

		//BooleanLiteralExpCS
		public RuleCall getBooleanLiteralExpCSParserRuleCall_2() { return cBooleanLiteralExpCSParserRuleCall_2; }

		//UnlimitedNaturalLiteralExpCS
		public RuleCall getUnlimitedNaturalLiteralExpCSParserRuleCall_3() { return cUnlimitedNaturalLiteralExpCSParserRuleCall_3; }

		//InvalidLiteralExpCS
		public RuleCall getInvalidLiteralExpCSParserRuleCall_4() { return cInvalidLiteralExpCSParserRuleCall_4; }

		//NullLiteralExpCS
		public RuleCall getNullLiteralExpCSParserRuleCall_5() { return cNullLiteralExpCSParserRuleCall_5; }
	}

	public class TupleLiteralExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "TupleLiteralExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cTupleKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cOwnedPartsAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cOwnedPartsTupleLiteralPartCSParserRuleCall_2_0 = (RuleCall)cOwnedPartsAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cCommaKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cOwnedPartsAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cOwnedPartsTupleLiteralPartCSParserRuleCall_3_1_0 = (RuleCall)cOwnedPartsAssignment_3_1.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//TupleLiteralExpCS:
		//	"Tuple" "{" ownedParts+=TupleLiteralPartCS ("," ownedParts+=TupleLiteralPartCS)* "}";
		public ParserRule getRule() { return rule; }

		//"Tuple" "{" ownedParts+=TupleLiteralPartCS ("," ownedParts+=TupleLiteralPartCS)* "}"
		public Group getGroup() { return cGroup; }

		//"Tuple"
		public Keyword getTupleKeyword_0() { return cTupleKeyword_0; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_1() { return cLeftCurlyBracketKeyword_1; }

		//ownedParts+=TupleLiteralPartCS
		public Assignment getOwnedPartsAssignment_2() { return cOwnedPartsAssignment_2; }

		//TupleLiteralPartCS
		public RuleCall getOwnedPartsTupleLiteralPartCSParserRuleCall_2_0() { return cOwnedPartsTupleLiteralPartCSParserRuleCall_2_0; }

		//("," ownedParts+=TupleLiteralPartCS)*
		public Group getGroup_3() { return cGroup_3; }

		//","
		public Keyword getCommaKeyword_3_0() { return cCommaKeyword_3_0; }

		//ownedParts+=TupleLiteralPartCS
		public Assignment getOwnedPartsAssignment_3_1() { return cOwnedPartsAssignment_3_1; }

		//TupleLiteralPartCS
		public RuleCall getOwnedPartsTupleLiteralPartCSParserRuleCall_3_1_0() { return cOwnedPartsTupleLiteralPartCSParserRuleCall_3_1_0; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_4() { return cRightCurlyBracketKeyword_4; }
	}

	public class TupleLiteralPartCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "TupleLiteralPartCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cColonKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cOwnedTypeAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cOwnedTypeTypeExpCSParserRuleCall_1_1_0 = (RuleCall)cOwnedTypeAssignment_1_1.eContents().get(0);
		private final Keyword cEqualsSignKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cInitExpressionAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cInitExpressionExpCSParserRuleCall_3_0 = (RuleCall)cInitExpressionAssignment_3.eContents().get(0);
		
		//TupleLiteralPartCS:
		//	name=UnrestrictedName (":" ownedType=TypeExpCS)? "=" initExpression=ExpCS;
		public ParserRule getRule() { return rule; }

		//name=UnrestrictedName (":" ownedType=TypeExpCS)? "=" initExpression=ExpCS
		public Group getGroup() { return cGroup; }

		//name=UnrestrictedName
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_0_0() { return cNameUnrestrictedNameParserRuleCall_0_0; }

		//(":" ownedType=TypeExpCS)?
		public Group getGroup_1() { return cGroup_1; }

		//":"
		public Keyword getColonKeyword_1_0() { return cColonKeyword_1_0; }

		//ownedType=TypeExpCS
		public Assignment getOwnedTypeAssignment_1_1() { return cOwnedTypeAssignment_1_1; }

		//TypeExpCS
		public RuleCall getOwnedTypeTypeExpCSParserRuleCall_1_1_0() { return cOwnedTypeTypeExpCSParserRuleCall_1_1_0; }

		//"="
		public Keyword getEqualsSignKeyword_2() { return cEqualsSignKeyword_2; }

		//initExpression=ExpCS
		public Assignment getInitExpressionAssignment_3() { return cInitExpressionAssignment_3; }

		//ExpCS
		public RuleCall getInitExpressionExpCSParserRuleCall_3_0() { return cInitExpressionExpCSParserRuleCall_3_0; }
	}

	public class NumberLiteralExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "NumberLiteralExpCS");
		private final Assignment cNameAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cNameNUMBER_LITERALParserRuleCall_0 = (RuleCall)cNameAssignment.eContents().get(0);
		
		//NumberLiteralExpCS:
		//	name=NUMBER_LITERAL;
		public ParserRule getRule() { return rule; }

		//name=NUMBER_LITERAL
		public Assignment getNameAssignment() { return cNameAssignment; }

		//NUMBER_LITERAL
		public RuleCall getNameNUMBER_LITERALParserRuleCall_0() { return cNameNUMBER_LITERALParserRuleCall_0; }
	}

	public class StringLiteralExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "StringLiteralExpCS");
		private final Assignment cNameAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cNameStringLiteralParserRuleCall_0 = (RuleCall)cNameAssignment.eContents().get(0);
		
		//StringLiteralExpCS:
		//	name+=StringLiteral+;
		public ParserRule getRule() { return rule; }

		//name+=StringLiteral+
		public Assignment getNameAssignment() { return cNameAssignment; }

		//StringLiteral
		public RuleCall getNameStringLiteralParserRuleCall_0() { return cNameStringLiteralParserRuleCall_0; }
	}

	public class BooleanLiteralExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "BooleanLiteralExpCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cAlternatives.eContents().get(0);
		private final Keyword cNameTrueKeyword_0_0 = (Keyword)cNameAssignment_0.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cAlternatives.eContents().get(1);
		private final Keyword cNameFalseKeyword_1_0 = (Keyword)cNameAssignment_1.eContents().get(0);
		
		//BooleanLiteralExpCS:
		//	name="true" | name="false";
		public ParserRule getRule() { return rule; }

		//name="true" | name="false"
		public Alternatives getAlternatives() { return cAlternatives; }

		//name="true"
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//"true"
		public Keyword getNameTrueKeyword_0_0() { return cNameTrueKeyword_0_0; }

		//name="false"
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }

		//"false"
		public Keyword getNameFalseKeyword_1_0() { return cNameFalseKeyword_1_0; }
	}

	public class UnlimitedNaturalLiteralExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "UnlimitedNaturalLiteralExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cUnlimitedNaturalLiteralExpCSAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cAsteriskKeyword_1 = (Keyword)cGroup.eContents().get(1);
		
		//UnlimitedNaturalLiteralExpCS:
		//	{UnlimitedNaturalLiteralExpCS} "*";
		public ParserRule getRule() { return rule; }

		//{UnlimitedNaturalLiteralExpCS} "*"
		public Group getGroup() { return cGroup; }

		//{UnlimitedNaturalLiteralExpCS}
		public Action getUnlimitedNaturalLiteralExpCSAction_0() { return cUnlimitedNaturalLiteralExpCSAction_0; }

		//"*"
		public Keyword getAsteriskKeyword_1() { return cAsteriskKeyword_1; }
	}

	public class InvalidLiteralExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "InvalidLiteralExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cInvalidLiteralExpCSAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cInvalidKeyword_1 = (Keyword)cGroup.eContents().get(1);
		
		//InvalidLiteralExpCS:
		//	{InvalidLiteralExpCS} "invalid";
		public ParserRule getRule() { return rule; }

		//{InvalidLiteralExpCS} "invalid"
		public Group getGroup() { return cGroup; }

		//{InvalidLiteralExpCS}
		public Action getInvalidLiteralExpCSAction_0() { return cInvalidLiteralExpCSAction_0; }

		//"invalid"
		public Keyword getInvalidKeyword_1() { return cInvalidKeyword_1; }
	}

	public class NullLiteralExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "NullLiteralExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cNullLiteralExpCSAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cNullKeyword_1 = (Keyword)cGroup.eContents().get(1);
		
		//NullLiteralExpCS:
		//	{NullLiteralExpCS} "null";
		public ParserRule getRule() { return rule; }

		//{NullLiteralExpCS} "null"
		public Group getGroup() { return cGroup; }

		//{NullLiteralExpCS}
		public Action getNullLiteralExpCSAction_0() { return cNullLiteralExpCSAction_0; }

		//"null"
		public Keyword getNullKeyword_1() { return cNullKeyword_1; }
	}

	public class TypeLiteralCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "TypeLiteralCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cPrimitiveTypeCSParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cCollectionTypeCSParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cTupleTypeCSParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//TypeLiteralCS returns base::TypedRefCS:
		//	PrimitiveTypeCS | CollectionTypeCS | TupleTypeCS;
		public ParserRule getRule() { return rule; }

		//PrimitiveTypeCS | CollectionTypeCS | TupleTypeCS
		public Alternatives getAlternatives() { return cAlternatives; }

		//PrimitiveTypeCS
		public RuleCall getPrimitiveTypeCSParserRuleCall_0() { return cPrimitiveTypeCSParserRuleCall_0; }

		//CollectionTypeCS
		public RuleCall getCollectionTypeCSParserRuleCall_1() { return cCollectionTypeCSParserRuleCall_1; }

		//TupleTypeCS
		public RuleCall getTupleTypeCSParserRuleCall_2() { return cTupleTypeCSParserRuleCall_2; }
	}

	public class TypeLiteralWithMultiplicityCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "TypeLiteralWithMultiplicityCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final RuleCall cTypeLiteralCSParserRuleCall_0 = (RuleCall)cGroup.eContents().get(0);
		private final Assignment cMultiplicityAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cMultiplicityMultiplicityCSParserRuleCall_1_0 = (RuleCall)cMultiplicityAssignment_1.eContents().get(0);
		
		//TypeLiteralWithMultiplicityCS returns base::TypedRefCS:
		//	TypeLiteralCS multiplicity=MultiplicityCS?;
		public ParserRule getRule() { return rule; }

		//TypeLiteralCS multiplicity=MultiplicityCS?
		public Group getGroup() { return cGroup; }

		//TypeLiteralCS
		public RuleCall getTypeLiteralCSParserRuleCall_0() { return cTypeLiteralCSParserRuleCall_0; }

		//multiplicity=MultiplicityCS?
		public Assignment getMultiplicityAssignment_1() { return cMultiplicityAssignment_1; }

		//MultiplicityCS
		public RuleCall getMultiplicityMultiplicityCSParserRuleCall_1_0() { return cMultiplicityMultiplicityCSParserRuleCall_1_0; }
	}

	public class TypeLiteralExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "TypeLiteralExpCS");
		private final Assignment cOwnedTypeAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cOwnedTypeTypeLiteralWithMultiplicityCSParserRuleCall_0 = (RuleCall)cOwnedTypeAssignment.eContents().get(0);
		
		//TypeLiteralExpCS:
		//	ownedType=TypeLiteralWithMultiplicityCS;
		public ParserRule getRule() { return rule; }

		//ownedType=TypeLiteralWithMultiplicityCS
		public Assignment getOwnedTypeAssignment() { return cOwnedTypeAssignment; }

		//TypeLiteralWithMultiplicityCS
		public RuleCall getOwnedTypeTypeLiteralWithMultiplicityCSParserRuleCall_0() { return cOwnedTypeTypeLiteralWithMultiplicityCSParserRuleCall_0; }
	}

	public class TypeNameExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "TypeNameExpCS");
		private final Assignment cPathNameAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cPathNamePathNameCSParserRuleCall_0 = (RuleCall)cPathNameAssignment.eContents().get(0);
		
		//TypeNameExpCS:
		//	pathName=PathNameCS;
		public ParserRule getRule() { return rule; }

		//pathName=PathNameCS
		public Assignment getPathNameAssignment() { return cPathNameAssignment; }

		//PathNameCS
		public RuleCall getPathNamePathNameCSParserRuleCall_0() { return cPathNamePathNameCSParserRuleCall_0; }
	}

	public class TypeExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "TypeExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Alternatives cAlternatives_0 = (Alternatives)cGroup.eContents().get(0);
		private final RuleCall cTypeNameExpCSParserRuleCall_0_0 = (RuleCall)cAlternatives_0.eContents().get(0);
		private final RuleCall cTypeLiteralCSParserRuleCall_0_1 = (RuleCall)cAlternatives_0.eContents().get(1);
		private final Assignment cMultiplicityAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cMultiplicityMultiplicityCSParserRuleCall_1_0 = (RuleCall)cMultiplicityAssignment_1.eContents().get(0);
		
		//TypeExpCS returns base::TypedRefCS:
		//	(TypeNameExpCS | TypeLiteralCS) multiplicity=MultiplicityCS?;
		public ParserRule getRule() { return rule; }

		//(TypeNameExpCS | TypeLiteralCS) multiplicity=MultiplicityCS?
		public Group getGroup() { return cGroup; }

		//TypeNameExpCS | TypeLiteralCS
		public Alternatives getAlternatives_0() { return cAlternatives_0; }

		//TypeNameExpCS
		public RuleCall getTypeNameExpCSParserRuleCall_0_0() { return cTypeNameExpCSParserRuleCall_0_0; }

		//TypeLiteralCS
		public RuleCall getTypeLiteralCSParserRuleCall_0_1() { return cTypeLiteralCSParserRuleCall_0_1; }

		//multiplicity=MultiplicityCS?
		public Assignment getMultiplicityAssignment_1() { return cMultiplicityAssignment_1; }

		//MultiplicityCS
		public RuleCall getMultiplicityMultiplicityCSParserRuleCall_1_0() { return cMultiplicityMultiplicityCSParserRuleCall_1_0; }
	}

	public class ExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "ExpCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cAlternatives.eContents().get(0);
		private final RuleCall cPrefixedExpCSParserRuleCall_0_0 = (RuleCall)cGroup_0.eContents().get(0);
		private final Group cGroup_0_1 = (Group)cGroup_0.eContents().get(1);
		private final Action cInfixExpCSOwnedExpressionAction_0_1_0 = (Action)cGroup_0_1.eContents().get(0);
		private final Assignment cOwnedOperatorAssignment_0_1_1 = (Assignment)cGroup_0_1.eContents().get(1);
		private final RuleCall cOwnedOperatorBinaryOperatorCSParserRuleCall_0_1_1_0 = (RuleCall)cOwnedOperatorAssignment_0_1_1.eContents().get(0);
		private final Alternatives cAlternatives_0_1_2 = (Alternatives)cGroup_0_1.eContents().get(2);
		private final Group cGroup_0_1_2_0 = (Group)cAlternatives_0_1_2.eContents().get(0);
		private final Assignment cOwnedExpressionAssignment_0_1_2_0_0 = (Assignment)cGroup_0_1_2_0.eContents().get(0);
		private final RuleCall cOwnedExpressionPrefixedExpCSParserRuleCall_0_1_2_0_0_0 = (RuleCall)cOwnedExpressionAssignment_0_1_2_0_0.eContents().get(0);
		private final Group cGroup_0_1_2_0_1 = (Group)cGroup_0_1_2_0.eContents().get(1);
		private final Assignment cOwnedOperatorAssignment_0_1_2_0_1_0 = (Assignment)cGroup_0_1_2_0_1.eContents().get(0);
		private final RuleCall cOwnedOperatorBinaryOperatorCSParserRuleCall_0_1_2_0_1_0_0 = (RuleCall)cOwnedOperatorAssignment_0_1_2_0_1_0.eContents().get(0);
		private final Assignment cOwnedExpressionAssignment_0_1_2_0_1_1 = (Assignment)cGroup_0_1_2_0_1.eContents().get(1);
		private final RuleCall cOwnedExpressionPrefixedExpCSParserRuleCall_0_1_2_0_1_1_0 = (RuleCall)cOwnedExpressionAssignment_0_1_2_0_1_1.eContents().get(0);
		private final Group cGroup_0_1_2_0_2 = (Group)cGroup_0_1_2_0.eContents().get(2);
		private final Assignment cOwnedOperatorAssignment_0_1_2_0_2_0 = (Assignment)cGroup_0_1_2_0_2.eContents().get(0);
		private final RuleCall cOwnedOperatorBinaryOperatorCSParserRuleCall_0_1_2_0_2_0_0 = (RuleCall)cOwnedOperatorAssignment_0_1_2_0_2_0.eContents().get(0);
		private final Assignment cOwnedExpressionAssignment_0_1_2_0_2_1 = (Assignment)cGroup_0_1_2_0_2.eContents().get(1);
		private final RuleCall cOwnedExpressionLetExpCSParserRuleCall_0_1_2_0_2_1_0 = (RuleCall)cOwnedExpressionAssignment_0_1_2_0_2_1.eContents().get(0);
		private final Assignment cOwnedExpressionAssignment_0_1_2_1 = (Assignment)cAlternatives_0_1_2.eContents().get(1);
		private final RuleCall cOwnedExpressionLetExpCSParserRuleCall_0_1_2_1_0 = (RuleCall)cOwnedExpressionAssignment_0_1_2_1.eContents().get(0);
		private final Group cGroup_1 = (Group)cAlternatives.eContents().get(1);
		private final Action cPrefixExpCSAction_1_0 = (Action)cGroup_1.eContents().get(0);
		private final Assignment cOwnedOperatorAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cOwnedOperatorUnaryOperatorCSParserRuleCall_1_1_0 = (RuleCall)cOwnedOperatorAssignment_1_1.eContents().get(0);
		private final Assignment cOwnedExpressionAssignment_1_2 = (Assignment)cGroup_1.eContents().get(2);
		private final RuleCall cOwnedExpressionLetExpCSParserRuleCall_1_2_0 = (RuleCall)cOwnedExpressionAssignment_1_2.eContents().get(0);
		private final RuleCall cLetExpCSParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		////---------------------------------------------------------------------
		// //  Expressions
		//
		////---------------------------------------------------------------------
		//
		//// An ExpCS permits a LetExpCS only in the final term to ensure
		//
		////  that let is right associative, whereas infix operators are left associative.
		//
		////   a = 64 / 16 / let b : Integer in 8 / let c : Integer in 4 
		// // is
		//
		////   a = (64 / 16) / (let b : Integer in 8 / (let c : Integer in 4 ))
		// ExpCS:
		//	PrefixedExpCS ({InfixExpCS.ownedExpression+=current} ownedOperator+=BinaryOperatorCS (ownedExpression+=PrefixedExpCS
		//	(ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)* (ownedOperator+=BinaryOperatorCS
		//	ownedExpression+=LetExpCS)? | ownedExpression+=LetExpCS))? | {PrefixExpCS} ownedOperator+=UnaryOperatorCS+
		//	ownedExpression=LetExpCS | LetExpCS;
		public ParserRule getRule() { return rule; }

		//PrefixedExpCS ({InfixExpCS.ownedExpression+=current} ownedOperator+=BinaryOperatorCS (ownedExpression+=PrefixedExpCS
		//(ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)* (ownedOperator+=BinaryOperatorCS
		//ownedExpression+=LetExpCS)? | ownedExpression+=LetExpCS))? | {PrefixExpCS} ownedOperator+=UnaryOperatorCS+
		//ownedExpression=LetExpCS | LetExpCS
		public Alternatives getAlternatives() { return cAlternatives; }

		//PrefixedExpCS ({InfixExpCS.ownedExpression+=current} ownedOperator+=BinaryOperatorCS (ownedExpression+=PrefixedExpCS
		//(ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)* (ownedOperator+=BinaryOperatorCS
		//ownedExpression+=LetExpCS)? | ownedExpression+=LetExpCS))?
		public Group getGroup_0() { return cGroup_0; }

		//PrefixedExpCS
		public RuleCall getPrefixedExpCSParserRuleCall_0_0() { return cPrefixedExpCSParserRuleCall_0_0; }

		//({InfixExpCS.ownedExpression+=current} ownedOperator+=BinaryOperatorCS (ownedExpression+=PrefixedExpCS
		//(ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)* (ownedOperator+=BinaryOperatorCS
		//ownedExpression+=LetExpCS)? | ownedExpression+=LetExpCS))?
		public Group getGroup_0_1() { return cGroup_0_1; }

		//{InfixExpCS.ownedExpression+=current}
		public Action getInfixExpCSOwnedExpressionAction_0_1_0() { return cInfixExpCSOwnedExpressionAction_0_1_0; }

		//ownedOperator+=BinaryOperatorCS
		public Assignment getOwnedOperatorAssignment_0_1_1() { return cOwnedOperatorAssignment_0_1_1; }

		//BinaryOperatorCS
		public RuleCall getOwnedOperatorBinaryOperatorCSParserRuleCall_0_1_1_0() { return cOwnedOperatorBinaryOperatorCSParserRuleCall_0_1_1_0; }

		//ownedExpression+=PrefixedExpCS (ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)*
		//(ownedOperator+=BinaryOperatorCS ownedExpression+=LetExpCS)? | ownedExpression+=LetExpCS
		public Alternatives getAlternatives_0_1_2() { return cAlternatives_0_1_2; }

		//ownedExpression+=PrefixedExpCS (ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)*
		//(ownedOperator+=BinaryOperatorCS ownedExpression+=LetExpCS)?
		public Group getGroup_0_1_2_0() { return cGroup_0_1_2_0; }

		//ownedExpression+=PrefixedExpCS
		public Assignment getOwnedExpressionAssignment_0_1_2_0_0() { return cOwnedExpressionAssignment_0_1_2_0_0; }

		//PrefixedExpCS
		public RuleCall getOwnedExpressionPrefixedExpCSParserRuleCall_0_1_2_0_0_0() { return cOwnedExpressionPrefixedExpCSParserRuleCall_0_1_2_0_0_0; }

		//(ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)*
		public Group getGroup_0_1_2_0_1() { return cGroup_0_1_2_0_1; }

		//ownedOperator+=BinaryOperatorCS
		public Assignment getOwnedOperatorAssignment_0_1_2_0_1_0() { return cOwnedOperatorAssignment_0_1_2_0_1_0; }

		//BinaryOperatorCS
		public RuleCall getOwnedOperatorBinaryOperatorCSParserRuleCall_0_1_2_0_1_0_0() { return cOwnedOperatorBinaryOperatorCSParserRuleCall_0_1_2_0_1_0_0; }

		//ownedExpression+=PrefixedExpCS
		public Assignment getOwnedExpressionAssignment_0_1_2_0_1_1() { return cOwnedExpressionAssignment_0_1_2_0_1_1; }

		//PrefixedExpCS
		public RuleCall getOwnedExpressionPrefixedExpCSParserRuleCall_0_1_2_0_1_1_0() { return cOwnedExpressionPrefixedExpCSParserRuleCall_0_1_2_0_1_1_0; }

		//(ownedOperator+=BinaryOperatorCS ownedExpression+=LetExpCS)?
		public Group getGroup_0_1_2_0_2() { return cGroup_0_1_2_0_2; }

		//ownedOperator+=BinaryOperatorCS
		public Assignment getOwnedOperatorAssignment_0_1_2_0_2_0() { return cOwnedOperatorAssignment_0_1_2_0_2_0; }

		//BinaryOperatorCS
		public RuleCall getOwnedOperatorBinaryOperatorCSParserRuleCall_0_1_2_0_2_0_0() { return cOwnedOperatorBinaryOperatorCSParserRuleCall_0_1_2_0_2_0_0; }

		//ownedExpression+=LetExpCS
		public Assignment getOwnedExpressionAssignment_0_1_2_0_2_1() { return cOwnedExpressionAssignment_0_1_2_0_2_1; }

		//LetExpCS
		public RuleCall getOwnedExpressionLetExpCSParserRuleCall_0_1_2_0_2_1_0() { return cOwnedExpressionLetExpCSParserRuleCall_0_1_2_0_2_1_0; }

		//ownedExpression+=LetExpCS
		public Assignment getOwnedExpressionAssignment_0_1_2_1() { return cOwnedExpressionAssignment_0_1_2_1; }

		//LetExpCS
		public RuleCall getOwnedExpressionLetExpCSParserRuleCall_0_1_2_1_0() { return cOwnedExpressionLetExpCSParserRuleCall_0_1_2_1_0; }

		//{PrefixExpCS} ownedOperator+=UnaryOperatorCS+ ownedExpression=LetExpCS
		public Group getGroup_1() { return cGroup_1; }

		//{PrefixExpCS}
		public Action getPrefixExpCSAction_1_0() { return cPrefixExpCSAction_1_0; }

		//ownedOperator+=UnaryOperatorCS+
		public Assignment getOwnedOperatorAssignment_1_1() { return cOwnedOperatorAssignment_1_1; }

		//UnaryOperatorCS
		public RuleCall getOwnedOperatorUnaryOperatorCSParserRuleCall_1_1_0() { return cOwnedOperatorUnaryOperatorCSParserRuleCall_1_1_0; }

		//ownedExpression=LetExpCS
		public Assignment getOwnedExpressionAssignment_1_2() { return cOwnedExpressionAssignment_1_2; }

		//LetExpCS
		public RuleCall getOwnedExpressionLetExpCSParserRuleCall_1_2_0() { return cOwnedExpressionLetExpCSParserRuleCall_1_2_0; }

		//LetExpCS
		public RuleCall getLetExpCSParserRuleCall_2() { return cLetExpCSParserRuleCall_2; }
	}

	public class PrefixedExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "PrefixedExpCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cAlternatives.eContents().get(0);
		private final Action cPrefixExpCSAction_0_0 = (Action)cGroup_0.eContents().get(0);
		private final Assignment cOwnedOperatorAssignment_0_1 = (Assignment)cGroup_0.eContents().get(1);
		private final RuleCall cOwnedOperatorUnaryOperatorCSParserRuleCall_0_1_0 = (RuleCall)cOwnedOperatorAssignment_0_1.eContents().get(0);
		private final Assignment cOwnedExpressionAssignment_0_2 = (Assignment)cGroup_0.eContents().get(2);
		private final RuleCall cOwnedExpressionPrimaryExpCSParserRuleCall_0_2_0 = (RuleCall)cOwnedExpressionAssignment_0_2.eContents().get(0);
		private final RuleCall cPrimaryExpCSParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//PrefixedExpCS returns ExpCS:
		//	{PrefixExpCS} ownedOperator+=UnaryOperatorCS+ ownedExpression=PrimaryExpCS | PrimaryExpCS;
		public ParserRule getRule() { return rule; }

		//{PrefixExpCS} ownedOperator+=UnaryOperatorCS+ ownedExpression=PrimaryExpCS | PrimaryExpCS
		public Alternatives getAlternatives() { return cAlternatives; }

		//{PrefixExpCS} ownedOperator+=UnaryOperatorCS+ ownedExpression=PrimaryExpCS
		public Group getGroup_0() { return cGroup_0; }

		//{PrefixExpCS}
		public Action getPrefixExpCSAction_0_0() { return cPrefixExpCSAction_0_0; }

		//ownedOperator+=UnaryOperatorCS+
		public Assignment getOwnedOperatorAssignment_0_1() { return cOwnedOperatorAssignment_0_1; }

		//UnaryOperatorCS
		public RuleCall getOwnedOperatorUnaryOperatorCSParserRuleCall_0_1_0() { return cOwnedOperatorUnaryOperatorCSParserRuleCall_0_1_0; }

		//ownedExpression=PrimaryExpCS
		public Assignment getOwnedExpressionAssignment_0_2() { return cOwnedExpressionAssignment_0_2; }

		//PrimaryExpCS
		public RuleCall getOwnedExpressionPrimaryExpCSParserRuleCall_0_2_0() { return cOwnedExpressionPrimaryExpCSParserRuleCall_0_2_0; }

		//PrimaryExpCS
		public RuleCall getPrimaryExpCSParserRuleCall_1() { return cPrimaryExpCSParserRuleCall_1; }
	}

	public class PrimaryExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "PrimaryExpCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cNestedExpCSParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cIfExpCSParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cSelfExpCSParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cPrimitiveLiteralExpCSParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		private final RuleCall cTupleLiteralExpCSParserRuleCall_4 = (RuleCall)cAlternatives.eContents().get(4);
		private final RuleCall cCollectionLiteralExpCSParserRuleCall_5 = (RuleCall)cAlternatives.eContents().get(5);
		private final RuleCall cTypeLiteralExpCSParserRuleCall_6 = (RuleCall)cAlternatives.eContents().get(6);
		private final Group cGroup_7 = (Group)cAlternatives.eContents().get(7);
		private final Action cNameExpCSAction_7_0 = (Action)cGroup_7.eContents().get(0);
		private final Assignment cPathNameAssignment_7_1 = (Assignment)cGroup_7.eContents().get(1);
		private final RuleCall cPathNamePathNameCSParserRuleCall_7_1_0 = (RuleCall)cPathNameAssignment_7_1.eContents().get(0);
		private final Alternatives cAlternatives_7_2 = (Alternatives)cGroup_7.eContents().get(2);
		private final Group cGroup_7_2_0 = (Group)cAlternatives_7_2.eContents().get(0);
		private final Action cIndexExpCSNameExpAction_7_2_0_0 = (Action)cGroup_7_2_0.eContents().get(0);
		private final Keyword cLeftSquareBracketKeyword_7_2_0_1 = (Keyword)cGroup_7_2_0.eContents().get(1);
		private final Assignment cFirstIndexesAssignment_7_2_0_2 = (Assignment)cGroup_7_2_0.eContents().get(2);
		private final RuleCall cFirstIndexesExpCSParserRuleCall_7_2_0_2_0 = (RuleCall)cFirstIndexesAssignment_7_2_0_2.eContents().get(0);
		private final Group cGroup_7_2_0_3 = (Group)cGroup_7_2_0.eContents().get(3);
		private final Keyword cCommaKeyword_7_2_0_3_0 = (Keyword)cGroup_7_2_0_3.eContents().get(0);
		private final Assignment cFirstIndexesAssignment_7_2_0_3_1 = (Assignment)cGroup_7_2_0_3.eContents().get(1);
		private final RuleCall cFirstIndexesExpCSParserRuleCall_7_2_0_3_1_0 = (RuleCall)cFirstIndexesAssignment_7_2_0_3_1.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_7_2_0_4 = (Keyword)cGroup_7_2_0.eContents().get(4);
		private final Group cGroup_7_2_0_5 = (Group)cGroup_7_2_0.eContents().get(5);
		private final Keyword cLeftSquareBracketKeyword_7_2_0_5_0 = (Keyword)cGroup_7_2_0_5.eContents().get(0);
		private final Assignment cSecondIndexesAssignment_7_2_0_5_1 = (Assignment)cGroup_7_2_0_5.eContents().get(1);
		private final RuleCall cSecondIndexesExpCSParserRuleCall_7_2_0_5_1_0 = (RuleCall)cSecondIndexesAssignment_7_2_0_5_1.eContents().get(0);
		private final Group cGroup_7_2_0_5_2 = (Group)cGroup_7_2_0_5.eContents().get(2);
		private final Keyword cCommaKeyword_7_2_0_5_2_0 = (Keyword)cGroup_7_2_0_5_2.eContents().get(0);
		private final Assignment cSecondIndexesAssignment_7_2_0_5_2_1 = (Assignment)cGroup_7_2_0_5_2.eContents().get(1);
		private final RuleCall cSecondIndexesExpCSParserRuleCall_7_2_0_5_2_1_0 = (RuleCall)cSecondIndexesAssignment_7_2_0_5_2_1.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_7_2_0_5_3 = (Keyword)cGroup_7_2_0_5.eContents().get(3);
		private final Group cGroup_7_2_0_6 = (Group)cGroup_7_2_0.eContents().get(6);
		private final Assignment cAtPreAssignment_7_2_0_6_0 = (Assignment)cGroup_7_2_0_6.eContents().get(0);
		private final Keyword cAtPreCommercialAtKeyword_7_2_0_6_0_0 = (Keyword)cAtPreAssignment_7_2_0_6_0.eContents().get(0);
		private final Keyword cPreKeyword_7_2_0_6_1 = (Keyword)cGroup_7_2_0_6.eContents().get(1);
		private final Group cGroup_7_2_1 = (Group)cAlternatives_7_2.eContents().get(1);
		private final Action cConstructorExpCSNameExpAction_7_2_1_0 = (Action)cGroup_7_2_1.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_7_2_1_1 = (Keyword)cGroup_7_2_1.eContents().get(1);
		private final Alternatives cAlternatives_7_2_1_2 = (Alternatives)cGroup_7_2_1.eContents().get(2);
		private final Group cGroup_7_2_1_2_0 = (Group)cAlternatives_7_2_1_2.eContents().get(0);
		private final Assignment cOwnedPartsAssignment_7_2_1_2_0_0 = (Assignment)cGroup_7_2_1_2_0.eContents().get(0);
		private final RuleCall cOwnedPartsConstructorPartCSParserRuleCall_7_2_1_2_0_0_0 = (RuleCall)cOwnedPartsAssignment_7_2_1_2_0_0.eContents().get(0);
		private final Group cGroup_7_2_1_2_0_1 = (Group)cGroup_7_2_1_2_0.eContents().get(1);
		private final Keyword cCommaKeyword_7_2_1_2_0_1_0 = (Keyword)cGroup_7_2_1_2_0_1.eContents().get(0);
		private final Assignment cOwnedPartsAssignment_7_2_1_2_0_1_1 = (Assignment)cGroup_7_2_1_2_0_1.eContents().get(1);
		private final RuleCall cOwnedPartsConstructorPartCSParserRuleCall_7_2_1_2_0_1_1_0 = (RuleCall)cOwnedPartsAssignment_7_2_1_2_0_1_1.eContents().get(0);
		private final Assignment cValueAssignment_7_2_1_2_1 = (Assignment)cAlternatives_7_2_1_2.eContents().get(1);
		private final RuleCall cValueStringLiteralParserRuleCall_7_2_1_2_1_0 = (RuleCall)cValueAssignment_7_2_1_2_1.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_7_2_1_3 = (Keyword)cGroup_7_2_1.eContents().get(3);
		private final Group cGroup_7_2_2 = (Group)cAlternatives_7_2.eContents().get(2);
		private final Group cGroup_7_2_2_0 = (Group)cGroup_7_2_2.eContents().get(0);
		private final Assignment cAtPreAssignment_7_2_2_0_0 = (Assignment)cGroup_7_2_2_0.eContents().get(0);
		private final Keyword cAtPreCommercialAtKeyword_7_2_2_0_0_0 = (Keyword)cAtPreAssignment_7_2_2_0_0.eContents().get(0);
		private final Keyword cPreKeyword_7_2_2_0_1 = (Keyword)cGroup_7_2_2_0.eContents().get(1);
		private final Group cGroup_7_2_2_1 = (Group)cGroup_7_2_2.eContents().get(1);
		private final Action cInvocationExpCSNameExpAction_7_2_2_1_0 = (Action)cGroup_7_2_2_1.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_7_2_2_1_1 = (Keyword)cGroup_7_2_2_1.eContents().get(1);
		private final Group cGroup_7_2_2_1_2 = (Group)cGroup_7_2_2_1.eContents().get(2);
		private final Assignment cArgumentAssignment_7_2_2_1_2_0 = (Assignment)cGroup_7_2_2_1_2.eContents().get(0);
		private final RuleCall cArgumentNavigatingArgCSParserRuleCall_7_2_2_1_2_0_0 = (RuleCall)cArgumentAssignment_7_2_2_1_2_0.eContents().get(0);
		private final Assignment cArgumentAssignment_7_2_2_1_2_1 = (Assignment)cGroup_7_2_2_1_2.eContents().get(1);
		private final RuleCall cArgumentNavigatingCommaArgCSParserRuleCall_7_2_2_1_2_1_0 = (RuleCall)cArgumentAssignment_7_2_2_1_2_1.eContents().get(0);
		private final Group cGroup_7_2_2_1_2_2 = (Group)cGroup_7_2_2_1_2.eContents().get(2);
		private final Assignment cArgumentAssignment_7_2_2_1_2_2_0 = (Assignment)cGroup_7_2_2_1_2_2.eContents().get(0);
		private final RuleCall cArgumentNavigatingSemiArgCSParserRuleCall_7_2_2_1_2_2_0_0 = (RuleCall)cArgumentAssignment_7_2_2_1_2_2_0.eContents().get(0);
		private final Assignment cArgumentAssignment_7_2_2_1_2_2_1 = (Assignment)cGroup_7_2_2_1_2_2.eContents().get(1);
		private final RuleCall cArgumentNavigatingCommaArgCSParserRuleCall_7_2_2_1_2_2_1_0 = (RuleCall)cArgumentAssignment_7_2_2_1_2_2_1.eContents().get(0);
		private final Group cGroup_7_2_2_1_2_3 = (Group)cGroup_7_2_2_1_2.eContents().get(3);
		private final Assignment cArgumentAssignment_7_2_2_1_2_3_0 = (Assignment)cGroup_7_2_2_1_2_3.eContents().get(0);
		private final RuleCall cArgumentNavigatingBarArgCSParserRuleCall_7_2_2_1_2_3_0_0 = (RuleCall)cArgumentAssignment_7_2_2_1_2_3_0.eContents().get(0);
		private final Assignment cArgumentAssignment_7_2_2_1_2_3_1 = (Assignment)cGroup_7_2_2_1_2_3.eContents().get(1);
		private final RuleCall cArgumentNavigatingCommaArgCSParserRuleCall_7_2_2_1_2_3_1_0 = (RuleCall)cArgumentAssignment_7_2_2_1_2_3_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_7_2_2_1_3 = (Keyword)cGroup_7_2_2_1.eContents().get(3);
		
		//PrimaryExpCS returns ExpCS:
		//	NestedExpCS | IfExpCS | SelfExpCS | PrimitiveLiteralExpCS | TupleLiteralExpCS | CollectionLiteralExpCS |
		//	TypeLiteralExpCS | {NameExpCS} pathName=PathNameCS ({IndexExpCS.nameExp=current} "[" firstIndexes+=ExpCS (","
		//	firstIndexes+=ExpCS)* "]" ("[" secondIndexes+=ExpCS ("," secondIndexes+=ExpCS)* "]")? (atPre?="@" "pre")? |
		//	{ConstructorExpCS.nameExp=current} "{" ((ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)? |
		//	value=StringLiteral) "}" | (atPre?="@" "pre")? ({InvocationExpCS.nameExp=current} "(" (argument+=NavigatingArgCS
		//	argument+=NavigatingCommaArgCS* (argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)?
		//	(argument+=NavigatingBarArgCS argument+=NavigatingCommaArgCS*)?)? ")")?);
		public ParserRule getRule() { return rule; }

		//NestedExpCS | IfExpCS | SelfExpCS | PrimitiveLiteralExpCS | TupleLiteralExpCS | CollectionLiteralExpCS |
		//TypeLiteralExpCS | {NameExpCS} pathName=PathNameCS ({IndexExpCS.nameExp=current} "[" firstIndexes+=ExpCS (","
		//firstIndexes+=ExpCS)* "]" ("[" secondIndexes+=ExpCS ("," secondIndexes+=ExpCS)* "]")? (atPre?="@" "pre")? |
		//{ConstructorExpCS.nameExp=current} "{" ((ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)? |
		//value=StringLiteral) "}" | (atPre?="@" "pre")? ({InvocationExpCS.nameExp=current} "(" (argument+=NavigatingArgCS
		//argument+=NavigatingCommaArgCS* (argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)?
		//(argument+=NavigatingBarArgCS argument+=NavigatingCommaArgCS*)?)? ")")?)
		public Alternatives getAlternatives() { return cAlternatives; }

		//NestedExpCS
		public RuleCall getNestedExpCSParserRuleCall_0() { return cNestedExpCSParserRuleCall_0; }

		//IfExpCS
		public RuleCall getIfExpCSParserRuleCall_1() { return cIfExpCSParserRuleCall_1; }

		//SelfExpCS
		public RuleCall getSelfExpCSParserRuleCall_2() { return cSelfExpCSParserRuleCall_2; }

		//PrimitiveLiteralExpCS
		public RuleCall getPrimitiveLiteralExpCSParserRuleCall_3() { return cPrimitiveLiteralExpCSParserRuleCall_3; }

		//TupleLiteralExpCS
		public RuleCall getTupleLiteralExpCSParserRuleCall_4() { return cTupleLiteralExpCSParserRuleCall_4; }

		//CollectionLiteralExpCS
		public RuleCall getCollectionLiteralExpCSParserRuleCall_5() { return cCollectionLiteralExpCSParserRuleCall_5; }

		//TypeLiteralExpCS
		public RuleCall getTypeLiteralExpCSParserRuleCall_6() { return cTypeLiteralExpCSParserRuleCall_6; }

		//{NameExpCS} pathName=PathNameCS ({IndexExpCS.nameExp=current} "[" firstIndexes+=ExpCS ("," firstIndexes+=ExpCS)* "]"
		//("[" secondIndexes+=ExpCS ("," secondIndexes+=ExpCS)* "]")? (atPre?="@" "pre")? | {ConstructorExpCS.nameExp=current}
		//"{" ((ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)? | value=StringLiteral) "}" | (atPre?="@"
		//"pre")? ({InvocationExpCS.nameExp=current} "(" (argument+=NavigatingArgCS argument+=NavigatingCommaArgCS*
		//(argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)? (argument+=NavigatingBarArgCS
		//argument+=NavigatingCommaArgCS*)?)? ")")?)
		public Group getGroup_7() { return cGroup_7; }

		//{NameExpCS}
		public Action getNameExpCSAction_7_0() { return cNameExpCSAction_7_0; }

		//pathName=PathNameCS
		public Assignment getPathNameAssignment_7_1() { return cPathNameAssignment_7_1; }

		//PathNameCS
		public RuleCall getPathNamePathNameCSParserRuleCall_7_1_0() { return cPathNamePathNameCSParserRuleCall_7_1_0; }

		//{IndexExpCS.nameExp=current} "[" firstIndexes+=ExpCS ("," firstIndexes+=ExpCS)* "]" ("[" secondIndexes+=ExpCS (","
		//secondIndexes+=ExpCS)* "]")? (atPre?="@" "pre")? | {ConstructorExpCS.nameExp=current} "{"
		//((ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)? | value=StringLiteral) "}" | (atPre?="@"
		//"pre")? ({InvocationExpCS.nameExp=current} "(" (argument+=NavigatingArgCS argument+=NavigatingCommaArgCS*
		//(argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)? (argument+=NavigatingBarArgCS
		//argument+=NavigatingCommaArgCS*)?)? ")")?
		public Alternatives getAlternatives_7_2() { return cAlternatives_7_2; }

		//{IndexExpCS.nameExp=current} "[" firstIndexes+=ExpCS ("," firstIndexes+=ExpCS)* "]" ("[" secondIndexes+=ExpCS (","
		//secondIndexes+=ExpCS)* "]")? (atPre?="@" "pre")?
		public Group getGroup_7_2_0() { return cGroup_7_2_0; }

		//{IndexExpCS.nameExp=current}
		public Action getIndexExpCSNameExpAction_7_2_0_0() { return cIndexExpCSNameExpAction_7_2_0_0; }

		//"["
		public Keyword getLeftSquareBracketKeyword_7_2_0_1() { return cLeftSquareBracketKeyword_7_2_0_1; }

		//firstIndexes+=ExpCS
		public Assignment getFirstIndexesAssignment_7_2_0_2() { return cFirstIndexesAssignment_7_2_0_2; }

		//ExpCS
		public RuleCall getFirstIndexesExpCSParserRuleCall_7_2_0_2_0() { return cFirstIndexesExpCSParserRuleCall_7_2_0_2_0; }

		//("," firstIndexes+=ExpCS)*
		public Group getGroup_7_2_0_3() { return cGroup_7_2_0_3; }

		//","
		public Keyword getCommaKeyword_7_2_0_3_0() { return cCommaKeyword_7_2_0_3_0; }

		//firstIndexes+=ExpCS
		public Assignment getFirstIndexesAssignment_7_2_0_3_1() { return cFirstIndexesAssignment_7_2_0_3_1; }

		//ExpCS
		public RuleCall getFirstIndexesExpCSParserRuleCall_7_2_0_3_1_0() { return cFirstIndexesExpCSParserRuleCall_7_2_0_3_1_0; }

		//"]"
		public Keyword getRightSquareBracketKeyword_7_2_0_4() { return cRightSquareBracketKeyword_7_2_0_4; }

		//("[" secondIndexes+=ExpCS ("," secondIndexes+=ExpCS)* "]")?
		public Group getGroup_7_2_0_5() { return cGroup_7_2_0_5; }

		//"["
		public Keyword getLeftSquareBracketKeyword_7_2_0_5_0() { return cLeftSquareBracketKeyword_7_2_0_5_0; }

		//secondIndexes+=ExpCS
		public Assignment getSecondIndexesAssignment_7_2_0_5_1() { return cSecondIndexesAssignment_7_2_0_5_1; }

		//ExpCS
		public RuleCall getSecondIndexesExpCSParserRuleCall_7_2_0_5_1_0() { return cSecondIndexesExpCSParserRuleCall_7_2_0_5_1_0; }

		//("," secondIndexes+=ExpCS)*
		public Group getGroup_7_2_0_5_2() { return cGroup_7_2_0_5_2; }

		//","
		public Keyword getCommaKeyword_7_2_0_5_2_0() { return cCommaKeyword_7_2_0_5_2_0; }

		//secondIndexes+=ExpCS
		public Assignment getSecondIndexesAssignment_7_2_0_5_2_1() { return cSecondIndexesAssignment_7_2_0_5_2_1; }

		//ExpCS
		public RuleCall getSecondIndexesExpCSParserRuleCall_7_2_0_5_2_1_0() { return cSecondIndexesExpCSParserRuleCall_7_2_0_5_2_1_0; }

		//"]"
		public Keyword getRightSquareBracketKeyword_7_2_0_5_3() { return cRightSquareBracketKeyword_7_2_0_5_3; }

		//(atPre?="@" "pre")?
		public Group getGroup_7_2_0_6() { return cGroup_7_2_0_6; }

		//atPre?="@"
		public Assignment getAtPreAssignment_7_2_0_6_0() { return cAtPreAssignment_7_2_0_6_0; }

		//"@"
		public Keyword getAtPreCommercialAtKeyword_7_2_0_6_0_0() { return cAtPreCommercialAtKeyword_7_2_0_6_0_0; }

		//"pre"
		public Keyword getPreKeyword_7_2_0_6_1() { return cPreKeyword_7_2_0_6_1; }

		//{ConstructorExpCS.nameExp=current} "{" ((ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)? |
		//value=StringLiteral) "}"
		public Group getGroup_7_2_1() { return cGroup_7_2_1; }

		//{ConstructorExpCS.nameExp=current}
		public Action getConstructorExpCSNameExpAction_7_2_1_0() { return cConstructorExpCSNameExpAction_7_2_1_0; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_7_2_1_1() { return cLeftCurlyBracketKeyword_7_2_1_1; }

		//(ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)? | value=StringLiteral
		public Alternatives getAlternatives_7_2_1_2() { return cAlternatives_7_2_1_2; }

		//(ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)?
		public Group getGroup_7_2_1_2_0() { return cGroup_7_2_1_2_0; }

		//ownedParts+=ConstructorPartCS
		public Assignment getOwnedPartsAssignment_7_2_1_2_0_0() { return cOwnedPartsAssignment_7_2_1_2_0_0; }

		//ConstructorPartCS
		public RuleCall getOwnedPartsConstructorPartCSParserRuleCall_7_2_1_2_0_0_0() { return cOwnedPartsConstructorPartCSParserRuleCall_7_2_1_2_0_0_0; }

		//("," ownedParts+=ConstructorPartCS)*
		public Group getGroup_7_2_1_2_0_1() { return cGroup_7_2_1_2_0_1; }

		//","
		public Keyword getCommaKeyword_7_2_1_2_0_1_0() { return cCommaKeyword_7_2_1_2_0_1_0; }

		//ownedParts+=ConstructorPartCS
		public Assignment getOwnedPartsAssignment_7_2_1_2_0_1_1() { return cOwnedPartsAssignment_7_2_1_2_0_1_1; }

		//ConstructorPartCS
		public RuleCall getOwnedPartsConstructorPartCSParserRuleCall_7_2_1_2_0_1_1_0() { return cOwnedPartsConstructorPartCSParserRuleCall_7_2_1_2_0_1_1_0; }

		//value=StringLiteral
		public Assignment getValueAssignment_7_2_1_2_1() { return cValueAssignment_7_2_1_2_1; }

		//StringLiteral
		public RuleCall getValueStringLiteralParserRuleCall_7_2_1_2_1_0() { return cValueStringLiteralParserRuleCall_7_2_1_2_1_0; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_7_2_1_3() { return cRightCurlyBracketKeyword_7_2_1_3; }

		//(atPre?="@" "pre")? ({InvocationExpCS.nameExp=current} "(" (argument+=NavigatingArgCS argument+=NavigatingCommaArgCS*
		//(argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)? (argument+=NavigatingBarArgCS
		//argument+=NavigatingCommaArgCS*)?)? ")")?
		public Group getGroup_7_2_2() { return cGroup_7_2_2; }

		//(atPre?="@" "pre")?
		public Group getGroup_7_2_2_0() { return cGroup_7_2_2_0; }

		//atPre?="@"
		public Assignment getAtPreAssignment_7_2_2_0_0() { return cAtPreAssignment_7_2_2_0_0; }

		//"@"
		public Keyword getAtPreCommercialAtKeyword_7_2_2_0_0_0() { return cAtPreCommercialAtKeyword_7_2_2_0_0_0; }

		//"pre"
		public Keyword getPreKeyword_7_2_2_0_1() { return cPreKeyword_7_2_2_0_1; }

		//({InvocationExpCS.nameExp=current} "(" (argument+=NavigatingArgCS argument+=NavigatingCommaArgCS*
		//(argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)? (argument+=NavigatingBarArgCS
		//argument+=NavigatingCommaArgCS*)?)? ")")?
		public Group getGroup_7_2_2_1() { return cGroup_7_2_2_1; }

		//{InvocationExpCS.nameExp=current}
		public Action getInvocationExpCSNameExpAction_7_2_2_1_0() { return cInvocationExpCSNameExpAction_7_2_2_1_0; }

		//"("
		public Keyword getLeftParenthesisKeyword_7_2_2_1_1() { return cLeftParenthesisKeyword_7_2_2_1_1; }

		//(argument+=NavigatingArgCS argument+=NavigatingCommaArgCS* (argument+=NavigatingSemiArgCS
		//argument+=NavigatingCommaArgCS*)? (argument+=NavigatingBarArgCS argument+=NavigatingCommaArgCS*)?)?
		public Group getGroup_7_2_2_1_2() { return cGroup_7_2_2_1_2; }

		//argument+=NavigatingArgCS
		public Assignment getArgumentAssignment_7_2_2_1_2_0() { return cArgumentAssignment_7_2_2_1_2_0; }

		//NavigatingArgCS
		public RuleCall getArgumentNavigatingArgCSParserRuleCall_7_2_2_1_2_0_0() { return cArgumentNavigatingArgCSParserRuleCall_7_2_2_1_2_0_0; }

		//argument+=NavigatingCommaArgCS*
		public Assignment getArgumentAssignment_7_2_2_1_2_1() { return cArgumentAssignment_7_2_2_1_2_1; }

		//NavigatingCommaArgCS
		public RuleCall getArgumentNavigatingCommaArgCSParserRuleCall_7_2_2_1_2_1_0() { return cArgumentNavigatingCommaArgCSParserRuleCall_7_2_2_1_2_1_0; }

		//(argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)?
		public Group getGroup_7_2_2_1_2_2() { return cGroup_7_2_2_1_2_2; }

		//argument+=NavigatingSemiArgCS
		public Assignment getArgumentAssignment_7_2_2_1_2_2_0() { return cArgumentAssignment_7_2_2_1_2_2_0; }

		//NavigatingSemiArgCS
		public RuleCall getArgumentNavigatingSemiArgCSParserRuleCall_7_2_2_1_2_2_0_0() { return cArgumentNavigatingSemiArgCSParserRuleCall_7_2_2_1_2_2_0_0; }

		//argument+=NavigatingCommaArgCS*
		public Assignment getArgumentAssignment_7_2_2_1_2_2_1() { return cArgumentAssignment_7_2_2_1_2_2_1; }

		//NavigatingCommaArgCS
		public RuleCall getArgumentNavigatingCommaArgCSParserRuleCall_7_2_2_1_2_2_1_0() { return cArgumentNavigatingCommaArgCSParserRuleCall_7_2_2_1_2_2_1_0; }

		//(argument+=NavigatingBarArgCS argument+=NavigatingCommaArgCS*)?
		public Group getGroup_7_2_2_1_2_3() { return cGroup_7_2_2_1_2_3; }

		//argument+=NavigatingBarArgCS
		public Assignment getArgumentAssignment_7_2_2_1_2_3_0() { return cArgumentAssignment_7_2_2_1_2_3_0; }

		//NavigatingBarArgCS
		public RuleCall getArgumentNavigatingBarArgCSParserRuleCall_7_2_2_1_2_3_0_0() { return cArgumentNavigatingBarArgCSParserRuleCall_7_2_2_1_2_3_0_0; }

		//argument+=NavigatingCommaArgCS*
		public Assignment getArgumentAssignment_7_2_2_1_2_3_1() { return cArgumentAssignment_7_2_2_1_2_3_1; }

		//NavigatingCommaArgCS
		public RuleCall getArgumentNavigatingCommaArgCSParserRuleCall_7_2_2_1_2_3_1_0() { return cArgumentNavigatingCommaArgCSParserRuleCall_7_2_2_1_2_3_1_0; }

		//")"
		public Keyword getRightParenthesisKeyword_7_2_2_1_3() { return cRightParenthesisKeyword_7_2_2_1_3; }
	}

	public class NavigatingArgCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "NavigatingArgCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameNavigatingArgExpCSParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cColonKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cOwnedTypeAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cOwnedTypeTypeExpCSParserRuleCall_1_1_0 = (RuleCall)cOwnedTypeAssignment_1_1.eContents().get(0);
		private final Group cGroup_1_2 = (Group)cGroup_1.eContents().get(2);
		private final Keyword cEqualsSignKeyword_1_2_0 = (Keyword)cGroup_1_2.eContents().get(0);
		private final Assignment cInitAssignment_1_2_1 = (Assignment)cGroup_1_2.eContents().get(1);
		private final RuleCall cInitExpCSParserRuleCall_1_2_1_0 = (RuleCall)cInitAssignment_1_2_1.eContents().get(0);
		
		//// Type-less init is an illegal infix expression
		// NavigatingArgCS:
		//	name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
		public ParserRule getRule() { return rule; }

		//name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?
		public Group getGroup() { return cGroup; }

		//name=NavigatingArgExpCS
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//NavigatingArgExpCS
		public RuleCall getNameNavigatingArgExpCSParserRuleCall_0_0() { return cNameNavigatingArgExpCSParserRuleCall_0_0; }

		//(":" ownedType=TypeExpCS ("=" init=ExpCS)?)?
		public Group getGroup_1() { return cGroup_1; }

		//":"
		public Keyword getColonKeyword_1_0() { return cColonKeyword_1_0; }

		//ownedType=TypeExpCS
		public Assignment getOwnedTypeAssignment_1_1() { return cOwnedTypeAssignment_1_1; }

		//TypeExpCS
		public RuleCall getOwnedTypeTypeExpCSParserRuleCall_1_1_0() { return cOwnedTypeTypeExpCSParserRuleCall_1_1_0; }

		//("=" init=ExpCS)?
		public Group getGroup_1_2() { return cGroup_1_2; }

		//"="
		public Keyword getEqualsSignKeyword_1_2_0() { return cEqualsSignKeyword_1_2_0; }

		//init=ExpCS
		public Assignment getInitAssignment_1_2_1() { return cInitAssignment_1_2_1; }

		//ExpCS
		public RuleCall getInitExpCSParserRuleCall_1_2_1_0() { return cInitExpCSParserRuleCall_1_2_1_0; }
	}

	public class NavigatingBarArgCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "NavigatingBarArgCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cPrefixAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final Keyword cPrefixVerticalLineKeyword_0_0 = (Keyword)cPrefixAssignment_0.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameNavigatingArgExpCSParserRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cColonKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cOwnedTypeAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cOwnedTypeTypeExpCSParserRuleCall_2_1_0 = (RuleCall)cOwnedTypeAssignment_2_1.eContents().get(0);
		private final Group cGroup_2_2 = (Group)cGroup_2.eContents().get(2);
		private final Keyword cEqualsSignKeyword_2_2_0 = (Keyword)cGroup_2_2.eContents().get(0);
		private final Assignment cInitAssignment_2_2_1 = (Assignment)cGroup_2_2.eContents().get(1);
		private final RuleCall cInitExpCSParserRuleCall_2_2_1_0 = (RuleCall)cInitAssignment_2_2_1.eContents().get(0);
		
		//// Type-less init is an illegal infix expression
		// NavigatingBarArgCS returns NavigatingArgCS:
		//	prefix="|" name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
		public ParserRule getRule() { return rule; }

		//prefix="|" name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?
		public Group getGroup() { return cGroup; }

		//prefix="|"
		public Assignment getPrefixAssignment_0() { return cPrefixAssignment_0; }

		//"|"
		public Keyword getPrefixVerticalLineKeyword_0_0() { return cPrefixVerticalLineKeyword_0_0; }

		//name=NavigatingArgExpCS
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }

		//NavigatingArgExpCS
		public RuleCall getNameNavigatingArgExpCSParserRuleCall_1_0() { return cNameNavigatingArgExpCSParserRuleCall_1_0; }

		//(":" ownedType=TypeExpCS ("=" init=ExpCS)?)?
		public Group getGroup_2() { return cGroup_2; }

		//":"
		public Keyword getColonKeyword_2_0() { return cColonKeyword_2_0; }

		//ownedType=TypeExpCS
		public Assignment getOwnedTypeAssignment_2_1() { return cOwnedTypeAssignment_2_1; }

		//TypeExpCS
		public RuleCall getOwnedTypeTypeExpCSParserRuleCall_2_1_0() { return cOwnedTypeTypeExpCSParserRuleCall_2_1_0; }

		//("=" init=ExpCS)?
		public Group getGroup_2_2() { return cGroup_2_2; }

		//"="
		public Keyword getEqualsSignKeyword_2_2_0() { return cEqualsSignKeyword_2_2_0; }

		//init=ExpCS
		public Assignment getInitAssignment_2_2_1() { return cInitAssignment_2_2_1; }

		//ExpCS
		public RuleCall getInitExpCSParserRuleCall_2_2_1_0() { return cInitExpCSParserRuleCall_2_2_1_0; }
	}

	public class NavigatingCommaArgCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "NavigatingCommaArgCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cPrefixAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final Keyword cPrefixCommaKeyword_0_0 = (Keyword)cPrefixAssignment_0.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameNavigatingArgExpCSParserRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cColonKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cOwnedTypeAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cOwnedTypeTypeExpCSParserRuleCall_2_1_0 = (RuleCall)cOwnedTypeAssignment_2_1.eContents().get(0);
		private final Group cGroup_2_2 = (Group)cGroup_2.eContents().get(2);
		private final Keyword cEqualsSignKeyword_2_2_0 = (Keyword)cGroup_2_2.eContents().get(0);
		private final Assignment cInitAssignment_2_2_1 = (Assignment)cGroup_2_2.eContents().get(1);
		private final RuleCall cInitExpCSParserRuleCall_2_2_1_0 = (RuleCall)cInitAssignment_2_2_1.eContents().get(0);
		
		//// Type-less init is an illegal infix expression
		// NavigatingCommaArgCS returns NavigatingArgCS:
		//	prefix="," name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
		public ParserRule getRule() { return rule; }

		//prefix="," name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?
		public Group getGroup() { return cGroup; }

		//prefix=","
		public Assignment getPrefixAssignment_0() { return cPrefixAssignment_0; }

		//","
		public Keyword getPrefixCommaKeyword_0_0() { return cPrefixCommaKeyword_0_0; }

		//name=NavigatingArgExpCS
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }

		//NavigatingArgExpCS
		public RuleCall getNameNavigatingArgExpCSParserRuleCall_1_0() { return cNameNavigatingArgExpCSParserRuleCall_1_0; }

		//(":" ownedType=TypeExpCS ("=" init=ExpCS)?)?
		public Group getGroup_2() { return cGroup_2; }

		//":"
		public Keyword getColonKeyword_2_0() { return cColonKeyword_2_0; }

		//ownedType=TypeExpCS
		public Assignment getOwnedTypeAssignment_2_1() { return cOwnedTypeAssignment_2_1; }

		//TypeExpCS
		public RuleCall getOwnedTypeTypeExpCSParserRuleCall_2_1_0() { return cOwnedTypeTypeExpCSParserRuleCall_2_1_0; }

		//("=" init=ExpCS)?
		public Group getGroup_2_2() { return cGroup_2_2; }

		//"="
		public Keyword getEqualsSignKeyword_2_2_0() { return cEqualsSignKeyword_2_2_0; }

		//init=ExpCS
		public Assignment getInitAssignment_2_2_1() { return cInitAssignment_2_2_1; }

		//ExpCS
		public RuleCall getInitExpCSParserRuleCall_2_2_1_0() { return cInitExpCSParserRuleCall_2_2_1_0; }
	}

	public class NavigatingSemiArgCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "NavigatingSemiArgCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cPrefixAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final Keyword cPrefixSemicolonKeyword_0_0 = (Keyword)cPrefixAssignment_0.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameNavigatingArgExpCSParserRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cColonKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cOwnedTypeAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cOwnedTypeTypeExpCSParserRuleCall_2_1_0 = (RuleCall)cOwnedTypeAssignment_2_1.eContents().get(0);
		private final Group cGroup_2_2 = (Group)cGroup_2.eContents().get(2);
		private final Keyword cEqualsSignKeyword_2_2_0 = (Keyword)cGroup_2_2.eContents().get(0);
		private final Assignment cInitAssignment_2_2_1 = (Assignment)cGroup_2_2.eContents().get(1);
		private final RuleCall cInitExpCSParserRuleCall_2_2_1_0 = (RuleCall)cInitAssignment_2_2_1.eContents().get(0);
		
		//// Type-less init is an illegal infix expression
		// NavigatingSemiArgCS returns NavigatingArgCS:
		//	prefix=";" name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
		public ParserRule getRule() { return rule; }

		//prefix=";" name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?
		public Group getGroup() { return cGroup; }

		//prefix=";"
		public Assignment getPrefixAssignment_0() { return cPrefixAssignment_0; }

		//";"
		public Keyword getPrefixSemicolonKeyword_0_0() { return cPrefixSemicolonKeyword_0_0; }

		//name=NavigatingArgExpCS
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }

		//NavigatingArgExpCS
		public RuleCall getNameNavigatingArgExpCSParserRuleCall_1_0() { return cNameNavigatingArgExpCSParserRuleCall_1_0; }

		//(":" ownedType=TypeExpCS ("=" init=ExpCS)?)?
		public Group getGroup_2() { return cGroup_2; }

		//":"
		public Keyword getColonKeyword_2_0() { return cColonKeyword_2_0; }

		//ownedType=TypeExpCS
		public Assignment getOwnedTypeAssignment_2_1() { return cOwnedTypeAssignment_2_1; }

		//TypeExpCS
		public RuleCall getOwnedTypeTypeExpCSParserRuleCall_2_1_0() { return cOwnedTypeTypeExpCSParserRuleCall_2_1_0; }

		//("=" init=ExpCS)?
		public Group getGroup_2_2() { return cGroup_2_2; }

		//"="
		public Keyword getEqualsSignKeyword_2_2_0() { return cEqualsSignKeyword_2_2_0; }

		//init=ExpCS
		public Assignment getInitAssignment_2_2_1() { return cInitAssignment_2_2_1; }

		//ExpCS
		public RuleCall getInitExpCSParserRuleCall_2_2_1_0() { return cInitExpCSParserRuleCall_2_2_1_0; }
	}

	public class NavigatingArgExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "NavigatingArgExpCS");
		private final RuleCall cExpCSParserRuleCall = (RuleCall)rule.eContents().get(1);
		
		//// Intended to be overridden
		// //	'?'	-- defined by Complete OCL
		// NavigatingArgExpCS returns ExpCS:
		//	ExpCS;
		public ParserRule getRule() { return rule; }

		//ExpCS
		public RuleCall getExpCSParserRuleCall() { return cExpCSParserRuleCall; }
	}

	public class IfExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "IfExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cIfKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cConditionAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cConditionExpCSParserRuleCall_1_0 = (RuleCall)cConditionAssignment_1.eContents().get(0);
		private final Keyword cThenKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cThenExpressionAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cThenExpressionExpCSParserRuleCall_3_0 = (RuleCall)cThenExpressionAssignment_3.eContents().get(0);
		private final Keyword cElseKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cElseExpressionAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final RuleCall cElseExpressionExpCSParserRuleCall_5_0 = (RuleCall)cElseExpressionAssignment_5.eContents().get(0);
		private final Keyword cEndifKeyword_6 = (Keyword)cGroup.eContents().get(6);
		
		//IfExpCS:
		//	"if" condition=ExpCS "then" thenExpression=ExpCS "else" elseExpression=ExpCS "endif";
		public ParserRule getRule() { return rule; }

		//"if" condition=ExpCS "then" thenExpression=ExpCS "else" elseExpression=ExpCS "endif"
		public Group getGroup() { return cGroup; }

		//"if"
		public Keyword getIfKeyword_0() { return cIfKeyword_0; }

		//condition=ExpCS
		public Assignment getConditionAssignment_1() { return cConditionAssignment_1; }

		//ExpCS
		public RuleCall getConditionExpCSParserRuleCall_1_0() { return cConditionExpCSParserRuleCall_1_0; }

		//"then"
		public Keyword getThenKeyword_2() { return cThenKeyword_2; }

		//thenExpression=ExpCS
		public Assignment getThenExpressionAssignment_3() { return cThenExpressionAssignment_3; }

		//ExpCS
		public RuleCall getThenExpressionExpCSParserRuleCall_3_0() { return cThenExpressionExpCSParserRuleCall_3_0; }

		//"else"
		public Keyword getElseKeyword_4() { return cElseKeyword_4; }

		//elseExpression=ExpCS
		public Assignment getElseExpressionAssignment_5() { return cElseExpressionAssignment_5; }

		//ExpCS
		public RuleCall getElseExpressionExpCSParserRuleCall_5_0() { return cElseExpressionExpCSParserRuleCall_5_0; }

		//"endif"
		public Keyword getEndifKeyword_6() { return cEndifKeyword_6; }
	}

	public class LetExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "LetExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLetKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cVariableAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cVariableLetVariableCSParserRuleCall_1_0 = (RuleCall)cVariableAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cCommaKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cVariableAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cVariableLetVariableCSParserRuleCall_2_1_0 = (RuleCall)cVariableAssignment_2_1.eContents().get(0);
		private final Keyword cInKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cInAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cInExpCSParserRuleCall_4_0 = (RuleCall)cInAssignment_4.eContents().get(0);
		
		//LetExpCS:
		//	"let" variable+=LetVariableCS ("," variable+=LetVariableCS)* "in" in=ExpCS;
		public ParserRule getRule() { return rule; }

		//"let" variable+=LetVariableCS ("," variable+=LetVariableCS)* "in" in=ExpCS
		public Group getGroup() { return cGroup; }

		//"let"
		public Keyword getLetKeyword_0() { return cLetKeyword_0; }

		//variable+=LetVariableCS
		public Assignment getVariableAssignment_1() { return cVariableAssignment_1; }

		//LetVariableCS
		public RuleCall getVariableLetVariableCSParserRuleCall_1_0() { return cVariableLetVariableCSParserRuleCall_1_0; }

		//("," variable+=LetVariableCS)*
		public Group getGroup_2() { return cGroup_2; }

		//","
		public Keyword getCommaKeyword_2_0() { return cCommaKeyword_2_0; }

		//variable+=LetVariableCS
		public Assignment getVariableAssignment_2_1() { return cVariableAssignment_2_1; }

		//LetVariableCS
		public RuleCall getVariableLetVariableCSParserRuleCall_2_1_0() { return cVariableLetVariableCSParserRuleCall_2_1_0; }

		//"in"
		public Keyword getInKeyword_3() { return cInKeyword_3; }

		//in=ExpCS
		public Assignment getInAssignment_4() { return cInAssignment_4; }

		//ExpCS
		public RuleCall getInExpCSParserRuleCall_4_0() { return cInExpCSParserRuleCall_4_0; }
	}

	public class LetVariableCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "LetVariableCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cColonKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cOwnedTypeAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cOwnedTypeTypeExpCSParserRuleCall_1_1_0 = (RuleCall)cOwnedTypeAssignment_1_1.eContents().get(0);
		private final Keyword cEqualsSignKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cInitExpressionAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cInitExpressionExpCSParserRuleCall_3_0 = (RuleCall)cInitExpressionAssignment_3.eContents().get(0);
		
		//LetVariableCS:
		//	name=UnrestrictedName (":" ownedType=TypeExpCS)? "=" initExpression=ExpCS;
		public ParserRule getRule() { return rule; }

		//name=UnrestrictedName (":" ownedType=TypeExpCS)? "=" initExpression=ExpCS
		public Group getGroup() { return cGroup; }

		//name=UnrestrictedName
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_0_0() { return cNameUnrestrictedNameParserRuleCall_0_0; }

		//(":" ownedType=TypeExpCS)?
		public Group getGroup_1() { return cGroup_1; }

		//":"
		public Keyword getColonKeyword_1_0() { return cColonKeyword_1_0; }

		//ownedType=TypeExpCS
		public Assignment getOwnedTypeAssignment_1_1() { return cOwnedTypeAssignment_1_1; }

		//TypeExpCS
		public RuleCall getOwnedTypeTypeExpCSParserRuleCall_1_1_0() { return cOwnedTypeTypeExpCSParserRuleCall_1_1_0; }

		//"="
		public Keyword getEqualsSignKeyword_2() { return cEqualsSignKeyword_2; }

		//initExpression=ExpCS
		public Assignment getInitExpressionAssignment_3() { return cInitExpressionAssignment_3; }

		//ExpCS
		public RuleCall getInitExpressionExpCSParserRuleCall_3_0() { return cInitExpressionExpCSParserRuleCall_3_0; }
	}

	public class NestedExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "NestedExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLeftParenthesisKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cSourceAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cSourceExpCSParserRuleCall_1_0 = (RuleCall)cSourceAssignment_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_2 = (Keyword)cGroup.eContents().get(2);
		
		//NestedExpCS:
		//	"(" source=ExpCS ")";
		public ParserRule getRule() { return rule; }

		//"(" source=ExpCS ")"
		public Group getGroup() { return cGroup; }

		//"("
		public Keyword getLeftParenthesisKeyword_0() { return cLeftParenthesisKeyword_0; }

		//source=ExpCS
		public Assignment getSourceAssignment_1() { return cSourceAssignment_1; }

		//ExpCS
		public RuleCall getSourceExpCSParserRuleCall_1_0() { return cSourceExpCSParserRuleCall_1_0; }

		//")"
		public Keyword getRightParenthesisKeyword_2() { return cRightParenthesisKeyword_2; }
	}

	public class SelfExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "SelfExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cSelfExpCSAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cSelfKeyword_1 = (Keyword)cGroup.eContents().get(1);
		
		//SelfExpCS:
		//	{SelfExpCS} "self";
		public ParserRule getRule() { return rule; }

		//{SelfExpCS} "self"
		public Group getGroup() { return cGroup; }

		//{SelfExpCS}
		public Action getSelfExpCSAction_0() { return cSelfExpCSAction_0; }

		//"self"
		public Keyword getSelfKeyword_1() { return cSelfKeyword_1; }
	}
	
	
	private ModelElements pModel;
	private TerminalRule tESCAPED_CHARACTER;
	private TerminalRule tLETTER_CHARACTER;
	private TerminalRule tDOUBLE_QUOTED_STRING;
	private TerminalRule tSINGLE_QUOTED_STRING;
	private TerminalRule tML_SINGLE_QUOTED_STRING;
	private TerminalRule tSIMPLE_ID;
	private TerminalRule tESCAPED_ID;
	private IDElements pID;
	private TerminalRule tINT;
	private LOWERElements pLOWER;
	private UPPERElements pUPPER;
	private NUMBER_LITERALElements pNUMBER_LITERAL;
	private TerminalRule tML_COMMENT;
	private TerminalRule tSL_COMMENT;
	private TerminalRule tWS;
	private TerminalRule tANY_OTHER;
	private URIElements pURI;
	private EssentialOCLReservedKeywordElements pEssentialOCLReservedKeyword;
	private EssentialOCLUnaryOperatorCSElements pEssentialOCLUnaryOperatorCS;
	private EssentialOCLInfixOperatorCSElements pEssentialOCLInfixOperatorCS;
	private EssentialOCLNavigationOperatorCSElements pEssentialOCLNavigationOperatorCS;
	private IdentifierElements pIdentifier;
	private StringLiteralElements pStringLiteral;
	private BinaryOperatorCSElements pBinaryOperatorCS;
	private InfixOperatorCSElements pInfixOperatorCS;
	private NavigationOperatorCSElements pNavigationOperatorCS;
	private UnaryOperatorCSElements pUnaryOperatorCS;
	private EssentialOCLUnrestrictedNameElements pEssentialOCLUnrestrictedName;
	private UnrestrictedNameElements pUnrestrictedName;
	private EssentialOCLUnreservedNameElements pEssentialOCLUnreservedName;
	private UnreservedNameElements pUnreservedName;
	private PathNameCSElements pPathNameCS;
	private FirstPathElementCSElements pFirstPathElementCS;
	private NextPathElementCSElements pNextPathElementCS;
	private URIPathNameCSElements pURIPathNameCS;
	private URIFirstPathElementCSElements pURIFirstPathElementCS;
	private PrimitiveTypeIdentifierElements pPrimitiveTypeIdentifier;
	private PrimitiveTypeCSElements pPrimitiveTypeCS;
	private CollectionTypeIdentifierElements pCollectionTypeIdentifier;
	private CollectionTypeCSElements pCollectionTypeCS;
	private MultiplicityBoundsCSElements pMultiplicityBoundsCS;
	private MultiplicityCSElements pMultiplicityCS;
	private MultiplicityStringCSElements pMultiplicityStringCS;
	private TupleTypeCSElements pTupleTypeCS;
	private TuplePartCSElements pTuplePartCS;
	private CollectionLiteralExpCSElements pCollectionLiteralExpCS;
	private CollectionLiteralPartCSElements pCollectionLiteralPartCS;
	private ConstructorPartCSElements pConstructorPartCS;
	private PrimitiveLiteralExpCSElements pPrimitiveLiteralExpCS;
	private TupleLiteralExpCSElements pTupleLiteralExpCS;
	private TupleLiteralPartCSElements pTupleLiteralPartCS;
	private NumberLiteralExpCSElements pNumberLiteralExpCS;
	private StringLiteralExpCSElements pStringLiteralExpCS;
	private BooleanLiteralExpCSElements pBooleanLiteralExpCS;
	private UnlimitedNaturalLiteralExpCSElements pUnlimitedNaturalLiteralExpCS;
	private InvalidLiteralExpCSElements pInvalidLiteralExpCS;
	private NullLiteralExpCSElements pNullLiteralExpCS;
	private TypeLiteralCSElements pTypeLiteralCS;
	private TypeLiteralWithMultiplicityCSElements pTypeLiteralWithMultiplicityCS;
	private TypeLiteralExpCSElements pTypeLiteralExpCS;
	private TypeNameExpCSElements pTypeNameExpCS;
	private TypeExpCSElements pTypeExpCS;
	private ExpCSElements pExpCS;
	private PrefixedExpCSElements pPrefixedExpCS;
	private PrimaryExpCSElements pPrimaryExpCS;
	private NavigatingArgCSElements pNavigatingArgCS;
	private NavigatingBarArgCSElements pNavigatingBarArgCS;
	private NavigatingCommaArgCSElements pNavigatingCommaArgCS;
	private NavigatingSemiArgCSElements pNavigatingSemiArgCS;
	private NavigatingArgExpCSElements pNavigatingArgExpCS;
	private IfExpCSElements pIfExpCS;
	private LetExpCSElements pLetExpCS;
	private LetVariableCSElements pLetVariableCS;
	private NestedExpCSElements pNestedExpCS;
	private SelfExpCSElements pSelfExpCS;
	
	private final Grammar grammar;

	@Inject
	public EssentialOCLGrammarAccess(GrammarProvider grammarProvider) {
		this.grammar = internalFindGrammar(grammarProvider);
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("org.eclipse.ocl.examples.xtext.essentialocl.EssentialOCL".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	
	public Grammar getGrammar() {
		return grammar;
	}
	

	
	////generate essentialOCLCST "http://www.eclipse.org/ocl/3.0.0/EssentialOCLCST"
	// Model returns ContextCS:
	//	ownedExpression=ExpCS;
	public ModelElements getModelAccess() {
		return (pModel != null) ? pModel : (pModel = new ModelElements());
	}
	
	public ParserRule getModelRule() {
		return getModelAccess().getRule();
	}

	//terminal fragment ESCAPED_CHARACTER:
	//	"\\" ("b" | "t" | "n" | "f" | "r" | "u" | "\"" | "\'" | "\\");
	public TerminalRule getESCAPED_CHARACTERRule() {
		return (tESCAPED_CHARACTER != null) ? tESCAPED_CHARACTER : (tESCAPED_CHARACTER = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "ESCAPED_CHARACTER"));
	} 

	//terminal fragment LETTER_CHARACTER:
	//	"a".."z" | "A".."Z" | "_";
	public TerminalRule getLETTER_CHARACTERRule() {
		return (tLETTER_CHARACTER != null) ? tLETTER_CHARACTER : (tLETTER_CHARACTER = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "LETTER_CHARACTER"));
	} 

	//terminal DOUBLE_QUOTED_STRING:
	//	"\"" (ESCAPED_CHARACTER | !("\\" | "\""))* "\"";
	public TerminalRule getDOUBLE_QUOTED_STRINGRule() {
		return (tDOUBLE_QUOTED_STRING != null) ? tDOUBLE_QUOTED_STRING : (tDOUBLE_QUOTED_STRING = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "DOUBLE_QUOTED_STRING"));
	} 

	//terminal SINGLE_QUOTED_STRING:
	//	"\'" (ESCAPED_CHARACTER | !("\\" | "\'"))* "\'";
	public TerminalRule getSINGLE_QUOTED_STRINGRule() {
		return (tSINGLE_QUOTED_STRING != null) ? tSINGLE_QUOTED_STRING : (tSINGLE_QUOTED_STRING = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "SINGLE_QUOTED_STRING"));
	} 

	//terminal ML_SINGLE_QUOTED_STRING:
	//	"/\'"->"\'/";
	public TerminalRule getML_SINGLE_QUOTED_STRINGRule() {
		return (tML_SINGLE_QUOTED_STRING != null) ? tML_SINGLE_QUOTED_STRING : (tML_SINGLE_QUOTED_STRING = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "ML_SINGLE_QUOTED_STRING"));
	} 

	//terminal SIMPLE_ID:
	//	LETTER_CHARACTER (LETTER_CHARACTER | "0".."9")*;
	public TerminalRule getSIMPLE_IDRule() {
		return (tSIMPLE_ID != null) ? tSIMPLE_ID : (tSIMPLE_ID = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "SIMPLE_ID"));
	} 

	//terminal ESCAPED_ID:
	//	"_" SINGLE_QUOTED_STRING;
	public TerminalRule getESCAPED_IDRule() {
		return (tESCAPED_ID != null) ? tESCAPED_ID : (tESCAPED_ID = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "ESCAPED_ID"));
	} 

	//ID:
	//	SIMPLE_ID | ESCAPED_ID;
	public IDElements getIDAccess() {
		return (pID != null) ? pID : (pID = new IDElements());
	}
	
	public ParserRule getIDRule() {
		return getIDAccess().getRule();
	}

	//// String to allow diverse re-use
	// // multiple leading zeroes occur as floating point fractional part
	// terminal INT:
	//	"0".."9"+;
	public TerminalRule getINTRule() {
		return (tINT != null) ? tINT : (tINT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "INT"));
	} 

	//LOWER returns ecore::EInt:
	//	INT;
	public LOWERElements getLOWERAccess() {
		return (pLOWER != null) ? pLOWER : (pLOWER = new LOWERElements());
	}
	
	public ParserRule getLOWERRule() {
		return getLOWERAccess().getRule();
	}

	//UPPER returns ecore::EInt:
	//	INT | "*";
	public UPPERElements getUPPERAccess() {
		return (pUPPER != null) ? pUPPER : (pUPPER = new UPPERElements());
	}
	
	public ParserRule getUPPERRule() {
		return getUPPERAccess().getRule();
	}

	//// Not terminal to allow parser backtracking to sort out "5..7"
	//
	//// EssentialOCLTokenSource pieces this together ('.' INT)? (('e' | 'E') ('+' | '-')? INT)?;
	// NUMBER_LITERAL returns
	//BigNumber:
	//	INT;
	public NUMBER_LITERALElements getNUMBER_LITERALAccess() {
		return (pNUMBER_LITERAL != null) ? pNUMBER_LITERAL : (pNUMBER_LITERAL = new NUMBER_LITERALElements());
	}
	
	public ParserRule getNUMBER_LITERALRule() {
		return getNUMBER_LITERALAccess().getRule();
	}

	//terminal ML_COMMENT:
	//	"/ *"->"* /";
	public TerminalRule getML_COMMENTRule() {
		return (tML_COMMENT != null) ? tML_COMMENT : (tML_COMMENT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "ML_COMMENT"));
	} 

	//terminal SL_COMMENT:
	//	"--" !("\n" | "\r")* ("\r"? "\n")?;
	public TerminalRule getSL_COMMENTRule() {
		return (tSL_COMMENT != null) ? tSL_COMMENT : (tSL_COMMENT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "SL_COMMENT"));
	} 

	//terminal WS:
	//	(" " | "\t" | "\r" | "\n")+;
	public TerminalRule getWSRule() {
		return (tWS != null) ? tWS : (tWS = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "WS"));
	} 

	//terminal ANY_OTHER:
	//	.;
	public TerminalRule getANY_OTHERRule() {
		return (tANY_OTHER != null) ? tANY_OTHER : (tANY_OTHER = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "ANY_OTHER"));
	} 

	//URI:
	//	SINGLE_QUOTED_STRING;
	public URIElements getURIAccess() {
		return (pURI != null) ? pURI : (pURI = new URIElements());
	}
	
	public ParserRule getURIRule() {
		return getURIAccess().getRule();
	}

	//EssentialOCLReservedKeyword:
	//	"and" | "else" | "endif" | "if" | "implies" | "in" | "let" | "not" | "or" | "then" | "xor";
	public EssentialOCLReservedKeywordElements getEssentialOCLReservedKeywordAccess() {
		return (pEssentialOCLReservedKeyword != null) ? pEssentialOCLReservedKeyword : (pEssentialOCLReservedKeyword = new EssentialOCLReservedKeywordElements());
	}
	
	public ParserRule getEssentialOCLReservedKeywordRule() {
		return getEssentialOCLReservedKeywordAccess().getRule();
	}

	//EssentialOCLUnaryOperatorCS returns UnaryOperatorCS:
	//	name=("-" | "not");
	public EssentialOCLUnaryOperatorCSElements getEssentialOCLUnaryOperatorCSAccess() {
		return (pEssentialOCLUnaryOperatorCS != null) ? pEssentialOCLUnaryOperatorCS : (pEssentialOCLUnaryOperatorCS = new EssentialOCLUnaryOperatorCSElements());
	}
	
	public ParserRule getEssentialOCLUnaryOperatorCSRule() {
		return getEssentialOCLUnaryOperatorCSAccess().getRule();
	}

	//EssentialOCLInfixOperatorCS returns BinaryOperatorCS:
	//	name=("*" | "/" | "+" | "-" | ">" | "<" | ">=" | "<=" | "=" | "<>" | "and" | "or" | "xor" | "implies");
	public EssentialOCLInfixOperatorCSElements getEssentialOCLInfixOperatorCSAccess() {
		return (pEssentialOCLInfixOperatorCS != null) ? pEssentialOCLInfixOperatorCS : (pEssentialOCLInfixOperatorCS = new EssentialOCLInfixOperatorCSElements());
	}
	
	public ParserRule getEssentialOCLInfixOperatorCSRule() {
		return getEssentialOCLInfixOperatorCSAccess().getRule();
	}

	//EssentialOCLNavigationOperatorCS returns NavigationOperatorCS:
	//	name=("." | "->");
	public EssentialOCLNavigationOperatorCSElements getEssentialOCLNavigationOperatorCSAccess() {
		return (pEssentialOCLNavigationOperatorCS != null) ? pEssentialOCLNavigationOperatorCS : (pEssentialOCLNavigationOperatorCS = new EssentialOCLNavigationOperatorCSElements());
	}
	
	public ParserRule getEssentialOCLNavigationOperatorCSRule() {
		return getEssentialOCLNavigationOperatorCSAccess().getRule();
	}

	//Identifier:
	//	ID;
	public IdentifierElements getIdentifierAccess() {
		return (pIdentifier != null) ? pIdentifier : (pIdentifier = new IdentifierElements());
	}
	
	public ParserRule getIdentifierRule() {
		return getIdentifierAccess().getRule();
	}

	//StringLiteral:
	//	SINGLE_QUOTED_STRING;
	public StringLiteralElements getStringLiteralAccess() {
		return (pStringLiteral != null) ? pStringLiteral : (pStringLiteral = new StringLiteralElements());
	}
	
	public ParserRule getStringLiteralRule() {
		return getStringLiteralAccess().getRule();
	}

	//BinaryOperatorCS:
	//	InfixOperatorCS | NavigationOperatorCS;
	public BinaryOperatorCSElements getBinaryOperatorCSAccess() {
		return (pBinaryOperatorCS != null) ? pBinaryOperatorCS : (pBinaryOperatorCS = new BinaryOperatorCSElements());
	}
	
	public ParserRule getBinaryOperatorCSRule() {
		return getBinaryOperatorCSAccess().getRule();
	}

	//// Intended to be overrideable
	// InfixOperatorCS returns BinaryOperatorCS:
	//	EssentialOCLInfixOperatorCS;
	public InfixOperatorCSElements getInfixOperatorCSAccess() {
		return (pInfixOperatorCS != null) ? pInfixOperatorCS : (pInfixOperatorCS = new InfixOperatorCSElements());
	}
	
	public ParserRule getInfixOperatorCSRule() {
		return getInfixOperatorCSAccess().getRule();
	}

	//// Intended to be overrideable
	// NavigationOperatorCS:
	//	EssentialOCLNavigationOperatorCS;
	public NavigationOperatorCSElements getNavigationOperatorCSAccess() {
		return (pNavigationOperatorCS != null) ? pNavigationOperatorCS : (pNavigationOperatorCS = new NavigationOperatorCSElements());
	}
	
	public ParserRule getNavigationOperatorCSRule() {
		return getNavigationOperatorCSAccess().getRule();
	}

	//// Intended to be overrideable
	// UnaryOperatorCS:
	//	EssentialOCLUnaryOperatorCS;
	public UnaryOperatorCSElements getUnaryOperatorCSAccess() {
		return (pUnaryOperatorCS != null) ? pUnaryOperatorCS : (pUnaryOperatorCS = new UnaryOperatorCSElements());
	}
	
	public ParserRule getUnaryOperatorCSRule() {
		return getUnaryOperatorCSAccess().getRule();
	}

	////---------------------------------------------------------------------
	// //  Names
	//
	////---------------------------------------------------------------------
	// EssentialOCLUnrestrictedName returns
	//ecore::EString:
	//	Identifier;
	public EssentialOCLUnrestrictedNameElements getEssentialOCLUnrestrictedNameAccess() {
		return (pEssentialOCLUnrestrictedName != null) ? pEssentialOCLUnrestrictedName : (pEssentialOCLUnrestrictedName = new EssentialOCLUnrestrictedNameElements());
	}
	
	public ParserRule getEssentialOCLUnrestrictedNameRule() {
		return getEssentialOCLUnrestrictedNameAccess().getRule();
	}

	//// Intended to be overridden
	// UnrestrictedName returns ecore::EString:
	//	EssentialOCLUnrestrictedName;
	public UnrestrictedNameElements getUnrestrictedNameAccess() {
		return (pUnrestrictedName != null) ? pUnrestrictedName : (pUnrestrictedName = new UnrestrictedNameElements());
	}
	
	public ParserRule getUnrestrictedNameRule() {
		return getUnrestrictedNameAccess().getRule();
	}

	//EssentialOCLUnreservedName returns ecore::EString:
	//	UnrestrictedName | CollectionTypeIdentifier | PrimitiveTypeIdentifier | "Tuple";
	public EssentialOCLUnreservedNameElements getEssentialOCLUnreservedNameAccess() {
		return (pEssentialOCLUnreservedName != null) ? pEssentialOCLUnreservedName : (pEssentialOCLUnreservedName = new EssentialOCLUnreservedNameElements());
	}
	
	public ParserRule getEssentialOCLUnreservedNameRule() {
		return getEssentialOCLUnreservedNameAccess().getRule();
	}

	//// Intended to be overridden
	// UnreservedName returns ecore::EString:
	//	EssentialOCLUnreservedName;
	public UnreservedNameElements getUnreservedNameAccess() {
		return (pUnreservedName != null) ? pUnreservedName : (pUnreservedName = new UnreservedNameElements());
	}
	
	public ParserRule getUnreservedNameRule() {
		return getUnreservedNameAccess().getRule();
	}

	//PathNameCS returns base::PathNameCS:
	//	path+=FirstPathElementCS ("::" path+=NextPathElementCS)*;
	public PathNameCSElements getPathNameCSAccess() {
		return (pPathNameCS != null) ? pPathNameCS : (pPathNameCS = new PathNameCSElements());
	}
	
	public ParserRule getPathNameCSRule() {
		return getPathNameCSAccess().getRule();
	}

	//FirstPathElementCS returns base::PathElementCS:
	//	element=[pivot::NamedElement|UnrestrictedName];
	public FirstPathElementCSElements getFirstPathElementCSAccess() {
		return (pFirstPathElementCS != null) ? pFirstPathElementCS : (pFirstPathElementCS = new FirstPathElementCSElements());
	}
	
	public ParserRule getFirstPathElementCSRule() {
		return getFirstPathElementCSAccess().getRule();
	}

	//NextPathElementCS returns base::PathElementCS:
	//	element=[pivot::NamedElement|UnreservedName];
	public NextPathElementCSElements getNextPathElementCSAccess() {
		return (pNextPathElementCS != null) ? pNextPathElementCS : (pNextPathElementCS = new NextPathElementCSElements());
	}
	
	public ParserRule getNextPathElementCSRule() {
		return getNextPathElementCSAccess().getRule();
	}

	//URIPathNameCS returns base::PathNameCS:
	//	path+=URIFirstPathElementCS ("::" path+=NextPathElementCS)*;
	public URIPathNameCSElements getURIPathNameCSAccess() {
		return (pURIPathNameCS != null) ? pURIPathNameCS : (pURIPathNameCS = new URIPathNameCSElements());
	}
	
	public ParserRule getURIPathNameCSRule() {
		return getURIPathNameCSAccess().getRule();
	}

	//URIFirstPathElementCS returns base::PathElementCS:
	//	element=[pivot::NamedElement|UnrestrictedName] | {base::PathElementWithURICS} element=[pivot::Namespace|URI];
	public URIFirstPathElementCSElements getURIFirstPathElementCSAccess() {
		return (pURIFirstPathElementCS != null) ? pURIFirstPathElementCS : (pURIFirstPathElementCS = new URIFirstPathElementCSElements());
	}
	
	public ParserRule getURIFirstPathElementCSRule() {
		return getURIFirstPathElementCSAccess().getRule();
	}

	////---------------------------------------------------------------------
	// //  Types
	//
	////---------------------------------------------------------------------
	// PrimitiveTypeIdentifier:
	//	"Boolean" | "Integer" | "Real" | "String" | "UnlimitedNatural" | "OclAny" | "OclInvalid" | "OclVoid";
	public PrimitiveTypeIdentifierElements getPrimitiveTypeIdentifierAccess() {
		return (pPrimitiveTypeIdentifier != null) ? pPrimitiveTypeIdentifier : (pPrimitiveTypeIdentifier = new PrimitiveTypeIdentifierElements());
	}
	
	public ParserRule getPrimitiveTypeIdentifierRule() {
		return getPrimitiveTypeIdentifierAccess().getRule();
	}

	//PrimitiveTypeCS returns base::PrimitiveTypeRefCS:
	//	name=PrimitiveTypeIdentifier;
	public PrimitiveTypeCSElements getPrimitiveTypeCSAccess() {
		return (pPrimitiveTypeCS != null) ? pPrimitiveTypeCS : (pPrimitiveTypeCS = new PrimitiveTypeCSElements());
	}
	
	public ParserRule getPrimitiveTypeCSRule() {
		return getPrimitiveTypeCSAccess().getRule();
	}

	//CollectionTypeIdentifier returns ecore::EString:
	//	"Set" | "Bag" | "Sequence" | "Collection" | "OrderedSet";
	public CollectionTypeIdentifierElements getCollectionTypeIdentifierAccess() {
		return (pCollectionTypeIdentifier != null) ? pCollectionTypeIdentifier : (pCollectionTypeIdentifier = new CollectionTypeIdentifierElements());
	}
	
	public ParserRule getCollectionTypeIdentifierRule() {
		return getCollectionTypeIdentifierAccess().getRule();
	}

	//CollectionTypeCS:
	//	name=CollectionTypeIdentifier ("(" ownedType=TypeExpCS ")")?;
	public CollectionTypeCSElements getCollectionTypeCSAccess() {
		return (pCollectionTypeCS != null) ? pCollectionTypeCS : (pCollectionTypeCS = new CollectionTypeCSElements());
	}
	
	public ParserRule getCollectionTypeCSRule() {
		return getCollectionTypeCSAccess().getRule();
	}

	//MultiplicityBoundsCS returns base::MultiplicityBoundsCS:
	//	lowerBound=LOWER (".." upperBound=UPPER)?;
	public MultiplicityBoundsCSElements getMultiplicityBoundsCSAccess() {
		return (pMultiplicityBoundsCS != null) ? pMultiplicityBoundsCS : (pMultiplicityBoundsCS = new MultiplicityBoundsCSElements());
	}
	
	public ParserRule getMultiplicityBoundsCSRule() {
		return getMultiplicityBoundsCSAccess().getRule();
	}

	//MultiplicityCS returns base::MultiplicityCS:
	//	"[" (MultiplicityBoundsCS | MultiplicityStringCS) "]";
	public MultiplicityCSElements getMultiplicityCSAccess() {
		return (pMultiplicityCS != null) ? pMultiplicityCS : (pMultiplicityCS = new MultiplicityCSElements());
	}
	
	public ParserRule getMultiplicityCSRule() {
		return getMultiplicityCSAccess().getRule();
	}

	//MultiplicityStringCS returns base::MultiplicityStringCS:
	//	stringBounds=("*" | "+" | "?");
	public MultiplicityStringCSElements getMultiplicityStringCSAccess() {
		return (pMultiplicityStringCS != null) ? pMultiplicityStringCS : (pMultiplicityStringCS = new MultiplicityStringCSElements());
	}
	
	public ParserRule getMultiplicityStringCSRule() {
		return getMultiplicityStringCSAccess().getRule();
	}

	//TupleTypeCS returns base::TupleTypeCS:
	//	name="Tuple" ("(" (ownedParts+=TuplePartCS ("," ownedParts+=TuplePartCS)*)? ")")?;
	public TupleTypeCSElements getTupleTypeCSAccess() {
		return (pTupleTypeCS != null) ? pTupleTypeCS : (pTupleTypeCS = new TupleTypeCSElements());
	}
	
	public ParserRule getTupleTypeCSRule() {
		return getTupleTypeCSAccess().getRule();
	}

	//TuplePartCS returns base::TuplePartCS:
	//	name=UnrestrictedName ":" ownedType=TypeExpCS;
	public TuplePartCSElements getTuplePartCSAccess() {
		return (pTuplePartCS != null) ? pTuplePartCS : (pTuplePartCS = new TuplePartCSElements());
	}
	
	public ParserRule getTuplePartCSRule() {
		return getTuplePartCSAccess().getRule();
	}

	////---------------------------------------------------------------------
	// //  Literals
	//
	////---------------------------------------------------------------------
	// CollectionLiteralExpCS:
	//	ownedType=CollectionTypeCS "{" (ownedParts+=CollectionLiteralPartCS ("," ownedParts+=CollectionLiteralPartCS)*)? "}";
	public CollectionLiteralExpCSElements getCollectionLiteralExpCSAccess() {
		return (pCollectionLiteralExpCS != null) ? pCollectionLiteralExpCS : (pCollectionLiteralExpCS = new CollectionLiteralExpCSElements());
	}
	
	public ParserRule getCollectionLiteralExpCSRule() {
		return getCollectionLiteralExpCSAccess().getRule();
	}

	//CollectionLiteralPartCS:
	//	expressionCS=ExpCS (".." lastExpressionCS=ExpCS)?;
	public CollectionLiteralPartCSElements getCollectionLiteralPartCSAccess() {
		return (pCollectionLiteralPartCS != null) ? pCollectionLiteralPartCS : (pCollectionLiteralPartCS = new CollectionLiteralPartCSElements());
	}
	
	public ParserRule getCollectionLiteralPartCSRule() {
		return getCollectionLiteralPartCSAccess().getRule();
	}

	//ConstructorPartCS:
	//	property=[pivot::Property|UnrestrictedName] "=" initExpression=ExpCS;
	public ConstructorPartCSElements getConstructorPartCSAccess() {
		return (pConstructorPartCS != null) ? pConstructorPartCS : (pConstructorPartCS = new ConstructorPartCSElements());
	}
	
	public ParserRule getConstructorPartCSRule() {
		return getConstructorPartCSAccess().getRule();
	}

	//PrimitiveLiteralExpCS:
	//	NumberLiteralExpCS | StringLiteralExpCS | BooleanLiteralExpCS | UnlimitedNaturalLiteralExpCS | InvalidLiteralExpCS |
	//	NullLiteralExpCS;
	public PrimitiveLiteralExpCSElements getPrimitiveLiteralExpCSAccess() {
		return (pPrimitiveLiteralExpCS != null) ? pPrimitiveLiteralExpCS : (pPrimitiveLiteralExpCS = new PrimitiveLiteralExpCSElements());
	}
	
	public ParserRule getPrimitiveLiteralExpCSRule() {
		return getPrimitiveLiteralExpCSAccess().getRule();
	}

	//TupleLiteralExpCS:
	//	"Tuple" "{" ownedParts+=TupleLiteralPartCS ("," ownedParts+=TupleLiteralPartCS)* "}";
	public TupleLiteralExpCSElements getTupleLiteralExpCSAccess() {
		return (pTupleLiteralExpCS != null) ? pTupleLiteralExpCS : (pTupleLiteralExpCS = new TupleLiteralExpCSElements());
	}
	
	public ParserRule getTupleLiteralExpCSRule() {
		return getTupleLiteralExpCSAccess().getRule();
	}

	//TupleLiteralPartCS:
	//	name=UnrestrictedName (":" ownedType=TypeExpCS)? "=" initExpression=ExpCS;
	public TupleLiteralPartCSElements getTupleLiteralPartCSAccess() {
		return (pTupleLiteralPartCS != null) ? pTupleLiteralPartCS : (pTupleLiteralPartCS = new TupleLiteralPartCSElements());
	}
	
	public ParserRule getTupleLiteralPartCSRule() {
		return getTupleLiteralPartCSAccess().getRule();
	}

	//NumberLiteralExpCS:
	//	name=NUMBER_LITERAL;
	public NumberLiteralExpCSElements getNumberLiteralExpCSAccess() {
		return (pNumberLiteralExpCS != null) ? pNumberLiteralExpCS : (pNumberLiteralExpCS = new NumberLiteralExpCSElements());
	}
	
	public ParserRule getNumberLiteralExpCSRule() {
		return getNumberLiteralExpCSAccess().getRule();
	}

	//StringLiteralExpCS:
	//	name+=StringLiteral+;
	public StringLiteralExpCSElements getStringLiteralExpCSAccess() {
		return (pStringLiteralExpCS != null) ? pStringLiteralExpCS : (pStringLiteralExpCS = new StringLiteralExpCSElements());
	}
	
	public ParserRule getStringLiteralExpCSRule() {
		return getStringLiteralExpCSAccess().getRule();
	}

	//BooleanLiteralExpCS:
	//	name="true" | name="false";
	public BooleanLiteralExpCSElements getBooleanLiteralExpCSAccess() {
		return (pBooleanLiteralExpCS != null) ? pBooleanLiteralExpCS : (pBooleanLiteralExpCS = new BooleanLiteralExpCSElements());
	}
	
	public ParserRule getBooleanLiteralExpCSRule() {
		return getBooleanLiteralExpCSAccess().getRule();
	}

	//UnlimitedNaturalLiteralExpCS:
	//	{UnlimitedNaturalLiteralExpCS} "*";
	public UnlimitedNaturalLiteralExpCSElements getUnlimitedNaturalLiteralExpCSAccess() {
		return (pUnlimitedNaturalLiteralExpCS != null) ? pUnlimitedNaturalLiteralExpCS : (pUnlimitedNaturalLiteralExpCS = new UnlimitedNaturalLiteralExpCSElements());
	}
	
	public ParserRule getUnlimitedNaturalLiteralExpCSRule() {
		return getUnlimitedNaturalLiteralExpCSAccess().getRule();
	}

	//InvalidLiteralExpCS:
	//	{InvalidLiteralExpCS} "invalid";
	public InvalidLiteralExpCSElements getInvalidLiteralExpCSAccess() {
		return (pInvalidLiteralExpCS != null) ? pInvalidLiteralExpCS : (pInvalidLiteralExpCS = new InvalidLiteralExpCSElements());
	}
	
	public ParserRule getInvalidLiteralExpCSRule() {
		return getInvalidLiteralExpCSAccess().getRule();
	}

	//NullLiteralExpCS:
	//	{NullLiteralExpCS} "null";
	public NullLiteralExpCSElements getNullLiteralExpCSAccess() {
		return (pNullLiteralExpCS != null) ? pNullLiteralExpCS : (pNullLiteralExpCS = new NullLiteralExpCSElements());
	}
	
	public ParserRule getNullLiteralExpCSRule() {
		return getNullLiteralExpCSAccess().getRule();
	}

	//TypeLiteralCS returns base::TypedRefCS:
	//	PrimitiveTypeCS | CollectionTypeCS | TupleTypeCS;
	public TypeLiteralCSElements getTypeLiteralCSAccess() {
		return (pTypeLiteralCS != null) ? pTypeLiteralCS : (pTypeLiteralCS = new TypeLiteralCSElements());
	}
	
	public ParserRule getTypeLiteralCSRule() {
		return getTypeLiteralCSAccess().getRule();
	}

	//TypeLiteralWithMultiplicityCS returns base::TypedRefCS:
	//	TypeLiteralCS multiplicity=MultiplicityCS?;
	public TypeLiteralWithMultiplicityCSElements getTypeLiteralWithMultiplicityCSAccess() {
		return (pTypeLiteralWithMultiplicityCS != null) ? pTypeLiteralWithMultiplicityCS : (pTypeLiteralWithMultiplicityCS = new TypeLiteralWithMultiplicityCSElements());
	}
	
	public ParserRule getTypeLiteralWithMultiplicityCSRule() {
		return getTypeLiteralWithMultiplicityCSAccess().getRule();
	}

	//TypeLiteralExpCS:
	//	ownedType=TypeLiteralWithMultiplicityCS;
	public TypeLiteralExpCSElements getTypeLiteralExpCSAccess() {
		return (pTypeLiteralExpCS != null) ? pTypeLiteralExpCS : (pTypeLiteralExpCS = new TypeLiteralExpCSElements());
	}
	
	public ParserRule getTypeLiteralExpCSRule() {
		return getTypeLiteralExpCSAccess().getRule();
	}

	//TypeNameExpCS:
	//	pathName=PathNameCS;
	public TypeNameExpCSElements getTypeNameExpCSAccess() {
		return (pTypeNameExpCS != null) ? pTypeNameExpCS : (pTypeNameExpCS = new TypeNameExpCSElements());
	}
	
	public ParserRule getTypeNameExpCSRule() {
		return getTypeNameExpCSAccess().getRule();
	}

	//TypeExpCS returns base::TypedRefCS:
	//	(TypeNameExpCS | TypeLiteralCS) multiplicity=MultiplicityCS?;
	public TypeExpCSElements getTypeExpCSAccess() {
		return (pTypeExpCS != null) ? pTypeExpCS : (pTypeExpCS = new TypeExpCSElements());
	}
	
	public ParserRule getTypeExpCSRule() {
		return getTypeExpCSAccess().getRule();
	}

	////---------------------------------------------------------------------
	// //  Expressions
	//
	////---------------------------------------------------------------------
	//
	//// An ExpCS permits a LetExpCS only in the final term to ensure
	//
	////  that let is right associative, whereas infix operators are left associative.
	//
	////   a = 64 / 16 / let b : Integer in 8 / let c : Integer in 4 
	// // is
	//
	////   a = (64 / 16) / (let b : Integer in 8 / (let c : Integer in 4 ))
	// ExpCS:
	//	PrefixedExpCS ({InfixExpCS.ownedExpression+=current} ownedOperator+=BinaryOperatorCS (ownedExpression+=PrefixedExpCS
	//	(ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)* (ownedOperator+=BinaryOperatorCS
	//	ownedExpression+=LetExpCS)? | ownedExpression+=LetExpCS))? | {PrefixExpCS} ownedOperator+=UnaryOperatorCS+
	//	ownedExpression=LetExpCS | LetExpCS;
	public ExpCSElements getExpCSAccess() {
		return (pExpCS != null) ? pExpCS : (pExpCS = new ExpCSElements());
	}
	
	public ParserRule getExpCSRule() {
		return getExpCSAccess().getRule();
	}

	//PrefixedExpCS returns ExpCS:
	//	{PrefixExpCS} ownedOperator+=UnaryOperatorCS+ ownedExpression=PrimaryExpCS | PrimaryExpCS;
	public PrefixedExpCSElements getPrefixedExpCSAccess() {
		return (pPrefixedExpCS != null) ? pPrefixedExpCS : (pPrefixedExpCS = new PrefixedExpCSElements());
	}
	
	public ParserRule getPrefixedExpCSRule() {
		return getPrefixedExpCSAccess().getRule();
	}

	//PrimaryExpCS returns ExpCS:
	//	NestedExpCS | IfExpCS | SelfExpCS | PrimitiveLiteralExpCS | TupleLiteralExpCS | CollectionLiteralExpCS |
	//	TypeLiteralExpCS | {NameExpCS} pathName=PathNameCS ({IndexExpCS.nameExp=current} "[" firstIndexes+=ExpCS (","
	//	firstIndexes+=ExpCS)* "]" ("[" secondIndexes+=ExpCS ("," secondIndexes+=ExpCS)* "]")? (atPre?="@" "pre")? |
	//	{ConstructorExpCS.nameExp=current} "{" ((ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)? |
	//	value=StringLiteral) "}" | (atPre?="@" "pre")? ({InvocationExpCS.nameExp=current} "(" (argument+=NavigatingArgCS
	//	argument+=NavigatingCommaArgCS* (argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)?
	//	(argument+=NavigatingBarArgCS argument+=NavigatingCommaArgCS*)?)? ")")?);
	public PrimaryExpCSElements getPrimaryExpCSAccess() {
		return (pPrimaryExpCS != null) ? pPrimaryExpCS : (pPrimaryExpCS = new PrimaryExpCSElements());
	}
	
	public ParserRule getPrimaryExpCSRule() {
		return getPrimaryExpCSAccess().getRule();
	}

	//// Type-less init is an illegal infix expression
	// NavigatingArgCS:
	//	name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
	public NavigatingArgCSElements getNavigatingArgCSAccess() {
		return (pNavigatingArgCS != null) ? pNavigatingArgCS : (pNavigatingArgCS = new NavigatingArgCSElements());
	}
	
	public ParserRule getNavigatingArgCSRule() {
		return getNavigatingArgCSAccess().getRule();
	}

	//// Type-less init is an illegal infix expression
	// NavigatingBarArgCS returns NavigatingArgCS:
	//	prefix="|" name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
	public NavigatingBarArgCSElements getNavigatingBarArgCSAccess() {
		return (pNavigatingBarArgCS != null) ? pNavigatingBarArgCS : (pNavigatingBarArgCS = new NavigatingBarArgCSElements());
	}
	
	public ParserRule getNavigatingBarArgCSRule() {
		return getNavigatingBarArgCSAccess().getRule();
	}

	//// Type-less init is an illegal infix expression
	// NavigatingCommaArgCS returns NavigatingArgCS:
	//	prefix="," name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
	public NavigatingCommaArgCSElements getNavigatingCommaArgCSAccess() {
		return (pNavigatingCommaArgCS != null) ? pNavigatingCommaArgCS : (pNavigatingCommaArgCS = new NavigatingCommaArgCSElements());
	}
	
	public ParserRule getNavigatingCommaArgCSRule() {
		return getNavigatingCommaArgCSAccess().getRule();
	}

	//// Type-less init is an illegal infix expression
	// NavigatingSemiArgCS returns NavigatingArgCS:
	//	prefix=";" name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
	public NavigatingSemiArgCSElements getNavigatingSemiArgCSAccess() {
		return (pNavigatingSemiArgCS != null) ? pNavigatingSemiArgCS : (pNavigatingSemiArgCS = new NavigatingSemiArgCSElements());
	}
	
	public ParserRule getNavigatingSemiArgCSRule() {
		return getNavigatingSemiArgCSAccess().getRule();
	}

	//// Intended to be overridden
	// //	'?'	-- defined by Complete OCL
	// NavigatingArgExpCS returns ExpCS:
	//	ExpCS;
	public NavigatingArgExpCSElements getNavigatingArgExpCSAccess() {
		return (pNavigatingArgExpCS != null) ? pNavigatingArgExpCS : (pNavigatingArgExpCS = new NavigatingArgExpCSElements());
	}
	
	public ParserRule getNavigatingArgExpCSRule() {
		return getNavigatingArgExpCSAccess().getRule();
	}

	//IfExpCS:
	//	"if" condition=ExpCS "then" thenExpression=ExpCS "else" elseExpression=ExpCS "endif";
	public IfExpCSElements getIfExpCSAccess() {
		return (pIfExpCS != null) ? pIfExpCS : (pIfExpCS = new IfExpCSElements());
	}
	
	public ParserRule getIfExpCSRule() {
		return getIfExpCSAccess().getRule();
	}

	//LetExpCS:
	//	"let" variable+=LetVariableCS ("," variable+=LetVariableCS)* "in" in=ExpCS;
	public LetExpCSElements getLetExpCSAccess() {
		return (pLetExpCS != null) ? pLetExpCS : (pLetExpCS = new LetExpCSElements());
	}
	
	public ParserRule getLetExpCSRule() {
		return getLetExpCSAccess().getRule();
	}

	//LetVariableCS:
	//	name=UnrestrictedName (":" ownedType=TypeExpCS)? "=" initExpression=ExpCS;
	public LetVariableCSElements getLetVariableCSAccess() {
		return (pLetVariableCS != null) ? pLetVariableCS : (pLetVariableCS = new LetVariableCSElements());
	}
	
	public ParserRule getLetVariableCSRule() {
		return getLetVariableCSAccess().getRule();
	}

	//NestedExpCS:
	//	"(" source=ExpCS ")";
	public NestedExpCSElements getNestedExpCSAccess() {
		return (pNestedExpCS != null) ? pNestedExpCS : (pNestedExpCS = new NestedExpCSElements());
	}
	
	public ParserRule getNestedExpCSRule() {
		return getNestedExpCSAccess().getRule();
	}

	//SelfExpCS:
	//	{SelfExpCS} "self";
	public SelfExpCSElements getSelfExpCSAccess() {
		return (pSelfExpCS != null) ? pSelfExpCS : (pSelfExpCS = new SelfExpCSElements());
	}
	
	public ParserRule getSelfExpCSRule() {
		return getSelfExpCSAccess().getRule();
	}
}
