/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.scoping;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.scoping.Attribution;
import org.eclipse.ocl.examples.pivot.scoping.EmptyAttribution;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.attributes.ImportCSAttribution;
import org.eclipse.ocl.examples.xtext.base.basecs.BaseCSPackage;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ImportCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ModelElementRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.basecs.SpecificationCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.cs2as.CS2Pivot;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.ConstructorPartCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.ContextCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.ExpSpecificationCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.InvocationExpCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.LetExpCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.LetVariableCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.NavigatingArgCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.NavigationOperatorCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.EssentialOCLCSPackage;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.InfixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.InvocationExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NavigationOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NestedExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.OperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.PrefixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.TypeNameExpCS;

public class EssentialOCLScoping {
    public static void init() {
        Map registry = Attribution.REGISTRY;
        registry.put(EssentialOCLCSPackage.Literals.CONSTRUCTOR_PART_CS, ConstructorPartCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSPackage.Literals.CONTEXT_CS, ContextCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSPackage.Literals.EXP_SPECIFICATION_CS, ExpSpecificationCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSPackage.Literals.INVOCATION_EXP_CS, InvocationExpCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSPackage.Literals.LET_EXP_CS, LetExpCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSPackage.Literals.LET_VARIABLE_CS, LetVariableCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSPackage.Literals.NAVIGATING_ARG_CS, NavigatingArgCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSPackage.Literals.NAVIGATION_OPERATOR_CS, NavigationOperatorCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSPackage.Literals.TUPLE_LITERAL_EXP_CS, EmptyAttribution.INSTANCE);
        CS2Pivot.addUnresolvedProxyMessageProvider((CS2Pivot.UnresolvedProxyMessageProvider)new PathElementCSUnresolvedProxyMessageProvider());
    }

    private static final class PathElementCSUnresolvedProxyMessageProvider
    extends CS2Pivot.AbstractUnresolvedProxyMessageProvider {
        private PathElementCSUnresolvedProxyMessageProvider() {
            super(BaseCSPackage.Literals.PATH_ELEMENT_CS__ELEMENT);
        }

        public String getMessage(@NonNull EObject eObject, @NonNull String linkText) {
            ExpCS csSource;
            String messageTemplate;
            PathElementCS csPathElement = (PathElementCS)eObject;
            PathNameCS pathName = csPathElement.getPathName();
            EList path = pathName.getPath();
            int index = path.indexOf(csPathElement);
            int i = 0;
            while (i < index) {
                PathElementCS csElement = (PathElementCS)path.get(i);
                Element element = csElement.basicGetElement();
                if (element == null || element.eIsProxy()) {
                    return null;
                }
                ++i;
            }
            ElementCS csContext = pathName.getContext();
            if (csContext == null) {
                csContext = (ElementCS)pathName.eContainer();
            }
            assert (csContext != null);
            String argumentText = null;
            ExpCS navigationArgument = null;
            if (index + 1 < path.size()) {
                messageTemplate = OCLMessages.UnresolvedNamespace_ERROR_;
            } else if (csContext instanceof InvocationExpCS) {
                InvocationExpCS csNavigatingExp = (InvocationExpCS)csContext;
                navigationArgument = csNavigatingExp;
                argumentText = this.getOperationArguments(csNavigatingExp);
                messageTemplate = OCLMessages.UnresolvedOperationCall_ERROR_;
            } else if (csContext instanceof TypeNameExpCS) {
                messageTemplate = OCLMessages.UnresolvedType_ERROR_;
            } else if (csContext instanceof TypedTypeRefCS) {
                messageTemplate = OCLMessages.UnresolvedType_ERROR_;
            } else if (csContext instanceof ExpCS) {
                navigationArgument = (ExpCS)csContext;
                messageTemplate = OCLMessages.UnresolvedProperty_ERROR_;
            } else {
                if (csContext instanceof ImportCS) {
                    return ImportCSAttribution.INSTANCE.getMessage((EObject)csContext, linkText);
                }
                messageTemplate = csContext instanceof ModelElementRefCS ? "Unresolved ModelElement ''{0}''" : "Unresolved ''{1}'' ''{0}''";
            }
            assert (messageTemplate != null);
            TypedElement source = null;
            ExpCS aSource = csSource = navigationArgument;
            while (aSource != null) {
                OperatorCS csOperator = aSource.getParent();
                if (csOperator != null && csOperator.getSource() != aSource) {
                    csSource = csOperator.getSource();
                    break;
                }
                EObject eContainer = aSource.eContainer();
                if (eContainer instanceof NavigatingArgCS) {
                    aSource = ((NavigatingArgCS)eContainer).getNavigatingExp();
                    continue;
                }
                if (eContainer instanceof InfixExpCS) {
                    aSource = (InfixExpCS)eContainer;
                    continue;
                }
                if (eContainer instanceof PrefixExpCS) {
                    aSource = (PrefixExpCS)eContainer;
                    continue;
                }
                if (eContainer instanceof NestedExpCS) {
                    aSource = (NestedExpCS)eContainer;
                    continue;
                }
                if (!(eContainer instanceof SpecificationCS)) break;
                ExpressionInOCL expression = PivotUtil.getContainingExpressionInOCL((Element)((SpecificationCS)eContainer).getPivot());
                source = expression != null ? expression.getContextVariable() : null;
                break;
            }
            if (source == null && csSource != null && csSource != navigationArgument) {
                source = (TypedElement)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csSource);
            }
            String typeText = "";
            if (source != null) {
                typeText = "unknown-type";
                Type sourceType = source.getType();
                if (sourceType != null) {
                    OperatorCS csParent = navigationArgument != null ? navigationArgument.getParent() : null;
                    typeText = !(sourceType instanceof CollectionType) && csParent instanceof NavigationOperatorCS && "->".equals(((NavigationOperatorCS)csParent).getName()) ? "Set(" + sourceType.toString() + ")" : sourceType.toString();
                }
            }
            CS2Pivot.MessageBinder messageBinder = CS2Pivot.getMessageBinder();
            String messageText = argumentText == null ? messageBinder.bind((EObject)csContext, messageTemplate, new Object[]{linkText, typeText}) : messageBinder.bind((EObject)csContext, messageTemplate, new Object[]{linkText, typeText, argumentText});
            return messageText;
        }

        public String getOperationArguments(InvocationExpCS csNavigatingExp) {
            EList<NavigatingArgCS> arguments = csNavigatingExp.getArgument();
            StringBuilder s = new StringBuilder();
            for (NavigatingArgCS csArgument : arguments) {
                TypedElement pivot = (TypedElement)PivotUtil.getPivot(TypedElement.class, (Pivotable)csArgument);
                if (pivot != null && !pivot.eIsProxy()) {
                    if (s.length() > 0) {
                        s.append(", ");
                    }
                    Type type = pivot.getType();
                    s.append(String.valueOf(type));
                    continue;
                }
                s.append(csArgument.toString());
            }
            return s.toString();
        }
    }
}

