/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.markup;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.ocl.examples.xtext.base.services.CompatibilityGrammarProvider;
import org.eclipse.ocl.examples.xtext.markup.MarkupPackage;
import org.eclipse.ocl.examples.xtext.markup.MarkupRuntimeModule;
import org.eclipse.ocl.examples.xtext.markup.MarkupStandaloneSetupGenerated;
import org.eclipse.xtext.XtextPackage;

public class MarkupStandaloneSetup
extends MarkupStandaloneSetupGenerated {
    private static Injector injector = null;

    public static void doSetup() {
        if (injector == null) {
            new MarkupStandaloneSetup().createInjectorAndDoEMFRegistration();
        }
    }

    public Injector createInjectorAndDoEMFRegistration() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> loadClass = classLoader.loadClass("org.eclipse.xtext.resource.impl.BinaryGrammarResourceFactoryImpl");
            return super.createInjectorAndDoEMFRegistration();
        }
        catch (ClassNotFoundException e) {
            if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("ecore")) {
                Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
            }
            if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("xmi")) {
                Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
            }
            if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("xtextbin")) {
                Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xtextbin", CompatibilityGrammarProvider.BinaryGrammarResourceFactoryImpl.INSTANCE);
            }
            if (!EPackage.Registry.INSTANCE.containsKey((Object)"http://www.eclipse.org/2008/Xtext")) {
                EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/2008/Xtext", (Object)XtextPackage.eINSTANCE);
            }
            Injector injector = this.createInjector();
            this.register(injector);
            return injector;
        }
    }

    public static void doTearDown() {
        injector = null;
    }

    public static Injector getInjector() {
        if (injector == null) {
            if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                MarkupStandaloneSetup.doSetup();
            } else {
                injector = Guice.createInjector((Module[])new Module[]{new MarkupRuntimeModule()});
            }
        }
        return injector;
    }

    public static void init() {
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/ocl/3.2.0/Markup", (Object)MarkupPackage.eINSTANCE);
    }

    public Injector createInjector() {
        MarkupStandaloneSetup.init();
        injector = super.createInjector();
        return injector;
    }
}

