/*******************************************************************************
 * Copyright (c) 2014 E.D.Willink and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *******************************************************************************/
package org.eclipse.ocl.examples.xtext.oclinecore.parser.antlr.internal; 

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import org.eclipse.ocl.examples.xtext.oclinecore.services.OCLinEcoreGrammarAccess;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
@SuppressWarnings("all")
public class InternalOCLinEcoreParser extends AbstractInternalAntlrParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "RULE_INT", "RULE_SINGLE_QUOTED_STRING", "RULE_ML_SINGLE_QUOTED_STRING", "RULE_UNQUOTED_STRING", "RULE_SIMPLE_ID", "RULE_ESCAPED_ID", "RULE_ESCAPED_CHARACTER", "RULE_LETTER_CHARACTER", "RULE_DOUBLE_QUOTED_STRING", "RULE_ML_COMMENT", "RULE_SL_COMMENT", "RULE_WS", "RULE_ANY_OTHER", "'module'", "'-'", "'abstract'", "'attribute'", "'body'", "'callable'", "'class'", "'composes'", "'datatype'", "'definition'", "'derivation'", "'derived'", "'enum'", "'extends'", "'id'", "'import'", "'initial'", "'interface'", "'key'", "'library'", "'operation'", "'ordered'", "'package'", "'postcondition'", "'precondition'", "'property'", "'readonly'", "'reference'", "'resolve'", "'static'", "'super'", "'throws'", "'transient'", "'unique'", "'unsettable'", "'volatile'", "'annotation'", "'documentation'", "'invariant'", "'literal'", "'serializable'", "'sysml'", "'('", "')'", "':'", "';'", "','", "'{'", "'}'", "'='", "'!derived'", "'!id'", "'!ordered'", "'!readonly'", "'!transient'", "'!unique'", "'!unsettable'", "'!volatile'", "'!serializable'", "'::'", "'*'", "'#'", "'!composes'", "'!resolve'", "'<'", "'>'", "'&&'", "'?'", "'not'", "'/'", "'+'", "'>='", "'<='", "'<>'", "'and'", "'or'", "'xor'", "'implies'", "'.'", "'->'", "'Tuple'", "'Boolean'", "'Integer'", "'Real'", "'String'", "'UnlimitedNatural'", "'OclAny'", "'OclInvalid'", "'OclVoid'", "'Set'", "'Bag'", "'Sequence'", "'Collection'", "'OrderedSet'", "'..'", "'['", "']'", "'true'", "'false'", "'invalid'", "'null'", "'@'", "'pre'", "'|'", "'if'", "'then'", "'else'", "'endif'", "'let'", "'in'", "'self'"
    };
    public static final int T__29=29;
    public static final int T__28=28;
    public static final int T__27=27;
    public static final int T__26=26;
    public static final int RULE_ESCAPED_CHARACTER=10;
    public static final int T__25=25;
    public static final int T__24=24;
    public static final int T__23=23;
    public static final int T__22=22;
    public static final int RULE_ANY_OTHER=16;
    public static final int T__21=21;
    public static final int T__20=20;
    public static final int RULE_ESCAPED_ID=9;
    public static final int RULE_DOUBLE_QUOTED_STRING=12;
    public static final int EOF=-1;
    public static final int T__93=93;
    public static final int T__19=19;
    public static final int T__94=94;
    public static final int T__91=91;
    public static final int T__92=92;
    public static final int T__90=90;
    public static final int T__18=18;
    public static final int T__17=17;
    public static final int RULE_SIMPLE_ID=8;
    public static final int T__99=99;
    public static final int T__98=98;
    public static final int T__97=97;
    public static final int T__96=96;
    public static final int T__95=95;
    public static final int T__80=80;
    public static final int T__81=81;
    public static final int T__82=82;
    public static final int T__83=83;
    public static final int RULE_SINGLE_QUOTED_STRING=5;
    public static final int T__85=85;
    public static final int T__84=84;
    public static final int T__87=87;
    public static final int T__86=86;
    public static final int T__89=89;
    public static final int T__88=88;
    public static final int RULE_ML_COMMENT=13;
    public static final int RULE_LETTER_CHARACTER=11;
    public static final int T__126=126;
    public static final int T__125=125;
    public static final int T__127=127;
    public static final int T__71=71;
    public static final int T__72=72;
    public static final int T__70=70;
    public static final int T__76=76;
    public static final int T__75=75;
    public static final int T__74=74;
    public static final int T__73=73;
    public static final int T__79=79;
    public static final int T__78=78;
    public static final int T__77=77;
    public static final int T__68=68;
    public static final int T__69=69;
    public static final int T__66=66;
    public static final int T__67=67;
    public static final int T__64=64;
    public static final int T__65=65;
    public static final int T__62=62;
    public static final int T__63=63;
    public static final int T__118=118;
    public static final int T__119=119;
    public static final int T__116=116;
    public static final int T__117=117;
    public static final int T__114=114;
    public static final int T__115=115;
    public static final int T__124=124;
    public static final int T__123=123;
    public static final int T__122=122;
    public static final int T__121=121;
    public static final int T__120=120;
    public static final int T__61=61;
    public static final int T__60=60;
    public static final int T__55=55;
    public static final int T__56=56;
    public static final int T__57=57;
    public static final int T__58=58;
    public static final int T__51=51;
    public static final int T__52=52;
    public static final int T__53=53;
    public static final int T__54=54;
    public static final int T__107=107;
    public static final int T__108=108;
    public static final int T__109=109;
    public static final int T__59=59;
    public static final int T__103=103;
    public static final int RULE_UNQUOTED_STRING=7;
    public static final int T__104=104;
    public static final int T__105=105;
    public static final int T__106=106;
    public static final int T__111=111;
    public static final int T__110=110;
    public static final int RULE_INT=4;
    public static final int T__113=113;
    public static final int T__112=112;
    public static final int T__50=50;
    public static final int T__42=42;
    public static final int T__43=43;
    public static final int T__40=40;
    public static final int RULE_ML_SINGLE_QUOTED_STRING=6;
    public static final int T__41=41;
    public static final int T__46=46;
    public static final int T__47=47;
    public static final int T__44=44;
    public static final int T__45=45;
    public static final int T__48=48;
    public static final int T__49=49;
    public static final int T__102=102;
    public static final int T__101=101;
    public static final int T__100=100;
    public static final int RULE_SL_COMMENT=14;
    public static final int T__30=30;
    public static final int T__31=31;
    public static final int T__32=32;
    public static final int T__33=33;
    public static final int T__34=34;
    public static final int T__35=35;
    public static final int T__36=36;
    public static final int T__37=37;
    public static final int T__38=38;
    public static final int T__39=39;
    public static final int RULE_WS=15;

    // delegates
    // delegators


        public InternalOCLinEcoreParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public InternalOCLinEcoreParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return InternalOCLinEcoreParser.tokenNames; }
    public String getGrammarFileName() { return "../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g"; }



    /*
      This grammar contains a lot of empty actions to work around a bug in ANTLR.
      Otherwise the ANTLR tool will create synpreds that cannot be compiled in some rare cases.
    */
     
     	private OCLinEcoreGrammarAccess grammarAccess;
     	
        public InternalOCLinEcoreParser(TokenStream input, OCLinEcoreGrammarAccess grammarAccess) {
            this(input);
            this.grammarAccess = grammarAccess;
            registerRules(grammarAccess.getGrammar());
        }
        
        @Override
        protected String getFirstRuleName() {
        	return "TopLevelCS";	
       	}
       	
       	@Override
       	protected OCLinEcoreGrammarAccess getGrammarAccess() {
       		return grammarAccess;
       	}



    // $ANTLR start "entryRuleTopLevelCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:73:1: entryRuleTopLevelCS returns [EObject current=null] : iv_ruleTopLevelCS= ruleTopLevelCS EOF ;
    public final EObject entryRuleTopLevelCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleTopLevelCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:74:2: (iv_ruleTopLevelCS= ruleTopLevelCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:75:2: iv_ruleTopLevelCS= ruleTopLevelCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getTopLevelCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleTopLevelCS_in_entryRuleTopLevelCS81);
            iv_ruleTopLevelCS=ruleTopLevelCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleTopLevelCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleTopLevelCS91); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleTopLevelCS"


    // $ANTLR start "ruleTopLevelCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:82:1: ruleTopLevelCS returns [EObject current=null] : ( () (otherlv_1= 'module' ruleUnrestrictedName )? ( (lv_ownedLibrary_3_0= ruleLibraryCS ) )* ( (lv_ownedImport_4_0= ruleImportCS ) )* ( (lv_ownedNestedPackage_5_0= rulePackageCS ) )* ) ;
    public final EObject ruleTopLevelCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_ownedLibrary_3_0 = null;

        EObject lv_ownedImport_4_0 = null;

        EObject lv_ownedNestedPackage_5_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:85:28: ( ( () (otherlv_1= 'module' ruleUnrestrictedName )? ( (lv_ownedLibrary_3_0= ruleLibraryCS ) )* ( (lv_ownedImport_4_0= ruleImportCS ) )* ( (lv_ownedNestedPackage_5_0= rulePackageCS ) )* ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:86:1: ( () (otherlv_1= 'module' ruleUnrestrictedName )? ( (lv_ownedLibrary_3_0= ruleLibraryCS ) )* ( (lv_ownedImport_4_0= ruleImportCS ) )* ( (lv_ownedNestedPackage_5_0= rulePackageCS ) )* )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:86:1: ( () (otherlv_1= 'module' ruleUnrestrictedName )? ( (lv_ownedLibrary_3_0= ruleLibraryCS ) )* ( (lv_ownedImport_4_0= ruleImportCS ) )* ( (lv_ownedNestedPackage_5_0= rulePackageCS ) )* )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:86:2: () (otherlv_1= 'module' ruleUnrestrictedName )? ( (lv_ownedLibrary_3_0= ruleLibraryCS ) )* ( (lv_ownedImport_4_0= ruleImportCS ) )* ( (lv_ownedNestedPackage_5_0= rulePackageCS ) )*
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:86:2: ()
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:87:2: 
            {
            if ( state.backtracking==0 ) {
               
              	  /* */ 
              	
            }
            if ( state.backtracking==0 ) {

                      current = forceCreateModelElement(
                          grammarAccess.getTopLevelCSAccess().getTopLevelCSAction_0(),
                          current);
                  
            }

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:95:2: (otherlv_1= 'module' ruleUnrestrictedName )?
            int alt1=2;
            int LA1_0 = input.LA(1);

            if ( (LA1_0==17) ) {
                alt1=1;
            }
            switch (alt1) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:95:4: otherlv_1= 'module' ruleUnrestrictedName
                    {
                    otherlv_1=(Token)match(input,17,FollowSets000.FOLLOW_17_in_ruleTopLevelCS141); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_1, grammarAccess.getTopLevelCSAccess().getModuleKeyword_1_0());
                          
                    }
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getTopLevelCSAccess().getUnrestrictedNameParserRuleCall_1_1()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleTopLevelCS160);
                    ruleUnrestrictedName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:110:3: ( (lv_ownedLibrary_3_0= ruleLibraryCS ) )*
            loop2:
            do {
                int alt2=2;
                int LA2_0 = input.LA(1);

                if ( (LA2_0==36) ) {
                    alt2=1;
                }


                switch (alt2) {
            	case 1 :
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:111:1: (lv_ownedLibrary_3_0= ruleLibraryCS )
            	    {
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:111:1: (lv_ownedLibrary_3_0= ruleLibraryCS )
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:112:3: lv_ownedLibrary_3_0= ruleLibraryCS
            	    {
            	    if ( state.backtracking==0 ) {
            	       
            	      	        newCompositeNode(grammarAccess.getTopLevelCSAccess().getOwnedLibraryLibraryCSParserRuleCall_2_0()); 
            	      	    
            	    }
            	    pushFollow(FollowSets000.FOLLOW_ruleLibraryCS_in_ruleTopLevelCS182);
            	    lv_ownedLibrary_3_0=ruleLibraryCS();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      	        if (current==null) {
            	      	            current = createModelElementForParent(grammarAccess.getTopLevelCSRule());
            	      	        }
            	             		add(
            	             			current, 
            	             			"ownedLibrary",
            	              		lv_ownedLibrary_3_0, 
            	              		"LibraryCS");
            	      	        afterParserOrEnumRuleCall();
            	      	    
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:128:3: ( (lv_ownedImport_4_0= ruleImportCS ) )*
            loop3:
            do {
                int alt3=2;
                int LA3_0 = input.LA(1);

                if ( (LA3_0==32) ) {
                    alt3=1;
                }


                switch (alt3) {
            	case 1 :
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:129:1: (lv_ownedImport_4_0= ruleImportCS )
            	    {
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:129:1: (lv_ownedImport_4_0= ruleImportCS )
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:130:3: lv_ownedImport_4_0= ruleImportCS
            	    {
            	    if ( state.backtracking==0 ) {
            	       
            	      	        newCompositeNode(grammarAccess.getTopLevelCSAccess().getOwnedImportImportCSParserRuleCall_3_0()); 
            	      	    
            	    }
            	    pushFollow(FollowSets000.FOLLOW_ruleImportCS_in_ruleTopLevelCS204);
            	    lv_ownedImport_4_0=ruleImportCS();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      	        if (current==null) {
            	      	            current = createModelElementForParent(grammarAccess.getTopLevelCSRule());
            	      	        }
            	             		add(
            	             			current, 
            	             			"ownedImport",
            	              		lv_ownedImport_4_0, 
            	              		"ImportCS");
            	      	        afterParserOrEnumRuleCall();
            	      	    
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop3;
                }
            } while (true);

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:146:3: ( (lv_ownedNestedPackage_5_0= rulePackageCS ) )*
            loop4:
            do {
                int alt4=2;
                int LA4_0 = input.LA(1);

                if ( (LA4_0==39) ) {
                    alt4=1;
                }


                switch (alt4) {
            	case 1 :
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:147:1: (lv_ownedNestedPackage_5_0= rulePackageCS )
            	    {
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:147:1: (lv_ownedNestedPackage_5_0= rulePackageCS )
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:148:3: lv_ownedNestedPackage_5_0= rulePackageCS
            	    {
            	    if ( state.backtracking==0 ) {
            	       
            	      	        newCompositeNode(grammarAccess.getTopLevelCSAccess().getOwnedNestedPackagePackageCSParserRuleCall_4_0()); 
            	      	    
            	    }
            	    pushFollow(FollowSets000.FOLLOW_rulePackageCS_in_ruleTopLevelCS226);
            	    lv_ownedNestedPackage_5_0=rulePackageCS();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      	        if (current==null) {
            	      	            current = createModelElementForParent(grammarAccess.getTopLevelCSRule());
            	      	        }
            	             		add(
            	             			current, 
            	             			"ownedNestedPackage",
            	              		lv_ownedNestedPackage_5_0, 
            	              		"PackageCS");
            	      	        afterParserOrEnumRuleCall();
            	      	    
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop4;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleTopLevelCS"


    // $ANTLR start "entryRuleSIGNED"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:174:1: entryRuleSIGNED returns [String current=null] : iv_ruleSIGNED= ruleSIGNED EOF ;
    public final String entryRuleSIGNED() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleSIGNED = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:175:2: (iv_ruleSIGNED= ruleSIGNED EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:176:2: iv_ruleSIGNED= ruleSIGNED EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getSIGNEDRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleSIGNED_in_entryRuleSIGNED266);
            iv_ruleSIGNED=ruleSIGNED();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleSIGNED.getText(); 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleSIGNED277); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleSIGNED"


    // $ANTLR start "ruleSIGNED"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:183:1: ruleSIGNED returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : ( (kw= '-' )? this_INT_1= RULE_INT ) ;
    public final AntlrDatatypeRuleToken ruleSIGNED() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;
        Token this_INT_1=null;

         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:186:28: ( ( (kw= '-' )? this_INT_1= RULE_INT ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:187:1: ( (kw= '-' )? this_INT_1= RULE_INT )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:187:1: ( (kw= '-' )? this_INT_1= RULE_INT )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:187:2: (kw= '-' )? this_INT_1= RULE_INT
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:187:2: (kw= '-' )?
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==18) ) {
                alt5=1;
            }
            switch (alt5) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:188:2: kw= '-'
                    {
                    kw=(Token)match(input,18,FollowSets000.FOLLOW_18_in_ruleSIGNED316); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getSIGNEDAccess().getHyphenMinusKeyword_0()); 
                          
                    }

                    }
                    break;

            }

            this_INT_1=(Token)match(input,RULE_INT,FollowSets000.FOLLOW_RULE_INT_in_ruleSIGNED333); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              		current.merge(this_INT_1);
                  
            }
            if ( state.backtracking==0 ) {
               
                  newLeafNode(this_INT_1, grammarAccess.getSIGNEDAccess().getINTTerminalRuleCall_1()); 
                  
            }

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleSIGNED"


    // $ANTLR start "entryRuleEnumerationLiteralName"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:208:1: entryRuleEnumerationLiteralName returns [String current=null] : iv_ruleEnumerationLiteralName= ruleEnumerationLiteralName EOF ;
    public final String entryRuleEnumerationLiteralName() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleEnumerationLiteralName = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:209:2: (iv_ruleEnumerationLiteralName= ruleEnumerationLiteralName EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:210:2: iv_ruleEnumerationLiteralName= ruleEnumerationLiteralName EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getEnumerationLiteralNameRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleEnumerationLiteralName_in_entryRuleEnumerationLiteralName379);
            iv_ruleEnumerationLiteralName=ruleEnumerationLiteralName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleEnumerationLiteralName.getText(); 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleEnumerationLiteralName390); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleEnumerationLiteralName"


    // $ANTLR start "ruleEnumerationLiteralName"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:217:1: ruleEnumerationLiteralName returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (this_EssentialOCLUnrestrictedName_0= ruleEssentialOCLUnrestrictedName | kw= 'abstract' | kw= 'attribute' | kw= 'body' | kw= 'callable' | kw= 'class' | kw= 'composes' | kw= 'datatype' | kw= 'definition' | kw= 'derivation' | kw= 'derived' | kw= 'enum' | kw= 'extends' | kw= 'id' | kw= 'import' | kw= 'initial' | kw= 'interface' | kw= 'key' | kw= 'library' | kw= 'module' | kw= 'operation' | kw= 'ordered' | kw= 'package' | kw= 'postcondition' | kw= 'precondition' | kw= 'property' | kw= 'readonly' | kw= 'reference' | kw= 'resolve' | kw= 'static' | kw= 'super' | kw= 'throws' | kw= 'transient' | kw= 'unique' | kw= 'unsettable' | kw= 'volatile' ) ;
    public final AntlrDatatypeRuleToken ruleEnumerationLiteralName() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;
        AntlrDatatypeRuleToken this_EssentialOCLUnrestrictedName_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:220:28: ( (this_EssentialOCLUnrestrictedName_0= ruleEssentialOCLUnrestrictedName | kw= 'abstract' | kw= 'attribute' | kw= 'body' | kw= 'callable' | kw= 'class' | kw= 'composes' | kw= 'datatype' | kw= 'definition' | kw= 'derivation' | kw= 'derived' | kw= 'enum' | kw= 'extends' | kw= 'id' | kw= 'import' | kw= 'initial' | kw= 'interface' | kw= 'key' | kw= 'library' | kw= 'module' | kw= 'operation' | kw= 'ordered' | kw= 'package' | kw= 'postcondition' | kw= 'precondition' | kw= 'property' | kw= 'readonly' | kw= 'reference' | kw= 'resolve' | kw= 'static' | kw= 'super' | kw= 'throws' | kw= 'transient' | kw= 'unique' | kw= 'unsettable' | kw= 'volatile' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:221:1: (this_EssentialOCLUnrestrictedName_0= ruleEssentialOCLUnrestrictedName | kw= 'abstract' | kw= 'attribute' | kw= 'body' | kw= 'callable' | kw= 'class' | kw= 'composes' | kw= 'datatype' | kw= 'definition' | kw= 'derivation' | kw= 'derived' | kw= 'enum' | kw= 'extends' | kw= 'id' | kw= 'import' | kw= 'initial' | kw= 'interface' | kw= 'key' | kw= 'library' | kw= 'module' | kw= 'operation' | kw= 'ordered' | kw= 'package' | kw= 'postcondition' | kw= 'precondition' | kw= 'property' | kw= 'readonly' | kw= 'reference' | kw= 'resolve' | kw= 'static' | kw= 'super' | kw= 'throws' | kw= 'transient' | kw= 'unique' | kw= 'unsettable' | kw= 'volatile' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:221:1: (this_EssentialOCLUnrestrictedName_0= ruleEssentialOCLUnrestrictedName | kw= 'abstract' | kw= 'attribute' | kw= 'body' | kw= 'callable' | kw= 'class' | kw= 'composes' | kw= 'datatype' | kw= 'definition' | kw= 'derivation' | kw= 'derived' | kw= 'enum' | kw= 'extends' | kw= 'id' | kw= 'import' | kw= 'initial' | kw= 'interface' | kw= 'key' | kw= 'library' | kw= 'module' | kw= 'operation' | kw= 'ordered' | kw= 'package' | kw= 'postcondition' | kw= 'precondition' | kw= 'property' | kw= 'readonly' | kw= 'reference' | kw= 'resolve' | kw= 'static' | kw= 'super' | kw= 'throws' | kw= 'transient' | kw= 'unique' | kw= 'unsettable' | kw= 'volatile' )
            int alt6=36;
            switch ( input.LA(1) ) {
            case RULE_SIMPLE_ID:
            case RULE_ESCAPED_ID:
                {
                alt6=1;
                }
                break;
            case 19:
                {
                alt6=2;
                }
                break;
            case 20:
                {
                alt6=3;
                }
                break;
            case 21:
                {
                alt6=4;
                }
                break;
            case 22:
                {
                alt6=5;
                }
                break;
            case 23:
                {
                alt6=6;
                }
                break;
            case 24:
                {
                alt6=7;
                }
                break;
            case 25:
                {
                alt6=8;
                }
                break;
            case 26:
                {
                alt6=9;
                }
                break;
            case 27:
                {
                alt6=10;
                }
                break;
            case 28:
                {
                alt6=11;
                }
                break;
            case 29:
                {
                alt6=12;
                }
                break;
            case 30:
                {
                alt6=13;
                }
                break;
            case 31:
                {
                alt6=14;
                }
                break;
            case 32:
                {
                alt6=15;
                }
                break;
            case 33:
                {
                alt6=16;
                }
                break;
            case 34:
                {
                alt6=17;
                }
                break;
            case 35:
                {
                alt6=18;
                }
                break;
            case 36:
                {
                alt6=19;
                }
                break;
            case 17:
                {
                alt6=20;
                }
                break;
            case 37:
                {
                alt6=21;
                }
                break;
            case 38:
                {
                alt6=22;
                }
                break;
            case 39:
                {
                alt6=23;
                }
                break;
            case 40:
                {
                alt6=24;
                }
                break;
            case 41:
                {
                alt6=25;
                }
                break;
            case 42:
                {
                alt6=26;
                }
                break;
            case 43:
                {
                alt6=27;
                }
                break;
            case 44:
                {
                alt6=28;
                }
                break;
            case 45:
                {
                alt6=29;
                }
                break;
            case 46:
                {
                alt6=30;
                }
                break;
            case 47:
                {
                alt6=31;
                }
                break;
            case 48:
                {
                alt6=32;
                }
                break;
            case 49:
                {
                alt6=33;
                }
                break;
            case 50:
                {
                alt6=34;
                }
                break;
            case 51:
                {
                alt6=35;
                }
                break;
            case 52:
                {
                alt6=36;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;
            }

            switch (alt6) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:222:5: this_EssentialOCLUnrestrictedName_0= ruleEssentialOCLUnrestrictedName
                    {
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getEnumerationLiteralNameAccess().getEssentialOCLUnrestrictedNameParserRuleCall_0()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleEssentialOCLUnrestrictedName_in_ruleEnumerationLiteralName437);
                    this_EssentialOCLUnrestrictedName_0=ruleEssentialOCLUnrestrictedName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      		current.merge(this_EssentialOCLUnrestrictedName_0);
                          
                    }
                    if ( state.backtracking==0 ) {
                       
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:234:2: kw= 'abstract'
                    {
                    kw=(Token)match(input,19,FollowSets000.FOLLOW_19_in_ruleEnumerationLiteralName461); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getAbstractKeyword_1()); 
                          
                    }

                    }
                    break;
                case 3 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:241:2: kw= 'attribute'
                    {
                    kw=(Token)match(input,20,FollowSets000.FOLLOW_20_in_ruleEnumerationLiteralName480); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getAttributeKeyword_2()); 
                          
                    }

                    }
                    break;
                case 4 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:248:2: kw= 'body'
                    {
                    kw=(Token)match(input,21,FollowSets000.FOLLOW_21_in_ruleEnumerationLiteralName499); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getBodyKeyword_3()); 
                          
                    }

                    }
                    break;
                case 5 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:255:2: kw= 'callable'
                    {
                    kw=(Token)match(input,22,FollowSets000.FOLLOW_22_in_ruleEnumerationLiteralName518); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getCallableKeyword_4()); 
                          
                    }

                    }
                    break;
                case 6 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:262:2: kw= 'class'
                    {
                    kw=(Token)match(input,23,FollowSets000.FOLLOW_23_in_ruleEnumerationLiteralName537); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getClassKeyword_5()); 
                          
                    }

                    }
                    break;
                case 7 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:269:2: kw= 'composes'
                    {
                    kw=(Token)match(input,24,FollowSets000.FOLLOW_24_in_ruleEnumerationLiteralName556); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getComposesKeyword_6()); 
                          
                    }

                    }
                    break;
                case 8 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:276:2: kw= 'datatype'
                    {
                    kw=(Token)match(input,25,FollowSets000.FOLLOW_25_in_ruleEnumerationLiteralName575); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getDatatypeKeyword_7()); 
                          
                    }

                    }
                    break;
                case 9 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:283:2: kw= 'definition'
                    {
                    kw=(Token)match(input,26,FollowSets000.FOLLOW_26_in_ruleEnumerationLiteralName594); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getDefinitionKeyword_8()); 
                          
                    }

                    }
                    break;
                case 10 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:290:2: kw= 'derivation'
                    {
                    kw=(Token)match(input,27,FollowSets000.FOLLOW_27_in_ruleEnumerationLiteralName613); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getDerivationKeyword_9()); 
                          
                    }

                    }
                    break;
                case 11 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:297:2: kw= 'derived'
                    {
                    kw=(Token)match(input,28,FollowSets000.FOLLOW_28_in_ruleEnumerationLiteralName632); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getDerivedKeyword_10()); 
                          
                    }

                    }
                    break;
                case 12 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:304:2: kw= 'enum'
                    {
                    kw=(Token)match(input,29,FollowSets000.FOLLOW_29_in_ruleEnumerationLiteralName651); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getEnumKeyword_11()); 
                          
                    }

                    }
                    break;
                case 13 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:311:2: kw= 'extends'
                    {
                    kw=(Token)match(input,30,FollowSets000.FOLLOW_30_in_ruleEnumerationLiteralName670); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getExtendsKeyword_12()); 
                          
                    }

                    }
                    break;
                case 14 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:318:2: kw= 'id'
                    {
                    kw=(Token)match(input,31,FollowSets000.FOLLOW_31_in_ruleEnumerationLiteralName689); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getIdKeyword_13()); 
                          
                    }

                    }
                    break;
                case 15 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:325:2: kw= 'import'
                    {
                    kw=(Token)match(input,32,FollowSets000.FOLLOW_32_in_ruleEnumerationLiteralName708); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getImportKeyword_14()); 
                          
                    }

                    }
                    break;
                case 16 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:332:2: kw= 'initial'
                    {
                    kw=(Token)match(input,33,FollowSets000.FOLLOW_33_in_ruleEnumerationLiteralName727); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getInitialKeyword_15()); 
                          
                    }

                    }
                    break;
                case 17 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:339:2: kw= 'interface'
                    {
                    kw=(Token)match(input,34,FollowSets000.FOLLOW_34_in_ruleEnumerationLiteralName746); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getInterfaceKeyword_16()); 
                          
                    }

                    }
                    break;
                case 18 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:346:2: kw= 'key'
                    {
                    kw=(Token)match(input,35,FollowSets000.FOLLOW_35_in_ruleEnumerationLiteralName765); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getKeyKeyword_17()); 
                          
                    }

                    }
                    break;
                case 19 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:353:2: kw= 'library'
                    {
                    kw=(Token)match(input,36,FollowSets000.FOLLOW_36_in_ruleEnumerationLiteralName784); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getLibraryKeyword_18()); 
                          
                    }

                    }
                    break;
                case 20 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:360:2: kw= 'module'
                    {
                    kw=(Token)match(input,17,FollowSets000.FOLLOW_17_in_ruleEnumerationLiteralName803); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getModuleKeyword_19()); 
                          
                    }

                    }
                    break;
                case 21 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:367:2: kw= 'operation'
                    {
                    kw=(Token)match(input,37,FollowSets000.FOLLOW_37_in_ruleEnumerationLiteralName822); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getOperationKeyword_20()); 
                          
                    }

                    }
                    break;
                case 22 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:374:2: kw= 'ordered'
                    {
                    kw=(Token)match(input,38,FollowSets000.FOLLOW_38_in_ruleEnumerationLiteralName841); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getOrderedKeyword_21()); 
                          
                    }

                    }
                    break;
                case 23 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:381:2: kw= 'package'
                    {
                    kw=(Token)match(input,39,FollowSets000.FOLLOW_39_in_ruleEnumerationLiteralName860); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getPackageKeyword_22()); 
                          
                    }

                    }
                    break;
                case 24 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:388:2: kw= 'postcondition'
                    {
                    kw=(Token)match(input,40,FollowSets000.FOLLOW_40_in_ruleEnumerationLiteralName879); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getPostconditionKeyword_23()); 
                          
                    }

                    }
                    break;
                case 25 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:395:2: kw= 'precondition'
                    {
                    kw=(Token)match(input,41,FollowSets000.FOLLOW_41_in_ruleEnumerationLiteralName898); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getPreconditionKeyword_24()); 
                          
                    }

                    }
                    break;
                case 26 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:402:2: kw= 'property'
                    {
                    kw=(Token)match(input,42,FollowSets000.FOLLOW_42_in_ruleEnumerationLiteralName917); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getPropertyKeyword_25()); 
                          
                    }

                    }
                    break;
                case 27 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:409:2: kw= 'readonly'
                    {
                    kw=(Token)match(input,43,FollowSets000.FOLLOW_43_in_ruleEnumerationLiteralName936); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getReadonlyKeyword_26()); 
                          
                    }

                    }
                    break;
                case 28 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:416:2: kw= 'reference'
                    {
                    kw=(Token)match(input,44,FollowSets000.FOLLOW_44_in_ruleEnumerationLiteralName955); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getReferenceKeyword_27()); 
                          
                    }

                    }
                    break;
                case 29 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:423:2: kw= 'resolve'
                    {
                    kw=(Token)match(input,45,FollowSets000.FOLLOW_45_in_ruleEnumerationLiteralName974); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getResolveKeyword_28()); 
                          
                    }

                    }
                    break;
                case 30 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:430:2: kw= 'static'
                    {
                    kw=(Token)match(input,46,FollowSets000.FOLLOW_46_in_ruleEnumerationLiteralName993); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getStaticKeyword_29()); 
                          
                    }

                    }
                    break;
                case 31 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:437:2: kw= 'super'
                    {
                    kw=(Token)match(input,47,FollowSets000.FOLLOW_47_in_ruleEnumerationLiteralName1012); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getSuperKeyword_30()); 
                          
                    }

                    }
                    break;
                case 32 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:444:2: kw= 'throws'
                    {
                    kw=(Token)match(input,48,FollowSets000.FOLLOW_48_in_ruleEnumerationLiteralName1031); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getThrowsKeyword_31()); 
                          
                    }

                    }
                    break;
                case 33 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:451:2: kw= 'transient'
                    {
                    kw=(Token)match(input,49,FollowSets000.FOLLOW_49_in_ruleEnumerationLiteralName1050); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getTransientKeyword_32()); 
                          
                    }

                    }
                    break;
                case 34 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:458:2: kw= 'unique'
                    {
                    kw=(Token)match(input,50,FollowSets000.FOLLOW_50_in_ruleEnumerationLiteralName1069); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getUniqueKeyword_33()); 
                          
                    }

                    }
                    break;
                case 35 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:465:2: kw= 'unsettable'
                    {
                    kw=(Token)match(input,51,FollowSets000.FOLLOW_51_in_ruleEnumerationLiteralName1088); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getUnsettableKeyword_34()); 
                          
                    }

                    }
                    break;
                case 36 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:472:2: kw= 'volatile'
                    {
                    kw=(Token)match(input,52,FollowSets000.FOLLOW_52_in_ruleEnumerationLiteralName1107); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEnumerationLiteralNameAccess().getVolatileKeyword_35()); 
                          
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleEnumerationLiteralName"


    // $ANTLR start "entryRuleUnrestrictedName"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:485:1: entryRuleUnrestrictedName returns [String current=null] : iv_ruleUnrestrictedName= ruleUnrestrictedName EOF ;
    public final String entryRuleUnrestrictedName() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleUnrestrictedName = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:486:2: (iv_ruleUnrestrictedName= ruleUnrestrictedName EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:487:2: iv_ruleUnrestrictedName= ruleUnrestrictedName EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getUnrestrictedNameRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_entryRuleUnrestrictedName1148);
            iv_ruleUnrestrictedName=ruleUnrestrictedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleUnrestrictedName.getText(); 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleUnrestrictedName1159); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleUnrestrictedName"


    // $ANTLR start "ruleUnrestrictedName"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:494:1: ruleUnrestrictedName returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (this_EnumerationLiteralName_0= ruleEnumerationLiteralName | kw= 'annotation' | kw= 'documentation' | kw= 'invariant' | kw= 'literal' | kw= 'serializable' | kw= 'sysml' ) ;
    public final AntlrDatatypeRuleToken ruleUnrestrictedName() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;
        AntlrDatatypeRuleToken this_EnumerationLiteralName_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:497:28: ( (this_EnumerationLiteralName_0= ruleEnumerationLiteralName | kw= 'annotation' | kw= 'documentation' | kw= 'invariant' | kw= 'literal' | kw= 'serializable' | kw= 'sysml' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:498:1: (this_EnumerationLiteralName_0= ruleEnumerationLiteralName | kw= 'annotation' | kw= 'documentation' | kw= 'invariant' | kw= 'literal' | kw= 'serializable' | kw= 'sysml' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:498:1: (this_EnumerationLiteralName_0= ruleEnumerationLiteralName | kw= 'annotation' | kw= 'documentation' | kw= 'invariant' | kw= 'literal' | kw= 'serializable' | kw= 'sysml' )
            int alt7=7;
            switch ( input.LA(1) ) {
            case RULE_SIMPLE_ID:
            case RULE_ESCAPED_ID:
            case 17:
            case 19:
            case 20:
            case 21:
            case 22:
            case 23:
            case 24:
            case 25:
            case 26:
            case 27:
            case 28:
            case 29:
            case 30:
            case 31:
            case 32:
            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 38:
            case 39:
            case 40:
            case 41:
            case 42:
            case 43:
            case 44:
            case 45:
            case 46:
            case 47:
            case 48:
            case 49:
            case 50:
            case 51:
            case 52:
                {
                alt7=1;
                }
                break;
            case 53:
                {
                alt7=2;
                }
                break;
            case 54:
                {
                alt7=3;
                }
                break;
            case 55:
                {
                alt7=4;
                }
                break;
            case 56:
                {
                alt7=5;
                }
                break;
            case 57:
                {
                alt7=6;
                }
                break;
            case 58:
                {
                alt7=7;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 7, 0, input);

                throw nvae;
            }

            switch (alt7) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:499:5: this_EnumerationLiteralName_0= ruleEnumerationLiteralName
                    {
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getUnrestrictedNameAccess().getEnumerationLiteralNameParserRuleCall_0()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleEnumerationLiteralName_in_ruleUnrestrictedName1206);
                    this_EnumerationLiteralName_0=ruleEnumerationLiteralName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      		current.merge(this_EnumerationLiteralName_0);
                          
                    }
                    if ( state.backtracking==0 ) {
                       
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:511:2: kw= 'annotation'
                    {
                    kw=(Token)match(input,53,FollowSets000.FOLLOW_53_in_ruleUnrestrictedName1230); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getUnrestrictedNameAccess().getAnnotationKeyword_1()); 
                          
                    }

                    }
                    break;
                case 3 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:518:2: kw= 'documentation'
                    {
                    kw=(Token)match(input,54,FollowSets000.FOLLOW_54_in_ruleUnrestrictedName1249); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getUnrestrictedNameAccess().getDocumentationKeyword_2()); 
                          
                    }

                    }
                    break;
                case 4 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:525:2: kw= 'invariant'
                    {
                    kw=(Token)match(input,55,FollowSets000.FOLLOW_55_in_ruleUnrestrictedName1268); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getUnrestrictedNameAccess().getInvariantKeyword_3()); 
                          
                    }

                    }
                    break;
                case 5 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:532:2: kw= 'literal'
                    {
                    kw=(Token)match(input,56,FollowSets000.FOLLOW_56_in_ruleUnrestrictedName1287); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getUnrestrictedNameAccess().getLiteralKeyword_4()); 
                          
                    }

                    }
                    break;
                case 6 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:539:2: kw= 'serializable'
                    {
                    kw=(Token)match(input,57,FollowSets000.FOLLOW_57_in_ruleUnrestrictedName1306); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getUnrestrictedNameAccess().getSerializableKeyword_5()); 
                          
                    }

                    }
                    break;
                case 7 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:546:2: kw= 'sysml'
                    {
                    kw=(Token)match(input,58,FollowSets000.FOLLOW_58_in_ruleUnrestrictedName1325); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getUnrestrictedNameAccess().getSysmlKeyword_6()); 
                          
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleUnrestrictedName"


    // $ANTLR start "entryRuleInvariantConstraintCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:559:1: entryRuleInvariantConstraintCS returns [EObject current=null] : iv_ruleInvariantConstraintCS= ruleInvariantConstraintCS EOF ;
    public final EObject entryRuleInvariantConstraintCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleInvariantConstraintCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:560:2: (iv_ruleInvariantConstraintCS= ruleInvariantConstraintCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:561:2: iv_ruleInvariantConstraintCS= ruleInvariantConstraintCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getInvariantConstraintCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleInvariantConstraintCS_in_entryRuleInvariantConstraintCS1365);
            iv_ruleInvariantConstraintCS=ruleInvariantConstraintCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleInvariantConstraintCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleInvariantConstraintCS1375); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleInvariantConstraintCS"


    // $ANTLR start "ruleInvariantConstraintCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:568:1: ruleInvariantConstraintCS returns [EObject current=null] : ( ( (lv_callable_0_0= 'callable' ) )? ( (lv_stereotype_1_0= 'invariant' ) ) ( ( (lv_name_2_0= ruleUnrestrictedName ) ) (otherlv_3= '(' ( (lv_messageSpecification_4_0= ruleSpecificationCS ) ) otherlv_5= ')' )? )? ( (otherlv_6= ':' ( (lv_specification_7_0= ruleSpecificationCS ) )? otherlv_8= ';' ) | otherlv_9= ';' ) ) ;
    public final EObject ruleInvariantConstraintCS() throws RecognitionException {
        EObject current = null;

        Token lv_callable_0_0=null;
        Token lv_stereotype_1_0=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        Token otherlv_6=null;
        Token otherlv_8=null;
        Token otherlv_9=null;
        AntlrDatatypeRuleToken lv_name_2_0 = null;

        EObject lv_messageSpecification_4_0 = null;

        EObject lv_specification_7_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:571:28: ( ( ( (lv_callable_0_0= 'callable' ) )? ( (lv_stereotype_1_0= 'invariant' ) ) ( ( (lv_name_2_0= ruleUnrestrictedName ) ) (otherlv_3= '(' ( (lv_messageSpecification_4_0= ruleSpecificationCS ) ) otherlv_5= ')' )? )? ( (otherlv_6= ':' ( (lv_specification_7_0= ruleSpecificationCS ) )? otherlv_8= ';' ) | otherlv_9= ';' ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:572:1: ( ( (lv_callable_0_0= 'callable' ) )? ( (lv_stereotype_1_0= 'invariant' ) ) ( ( (lv_name_2_0= ruleUnrestrictedName ) ) (otherlv_3= '(' ( (lv_messageSpecification_4_0= ruleSpecificationCS ) ) otherlv_5= ')' )? )? ( (otherlv_6= ':' ( (lv_specification_7_0= ruleSpecificationCS ) )? otherlv_8= ';' ) | otherlv_9= ';' ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:572:1: ( ( (lv_callable_0_0= 'callable' ) )? ( (lv_stereotype_1_0= 'invariant' ) ) ( ( (lv_name_2_0= ruleUnrestrictedName ) ) (otherlv_3= '(' ( (lv_messageSpecification_4_0= ruleSpecificationCS ) ) otherlv_5= ')' )? )? ( (otherlv_6= ':' ( (lv_specification_7_0= ruleSpecificationCS ) )? otherlv_8= ';' ) | otherlv_9= ';' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:572:2: ( (lv_callable_0_0= 'callable' ) )? ( (lv_stereotype_1_0= 'invariant' ) ) ( ( (lv_name_2_0= ruleUnrestrictedName ) ) (otherlv_3= '(' ( (lv_messageSpecification_4_0= ruleSpecificationCS ) ) otherlv_5= ')' )? )? ( (otherlv_6= ':' ( (lv_specification_7_0= ruleSpecificationCS ) )? otherlv_8= ';' ) | otherlv_9= ';' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:572:2: ( (lv_callable_0_0= 'callable' ) )?
            int alt8=2;
            int LA8_0 = input.LA(1);

            if ( (LA8_0==22) ) {
                alt8=1;
            }
            switch (alt8) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:573:1: (lv_callable_0_0= 'callable' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:573:1: (lv_callable_0_0= 'callable' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:574:3: lv_callable_0_0= 'callable'
                    {
                    lv_callable_0_0=(Token)match(input,22,FollowSets000.FOLLOW_22_in_ruleInvariantConstraintCS1418); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_callable_0_0, grammarAccess.getInvariantConstraintCSAccess().getCallableCallableKeyword_0_0());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getInvariantConstraintCSRule());
                      	        }
                             		setWithLastConsumed(current, "callable", true, "callable");
                      	    
                    }

                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:587:3: ( (lv_stereotype_1_0= 'invariant' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:588:1: (lv_stereotype_1_0= 'invariant' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:588:1: (lv_stereotype_1_0= 'invariant' )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:589:3: lv_stereotype_1_0= 'invariant'
            {
            lv_stereotype_1_0=(Token)match(input,55,FollowSets000.FOLLOW_55_in_ruleInvariantConstraintCS1450); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                      newLeafNode(lv_stereotype_1_0, grammarAccess.getInvariantConstraintCSAccess().getStereotypeInvariantKeyword_1_0());
                  
            }
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElement(grammarAccess.getInvariantConstraintCSRule());
              	        }
                     		setWithLastConsumed(current, "stereotype", lv_stereotype_1_0, "invariant");
              	    
            }

            }


            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:602:2: ( ( (lv_name_2_0= ruleUnrestrictedName ) ) (otherlv_3= '(' ( (lv_messageSpecification_4_0= ruleSpecificationCS ) ) otherlv_5= ')' )? )?
            int alt10=2;
            int LA10_0 = input.LA(1);

            if ( ((LA10_0>=RULE_SIMPLE_ID && LA10_0<=RULE_ESCAPED_ID)||LA10_0==17||(LA10_0>=19 && LA10_0<=58)) ) {
                alt10=1;
            }
            switch (alt10) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:602:3: ( (lv_name_2_0= ruleUnrestrictedName ) ) (otherlv_3= '(' ( (lv_messageSpecification_4_0= ruleSpecificationCS ) ) otherlv_5= ')' )?
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:602:3: ( (lv_name_2_0= ruleUnrestrictedName ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:603:1: (lv_name_2_0= ruleUnrestrictedName )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:603:1: (lv_name_2_0= ruleUnrestrictedName )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:604:3: lv_name_2_0= ruleUnrestrictedName
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getInvariantConstraintCSAccess().getNameUnrestrictedNameParserRuleCall_2_0_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleInvariantConstraintCS1485);
                    lv_name_2_0=ruleUnrestrictedName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getInvariantConstraintCSRule());
                      	        }
                             		set(
                             			current, 
                             			"name",
                              		lv_name_2_0, 
                              		"UnrestrictedName");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:620:2: (otherlv_3= '(' ( (lv_messageSpecification_4_0= ruleSpecificationCS ) ) otherlv_5= ')' )?
                    int alt9=2;
                    int LA9_0 = input.LA(1);

                    if ( (LA9_0==59) ) {
                        alt9=1;
                    }
                    switch (alt9) {
                        case 1 :
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:620:4: otherlv_3= '(' ( (lv_messageSpecification_4_0= ruleSpecificationCS ) ) otherlv_5= ')'
                            {
                            otherlv_3=(Token)match(input,59,FollowSets000.FOLLOW_59_in_ruleInvariantConstraintCS1498); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                                  	newLeafNode(otherlv_3, grammarAccess.getInvariantConstraintCSAccess().getLeftParenthesisKeyword_2_1_0());
                                  
                            }
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:624:1: ( (lv_messageSpecification_4_0= ruleSpecificationCS ) )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:625:1: (lv_messageSpecification_4_0= ruleSpecificationCS )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:625:1: (lv_messageSpecification_4_0= ruleSpecificationCS )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:626:3: lv_messageSpecification_4_0= ruleSpecificationCS
                            {
                            if ( state.backtracking==0 ) {
                               
                              	        newCompositeNode(grammarAccess.getInvariantConstraintCSAccess().getMessageSpecificationSpecificationCSParserRuleCall_2_1_1_0()); 
                              	    
                            }
                            pushFollow(FollowSets000.FOLLOW_ruleSpecificationCS_in_ruleInvariantConstraintCS1519);
                            lv_messageSpecification_4_0=ruleSpecificationCS();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              	        if (current==null) {
                              	            current = createModelElementForParent(grammarAccess.getInvariantConstraintCSRule());
                              	        }
                                     		set(
                                     			current, 
                                     			"messageSpecification",
                                      		lv_messageSpecification_4_0, 
                                      		"SpecificationCS");
                              	        afterParserOrEnumRuleCall();
                              	    
                            }

                            }


                            }

                            otherlv_5=(Token)match(input,60,FollowSets000.FOLLOW_60_in_ruleInvariantConstraintCS1531); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                                  	newLeafNode(otherlv_5, grammarAccess.getInvariantConstraintCSAccess().getRightParenthesisKeyword_2_1_2());
                                  
                            }

                            }
                            break;

                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:646:5: ( (otherlv_6= ':' ( (lv_specification_7_0= ruleSpecificationCS ) )? otherlv_8= ';' ) | otherlv_9= ';' )
            int alt12=2;
            int LA12_0 = input.LA(1);

            if ( (LA12_0==61) ) {
                alt12=1;
            }
            else if ( (LA12_0==62) ) {
                alt12=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 12, 0, input);

                throw nvae;
            }
            switch (alt12) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:646:6: (otherlv_6= ':' ( (lv_specification_7_0= ruleSpecificationCS ) )? otherlv_8= ';' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:646:6: (otherlv_6= ':' ( (lv_specification_7_0= ruleSpecificationCS ) )? otherlv_8= ';' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:646:8: otherlv_6= ':' ( (lv_specification_7_0= ruleSpecificationCS ) )? otherlv_8= ';'
                    {
                    otherlv_6=(Token)match(input,61,FollowSets000.FOLLOW_61_in_ruleInvariantConstraintCS1549); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_6, grammarAccess.getInvariantConstraintCSAccess().getColonKeyword_3_0_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:650:1: ( (lv_specification_7_0= ruleSpecificationCS ) )?
                    int alt11=2;
                    int LA11_0 = input.LA(1);

                    if ( ((LA11_0>=RULE_INT && LA11_0<=RULE_SINGLE_QUOTED_STRING)||(LA11_0>=RULE_UNQUOTED_STRING && LA11_0<=RULE_ESCAPED_ID)||(LA11_0>=17 && LA11_0<=59)||LA11_0==77||LA11_0==85||(LA11_0>=97 && LA11_0<=110)||(LA11_0>=114 && LA11_0<=117)||LA11_0==121||LA11_0==125||LA11_0==127) ) {
                        alt11=1;
                    }
                    switch (alt11) {
                        case 1 :
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:651:1: (lv_specification_7_0= ruleSpecificationCS )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:651:1: (lv_specification_7_0= ruleSpecificationCS )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:652:3: lv_specification_7_0= ruleSpecificationCS
                            {
                            if ( state.backtracking==0 ) {
                               
                              	        newCompositeNode(grammarAccess.getInvariantConstraintCSAccess().getSpecificationSpecificationCSParserRuleCall_3_0_1_0()); 
                              	    
                            }
                            pushFollow(FollowSets000.FOLLOW_ruleSpecificationCS_in_ruleInvariantConstraintCS1570);
                            lv_specification_7_0=ruleSpecificationCS();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              	        if (current==null) {
                              	            current = createModelElementForParent(grammarAccess.getInvariantConstraintCSRule());
                              	        }
                                     		set(
                                     			current, 
                                     			"specification",
                                      		lv_specification_7_0, 
                                      		"SpecificationCS");
                              	        afterParserOrEnumRuleCall();
                              	    
                            }

                            }


                            }
                            break;

                    }

                    otherlv_8=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleInvariantConstraintCS1583); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_8, grammarAccess.getInvariantConstraintCSAccess().getSemicolonKeyword_3_0_2());
                          
                    }

                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:673:7: otherlv_9= ';'
                    {
                    otherlv_9=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleInvariantConstraintCS1602); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_9, grammarAccess.getInvariantConstraintCSAccess().getSemicolonKeyword_3_1());
                          
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleInvariantConstraintCS"


    // $ANTLR start "entryRulePostconditionConstraintCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:685:1: entryRulePostconditionConstraintCS returns [EObject current=null] : iv_rulePostconditionConstraintCS= rulePostconditionConstraintCS EOF ;
    public final EObject entryRulePostconditionConstraintCS() throws RecognitionException {
        EObject current = null;

        EObject iv_rulePostconditionConstraintCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:686:2: (iv_rulePostconditionConstraintCS= rulePostconditionConstraintCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:687:2: iv_rulePostconditionConstraintCS= rulePostconditionConstraintCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getPostconditionConstraintCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_rulePostconditionConstraintCS_in_entryRulePostconditionConstraintCS1639);
            iv_rulePostconditionConstraintCS=rulePostconditionConstraintCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_rulePostconditionConstraintCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRulePostconditionConstraintCS1649); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRulePostconditionConstraintCS"


    // $ANTLR start "rulePostconditionConstraintCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:694:1: rulePostconditionConstraintCS returns [EObject current=null] : ( ( (lv_stereotype_0_0= 'postcondition' ) ) ( ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')' )? )? otherlv_5= ':' ( (lv_specification_6_0= ruleSpecificationCS ) )? otherlv_7= ';' ) ;
    public final EObject rulePostconditionConstraintCS() throws RecognitionException {
        EObject current = null;

        Token lv_stereotype_0_0=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        Token otherlv_5=null;
        Token otherlv_7=null;
        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject lv_messageSpecification_3_0 = null;

        EObject lv_specification_6_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:697:28: ( ( ( (lv_stereotype_0_0= 'postcondition' ) ) ( ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')' )? )? otherlv_5= ':' ( (lv_specification_6_0= ruleSpecificationCS ) )? otherlv_7= ';' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:698:1: ( ( (lv_stereotype_0_0= 'postcondition' ) ) ( ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')' )? )? otherlv_5= ':' ( (lv_specification_6_0= ruleSpecificationCS ) )? otherlv_7= ';' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:698:1: ( ( (lv_stereotype_0_0= 'postcondition' ) ) ( ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')' )? )? otherlv_5= ':' ( (lv_specification_6_0= ruleSpecificationCS ) )? otherlv_7= ';' )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:698:2: ( (lv_stereotype_0_0= 'postcondition' ) ) ( ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')' )? )? otherlv_5= ':' ( (lv_specification_6_0= ruleSpecificationCS ) )? otherlv_7= ';'
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:698:2: ( (lv_stereotype_0_0= 'postcondition' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:699:1: (lv_stereotype_0_0= 'postcondition' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:699:1: (lv_stereotype_0_0= 'postcondition' )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:700:3: lv_stereotype_0_0= 'postcondition'
            {
            lv_stereotype_0_0=(Token)match(input,40,FollowSets000.FOLLOW_40_in_rulePostconditionConstraintCS1692); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                      newLeafNode(lv_stereotype_0_0, grammarAccess.getPostconditionConstraintCSAccess().getStereotypePostconditionKeyword_0_0());
                  
            }
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElement(grammarAccess.getPostconditionConstraintCSRule());
              	        }
                     		setWithLastConsumed(current, "stereotype", lv_stereotype_0_0, "postcondition");
              	    
            }

            }


            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:713:2: ( ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')' )? )?
            int alt14=2;
            int LA14_0 = input.LA(1);

            if ( ((LA14_0>=RULE_SIMPLE_ID && LA14_0<=RULE_ESCAPED_ID)||LA14_0==17||(LA14_0>=19 && LA14_0<=58)) ) {
                alt14=1;
            }
            switch (alt14) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:713:3: ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')' )?
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:713:3: ( (lv_name_1_0= ruleUnrestrictedName ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:714:1: (lv_name_1_0= ruleUnrestrictedName )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:714:1: (lv_name_1_0= ruleUnrestrictedName )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:715:3: lv_name_1_0= ruleUnrestrictedName
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getPostconditionConstraintCSAccess().getNameUnrestrictedNameParserRuleCall_1_0_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_rulePostconditionConstraintCS1727);
                    lv_name_1_0=ruleUnrestrictedName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getPostconditionConstraintCSRule());
                      	        }
                             		set(
                             			current, 
                             			"name",
                              		lv_name_1_0, 
                              		"UnrestrictedName");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:731:2: (otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')' )?
                    int alt13=2;
                    int LA13_0 = input.LA(1);

                    if ( (LA13_0==59) ) {
                        alt13=1;
                    }
                    switch (alt13) {
                        case 1 :
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:731:4: otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')'
                            {
                            otherlv_2=(Token)match(input,59,FollowSets000.FOLLOW_59_in_rulePostconditionConstraintCS1740); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                                  	newLeafNode(otherlv_2, grammarAccess.getPostconditionConstraintCSAccess().getLeftParenthesisKeyword_1_1_0());
                                  
                            }
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:735:1: ( (lv_messageSpecification_3_0= ruleSpecificationCS ) )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:736:1: (lv_messageSpecification_3_0= ruleSpecificationCS )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:736:1: (lv_messageSpecification_3_0= ruleSpecificationCS )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:737:3: lv_messageSpecification_3_0= ruleSpecificationCS
                            {
                            if ( state.backtracking==0 ) {
                               
                              	        newCompositeNode(grammarAccess.getPostconditionConstraintCSAccess().getMessageSpecificationSpecificationCSParserRuleCall_1_1_1_0()); 
                              	    
                            }
                            pushFollow(FollowSets000.FOLLOW_ruleSpecificationCS_in_rulePostconditionConstraintCS1761);
                            lv_messageSpecification_3_0=ruleSpecificationCS();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              	        if (current==null) {
                              	            current = createModelElementForParent(grammarAccess.getPostconditionConstraintCSRule());
                              	        }
                                     		set(
                                     			current, 
                                     			"messageSpecification",
                                      		lv_messageSpecification_3_0, 
                                      		"SpecificationCS");
                              	        afterParserOrEnumRuleCall();
                              	    
                            }

                            }


                            }

                            otherlv_4=(Token)match(input,60,FollowSets000.FOLLOW_60_in_rulePostconditionConstraintCS1773); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                                  	newLeafNode(otherlv_4, grammarAccess.getPostconditionConstraintCSAccess().getRightParenthesisKeyword_1_1_2());
                                  
                            }

                            }
                            break;

                    }


                    }
                    break;

            }

            otherlv_5=(Token)match(input,61,FollowSets000.FOLLOW_61_in_rulePostconditionConstraintCS1789); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_5, grammarAccess.getPostconditionConstraintCSAccess().getColonKeyword_2());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:761:1: ( (lv_specification_6_0= ruleSpecificationCS ) )?
            int alt15=2;
            int LA15_0 = input.LA(1);

            if ( ((LA15_0>=RULE_INT && LA15_0<=RULE_SINGLE_QUOTED_STRING)||(LA15_0>=RULE_UNQUOTED_STRING && LA15_0<=RULE_ESCAPED_ID)||(LA15_0>=17 && LA15_0<=59)||LA15_0==77||LA15_0==85||(LA15_0>=97 && LA15_0<=110)||(LA15_0>=114 && LA15_0<=117)||LA15_0==121||LA15_0==125||LA15_0==127) ) {
                alt15=1;
            }
            switch (alt15) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:762:1: (lv_specification_6_0= ruleSpecificationCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:762:1: (lv_specification_6_0= ruleSpecificationCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:763:3: lv_specification_6_0= ruleSpecificationCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getPostconditionConstraintCSAccess().getSpecificationSpecificationCSParserRuleCall_3_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleSpecificationCS_in_rulePostconditionConstraintCS1810);
                    lv_specification_6_0=ruleSpecificationCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getPostconditionConstraintCSRule());
                      	        }
                             		set(
                             			current, 
                             			"specification",
                              		lv_specification_6_0, 
                              		"SpecificationCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }
                    break;

            }

            otherlv_7=(Token)match(input,62,FollowSets000.FOLLOW_62_in_rulePostconditionConstraintCS1823); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_7, grammarAccess.getPostconditionConstraintCSAccess().getSemicolonKeyword_4());
                  
            }

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "rulePostconditionConstraintCS"


    // $ANTLR start "entryRulePreconditionConstraintCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:791:1: entryRulePreconditionConstraintCS returns [EObject current=null] : iv_rulePreconditionConstraintCS= rulePreconditionConstraintCS EOF ;
    public final EObject entryRulePreconditionConstraintCS() throws RecognitionException {
        EObject current = null;

        EObject iv_rulePreconditionConstraintCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:792:2: (iv_rulePreconditionConstraintCS= rulePreconditionConstraintCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:793:2: iv_rulePreconditionConstraintCS= rulePreconditionConstraintCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getPreconditionConstraintCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_rulePreconditionConstraintCS_in_entryRulePreconditionConstraintCS1859);
            iv_rulePreconditionConstraintCS=rulePreconditionConstraintCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_rulePreconditionConstraintCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRulePreconditionConstraintCS1869); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRulePreconditionConstraintCS"


    // $ANTLR start "rulePreconditionConstraintCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:800:1: rulePreconditionConstraintCS returns [EObject current=null] : ( ( (lv_stereotype_0_0= 'precondition' ) ) ( ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')' )? )? otherlv_5= ':' ( (lv_specification_6_0= ruleSpecificationCS ) )? otherlv_7= ';' ) ;
    public final EObject rulePreconditionConstraintCS() throws RecognitionException {
        EObject current = null;

        Token lv_stereotype_0_0=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        Token otherlv_5=null;
        Token otherlv_7=null;
        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject lv_messageSpecification_3_0 = null;

        EObject lv_specification_6_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:803:28: ( ( ( (lv_stereotype_0_0= 'precondition' ) ) ( ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')' )? )? otherlv_5= ':' ( (lv_specification_6_0= ruleSpecificationCS ) )? otherlv_7= ';' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:804:1: ( ( (lv_stereotype_0_0= 'precondition' ) ) ( ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')' )? )? otherlv_5= ':' ( (lv_specification_6_0= ruleSpecificationCS ) )? otherlv_7= ';' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:804:1: ( ( (lv_stereotype_0_0= 'precondition' ) ) ( ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')' )? )? otherlv_5= ':' ( (lv_specification_6_0= ruleSpecificationCS ) )? otherlv_7= ';' )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:804:2: ( (lv_stereotype_0_0= 'precondition' ) ) ( ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')' )? )? otherlv_5= ':' ( (lv_specification_6_0= ruleSpecificationCS ) )? otherlv_7= ';'
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:804:2: ( (lv_stereotype_0_0= 'precondition' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:805:1: (lv_stereotype_0_0= 'precondition' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:805:1: (lv_stereotype_0_0= 'precondition' )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:806:3: lv_stereotype_0_0= 'precondition'
            {
            lv_stereotype_0_0=(Token)match(input,41,FollowSets000.FOLLOW_41_in_rulePreconditionConstraintCS1912); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                      newLeafNode(lv_stereotype_0_0, grammarAccess.getPreconditionConstraintCSAccess().getStereotypePreconditionKeyword_0_0());
                  
            }
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElement(grammarAccess.getPreconditionConstraintCSRule());
              	        }
                     		setWithLastConsumed(current, "stereotype", lv_stereotype_0_0, "precondition");
              	    
            }

            }


            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:819:2: ( ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')' )? )?
            int alt17=2;
            int LA17_0 = input.LA(1);

            if ( ((LA17_0>=RULE_SIMPLE_ID && LA17_0<=RULE_ESCAPED_ID)||LA17_0==17||(LA17_0>=19 && LA17_0<=58)) ) {
                alt17=1;
            }
            switch (alt17) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:819:3: ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')' )?
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:819:3: ( (lv_name_1_0= ruleUnrestrictedName ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:820:1: (lv_name_1_0= ruleUnrestrictedName )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:820:1: (lv_name_1_0= ruleUnrestrictedName )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:821:3: lv_name_1_0= ruleUnrestrictedName
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getPreconditionConstraintCSAccess().getNameUnrestrictedNameParserRuleCall_1_0_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_rulePreconditionConstraintCS1947);
                    lv_name_1_0=ruleUnrestrictedName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getPreconditionConstraintCSRule());
                      	        }
                             		set(
                             			current, 
                             			"name",
                              		lv_name_1_0, 
                              		"UnrestrictedName");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:837:2: (otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')' )?
                    int alt16=2;
                    int LA16_0 = input.LA(1);

                    if ( (LA16_0==59) ) {
                        alt16=1;
                    }
                    switch (alt16) {
                        case 1 :
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:837:4: otherlv_2= '(' ( (lv_messageSpecification_3_0= ruleSpecificationCS ) ) otherlv_4= ')'
                            {
                            otherlv_2=(Token)match(input,59,FollowSets000.FOLLOW_59_in_rulePreconditionConstraintCS1960); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                                  	newLeafNode(otherlv_2, grammarAccess.getPreconditionConstraintCSAccess().getLeftParenthesisKeyword_1_1_0());
                                  
                            }
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:841:1: ( (lv_messageSpecification_3_0= ruleSpecificationCS ) )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:842:1: (lv_messageSpecification_3_0= ruleSpecificationCS )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:842:1: (lv_messageSpecification_3_0= ruleSpecificationCS )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:843:3: lv_messageSpecification_3_0= ruleSpecificationCS
                            {
                            if ( state.backtracking==0 ) {
                               
                              	        newCompositeNode(grammarAccess.getPreconditionConstraintCSAccess().getMessageSpecificationSpecificationCSParserRuleCall_1_1_1_0()); 
                              	    
                            }
                            pushFollow(FollowSets000.FOLLOW_ruleSpecificationCS_in_rulePreconditionConstraintCS1981);
                            lv_messageSpecification_3_0=ruleSpecificationCS();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              	        if (current==null) {
                              	            current = createModelElementForParent(grammarAccess.getPreconditionConstraintCSRule());
                              	        }
                                     		set(
                                     			current, 
                                     			"messageSpecification",
                                      		lv_messageSpecification_3_0, 
                                      		"SpecificationCS");
                              	        afterParserOrEnumRuleCall();
                              	    
                            }

                            }


                            }

                            otherlv_4=(Token)match(input,60,FollowSets000.FOLLOW_60_in_rulePreconditionConstraintCS1993); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                                  	newLeafNode(otherlv_4, grammarAccess.getPreconditionConstraintCSAccess().getRightParenthesisKeyword_1_1_2());
                                  
                            }

                            }
                            break;

                    }


                    }
                    break;

            }

            otherlv_5=(Token)match(input,61,FollowSets000.FOLLOW_61_in_rulePreconditionConstraintCS2009); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_5, grammarAccess.getPreconditionConstraintCSAccess().getColonKeyword_2());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:867:1: ( (lv_specification_6_0= ruleSpecificationCS ) )?
            int alt18=2;
            int LA18_0 = input.LA(1);

            if ( ((LA18_0>=RULE_INT && LA18_0<=RULE_SINGLE_QUOTED_STRING)||(LA18_0>=RULE_UNQUOTED_STRING && LA18_0<=RULE_ESCAPED_ID)||(LA18_0>=17 && LA18_0<=59)||LA18_0==77||LA18_0==85||(LA18_0>=97 && LA18_0<=110)||(LA18_0>=114 && LA18_0<=117)||LA18_0==121||LA18_0==125||LA18_0==127) ) {
                alt18=1;
            }
            switch (alt18) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:868:1: (lv_specification_6_0= ruleSpecificationCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:868:1: (lv_specification_6_0= ruleSpecificationCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:869:3: lv_specification_6_0= ruleSpecificationCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getPreconditionConstraintCSAccess().getSpecificationSpecificationCSParserRuleCall_3_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleSpecificationCS_in_rulePreconditionConstraintCS2030);
                    lv_specification_6_0=ruleSpecificationCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getPreconditionConstraintCSRule());
                      	        }
                             		set(
                             			current, 
                             			"specification",
                              		lv_specification_6_0, 
                              		"SpecificationCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }
                    break;

            }

            otherlv_7=(Token)match(input,62,FollowSets000.FOLLOW_62_in_rulePreconditionConstraintCS2043); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_7, grammarAccess.getPreconditionConstraintCSAccess().getSemicolonKeyword_4());
                  
            }

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "rulePreconditionConstraintCS"


    // $ANTLR start "entryRuleAnnotationCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:897:1: entryRuleAnnotationCS returns [EObject current=null] : iv_ruleAnnotationCS= ruleAnnotationCS EOF ;
    public final EObject entryRuleAnnotationCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleAnnotationCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:898:2: (iv_ruleAnnotationCS= ruleAnnotationCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:899:2: iv_ruleAnnotationCS= ruleAnnotationCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getAnnotationCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleAnnotationCS_in_entryRuleAnnotationCS2079);
            iv_ruleAnnotationCS=ruleAnnotationCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleAnnotationCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleAnnotationCS2089); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleAnnotationCS"


    // $ANTLR start "ruleAnnotationCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:906:1: ruleAnnotationCS returns [EObject current=null] : ( () otherlv_1= 'annotation' ( ( (lv_name_2_1= ruleUnrestrictedName | lv_name_2_2= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_3= '(' ( (lv_ownedDetail_4_0= ruleDetailCS ) ) (otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) ) )* otherlv_7= ')' )? ( (otherlv_8= '{' ( ( (lv_ownedAnnotation_9_0= ruleAnnotationElementCS ) ) | ( (lv_ownedContent_10_0= ruleModelElementCS ) ) | ( (lv_ownedReference_11_0= ruleModelElementRefCS ) ) )+ otherlv_12= '}' ) | otherlv_13= ';' ) ) ;
    public final EObject ruleAnnotationCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token lv_name_2_2=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        Token otherlv_7=null;
        Token otherlv_8=null;
        Token otherlv_12=null;
        Token otherlv_13=null;
        AntlrDatatypeRuleToken lv_name_2_1 = null;

        EObject lv_ownedDetail_4_0 = null;

        EObject lv_ownedDetail_6_0 = null;

        EObject lv_ownedAnnotation_9_0 = null;

        EObject lv_ownedContent_10_0 = null;

        EObject lv_ownedReference_11_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:909:28: ( ( () otherlv_1= 'annotation' ( ( (lv_name_2_1= ruleUnrestrictedName | lv_name_2_2= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_3= '(' ( (lv_ownedDetail_4_0= ruleDetailCS ) ) (otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) ) )* otherlv_7= ')' )? ( (otherlv_8= '{' ( ( (lv_ownedAnnotation_9_0= ruleAnnotationElementCS ) ) | ( (lv_ownedContent_10_0= ruleModelElementCS ) ) | ( (lv_ownedReference_11_0= ruleModelElementRefCS ) ) )+ otherlv_12= '}' ) | otherlv_13= ';' ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:910:1: ( () otherlv_1= 'annotation' ( ( (lv_name_2_1= ruleUnrestrictedName | lv_name_2_2= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_3= '(' ( (lv_ownedDetail_4_0= ruleDetailCS ) ) (otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) ) )* otherlv_7= ')' )? ( (otherlv_8= '{' ( ( (lv_ownedAnnotation_9_0= ruleAnnotationElementCS ) ) | ( (lv_ownedContent_10_0= ruleModelElementCS ) ) | ( (lv_ownedReference_11_0= ruleModelElementRefCS ) ) )+ otherlv_12= '}' ) | otherlv_13= ';' ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:910:1: ( () otherlv_1= 'annotation' ( ( (lv_name_2_1= ruleUnrestrictedName | lv_name_2_2= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_3= '(' ( (lv_ownedDetail_4_0= ruleDetailCS ) ) (otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) ) )* otherlv_7= ')' )? ( (otherlv_8= '{' ( ( (lv_ownedAnnotation_9_0= ruleAnnotationElementCS ) ) | ( (lv_ownedContent_10_0= ruleModelElementCS ) ) | ( (lv_ownedReference_11_0= ruleModelElementRefCS ) ) )+ otherlv_12= '}' ) | otherlv_13= ';' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:910:2: () otherlv_1= 'annotation' ( ( (lv_name_2_1= ruleUnrestrictedName | lv_name_2_2= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_3= '(' ( (lv_ownedDetail_4_0= ruleDetailCS ) ) (otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) ) )* otherlv_7= ')' )? ( (otherlv_8= '{' ( ( (lv_ownedAnnotation_9_0= ruleAnnotationElementCS ) ) | ( (lv_ownedContent_10_0= ruleModelElementCS ) ) | ( (lv_ownedReference_11_0= ruleModelElementRefCS ) ) )+ otherlv_12= '}' ) | otherlv_13= ';' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:910:2: ()
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:911:2: 
            {
            if ( state.backtracking==0 ) {
               
              	  /* */ 
              	
            }
            if ( state.backtracking==0 ) {

                      current = forceCreateModelElement(
                          grammarAccess.getAnnotationCSAccess().getAnnotationCSAction_0(),
                          current);
                  
            }

            }

            otherlv_1=(Token)match(input,53,FollowSets000.FOLLOW_53_in_ruleAnnotationCS2138); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_1, grammarAccess.getAnnotationCSAccess().getAnnotationKeyword_1());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:923:1: ( ( (lv_name_2_1= ruleUnrestrictedName | lv_name_2_2= RULE_SINGLE_QUOTED_STRING ) ) )?
            int alt20=2;
            int LA20_0 = input.LA(1);

            if ( (LA20_0==RULE_SINGLE_QUOTED_STRING||(LA20_0>=RULE_SIMPLE_ID && LA20_0<=RULE_ESCAPED_ID)||LA20_0==17||(LA20_0>=19 && LA20_0<=58)) ) {
                alt20=1;
            }
            switch (alt20) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:924:1: ( (lv_name_2_1= ruleUnrestrictedName | lv_name_2_2= RULE_SINGLE_QUOTED_STRING ) )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:924:1: ( (lv_name_2_1= ruleUnrestrictedName | lv_name_2_2= RULE_SINGLE_QUOTED_STRING ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:925:1: (lv_name_2_1= ruleUnrestrictedName | lv_name_2_2= RULE_SINGLE_QUOTED_STRING )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:925:1: (lv_name_2_1= ruleUnrestrictedName | lv_name_2_2= RULE_SINGLE_QUOTED_STRING )
                    int alt19=2;
                    int LA19_0 = input.LA(1);

                    if ( ((LA19_0>=RULE_SIMPLE_ID && LA19_0<=RULE_ESCAPED_ID)||LA19_0==17||(LA19_0>=19 && LA19_0<=58)) ) {
                        alt19=1;
                    }
                    else if ( (LA19_0==RULE_SINGLE_QUOTED_STRING) ) {
                        alt19=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return current;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 19, 0, input);

                        throw nvae;
                    }
                    switch (alt19) {
                        case 1 :
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:926:3: lv_name_2_1= ruleUnrestrictedName
                            {
                            if ( state.backtracking==0 ) {
                               
                              	        newCompositeNode(grammarAccess.getAnnotationCSAccess().getNameUnrestrictedNameParserRuleCall_2_0_0()); 
                              	    
                            }
                            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleAnnotationCS2161);
                            lv_name_2_1=ruleUnrestrictedName();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              	        if (current==null) {
                              	            current = createModelElementForParent(grammarAccess.getAnnotationCSRule());
                              	        }
                                     		set(
                                     			current, 
                                     			"name",
                                      		lv_name_2_1, 
                                      		"UnrestrictedName");
                              	        afterParserOrEnumRuleCall();
                              	    
                            }

                            }
                            break;
                        case 2 :
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:941:8: lv_name_2_2= RULE_SINGLE_QUOTED_STRING
                            {
                            lv_name_2_2=(Token)match(input,RULE_SINGLE_QUOTED_STRING,FollowSets000.FOLLOW_RULE_SINGLE_QUOTED_STRING_in_ruleAnnotationCS2176); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              			newLeafNode(lv_name_2_2, grammarAccess.getAnnotationCSAccess().getNameSINGLE_QUOTED_STRINGTerminalRuleCall_2_0_1()); 
                              		
                            }
                            if ( state.backtracking==0 ) {

                              	        if (current==null) {
                              	            current = createModelElement(grammarAccess.getAnnotationCSRule());
                              	        }
                                     		setWithLastConsumed(
                                     			current, 
                                     			"name",
                                      		lv_name_2_2, 
                                      		"SINGLE_QUOTED_STRING");
                              	    
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:959:3: (otherlv_3= '(' ( (lv_ownedDetail_4_0= ruleDetailCS ) ) (otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) ) )* otherlv_7= ')' )?
            int alt22=2;
            int LA22_0 = input.LA(1);

            if ( (LA22_0==59) ) {
                alt22=1;
            }
            switch (alt22) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:959:5: otherlv_3= '(' ( (lv_ownedDetail_4_0= ruleDetailCS ) ) (otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) ) )* otherlv_7= ')'
                    {
                    otherlv_3=(Token)match(input,59,FollowSets000.FOLLOW_59_in_ruleAnnotationCS2198); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_3, grammarAccess.getAnnotationCSAccess().getLeftParenthesisKeyword_3_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:963:1: ( (lv_ownedDetail_4_0= ruleDetailCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:964:1: (lv_ownedDetail_4_0= ruleDetailCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:964:1: (lv_ownedDetail_4_0= ruleDetailCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:965:3: lv_ownedDetail_4_0= ruleDetailCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getAnnotationCSAccess().getOwnedDetailDetailCSParserRuleCall_3_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleDetailCS_in_ruleAnnotationCS2219);
                    lv_ownedDetail_4_0=ruleDetailCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getAnnotationCSRule());
                      	        }
                             		add(
                             			current, 
                             			"ownedDetail",
                              		lv_ownedDetail_4_0, 
                              		"DetailCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:981:2: (otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) ) )*
                    loop21:
                    do {
                        int alt21=2;
                        int LA21_0 = input.LA(1);

                        if ( (LA21_0==63) ) {
                            alt21=1;
                        }


                        switch (alt21) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:981:4: otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) )
                    	    {
                    	    otherlv_5=(Token)match(input,63,FollowSets000.FOLLOW_63_in_ruleAnnotationCS2232); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_5, grammarAccess.getAnnotationCSAccess().getCommaKeyword_3_2_0());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:985:1: ( (lv_ownedDetail_6_0= ruleDetailCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:986:1: (lv_ownedDetail_6_0= ruleDetailCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:986:1: (lv_ownedDetail_6_0= ruleDetailCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:987:3: lv_ownedDetail_6_0= ruleDetailCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getAnnotationCSAccess().getOwnedDetailDetailCSParserRuleCall_3_2_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleDetailCS_in_ruleAnnotationCS2253);
                    	    lv_ownedDetail_6_0=ruleDetailCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getAnnotationCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedDetail",
                    	              		lv_ownedDetail_6_0, 
                    	              		"DetailCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop21;
                        }
                    } while (true);

                    otherlv_7=(Token)match(input,60,FollowSets000.FOLLOW_60_in_ruleAnnotationCS2267); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_7, grammarAccess.getAnnotationCSAccess().getRightParenthesisKeyword_3_3());
                          
                    }

                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1007:3: ( (otherlv_8= '{' ( ( (lv_ownedAnnotation_9_0= ruleAnnotationElementCS ) ) | ( (lv_ownedContent_10_0= ruleModelElementCS ) ) | ( (lv_ownedReference_11_0= ruleModelElementRefCS ) ) )+ otherlv_12= '}' ) | otherlv_13= ';' )
            int alt24=2;
            int LA24_0 = input.LA(1);

            if ( (LA24_0==64) ) {
                alt24=1;
            }
            else if ( (LA24_0==62) ) {
                alt24=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 24, 0, input);

                throw nvae;
            }
            switch (alt24) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1007:4: (otherlv_8= '{' ( ( (lv_ownedAnnotation_9_0= ruleAnnotationElementCS ) ) | ( (lv_ownedContent_10_0= ruleModelElementCS ) ) | ( (lv_ownedReference_11_0= ruleModelElementRefCS ) ) )+ otherlv_12= '}' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1007:4: (otherlv_8= '{' ( ( (lv_ownedAnnotation_9_0= ruleAnnotationElementCS ) ) | ( (lv_ownedContent_10_0= ruleModelElementCS ) ) | ( (lv_ownedReference_11_0= ruleModelElementRefCS ) ) )+ otherlv_12= '}' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1007:6: otherlv_8= '{' ( ( (lv_ownedAnnotation_9_0= ruleAnnotationElementCS ) ) | ( (lv_ownedContent_10_0= ruleModelElementCS ) ) | ( (lv_ownedReference_11_0= ruleModelElementRefCS ) ) )+ otherlv_12= '}'
                    {
                    otherlv_8=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleAnnotationCS2283); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_8, grammarAccess.getAnnotationCSAccess().getLeftCurlyBracketKeyword_4_0_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1011:1: ( ( (lv_ownedAnnotation_9_0= ruleAnnotationElementCS ) ) | ( (lv_ownedContent_10_0= ruleModelElementCS ) ) | ( (lv_ownedReference_11_0= ruleModelElementRefCS ) ) )+
                    int cnt23=0;
                    loop23:
                    do {
                        int alt23=4;
                        switch ( input.LA(1) ) {
                        case 53:
                        case 54:
                        case 58:
                            {
                            alt23=1;
                            }
                            break;
                        case RULE_SIMPLE_ID:
                        case RULE_ESCAPED_ID:
                        case 17:
                        case 19:
                        case 20:
                        case 21:
                        case 22:
                        case 23:
                        case 24:
                        case 25:
                        case 26:
                        case 27:
                        case 28:
                        case 29:
                        case 30:
                        case 31:
                        case 32:
                        case 33:
                        case 34:
                        case 35:
                        case 36:
                        case 37:
                        case 38:
                        case 39:
                        case 40:
                        case 41:
                        case 42:
                        case 43:
                        case 45:
                        case 46:
                        case 47:
                        case 48:
                        case 49:
                        case 50:
                        case 51:
                        case 52:
                        case 56:
                            {
                            alt23=2;
                            }
                            break;
                        case 44:
                            {
                            int LA23_4 = input.LA(2);

                            if ( (LA23_4==62||LA23_4==64||LA23_4==66) ) {
                                alt23=2;
                            }
                            else if ( ((LA23_4>=RULE_SIMPLE_ID && LA23_4<=RULE_ESCAPED_ID)||LA23_4==17||(LA23_4>=19 && LA23_4<=58)) ) {
                                alt23=3;
                            }


                            }
                            break;

                        }

                        switch (alt23) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1011:2: ( (lv_ownedAnnotation_9_0= ruleAnnotationElementCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1011:2: ( (lv_ownedAnnotation_9_0= ruleAnnotationElementCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1012:1: (lv_ownedAnnotation_9_0= ruleAnnotationElementCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1012:1: (lv_ownedAnnotation_9_0= ruleAnnotationElementCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1013:3: lv_ownedAnnotation_9_0= ruleAnnotationElementCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getAnnotationCSAccess().getOwnedAnnotationAnnotationElementCSParserRuleCall_4_0_1_0_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleAnnotationElementCS_in_ruleAnnotationCS2305);
                    	    lv_ownedAnnotation_9_0=ruleAnnotationElementCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getAnnotationCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedAnnotation",
                    	              		lv_ownedAnnotation_9_0, 
                    	              		"AnnotationElementCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 2 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1030:6: ( (lv_ownedContent_10_0= ruleModelElementCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1030:6: ( (lv_ownedContent_10_0= ruleModelElementCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1031:1: (lv_ownedContent_10_0= ruleModelElementCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1031:1: (lv_ownedContent_10_0= ruleModelElementCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1032:3: lv_ownedContent_10_0= ruleModelElementCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getAnnotationCSAccess().getOwnedContentModelElementCSParserRuleCall_4_0_1_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleModelElementCS_in_ruleAnnotationCS2332);
                    	    lv_ownedContent_10_0=ruleModelElementCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getAnnotationCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedContent",
                    	              		lv_ownedContent_10_0, 
                    	              		"ModelElementCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 3 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1049:6: ( (lv_ownedReference_11_0= ruleModelElementRefCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1049:6: ( (lv_ownedReference_11_0= ruleModelElementRefCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1050:1: (lv_ownedReference_11_0= ruleModelElementRefCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1050:1: (lv_ownedReference_11_0= ruleModelElementRefCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1051:3: lv_ownedReference_11_0= ruleModelElementRefCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getAnnotationCSAccess().getOwnedReferenceModelElementRefCSParserRuleCall_4_0_1_2_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleModelElementRefCS_in_ruleAnnotationCS2359);
                    	    lv_ownedReference_11_0=ruleModelElementRefCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getAnnotationCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedReference",
                    	              		lv_ownedReference_11_0, 
                    	              		"ModelElementRefCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    if ( cnt23 >= 1 ) break loop23;
                    	    if (state.backtracking>0) {state.failed=true; return current;}
                                EarlyExitException eee =
                                    new EarlyExitException(23, input);
                                throw eee;
                        }
                        cnt23++;
                    } while (true);

                    otherlv_12=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleAnnotationCS2373); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_12, grammarAccess.getAnnotationCSAccess().getRightCurlyBracketKeyword_4_0_2());
                          
                    }

                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1072:7: otherlv_13= ';'
                    {
                    otherlv_13=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleAnnotationCS2392); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_13, grammarAccess.getAnnotationCSAccess().getSemicolonKeyword_4_1());
                          
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleAnnotationCS"


    // $ANTLR start "entryRuleAnnotationElementCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1084:1: entryRuleAnnotationElementCS returns [EObject current=null] : iv_ruleAnnotationElementCS= ruleAnnotationElementCS EOF ;
    public final EObject entryRuleAnnotationElementCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleAnnotationElementCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1085:2: (iv_ruleAnnotationElementCS= ruleAnnotationElementCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1086:2: iv_ruleAnnotationElementCS= ruleAnnotationElementCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getAnnotationElementCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleAnnotationElementCS_in_entryRuleAnnotationElementCS2429);
            iv_ruleAnnotationElementCS=ruleAnnotationElementCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleAnnotationElementCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleAnnotationElementCS2439); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleAnnotationElementCS"


    // $ANTLR start "ruleAnnotationElementCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1093:1: ruleAnnotationElementCS returns [EObject current=null] : (this_AnnotationCS_0= ruleAnnotationCS | this_DocumentationCS_1= ruleDocumentationCS | this_SysMLCS_2= ruleSysMLCS ) ;
    public final EObject ruleAnnotationElementCS() throws RecognitionException {
        EObject current = null;

        EObject this_AnnotationCS_0 = null;

        EObject this_DocumentationCS_1 = null;

        EObject this_SysMLCS_2 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1096:28: ( (this_AnnotationCS_0= ruleAnnotationCS | this_DocumentationCS_1= ruleDocumentationCS | this_SysMLCS_2= ruleSysMLCS ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1097:1: (this_AnnotationCS_0= ruleAnnotationCS | this_DocumentationCS_1= ruleDocumentationCS | this_SysMLCS_2= ruleSysMLCS )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1097:1: (this_AnnotationCS_0= ruleAnnotationCS | this_DocumentationCS_1= ruleDocumentationCS | this_SysMLCS_2= ruleSysMLCS )
            int alt25=3;
            switch ( input.LA(1) ) {
            case 53:
                {
                alt25=1;
                }
                break;
            case 54:
                {
                alt25=2;
                }
                break;
            case 58:
                {
                alt25=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 25, 0, input);

                throw nvae;
            }

            switch (alt25) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1098:2: this_AnnotationCS_0= ruleAnnotationCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getAnnotationElementCSAccess().getAnnotationCSParserRuleCall_0()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleAnnotationCS_in_ruleAnnotationElementCS2489);
                    this_AnnotationCS_0=ruleAnnotationCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_AnnotationCS_0; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1111:2: this_DocumentationCS_1= ruleDocumentationCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getAnnotationElementCSAccess().getDocumentationCSParserRuleCall_1()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleDocumentationCS_in_ruleAnnotationElementCS2519);
                    this_DocumentationCS_1=ruleDocumentationCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_DocumentationCS_1; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 3 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1124:2: this_SysMLCS_2= ruleSysMLCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getAnnotationElementCSAccess().getSysMLCSParserRuleCall_2()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleSysMLCS_in_ruleAnnotationElementCS2549);
                    this_SysMLCS_2=ruleSysMLCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_SysMLCS_2; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleAnnotationElementCS"


    // $ANTLR start "entryRuleAttributeCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1143:1: entryRuleAttributeCS returns [EObject current=null] : iv_ruleAttributeCS= ruleAttributeCS EOF ;
    public final EObject entryRuleAttributeCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleAttributeCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1144:2: (iv_ruleAttributeCS= ruleAttributeCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1145:2: iv_ruleAttributeCS= ruleAttributeCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getAttributeCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleAttributeCS_in_entryRuleAttributeCS2584);
            iv_ruleAttributeCS=ruleAttributeCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleAttributeCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleAttributeCS2594); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleAttributeCS"


    // $ANTLR start "ruleAttributeCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1152:1: ruleAttributeCS returns [EObject current=null] : ( ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )? otherlv_4= 'attribute' ( (lv_name_5_0= ruleUnrestrictedName ) ) (otherlv_6= ':' ( (lv_ownedType_7_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_8= '=' ( (lv_default_9_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_10= '{' ( ( ( (lv_qualifier_11_0= 'derived' ) ) | ( (lv_qualifier_12_0= '!derived' ) ) | ( (lv_qualifier_13_0= 'id' ) ) | ( (lv_qualifier_14_0= '!id' ) ) | ( (lv_qualifier_15_0= 'ordered' ) ) | ( (lv_qualifier_16_0= '!ordered' ) ) | ( (lv_qualifier_17_0= 'readonly' ) ) | ( (lv_qualifier_18_0= '!readonly' ) ) | ( (lv_qualifier_19_0= 'transient' ) ) | ( (lv_qualifier_20_0= '!transient' ) ) | ( (lv_qualifier_21_0= 'unique' ) ) | ( (lv_qualifier_22_0= '!unique' ) ) | ( (lv_qualifier_23_0= 'unsettable' ) ) | ( (lv_qualifier_24_0= '!unsettable' ) ) | ( (lv_qualifier_25_0= 'volatile' ) ) | ( (lv_qualifier_26_0= '!volatile' ) ) ) (otherlv_27= ',' )? )+ otherlv_28= '}' )? ( (otherlv_29= '{' ( ( (lv_ownedAnnotation_30_0= ruleAnnotationElementCS ) ) | (otherlv_31= 'derivation' ( ruleUnrestrictedName )? otherlv_33= ':' ( (lv_ownedDefaultExpression_34_0= ruleSpecificationCS ) )? otherlv_35= ';' ) | (otherlv_36= 'initial' ( ruleUnrestrictedName )? otherlv_38= ':' ( (lv_ownedDefaultExpression_39_0= ruleSpecificationCS ) )? otherlv_40= ';' ) )* otherlv_41= '}' ) | otherlv_42= ';' ) ) ;
    public final EObject ruleAttributeCS() throws RecognitionException {
        EObject current = null;

        Token lv_qualifier_0_0=null;
        Token lv_qualifier_1_0=null;
        Token lv_qualifier_2_0=null;
        Token lv_qualifier_3_0=null;
        Token otherlv_4=null;
        Token otherlv_6=null;
        Token otherlv_8=null;
        Token lv_default_9_0=null;
        Token otherlv_10=null;
        Token lv_qualifier_11_0=null;
        Token lv_qualifier_12_0=null;
        Token lv_qualifier_13_0=null;
        Token lv_qualifier_14_0=null;
        Token lv_qualifier_15_0=null;
        Token lv_qualifier_16_0=null;
        Token lv_qualifier_17_0=null;
        Token lv_qualifier_18_0=null;
        Token lv_qualifier_19_0=null;
        Token lv_qualifier_20_0=null;
        Token lv_qualifier_21_0=null;
        Token lv_qualifier_22_0=null;
        Token lv_qualifier_23_0=null;
        Token lv_qualifier_24_0=null;
        Token lv_qualifier_25_0=null;
        Token lv_qualifier_26_0=null;
        Token otherlv_27=null;
        Token otherlv_28=null;
        Token otherlv_29=null;
        Token otherlv_31=null;
        Token otherlv_33=null;
        Token otherlv_35=null;
        Token otherlv_36=null;
        Token otherlv_38=null;
        Token otherlv_40=null;
        Token otherlv_41=null;
        Token otherlv_42=null;
        AntlrDatatypeRuleToken lv_name_5_0 = null;

        EObject lv_ownedType_7_0 = null;

        EObject lv_ownedAnnotation_30_0 = null;

        EObject lv_ownedDefaultExpression_34_0 = null;

        EObject lv_ownedDefaultExpression_39_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1155:28: ( ( ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )? otherlv_4= 'attribute' ( (lv_name_5_0= ruleUnrestrictedName ) ) (otherlv_6= ':' ( (lv_ownedType_7_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_8= '=' ( (lv_default_9_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_10= '{' ( ( ( (lv_qualifier_11_0= 'derived' ) ) | ( (lv_qualifier_12_0= '!derived' ) ) | ( (lv_qualifier_13_0= 'id' ) ) | ( (lv_qualifier_14_0= '!id' ) ) | ( (lv_qualifier_15_0= 'ordered' ) ) | ( (lv_qualifier_16_0= '!ordered' ) ) | ( (lv_qualifier_17_0= 'readonly' ) ) | ( (lv_qualifier_18_0= '!readonly' ) ) | ( (lv_qualifier_19_0= 'transient' ) ) | ( (lv_qualifier_20_0= '!transient' ) ) | ( (lv_qualifier_21_0= 'unique' ) ) | ( (lv_qualifier_22_0= '!unique' ) ) | ( (lv_qualifier_23_0= 'unsettable' ) ) | ( (lv_qualifier_24_0= '!unsettable' ) ) | ( (lv_qualifier_25_0= 'volatile' ) ) | ( (lv_qualifier_26_0= '!volatile' ) ) ) (otherlv_27= ',' )? )+ otherlv_28= '}' )? ( (otherlv_29= '{' ( ( (lv_ownedAnnotation_30_0= ruleAnnotationElementCS ) ) | (otherlv_31= 'derivation' ( ruleUnrestrictedName )? otherlv_33= ':' ( (lv_ownedDefaultExpression_34_0= ruleSpecificationCS ) )? otherlv_35= ';' ) | (otherlv_36= 'initial' ( ruleUnrestrictedName )? otherlv_38= ':' ( (lv_ownedDefaultExpression_39_0= ruleSpecificationCS ) )? otherlv_40= ';' ) )* otherlv_41= '}' ) | otherlv_42= ';' ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1156:1: ( ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )? otherlv_4= 'attribute' ( (lv_name_5_0= ruleUnrestrictedName ) ) (otherlv_6= ':' ( (lv_ownedType_7_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_8= '=' ( (lv_default_9_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_10= '{' ( ( ( (lv_qualifier_11_0= 'derived' ) ) | ( (lv_qualifier_12_0= '!derived' ) ) | ( (lv_qualifier_13_0= 'id' ) ) | ( (lv_qualifier_14_0= '!id' ) ) | ( (lv_qualifier_15_0= 'ordered' ) ) | ( (lv_qualifier_16_0= '!ordered' ) ) | ( (lv_qualifier_17_0= 'readonly' ) ) | ( (lv_qualifier_18_0= '!readonly' ) ) | ( (lv_qualifier_19_0= 'transient' ) ) | ( (lv_qualifier_20_0= '!transient' ) ) | ( (lv_qualifier_21_0= 'unique' ) ) | ( (lv_qualifier_22_0= '!unique' ) ) | ( (lv_qualifier_23_0= 'unsettable' ) ) | ( (lv_qualifier_24_0= '!unsettable' ) ) | ( (lv_qualifier_25_0= 'volatile' ) ) | ( (lv_qualifier_26_0= '!volatile' ) ) ) (otherlv_27= ',' )? )+ otherlv_28= '}' )? ( (otherlv_29= '{' ( ( (lv_ownedAnnotation_30_0= ruleAnnotationElementCS ) ) | (otherlv_31= 'derivation' ( ruleUnrestrictedName )? otherlv_33= ':' ( (lv_ownedDefaultExpression_34_0= ruleSpecificationCS ) )? otherlv_35= ';' ) | (otherlv_36= 'initial' ( ruleUnrestrictedName )? otherlv_38= ':' ( (lv_ownedDefaultExpression_39_0= ruleSpecificationCS ) )? otherlv_40= ';' ) )* otherlv_41= '}' ) | otherlv_42= ';' ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1156:1: ( ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )? otherlv_4= 'attribute' ( (lv_name_5_0= ruleUnrestrictedName ) ) (otherlv_6= ':' ( (lv_ownedType_7_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_8= '=' ( (lv_default_9_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_10= '{' ( ( ( (lv_qualifier_11_0= 'derived' ) ) | ( (lv_qualifier_12_0= '!derived' ) ) | ( (lv_qualifier_13_0= 'id' ) ) | ( (lv_qualifier_14_0= '!id' ) ) | ( (lv_qualifier_15_0= 'ordered' ) ) | ( (lv_qualifier_16_0= '!ordered' ) ) | ( (lv_qualifier_17_0= 'readonly' ) ) | ( (lv_qualifier_18_0= '!readonly' ) ) | ( (lv_qualifier_19_0= 'transient' ) ) | ( (lv_qualifier_20_0= '!transient' ) ) | ( (lv_qualifier_21_0= 'unique' ) ) | ( (lv_qualifier_22_0= '!unique' ) ) | ( (lv_qualifier_23_0= 'unsettable' ) ) | ( (lv_qualifier_24_0= '!unsettable' ) ) | ( (lv_qualifier_25_0= 'volatile' ) ) | ( (lv_qualifier_26_0= '!volatile' ) ) ) (otherlv_27= ',' )? )+ otherlv_28= '}' )? ( (otherlv_29= '{' ( ( (lv_ownedAnnotation_30_0= ruleAnnotationElementCS ) ) | (otherlv_31= 'derivation' ( ruleUnrestrictedName )? otherlv_33= ':' ( (lv_ownedDefaultExpression_34_0= ruleSpecificationCS ) )? otherlv_35= ';' ) | (otherlv_36= 'initial' ( ruleUnrestrictedName )? otherlv_38= ':' ( (lv_ownedDefaultExpression_39_0= ruleSpecificationCS ) )? otherlv_40= ';' ) )* otherlv_41= '}' ) | otherlv_42= ';' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1156:2: ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )? otherlv_4= 'attribute' ( (lv_name_5_0= ruleUnrestrictedName ) ) (otherlv_6= ':' ( (lv_ownedType_7_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_8= '=' ( (lv_default_9_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_10= '{' ( ( ( (lv_qualifier_11_0= 'derived' ) ) | ( (lv_qualifier_12_0= '!derived' ) ) | ( (lv_qualifier_13_0= 'id' ) ) | ( (lv_qualifier_14_0= '!id' ) ) | ( (lv_qualifier_15_0= 'ordered' ) ) | ( (lv_qualifier_16_0= '!ordered' ) ) | ( (lv_qualifier_17_0= 'readonly' ) ) | ( (lv_qualifier_18_0= '!readonly' ) ) | ( (lv_qualifier_19_0= 'transient' ) ) | ( (lv_qualifier_20_0= '!transient' ) ) | ( (lv_qualifier_21_0= 'unique' ) ) | ( (lv_qualifier_22_0= '!unique' ) ) | ( (lv_qualifier_23_0= 'unsettable' ) ) | ( (lv_qualifier_24_0= '!unsettable' ) ) | ( (lv_qualifier_25_0= 'volatile' ) ) | ( (lv_qualifier_26_0= '!volatile' ) ) ) (otherlv_27= ',' )? )+ otherlv_28= '}' )? ( (otherlv_29= '{' ( ( (lv_ownedAnnotation_30_0= ruleAnnotationElementCS ) ) | (otherlv_31= 'derivation' ( ruleUnrestrictedName )? otherlv_33= ':' ( (lv_ownedDefaultExpression_34_0= ruleSpecificationCS ) )? otherlv_35= ';' ) | (otherlv_36= 'initial' ( ruleUnrestrictedName )? otherlv_38= ':' ( (lv_ownedDefaultExpression_39_0= ruleSpecificationCS ) )? otherlv_40= ';' ) )* otherlv_41= '}' ) | otherlv_42= ';' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1156:2: ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )?
            int alt28=3;
            int LA28_0 = input.LA(1);

            if ( (LA28_0==46) ) {
                alt28=1;
            }
            else if ( (LA28_0==26) ) {
                alt28=2;
            }
            switch (alt28) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1156:3: ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1156:3: ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1156:4: ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )?
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1156:4: ( (lv_qualifier_0_0= 'static' ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1157:1: (lv_qualifier_0_0= 'static' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1157:1: (lv_qualifier_0_0= 'static' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1158:3: lv_qualifier_0_0= 'static'
                    {
                    lv_qualifier_0_0=(Token)match(input,46,FollowSets000.FOLLOW_46_in_ruleAttributeCS2639); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_qualifier_0_0, grammarAccess.getAttributeCSAccess().getQualifierStaticKeyword_0_0_0_0());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getAttributeCSRule());
                      	        }
                             		addWithLastConsumed(current, "qualifier", lv_qualifier_0_0, "static");
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1171:2: ( (lv_qualifier_1_0= 'definition' ) )?
                    int alt26=2;
                    int LA26_0 = input.LA(1);

                    if ( (LA26_0==26) ) {
                        alt26=1;
                    }
                    switch (alt26) {
                        case 1 :
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1172:1: (lv_qualifier_1_0= 'definition' )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1172:1: (lv_qualifier_1_0= 'definition' )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1173:3: lv_qualifier_1_0= 'definition'
                            {
                            lv_qualifier_1_0=(Token)match(input,26,FollowSets000.FOLLOW_26_in_ruleAttributeCS2670); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                                      newLeafNode(lv_qualifier_1_0, grammarAccess.getAttributeCSAccess().getQualifierDefinitionKeyword_0_0_1_0());
                                  
                            }
                            if ( state.backtracking==0 ) {

                              	        if (current==null) {
                              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                              	        }
                                     		addWithLastConsumed(current, "qualifier", lv_qualifier_1_0, "definition");
                              	    
                            }

                            }


                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1187:6: ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1187:6: ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1187:7: ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )?
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1187:7: ( (lv_qualifier_2_0= 'definition' ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1188:1: (lv_qualifier_2_0= 'definition' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1188:1: (lv_qualifier_2_0= 'definition' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1189:3: lv_qualifier_2_0= 'definition'
                    {
                    lv_qualifier_2_0=(Token)match(input,26,FollowSets000.FOLLOW_26_in_ruleAttributeCS2710); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_qualifier_2_0, grammarAccess.getAttributeCSAccess().getQualifierDefinitionKeyword_0_1_0_0());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getAttributeCSRule());
                      	        }
                             		addWithLastConsumed(current, "qualifier", lv_qualifier_2_0, "definition");
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1202:2: ( (lv_qualifier_3_0= 'static' ) )?
                    int alt27=2;
                    int LA27_0 = input.LA(1);

                    if ( (LA27_0==46) ) {
                        alt27=1;
                    }
                    switch (alt27) {
                        case 1 :
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1203:1: (lv_qualifier_3_0= 'static' )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1203:1: (lv_qualifier_3_0= 'static' )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1204:3: lv_qualifier_3_0= 'static'
                            {
                            lv_qualifier_3_0=(Token)match(input,46,FollowSets000.FOLLOW_46_in_ruleAttributeCS2741); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                                      newLeafNode(lv_qualifier_3_0, grammarAccess.getAttributeCSAccess().getQualifierStaticKeyword_0_1_1_0());
                                  
                            }
                            if ( state.backtracking==0 ) {

                              	        if (current==null) {
                              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                              	        }
                                     		addWithLastConsumed(current, "qualifier", lv_qualifier_3_0, "static");
                              	    
                            }

                            }


                            }
                            break;

                    }


                    }


                    }
                    break;

            }

            otherlv_4=(Token)match(input,20,FollowSets000.FOLLOW_20_in_ruleAttributeCS2770); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_4, grammarAccess.getAttributeCSAccess().getAttributeKeyword_1());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1221:1: ( (lv_name_5_0= ruleUnrestrictedName ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1222:1: (lv_name_5_0= ruleUnrestrictedName )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1222:1: (lv_name_5_0= ruleUnrestrictedName )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1223:3: lv_name_5_0= ruleUnrestrictedName
            {
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getAttributeCSAccess().getNameUnrestrictedNameParserRuleCall_2_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleAttributeCS2791);
            lv_name_5_0=ruleUnrestrictedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElementForParent(grammarAccess.getAttributeCSRule());
              	        }
                     		set(
                     			current, 
                     			"name",
                      		lv_name_5_0, 
                      		"UnrestrictedName");
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1239:2: (otherlv_6= ':' ( (lv_ownedType_7_0= ruleTypedMultiplicityRefCS ) ) )?
            int alt29=2;
            int LA29_0 = input.LA(1);

            if ( (LA29_0==61) ) {
                alt29=1;
            }
            switch (alt29) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1239:4: otherlv_6= ':' ( (lv_ownedType_7_0= ruleTypedMultiplicityRefCS ) )
                    {
                    otherlv_6=(Token)match(input,61,FollowSets000.FOLLOW_61_in_ruleAttributeCS2804); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_6, grammarAccess.getAttributeCSAccess().getColonKeyword_3_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1243:1: ( (lv_ownedType_7_0= ruleTypedMultiplicityRefCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1244:1: (lv_ownedType_7_0= ruleTypedMultiplicityRefCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1244:1: (lv_ownedType_7_0= ruleTypedMultiplicityRefCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1245:3: lv_ownedType_7_0= ruleTypedMultiplicityRefCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getAttributeCSAccess().getOwnedTypeTypedMultiplicityRefCSParserRuleCall_3_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTypedMultiplicityRefCS_in_ruleAttributeCS2825);
                    lv_ownedType_7_0=ruleTypedMultiplicityRefCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getAttributeCSRule());
                      	        }
                             		set(
                             			current, 
                             			"ownedType",
                              		lv_ownedType_7_0, 
                              		"TypedMultiplicityRefCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1261:4: (otherlv_8= '=' ( (lv_default_9_0= RULE_SINGLE_QUOTED_STRING ) ) )?
            int alt30=2;
            int LA30_0 = input.LA(1);

            if ( (LA30_0==66) ) {
                alt30=1;
            }
            switch (alt30) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1261:6: otherlv_8= '=' ( (lv_default_9_0= RULE_SINGLE_QUOTED_STRING ) )
                    {
                    otherlv_8=(Token)match(input,66,FollowSets000.FOLLOW_66_in_ruleAttributeCS2840); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_8, grammarAccess.getAttributeCSAccess().getEqualsSignKeyword_4_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1265:1: ( (lv_default_9_0= RULE_SINGLE_QUOTED_STRING ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1266:1: (lv_default_9_0= RULE_SINGLE_QUOTED_STRING )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1266:1: (lv_default_9_0= RULE_SINGLE_QUOTED_STRING )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1267:3: lv_default_9_0= RULE_SINGLE_QUOTED_STRING
                    {
                    lv_default_9_0=(Token)match(input,RULE_SINGLE_QUOTED_STRING,FollowSets000.FOLLOW_RULE_SINGLE_QUOTED_STRING_in_ruleAttributeCS2857); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			newLeafNode(lv_default_9_0, grammarAccess.getAttributeCSAccess().getDefaultSINGLE_QUOTED_STRINGTerminalRuleCall_4_1_0()); 
                      		
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getAttributeCSRule());
                      	        }
                             		setWithLastConsumed(
                             			current, 
                             			"default",
                              		lv_default_9_0, 
                              		"SINGLE_QUOTED_STRING");
                      	    
                    }

                    }


                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1283:4: (otherlv_10= '{' ( ( ( (lv_qualifier_11_0= 'derived' ) ) | ( (lv_qualifier_12_0= '!derived' ) ) | ( (lv_qualifier_13_0= 'id' ) ) | ( (lv_qualifier_14_0= '!id' ) ) | ( (lv_qualifier_15_0= 'ordered' ) ) | ( (lv_qualifier_16_0= '!ordered' ) ) | ( (lv_qualifier_17_0= 'readonly' ) ) | ( (lv_qualifier_18_0= '!readonly' ) ) | ( (lv_qualifier_19_0= 'transient' ) ) | ( (lv_qualifier_20_0= '!transient' ) ) | ( (lv_qualifier_21_0= 'unique' ) ) | ( (lv_qualifier_22_0= '!unique' ) ) | ( (lv_qualifier_23_0= 'unsettable' ) ) | ( (lv_qualifier_24_0= '!unsettable' ) ) | ( (lv_qualifier_25_0= 'volatile' ) ) | ( (lv_qualifier_26_0= '!volatile' ) ) ) (otherlv_27= ',' )? )+ otherlv_28= '}' )?
            int alt34=2;
            int LA34_0 = input.LA(1);

            if ( (LA34_0==64) ) {
                int LA34_1 = input.LA(2);

                if ( (LA34_1==28||LA34_1==31||LA34_1==38||LA34_1==43||(LA34_1>=49 && LA34_1<=52)||(LA34_1>=67 && LA34_1<=74)) ) {
                    alt34=1;
                }
            }
            switch (alt34) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1283:6: otherlv_10= '{' ( ( ( (lv_qualifier_11_0= 'derived' ) ) | ( (lv_qualifier_12_0= '!derived' ) ) | ( (lv_qualifier_13_0= 'id' ) ) | ( (lv_qualifier_14_0= '!id' ) ) | ( (lv_qualifier_15_0= 'ordered' ) ) | ( (lv_qualifier_16_0= '!ordered' ) ) | ( (lv_qualifier_17_0= 'readonly' ) ) | ( (lv_qualifier_18_0= '!readonly' ) ) | ( (lv_qualifier_19_0= 'transient' ) ) | ( (lv_qualifier_20_0= '!transient' ) ) | ( (lv_qualifier_21_0= 'unique' ) ) | ( (lv_qualifier_22_0= '!unique' ) ) | ( (lv_qualifier_23_0= 'unsettable' ) ) | ( (lv_qualifier_24_0= '!unsettable' ) ) | ( (lv_qualifier_25_0= 'volatile' ) ) | ( (lv_qualifier_26_0= '!volatile' ) ) ) (otherlv_27= ',' )? )+ otherlv_28= '}'
                    {
                    otherlv_10=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleAttributeCS2877); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_10, grammarAccess.getAttributeCSAccess().getLeftCurlyBracketKeyword_5_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1287:1: ( ( ( (lv_qualifier_11_0= 'derived' ) ) | ( (lv_qualifier_12_0= '!derived' ) ) | ( (lv_qualifier_13_0= 'id' ) ) | ( (lv_qualifier_14_0= '!id' ) ) | ( (lv_qualifier_15_0= 'ordered' ) ) | ( (lv_qualifier_16_0= '!ordered' ) ) | ( (lv_qualifier_17_0= 'readonly' ) ) | ( (lv_qualifier_18_0= '!readonly' ) ) | ( (lv_qualifier_19_0= 'transient' ) ) | ( (lv_qualifier_20_0= '!transient' ) ) | ( (lv_qualifier_21_0= 'unique' ) ) | ( (lv_qualifier_22_0= '!unique' ) ) | ( (lv_qualifier_23_0= 'unsettable' ) ) | ( (lv_qualifier_24_0= '!unsettable' ) ) | ( (lv_qualifier_25_0= 'volatile' ) ) | ( (lv_qualifier_26_0= '!volatile' ) ) ) (otherlv_27= ',' )? )+
                    int cnt33=0;
                    loop33:
                    do {
                        int alt33=2;
                        int LA33_0 = input.LA(1);

                        if ( (LA33_0==28||LA33_0==31||LA33_0==38||LA33_0==43||(LA33_0>=49 && LA33_0<=52)||(LA33_0>=67 && LA33_0<=74)) ) {
                            alt33=1;
                        }


                        switch (alt33) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1287:2: ( ( (lv_qualifier_11_0= 'derived' ) ) | ( (lv_qualifier_12_0= '!derived' ) ) | ( (lv_qualifier_13_0= 'id' ) ) | ( (lv_qualifier_14_0= '!id' ) ) | ( (lv_qualifier_15_0= 'ordered' ) ) | ( (lv_qualifier_16_0= '!ordered' ) ) | ( (lv_qualifier_17_0= 'readonly' ) ) | ( (lv_qualifier_18_0= '!readonly' ) ) | ( (lv_qualifier_19_0= 'transient' ) ) | ( (lv_qualifier_20_0= '!transient' ) ) | ( (lv_qualifier_21_0= 'unique' ) ) | ( (lv_qualifier_22_0= '!unique' ) ) | ( (lv_qualifier_23_0= 'unsettable' ) ) | ( (lv_qualifier_24_0= '!unsettable' ) ) | ( (lv_qualifier_25_0= 'volatile' ) ) | ( (lv_qualifier_26_0= '!volatile' ) ) ) (otherlv_27= ',' )?
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1287:2: ( ( (lv_qualifier_11_0= 'derived' ) ) | ( (lv_qualifier_12_0= '!derived' ) ) | ( (lv_qualifier_13_0= 'id' ) ) | ( (lv_qualifier_14_0= '!id' ) ) | ( (lv_qualifier_15_0= 'ordered' ) ) | ( (lv_qualifier_16_0= '!ordered' ) ) | ( (lv_qualifier_17_0= 'readonly' ) ) | ( (lv_qualifier_18_0= '!readonly' ) ) | ( (lv_qualifier_19_0= 'transient' ) ) | ( (lv_qualifier_20_0= '!transient' ) ) | ( (lv_qualifier_21_0= 'unique' ) ) | ( (lv_qualifier_22_0= '!unique' ) ) | ( (lv_qualifier_23_0= 'unsettable' ) ) | ( (lv_qualifier_24_0= '!unsettable' ) ) | ( (lv_qualifier_25_0= 'volatile' ) ) | ( (lv_qualifier_26_0= '!volatile' ) ) )
                    	    int alt31=16;
                    	    switch ( input.LA(1) ) {
                    	    case 28:
                    	        {
                    	        alt31=1;
                    	        }
                    	        break;
                    	    case 67:
                    	        {
                    	        alt31=2;
                    	        }
                    	        break;
                    	    case 31:
                    	        {
                    	        alt31=3;
                    	        }
                    	        break;
                    	    case 68:
                    	        {
                    	        alt31=4;
                    	        }
                    	        break;
                    	    case 38:
                    	        {
                    	        alt31=5;
                    	        }
                    	        break;
                    	    case 69:
                    	        {
                    	        alt31=6;
                    	        }
                    	        break;
                    	    case 43:
                    	        {
                    	        alt31=7;
                    	        }
                    	        break;
                    	    case 70:
                    	        {
                    	        alt31=8;
                    	        }
                    	        break;
                    	    case 49:
                    	        {
                    	        alt31=9;
                    	        }
                    	        break;
                    	    case 71:
                    	        {
                    	        alt31=10;
                    	        }
                    	        break;
                    	    case 50:
                    	        {
                    	        alt31=11;
                    	        }
                    	        break;
                    	    case 72:
                    	        {
                    	        alt31=12;
                    	        }
                    	        break;
                    	    case 51:
                    	        {
                    	        alt31=13;
                    	        }
                    	        break;
                    	    case 73:
                    	        {
                    	        alt31=14;
                    	        }
                    	        break;
                    	    case 52:
                    	        {
                    	        alt31=15;
                    	        }
                    	        break;
                    	    case 74:
                    	        {
                    	        alt31=16;
                    	        }
                    	        break;
                    	    default:
                    	        if (state.backtracking>0) {state.failed=true; return current;}
                    	        NoViableAltException nvae =
                    	            new NoViableAltException("", 31, 0, input);

                    	        throw nvae;
                    	    }

                    	    switch (alt31) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1287:3: ( (lv_qualifier_11_0= 'derived' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1287:3: ( (lv_qualifier_11_0= 'derived' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1288:1: (lv_qualifier_11_0= 'derived' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1288:1: (lv_qualifier_11_0= 'derived' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1289:3: lv_qualifier_11_0= 'derived'
                    	            {
                    	            lv_qualifier_11_0=(Token)match(input,28,FollowSets000.FOLLOW_28_in_ruleAttributeCS2897); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_11_0, grammarAccess.getAttributeCSAccess().getQualifierDerivedKeyword_5_1_0_0_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_11_0, "derived");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 2 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1303:6: ( (lv_qualifier_12_0= '!derived' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1303:6: ( (lv_qualifier_12_0= '!derived' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1304:1: (lv_qualifier_12_0= '!derived' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1304:1: (lv_qualifier_12_0= '!derived' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1305:3: lv_qualifier_12_0= '!derived'
                    	            {
                    	            lv_qualifier_12_0=(Token)match(input,67,FollowSets000.FOLLOW_67_in_ruleAttributeCS2934); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_12_0, grammarAccess.getAttributeCSAccess().getQualifierDerivedKeyword_5_1_0_1_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_12_0, "!derived");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 3 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1319:6: ( (lv_qualifier_13_0= 'id' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1319:6: ( (lv_qualifier_13_0= 'id' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1320:1: (lv_qualifier_13_0= 'id' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1320:1: (lv_qualifier_13_0= 'id' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1321:3: lv_qualifier_13_0= 'id'
                    	            {
                    	            lv_qualifier_13_0=(Token)match(input,31,FollowSets000.FOLLOW_31_in_ruleAttributeCS2971); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_13_0, grammarAccess.getAttributeCSAccess().getQualifierIdKeyword_5_1_0_2_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_13_0, "id");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 4 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1335:6: ( (lv_qualifier_14_0= '!id' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1335:6: ( (lv_qualifier_14_0= '!id' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1336:1: (lv_qualifier_14_0= '!id' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1336:1: (lv_qualifier_14_0= '!id' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1337:3: lv_qualifier_14_0= '!id'
                    	            {
                    	            lv_qualifier_14_0=(Token)match(input,68,FollowSets000.FOLLOW_68_in_ruleAttributeCS3008); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_14_0, grammarAccess.getAttributeCSAccess().getQualifierIdKeyword_5_1_0_3_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_14_0, "!id");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 5 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1351:6: ( (lv_qualifier_15_0= 'ordered' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1351:6: ( (lv_qualifier_15_0= 'ordered' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1352:1: (lv_qualifier_15_0= 'ordered' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1352:1: (lv_qualifier_15_0= 'ordered' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1353:3: lv_qualifier_15_0= 'ordered'
                    	            {
                    	            lv_qualifier_15_0=(Token)match(input,38,FollowSets000.FOLLOW_38_in_ruleAttributeCS3045); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_15_0, grammarAccess.getAttributeCSAccess().getQualifierOrderedKeyword_5_1_0_4_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_15_0, "ordered");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 6 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1367:6: ( (lv_qualifier_16_0= '!ordered' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1367:6: ( (lv_qualifier_16_0= '!ordered' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1368:1: (lv_qualifier_16_0= '!ordered' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1368:1: (lv_qualifier_16_0= '!ordered' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1369:3: lv_qualifier_16_0= '!ordered'
                    	            {
                    	            lv_qualifier_16_0=(Token)match(input,69,FollowSets000.FOLLOW_69_in_ruleAttributeCS3082); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_16_0, grammarAccess.getAttributeCSAccess().getQualifierOrderedKeyword_5_1_0_5_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_16_0, "!ordered");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 7 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1383:6: ( (lv_qualifier_17_0= 'readonly' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1383:6: ( (lv_qualifier_17_0= 'readonly' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1384:1: (lv_qualifier_17_0= 'readonly' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1384:1: (lv_qualifier_17_0= 'readonly' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1385:3: lv_qualifier_17_0= 'readonly'
                    	            {
                    	            lv_qualifier_17_0=(Token)match(input,43,FollowSets000.FOLLOW_43_in_ruleAttributeCS3119); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_17_0, grammarAccess.getAttributeCSAccess().getQualifierReadonlyKeyword_5_1_0_6_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_17_0, "readonly");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 8 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1399:6: ( (lv_qualifier_18_0= '!readonly' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1399:6: ( (lv_qualifier_18_0= '!readonly' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1400:1: (lv_qualifier_18_0= '!readonly' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1400:1: (lv_qualifier_18_0= '!readonly' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1401:3: lv_qualifier_18_0= '!readonly'
                    	            {
                    	            lv_qualifier_18_0=(Token)match(input,70,FollowSets000.FOLLOW_70_in_ruleAttributeCS3156); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_18_0, grammarAccess.getAttributeCSAccess().getQualifierReadonlyKeyword_5_1_0_7_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_18_0, "!readonly");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 9 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1415:6: ( (lv_qualifier_19_0= 'transient' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1415:6: ( (lv_qualifier_19_0= 'transient' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1416:1: (lv_qualifier_19_0= 'transient' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1416:1: (lv_qualifier_19_0= 'transient' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1417:3: lv_qualifier_19_0= 'transient'
                    	            {
                    	            lv_qualifier_19_0=(Token)match(input,49,FollowSets000.FOLLOW_49_in_ruleAttributeCS3193); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_19_0, grammarAccess.getAttributeCSAccess().getQualifierTransientKeyword_5_1_0_8_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_19_0, "transient");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 10 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1431:6: ( (lv_qualifier_20_0= '!transient' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1431:6: ( (lv_qualifier_20_0= '!transient' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1432:1: (lv_qualifier_20_0= '!transient' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1432:1: (lv_qualifier_20_0= '!transient' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1433:3: lv_qualifier_20_0= '!transient'
                    	            {
                    	            lv_qualifier_20_0=(Token)match(input,71,FollowSets000.FOLLOW_71_in_ruleAttributeCS3230); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_20_0, grammarAccess.getAttributeCSAccess().getQualifierTransientKeyword_5_1_0_9_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_20_0, "!transient");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 11 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1447:6: ( (lv_qualifier_21_0= 'unique' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1447:6: ( (lv_qualifier_21_0= 'unique' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1448:1: (lv_qualifier_21_0= 'unique' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1448:1: (lv_qualifier_21_0= 'unique' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1449:3: lv_qualifier_21_0= 'unique'
                    	            {
                    	            lv_qualifier_21_0=(Token)match(input,50,FollowSets000.FOLLOW_50_in_ruleAttributeCS3267); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_21_0, grammarAccess.getAttributeCSAccess().getQualifierUniqueKeyword_5_1_0_10_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_21_0, "unique");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 12 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1463:6: ( (lv_qualifier_22_0= '!unique' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1463:6: ( (lv_qualifier_22_0= '!unique' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1464:1: (lv_qualifier_22_0= '!unique' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1464:1: (lv_qualifier_22_0= '!unique' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1465:3: lv_qualifier_22_0= '!unique'
                    	            {
                    	            lv_qualifier_22_0=(Token)match(input,72,FollowSets000.FOLLOW_72_in_ruleAttributeCS3304); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_22_0, grammarAccess.getAttributeCSAccess().getQualifierUniqueKeyword_5_1_0_11_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_22_0, "!unique");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 13 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1479:6: ( (lv_qualifier_23_0= 'unsettable' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1479:6: ( (lv_qualifier_23_0= 'unsettable' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1480:1: (lv_qualifier_23_0= 'unsettable' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1480:1: (lv_qualifier_23_0= 'unsettable' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1481:3: lv_qualifier_23_0= 'unsettable'
                    	            {
                    	            lv_qualifier_23_0=(Token)match(input,51,FollowSets000.FOLLOW_51_in_ruleAttributeCS3341); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_23_0, grammarAccess.getAttributeCSAccess().getQualifierUnsettableKeyword_5_1_0_12_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_23_0, "unsettable");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 14 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1495:6: ( (lv_qualifier_24_0= '!unsettable' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1495:6: ( (lv_qualifier_24_0= '!unsettable' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1496:1: (lv_qualifier_24_0= '!unsettable' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1496:1: (lv_qualifier_24_0= '!unsettable' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1497:3: lv_qualifier_24_0= '!unsettable'
                    	            {
                    	            lv_qualifier_24_0=(Token)match(input,73,FollowSets000.FOLLOW_73_in_ruleAttributeCS3378); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_24_0, grammarAccess.getAttributeCSAccess().getQualifierUnsettableKeyword_5_1_0_13_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_24_0, "!unsettable");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 15 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1511:6: ( (lv_qualifier_25_0= 'volatile' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1511:6: ( (lv_qualifier_25_0= 'volatile' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1512:1: (lv_qualifier_25_0= 'volatile' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1512:1: (lv_qualifier_25_0= 'volatile' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1513:3: lv_qualifier_25_0= 'volatile'
                    	            {
                    	            lv_qualifier_25_0=(Token)match(input,52,FollowSets000.FOLLOW_52_in_ruleAttributeCS3415); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_25_0, grammarAccess.getAttributeCSAccess().getQualifierVolatileKeyword_5_1_0_14_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_25_0, "volatile");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 16 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1527:6: ( (lv_qualifier_26_0= '!volatile' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1527:6: ( (lv_qualifier_26_0= '!volatile' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1528:1: (lv_qualifier_26_0= '!volatile' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1528:1: (lv_qualifier_26_0= '!volatile' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1529:3: lv_qualifier_26_0= '!volatile'
                    	            {
                    	            lv_qualifier_26_0=(Token)match(input,74,FollowSets000.FOLLOW_74_in_ruleAttributeCS3452); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_26_0, grammarAccess.getAttributeCSAccess().getQualifierVolatileKeyword_5_1_0_15_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_26_0, "!volatile");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;

                    	    }

                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1542:3: (otherlv_27= ',' )?
                    	    int alt32=2;
                    	    int LA32_0 = input.LA(1);

                    	    if ( (LA32_0==63) ) {
                    	        alt32=1;
                    	    }
                    	    switch (alt32) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1542:5: otherlv_27= ','
                    	            {
                    	            otherlv_27=(Token)match(input,63,FollowSets000.FOLLOW_63_in_ruleAttributeCS3479); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                  	newLeafNode(otherlv_27, grammarAccess.getAttributeCSAccess().getCommaKeyword_5_1_1());
                    	                  
                    	            }

                    	            }
                    	            break;

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    if ( cnt33 >= 1 ) break loop33;
                    	    if (state.backtracking>0) {state.failed=true; return current;}
                                EarlyExitException eee =
                                    new EarlyExitException(33, input);
                                throw eee;
                        }
                        cnt33++;
                    } while (true);

                    otherlv_28=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleAttributeCS3495); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_28, grammarAccess.getAttributeCSAccess().getRightCurlyBracketKeyword_5_2());
                          
                    }

                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1550:3: ( (otherlv_29= '{' ( ( (lv_ownedAnnotation_30_0= ruleAnnotationElementCS ) ) | (otherlv_31= 'derivation' ( ruleUnrestrictedName )? otherlv_33= ':' ( (lv_ownedDefaultExpression_34_0= ruleSpecificationCS ) )? otherlv_35= ';' ) | (otherlv_36= 'initial' ( ruleUnrestrictedName )? otherlv_38= ':' ( (lv_ownedDefaultExpression_39_0= ruleSpecificationCS ) )? otherlv_40= ';' ) )* otherlv_41= '}' ) | otherlv_42= ';' )
            int alt40=2;
            int LA40_0 = input.LA(1);

            if ( (LA40_0==64) ) {
                alt40=1;
            }
            else if ( (LA40_0==62) ) {
                alt40=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 40, 0, input);

                throw nvae;
            }
            switch (alt40) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1550:4: (otherlv_29= '{' ( ( (lv_ownedAnnotation_30_0= ruleAnnotationElementCS ) ) | (otherlv_31= 'derivation' ( ruleUnrestrictedName )? otherlv_33= ':' ( (lv_ownedDefaultExpression_34_0= ruleSpecificationCS ) )? otherlv_35= ';' ) | (otherlv_36= 'initial' ( ruleUnrestrictedName )? otherlv_38= ':' ( (lv_ownedDefaultExpression_39_0= ruleSpecificationCS ) )? otherlv_40= ';' ) )* otherlv_41= '}' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1550:4: (otherlv_29= '{' ( ( (lv_ownedAnnotation_30_0= ruleAnnotationElementCS ) ) | (otherlv_31= 'derivation' ( ruleUnrestrictedName )? otherlv_33= ':' ( (lv_ownedDefaultExpression_34_0= ruleSpecificationCS ) )? otherlv_35= ';' ) | (otherlv_36= 'initial' ( ruleUnrestrictedName )? otherlv_38= ':' ( (lv_ownedDefaultExpression_39_0= ruleSpecificationCS ) )? otherlv_40= ';' ) )* otherlv_41= '}' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1550:6: otherlv_29= '{' ( ( (lv_ownedAnnotation_30_0= ruleAnnotationElementCS ) ) | (otherlv_31= 'derivation' ( ruleUnrestrictedName )? otherlv_33= ':' ( (lv_ownedDefaultExpression_34_0= ruleSpecificationCS ) )? otherlv_35= ';' ) | (otherlv_36= 'initial' ( ruleUnrestrictedName )? otherlv_38= ':' ( (lv_ownedDefaultExpression_39_0= ruleSpecificationCS ) )? otherlv_40= ';' ) )* otherlv_41= '}'
                    {
                    otherlv_29=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleAttributeCS3511); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_29, grammarAccess.getAttributeCSAccess().getLeftCurlyBracketKeyword_6_0_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1554:1: ( ( (lv_ownedAnnotation_30_0= ruleAnnotationElementCS ) ) | (otherlv_31= 'derivation' ( ruleUnrestrictedName )? otherlv_33= ':' ( (lv_ownedDefaultExpression_34_0= ruleSpecificationCS ) )? otherlv_35= ';' ) | (otherlv_36= 'initial' ( ruleUnrestrictedName )? otherlv_38= ':' ( (lv_ownedDefaultExpression_39_0= ruleSpecificationCS ) )? otherlv_40= ';' ) )*
                    loop39:
                    do {
                        int alt39=4;
                        switch ( input.LA(1) ) {
                        case 53:
                        case 54:
                        case 58:
                            {
                            alt39=1;
                            }
                            break;
                        case 27:
                            {
                            alt39=2;
                            }
                            break;
                        case 33:
                            {
                            alt39=3;
                            }
                            break;

                        }

                        switch (alt39) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1554:2: ( (lv_ownedAnnotation_30_0= ruleAnnotationElementCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1554:2: ( (lv_ownedAnnotation_30_0= ruleAnnotationElementCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1555:1: (lv_ownedAnnotation_30_0= ruleAnnotationElementCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1555:1: (lv_ownedAnnotation_30_0= ruleAnnotationElementCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1556:3: lv_ownedAnnotation_30_0= ruleAnnotationElementCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getAttributeCSAccess().getOwnedAnnotationAnnotationElementCSParserRuleCall_6_0_1_0_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleAnnotationElementCS_in_ruleAttributeCS3533);
                    	    lv_ownedAnnotation_30_0=ruleAnnotationElementCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getAttributeCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedAnnotation",
                    	              		lv_ownedAnnotation_30_0, 
                    	              		"AnnotationElementCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 2 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1573:6: (otherlv_31= 'derivation' ( ruleUnrestrictedName )? otherlv_33= ':' ( (lv_ownedDefaultExpression_34_0= ruleSpecificationCS ) )? otherlv_35= ';' )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1573:6: (otherlv_31= 'derivation' ( ruleUnrestrictedName )? otherlv_33= ':' ( (lv_ownedDefaultExpression_34_0= ruleSpecificationCS ) )? otherlv_35= ';' )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1573:8: otherlv_31= 'derivation' ( ruleUnrestrictedName )? otherlv_33= ':' ( (lv_ownedDefaultExpression_34_0= ruleSpecificationCS ) )? otherlv_35= ';'
                    	    {
                    	    otherlv_31=(Token)match(input,27,FollowSets000.FOLLOW_27_in_ruleAttributeCS3552); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_31, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_1_0());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1577:1: ( ruleUnrestrictedName )?
                    	    int alt35=2;
                    	    int LA35_0 = input.LA(1);

                    	    if ( ((LA35_0>=RULE_SIMPLE_ID && LA35_0<=RULE_ESCAPED_ID)||LA35_0==17||(LA35_0>=19 && LA35_0<=58)) ) {
                    	        alt35=1;
                    	    }
                    	    switch (alt35) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1578:2: ruleUnrestrictedName
                    	            {
                    	            if ( state.backtracking==0 ) {
                    	               
                    	              	  /* */ 
                    	              	
                    	            }
                    	            if ( state.backtracking==0 ) {
                    	               
                    	                      newCompositeNode(grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()); 
                    	                  
                    	            }
                    	            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleAttributeCS3572);
                    	            ruleUnrestrictedName();

                    	            state._fsp--;
                    	            if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {
                    	               
                    	                      afterParserOrEnumRuleCall();
                    	                  
                    	            }

                    	            }
                    	            break;

                    	    }

                    	    otherlv_33=(Token)match(input,61,FollowSets000.FOLLOW_61_in_ruleAttributeCS3585); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_33, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1592:1: ( (lv_ownedDefaultExpression_34_0= ruleSpecificationCS ) )?
                    	    int alt36=2;
                    	    int LA36_0 = input.LA(1);

                    	    if ( ((LA36_0>=RULE_INT && LA36_0<=RULE_SINGLE_QUOTED_STRING)||(LA36_0>=RULE_UNQUOTED_STRING && LA36_0<=RULE_ESCAPED_ID)||(LA36_0>=17 && LA36_0<=59)||LA36_0==77||LA36_0==85||(LA36_0>=97 && LA36_0<=110)||(LA36_0>=114 && LA36_0<=117)||LA36_0==121||LA36_0==125||LA36_0==127) ) {
                    	        alt36=1;
                    	    }
                    	    switch (alt36) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1593:1: (lv_ownedDefaultExpression_34_0= ruleSpecificationCS )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1593:1: (lv_ownedDefaultExpression_34_0= ruleSpecificationCS )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1594:3: lv_ownedDefaultExpression_34_0= ruleSpecificationCS
                    	            {
                    	            if ( state.backtracking==0 ) {
                    	               
                    	              	        newCompositeNode(grammarAccess.getAttributeCSAccess().getOwnedDefaultExpressionSpecificationCSParserRuleCall_6_0_1_1_3_0()); 
                    	              	    
                    	            }
                    	            pushFollow(FollowSets000.FOLLOW_ruleSpecificationCS_in_ruleAttributeCS3606);
                    	            lv_ownedDefaultExpression_34_0=ruleSpecificationCS();

                    	            state._fsp--;
                    	            if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElementForParent(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		add(
                    	                     			current, 
                    	                     			"ownedDefaultExpression",
                    	                      		lv_ownedDefaultExpression_34_0, 
                    	                      		"SpecificationCS");
                    	              	        afterParserOrEnumRuleCall();
                    	              	    
                    	            }

                    	            }


                    	            }
                    	            break;

                    	    }

                    	    otherlv_35=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleAttributeCS3619); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_35, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4());
                    	          
                    	    }

                    	    }


                    	    }
                    	    break;
                    	case 3 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1615:6: (otherlv_36= 'initial' ( ruleUnrestrictedName )? otherlv_38= ':' ( (lv_ownedDefaultExpression_39_0= ruleSpecificationCS ) )? otherlv_40= ';' )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1615:6: (otherlv_36= 'initial' ( ruleUnrestrictedName )? otherlv_38= ':' ( (lv_ownedDefaultExpression_39_0= ruleSpecificationCS ) )? otherlv_40= ';' )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1615:8: otherlv_36= 'initial' ( ruleUnrestrictedName )? otherlv_38= ':' ( (lv_ownedDefaultExpression_39_0= ruleSpecificationCS ) )? otherlv_40= ';'
                    	    {
                    	    otherlv_36=(Token)match(input,33,FollowSets000.FOLLOW_33_in_ruleAttributeCS3639); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_36, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_2_0());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1619:1: ( ruleUnrestrictedName )?
                    	    int alt37=2;
                    	    int LA37_0 = input.LA(1);

                    	    if ( ((LA37_0>=RULE_SIMPLE_ID && LA37_0<=RULE_ESCAPED_ID)||LA37_0==17||(LA37_0>=19 && LA37_0<=58)) ) {
                    	        alt37=1;
                    	    }
                    	    switch (alt37) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1620:2: ruleUnrestrictedName
                    	            {
                    	            if ( state.backtracking==0 ) {
                    	               
                    	              	  /* */ 
                    	              	
                    	            }
                    	            if ( state.backtracking==0 ) {
                    	               
                    	                      newCompositeNode(grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()); 
                    	                  
                    	            }
                    	            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleAttributeCS3659);
                    	            ruleUnrestrictedName();

                    	            state._fsp--;
                    	            if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {
                    	               
                    	                      afterParserOrEnumRuleCall();
                    	                  
                    	            }

                    	            }
                    	            break;

                    	    }

                    	    otherlv_38=(Token)match(input,61,FollowSets000.FOLLOW_61_in_ruleAttributeCS3672); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_38, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1634:1: ( (lv_ownedDefaultExpression_39_0= ruleSpecificationCS ) )?
                    	    int alt38=2;
                    	    int LA38_0 = input.LA(1);

                    	    if ( ((LA38_0>=RULE_INT && LA38_0<=RULE_SINGLE_QUOTED_STRING)||(LA38_0>=RULE_UNQUOTED_STRING && LA38_0<=RULE_ESCAPED_ID)||(LA38_0>=17 && LA38_0<=59)||LA38_0==77||LA38_0==85||(LA38_0>=97 && LA38_0<=110)||(LA38_0>=114 && LA38_0<=117)||LA38_0==121||LA38_0==125||LA38_0==127) ) {
                    	        alt38=1;
                    	    }
                    	    switch (alt38) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1635:1: (lv_ownedDefaultExpression_39_0= ruleSpecificationCS )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1635:1: (lv_ownedDefaultExpression_39_0= ruleSpecificationCS )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1636:3: lv_ownedDefaultExpression_39_0= ruleSpecificationCS
                    	            {
                    	            if ( state.backtracking==0 ) {
                    	               
                    	              	        newCompositeNode(grammarAccess.getAttributeCSAccess().getOwnedDefaultExpressionSpecificationCSParserRuleCall_6_0_1_2_3_0()); 
                    	              	    
                    	            }
                    	            pushFollow(FollowSets000.FOLLOW_ruleSpecificationCS_in_ruleAttributeCS3693);
                    	            lv_ownedDefaultExpression_39_0=ruleSpecificationCS();

                    	            state._fsp--;
                    	            if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElementForParent(grammarAccess.getAttributeCSRule());
                    	              	        }
                    	                     		add(
                    	                     			current, 
                    	                     			"ownedDefaultExpression",
                    	                      		lv_ownedDefaultExpression_39_0, 
                    	                      		"SpecificationCS");
                    	              	        afterParserOrEnumRuleCall();
                    	              	    
                    	            }

                    	            }


                    	            }
                    	            break;

                    	    }

                    	    otherlv_40=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleAttributeCS3706); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_40, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4());
                    	          
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop39;
                        }
                    } while (true);

                    otherlv_41=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleAttributeCS3721); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_41, grammarAccess.getAttributeCSAccess().getRightCurlyBracketKeyword_6_0_2());
                          
                    }

                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1661:7: otherlv_42= ';'
                    {
                    otherlv_42=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleAttributeCS3740); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_42, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_1());
                          
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleAttributeCS"


    // $ANTLR start "entryRuleClassCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1673:1: entryRuleClassCS returns [EObject current=null] : iv_ruleClassCS= ruleClassCS EOF ;
    public final EObject entryRuleClassCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleClassCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1674:2: (iv_ruleClassCS= ruleClassCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1675:2: iv_ruleClassCS= ruleClassCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getClassCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleClassCS_in_entryRuleClassCS3777);
            iv_ruleClassCS=ruleClassCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleClassCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleClassCS3787); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleClassCS"


    // $ANTLR start "ruleClassCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1682:1: ruleClassCS returns [EObject current=null] : ( ( (lv_qualifier_0_0= 'abstract' ) )? otherlv_1= 'class' ( (lv_name_2_0= ruleUnrestrictedName ) ) ( (lv_ownedTemplateSignature_3_0= ruleTemplateSignatureCS ) )? (otherlv_4= 'extends' ( (lv_ownedSuperType_5_0= ruleTypedRefCS ) ) (otherlv_6= ',' ( (lv_ownedSuperType_7_0= ruleTypedRefCS ) ) )* )? (otherlv_8= ':' ( (lv_instanceClassName_9_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_10= '{' ( (lv_qualifier_11_0= 'interface' ) ) otherlv_12= '}' )? ( (otherlv_13= '{' ( ( (lv_ownedAnnotation_14_0= ruleAnnotationElementCS ) ) | ( (lv_ownedOperation_15_0= ruleOperationCS ) ) | ( (lv_ownedProperty_16_0= ruleStructuralFeatureCS ) ) | ( (lv_ownedConstraint_17_0= ruleInvariantConstraintCS ) ) )* otherlv_18= '}' ) | otherlv_19= ';' ) ) ;
    public final EObject ruleClassCS() throws RecognitionException {
        EObject current = null;

        Token lv_qualifier_0_0=null;
        Token otherlv_1=null;
        Token otherlv_4=null;
        Token otherlv_6=null;
        Token otherlv_8=null;
        Token lv_instanceClassName_9_0=null;
        Token otherlv_10=null;
        Token lv_qualifier_11_0=null;
        Token otherlv_12=null;
        Token otherlv_13=null;
        Token otherlv_18=null;
        Token otherlv_19=null;
        AntlrDatatypeRuleToken lv_name_2_0 = null;

        EObject lv_ownedTemplateSignature_3_0 = null;

        EObject lv_ownedSuperType_5_0 = null;

        EObject lv_ownedSuperType_7_0 = null;

        EObject lv_ownedAnnotation_14_0 = null;

        EObject lv_ownedOperation_15_0 = null;

        EObject lv_ownedProperty_16_0 = null;

        EObject lv_ownedConstraint_17_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1685:28: ( ( ( (lv_qualifier_0_0= 'abstract' ) )? otherlv_1= 'class' ( (lv_name_2_0= ruleUnrestrictedName ) ) ( (lv_ownedTemplateSignature_3_0= ruleTemplateSignatureCS ) )? (otherlv_4= 'extends' ( (lv_ownedSuperType_5_0= ruleTypedRefCS ) ) (otherlv_6= ',' ( (lv_ownedSuperType_7_0= ruleTypedRefCS ) ) )* )? (otherlv_8= ':' ( (lv_instanceClassName_9_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_10= '{' ( (lv_qualifier_11_0= 'interface' ) ) otherlv_12= '}' )? ( (otherlv_13= '{' ( ( (lv_ownedAnnotation_14_0= ruleAnnotationElementCS ) ) | ( (lv_ownedOperation_15_0= ruleOperationCS ) ) | ( (lv_ownedProperty_16_0= ruleStructuralFeatureCS ) ) | ( (lv_ownedConstraint_17_0= ruleInvariantConstraintCS ) ) )* otherlv_18= '}' ) | otherlv_19= ';' ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1686:1: ( ( (lv_qualifier_0_0= 'abstract' ) )? otherlv_1= 'class' ( (lv_name_2_0= ruleUnrestrictedName ) ) ( (lv_ownedTemplateSignature_3_0= ruleTemplateSignatureCS ) )? (otherlv_4= 'extends' ( (lv_ownedSuperType_5_0= ruleTypedRefCS ) ) (otherlv_6= ',' ( (lv_ownedSuperType_7_0= ruleTypedRefCS ) ) )* )? (otherlv_8= ':' ( (lv_instanceClassName_9_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_10= '{' ( (lv_qualifier_11_0= 'interface' ) ) otherlv_12= '}' )? ( (otherlv_13= '{' ( ( (lv_ownedAnnotation_14_0= ruleAnnotationElementCS ) ) | ( (lv_ownedOperation_15_0= ruleOperationCS ) ) | ( (lv_ownedProperty_16_0= ruleStructuralFeatureCS ) ) | ( (lv_ownedConstraint_17_0= ruleInvariantConstraintCS ) ) )* otherlv_18= '}' ) | otherlv_19= ';' ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1686:1: ( ( (lv_qualifier_0_0= 'abstract' ) )? otherlv_1= 'class' ( (lv_name_2_0= ruleUnrestrictedName ) ) ( (lv_ownedTemplateSignature_3_0= ruleTemplateSignatureCS ) )? (otherlv_4= 'extends' ( (lv_ownedSuperType_5_0= ruleTypedRefCS ) ) (otherlv_6= ',' ( (lv_ownedSuperType_7_0= ruleTypedRefCS ) ) )* )? (otherlv_8= ':' ( (lv_instanceClassName_9_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_10= '{' ( (lv_qualifier_11_0= 'interface' ) ) otherlv_12= '}' )? ( (otherlv_13= '{' ( ( (lv_ownedAnnotation_14_0= ruleAnnotationElementCS ) ) | ( (lv_ownedOperation_15_0= ruleOperationCS ) ) | ( (lv_ownedProperty_16_0= ruleStructuralFeatureCS ) ) | ( (lv_ownedConstraint_17_0= ruleInvariantConstraintCS ) ) )* otherlv_18= '}' ) | otherlv_19= ';' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1686:2: ( (lv_qualifier_0_0= 'abstract' ) )? otherlv_1= 'class' ( (lv_name_2_0= ruleUnrestrictedName ) ) ( (lv_ownedTemplateSignature_3_0= ruleTemplateSignatureCS ) )? (otherlv_4= 'extends' ( (lv_ownedSuperType_5_0= ruleTypedRefCS ) ) (otherlv_6= ',' ( (lv_ownedSuperType_7_0= ruleTypedRefCS ) ) )* )? (otherlv_8= ':' ( (lv_instanceClassName_9_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_10= '{' ( (lv_qualifier_11_0= 'interface' ) ) otherlv_12= '}' )? ( (otherlv_13= '{' ( ( (lv_ownedAnnotation_14_0= ruleAnnotationElementCS ) ) | ( (lv_ownedOperation_15_0= ruleOperationCS ) ) | ( (lv_ownedProperty_16_0= ruleStructuralFeatureCS ) ) | ( (lv_ownedConstraint_17_0= ruleInvariantConstraintCS ) ) )* otherlv_18= '}' ) | otherlv_19= ';' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1686:2: ( (lv_qualifier_0_0= 'abstract' ) )?
            int alt41=2;
            int LA41_0 = input.LA(1);

            if ( (LA41_0==19) ) {
                alt41=1;
            }
            switch (alt41) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1687:1: (lv_qualifier_0_0= 'abstract' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1687:1: (lv_qualifier_0_0= 'abstract' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1688:3: lv_qualifier_0_0= 'abstract'
                    {
                    lv_qualifier_0_0=(Token)match(input,19,FollowSets000.FOLLOW_19_in_ruleClassCS3830); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_qualifier_0_0, grammarAccess.getClassCSAccess().getQualifierAbstractKeyword_0_0());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getClassCSRule());
                      	        }
                             		addWithLastConsumed(current, "qualifier", lv_qualifier_0_0, "abstract");
                      	    
                    }

                    }


                    }
                    break;

            }

            otherlv_1=(Token)match(input,23,FollowSets000.FOLLOW_23_in_ruleClassCS3856); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_1, grammarAccess.getClassCSAccess().getClassKeyword_1());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1705:1: ( (lv_name_2_0= ruleUnrestrictedName ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1706:1: (lv_name_2_0= ruleUnrestrictedName )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1706:1: (lv_name_2_0= ruleUnrestrictedName )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1707:3: lv_name_2_0= ruleUnrestrictedName
            {
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getClassCSAccess().getNameUnrestrictedNameParserRuleCall_2_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleClassCS3877);
            lv_name_2_0=ruleUnrestrictedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElementForParent(grammarAccess.getClassCSRule());
              	        }
                     		set(
                     			current, 
                     			"name",
                      		lv_name_2_0, 
                      		"UnrestrictedName");
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1723:2: ( (lv_ownedTemplateSignature_3_0= ruleTemplateSignatureCS ) )?
            int alt42=2;
            int LA42_0 = input.LA(1);

            if ( (LA42_0==59||LA42_0==81) ) {
                alt42=1;
            }
            switch (alt42) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1724:1: (lv_ownedTemplateSignature_3_0= ruleTemplateSignatureCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1724:1: (lv_ownedTemplateSignature_3_0= ruleTemplateSignatureCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1725:3: lv_ownedTemplateSignature_3_0= ruleTemplateSignatureCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getClassCSAccess().getOwnedTemplateSignatureTemplateSignatureCSParserRuleCall_3_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTemplateSignatureCS_in_ruleClassCS3898);
                    lv_ownedTemplateSignature_3_0=ruleTemplateSignatureCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getClassCSRule());
                      	        }
                             		set(
                             			current, 
                             			"ownedTemplateSignature",
                              		lv_ownedTemplateSignature_3_0, 
                              		"TemplateSignatureCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1741:3: (otherlv_4= 'extends' ( (lv_ownedSuperType_5_0= ruleTypedRefCS ) ) (otherlv_6= ',' ( (lv_ownedSuperType_7_0= ruleTypedRefCS ) ) )* )?
            int alt44=2;
            int LA44_0 = input.LA(1);

            if ( (LA44_0==30) ) {
                alt44=1;
            }
            switch (alt44) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1741:5: otherlv_4= 'extends' ( (lv_ownedSuperType_5_0= ruleTypedRefCS ) ) (otherlv_6= ',' ( (lv_ownedSuperType_7_0= ruleTypedRefCS ) ) )*
                    {
                    otherlv_4=(Token)match(input,30,FollowSets000.FOLLOW_30_in_ruleClassCS3912); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_4, grammarAccess.getClassCSAccess().getExtendsKeyword_4_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1745:1: ( (lv_ownedSuperType_5_0= ruleTypedRefCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1746:1: (lv_ownedSuperType_5_0= ruleTypedRefCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1746:1: (lv_ownedSuperType_5_0= ruleTypedRefCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1747:3: lv_ownedSuperType_5_0= ruleTypedRefCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getClassCSAccess().getOwnedSuperTypeTypedRefCSParserRuleCall_4_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTypedRefCS_in_ruleClassCS3933);
                    lv_ownedSuperType_5_0=ruleTypedRefCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getClassCSRule());
                      	        }
                             		add(
                             			current, 
                             			"ownedSuperType",
                              		lv_ownedSuperType_5_0, 
                              		"TypedRefCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1763:2: (otherlv_6= ',' ( (lv_ownedSuperType_7_0= ruleTypedRefCS ) ) )*
                    loop43:
                    do {
                        int alt43=2;
                        int LA43_0 = input.LA(1);

                        if ( (LA43_0==63) ) {
                            alt43=1;
                        }


                        switch (alt43) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1763:4: otherlv_6= ',' ( (lv_ownedSuperType_7_0= ruleTypedRefCS ) )
                    	    {
                    	    otherlv_6=(Token)match(input,63,FollowSets000.FOLLOW_63_in_ruleClassCS3946); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_6, grammarAccess.getClassCSAccess().getCommaKeyword_4_2_0());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1767:1: ( (lv_ownedSuperType_7_0= ruleTypedRefCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1768:1: (lv_ownedSuperType_7_0= ruleTypedRefCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1768:1: (lv_ownedSuperType_7_0= ruleTypedRefCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1769:3: lv_ownedSuperType_7_0= ruleTypedRefCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getClassCSAccess().getOwnedSuperTypeTypedRefCSParserRuleCall_4_2_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleTypedRefCS_in_ruleClassCS3967);
                    	    lv_ownedSuperType_7_0=ruleTypedRefCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getClassCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedSuperType",
                    	              		lv_ownedSuperType_7_0, 
                    	              		"TypedRefCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop43;
                        }
                    } while (true);


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1785:6: (otherlv_8= ':' ( (lv_instanceClassName_9_0= RULE_SINGLE_QUOTED_STRING ) ) )?
            int alt45=2;
            int LA45_0 = input.LA(1);

            if ( (LA45_0==61) ) {
                alt45=1;
            }
            switch (alt45) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1785:8: otherlv_8= ':' ( (lv_instanceClassName_9_0= RULE_SINGLE_QUOTED_STRING ) )
                    {
                    otherlv_8=(Token)match(input,61,FollowSets000.FOLLOW_61_in_ruleClassCS3984); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_8, grammarAccess.getClassCSAccess().getColonKeyword_5_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1789:1: ( (lv_instanceClassName_9_0= RULE_SINGLE_QUOTED_STRING ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1790:1: (lv_instanceClassName_9_0= RULE_SINGLE_QUOTED_STRING )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1790:1: (lv_instanceClassName_9_0= RULE_SINGLE_QUOTED_STRING )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1791:3: lv_instanceClassName_9_0= RULE_SINGLE_QUOTED_STRING
                    {
                    lv_instanceClassName_9_0=(Token)match(input,RULE_SINGLE_QUOTED_STRING,FollowSets000.FOLLOW_RULE_SINGLE_QUOTED_STRING_in_ruleClassCS4001); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			newLeafNode(lv_instanceClassName_9_0, grammarAccess.getClassCSAccess().getInstanceClassNameSINGLE_QUOTED_STRINGTerminalRuleCall_5_1_0()); 
                      		
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getClassCSRule());
                      	        }
                             		setWithLastConsumed(
                             			current, 
                             			"instanceClassName",
                              		lv_instanceClassName_9_0, 
                              		"SINGLE_QUOTED_STRING");
                      	    
                    }

                    }


                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1807:4: (otherlv_10= '{' ( (lv_qualifier_11_0= 'interface' ) ) otherlv_12= '}' )?
            int alt46=2;
            int LA46_0 = input.LA(1);

            if ( (LA46_0==64) ) {
                int LA46_1 = input.LA(2);

                if ( (LA46_1==34) ) {
                    alt46=1;
                }
            }
            switch (alt46) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1807:6: otherlv_10= '{' ( (lv_qualifier_11_0= 'interface' ) ) otherlv_12= '}'
                    {
                    otherlv_10=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleClassCS4021); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_10, grammarAccess.getClassCSAccess().getLeftCurlyBracketKeyword_6_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1811:1: ( (lv_qualifier_11_0= 'interface' ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1812:1: (lv_qualifier_11_0= 'interface' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1812:1: (lv_qualifier_11_0= 'interface' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1813:3: lv_qualifier_11_0= 'interface'
                    {
                    lv_qualifier_11_0=(Token)match(input,34,FollowSets000.FOLLOW_34_in_ruleClassCS4039); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_qualifier_11_0, grammarAccess.getClassCSAccess().getQualifierInterfaceKeyword_6_1_0());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getClassCSRule());
                      	        }
                             		addWithLastConsumed(current, "qualifier", lv_qualifier_11_0, "interface");
                      	    
                    }

                    }


                    }

                    otherlv_12=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleClassCS4064); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_12, grammarAccess.getClassCSAccess().getRightCurlyBracketKeyword_6_2());
                          
                    }

                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1830:3: ( (otherlv_13= '{' ( ( (lv_ownedAnnotation_14_0= ruleAnnotationElementCS ) ) | ( (lv_ownedOperation_15_0= ruleOperationCS ) ) | ( (lv_ownedProperty_16_0= ruleStructuralFeatureCS ) ) | ( (lv_ownedConstraint_17_0= ruleInvariantConstraintCS ) ) )* otherlv_18= '}' ) | otherlv_19= ';' )
            int alt48=2;
            int LA48_0 = input.LA(1);

            if ( (LA48_0==64) ) {
                alt48=1;
            }
            else if ( (LA48_0==62) ) {
                alt48=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 48, 0, input);

                throw nvae;
            }
            switch (alt48) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1830:4: (otherlv_13= '{' ( ( (lv_ownedAnnotation_14_0= ruleAnnotationElementCS ) ) | ( (lv_ownedOperation_15_0= ruleOperationCS ) ) | ( (lv_ownedProperty_16_0= ruleStructuralFeatureCS ) ) | ( (lv_ownedConstraint_17_0= ruleInvariantConstraintCS ) ) )* otherlv_18= '}' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1830:4: (otherlv_13= '{' ( ( (lv_ownedAnnotation_14_0= ruleAnnotationElementCS ) ) | ( (lv_ownedOperation_15_0= ruleOperationCS ) ) | ( (lv_ownedProperty_16_0= ruleStructuralFeatureCS ) ) | ( (lv_ownedConstraint_17_0= ruleInvariantConstraintCS ) ) )* otherlv_18= '}' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1830:6: otherlv_13= '{' ( ( (lv_ownedAnnotation_14_0= ruleAnnotationElementCS ) ) | ( (lv_ownedOperation_15_0= ruleOperationCS ) ) | ( (lv_ownedProperty_16_0= ruleStructuralFeatureCS ) ) | ( (lv_ownedConstraint_17_0= ruleInvariantConstraintCS ) ) )* otherlv_18= '}'
                    {
                    otherlv_13=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleClassCS4080); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_13, grammarAccess.getClassCSAccess().getLeftCurlyBracketKeyword_7_0_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1834:1: ( ( (lv_ownedAnnotation_14_0= ruleAnnotationElementCS ) ) | ( (lv_ownedOperation_15_0= ruleOperationCS ) ) | ( (lv_ownedProperty_16_0= ruleStructuralFeatureCS ) ) | ( (lv_ownedConstraint_17_0= ruleInvariantConstraintCS ) ) )*
                    loop47:
                    do {
                        int alt47=5;
                        alt47 = dfa47.predict(input);
                        switch (alt47) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1834:2: ( (lv_ownedAnnotation_14_0= ruleAnnotationElementCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1834:2: ( (lv_ownedAnnotation_14_0= ruleAnnotationElementCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1835:1: (lv_ownedAnnotation_14_0= ruleAnnotationElementCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1835:1: (lv_ownedAnnotation_14_0= ruleAnnotationElementCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1836:3: lv_ownedAnnotation_14_0= ruleAnnotationElementCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getClassCSAccess().getOwnedAnnotationAnnotationElementCSParserRuleCall_7_0_1_0_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleAnnotationElementCS_in_ruleClassCS4102);
                    	    lv_ownedAnnotation_14_0=ruleAnnotationElementCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getClassCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedAnnotation",
                    	              		lv_ownedAnnotation_14_0, 
                    	              		"AnnotationElementCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 2 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1853:6: ( (lv_ownedOperation_15_0= ruleOperationCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1853:6: ( (lv_ownedOperation_15_0= ruleOperationCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1854:1: (lv_ownedOperation_15_0= ruleOperationCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1854:1: (lv_ownedOperation_15_0= ruleOperationCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1855:3: lv_ownedOperation_15_0= ruleOperationCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getClassCSAccess().getOwnedOperationOperationCSParserRuleCall_7_0_1_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleOperationCS_in_ruleClassCS4129);
                    	    lv_ownedOperation_15_0=ruleOperationCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getClassCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedOperation",
                    	              		lv_ownedOperation_15_0, 
                    	              		"OperationCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 3 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1872:6: ( (lv_ownedProperty_16_0= ruleStructuralFeatureCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1872:6: ( (lv_ownedProperty_16_0= ruleStructuralFeatureCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1873:1: (lv_ownedProperty_16_0= ruleStructuralFeatureCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1873:1: (lv_ownedProperty_16_0= ruleStructuralFeatureCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1874:3: lv_ownedProperty_16_0= ruleStructuralFeatureCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getClassCSAccess().getOwnedPropertyStructuralFeatureCSParserRuleCall_7_0_1_2_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleStructuralFeatureCS_in_ruleClassCS4156);
                    	    lv_ownedProperty_16_0=ruleStructuralFeatureCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getClassCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedProperty",
                    	              		lv_ownedProperty_16_0, 
                    	              		"StructuralFeatureCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 4 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1891:6: ( (lv_ownedConstraint_17_0= ruleInvariantConstraintCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1891:6: ( (lv_ownedConstraint_17_0= ruleInvariantConstraintCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1892:1: (lv_ownedConstraint_17_0= ruleInvariantConstraintCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1892:1: (lv_ownedConstraint_17_0= ruleInvariantConstraintCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1893:3: lv_ownedConstraint_17_0= ruleInvariantConstraintCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getClassCSAccess().getOwnedConstraintInvariantConstraintCSParserRuleCall_7_0_1_3_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleInvariantConstraintCS_in_ruleClassCS4183);
                    	    lv_ownedConstraint_17_0=ruleInvariantConstraintCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getClassCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedConstraint",
                    	              		lv_ownedConstraint_17_0, 
                    	              		"InvariantConstraintCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop47;
                        }
                    } while (true);

                    otherlv_18=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleClassCS4197); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_18, grammarAccess.getClassCSAccess().getRightCurlyBracketKeyword_7_0_2());
                          
                    }

                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1914:7: otherlv_19= ';'
                    {
                    otherlv_19=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleClassCS4216); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_19, grammarAccess.getClassCSAccess().getSemicolonKeyword_7_1());
                          
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleClassCS"


    // $ANTLR start "entryRuleClassifierCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1926:1: entryRuleClassifierCS returns [EObject current=null] : iv_ruleClassifierCS= ruleClassifierCS EOF ;
    public final EObject entryRuleClassifierCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleClassifierCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1927:2: (iv_ruleClassifierCS= ruleClassifierCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1928:2: iv_ruleClassifierCS= ruleClassifierCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getClassifierCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleClassifierCS_in_entryRuleClassifierCS4253);
            iv_ruleClassifierCS=ruleClassifierCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleClassifierCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleClassifierCS4263); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleClassifierCS"


    // $ANTLR start "ruleClassifierCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1935:1: ruleClassifierCS returns [EObject current=null] : (this_ClassCS_0= ruleClassCS | this_DataTypeCS_1= ruleDataTypeCS | this_EnumerationCS_2= ruleEnumerationCS ) ;
    public final EObject ruleClassifierCS() throws RecognitionException {
        EObject current = null;

        EObject this_ClassCS_0 = null;

        EObject this_DataTypeCS_1 = null;

        EObject this_EnumerationCS_2 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1938:28: ( (this_ClassCS_0= ruleClassCS | this_DataTypeCS_1= ruleDataTypeCS | this_EnumerationCS_2= ruleEnumerationCS ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1939:1: (this_ClassCS_0= ruleClassCS | this_DataTypeCS_1= ruleDataTypeCS | this_EnumerationCS_2= ruleEnumerationCS )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1939:1: (this_ClassCS_0= ruleClassCS | this_DataTypeCS_1= ruleDataTypeCS | this_EnumerationCS_2= ruleEnumerationCS )
            int alt49=3;
            switch ( input.LA(1) ) {
            case 19:
            case 23:
                {
                alt49=1;
                }
                break;
            case 25:
                {
                alt49=2;
                }
                break;
            case 29:
                {
                alt49=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 49, 0, input);

                throw nvae;
            }

            switch (alt49) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1940:2: this_ClassCS_0= ruleClassCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getClassifierCSAccess().getClassCSParserRuleCall_0()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleClassCS_in_ruleClassifierCS4313);
                    this_ClassCS_0=ruleClassCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_ClassCS_0; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1953:2: this_DataTypeCS_1= ruleDataTypeCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getClassifierCSAccess().getDataTypeCSParserRuleCall_1()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleDataTypeCS_in_ruleClassifierCS4343);
                    this_DataTypeCS_1=ruleDataTypeCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_DataTypeCS_1; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 3 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1966:2: this_EnumerationCS_2= ruleEnumerationCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getClassifierCSAccess().getEnumerationCSParserRuleCall_2()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleEnumerationCS_in_ruleClassifierCS4373);
                    this_EnumerationCS_2=ruleEnumerationCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_EnumerationCS_2; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleClassifierCS"


    // $ANTLR start "entryRuleDataTypeCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1985:1: entryRuleDataTypeCS returns [EObject current=null] : iv_ruleDataTypeCS= ruleDataTypeCS EOF ;
    public final EObject entryRuleDataTypeCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleDataTypeCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1986:2: (iv_ruleDataTypeCS= ruleDataTypeCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1987:2: iv_ruleDataTypeCS= ruleDataTypeCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getDataTypeCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleDataTypeCS_in_entryRuleDataTypeCS4408);
            iv_ruleDataTypeCS=ruleDataTypeCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleDataTypeCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleDataTypeCS4418); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleDataTypeCS"


    // $ANTLR start "ruleDataTypeCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1994:1: ruleDataTypeCS returns [EObject current=null] : (otherlv_0= 'datatype' ( (lv_name_1_0= ruleUnrestrictedName ) ) ( (lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS ) )? (otherlv_3= ':' ( (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_5= '{' ( ( (lv_qualifier_6_0= 'serializable' ) ) | ( (lv_qualifier_7_0= '!serializable' ) ) )? otherlv_8= '}' )? ( (otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedConstraint_11_0= ruleInvariantConstraintCS ) ) )* otherlv_12= '}' ) | otherlv_13= ';' ) ) ;
    public final EObject ruleDataTypeCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_3=null;
        Token lv_instanceClassName_4_0=null;
        Token otherlv_5=null;
        Token lv_qualifier_6_0=null;
        Token lv_qualifier_7_0=null;
        Token otherlv_8=null;
        Token otherlv_9=null;
        Token otherlv_12=null;
        Token otherlv_13=null;
        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject lv_ownedTemplateSignature_2_0 = null;

        EObject lv_ownedAnnotation_10_0 = null;

        EObject lv_ownedConstraint_11_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1997:28: ( (otherlv_0= 'datatype' ( (lv_name_1_0= ruleUnrestrictedName ) ) ( (lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS ) )? (otherlv_3= ':' ( (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_5= '{' ( ( (lv_qualifier_6_0= 'serializable' ) ) | ( (lv_qualifier_7_0= '!serializable' ) ) )? otherlv_8= '}' )? ( (otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedConstraint_11_0= ruleInvariantConstraintCS ) ) )* otherlv_12= '}' ) | otherlv_13= ';' ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1998:1: (otherlv_0= 'datatype' ( (lv_name_1_0= ruleUnrestrictedName ) ) ( (lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS ) )? (otherlv_3= ':' ( (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_5= '{' ( ( (lv_qualifier_6_0= 'serializable' ) ) | ( (lv_qualifier_7_0= '!serializable' ) ) )? otherlv_8= '}' )? ( (otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedConstraint_11_0= ruleInvariantConstraintCS ) ) )* otherlv_12= '}' ) | otherlv_13= ';' ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1998:1: (otherlv_0= 'datatype' ( (lv_name_1_0= ruleUnrestrictedName ) ) ( (lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS ) )? (otherlv_3= ':' ( (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_5= '{' ( ( (lv_qualifier_6_0= 'serializable' ) ) | ( (lv_qualifier_7_0= '!serializable' ) ) )? otherlv_8= '}' )? ( (otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedConstraint_11_0= ruleInvariantConstraintCS ) ) )* otherlv_12= '}' ) | otherlv_13= ';' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:1998:3: otherlv_0= 'datatype' ( (lv_name_1_0= ruleUnrestrictedName ) ) ( (lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS ) )? (otherlv_3= ':' ( (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_5= '{' ( ( (lv_qualifier_6_0= 'serializable' ) ) | ( (lv_qualifier_7_0= '!serializable' ) ) )? otherlv_8= '}' )? ( (otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedConstraint_11_0= ruleInvariantConstraintCS ) ) )* otherlv_12= '}' ) | otherlv_13= ';' )
            {
            otherlv_0=(Token)match(input,25,FollowSets000.FOLLOW_25_in_ruleDataTypeCS4455); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_0, grammarAccess.getDataTypeCSAccess().getDatatypeKeyword_0());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2002:1: ( (lv_name_1_0= ruleUnrestrictedName ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2003:1: (lv_name_1_0= ruleUnrestrictedName )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2003:1: (lv_name_1_0= ruleUnrestrictedName )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2004:3: lv_name_1_0= ruleUnrestrictedName
            {
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getDataTypeCSAccess().getNameUnrestrictedNameParserRuleCall_1_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleDataTypeCS4476);
            lv_name_1_0=ruleUnrestrictedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElementForParent(grammarAccess.getDataTypeCSRule());
              	        }
                     		set(
                     			current, 
                     			"name",
                      		lv_name_1_0, 
                      		"UnrestrictedName");
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2020:2: ( (lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS ) )?
            int alt50=2;
            int LA50_0 = input.LA(1);

            if ( (LA50_0==59||LA50_0==81) ) {
                alt50=1;
            }
            switch (alt50) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2021:1: (lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2021:1: (lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2022:3: lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getDataTypeCSAccess().getOwnedTemplateSignatureTemplateSignatureCSParserRuleCall_2_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTemplateSignatureCS_in_ruleDataTypeCS4497);
                    lv_ownedTemplateSignature_2_0=ruleTemplateSignatureCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getDataTypeCSRule());
                      	        }
                             		set(
                             			current, 
                             			"ownedTemplateSignature",
                              		lv_ownedTemplateSignature_2_0, 
                              		"TemplateSignatureCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2038:3: (otherlv_3= ':' ( (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING ) ) )?
            int alt51=2;
            int LA51_0 = input.LA(1);

            if ( (LA51_0==61) ) {
                alt51=1;
            }
            switch (alt51) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2038:5: otherlv_3= ':' ( (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING ) )
                    {
                    otherlv_3=(Token)match(input,61,FollowSets000.FOLLOW_61_in_ruleDataTypeCS4511); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_3, grammarAccess.getDataTypeCSAccess().getColonKeyword_3_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2042:1: ( (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2043:1: (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2043:1: (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2044:3: lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING
                    {
                    lv_instanceClassName_4_0=(Token)match(input,RULE_SINGLE_QUOTED_STRING,FollowSets000.FOLLOW_RULE_SINGLE_QUOTED_STRING_in_ruleDataTypeCS4528); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			newLeafNode(lv_instanceClassName_4_0, grammarAccess.getDataTypeCSAccess().getInstanceClassNameSINGLE_QUOTED_STRINGTerminalRuleCall_3_1_0()); 
                      		
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getDataTypeCSRule());
                      	        }
                             		setWithLastConsumed(
                             			current, 
                             			"instanceClassName",
                              		lv_instanceClassName_4_0, 
                              		"SINGLE_QUOTED_STRING");
                      	    
                    }

                    }


                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2060:4: (otherlv_5= '{' ( ( (lv_qualifier_6_0= 'serializable' ) ) | ( (lv_qualifier_7_0= '!serializable' ) ) )? otherlv_8= '}' )?
            int alt53=2;
            int LA53_0 = input.LA(1);

            if ( (LA53_0==64) ) {
                int LA53_1 = input.LA(2);

                if ( (LA53_1==65) ) {
                    int LA53_3 = input.LA(3);

                    if ( (LA53_3==62||LA53_3==64) ) {
                        alt53=1;
                    }
                }
                else if ( (LA53_1==57||LA53_1==75) ) {
                    alt53=1;
                }
            }
            switch (alt53) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2060:6: otherlv_5= '{' ( ( (lv_qualifier_6_0= 'serializable' ) ) | ( (lv_qualifier_7_0= '!serializable' ) ) )? otherlv_8= '}'
                    {
                    otherlv_5=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleDataTypeCS4548); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_5, grammarAccess.getDataTypeCSAccess().getLeftCurlyBracketKeyword_4_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2064:1: ( ( (lv_qualifier_6_0= 'serializable' ) ) | ( (lv_qualifier_7_0= '!serializable' ) ) )?
                    int alt52=3;
                    int LA52_0 = input.LA(1);

                    if ( (LA52_0==57) ) {
                        alt52=1;
                    }
                    else if ( (LA52_0==75) ) {
                        alt52=2;
                    }
                    switch (alt52) {
                        case 1 :
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2064:2: ( (lv_qualifier_6_0= 'serializable' ) )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2064:2: ( (lv_qualifier_6_0= 'serializable' ) )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2065:1: (lv_qualifier_6_0= 'serializable' )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2065:1: (lv_qualifier_6_0= 'serializable' )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2066:3: lv_qualifier_6_0= 'serializable'
                            {
                            lv_qualifier_6_0=(Token)match(input,57,FollowSets000.FOLLOW_57_in_ruleDataTypeCS4567); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                                      newLeafNode(lv_qualifier_6_0, grammarAccess.getDataTypeCSAccess().getQualifierSerializableKeyword_4_1_0_0());
                                  
                            }
                            if ( state.backtracking==0 ) {

                              	        if (current==null) {
                              	            current = createModelElement(grammarAccess.getDataTypeCSRule());
                              	        }
                                     		addWithLastConsumed(current, "qualifier", lv_qualifier_6_0, "serializable");
                              	    
                            }

                            }


                            }


                            }
                            break;
                        case 2 :
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2080:6: ( (lv_qualifier_7_0= '!serializable' ) )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2080:6: ( (lv_qualifier_7_0= '!serializable' ) )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2081:1: (lv_qualifier_7_0= '!serializable' )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2081:1: (lv_qualifier_7_0= '!serializable' )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2082:3: lv_qualifier_7_0= '!serializable'
                            {
                            lv_qualifier_7_0=(Token)match(input,75,FollowSets000.FOLLOW_75_in_ruleDataTypeCS4604); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                                      newLeafNode(lv_qualifier_7_0, grammarAccess.getDataTypeCSAccess().getQualifierSerializableKeyword_4_1_1_0());
                                  
                            }
                            if ( state.backtracking==0 ) {

                              	        if (current==null) {
                              	            current = createModelElement(grammarAccess.getDataTypeCSRule());
                              	        }
                                     		addWithLastConsumed(current, "qualifier", lv_qualifier_7_0, "!serializable");
                              	    
                            }

                            }


                            }


                            }
                            break;

                    }

                    otherlv_8=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleDataTypeCS4631); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_8, grammarAccess.getDataTypeCSAccess().getRightCurlyBracketKeyword_4_2());
                          
                    }

                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2099:3: ( (otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedConstraint_11_0= ruleInvariantConstraintCS ) ) )* otherlv_12= '}' ) | otherlv_13= ';' )
            int alt55=2;
            int LA55_0 = input.LA(1);

            if ( (LA55_0==64) ) {
                alt55=1;
            }
            else if ( (LA55_0==62) ) {
                alt55=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 55, 0, input);

                throw nvae;
            }
            switch (alt55) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2099:4: (otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedConstraint_11_0= ruleInvariantConstraintCS ) ) )* otherlv_12= '}' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2099:4: (otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedConstraint_11_0= ruleInvariantConstraintCS ) ) )* otherlv_12= '}' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2099:6: otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedConstraint_11_0= ruleInvariantConstraintCS ) ) )* otherlv_12= '}'
                    {
                    otherlv_9=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleDataTypeCS4647); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_9, grammarAccess.getDataTypeCSAccess().getLeftCurlyBracketKeyword_5_0_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2103:1: ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedConstraint_11_0= ruleInvariantConstraintCS ) ) )*
                    loop54:
                    do {
                        int alt54=3;
                        int LA54_0 = input.LA(1);

                        if ( ((LA54_0>=53 && LA54_0<=54)||LA54_0==58) ) {
                            alt54=1;
                        }
                        else if ( (LA54_0==22||LA54_0==55) ) {
                            alt54=2;
                        }


                        switch (alt54) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2103:2: ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2103:2: ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2104:1: (lv_ownedAnnotation_10_0= ruleAnnotationElementCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2104:1: (lv_ownedAnnotation_10_0= ruleAnnotationElementCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2105:3: lv_ownedAnnotation_10_0= ruleAnnotationElementCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getDataTypeCSAccess().getOwnedAnnotationAnnotationElementCSParserRuleCall_5_0_1_0_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleAnnotationElementCS_in_ruleDataTypeCS4669);
                    	    lv_ownedAnnotation_10_0=ruleAnnotationElementCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getDataTypeCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedAnnotation",
                    	              		lv_ownedAnnotation_10_0, 
                    	              		"AnnotationElementCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 2 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2122:6: ( (lv_ownedConstraint_11_0= ruleInvariantConstraintCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2122:6: ( (lv_ownedConstraint_11_0= ruleInvariantConstraintCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2123:1: (lv_ownedConstraint_11_0= ruleInvariantConstraintCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2123:1: (lv_ownedConstraint_11_0= ruleInvariantConstraintCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2124:3: lv_ownedConstraint_11_0= ruleInvariantConstraintCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getDataTypeCSAccess().getOwnedConstraintInvariantConstraintCSParserRuleCall_5_0_1_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleInvariantConstraintCS_in_ruleDataTypeCS4696);
                    	    lv_ownedConstraint_11_0=ruleInvariantConstraintCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getDataTypeCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedConstraint",
                    	              		lv_ownedConstraint_11_0, 
                    	              		"InvariantConstraintCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop54;
                        }
                    } while (true);

                    otherlv_12=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleDataTypeCS4710); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_12, grammarAccess.getDataTypeCSAccess().getRightCurlyBracketKeyword_5_0_2());
                          
                    }

                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2145:7: otherlv_13= ';'
                    {
                    otherlv_13=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleDataTypeCS4729); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_13, grammarAccess.getDataTypeCSAccess().getSemicolonKeyword_5_1());
                          
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleDataTypeCS"


    // $ANTLR start "entryRuleDetailCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2157:1: entryRuleDetailCS returns [EObject current=null] : iv_ruleDetailCS= ruleDetailCS EOF ;
    public final EObject entryRuleDetailCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleDetailCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2158:2: (iv_ruleDetailCS= ruleDetailCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2159:2: iv_ruleDetailCS= ruleDetailCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getDetailCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleDetailCS_in_entryRuleDetailCS4766);
            iv_ruleDetailCS=ruleDetailCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleDetailCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleDetailCS4776); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleDetailCS"


    // $ANTLR start "ruleDetailCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2166:1: ruleDetailCS returns [EObject current=null] : ( ( ( (lv_name_0_1= ruleUnrestrictedName | lv_name_0_2= RULE_SINGLE_QUOTED_STRING ) ) ) otherlv_1= '=' ( ( (lv_value_2_1= RULE_SINGLE_QUOTED_STRING | lv_value_2_2= RULE_ML_SINGLE_QUOTED_STRING ) ) )* ) ;
    public final EObject ruleDetailCS() throws RecognitionException {
        EObject current = null;

        Token lv_name_0_2=null;
        Token otherlv_1=null;
        Token lv_value_2_1=null;
        Token lv_value_2_2=null;
        AntlrDatatypeRuleToken lv_name_0_1 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2169:28: ( ( ( ( (lv_name_0_1= ruleUnrestrictedName | lv_name_0_2= RULE_SINGLE_QUOTED_STRING ) ) ) otherlv_1= '=' ( ( (lv_value_2_1= RULE_SINGLE_QUOTED_STRING | lv_value_2_2= RULE_ML_SINGLE_QUOTED_STRING ) ) )* ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2170:1: ( ( ( (lv_name_0_1= ruleUnrestrictedName | lv_name_0_2= RULE_SINGLE_QUOTED_STRING ) ) ) otherlv_1= '=' ( ( (lv_value_2_1= RULE_SINGLE_QUOTED_STRING | lv_value_2_2= RULE_ML_SINGLE_QUOTED_STRING ) ) )* )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2170:1: ( ( ( (lv_name_0_1= ruleUnrestrictedName | lv_name_0_2= RULE_SINGLE_QUOTED_STRING ) ) ) otherlv_1= '=' ( ( (lv_value_2_1= RULE_SINGLE_QUOTED_STRING | lv_value_2_2= RULE_ML_SINGLE_QUOTED_STRING ) ) )* )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2170:2: ( ( (lv_name_0_1= ruleUnrestrictedName | lv_name_0_2= RULE_SINGLE_QUOTED_STRING ) ) ) otherlv_1= '=' ( ( (lv_value_2_1= RULE_SINGLE_QUOTED_STRING | lv_value_2_2= RULE_ML_SINGLE_QUOTED_STRING ) ) )*
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2170:2: ( ( (lv_name_0_1= ruleUnrestrictedName | lv_name_0_2= RULE_SINGLE_QUOTED_STRING ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2171:1: ( (lv_name_0_1= ruleUnrestrictedName | lv_name_0_2= RULE_SINGLE_QUOTED_STRING ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2171:1: ( (lv_name_0_1= ruleUnrestrictedName | lv_name_0_2= RULE_SINGLE_QUOTED_STRING ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2172:1: (lv_name_0_1= ruleUnrestrictedName | lv_name_0_2= RULE_SINGLE_QUOTED_STRING )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2172:1: (lv_name_0_1= ruleUnrestrictedName | lv_name_0_2= RULE_SINGLE_QUOTED_STRING )
            int alt56=2;
            int LA56_0 = input.LA(1);

            if ( ((LA56_0>=RULE_SIMPLE_ID && LA56_0<=RULE_ESCAPED_ID)||LA56_0==17||(LA56_0>=19 && LA56_0<=58)) ) {
                alt56=1;
            }
            else if ( (LA56_0==RULE_SINGLE_QUOTED_STRING) ) {
                alt56=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 56, 0, input);

                throw nvae;
            }
            switch (alt56) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2173:3: lv_name_0_1= ruleUnrestrictedName
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getDetailCSAccess().getNameUnrestrictedNameParserRuleCall_0_0_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleDetailCS4824);
                    lv_name_0_1=ruleUnrestrictedName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getDetailCSRule());
                      	        }
                             		set(
                             			current, 
                             			"name",
                              		lv_name_0_1, 
                              		"UnrestrictedName");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2188:8: lv_name_0_2= RULE_SINGLE_QUOTED_STRING
                    {
                    lv_name_0_2=(Token)match(input,RULE_SINGLE_QUOTED_STRING,FollowSets000.FOLLOW_RULE_SINGLE_QUOTED_STRING_in_ruleDetailCS4839); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			newLeafNode(lv_name_0_2, grammarAccess.getDetailCSAccess().getNameSINGLE_QUOTED_STRINGTerminalRuleCall_0_0_1()); 
                      		
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getDetailCSRule());
                      	        }
                             		setWithLastConsumed(
                             			current, 
                             			"name",
                              		lv_name_0_2, 
                              		"SINGLE_QUOTED_STRING");
                      	    
                    }

                    }
                    break;

            }


            }


            }

            otherlv_1=(Token)match(input,66,FollowSets000.FOLLOW_66_in_ruleDetailCS4859); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_1, grammarAccess.getDetailCSAccess().getEqualsSignKeyword_1());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2210:1: ( ( (lv_value_2_1= RULE_SINGLE_QUOTED_STRING | lv_value_2_2= RULE_ML_SINGLE_QUOTED_STRING ) ) )*
            loop58:
            do {
                int alt58=2;
                int LA58_0 = input.LA(1);

                if ( ((LA58_0>=RULE_SINGLE_QUOTED_STRING && LA58_0<=RULE_ML_SINGLE_QUOTED_STRING)) ) {
                    alt58=1;
                }


                switch (alt58) {
            	case 1 :
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2211:1: ( (lv_value_2_1= RULE_SINGLE_QUOTED_STRING | lv_value_2_2= RULE_ML_SINGLE_QUOTED_STRING ) )
            	    {
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2211:1: ( (lv_value_2_1= RULE_SINGLE_QUOTED_STRING | lv_value_2_2= RULE_ML_SINGLE_QUOTED_STRING ) )
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2212:1: (lv_value_2_1= RULE_SINGLE_QUOTED_STRING | lv_value_2_2= RULE_ML_SINGLE_QUOTED_STRING )
            	    {
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2212:1: (lv_value_2_1= RULE_SINGLE_QUOTED_STRING | lv_value_2_2= RULE_ML_SINGLE_QUOTED_STRING )
            	    int alt57=2;
            	    int LA57_0 = input.LA(1);

            	    if ( (LA57_0==RULE_SINGLE_QUOTED_STRING) ) {
            	        alt57=1;
            	    }
            	    else if ( (LA57_0==RULE_ML_SINGLE_QUOTED_STRING) ) {
            	        alt57=2;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 57, 0, input);

            	        throw nvae;
            	    }
            	    switch (alt57) {
            	        case 1 :
            	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2213:3: lv_value_2_1= RULE_SINGLE_QUOTED_STRING
            	            {
            	            lv_value_2_1=(Token)match(input,RULE_SINGLE_QUOTED_STRING,FollowSets000.FOLLOW_RULE_SINGLE_QUOTED_STRING_in_ruleDetailCS4878); if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              			newLeafNode(lv_value_2_1, grammarAccess.getDetailCSAccess().getValueSINGLE_QUOTED_STRINGTerminalRuleCall_2_0_0()); 
            	              		
            	            }
            	            if ( state.backtracking==0 ) {

            	              	        if (current==null) {
            	              	            current = createModelElement(grammarAccess.getDetailCSRule());
            	              	        }
            	                     		addWithLastConsumed(
            	                     			current, 
            	                     			"value",
            	                      		lv_value_2_1, 
            	                      		"SINGLE_QUOTED_STRING");
            	              	    
            	            }

            	            }
            	            break;
            	        case 2 :
            	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2228:8: lv_value_2_2= RULE_ML_SINGLE_QUOTED_STRING
            	            {
            	            lv_value_2_2=(Token)match(input,RULE_ML_SINGLE_QUOTED_STRING,FollowSets000.FOLLOW_RULE_ML_SINGLE_QUOTED_STRING_in_ruleDetailCS4898); if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              			newLeafNode(lv_value_2_2, grammarAccess.getDetailCSAccess().getValueML_SINGLE_QUOTED_STRINGTerminalRuleCall_2_0_1()); 
            	              		
            	            }
            	            if ( state.backtracking==0 ) {

            	              	        if (current==null) {
            	              	            current = createModelElement(grammarAccess.getDetailCSRule());
            	              	        }
            	                     		addWithLastConsumed(
            	                     			current, 
            	                     			"value",
            	                      		lv_value_2_2, 
            	                      		"ML_SINGLE_QUOTED_STRING");
            	              	    
            	            }

            	            }
            	            break;

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop58;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleDetailCS"


    // $ANTLR start "entryRuleDocumentationCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2254:1: entryRuleDocumentationCS returns [EObject current=null] : iv_ruleDocumentationCS= ruleDocumentationCS EOF ;
    public final EObject entryRuleDocumentationCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleDocumentationCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2255:2: (iv_ruleDocumentationCS= ruleDocumentationCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2256:2: iv_ruleDocumentationCS= ruleDocumentationCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getDocumentationCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleDocumentationCS_in_entryRuleDocumentationCS4943);
            iv_ruleDocumentationCS=ruleDocumentationCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleDocumentationCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleDocumentationCS4953); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleDocumentationCS"


    // $ANTLR start "ruleDocumentationCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2263:1: ruleDocumentationCS returns [EObject current=null] : ( () otherlv_1= 'documentation' ( (lv_value_2_0= RULE_SINGLE_QUOTED_STRING ) )? (otherlv_3= '(' ( (lv_ownedDetail_4_0= ruleDetailCS ) ) (otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) ) )* otherlv_7= ')' )? otherlv_8= ';' ) ;
    public final EObject ruleDocumentationCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token lv_value_2_0=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        Token otherlv_7=null;
        Token otherlv_8=null;
        EObject lv_ownedDetail_4_0 = null;

        EObject lv_ownedDetail_6_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2266:28: ( ( () otherlv_1= 'documentation' ( (lv_value_2_0= RULE_SINGLE_QUOTED_STRING ) )? (otherlv_3= '(' ( (lv_ownedDetail_4_0= ruleDetailCS ) ) (otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) ) )* otherlv_7= ')' )? otherlv_8= ';' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2267:1: ( () otherlv_1= 'documentation' ( (lv_value_2_0= RULE_SINGLE_QUOTED_STRING ) )? (otherlv_3= '(' ( (lv_ownedDetail_4_0= ruleDetailCS ) ) (otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) ) )* otherlv_7= ')' )? otherlv_8= ';' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2267:1: ( () otherlv_1= 'documentation' ( (lv_value_2_0= RULE_SINGLE_QUOTED_STRING ) )? (otherlv_3= '(' ( (lv_ownedDetail_4_0= ruleDetailCS ) ) (otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) ) )* otherlv_7= ')' )? otherlv_8= ';' )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2267:2: () otherlv_1= 'documentation' ( (lv_value_2_0= RULE_SINGLE_QUOTED_STRING ) )? (otherlv_3= '(' ( (lv_ownedDetail_4_0= ruleDetailCS ) ) (otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) ) )* otherlv_7= ')' )? otherlv_8= ';'
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2267:2: ()
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2268:2: 
            {
            if ( state.backtracking==0 ) {
               
              	  /* */ 
              	
            }
            if ( state.backtracking==0 ) {

                      current = forceCreateModelElement(
                          grammarAccess.getDocumentationCSAccess().getDocumentationCSAction_0(),
                          current);
                  
            }

            }

            otherlv_1=(Token)match(input,54,FollowSets000.FOLLOW_54_in_ruleDocumentationCS5002); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_1, grammarAccess.getDocumentationCSAccess().getDocumentationKeyword_1());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2280:1: ( (lv_value_2_0= RULE_SINGLE_QUOTED_STRING ) )?
            int alt59=2;
            int LA59_0 = input.LA(1);

            if ( (LA59_0==RULE_SINGLE_QUOTED_STRING) ) {
                alt59=1;
            }
            switch (alt59) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2281:1: (lv_value_2_0= RULE_SINGLE_QUOTED_STRING )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2281:1: (lv_value_2_0= RULE_SINGLE_QUOTED_STRING )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2282:3: lv_value_2_0= RULE_SINGLE_QUOTED_STRING
                    {
                    lv_value_2_0=(Token)match(input,RULE_SINGLE_QUOTED_STRING,FollowSets000.FOLLOW_RULE_SINGLE_QUOTED_STRING_in_ruleDocumentationCS5019); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			newLeafNode(lv_value_2_0, grammarAccess.getDocumentationCSAccess().getValueSINGLE_QUOTED_STRINGTerminalRuleCall_2_0()); 
                      		
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getDocumentationCSRule());
                      	        }
                             		setWithLastConsumed(
                             			current, 
                             			"value",
                              		lv_value_2_0, 
                              		"SINGLE_QUOTED_STRING");
                      	    
                    }

                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2298:3: (otherlv_3= '(' ( (lv_ownedDetail_4_0= ruleDetailCS ) ) (otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) ) )* otherlv_7= ')' )?
            int alt61=2;
            int LA61_0 = input.LA(1);

            if ( (LA61_0==59) ) {
                alt61=1;
            }
            switch (alt61) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2298:5: otherlv_3= '(' ( (lv_ownedDetail_4_0= ruleDetailCS ) ) (otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) ) )* otherlv_7= ')'
                    {
                    otherlv_3=(Token)match(input,59,FollowSets000.FOLLOW_59_in_ruleDocumentationCS5038); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_3, grammarAccess.getDocumentationCSAccess().getLeftParenthesisKeyword_3_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2302:1: ( (lv_ownedDetail_4_0= ruleDetailCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2303:1: (lv_ownedDetail_4_0= ruleDetailCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2303:1: (lv_ownedDetail_4_0= ruleDetailCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2304:3: lv_ownedDetail_4_0= ruleDetailCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getDocumentationCSAccess().getOwnedDetailDetailCSParserRuleCall_3_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleDetailCS_in_ruleDocumentationCS5059);
                    lv_ownedDetail_4_0=ruleDetailCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getDocumentationCSRule());
                      	        }
                             		add(
                             			current, 
                             			"ownedDetail",
                              		lv_ownedDetail_4_0, 
                              		"DetailCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2320:2: (otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) ) )*
                    loop60:
                    do {
                        int alt60=2;
                        int LA60_0 = input.LA(1);

                        if ( (LA60_0==63) ) {
                            alt60=1;
                        }


                        switch (alt60) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2320:4: otherlv_5= ',' ( (lv_ownedDetail_6_0= ruleDetailCS ) )
                    	    {
                    	    otherlv_5=(Token)match(input,63,FollowSets000.FOLLOW_63_in_ruleDocumentationCS5072); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_5, grammarAccess.getDocumentationCSAccess().getCommaKeyword_3_2_0());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2324:1: ( (lv_ownedDetail_6_0= ruleDetailCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2325:1: (lv_ownedDetail_6_0= ruleDetailCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2325:1: (lv_ownedDetail_6_0= ruleDetailCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2326:3: lv_ownedDetail_6_0= ruleDetailCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getDocumentationCSAccess().getOwnedDetailDetailCSParserRuleCall_3_2_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleDetailCS_in_ruleDocumentationCS5093);
                    	    lv_ownedDetail_6_0=ruleDetailCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getDocumentationCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedDetail",
                    	              		lv_ownedDetail_6_0, 
                    	              		"DetailCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop60;
                        }
                    } while (true);

                    otherlv_7=(Token)match(input,60,FollowSets000.FOLLOW_60_in_ruleDocumentationCS5107); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_7, grammarAccess.getDocumentationCSAccess().getRightParenthesisKeyword_3_3());
                          
                    }

                    }
                    break;

            }

            otherlv_8=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleDocumentationCS5121); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_8, grammarAccess.getDocumentationCSAccess().getSemicolonKeyword_4());
                  
            }

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleDocumentationCS"


    // $ANTLR start "entryRuleEnumerationCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2358:1: entryRuleEnumerationCS returns [EObject current=null] : iv_ruleEnumerationCS= ruleEnumerationCS EOF ;
    public final EObject entryRuleEnumerationCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleEnumerationCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2359:2: (iv_ruleEnumerationCS= ruleEnumerationCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2360:2: iv_ruleEnumerationCS= ruleEnumerationCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getEnumerationCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleEnumerationCS_in_entryRuleEnumerationCS5157);
            iv_ruleEnumerationCS=ruleEnumerationCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleEnumerationCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleEnumerationCS5167); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleEnumerationCS"


    // $ANTLR start "ruleEnumerationCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2367:1: ruleEnumerationCS returns [EObject current=null] : (otherlv_0= 'enum' ( (lv_name_1_0= ruleUnrestrictedName ) ) ( (lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS ) )? (otherlv_3= ':' ( (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_5= '{' ( ( (lv_qualifier_6_0= 'serializable' ) ) | ( (lv_qualifier_7_0= '!serializable' ) ) )? otherlv_8= '}' )? ( (otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedLiterals_11_0= ruleEnumerationLiteralCS ) ) | ( (lv_ownedConstraint_12_0= ruleInvariantConstraintCS ) ) )* otherlv_13= '}' ) | otherlv_14= ';' ) ) ;
    public final EObject ruleEnumerationCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_3=null;
        Token lv_instanceClassName_4_0=null;
        Token otherlv_5=null;
        Token lv_qualifier_6_0=null;
        Token lv_qualifier_7_0=null;
        Token otherlv_8=null;
        Token otherlv_9=null;
        Token otherlv_13=null;
        Token otherlv_14=null;
        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject lv_ownedTemplateSignature_2_0 = null;

        EObject lv_ownedAnnotation_10_0 = null;

        EObject lv_ownedLiterals_11_0 = null;

        EObject lv_ownedConstraint_12_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2370:28: ( (otherlv_0= 'enum' ( (lv_name_1_0= ruleUnrestrictedName ) ) ( (lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS ) )? (otherlv_3= ':' ( (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_5= '{' ( ( (lv_qualifier_6_0= 'serializable' ) ) | ( (lv_qualifier_7_0= '!serializable' ) ) )? otherlv_8= '}' )? ( (otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedLiterals_11_0= ruleEnumerationLiteralCS ) ) | ( (lv_ownedConstraint_12_0= ruleInvariantConstraintCS ) ) )* otherlv_13= '}' ) | otherlv_14= ';' ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2371:1: (otherlv_0= 'enum' ( (lv_name_1_0= ruleUnrestrictedName ) ) ( (lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS ) )? (otherlv_3= ':' ( (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_5= '{' ( ( (lv_qualifier_6_0= 'serializable' ) ) | ( (lv_qualifier_7_0= '!serializable' ) ) )? otherlv_8= '}' )? ( (otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedLiterals_11_0= ruleEnumerationLiteralCS ) ) | ( (lv_ownedConstraint_12_0= ruleInvariantConstraintCS ) ) )* otherlv_13= '}' ) | otherlv_14= ';' ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2371:1: (otherlv_0= 'enum' ( (lv_name_1_0= ruleUnrestrictedName ) ) ( (lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS ) )? (otherlv_3= ':' ( (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_5= '{' ( ( (lv_qualifier_6_0= 'serializable' ) ) | ( (lv_qualifier_7_0= '!serializable' ) ) )? otherlv_8= '}' )? ( (otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedLiterals_11_0= ruleEnumerationLiteralCS ) ) | ( (lv_ownedConstraint_12_0= ruleInvariantConstraintCS ) ) )* otherlv_13= '}' ) | otherlv_14= ';' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2371:3: otherlv_0= 'enum' ( (lv_name_1_0= ruleUnrestrictedName ) ) ( (lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS ) )? (otherlv_3= ':' ( (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_5= '{' ( ( (lv_qualifier_6_0= 'serializable' ) ) | ( (lv_qualifier_7_0= '!serializable' ) ) )? otherlv_8= '}' )? ( (otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedLiterals_11_0= ruleEnumerationLiteralCS ) ) | ( (lv_ownedConstraint_12_0= ruleInvariantConstraintCS ) ) )* otherlv_13= '}' ) | otherlv_14= ';' )
            {
            otherlv_0=(Token)match(input,29,FollowSets000.FOLLOW_29_in_ruleEnumerationCS5204); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_0, grammarAccess.getEnumerationCSAccess().getEnumKeyword_0());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2375:1: ( (lv_name_1_0= ruleUnrestrictedName ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2376:1: (lv_name_1_0= ruleUnrestrictedName )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2376:1: (lv_name_1_0= ruleUnrestrictedName )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2377:3: lv_name_1_0= ruleUnrestrictedName
            {
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getEnumerationCSAccess().getNameUnrestrictedNameParserRuleCall_1_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleEnumerationCS5225);
            lv_name_1_0=ruleUnrestrictedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElementForParent(grammarAccess.getEnumerationCSRule());
              	        }
                     		set(
                     			current, 
                     			"name",
                      		lv_name_1_0, 
                      		"UnrestrictedName");
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2393:2: ( (lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS ) )?
            int alt62=2;
            int LA62_0 = input.LA(1);

            if ( (LA62_0==59||LA62_0==81) ) {
                alt62=1;
            }
            switch (alt62) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2394:1: (lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2394:1: (lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2395:3: lv_ownedTemplateSignature_2_0= ruleTemplateSignatureCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getEnumerationCSAccess().getOwnedTemplateSignatureTemplateSignatureCSParserRuleCall_2_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTemplateSignatureCS_in_ruleEnumerationCS5246);
                    lv_ownedTemplateSignature_2_0=ruleTemplateSignatureCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getEnumerationCSRule());
                      	        }
                             		set(
                             			current, 
                             			"ownedTemplateSignature",
                              		lv_ownedTemplateSignature_2_0, 
                              		"TemplateSignatureCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2411:3: (otherlv_3= ':' ( (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING ) ) )?
            int alt63=2;
            int LA63_0 = input.LA(1);

            if ( (LA63_0==61) ) {
                alt63=1;
            }
            switch (alt63) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2411:5: otherlv_3= ':' ( (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING ) )
                    {
                    otherlv_3=(Token)match(input,61,FollowSets000.FOLLOW_61_in_ruleEnumerationCS5260); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_3, grammarAccess.getEnumerationCSAccess().getColonKeyword_3_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2415:1: ( (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2416:1: (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2416:1: (lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2417:3: lv_instanceClassName_4_0= RULE_SINGLE_QUOTED_STRING
                    {
                    lv_instanceClassName_4_0=(Token)match(input,RULE_SINGLE_QUOTED_STRING,FollowSets000.FOLLOW_RULE_SINGLE_QUOTED_STRING_in_ruleEnumerationCS5277); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			newLeafNode(lv_instanceClassName_4_0, grammarAccess.getEnumerationCSAccess().getInstanceClassNameSINGLE_QUOTED_STRINGTerminalRuleCall_3_1_0()); 
                      		
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEnumerationCSRule());
                      	        }
                             		setWithLastConsumed(
                             			current, 
                             			"instanceClassName",
                              		lv_instanceClassName_4_0, 
                              		"SINGLE_QUOTED_STRING");
                      	    
                    }

                    }


                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2433:4: (otherlv_5= '{' ( ( (lv_qualifier_6_0= 'serializable' ) ) | ( (lv_qualifier_7_0= '!serializable' ) ) )? otherlv_8= '}' )?
            int alt65=2;
            int LA65_0 = input.LA(1);

            if ( (LA65_0==64) ) {
                int LA65_1 = input.LA(2);

                if ( (LA65_1==65) ) {
                    int LA65_3 = input.LA(3);

                    if ( (LA65_3==62||LA65_3==64) ) {
                        alt65=1;
                    }
                }
                else if ( (LA65_1==57||LA65_1==75) ) {
                    alt65=1;
                }
            }
            switch (alt65) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2433:6: otherlv_5= '{' ( ( (lv_qualifier_6_0= 'serializable' ) ) | ( (lv_qualifier_7_0= '!serializable' ) ) )? otherlv_8= '}'
                    {
                    otherlv_5=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleEnumerationCS5297); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_5, grammarAccess.getEnumerationCSAccess().getLeftCurlyBracketKeyword_4_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2437:1: ( ( (lv_qualifier_6_0= 'serializable' ) ) | ( (lv_qualifier_7_0= '!serializable' ) ) )?
                    int alt64=3;
                    int LA64_0 = input.LA(1);

                    if ( (LA64_0==57) ) {
                        alt64=1;
                    }
                    else if ( (LA64_0==75) ) {
                        alt64=2;
                    }
                    switch (alt64) {
                        case 1 :
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2437:2: ( (lv_qualifier_6_0= 'serializable' ) )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2437:2: ( (lv_qualifier_6_0= 'serializable' ) )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2438:1: (lv_qualifier_6_0= 'serializable' )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2438:1: (lv_qualifier_6_0= 'serializable' )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2439:3: lv_qualifier_6_0= 'serializable'
                            {
                            lv_qualifier_6_0=(Token)match(input,57,FollowSets000.FOLLOW_57_in_ruleEnumerationCS5316); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                                      newLeafNode(lv_qualifier_6_0, grammarAccess.getEnumerationCSAccess().getQualifierSerializableKeyword_4_1_0_0());
                                  
                            }
                            if ( state.backtracking==0 ) {

                              	        if (current==null) {
                              	            current = createModelElement(grammarAccess.getEnumerationCSRule());
                              	        }
                                     		addWithLastConsumed(current, "qualifier", lv_qualifier_6_0, "serializable");
                              	    
                            }

                            }


                            }


                            }
                            break;
                        case 2 :
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2453:6: ( (lv_qualifier_7_0= '!serializable' ) )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2453:6: ( (lv_qualifier_7_0= '!serializable' ) )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2454:1: (lv_qualifier_7_0= '!serializable' )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2454:1: (lv_qualifier_7_0= '!serializable' )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2455:3: lv_qualifier_7_0= '!serializable'
                            {
                            lv_qualifier_7_0=(Token)match(input,75,FollowSets000.FOLLOW_75_in_ruleEnumerationCS5353); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                                      newLeafNode(lv_qualifier_7_0, grammarAccess.getEnumerationCSAccess().getQualifierSerializableKeyword_4_1_1_0());
                                  
                            }
                            if ( state.backtracking==0 ) {

                              	        if (current==null) {
                              	            current = createModelElement(grammarAccess.getEnumerationCSRule());
                              	        }
                                     		addWithLastConsumed(current, "qualifier", lv_qualifier_7_0, "!serializable");
                              	    
                            }

                            }


                            }


                            }
                            break;

                    }

                    otherlv_8=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleEnumerationCS5380); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_8, grammarAccess.getEnumerationCSAccess().getRightCurlyBracketKeyword_4_2());
                          
                    }

                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2472:3: ( (otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedLiterals_11_0= ruleEnumerationLiteralCS ) ) | ( (lv_ownedConstraint_12_0= ruleInvariantConstraintCS ) ) )* otherlv_13= '}' ) | otherlv_14= ';' )
            int alt67=2;
            int LA67_0 = input.LA(1);

            if ( (LA67_0==64) ) {
                alt67=1;
            }
            else if ( (LA67_0==62) ) {
                alt67=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 67, 0, input);

                throw nvae;
            }
            switch (alt67) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2472:4: (otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedLiterals_11_0= ruleEnumerationLiteralCS ) ) | ( (lv_ownedConstraint_12_0= ruleInvariantConstraintCS ) ) )* otherlv_13= '}' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2472:4: (otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedLiterals_11_0= ruleEnumerationLiteralCS ) ) | ( (lv_ownedConstraint_12_0= ruleInvariantConstraintCS ) ) )* otherlv_13= '}' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2472:6: otherlv_9= '{' ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedLiterals_11_0= ruleEnumerationLiteralCS ) ) | ( (lv_ownedConstraint_12_0= ruleInvariantConstraintCS ) ) )* otherlv_13= '}'
                    {
                    otherlv_9=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleEnumerationCS5396); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_9, grammarAccess.getEnumerationCSAccess().getLeftCurlyBracketKeyword_5_0_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2476:1: ( ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) ) | ( (lv_ownedLiterals_11_0= ruleEnumerationLiteralCS ) ) | ( (lv_ownedConstraint_12_0= ruleInvariantConstraintCS ) ) )*
                    loop66:
                    do {
                        int alt66=4;
                        switch ( input.LA(1) ) {
                        case 53:
                        case 54:
                        case 58:
                            {
                            alt66=1;
                            }
                            break;
                        case RULE_SIMPLE_ID:
                        case RULE_ESCAPED_ID:
                        case 17:
                        case 19:
                        case 20:
                        case 21:
                        case 23:
                        case 24:
                        case 25:
                        case 26:
                        case 27:
                        case 28:
                        case 29:
                        case 30:
                        case 31:
                        case 32:
                        case 33:
                        case 34:
                        case 35:
                        case 36:
                        case 37:
                        case 38:
                        case 39:
                        case 40:
                        case 41:
                        case 42:
                        case 43:
                        case 44:
                        case 45:
                        case 46:
                        case 47:
                        case 48:
                        case 49:
                        case 50:
                        case 51:
                        case 52:
                        case 56:
                            {
                            alt66=2;
                            }
                            break;
                        case 22:
                            {
                            int LA66_4 = input.LA(2);

                            if ( (LA66_4==55) ) {
                                alt66=3;
                            }
                            else if ( (LA66_4==62||LA66_4==64||LA66_4==66) ) {
                                alt66=2;
                            }


                            }
                            break;
                        case 55:
                            {
                            alt66=3;
                            }
                            break;

                        }

                        switch (alt66) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2476:2: ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2476:2: ( (lv_ownedAnnotation_10_0= ruleAnnotationElementCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2477:1: (lv_ownedAnnotation_10_0= ruleAnnotationElementCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2477:1: (lv_ownedAnnotation_10_0= ruleAnnotationElementCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2478:3: lv_ownedAnnotation_10_0= ruleAnnotationElementCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getEnumerationCSAccess().getOwnedAnnotationAnnotationElementCSParserRuleCall_5_0_1_0_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleAnnotationElementCS_in_ruleEnumerationCS5418);
                    	    lv_ownedAnnotation_10_0=ruleAnnotationElementCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getEnumerationCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedAnnotation",
                    	              		lv_ownedAnnotation_10_0, 
                    	              		"AnnotationElementCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 2 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2495:6: ( (lv_ownedLiterals_11_0= ruleEnumerationLiteralCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2495:6: ( (lv_ownedLiterals_11_0= ruleEnumerationLiteralCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2496:1: (lv_ownedLiterals_11_0= ruleEnumerationLiteralCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2496:1: (lv_ownedLiterals_11_0= ruleEnumerationLiteralCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2497:3: lv_ownedLiterals_11_0= ruleEnumerationLiteralCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getEnumerationCSAccess().getOwnedLiteralsEnumerationLiteralCSParserRuleCall_5_0_1_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleEnumerationLiteralCS_in_ruleEnumerationCS5445);
                    	    lv_ownedLiterals_11_0=ruleEnumerationLiteralCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getEnumerationCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedLiterals",
                    	              		lv_ownedLiterals_11_0, 
                    	              		"EnumerationLiteralCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 3 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2514:6: ( (lv_ownedConstraint_12_0= ruleInvariantConstraintCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2514:6: ( (lv_ownedConstraint_12_0= ruleInvariantConstraintCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2515:1: (lv_ownedConstraint_12_0= ruleInvariantConstraintCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2515:1: (lv_ownedConstraint_12_0= ruleInvariantConstraintCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2516:3: lv_ownedConstraint_12_0= ruleInvariantConstraintCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getEnumerationCSAccess().getOwnedConstraintInvariantConstraintCSParserRuleCall_5_0_1_2_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleInvariantConstraintCS_in_ruleEnumerationCS5472);
                    	    lv_ownedConstraint_12_0=ruleInvariantConstraintCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getEnumerationCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedConstraint",
                    	              		lv_ownedConstraint_12_0, 
                    	              		"InvariantConstraintCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop66;
                        }
                    } while (true);

                    otherlv_13=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleEnumerationCS5486); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_13, grammarAccess.getEnumerationCSAccess().getRightCurlyBracketKeyword_5_0_2());
                          
                    }

                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2537:7: otherlv_14= ';'
                    {
                    otherlv_14=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleEnumerationCS5505); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_14, grammarAccess.getEnumerationCSAccess().getSemicolonKeyword_5_1());
                          
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleEnumerationCS"


    // $ANTLR start "entryRuleEnumerationLiteralCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2549:1: entryRuleEnumerationLiteralCS returns [EObject current=null] : iv_ruleEnumerationLiteralCS= ruleEnumerationLiteralCS EOF ;
    public final EObject entryRuleEnumerationLiteralCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleEnumerationLiteralCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2550:2: (iv_ruleEnumerationLiteralCS= ruleEnumerationLiteralCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2551:2: iv_ruleEnumerationLiteralCS= ruleEnumerationLiteralCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getEnumerationLiteralCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleEnumerationLiteralCS_in_entryRuleEnumerationLiteralCS5542);
            iv_ruleEnumerationLiteralCS=ruleEnumerationLiteralCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleEnumerationLiteralCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleEnumerationLiteralCS5552); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleEnumerationLiteralCS"


    // $ANTLR start "ruleEnumerationLiteralCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2558:1: ruleEnumerationLiteralCS returns [EObject current=null] : ( ( (otherlv_0= 'literal' ( (lv_name_1_0= ruleUnrestrictedName ) ) ) | ( (lv_name_2_0= ruleEnumerationLiteralName ) ) ) (otherlv_3= '=' ( (lv_value_4_0= ruleSIGNED ) ) )? ( (otherlv_5= '{' ( (lv_ownedAnnotation_6_0= ruleAnnotationElementCS ) )* otherlv_7= '}' ) | otherlv_8= ';' ) ) ;
    public final EObject ruleEnumerationLiteralCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        Token otherlv_7=null;
        Token otherlv_8=null;
        AntlrDatatypeRuleToken lv_name_1_0 = null;

        AntlrDatatypeRuleToken lv_name_2_0 = null;

        AntlrDatatypeRuleToken lv_value_4_0 = null;

        EObject lv_ownedAnnotation_6_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2561:28: ( ( ( (otherlv_0= 'literal' ( (lv_name_1_0= ruleUnrestrictedName ) ) ) | ( (lv_name_2_0= ruleEnumerationLiteralName ) ) ) (otherlv_3= '=' ( (lv_value_4_0= ruleSIGNED ) ) )? ( (otherlv_5= '{' ( (lv_ownedAnnotation_6_0= ruleAnnotationElementCS ) )* otherlv_7= '}' ) | otherlv_8= ';' ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2562:1: ( ( (otherlv_0= 'literal' ( (lv_name_1_0= ruleUnrestrictedName ) ) ) | ( (lv_name_2_0= ruleEnumerationLiteralName ) ) ) (otherlv_3= '=' ( (lv_value_4_0= ruleSIGNED ) ) )? ( (otherlv_5= '{' ( (lv_ownedAnnotation_6_0= ruleAnnotationElementCS ) )* otherlv_7= '}' ) | otherlv_8= ';' ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2562:1: ( ( (otherlv_0= 'literal' ( (lv_name_1_0= ruleUnrestrictedName ) ) ) | ( (lv_name_2_0= ruleEnumerationLiteralName ) ) ) (otherlv_3= '=' ( (lv_value_4_0= ruleSIGNED ) ) )? ( (otherlv_5= '{' ( (lv_ownedAnnotation_6_0= ruleAnnotationElementCS ) )* otherlv_7= '}' ) | otherlv_8= ';' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2562:2: ( (otherlv_0= 'literal' ( (lv_name_1_0= ruleUnrestrictedName ) ) ) | ( (lv_name_2_0= ruleEnumerationLiteralName ) ) ) (otherlv_3= '=' ( (lv_value_4_0= ruleSIGNED ) ) )? ( (otherlv_5= '{' ( (lv_ownedAnnotation_6_0= ruleAnnotationElementCS ) )* otherlv_7= '}' ) | otherlv_8= ';' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2562:2: ( (otherlv_0= 'literal' ( (lv_name_1_0= ruleUnrestrictedName ) ) ) | ( (lv_name_2_0= ruleEnumerationLiteralName ) ) )
            int alt68=2;
            int LA68_0 = input.LA(1);

            if ( (LA68_0==56) ) {
                alt68=1;
            }
            else if ( ((LA68_0>=RULE_SIMPLE_ID && LA68_0<=RULE_ESCAPED_ID)||LA68_0==17||(LA68_0>=19 && LA68_0<=52)) ) {
                alt68=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 68, 0, input);

                throw nvae;
            }
            switch (alt68) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2562:3: (otherlv_0= 'literal' ( (lv_name_1_0= ruleUnrestrictedName ) ) )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2562:3: (otherlv_0= 'literal' ( (lv_name_1_0= ruleUnrestrictedName ) ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2562:5: otherlv_0= 'literal' ( (lv_name_1_0= ruleUnrestrictedName ) )
                    {
                    otherlv_0=(Token)match(input,56,FollowSets000.FOLLOW_56_in_ruleEnumerationLiteralCS5591); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_0, grammarAccess.getEnumerationLiteralCSAccess().getLiteralKeyword_0_0_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2566:1: ( (lv_name_1_0= ruleUnrestrictedName ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2567:1: (lv_name_1_0= ruleUnrestrictedName )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2567:1: (lv_name_1_0= ruleUnrestrictedName )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2568:3: lv_name_1_0= ruleUnrestrictedName
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getEnumerationLiteralCSAccess().getNameUnrestrictedNameParserRuleCall_0_0_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleEnumerationLiteralCS5612);
                    lv_name_1_0=ruleUnrestrictedName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getEnumerationLiteralCSRule());
                      	        }
                             		set(
                             			current, 
                             			"name",
                              		lv_name_1_0, 
                              		"UnrestrictedName");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }


                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2585:6: ( (lv_name_2_0= ruleEnumerationLiteralName ) )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2585:6: ( (lv_name_2_0= ruleEnumerationLiteralName ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2586:1: (lv_name_2_0= ruleEnumerationLiteralName )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2586:1: (lv_name_2_0= ruleEnumerationLiteralName )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2587:3: lv_name_2_0= ruleEnumerationLiteralName
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getEnumerationLiteralCSAccess().getNameEnumerationLiteralNameParserRuleCall_0_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleEnumerationLiteralName_in_ruleEnumerationLiteralCS5640);
                    lv_name_2_0=ruleEnumerationLiteralName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getEnumerationLiteralCSRule());
                      	        }
                             		set(
                             			current, 
                             			"name",
                              		lv_name_2_0, 
                              		"EnumerationLiteralName");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2603:3: (otherlv_3= '=' ( (lv_value_4_0= ruleSIGNED ) ) )?
            int alt69=2;
            int LA69_0 = input.LA(1);

            if ( (LA69_0==66) ) {
                alt69=1;
            }
            switch (alt69) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2603:5: otherlv_3= '=' ( (lv_value_4_0= ruleSIGNED ) )
                    {
                    otherlv_3=(Token)match(input,66,FollowSets000.FOLLOW_66_in_ruleEnumerationLiteralCS5654); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_3, grammarAccess.getEnumerationLiteralCSAccess().getEqualsSignKeyword_1_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2607:1: ( (lv_value_4_0= ruleSIGNED ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2608:1: (lv_value_4_0= ruleSIGNED )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2608:1: (lv_value_4_0= ruleSIGNED )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2609:3: lv_value_4_0= ruleSIGNED
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getEnumerationLiteralCSAccess().getValueSIGNEDParserRuleCall_1_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleSIGNED_in_ruleEnumerationLiteralCS5675);
                    lv_value_4_0=ruleSIGNED();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getEnumerationLiteralCSRule());
                      	        }
                             		set(
                             			current, 
                             			"value",
                              		lv_value_4_0, 
                              		"SIGNED");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2625:4: ( (otherlv_5= '{' ( (lv_ownedAnnotation_6_0= ruleAnnotationElementCS ) )* otherlv_7= '}' ) | otherlv_8= ';' )
            int alt71=2;
            int LA71_0 = input.LA(1);

            if ( (LA71_0==64) ) {
                alt71=1;
            }
            else if ( (LA71_0==62) ) {
                alt71=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 71, 0, input);

                throw nvae;
            }
            switch (alt71) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2625:5: (otherlv_5= '{' ( (lv_ownedAnnotation_6_0= ruleAnnotationElementCS ) )* otherlv_7= '}' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2625:5: (otherlv_5= '{' ( (lv_ownedAnnotation_6_0= ruleAnnotationElementCS ) )* otherlv_7= '}' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2625:7: otherlv_5= '{' ( (lv_ownedAnnotation_6_0= ruleAnnotationElementCS ) )* otherlv_7= '}'
                    {
                    otherlv_5=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleEnumerationLiteralCS5691); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_5, grammarAccess.getEnumerationLiteralCSAccess().getLeftCurlyBracketKeyword_2_0_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2629:1: ( (lv_ownedAnnotation_6_0= ruleAnnotationElementCS ) )*
                    loop70:
                    do {
                        int alt70=2;
                        int LA70_0 = input.LA(1);

                        if ( ((LA70_0>=53 && LA70_0<=54)||LA70_0==58) ) {
                            alt70=1;
                        }


                        switch (alt70) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2630:1: (lv_ownedAnnotation_6_0= ruleAnnotationElementCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2630:1: (lv_ownedAnnotation_6_0= ruleAnnotationElementCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2631:3: lv_ownedAnnotation_6_0= ruleAnnotationElementCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getEnumerationLiteralCSAccess().getOwnedAnnotationAnnotationElementCSParserRuleCall_2_0_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleAnnotationElementCS_in_ruleEnumerationLiteralCS5712);
                    	    lv_ownedAnnotation_6_0=ruleAnnotationElementCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getEnumerationLiteralCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedAnnotation",
                    	              		lv_ownedAnnotation_6_0, 
                    	              		"AnnotationElementCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop70;
                        }
                    } while (true);

                    otherlv_7=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleEnumerationLiteralCS5725); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_7, grammarAccess.getEnumerationLiteralCSAccess().getRightCurlyBracketKeyword_2_0_2());
                          
                    }

                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2652:7: otherlv_8= ';'
                    {
                    otherlv_8=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleEnumerationLiteralCS5744); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_8, grammarAccess.getEnumerationLiteralCSAccess().getSemicolonKeyword_2_1());
                          
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleEnumerationLiteralCS"


    // $ANTLR start "entryRuleImportCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2664:1: entryRuleImportCS returns [EObject current=null] : iv_ruleImportCS= ruleImportCS EOF ;
    public final EObject entryRuleImportCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleImportCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2665:2: (iv_ruleImportCS= ruleImportCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2666:2: iv_ruleImportCS= ruleImportCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getImportCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleImportCS_in_entryRuleImportCS5781);
            iv_ruleImportCS=ruleImportCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleImportCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleImportCS5791); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleImportCS"


    // $ANTLR start "ruleImportCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2673:1: ruleImportCS returns [EObject current=null] : (otherlv_0= 'import' ( ( (lv_name_1_0= ruleUnrestrictedName ) ) otherlv_2= ':' )? ( (lv_pathName_3_0= ruleURIPathNameCS ) ) ( ( (lv_all_4_0= '::' ) ) otherlv_5= '*' )? otherlv_6= ';' ) ;
    public final EObject ruleImportCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_2=null;
        Token lv_all_4_0=null;
        Token otherlv_5=null;
        Token otherlv_6=null;
        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject lv_pathName_3_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2676:28: ( (otherlv_0= 'import' ( ( (lv_name_1_0= ruleUnrestrictedName ) ) otherlv_2= ':' )? ( (lv_pathName_3_0= ruleURIPathNameCS ) ) ( ( (lv_all_4_0= '::' ) ) otherlv_5= '*' )? otherlv_6= ';' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2677:1: (otherlv_0= 'import' ( ( (lv_name_1_0= ruleUnrestrictedName ) ) otherlv_2= ':' )? ( (lv_pathName_3_0= ruleURIPathNameCS ) ) ( ( (lv_all_4_0= '::' ) ) otherlv_5= '*' )? otherlv_6= ';' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2677:1: (otherlv_0= 'import' ( ( (lv_name_1_0= ruleUnrestrictedName ) ) otherlv_2= ':' )? ( (lv_pathName_3_0= ruleURIPathNameCS ) ) ( ( (lv_all_4_0= '::' ) ) otherlv_5= '*' )? otherlv_6= ';' )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2677:3: otherlv_0= 'import' ( ( (lv_name_1_0= ruleUnrestrictedName ) ) otherlv_2= ':' )? ( (lv_pathName_3_0= ruleURIPathNameCS ) ) ( ( (lv_all_4_0= '::' ) ) otherlv_5= '*' )? otherlv_6= ';'
            {
            otherlv_0=(Token)match(input,32,FollowSets000.FOLLOW_32_in_ruleImportCS5828); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_0, grammarAccess.getImportCSAccess().getImportKeyword_0());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2681:1: ( ( (lv_name_1_0= ruleUnrestrictedName ) ) otherlv_2= ':' )?
            int alt72=2;
            alt72 = dfa72.predict(input);
            switch (alt72) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2681:2: ( (lv_name_1_0= ruleUnrestrictedName ) ) otherlv_2= ':'
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2681:2: ( (lv_name_1_0= ruleUnrestrictedName ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2682:1: (lv_name_1_0= ruleUnrestrictedName )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2682:1: (lv_name_1_0= ruleUnrestrictedName )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2683:3: lv_name_1_0= ruleUnrestrictedName
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getImportCSAccess().getNameUnrestrictedNameParserRuleCall_1_0_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleImportCS5850);
                    lv_name_1_0=ruleUnrestrictedName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getImportCSRule());
                      	        }
                             		set(
                             			current, 
                             			"name",
                              		lv_name_1_0, 
                              		"UnrestrictedName");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }

                    otherlv_2=(Token)match(input,61,FollowSets000.FOLLOW_61_in_ruleImportCS5862); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_2, grammarAccess.getImportCSAccess().getColonKeyword_1_1());
                          
                    }

                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2703:3: ( (lv_pathName_3_0= ruleURIPathNameCS ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2704:1: (lv_pathName_3_0= ruleURIPathNameCS )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2704:1: (lv_pathName_3_0= ruleURIPathNameCS )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2705:3: lv_pathName_3_0= ruleURIPathNameCS
            {
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getImportCSAccess().getPathNameURIPathNameCSParserRuleCall_2_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_ruleURIPathNameCS_in_ruleImportCS5885);
            lv_pathName_3_0=ruleURIPathNameCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElementForParent(grammarAccess.getImportCSRule());
              	        }
                     		set(
                     			current, 
                     			"pathName",
                      		lv_pathName_3_0, 
                      		"URIPathNameCS");
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2721:2: ( ( (lv_all_4_0= '::' ) ) otherlv_5= '*' )?
            int alt73=2;
            int LA73_0 = input.LA(1);

            if ( (LA73_0==76) ) {
                alt73=1;
            }
            switch (alt73) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2721:3: ( (lv_all_4_0= '::' ) ) otherlv_5= '*'
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2721:3: ( (lv_all_4_0= '::' ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2722:1: (lv_all_4_0= '::' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2722:1: (lv_all_4_0= '::' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2723:3: lv_all_4_0= '::'
                    {
                    lv_all_4_0=(Token)match(input,76,FollowSets000.FOLLOW_76_in_ruleImportCS5904); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_all_4_0, grammarAccess.getImportCSAccess().getAllColonColonKeyword_3_0_0());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getImportCSRule());
                      	        }
                             		setWithLastConsumed(current, "all", true, "::");
                      	    
                    }

                    }


                    }

                    otherlv_5=(Token)match(input,77,FollowSets000.FOLLOW_77_in_ruleImportCS5929); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_5, grammarAccess.getImportCSAccess().getAsteriskKeyword_3_1());
                          
                    }

                    }
                    break;

            }

            otherlv_6=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleImportCS5943); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_6, grammarAccess.getImportCSAccess().getSemicolonKeyword_4());
                  
            }

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleImportCS"


    // $ANTLR start "entryRuleLibraryCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2752:1: entryRuleLibraryCS returns [EObject current=null] : iv_ruleLibraryCS= ruleLibraryCS EOF ;
    public final EObject entryRuleLibraryCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleLibraryCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2753:2: (iv_ruleLibraryCS= ruleLibraryCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2754:2: iv_ruleLibraryCS= ruleLibraryCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getLibraryCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleLibraryCS_in_entryRuleLibraryCS5979);
            iv_ruleLibraryCS=ruleLibraryCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleLibraryCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleLibraryCS5989); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleLibraryCS"


    // $ANTLR start "ruleLibraryCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2761:1: ruleLibraryCS returns [EObject current=null] : (otherlv_0= 'library' ( ( (lv_name_1_0= ruleUnrestrictedName ) ) otherlv_2= ':' )? ( ( ruleURI ) ) otherlv_4= ';' ) ;
    public final EObject ruleLibraryCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        AntlrDatatypeRuleToken lv_name_1_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2764:28: ( (otherlv_0= 'library' ( ( (lv_name_1_0= ruleUnrestrictedName ) ) otherlv_2= ':' )? ( ( ruleURI ) ) otherlv_4= ';' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2765:1: (otherlv_0= 'library' ( ( (lv_name_1_0= ruleUnrestrictedName ) ) otherlv_2= ':' )? ( ( ruleURI ) ) otherlv_4= ';' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2765:1: (otherlv_0= 'library' ( ( (lv_name_1_0= ruleUnrestrictedName ) ) otherlv_2= ':' )? ( ( ruleURI ) ) otherlv_4= ';' )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2765:3: otherlv_0= 'library' ( ( (lv_name_1_0= ruleUnrestrictedName ) ) otherlv_2= ':' )? ( ( ruleURI ) ) otherlv_4= ';'
            {
            otherlv_0=(Token)match(input,36,FollowSets000.FOLLOW_36_in_ruleLibraryCS6026); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_0, grammarAccess.getLibraryCSAccess().getLibraryKeyword_0());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2769:1: ( ( (lv_name_1_0= ruleUnrestrictedName ) ) otherlv_2= ':' )?
            int alt74=2;
            int LA74_0 = input.LA(1);

            if ( ((LA74_0>=RULE_SIMPLE_ID && LA74_0<=RULE_ESCAPED_ID)||LA74_0==17||(LA74_0>=19 && LA74_0<=58)) ) {
                alt74=1;
            }
            switch (alt74) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2769:2: ( (lv_name_1_0= ruleUnrestrictedName ) ) otherlv_2= ':'
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2769:2: ( (lv_name_1_0= ruleUnrestrictedName ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2770:1: (lv_name_1_0= ruleUnrestrictedName )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2770:1: (lv_name_1_0= ruleUnrestrictedName )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2771:3: lv_name_1_0= ruleUnrestrictedName
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getLibraryCSAccess().getNameUnrestrictedNameParserRuleCall_1_0_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleLibraryCS6048);
                    lv_name_1_0=ruleUnrestrictedName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getLibraryCSRule());
                      	        }
                             		set(
                             			current, 
                             			"name",
                              		lv_name_1_0, 
                              		"UnrestrictedName");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }

                    otherlv_2=(Token)match(input,61,FollowSets000.FOLLOW_61_in_ruleLibraryCS6060); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_2, grammarAccess.getLibraryCSAccess().getColonKeyword_1_1());
                          
                    }

                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2791:3: ( ( ruleURI ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2792:1: ( ruleURI )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2792:1: ( ruleURI )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2793:3: ruleURI
            {
            if ( state.backtracking==0 ) {
               
              		  /* */ 
              		
            }
            if ( state.backtracking==0 ) {

              			if (current==null) {
              	            current = createModelElement(grammarAccess.getLibraryCSRule());
              	        }
                      
            }
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getLibraryCSAccess().getPackagePackageCrossReference_2_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_ruleURI_in_ruleLibraryCS6089);
            ruleURI();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }

            otherlv_4=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleLibraryCS6101); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_4, grammarAccess.getLibraryCSAccess().getSemicolonKeyword_3());
                  
            }

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleLibraryCS"


    // $ANTLR start "entryRuleModelElementCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2821:1: entryRuleModelElementCS returns [EObject current=null] : iv_ruleModelElementCS= ruleModelElementCS EOF ;
    public final EObject entryRuleModelElementCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleModelElementCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2822:2: (iv_ruleModelElementCS= ruleModelElementCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2823:2: iv_ruleModelElementCS= ruleModelElementCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getModelElementCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleModelElementCS_in_entryRuleModelElementCS6137);
            iv_ruleModelElementCS=ruleModelElementCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleModelElementCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleModelElementCS6147); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleModelElementCS"


    // $ANTLR start "ruleModelElementCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2830:1: ruleModelElementCS returns [EObject current=null] : (this_ClassifierCS_0= ruleClassifierCS | this_EnumerationLiteralCS_1= ruleEnumerationLiteralCS | this_OperationCS_2= ruleOperationCS | this_PackageCS_3= rulePackageCS | this_StructuralFeatureCS_4= ruleStructuralFeatureCS ) ;
    public final EObject ruleModelElementCS() throws RecognitionException {
        EObject current = null;

        EObject this_ClassifierCS_0 = null;

        EObject this_EnumerationLiteralCS_1 = null;

        EObject this_OperationCS_2 = null;

        EObject this_PackageCS_3 = null;

        EObject this_StructuralFeatureCS_4 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2833:28: ( (this_ClassifierCS_0= ruleClassifierCS | this_EnumerationLiteralCS_1= ruleEnumerationLiteralCS | this_OperationCS_2= ruleOperationCS | this_PackageCS_3= rulePackageCS | this_StructuralFeatureCS_4= ruleStructuralFeatureCS ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2834:1: (this_ClassifierCS_0= ruleClassifierCS | this_EnumerationLiteralCS_1= ruleEnumerationLiteralCS | this_OperationCS_2= ruleOperationCS | this_PackageCS_3= rulePackageCS | this_StructuralFeatureCS_4= ruleStructuralFeatureCS )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2834:1: (this_ClassifierCS_0= ruleClassifierCS | this_EnumerationLiteralCS_1= ruleEnumerationLiteralCS | this_OperationCS_2= ruleOperationCS | this_PackageCS_3= rulePackageCS | this_StructuralFeatureCS_4= ruleStructuralFeatureCS )
            int alt75=5;
            alt75 = dfa75.predict(input);
            switch (alt75) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2835:2: this_ClassifierCS_0= ruleClassifierCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getModelElementCSAccess().getClassifierCSParserRuleCall_0()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleClassifierCS_in_ruleModelElementCS6197);
                    this_ClassifierCS_0=ruleClassifierCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_ClassifierCS_0; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2848:2: this_EnumerationLiteralCS_1= ruleEnumerationLiteralCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getModelElementCSAccess().getEnumerationLiteralCSParserRuleCall_1()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleEnumerationLiteralCS_in_ruleModelElementCS6227);
                    this_EnumerationLiteralCS_1=ruleEnumerationLiteralCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_EnumerationLiteralCS_1; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 3 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2861:2: this_OperationCS_2= ruleOperationCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getModelElementCSAccess().getOperationCSParserRuleCall_2()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleOperationCS_in_ruleModelElementCS6257);
                    this_OperationCS_2=ruleOperationCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_OperationCS_2; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 4 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2874:2: this_PackageCS_3= rulePackageCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getModelElementCSAccess().getPackageCSParserRuleCall_3()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_rulePackageCS_in_ruleModelElementCS6287);
                    this_PackageCS_3=rulePackageCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_PackageCS_3; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 5 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2887:2: this_StructuralFeatureCS_4= ruleStructuralFeatureCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getModelElementCSAccess().getStructuralFeatureCSParserRuleCall_4()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleStructuralFeatureCS_in_ruleModelElementCS6317);
                    this_StructuralFeatureCS_4=ruleStructuralFeatureCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_StructuralFeatureCS_4; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleModelElementCS"


    // $ANTLR start "entryRuleModelElementRefCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2906:1: entryRuleModelElementRefCS returns [EObject current=null] : iv_ruleModelElementRefCS= ruleModelElementRefCS EOF ;
    public final EObject entryRuleModelElementRefCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleModelElementRefCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2907:2: (iv_ruleModelElementRefCS= ruleModelElementRefCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2908:2: iv_ruleModelElementRefCS= ruleModelElementRefCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getModelElementRefCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleModelElementRefCS_in_entryRuleModelElementRefCS6352);
            iv_ruleModelElementRefCS=ruleModelElementRefCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleModelElementRefCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleModelElementRefCS6362); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleModelElementRefCS"


    // $ANTLR start "ruleModelElementRefCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2915:1: ruleModelElementRefCS returns [EObject current=null] : (otherlv_0= 'reference' ( (lv_pathName_1_0= rulePathNameCS ) ) otherlv_2= ';' ) ;
    public final EObject ruleModelElementRefCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_2=null;
        EObject lv_pathName_1_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2918:28: ( (otherlv_0= 'reference' ( (lv_pathName_1_0= rulePathNameCS ) ) otherlv_2= ';' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2919:1: (otherlv_0= 'reference' ( (lv_pathName_1_0= rulePathNameCS ) ) otherlv_2= ';' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2919:1: (otherlv_0= 'reference' ( (lv_pathName_1_0= rulePathNameCS ) ) otherlv_2= ';' )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2919:3: otherlv_0= 'reference' ( (lv_pathName_1_0= rulePathNameCS ) ) otherlv_2= ';'
            {
            otherlv_0=(Token)match(input,44,FollowSets000.FOLLOW_44_in_ruleModelElementRefCS6399); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_0, grammarAccess.getModelElementRefCSAccess().getReferenceKeyword_0());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2923:1: ( (lv_pathName_1_0= rulePathNameCS ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2924:1: (lv_pathName_1_0= rulePathNameCS )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2924:1: (lv_pathName_1_0= rulePathNameCS )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2925:3: lv_pathName_1_0= rulePathNameCS
            {
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getModelElementRefCSAccess().getPathNamePathNameCSParserRuleCall_1_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_rulePathNameCS_in_ruleModelElementRefCS6420);
            lv_pathName_1_0=rulePathNameCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElementForParent(grammarAccess.getModelElementRefCSRule());
              	        }
                     		set(
                     			current, 
                     			"pathName",
                      		lv_pathName_1_0, 
                      		"PathNameCS");
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }

            otherlv_2=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleModelElementRefCS6432); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_2, grammarAccess.getModelElementRefCSAccess().getSemicolonKeyword_2());
                  
            }

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleModelElementRefCS"


    // $ANTLR start "entryRuleOperationCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2953:1: entryRuleOperationCS returns [EObject current=null] : iv_ruleOperationCS= ruleOperationCS EOF ;
    public final EObject entryRuleOperationCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleOperationCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2954:2: (iv_ruleOperationCS= ruleOperationCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2955:2: iv_ruleOperationCS= ruleOperationCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getOperationCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleOperationCS_in_entryRuleOperationCS6468);
            iv_ruleOperationCS=ruleOperationCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleOperationCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleOperationCS6478); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleOperationCS"


    // $ANTLR start "ruleOperationCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2962:1: ruleOperationCS returns [EObject current=null] : ( ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )? otherlv_4= 'operation' ( (lv_ownedTemplateSignature_5_0= ruleTemplateSignatureCS ) )? ( (lv_name_6_0= ruleUnrestrictedName ) ) otherlv_7= '(' ( ( (lv_ownedParameter_8_0= ruleParameterCS ) ) (otherlv_9= ',' ( (lv_ownedParameter_10_0= ruleParameterCS ) ) )* )? otherlv_11= ')' (otherlv_12= ':' ( (lv_ownedType_13_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_14= 'throws' ( (lv_ownedException_15_0= ruleTypedRefCS ) ) (otherlv_16= ',' ( (lv_ownedException_17_0= ruleTypedRefCS ) ) )* )? (otherlv_18= '{' ( ( ( (lv_qualifier_19_0= 'derived' ) ) | ( (lv_qualifier_20_0= '!derived' ) ) | ( (lv_qualifier_21_0= 'ordered' ) ) | ( (lv_qualifier_22_0= '!ordered' ) ) | ( (lv_qualifier_23_0= 'unique' ) ) | ( (lv_qualifier_24_0= '!unique' ) ) ) (otherlv_25= ',' )? )+ otherlv_26= '}' )? ( (otherlv_27= '{' ( ( (lv_ownedAnnotation_28_0= ruleAnnotationElementCS ) ) | ( (lv_ownedPrecondition_29_0= rulePreconditionConstraintCS ) ) | (otherlv_30= 'body' ( ruleUnrestrictedName )? otherlv_32= ':' ( (lv_ownedBodyExpression_33_0= ruleSpecificationCS ) )? otherlv_34= ';' ) | ( (lv_ownedPostcondition_35_0= rulePostconditionConstraintCS ) ) )* otherlv_36= '}' ) | otherlv_37= ';' ) ) ;
    public final EObject ruleOperationCS() throws RecognitionException {
        EObject current = null;

        Token lv_qualifier_0_0=null;
        Token lv_qualifier_1_0=null;
        Token lv_qualifier_2_0=null;
        Token lv_qualifier_3_0=null;
        Token otherlv_4=null;
        Token otherlv_7=null;
        Token otherlv_9=null;
        Token otherlv_11=null;
        Token otherlv_12=null;
        Token otherlv_14=null;
        Token otherlv_16=null;
        Token otherlv_18=null;
        Token lv_qualifier_19_0=null;
        Token lv_qualifier_20_0=null;
        Token lv_qualifier_21_0=null;
        Token lv_qualifier_22_0=null;
        Token lv_qualifier_23_0=null;
        Token lv_qualifier_24_0=null;
        Token otherlv_25=null;
        Token otherlv_26=null;
        Token otherlv_27=null;
        Token otherlv_30=null;
        Token otherlv_32=null;
        Token otherlv_34=null;
        Token otherlv_36=null;
        Token otherlv_37=null;
        EObject lv_ownedTemplateSignature_5_0 = null;

        AntlrDatatypeRuleToken lv_name_6_0 = null;

        EObject lv_ownedParameter_8_0 = null;

        EObject lv_ownedParameter_10_0 = null;

        EObject lv_ownedType_13_0 = null;

        EObject lv_ownedException_15_0 = null;

        EObject lv_ownedException_17_0 = null;

        EObject lv_ownedAnnotation_28_0 = null;

        EObject lv_ownedPrecondition_29_0 = null;

        EObject lv_ownedBodyExpression_33_0 = null;

        EObject lv_ownedPostcondition_35_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2965:28: ( ( ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )? otherlv_4= 'operation' ( (lv_ownedTemplateSignature_5_0= ruleTemplateSignatureCS ) )? ( (lv_name_6_0= ruleUnrestrictedName ) ) otherlv_7= '(' ( ( (lv_ownedParameter_8_0= ruleParameterCS ) ) (otherlv_9= ',' ( (lv_ownedParameter_10_0= ruleParameterCS ) ) )* )? otherlv_11= ')' (otherlv_12= ':' ( (lv_ownedType_13_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_14= 'throws' ( (lv_ownedException_15_0= ruleTypedRefCS ) ) (otherlv_16= ',' ( (lv_ownedException_17_0= ruleTypedRefCS ) ) )* )? (otherlv_18= '{' ( ( ( (lv_qualifier_19_0= 'derived' ) ) | ( (lv_qualifier_20_0= '!derived' ) ) | ( (lv_qualifier_21_0= 'ordered' ) ) | ( (lv_qualifier_22_0= '!ordered' ) ) | ( (lv_qualifier_23_0= 'unique' ) ) | ( (lv_qualifier_24_0= '!unique' ) ) ) (otherlv_25= ',' )? )+ otherlv_26= '}' )? ( (otherlv_27= '{' ( ( (lv_ownedAnnotation_28_0= ruleAnnotationElementCS ) ) | ( (lv_ownedPrecondition_29_0= rulePreconditionConstraintCS ) ) | (otherlv_30= 'body' ( ruleUnrestrictedName )? otherlv_32= ':' ( (lv_ownedBodyExpression_33_0= ruleSpecificationCS ) )? otherlv_34= ';' ) | ( (lv_ownedPostcondition_35_0= rulePostconditionConstraintCS ) ) )* otherlv_36= '}' ) | otherlv_37= ';' ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2966:1: ( ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )? otherlv_4= 'operation' ( (lv_ownedTemplateSignature_5_0= ruleTemplateSignatureCS ) )? ( (lv_name_6_0= ruleUnrestrictedName ) ) otherlv_7= '(' ( ( (lv_ownedParameter_8_0= ruleParameterCS ) ) (otherlv_9= ',' ( (lv_ownedParameter_10_0= ruleParameterCS ) ) )* )? otherlv_11= ')' (otherlv_12= ':' ( (lv_ownedType_13_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_14= 'throws' ( (lv_ownedException_15_0= ruleTypedRefCS ) ) (otherlv_16= ',' ( (lv_ownedException_17_0= ruleTypedRefCS ) ) )* )? (otherlv_18= '{' ( ( ( (lv_qualifier_19_0= 'derived' ) ) | ( (lv_qualifier_20_0= '!derived' ) ) | ( (lv_qualifier_21_0= 'ordered' ) ) | ( (lv_qualifier_22_0= '!ordered' ) ) | ( (lv_qualifier_23_0= 'unique' ) ) | ( (lv_qualifier_24_0= '!unique' ) ) ) (otherlv_25= ',' )? )+ otherlv_26= '}' )? ( (otherlv_27= '{' ( ( (lv_ownedAnnotation_28_0= ruleAnnotationElementCS ) ) | ( (lv_ownedPrecondition_29_0= rulePreconditionConstraintCS ) ) | (otherlv_30= 'body' ( ruleUnrestrictedName )? otherlv_32= ':' ( (lv_ownedBodyExpression_33_0= ruleSpecificationCS ) )? otherlv_34= ';' ) | ( (lv_ownedPostcondition_35_0= rulePostconditionConstraintCS ) ) )* otherlv_36= '}' ) | otherlv_37= ';' ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2966:1: ( ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )? otherlv_4= 'operation' ( (lv_ownedTemplateSignature_5_0= ruleTemplateSignatureCS ) )? ( (lv_name_6_0= ruleUnrestrictedName ) ) otherlv_7= '(' ( ( (lv_ownedParameter_8_0= ruleParameterCS ) ) (otherlv_9= ',' ( (lv_ownedParameter_10_0= ruleParameterCS ) ) )* )? otherlv_11= ')' (otherlv_12= ':' ( (lv_ownedType_13_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_14= 'throws' ( (lv_ownedException_15_0= ruleTypedRefCS ) ) (otherlv_16= ',' ( (lv_ownedException_17_0= ruleTypedRefCS ) ) )* )? (otherlv_18= '{' ( ( ( (lv_qualifier_19_0= 'derived' ) ) | ( (lv_qualifier_20_0= '!derived' ) ) | ( (lv_qualifier_21_0= 'ordered' ) ) | ( (lv_qualifier_22_0= '!ordered' ) ) | ( (lv_qualifier_23_0= 'unique' ) ) | ( (lv_qualifier_24_0= '!unique' ) ) ) (otherlv_25= ',' )? )+ otherlv_26= '}' )? ( (otherlv_27= '{' ( ( (lv_ownedAnnotation_28_0= ruleAnnotationElementCS ) ) | ( (lv_ownedPrecondition_29_0= rulePreconditionConstraintCS ) ) | (otherlv_30= 'body' ( ruleUnrestrictedName )? otherlv_32= ':' ( (lv_ownedBodyExpression_33_0= ruleSpecificationCS ) )? otherlv_34= ';' ) | ( (lv_ownedPostcondition_35_0= rulePostconditionConstraintCS ) ) )* otherlv_36= '}' ) | otherlv_37= ';' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2966:2: ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )? otherlv_4= 'operation' ( (lv_ownedTemplateSignature_5_0= ruleTemplateSignatureCS ) )? ( (lv_name_6_0= ruleUnrestrictedName ) ) otherlv_7= '(' ( ( (lv_ownedParameter_8_0= ruleParameterCS ) ) (otherlv_9= ',' ( (lv_ownedParameter_10_0= ruleParameterCS ) ) )* )? otherlv_11= ')' (otherlv_12= ':' ( (lv_ownedType_13_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_14= 'throws' ( (lv_ownedException_15_0= ruleTypedRefCS ) ) (otherlv_16= ',' ( (lv_ownedException_17_0= ruleTypedRefCS ) ) )* )? (otherlv_18= '{' ( ( ( (lv_qualifier_19_0= 'derived' ) ) | ( (lv_qualifier_20_0= '!derived' ) ) | ( (lv_qualifier_21_0= 'ordered' ) ) | ( (lv_qualifier_22_0= '!ordered' ) ) | ( (lv_qualifier_23_0= 'unique' ) ) | ( (lv_qualifier_24_0= '!unique' ) ) ) (otherlv_25= ',' )? )+ otherlv_26= '}' )? ( (otherlv_27= '{' ( ( (lv_ownedAnnotation_28_0= ruleAnnotationElementCS ) ) | ( (lv_ownedPrecondition_29_0= rulePreconditionConstraintCS ) ) | (otherlv_30= 'body' ( ruleUnrestrictedName )? otherlv_32= ':' ( (lv_ownedBodyExpression_33_0= ruleSpecificationCS ) )? otherlv_34= ';' ) | ( (lv_ownedPostcondition_35_0= rulePostconditionConstraintCS ) ) )* otherlv_36= '}' ) | otherlv_37= ';' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2966:2: ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )?
            int alt78=3;
            int LA78_0 = input.LA(1);

            if ( (LA78_0==46) ) {
                alt78=1;
            }
            else if ( (LA78_0==26) ) {
                alt78=2;
            }
            switch (alt78) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2966:3: ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2966:3: ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2966:4: ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )?
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2966:4: ( (lv_qualifier_0_0= 'static' ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2967:1: (lv_qualifier_0_0= 'static' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2967:1: (lv_qualifier_0_0= 'static' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2968:3: lv_qualifier_0_0= 'static'
                    {
                    lv_qualifier_0_0=(Token)match(input,46,FollowSets000.FOLLOW_46_in_ruleOperationCS6523); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_qualifier_0_0, grammarAccess.getOperationCSAccess().getQualifierStaticKeyword_0_0_0_0());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getOperationCSRule());
                      	        }
                             		addWithLastConsumed(current, "qualifier", lv_qualifier_0_0, "static");
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2981:2: ( (lv_qualifier_1_0= 'definition' ) )?
                    int alt76=2;
                    int LA76_0 = input.LA(1);

                    if ( (LA76_0==26) ) {
                        alt76=1;
                    }
                    switch (alt76) {
                        case 1 :
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2982:1: (lv_qualifier_1_0= 'definition' )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2982:1: (lv_qualifier_1_0= 'definition' )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2983:3: lv_qualifier_1_0= 'definition'
                            {
                            lv_qualifier_1_0=(Token)match(input,26,FollowSets000.FOLLOW_26_in_ruleOperationCS6554); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                                      newLeafNode(lv_qualifier_1_0, grammarAccess.getOperationCSAccess().getQualifierDefinitionKeyword_0_0_1_0());
                                  
                            }
                            if ( state.backtracking==0 ) {

                              	        if (current==null) {
                              	            current = createModelElement(grammarAccess.getOperationCSRule());
                              	        }
                                     		addWithLastConsumed(current, "qualifier", lv_qualifier_1_0, "definition");
                              	    
                            }

                            }


                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2997:6: ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2997:6: ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2997:7: ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )?
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2997:7: ( (lv_qualifier_2_0= 'definition' ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2998:1: (lv_qualifier_2_0= 'definition' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2998:1: (lv_qualifier_2_0= 'definition' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:2999:3: lv_qualifier_2_0= 'definition'
                    {
                    lv_qualifier_2_0=(Token)match(input,26,FollowSets000.FOLLOW_26_in_ruleOperationCS6594); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_qualifier_2_0, grammarAccess.getOperationCSAccess().getQualifierDefinitionKeyword_0_1_0_0());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getOperationCSRule());
                      	        }
                             		addWithLastConsumed(current, "qualifier", lv_qualifier_2_0, "definition");
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3012:2: ( (lv_qualifier_3_0= 'static' ) )?
                    int alt77=2;
                    int LA77_0 = input.LA(1);

                    if ( (LA77_0==46) ) {
                        alt77=1;
                    }
                    switch (alt77) {
                        case 1 :
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3013:1: (lv_qualifier_3_0= 'static' )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3013:1: (lv_qualifier_3_0= 'static' )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3014:3: lv_qualifier_3_0= 'static'
                            {
                            lv_qualifier_3_0=(Token)match(input,46,FollowSets000.FOLLOW_46_in_ruleOperationCS6625); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                                      newLeafNode(lv_qualifier_3_0, grammarAccess.getOperationCSAccess().getQualifierStaticKeyword_0_1_1_0());
                                  
                            }
                            if ( state.backtracking==0 ) {

                              	        if (current==null) {
                              	            current = createModelElement(grammarAccess.getOperationCSRule());
                              	        }
                                     		addWithLastConsumed(current, "qualifier", lv_qualifier_3_0, "static");
                              	    
                            }

                            }


                            }
                            break;

                    }


                    }


                    }
                    break;

            }

            otherlv_4=(Token)match(input,37,FollowSets000.FOLLOW_37_in_ruleOperationCS6654); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_4, grammarAccess.getOperationCSAccess().getOperationKeyword_1());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3031:1: ( (lv_ownedTemplateSignature_5_0= ruleTemplateSignatureCS ) )?
            int alt79=2;
            int LA79_0 = input.LA(1);

            if ( (LA79_0==59||LA79_0==81) ) {
                alt79=1;
            }
            switch (alt79) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3032:1: (lv_ownedTemplateSignature_5_0= ruleTemplateSignatureCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3032:1: (lv_ownedTemplateSignature_5_0= ruleTemplateSignatureCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3033:3: lv_ownedTemplateSignature_5_0= ruleTemplateSignatureCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getOperationCSAccess().getOwnedTemplateSignatureTemplateSignatureCSParserRuleCall_2_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTemplateSignatureCS_in_ruleOperationCS6675);
                    lv_ownedTemplateSignature_5_0=ruleTemplateSignatureCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getOperationCSRule());
                      	        }
                             		set(
                             			current, 
                             			"ownedTemplateSignature",
                              		lv_ownedTemplateSignature_5_0, 
                              		"TemplateSignatureCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3049:3: ( (lv_name_6_0= ruleUnrestrictedName ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3050:1: (lv_name_6_0= ruleUnrestrictedName )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3050:1: (lv_name_6_0= ruleUnrestrictedName )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3051:3: lv_name_6_0= ruleUnrestrictedName
            {
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getOperationCSAccess().getNameUnrestrictedNameParserRuleCall_3_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleOperationCS6697);
            lv_name_6_0=ruleUnrestrictedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElementForParent(grammarAccess.getOperationCSRule());
              	        }
                     		set(
                     			current, 
                     			"name",
                      		lv_name_6_0, 
                      		"UnrestrictedName");
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }

            otherlv_7=(Token)match(input,59,FollowSets000.FOLLOW_59_in_ruleOperationCS6709); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_7, grammarAccess.getOperationCSAccess().getLeftParenthesisKeyword_4());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3071:1: ( ( (lv_ownedParameter_8_0= ruleParameterCS ) ) (otherlv_9= ',' ( (lv_ownedParameter_10_0= ruleParameterCS ) ) )* )?
            int alt81=2;
            int LA81_0 = input.LA(1);

            if ( ((LA81_0>=RULE_SIMPLE_ID && LA81_0<=RULE_ESCAPED_ID)||LA81_0==17||(LA81_0>=19 && LA81_0<=58)) ) {
                alt81=1;
            }
            switch (alt81) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3071:2: ( (lv_ownedParameter_8_0= ruleParameterCS ) ) (otherlv_9= ',' ( (lv_ownedParameter_10_0= ruleParameterCS ) ) )*
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3071:2: ( (lv_ownedParameter_8_0= ruleParameterCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3072:1: (lv_ownedParameter_8_0= ruleParameterCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3072:1: (lv_ownedParameter_8_0= ruleParameterCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3073:3: lv_ownedParameter_8_0= ruleParameterCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getOperationCSAccess().getOwnedParameterParameterCSParserRuleCall_5_0_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleParameterCS_in_ruleOperationCS6731);
                    lv_ownedParameter_8_0=ruleParameterCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getOperationCSRule());
                      	        }
                             		add(
                             			current, 
                             			"ownedParameter",
                              		lv_ownedParameter_8_0, 
                              		"ParameterCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3089:2: (otherlv_9= ',' ( (lv_ownedParameter_10_0= ruleParameterCS ) ) )*
                    loop80:
                    do {
                        int alt80=2;
                        int LA80_0 = input.LA(1);

                        if ( (LA80_0==63) ) {
                            alt80=1;
                        }


                        switch (alt80) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3089:4: otherlv_9= ',' ( (lv_ownedParameter_10_0= ruleParameterCS ) )
                    	    {
                    	    otherlv_9=(Token)match(input,63,FollowSets000.FOLLOW_63_in_ruleOperationCS6744); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_9, grammarAccess.getOperationCSAccess().getCommaKeyword_5_1_0());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3093:1: ( (lv_ownedParameter_10_0= ruleParameterCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3094:1: (lv_ownedParameter_10_0= ruleParameterCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3094:1: (lv_ownedParameter_10_0= ruleParameterCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3095:3: lv_ownedParameter_10_0= ruleParameterCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getOperationCSAccess().getOwnedParameterParameterCSParserRuleCall_5_1_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleParameterCS_in_ruleOperationCS6765);
                    	    lv_ownedParameter_10_0=ruleParameterCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getOperationCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedParameter",
                    	              		lv_ownedParameter_10_0, 
                    	              		"ParameterCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop80;
                        }
                    } while (true);


                    }
                    break;

            }

            otherlv_11=(Token)match(input,60,FollowSets000.FOLLOW_60_in_ruleOperationCS6781); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_11, grammarAccess.getOperationCSAccess().getRightParenthesisKeyword_6());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3115:1: (otherlv_12= ':' ( (lv_ownedType_13_0= ruleTypedMultiplicityRefCS ) ) )?
            int alt82=2;
            int LA82_0 = input.LA(1);

            if ( (LA82_0==61) ) {
                alt82=1;
            }
            switch (alt82) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3115:3: otherlv_12= ':' ( (lv_ownedType_13_0= ruleTypedMultiplicityRefCS ) )
                    {
                    otherlv_12=(Token)match(input,61,FollowSets000.FOLLOW_61_in_ruleOperationCS6794); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_12, grammarAccess.getOperationCSAccess().getColonKeyword_7_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3119:1: ( (lv_ownedType_13_0= ruleTypedMultiplicityRefCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3120:1: (lv_ownedType_13_0= ruleTypedMultiplicityRefCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3120:1: (lv_ownedType_13_0= ruleTypedMultiplicityRefCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3121:3: lv_ownedType_13_0= ruleTypedMultiplicityRefCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getOperationCSAccess().getOwnedTypeTypedMultiplicityRefCSParserRuleCall_7_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTypedMultiplicityRefCS_in_ruleOperationCS6815);
                    lv_ownedType_13_0=ruleTypedMultiplicityRefCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getOperationCSRule());
                      	        }
                             		set(
                             			current, 
                             			"ownedType",
                              		lv_ownedType_13_0, 
                              		"TypedMultiplicityRefCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3137:4: (otherlv_14= 'throws' ( (lv_ownedException_15_0= ruleTypedRefCS ) ) (otherlv_16= ',' ( (lv_ownedException_17_0= ruleTypedRefCS ) ) )* )?
            int alt84=2;
            int LA84_0 = input.LA(1);

            if ( (LA84_0==48) ) {
                alt84=1;
            }
            switch (alt84) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3137:6: otherlv_14= 'throws' ( (lv_ownedException_15_0= ruleTypedRefCS ) ) (otherlv_16= ',' ( (lv_ownedException_17_0= ruleTypedRefCS ) ) )*
                    {
                    otherlv_14=(Token)match(input,48,FollowSets000.FOLLOW_48_in_ruleOperationCS6830); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_14, grammarAccess.getOperationCSAccess().getThrowsKeyword_8_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3141:1: ( (lv_ownedException_15_0= ruleTypedRefCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3142:1: (lv_ownedException_15_0= ruleTypedRefCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3142:1: (lv_ownedException_15_0= ruleTypedRefCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3143:3: lv_ownedException_15_0= ruleTypedRefCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getOperationCSAccess().getOwnedExceptionTypedRefCSParserRuleCall_8_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTypedRefCS_in_ruleOperationCS6851);
                    lv_ownedException_15_0=ruleTypedRefCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getOperationCSRule());
                      	        }
                             		add(
                             			current, 
                             			"ownedException",
                              		lv_ownedException_15_0, 
                              		"TypedRefCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3159:2: (otherlv_16= ',' ( (lv_ownedException_17_0= ruleTypedRefCS ) ) )*
                    loop83:
                    do {
                        int alt83=2;
                        int LA83_0 = input.LA(1);

                        if ( (LA83_0==63) ) {
                            alt83=1;
                        }


                        switch (alt83) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3159:4: otherlv_16= ',' ( (lv_ownedException_17_0= ruleTypedRefCS ) )
                    	    {
                    	    otherlv_16=(Token)match(input,63,FollowSets000.FOLLOW_63_in_ruleOperationCS6864); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_16, grammarAccess.getOperationCSAccess().getCommaKeyword_8_2_0());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3163:1: ( (lv_ownedException_17_0= ruleTypedRefCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3164:1: (lv_ownedException_17_0= ruleTypedRefCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3164:1: (lv_ownedException_17_0= ruleTypedRefCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3165:3: lv_ownedException_17_0= ruleTypedRefCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getOperationCSAccess().getOwnedExceptionTypedRefCSParserRuleCall_8_2_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleTypedRefCS_in_ruleOperationCS6885);
                    	    lv_ownedException_17_0=ruleTypedRefCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getOperationCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedException",
                    	              		lv_ownedException_17_0, 
                    	              		"TypedRefCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop83;
                        }
                    } while (true);


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3181:6: (otherlv_18= '{' ( ( ( (lv_qualifier_19_0= 'derived' ) ) | ( (lv_qualifier_20_0= '!derived' ) ) | ( (lv_qualifier_21_0= 'ordered' ) ) | ( (lv_qualifier_22_0= '!ordered' ) ) | ( (lv_qualifier_23_0= 'unique' ) ) | ( (lv_qualifier_24_0= '!unique' ) ) ) (otherlv_25= ',' )? )+ otherlv_26= '}' )?
            int alt88=2;
            int LA88_0 = input.LA(1);

            if ( (LA88_0==64) ) {
                int LA88_1 = input.LA(2);

                if ( (LA88_1==28||LA88_1==38||LA88_1==50||LA88_1==67||LA88_1==69||LA88_1==72) ) {
                    alt88=1;
                }
            }
            switch (alt88) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3181:8: otherlv_18= '{' ( ( ( (lv_qualifier_19_0= 'derived' ) ) | ( (lv_qualifier_20_0= '!derived' ) ) | ( (lv_qualifier_21_0= 'ordered' ) ) | ( (lv_qualifier_22_0= '!ordered' ) ) | ( (lv_qualifier_23_0= 'unique' ) ) | ( (lv_qualifier_24_0= '!unique' ) ) ) (otherlv_25= ',' )? )+ otherlv_26= '}'
                    {
                    otherlv_18=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleOperationCS6902); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_18, grammarAccess.getOperationCSAccess().getLeftCurlyBracketKeyword_9_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3185:1: ( ( ( (lv_qualifier_19_0= 'derived' ) ) | ( (lv_qualifier_20_0= '!derived' ) ) | ( (lv_qualifier_21_0= 'ordered' ) ) | ( (lv_qualifier_22_0= '!ordered' ) ) | ( (lv_qualifier_23_0= 'unique' ) ) | ( (lv_qualifier_24_0= '!unique' ) ) ) (otherlv_25= ',' )? )+
                    int cnt87=0;
                    loop87:
                    do {
                        int alt87=2;
                        int LA87_0 = input.LA(1);

                        if ( (LA87_0==28||LA87_0==38||LA87_0==50||LA87_0==67||LA87_0==69||LA87_0==72) ) {
                            alt87=1;
                        }


                        switch (alt87) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3185:2: ( ( (lv_qualifier_19_0= 'derived' ) ) | ( (lv_qualifier_20_0= '!derived' ) ) | ( (lv_qualifier_21_0= 'ordered' ) ) | ( (lv_qualifier_22_0= '!ordered' ) ) | ( (lv_qualifier_23_0= 'unique' ) ) | ( (lv_qualifier_24_0= '!unique' ) ) ) (otherlv_25= ',' )?
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3185:2: ( ( (lv_qualifier_19_0= 'derived' ) ) | ( (lv_qualifier_20_0= '!derived' ) ) | ( (lv_qualifier_21_0= 'ordered' ) ) | ( (lv_qualifier_22_0= '!ordered' ) ) | ( (lv_qualifier_23_0= 'unique' ) ) | ( (lv_qualifier_24_0= '!unique' ) ) )
                    	    int alt85=6;
                    	    switch ( input.LA(1) ) {
                    	    case 28:
                    	        {
                    	        alt85=1;
                    	        }
                    	        break;
                    	    case 67:
                    	        {
                    	        alt85=2;
                    	        }
                    	        break;
                    	    case 38:
                    	        {
                    	        alt85=3;
                    	        }
                    	        break;
                    	    case 69:
                    	        {
                    	        alt85=4;
                    	        }
                    	        break;
                    	    case 50:
                    	        {
                    	        alt85=5;
                    	        }
                    	        break;
                    	    case 72:
                    	        {
                    	        alt85=6;
                    	        }
                    	        break;
                    	    default:
                    	        if (state.backtracking>0) {state.failed=true; return current;}
                    	        NoViableAltException nvae =
                    	            new NoViableAltException("", 85, 0, input);

                    	        throw nvae;
                    	    }

                    	    switch (alt85) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3185:3: ( (lv_qualifier_19_0= 'derived' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3185:3: ( (lv_qualifier_19_0= 'derived' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3186:1: (lv_qualifier_19_0= 'derived' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3186:1: (lv_qualifier_19_0= 'derived' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3187:3: lv_qualifier_19_0= 'derived'
                    	            {
                    	            lv_qualifier_19_0=(Token)match(input,28,FollowSets000.FOLLOW_28_in_ruleOperationCS6922); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_19_0, grammarAccess.getOperationCSAccess().getQualifierDerivedKeyword_9_1_0_0_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getOperationCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_19_0, "derived");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 2 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3201:6: ( (lv_qualifier_20_0= '!derived' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3201:6: ( (lv_qualifier_20_0= '!derived' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3202:1: (lv_qualifier_20_0= '!derived' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3202:1: (lv_qualifier_20_0= '!derived' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3203:3: lv_qualifier_20_0= '!derived'
                    	            {
                    	            lv_qualifier_20_0=(Token)match(input,67,FollowSets000.FOLLOW_67_in_ruleOperationCS6959); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_20_0, grammarAccess.getOperationCSAccess().getQualifierDerivedKeyword_9_1_0_1_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getOperationCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_20_0, "!derived");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 3 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3217:6: ( (lv_qualifier_21_0= 'ordered' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3217:6: ( (lv_qualifier_21_0= 'ordered' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3218:1: (lv_qualifier_21_0= 'ordered' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3218:1: (lv_qualifier_21_0= 'ordered' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3219:3: lv_qualifier_21_0= 'ordered'
                    	            {
                    	            lv_qualifier_21_0=(Token)match(input,38,FollowSets000.FOLLOW_38_in_ruleOperationCS6996); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_21_0, grammarAccess.getOperationCSAccess().getQualifierOrderedKeyword_9_1_0_2_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getOperationCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_21_0, "ordered");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 4 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3233:6: ( (lv_qualifier_22_0= '!ordered' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3233:6: ( (lv_qualifier_22_0= '!ordered' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3234:1: (lv_qualifier_22_0= '!ordered' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3234:1: (lv_qualifier_22_0= '!ordered' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3235:3: lv_qualifier_22_0= '!ordered'
                    	            {
                    	            lv_qualifier_22_0=(Token)match(input,69,FollowSets000.FOLLOW_69_in_ruleOperationCS7033); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_22_0, grammarAccess.getOperationCSAccess().getQualifierOrderedKeyword_9_1_0_3_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getOperationCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_22_0, "!ordered");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 5 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3249:6: ( (lv_qualifier_23_0= 'unique' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3249:6: ( (lv_qualifier_23_0= 'unique' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3250:1: (lv_qualifier_23_0= 'unique' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3250:1: (lv_qualifier_23_0= 'unique' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3251:3: lv_qualifier_23_0= 'unique'
                    	            {
                    	            lv_qualifier_23_0=(Token)match(input,50,FollowSets000.FOLLOW_50_in_ruleOperationCS7070); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_23_0, grammarAccess.getOperationCSAccess().getQualifierUniqueKeyword_9_1_0_4_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getOperationCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_23_0, "unique");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 6 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3265:6: ( (lv_qualifier_24_0= '!unique' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3265:6: ( (lv_qualifier_24_0= '!unique' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3266:1: (lv_qualifier_24_0= '!unique' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3266:1: (lv_qualifier_24_0= '!unique' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3267:3: lv_qualifier_24_0= '!unique'
                    	            {
                    	            lv_qualifier_24_0=(Token)match(input,72,FollowSets000.FOLLOW_72_in_ruleOperationCS7107); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_24_0, grammarAccess.getOperationCSAccess().getQualifierUniqueKeyword_9_1_0_5_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getOperationCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_24_0, "!unique");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;

                    	    }

                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3280:3: (otherlv_25= ',' )?
                    	    int alt86=2;
                    	    int LA86_0 = input.LA(1);

                    	    if ( (LA86_0==63) ) {
                    	        alt86=1;
                    	    }
                    	    switch (alt86) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3280:5: otherlv_25= ','
                    	            {
                    	            otherlv_25=(Token)match(input,63,FollowSets000.FOLLOW_63_in_ruleOperationCS7134); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                  	newLeafNode(otherlv_25, grammarAccess.getOperationCSAccess().getCommaKeyword_9_1_1());
                    	                  
                    	            }

                    	            }
                    	            break;

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    if ( cnt87 >= 1 ) break loop87;
                    	    if (state.backtracking>0) {state.failed=true; return current;}
                                EarlyExitException eee =
                                    new EarlyExitException(87, input);
                                throw eee;
                        }
                        cnt87++;
                    } while (true);

                    otherlv_26=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleOperationCS7150); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_26, grammarAccess.getOperationCSAccess().getRightCurlyBracketKeyword_9_2());
                          
                    }

                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3288:3: ( (otherlv_27= '{' ( ( (lv_ownedAnnotation_28_0= ruleAnnotationElementCS ) ) | ( (lv_ownedPrecondition_29_0= rulePreconditionConstraintCS ) ) | (otherlv_30= 'body' ( ruleUnrestrictedName )? otherlv_32= ':' ( (lv_ownedBodyExpression_33_0= ruleSpecificationCS ) )? otherlv_34= ';' ) | ( (lv_ownedPostcondition_35_0= rulePostconditionConstraintCS ) ) )* otherlv_36= '}' ) | otherlv_37= ';' )
            int alt92=2;
            int LA92_0 = input.LA(1);

            if ( (LA92_0==64) ) {
                alt92=1;
            }
            else if ( (LA92_0==62) ) {
                alt92=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 92, 0, input);

                throw nvae;
            }
            switch (alt92) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3288:4: (otherlv_27= '{' ( ( (lv_ownedAnnotation_28_0= ruleAnnotationElementCS ) ) | ( (lv_ownedPrecondition_29_0= rulePreconditionConstraintCS ) ) | (otherlv_30= 'body' ( ruleUnrestrictedName )? otherlv_32= ':' ( (lv_ownedBodyExpression_33_0= ruleSpecificationCS ) )? otherlv_34= ';' ) | ( (lv_ownedPostcondition_35_0= rulePostconditionConstraintCS ) ) )* otherlv_36= '}' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3288:4: (otherlv_27= '{' ( ( (lv_ownedAnnotation_28_0= ruleAnnotationElementCS ) ) | ( (lv_ownedPrecondition_29_0= rulePreconditionConstraintCS ) ) | (otherlv_30= 'body' ( ruleUnrestrictedName )? otherlv_32= ':' ( (lv_ownedBodyExpression_33_0= ruleSpecificationCS ) )? otherlv_34= ';' ) | ( (lv_ownedPostcondition_35_0= rulePostconditionConstraintCS ) ) )* otherlv_36= '}' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3288:6: otherlv_27= '{' ( ( (lv_ownedAnnotation_28_0= ruleAnnotationElementCS ) ) | ( (lv_ownedPrecondition_29_0= rulePreconditionConstraintCS ) ) | (otherlv_30= 'body' ( ruleUnrestrictedName )? otherlv_32= ':' ( (lv_ownedBodyExpression_33_0= ruleSpecificationCS ) )? otherlv_34= ';' ) | ( (lv_ownedPostcondition_35_0= rulePostconditionConstraintCS ) ) )* otherlv_36= '}'
                    {
                    otherlv_27=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleOperationCS7166); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_27, grammarAccess.getOperationCSAccess().getLeftCurlyBracketKeyword_10_0_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3292:1: ( ( (lv_ownedAnnotation_28_0= ruleAnnotationElementCS ) ) | ( (lv_ownedPrecondition_29_0= rulePreconditionConstraintCS ) ) | (otherlv_30= 'body' ( ruleUnrestrictedName )? otherlv_32= ':' ( (lv_ownedBodyExpression_33_0= ruleSpecificationCS ) )? otherlv_34= ';' ) | ( (lv_ownedPostcondition_35_0= rulePostconditionConstraintCS ) ) )*
                    loop91:
                    do {
                        int alt91=5;
                        switch ( input.LA(1) ) {
                        case 53:
                        case 54:
                        case 58:
                            {
                            alt91=1;
                            }
                            break;
                        case 41:
                            {
                            alt91=2;
                            }
                            break;
                        case 21:
                            {
                            alt91=3;
                            }
                            break;
                        case 40:
                            {
                            alt91=4;
                            }
                            break;

                        }

                        switch (alt91) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3292:2: ( (lv_ownedAnnotation_28_0= ruleAnnotationElementCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3292:2: ( (lv_ownedAnnotation_28_0= ruleAnnotationElementCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3293:1: (lv_ownedAnnotation_28_0= ruleAnnotationElementCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3293:1: (lv_ownedAnnotation_28_0= ruleAnnotationElementCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3294:3: lv_ownedAnnotation_28_0= ruleAnnotationElementCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getOperationCSAccess().getOwnedAnnotationAnnotationElementCSParserRuleCall_10_0_1_0_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleAnnotationElementCS_in_ruleOperationCS7188);
                    	    lv_ownedAnnotation_28_0=ruleAnnotationElementCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getOperationCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedAnnotation",
                    	              		lv_ownedAnnotation_28_0, 
                    	              		"AnnotationElementCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 2 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3311:6: ( (lv_ownedPrecondition_29_0= rulePreconditionConstraintCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3311:6: ( (lv_ownedPrecondition_29_0= rulePreconditionConstraintCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3312:1: (lv_ownedPrecondition_29_0= rulePreconditionConstraintCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3312:1: (lv_ownedPrecondition_29_0= rulePreconditionConstraintCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3313:3: lv_ownedPrecondition_29_0= rulePreconditionConstraintCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getOperationCSAccess().getOwnedPreconditionPreconditionConstraintCSParserRuleCall_10_0_1_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_rulePreconditionConstraintCS_in_ruleOperationCS7215);
                    	    lv_ownedPrecondition_29_0=rulePreconditionConstraintCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getOperationCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedPrecondition",
                    	              		lv_ownedPrecondition_29_0, 
                    	              		"PreconditionConstraintCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 3 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3330:6: (otherlv_30= 'body' ( ruleUnrestrictedName )? otherlv_32= ':' ( (lv_ownedBodyExpression_33_0= ruleSpecificationCS ) )? otherlv_34= ';' )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3330:6: (otherlv_30= 'body' ( ruleUnrestrictedName )? otherlv_32= ':' ( (lv_ownedBodyExpression_33_0= ruleSpecificationCS ) )? otherlv_34= ';' )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3330:8: otherlv_30= 'body' ( ruleUnrestrictedName )? otherlv_32= ':' ( (lv_ownedBodyExpression_33_0= ruleSpecificationCS ) )? otherlv_34= ';'
                    	    {
                    	    otherlv_30=(Token)match(input,21,FollowSets000.FOLLOW_21_in_ruleOperationCS7234); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_30, grammarAccess.getOperationCSAccess().getBodyKeyword_10_0_1_2_0());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3334:1: ( ruleUnrestrictedName )?
                    	    int alt89=2;
                    	    int LA89_0 = input.LA(1);

                    	    if ( ((LA89_0>=RULE_SIMPLE_ID && LA89_0<=RULE_ESCAPED_ID)||LA89_0==17||(LA89_0>=19 && LA89_0<=58)) ) {
                    	        alt89=1;
                    	    }
                    	    switch (alt89) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3335:2: ruleUnrestrictedName
                    	            {
                    	            if ( state.backtracking==0 ) {
                    	               
                    	              	  /* */ 
                    	              	
                    	            }
                    	            if ( state.backtracking==0 ) {
                    	               
                    	                      newCompositeNode(grammarAccess.getOperationCSAccess().getUnrestrictedNameParserRuleCall_10_0_1_2_1()); 
                    	                  
                    	            }
                    	            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleOperationCS7254);
                    	            ruleUnrestrictedName();

                    	            state._fsp--;
                    	            if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {
                    	               
                    	                      afterParserOrEnumRuleCall();
                    	                  
                    	            }

                    	            }
                    	            break;

                    	    }

                    	    otherlv_32=(Token)match(input,61,FollowSets000.FOLLOW_61_in_ruleOperationCS7267); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_32, grammarAccess.getOperationCSAccess().getColonKeyword_10_0_1_2_2());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3349:1: ( (lv_ownedBodyExpression_33_0= ruleSpecificationCS ) )?
                    	    int alt90=2;
                    	    int LA90_0 = input.LA(1);

                    	    if ( ((LA90_0>=RULE_INT && LA90_0<=RULE_SINGLE_QUOTED_STRING)||(LA90_0>=RULE_UNQUOTED_STRING && LA90_0<=RULE_ESCAPED_ID)||(LA90_0>=17 && LA90_0<=59)||LA90_0==77||LA90_0==85||(LA90_0>=97 && LA90_0<=110)||(LA90_0>=114 && LA90_0<=117)||LA90_0==121||LA90_0==125||LA90_0==127) ) {
                    	        alt90=1;
                    	    }
                    	    switch (alt90) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3350:1: (lv_ownedBodyExpression_33_0= ruleSpecificationCS )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3350:1: (lv_ownedBodyExpression_33_0= ruleSpecificationCS )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3351:3: lv_ownedBodyExpression_33_0= ruleSpecificationCS
                    	            {
                    	            if ( state.backtracking==0 ) {
                    	               
                    	              	        newCompositeNode(grammarAccess.getOperationCSAccess().getOwnedBodyExpressionSpecificationCSParserRuleCall_10_0_1_2_3_0()); 
                    	              	    
                    	            }
                    	            pushFollow(FollowSets000.FOLLOW_ruleSpecificationCS_in_ruleOperationCS7288);
                    	            lv_ownedBodyExpression_33_0=ruleSpecificationCS();

                    	            state._fsp--;
                    	            if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElementForParent(grammarAccess.getOperationCSRule());
                    	              	        }
                    	                     		add(
                    	                     			current, 
                    	                     			"ownedBodyExpression",
                    	                      		lv_ownedBodyExpression_33_0, 
                    	                      		"SpecificationCS");
                    	              	        afterParserOrEnumRuleCall();
                    	              	    
                    	            }

                    	            }


                    	            }
                    	            break;

                    	    }

                    	    otherlv_34=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleOperationCS7301); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_34, grammarAccess.getOperationCSAccess().getSemicolonKeyword_10_0_1_2_4());
                    	          
                    	    }

                    	    }


                    	    }
                    	    break;
                    	case 4 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3372:6: ( (lv_ownedPostcondition_35_0= rulePostconditionConstraintCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3372:6: ( (lv_ownedPostcondition_35_0= rulePostconditionConstraintCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3373:1: (lv_ownedPostcondition_35_0= rulePostconditionConstraintCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3373:1: (lv_ownedPostcondition_35_0= rulePostconditionConstraintCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3374:3: lv_ownedPostcondition_35_0= rulePostconditionConstraintCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getOperationCSAccess().getOwnedPostconditionPostconditionConstraintCSParserRuleCall_10_0_1_3_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_rulePostconditionConstraintCS_in_ruleOperationCS7329);
                    	    lv_ownedPostcondition_35_0=rulePostconditionConstraintCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getOperationCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedPostcondition",
                    	              		lv_ownedPostcondition_35_0, 
                    	              		"PostconditionConstraintCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop91;
                        }
                    } while (true);

                    otherlv_36=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleOperationCS7343); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_36, grammarAccess.getOperationCSAccess().getRightCurlyBracketKeyword_10_0_2());
                          
                    }

                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3395:7: otherlv_37= ';'
                    {
                    otherlv_37=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleOperationCS7362); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_37, grammarAccess.getOperationCSAccess().getSemicolonKeyword_10_1());
                          
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleOperationCS"


    // $ANTLR start "entryRulePackageCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3407:1: entryRulePackageCS returns [EObject current=null] : iv_rulePackageCS= rulePackageCS EOF ;
    public final EObject entryRulePackageCS() throws RecognitionException {
        EObject current = null;

        EObject iv_rulePackageCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3408:2: (iv_rulePackageCS= rulePackageCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3409:2: iv_rulePackageCS= rulePackageCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getPackageCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_rulePackageCS_in_entryRulePackageCS7399);
            iv_rulePackageCS=rulePackageCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_rulePackageCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRulePackageCS7409); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRulePackageCS"


    // $ANTLR start "rulePackageCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3416:1: rulePackageCS returns [EObject current=null] : (otherlv_0= 'package' ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= ':' ( (lv_nsPrefix_3_0= ruleUnrestrictedName ) ) )? (otherlv_4= '=' ( (lv_nsURI_5_0= ruleURI ) ) )? ( (otherlv_6= '{' ( ( (lv_ownedAnnotation_7_0= ruleAnnotationElementCS ) ) | ( (lv_ownedNestedPackage_8_0= rulePackageCS ) ) | ( (lv_ownedType_9_0= ruleClassifierCS ) ) )* otherlv_10= '}' ) | otherlv_11= ';' ) ) ;
    public final EObject rulePackageCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        Token otherlv_6=null;
        Token otherlv_10=null;
        Token otherlv_11=null;
        AntlrDatatypeRuleToken lv_name_1_0 = null;

        AntlrDatatypeRuleToken lv_nsPrefix_3_0 = null;

        AntlrDatatypeRuleToken lv_nsURI_5_0 = null;

        EObject lv_ownedAnnotation_7_0 = null;

        EObject lv_ownedNestedPackage_8_0 = null;

        EObject lv_ownedType_9_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3419:28: ( (otherlv_0= 'package' ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= ':' ( (lv_nsPrefix_3_0= ruleUnrestrictedName ) ) )? (otherlv_4= '=' ( (lv_nsURI_5_0= ruleURI ) ) )? ( (otherlv_6= '{' ( ( (lv_ownedAnnotation_7_0= ruleAnnotationElementCS ) ) | ( (lv_ownedNestedPackage_8_0= rulePackageCS ) ) | ( (lv_ownedType_9_0= ruleClassifierCS ) ) )* otherlv_10= '}' ) | otherlv_11= ';' ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3420:1: (otherlv_0= 'package' ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= ':' ( (lv_nsPrefix_3_0= ruleUnrestrictedName ) ) )? (otherlv_4= '=' ( (lv_nsURI_5_0= ruleURI ) ) )? ( (otherlv_6= '{' ( ( (lv_ownedAnnotation_7_0= ruleAnnotationElementCS ) ) | ( (lv_ownedNestedPackage_8_0= rulePackageCS ) ) | ( (lv_ownedType_9_0= ruleClassifierCS ) ) )* otherlv_10= '}' ) | otherlv_11= ';' ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3420:1: (otherlv_0= 'package' ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= ':' ( (lv_nsPrefix_3_0= ruleUnrestrictedName ) ) )? (otherlv_4= '=' ( (lv_nsURI_5_0= ruleURI ) ) )? ( (otherlv_6= '{' ( ( (lv_ownedAnnotation_7_0= ruleAnnotationElementCS ) ) | ( (lv_ownedNestedPackage_8_0= rulePackageCS ) ) | ( (lv_ownedType_9_0= ruleClassifierCS ) ) )* otherlv_10= '}' ) | otherlv_11= ';' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3420:3: otherlv_0= 'package' ( (lv_name_1_0= ruleUnrestrictedName ) ) (otherlv_2= ':' ( (lv_nsPrefix_3_0= ruleUnrestrictedName ) ) )? (otherlv_4= '=' ( (lv_nsURI_5_0= ruleURI ) ) )? ( (otherlv_6= '{' ( ( (lv_ownedAnnotation_7_0= ruleAnnotationElementCS ) ) | ( (lv_ownedNestedPackage_8_0= rulePackageCS ) ) | ( (lv_ownedType_9_0= ruleClassifierCS ) ) )* otherlv_10= '}' ) | otherlv_11= ';' )
            {
            otherlv_0=(Token)match(input,39,FollowSets000.FOLLOW_39_in_rulePackageCS7446); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_0, grammarAccess.getPackageCSAccess().getPackageKeyword_0());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3424:1: ( (lv_name_1_0= ruleUnrestrictedName ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3425:1: (lv_name_1_0= ruleUnrestrictedName )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3425:1: (lv_name_1_0= ruleUnrestrictedName )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3426:3: lv_name_1_0= ruleUnrestrictedName
            {
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getPackageCSAccess().getNameUnrestrictedNameParserRuleCall_1_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_rulePackageCS7467);
            lv_name_1_0=ruleUnrestrictedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElementForParent(grammarAccess.getPackageCSRule());
              	        }
                     		set(
                     			current, 
                     			"name",
                      		lv_name_1_0, 
                      		"UnrestrictedName");
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3442:2: (otherlv_2= ':' ( (lv_nsPrefix_3_0= ruleUnrestrictedName ) ) )?
            int alt93=2;
            int LA93_0 = input.LA(1);

            if ( (LA93_0==61) ) {
                alt93=1;
            }
            switch (alt93) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3442:4: otherlv_2= ':' ( (lv_nsPrefix_3_0= ruleUnrestrictedName ) )
                    {
                    otherlv_2=(Token)match(input,61,FollowSets000.FOLLOW_61_in_rulePackageCS7480); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_2, grammarAccess.getPackageCSAccess().getColonKeyword_2_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3446:1: ( (lv_nsPrefix_3_0= ruleUnrestrictedName ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3447:1: (lv_nsPrefix_3_0= ruleUnrestrictedName )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3447:1: (lv_nsPrefix_3_0= ruleUnrestrictedName )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3448:3: lv_nsPrefix_3_0= ruleUnrestrictedName
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getPackageCSAccess().getNsPrefixUnrestrictedNameParserRuleCall_2_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_rulePackageCS7501);
                    lv_nsPrefix_3_0=ruleUnrestrictedName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getPackageCSRule());
                      	        }
                             		set(
                             			current, 
                             			"nsPrefix",
                              		lv_nsPrefix_3_0, 
                              		"UnrestrictedName");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3464:4: (otherlv_4= '=' ( (lv_nsURI_5_0= ruleURI ) ) )?
            int alt94=2;
            int LA94_0 = input.LA(1);

            if ( (LA94_0==66) ) {
                alt94=1;
            }
            switch (alt94) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3464:6: otherlv_4= '=' ( (lv_nsURI_5_0= ruleURI ) )
                    {
                    otherlv_4=(Token)match(input,66,FollowSets000.FOLLOW_66_in_rulePackageCS7516); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_4, grammarAccess.getPackageCSAccess().getEqualsSignKeyword_3_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3468:1: ( (lv_nsURI_5_0= ruleURI ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3469:1: (lv_nsURI_5_0= ruleURI )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3469:1: (lv_nsURI_5_0= ruleURI )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3470:3: lv_nsURI_5_0= ruleURI
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getPackageCSAccess().getNsURIURIParserRuleCall_3_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleURI_in_rulePackageCS7537);
                    lv_nsURI_5_0=ruleURI();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getPackageCSRule());
                      	        }
                             		set(
                             			current, 
                             			"nsURI",
                              		lv_nsURI_5_0, 
                              		"URI");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3486:4: ( (otherlv_6= '{' ( ( (lv_ownedAnnotation_7_0= ruleAnnotationElementCS ) ) | ( (lv_ownedNestedPackage_8_0= rulePackageCS ) ) | ( (lv_ownedType_9_0= ruleClassifierCS ) ) )* otherlv_10= '}' ) | otherlv_11= ';' )
            int alt96=2;
            int LA96_0 = input.LA(1);

            if ( (LA96_0==64) ) {
                alt96=1;
            }
            else if ( (LA96_0==62) ) {
                alt96=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 96, 0, input);

                throw nvae;
            }
            switch (alt96) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3486:5: (otherlv_6= '{' ( ( (lv_ownedAnnotation_7_0= ruleAnnotationElementCS ) ) | ( (lv_ownedNestedPackage_8_0= rulePackageCS ) ) | ( (lv_ownedType_9_0= ruleClassifierCS ) ) )* otherlv_10= '}' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3486:5: (otherlv_6= '{' ( ( (lv_ownedAnnotation_7_0= ruleAnnotationElementCS ) ) | ( (lv_ownedNestedPackage_8_0= rulePackageCS ) ) | ( (lv_ownedType_9_0= ruleClassifierCS ) ) )* otherlv_10= '}' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3486:7: otherlv_6= '{' ( ( (lv_ownedAnnotation_7_0= ruleAnnotationElementCS ) ) | ( (lv_ownedNestedPackage_8_0= rulePackageCS ) ) | ( (lv_ownedType_9_0= ruleClassifierCS ) ) )* otherlv_10= '}'
                    {
                    otherlv_6=(Token)match(input,64,FollowSets000.FOLLOW_64_in_rulePackageCS7553); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_6, grammarAccess.getPackageCSAccess().getLeftCurlyBracketKeyword_4_0_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3490:1: ( ( (lv_ownedAnnotation_7_0= ruleAnnotationElementCS ) ) | ( (lv_ownedNestedPackage_8_0= rulePackageCS ) ) | ( (lv_ownedType_9_0= ruleClassifierCS ) ) )*
                    loop95:
                    do {
                        int alt95=4;
                        switch ( input.LA(1) ) {
                        case 53:
                        case 54:
                        case 58:
                            {
                            alt95=1;
                            }
                            break;
                        case 39:
                            {
                            alt95=2;
                            }
                            break;
                        case 19:
                        case 23:
                        case 25:
                        case 29:
                            {
                            alt95=3;
                            }
                            break;

                        }

                        switch (alt95) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3490:2: ( (lv_ownedAnnotation_7_0= ruleAnnotationElementCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3490:2: ( (lv_ownedAnnotation_7_0= ruleAnnotationElementCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3491:1: (lv_ownedAnnotation_7_0= ruleAnnotationElementCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3491:1: (lv_ownedAnnotation_7_0= ruleAnnotationElementCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3492:3: lv_ownedAnnotation_7_0= ruleAnnotationElementCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getPackageCSAccess().getOwnedAnnotationAnnotationElementCSParserRuleCall_4_0_1_0_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleAnnotationElementCS_in_rulePackageCS7575);
                    	    lv_ownedAnnotation_7_0=ruleAnnotationElementCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getPackageCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedAnnotation",
                    	              		lv_ownedAnnotation_7_0, 
                    	              		"AnnotationElementCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 2 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3509:6: ( (lv_ownedNestedPackage_8_0= rulePackageCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3509:6: ( (lv_ownedNestedPackage_8_0= rulePackageCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3510:1: (lv_ownedNestedPackage_8_0= rulePackageCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3510:1: (lv_ownedNestedPackage_8_0= rulePackageCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3511:3: lv_ownedNestedPackage_8_0= rulePackageCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getPackageCSAccess().getOwnedNestedPackagePackageCSParserRuleCall_4_0_1_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_rulePackageCS_in_rulePackageCS7602);
                    	    lv_ownedNestedPackage_8_0=rulePackageCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getPackageCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedNestedPackage",
                    	              		lv_ownedNestedPackage_8_0, 
                    	              		"PackageCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 3 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3528:6: ( (lv_ownedType_9_0= ruleClassifierCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3528:6: ( (lv_ownedType_9_0= ruleClassifierCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3529:1: (lv_ownedType_9_0= ruleClassifierCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3529:1: (lv_ownedType_9_0= ruleClassifierCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3530:3: lv_ownedType_9_0= ruleClassifierCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getPackageCSAccess().getOwnedTypeClassifierCSParserRuleCall_4_0_1_2_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleClassifierCS_in_rulePackageCS7629);
                    	    lv_ownedType_9_0=ruleClassifierCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getPackageCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedType",
                    	              		lv_ownedType_9_0, 
                    	              		"ClassifierCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop95;
                        }
                    } while (true);

                    otherlv_10=(Token)match(input,65,FollowSets000.FOLLOW_65_in_rulePackageCS7643); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_10, grammarAccess.getPackageCSAccess().getRightCurlyBracketKeyword_4_0_2());
                          
                    }

                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3551:7: otherlv_11= ';'
                    {
                    otherlv_11=(Token)match(input,62,FollowSets000.FOLLOW_62_in_rulePackageCS7662); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_11, grammarAccess.getPackageCSAccess().getSemicolonKeyword_4_1());
                          
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "rulePackageCS"


    // $ANTLR start "entryRuleParameterCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3563:1: entryRuleParameterCS returns [EObject current=null] : iv_ruleParameterCS= ruleParameterCS EOF ;
    public final EObject entryRuleParameterCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleParameterCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3564:2: (iv_ruleParameterCS= ruleParameterCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3565:2: iv_ruleParameterCS= ruleParameterCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getParameterCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleParameterCS_in_entryRuleParameterCS7699);
            iv_ruleParameterCS=ruleParameterCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleParameterCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleParameterCS7709); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleParameterCS"


    // $ANTLR start "ruleParameterCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3572:1: ruleParameterCS returns [EObject current=null] : ( ( (lv_name_0_0= ruleUnrestrictedName ) ) (otherlv_1= ':' ( (lv_ownedType_2_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_3= '{' ( ( ( (lv_qualifier_4_0= 'ordered' ) ) | ( (lv_qualifier_5_0= '!ordered' ) ) | ( (lv_qualifier_6_0= 'unique' ) ) | ( (lv_qualifier_7_0= '!unique' ) ) ) (otherlv_8= ',' )? )+ otherlv_9= '}' )? (otherlv_10= '{' ( (lv_ownedAnnotation_11_0= ruleAnnotationElementCS ) )* otherlv_12= '}' )? ) ;
    public final EObject ruleParameterCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_3=null;
        Token lv_qualifier_4_0=null;
        Token lv_qualifier_5_0=null;
        Token lv_qualifier_6_0=null;
        Token lv_qualifier_7_0=null;
        Token otherlv_8=null;
        Token otherlv_9=null;
        Token otherlv_10=null;
        Token otherlv_12=null;
        AntlrDatatypeRuleToken lv_name_0_0 = null;

        EObject lv_ownedType_2_0 = null;

        EObject lv_ownedAnnotation_11_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3575:28: ( ( ( (lv_name_0_0= ruleUnrestrictedName ) ) (otherlv_1= ':' ( (lv_ownedType_2_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_3= '{' ( ( ( (lv_qualifier_4_0= 'ordered' ) ) | ( (lv_qualifier_5_0= '!ordered' ) ) | ( (lv_qualifier_6_0= 'unique' ) ) | ( (lv_qualifier_7_0= '!unique' ) ) ) (otherlv_8= ',' )? )+ otherlv_9= '}' )? (otherlv_10= '{' ( (lv_ownedAnnotation_11_0= ruleAnnotationElementCS ) )* otherlv_12= '}' )? ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3576:1: ( ( (lv_name_0_0= ruleUnrestrictedName ) ) (otherlv_1= ':' ( (lv_ownedType_2_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_3= '{' ( ( ( (lv_qualifier_4_0= 'ordered' ) ) | ( (lv_qualifier_5_0= '!ordered' ) ) | ( (lv_qualifier_6_0= 'unique' ) ) | ( (lv_qualifier_7_0= '!unique' ) ) ) (otherlv_8= ',' )? )+ otherlv_9= '}' )? (otherlv_10= '{' ( (lv_ownedAnnotation_11_0= ruleAnnotationElementCS ) )* otherlv_12= '}' )? )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3576:1: ( ( (lv_name_0_0= ruleUnrestrictedName ) ) (otherlv_1= ':' ( (lv_ownedType_2_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_3= '{' ( ( ( (lv_qualifier_4_0= 'ordered' ) ) | ( (lv_qualifier_5_0= '!ordered' ) ) | ( (lv_qualifier_6_0= 'unique' ) ) | ( (lv_qualifier_7_0= '!unique' ) ) ) (otherlv_8= ',' )? )+ otherlv_9= '}' )? (otherlv_10= '{' ( (lv_ownedAnnotation_11_0= ruleAnnotationElementCS ) )* otherlv_12= '}' )? )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3576:2: ( (lv_name_0_0= ruleUnrestrictedName ) ) (otherlv_1= ':' ( (lv_ownedType_2_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_3= '{' ( ( ( (lv_qualifier_4_0= 'ordered' ) ) | ( (lv_qualifier_5_0= '!ordered' ) ) | ( (lv_qualifier_6_0= 'unique' ) ) | ( (lv_qualifier_7_0= '!unique' ) ) ) (otherlv_8= ',' )? )+ otherlv_9= '}' )? (otherlv_10= '{' ( (lv_ownedAnnotation_11_0= ruleAnnotationElementCS ) )* otherlv_12= '}' )?
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3576:2: ( (lv_name_0_0= ruleUnrestrictedName ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3577:1: (lv_name_0_0= ruleUnrestrictedName )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3577:1: (lv_name_0_0= ruleUnrestrictedName )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3578:3: lv_name_0_0= ruleUnrestrictedName
            {
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getParameterCSAccess().getNameUnrestrictedNameParserRuleCall_0_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleParameterCS7755);
            lv_name_0_0=ruleUnrestrictedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElementForParent(grammarAccess.getParameterCSRule());
              	        }
                     		set(
                     			current, 
                     			"name",
                      		lv_name_0_0, 
                      		"UnrestrictedName");
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3594:2: (otherlv_1= ':' ( (lv_ownedType_2_0= ruleTypedMultiplicityRefCS ) ) )?
            int alt97=2;
            int LA97_0 = input.LA(1);

            if ( (LA97_0==61) ) {
                alt97=1;
            }
            switch (alt97) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3594:4: otherlv_1= ':' ( (lv_ownedType_2_0= ruleTypedMultiplicityRefCS ) )
                    {
                    otherlv_1=(Token)match(input,61,FollowSets000.FOLLOW_61_in_ruleParameterCS7768); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_1, grammarAccess.getParameterCSAccess().getColonKeyword_1_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3598:1: ( (lv_ownedType_2_0= ruleTypedMultiplicityRefCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3599:1: (lv_ownedType_2_0= ruleTypedMultiplicityRefCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3599:1: (lv_ownedType_2_0= ruleTypedMultiplicityRefCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3600:3: lv_ownedType_2_0= ruleTypedMultiplicityRefCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getParameterCSAccess().getOwnedTypeTypedMultiplicityRefCSParserRuleCall_1_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTypedMultiplicityRefCS_in_ruleParameterCS7789);
                    lv_ownedType_2_0=ruleTypedMultiplicityRefCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getParameterCSRule());
                      	        }
                             		set(
                             			current, 
                             			"ownedType",
                              		lv_ownedType_2_0, 
                              		"TypedMultiplicityRefCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3616:4: (otherlv_3= '{' ( ( ( (lv_qualifier_4_0= 'ordered' ) ) | ( (lv_qualifier_5_0= '!ordered' ) ) | ( (lv_qualifier_6_0= 'unique' ) ) | ( (lv_qualifier_7_0= '!unique' ) ) ) (otherlv_8= ',' )? )+ otherlv_9= '}' )?
            int alt101=2;
            int LA101_0 = input.LA(1);

            if ( (LA101_0==64) ) {
                int LA101_1 = input.LA(2);

                if ( (LA101_1==38||LA101_1==50||LA101_1==69||LA101_1==72) ) {
                    alt101=1;
                }
            }
            switch (alt101) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3616:6: otherlv_3= '{' ( ( ( (lv_qualifier_4_0= 'ordered' ) ) | ( (lv_qualifier_5_0= '!ordered' ) ) | ( (lv_qualifier_6_0= 'unique' ) ) | ( (lv_qualifier_7_0= '!unique' ) ) ) (otherlv_8= ',' )? )+ otherlv_9= '}'
                    {
                    otherlv_3=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleParameterCS7804); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_3, grammarAccess.getParameterCSAccess().getLeftCurlyBracketKeyword_2_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3620:1: ( ( ( (lv_qualifier_4_0= 'ordered' ) ) | ( (lv_qualifier_5_0= '!ordered' ) ) | ( (lv_qualifier_6_0= 'unique' ) ) | ( (lv_qualifier_7_0= '!unique' ) ) ) (otherlv_8= ',' )? )+
                    int cnt100=0;
                    loop100:
                    do {
                        int alt100=2;
                        int LA100_0 = input.LA(1);

                        if ( (LA100_0==38||LA100_0==50||LA100_0==69||LA100_0==72) ) {
                            alt100=1;
                        }


                        switch (alt100) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3620:2: ( ( (lv_qualifier_4_0= 'ordered' ) ) | ( (lv_qualifier_5_0= '!ordered' ) ) | ( (lv_qualifier_6_0= 'unique' ) ) | ( (lv_qualifier_7_0= '!unique' ) ) ) (otherlv_8= ',' )?
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3620:2: ( ( (lv_qualifier_4_0= 'ordered' ) ) | ( (lv_qualifier_5_0= '!ordered' ) ) | ( (lv_qualifier_6_0= 'unique' ) ) | ( (lv_qualifier_7_0= '!unique' ) ) )
                    	    int alt98=4;
                    	    switch ( input.LA(1) ) {
                    	    case 38:
                    	        {
                    	        alt98=1;
                    	        }
                    	        break;
                    	    case 69:
                    	        {
                    	        alt98=2;
                    	        }
                    	        break;
                    	    case 50:
                    	        {
                    	        alt98=3;
                    	        }
                    	        break;
                    	    case 72:
                    	        {
                    	        alt98=4;
                    	        }
                    	        break;
                    	    default:
                    	        if (state.backtracking>0) {state.failed=true; return current;}
                    	        NoViableAltException nvae =
                    	            new NoViableAltException("", 98, 0, input);

                    	        throw nvae;
                    	    }

                    	    switch (alt98) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3620:3: ( (lv_qualifier_4_0= 'ordered' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3620:3: ( (lv_qualifier_4_0= 'ordered' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3621:1: (lv_qualifier_4_0= 'ordered' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3621:1: (lv_qualifier_4_0= 'ordered' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3622:3: lv_qualifier_4_0= 'ordered'
                    	            {
                    	            lv_qualifier_4_0=(Token)match(input,38,FollowSets000.FOLLOW_38_in_ruleParameterCS7824); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_4_0, grammarAccess.getParameterCSAccess().getQualifierOrderedKeyword_2_1_0_0_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getParameterCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_4_0, "ordered");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 2 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3636:6: ( (lv_qualifier_5_0= '!ordered' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3636:6: ( (lv_qualifier_5_0= '!ordered' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3637:1: (lv_qualifier_5_0= '!ordered' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3637:1: (lv_qualifier_5_0= '!ordered' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3638:3: lv_qualifier_5_0= '!ordered'
                    	            {
                    	            lv_qualifier_5_0=(Token)match(input,69,FollowSets000.FOLLOW_69_in_ruleParameterCS7861); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_5_0, grammarAccess.getParameterCSAccess().getQualifierOrderedKeyword_2_1_0_1_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getParameterCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_5_0, "!ordered");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 3 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3652:6: ( (lv_qualifier_6_0= 'unique' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3652:6: ( (lv_qualifier_6_0= 'unique' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3653:1: (lv_qualifier_6_0= 'unique' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3653:1: (lv_qualifier_6_0= 'unique' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3654:3: lv_qualifier_6_0= 'unique'
                    	            {
                    	            lv_qualifier_6_0=(Token)match(input,50,FollowSets000.FOLLOW_50_in_ruleParameterCS7898); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_6_0, grammarAccess.getParameterCSAccess().getQualifierUniqueKeyword_2_1_0_2_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getParameterCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_6_0, "unique");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 4 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3668:6: ( (lv_qualifier_7_0= '!unique' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3668:6: ( (lv_qualifier_7_0= '!unique' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3669:1: (lv_qualifier_7_0= '!unique' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3669:1: (lv_qualifier_7_0= '!unique' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3670:3: lv_qualifier_7_0= '!unique'
                    	            {
                    	            lv_qualifier_7_0=(Token)match(input,72,FollowSets000.FOLLOW_72_in_ruleParameterCS7935); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_7_0, grammarAccess.getParameterCSAccess().getQualifierUniqueKeyword_2_1_0_3_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getParameterCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_7_0, "!unique");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;

                    	    }

                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3683:3: (otherlv_8= ',' )?
                    	    int alt99=2;
                    	    int LA99_0 = input.LA(1);

                    	    if ( (LA99_0==63) ) {
                    	        alt99=1;
                    	    }
                    	    switch (alt99) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3683:5: otherlv_8= ','
                    	            {
                    	            otherlv_8=(Token)match(input,63,FollowSets000.FOLLOW_63_in_ruleParameterCS7962); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                  	newLeafNode(otherlv_8, grammarAccess.getParameterCSAccess().getCommaKeyword_2_1_1());
                    	                  
                    	            }

                    	            }
                    	            break;

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    if ( cnt100 >= 1 ) break loop100;
                    	    if (state.backtracking>0) {state.failed=true; return current;}
                                EarlyExitException eee =
                                    new EarlyExitException(100, input);
                                throw eee;
                        }
                        cnt100++;
                    } while (true);

                    otherlv_9=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleParameterCS7978); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_9, grammarAccess.getParameterCSAccess().getRightCurlyBracketKeyword_2_2());
                          
                    }

                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3691:3: (otherlv_10= '{' ( (lv_ownedAnnotation_11_0= ruleAnnotationElementCS ) )* otherlv_12= '}' )?
            int alt103=2;
            int LA103_0 = input.LA(1);

            if ( (LA103_0==64) ) {
                alt103=1;
            }
            switch (alt103) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3691:5: otherlv_10= '{' ( (lv_ownedAnnotation_11_0= ruleAnnotationElementCS ) )* otherlv_12= '}'
                    {
                    otherlv_10=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleParameterCS7993); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_10, grammarAccess.getParameterCSAccess().getLeftCurlyBracketKeyword_3_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3695:1: ( (lv_ownedAnnotation_11_0= ruleAnnotationElementCS ) )*
                    loop102:
                    do {
                        int alt102=2;
                        int LA102_0 = input.LA(1);

                        if ( ((LA102_0>=53 && LA102_0<=54)||LA102_0==58) ) {
                            alt102=1;
                        }


                        switch (alt102) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3696:1: (lv_ownedAnnotation_11_0= ruleAnnotationElementCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3696:1: (lv_ownedAnnotation_11_0= ruleAnnotationElementCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3697:3: lv_ownedAnnotation_11_0= ruleAnnotationElementCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getParameterCSAccess().getOwnedAnnotationAnnotationElementCSParserRuleCall_3_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleAnnotationElementCS_in_ruleParameterCS8014);
                    	    lv_ownedAnnotation_11_0=ruleAnnotationElementCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getParameterCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedAnnotation",
                    	              		lv_ownedAnnotation_11_0, 
                    	              		"AnnotationElementCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop102;
                        }
                    } while (true);

                    otherlv_12=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleParameterCS8027); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_12, grammarAccess.getParameterCSAccess().getRightCurlyBracketKeyword_3_2());
                          
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleParameterCS"


    // $ANTLR start "entryRuleReferenceCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3725:1: entryRuleReferenceCS returns [EObject current=null] : iv_ruleReferenceCS= ruleReferenceCS EOF ;
    public final EObject entryRuleReferenceCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleReferenceCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3726:2: (iv_ruleReferenceCS= ruleReferenceCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3727:2: iv_ruleReferenceCS= ruleReferenceCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getReferenceCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleReferenceCS_in_entryRuleReferenceCS8065);
            iv_ruleReferenceCS=ruleReferenceCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleReferenceCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleReferenceCS8075); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleReferenceCS"


    // $ANTLR start "ruleReferenceCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3734:1: ruleReferenceCS returns [EObject current=null] : ( ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )? otherlv_4= 'property' ( (lv_name_5_0= ruleUnrestrictedName ) ) (otherlv_6= '#' ( ( ruleUnrestrictedName ) ) )? (otherlv_8= ':' ( (lv_ownedType_9_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_10= '=' ( (lv_default_11_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_12= '{' ( ( ( (lv_qualifier_13_0= 'composes' ) ) | ( (lv_qualifier_14_0= '!composes' ) ) | ( (lv_qualifier_15_0= 'derived' ) ) | ( (lv_qualifier_16_0= '!derived' ) ) | ( (lv_qualifier_17_0= 'ordered' ) ) | ( (lv_qualifier_18_0= '!ordered' ) ) | ( (lv_qualifier_19_0= 'readonly' ) ) | ( (lv_qualifier_20_0= '!readonly' ) ) | ( (lv_qualifier_21_0= 'resolve' ) ) | ( (lv_qualifier_22_0= '!resolve' ) ) | ( (lv_qualifier_23_0= 'transient' ) ) | ( (lv_qualifier_24_0= '!transient' ) ) | ( (lv_qualifier_25_0= 'unique' ) ) | ( (lv_qualifier_26_0= '!unique' ) ) | ( (lv_qualifier_27_0= 'unsettable' ) ) | ( (lv_qualifier_28_0= '!unsettable' ) ) | ( (lv_qualifier_29_0= 'volatile' ) ) | ( (lv_qualifier_30_0= '!volatile' ) ) ) (otherlv_31= ',' )? )+ otherlv_32= '}' )? ( (otherlv_33= '{' ( ( (lv_ownedAnnotation_34_0= ruleAnnotationElementCS ) ) | (otherlv_35= 'key' ( ( ruleUnrestrictedName ) ) (otherlv_37= ',' ( ( ruleUnrestrictedName ) ) )* otherlv_39= ';' ) | (otherlv_40= 'derivation' ( ruleUnrestrictedName )? otherlv_42= ':' ( (lv_ownedDefaultExpression_43_0= ruleSpecificationCS ) )? otherlv_44= ';' ) | (otherlv_45= 'initial' ( ruleUnrestrictedName )? otherlv_47= ':' ( (lv_ownedDefaultExpression_48_0= ruleSpecificationCS ) )? otherlv_49= ';' ) )* otherlv_50= '}' ) | otherlv_51= ';' ) ) ;
    public final EObject ruleReferenceCS() throws RecognitionException {
        EObject current = null;

        Token lv_qualifier_0_0=null;
        Token lv_qualifier_1_0=null;
        Token lv_qualifier_2_0=null;
        Token lv_qualifier_3_0=null;
        Token otherlv_4=null;
        Token otherlv_6=null;
        Token otherlv_8=null;
        Token otherlv_10=null;
        Token lv_default_11_0=null;
        Token otherlv_12=null;
        Token lv_qualifier_13_0=null;
        Token lv_qualifier_14_0=null;
        Token lv_qualifier_15_0=null;
        Token lv_qualifier_16_0=null;
        Token lv_qualifier_17_0=null;
        Token lv_qualifier_18_0=null;
        Token lv_qualifier_19_0=null;
        Token lv_qualifier_20_0=null;
        Token lv_qualifier_21_0=null;
        Token lv_qualifier_22_0=null;
        Token lv_qualifier_23_0=null;
        Token lv_qualifier_24_0=null;
        Token lv_qualifier_25_0=null;
        Token lv_qualifier_26_0=null;
        Token lv_qualifier_27_0=null;
        Token lv_qualifier_28_0=null;
        Token lv_qualifier_29_0=null;
        Token lv_qualifier_30_0=null;
        Token otherlv_31=null;
        Token otherlv_32=null;
        Token otherlv_33=null;
        Token otherlv_35=null;
        Token otherlv_37=null;
        Token otherlv_39=null;
        Token otherlv_40=null;
        Token otherlv_42=null;
        Token otherlv_44=null;
        Token otherlv_45=null;
        Token otherlv_47=null;
        Token otherlv_49=null;
        Token otherlv_50=null;
        Token otherlv_51=null;
        AntlrDatatypeRuleToken lv_name_5_0 = null;

        EObject lv_ownedType_9_0 = null;

        EObject lv_ownedAnnotation_34_0 = null;

        EObject lv_ownedDefaultExpression_43_0 = null;

        EObject lv_ownedDefaultExpression_48_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3737:28: ( ( ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )? otherlv_4= 'property' ( (lv_name_5_0= ruleUnrestrictedName ) ) (otherlv_6= '#' ( ( ruleUnrestrictedName ) ) )? (otherlv_8= ':' ( (lv_ownedType_9_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_10= '=' ( (lv_default_11_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_12= '{' ( ( ( (lv_qualifier_13_0= 'composes' ) ) | ( (lv_qualifier_14_0= '!composes' ) ) | ( (lv_qualifier_15_0= 'derived' ) ) | ( (lv_qualifier_16_0= '!derived' ) ) | ( (lv_qualifier_17_0= 'ordered' ) ) | ( (lv_qualifier_18_0= '!ordered' ) ) | ( (lv_qualifier_19_0= 'readonly' ) ) | ( (lv_qualifier_20_0= '!readonly' ) ) | ( (lv_qualifier_21_0= 'resolve' ) ) | ( (lv_qualifier_22_0= '!resolve' ) ) | ( (lv_qualifier_23_0= 'transient' ) ) | ( (lv_qualifier_24_0= '!transient' ) ) | ( (lv_qualifier_25_0= 'unique' ) ) | ( (lv_qualifier_26_0= '!unique' ) ) | ( (lv_qualifier_27_0= 'unsettable' ) ) | ( (lv_qualifier_28_0= '!unsettable' ) ) | ( (lv_qualifier_29_0= 'volatile' ) ) | ( (lv_qualifier_30_0= '!volatile' ) ) ) (otherlv_31= ',' )? )+ otherlv_32= '}' )? ( (otherlv_33= '{' ( ( (lv_ownedAnnotation_34_0= ruleAnnotationElementCS ) ) | (otherlv_35= 'key' ( ( ruleUnrestrictedName ) ) (otherlv_37= ',' ( ( ruleUnrestrictedName ) ) )* otherlv_39= ';' ) | (otherlv_40= 'derivation' ( ruleUnrestrictedName )? otherlv_42= ':' ( (lv_ownedDefaultExpression_43_0= ruleSpecificationCS ) )? otherlv_44= ';' ) | (otherlv_45= 'initial' ( ruleUnrestrictedName )? otherlv_47= ':' ( (lv_ownedDefaultExpression_48_0= ruleSpecificationCS ) )? otherlv_49= ';' ) )* otherlv_50= '}' ) | otherlv_51= ';' ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3738:1: ( ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )? otherlv_4= 'property' ( (lv_name_5_0= ruleUnrestrictedName ) ) (otherlv_6= '#' ( ( ruleUnrestrictedName ) ) )? (otherlv_8= ':' ( (lv_ownedType_9_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_10= '=' ( (lv_default_11_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_12= '{' ( ( ( (lv_qualifier_13_0= 'composes' ) ) | ( (lv_qualifier_14_0= '!composes' ) ) | ( (lv_qualifier_15_0= 'derived' ) ) | ( (lv_qualifier_16_0= '!derived' ) ) | ( (lv_qualifier_17_0= 'ordered' ) ) | ( (lv_qualifier_18_0= '!ordered' ) ) | ( (lv_qualifier_19_0= 'readonly' ) ) | ( (lv_qualifier_20_0= '!readonly' ) ) | ( (lv_qualifier_21_0= 'resolve' ) ) | ( (lv_qualifier_22_0= '!resolve' ) ) | ( (lv_qualifier_23_0= 'transient' ) ) | ( (lv_qualifier_24_0= '!transient' ) ) | ( (lv_qualifier_25_0= 'unique' ) ) | ( (lv_qualifier_26_0= '!unique' ) ) | ( (lv_qualifier_27_0= 'unsettable' ) ) | ( (lv_qualifier_28_0= '!unsettable' ) ) | ( (lv_qualifier_29_0= 'volatile' ) ) | ( (lv_qualifier_30_0= '!volatile' ) ) ) (otherlv_31= ',' )? )+ otherlv_32= '}' )? ( (otherlv_33= '{' ( ( (lv_ownedAnnotation_34_0= ruleAnnotationElementCS ) ) | (otherlv_35= 'key' ( ( ruleUnrestrictedName ) ) (otherlv_37= ',' ( ( ruleUnrestrictedName ) ) )* otherlv_39= ';' ) | (otherlv_40= 'derivation' ( ruleUnrestrictedName )? otherlv_42= ':' ( (lv_ownedDefaultExpression_43_0= ruleSpecificationCS ) )? otherlv_44= ';' ) | (otherlv_45= 'initial' ( ruleUnrestrictedName )? otherlv_47= ':' ( (lv_ownedDefaultExpression_48_0= ruleSpecificationCS ) )? otherlv_49= ';' ) )* otherlv_50= '}' ) | otherlv_51= ';' ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3738:1: ( ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )? otherlv_4= 'property' ( (lv_name_5_0= ruleUnrestrictedName ) ) (otherlv_6= '#' ( ( ruleUnrestrictedName ) ) )? (otherlv_8= ':' ( (lv_ownedType_9_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_10= '=' ( (lv_default_11_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_12= '{' ( ( ( (lv_qualifier_13_0= 'composes' ) ) | ( (lv_qualifier_14_0= '!composes' ) ) | ( (lv_qualifier_15_0= 'derived' ) ) | ( (lv_qualifier_16_0= '!derived' ) ) | ( (lv_qualifier_17_0= 'ordered' ) ) | ( (lv_qualifier_18_0= '!ordered' ) ) | ( (lv_qualifier_19_0= 'readonly' ) ) | ( (lv_qualifier_20_0= '!readonly' ) ) | ( (lv_qualifier_21_0= 'resolve' ) ) | ( (lv_qualifier_22_0= '!resolve' ) ) | ( (lv_qualifier_23_0= 'transient' ) ) | ( (lv_qualifier_24_0= '!transient' ) ) | ( (lv_qualifier_25_0= 'unique' ) ) | ( (lv_qualifier_26_0= '!unique' ) ) | ( (lv_qualifier_27_0= 'unsettable' ) ) | ( (lv_qualifier_28_0= '!unsettable' ) ) | ( (lv_qualifier_29_0= 'volatile' ) ) | ( (lv_qualifier_30_0= '!volatile' ) ) ) (otherlv_31= ',' )? )+ otherlv_32= '}' )? ( (otherlv_33= '{' ( ( (lv_ownedAnnotation_34_0= ruleAnnotationElementCS ) ) | (otherlv_35= 'key' ( ( ruleUnrestrictedName ) ) (otherlv_37= ',' ( ( ruleUnrestrictedName ) ) )* otherlv_39= ';' ) | (otherlv_40= 'derivation' ( ruleUnrestrictedName )? otherlv_42= ':' ( (lv_ownedDefaultExpression_43_0= ruleSpecificationCS ) )? otherlv_44= ';' ) | (otherlv_45= 'initial' ( ruleUnrestrictedName )? otherlv_47= ':' ( (lv_ownedDefaultExpression_48_0= ruleSpecificationCS ) )? otherlv_49= ';' ) )* otherlv_50= '}' ) | otherlv_51= ';' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3738:2: ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )? otherlv_4= 'property' ( (lv_name_5_0= ruleUnrestrictedName ) ) (otherlv_6= '#' ( ( ruleUnrestrictedName ) ) )? (otherlv_8= ':' ( (lv_ownedType_9_0= ruleTypedMultiplicityRefCS ) ) )? (otherlv_10= '=' ( (lv_default_11_0= RULE_SINGLE_QUOTED_STRING ) ) )? (otherlv_12= '{' ( ( ( (lv_qualifier_13_0= 'composes' ) ) | ( (lv_qualifier_14_0= '!composes' ) ) | ( (lv_qualifier_15_0= 'derived' ) ) | ( (lv_qualifier_16_0= '!derived' ) ) | ( (lv_qualifier_17_0= 'ordered' ) ) | ( (lv_qualifier_18_0= '!ordered' ) ) | ( (lv_qualifier_19_0= 'readonly' ) ) | ( (lv_qualifier_20_0= '!readonly' ) ) | ( (lv_qualifier_21_0= 'resolve' ) ) | ( (lv_qualifier_22_0= '!resolve' ) ) | ( (lv_qualifier_23_0= 'transient' ) ) | ( (lv_qualifier_24_0= '!transient' ) ) | ( (lv_qualifier_25_0= 'unique' ) ) | ( (lv_qualifier_26_0= '!unique' ) ) | ( (lv_qualifier_27_0= 'unsettable' ) ) | ( (lv_qualifier_28_0= '!unsettable' ) ) | ( (lv_qualifier_29_0= 'volatile' ) ) | ( (lv_qualifier_30_0= '!volatile' ) ) ) (otherlv_31= ',' )? )+ otherlv_32= '}' )? ( (otherlv_33= '{' ( ( (lv_ownedAnnotation_34_0= ruleAnnotationElementCS ) ) | (otherlv_35= 'key' ( ( ruleUnrestrictedName ) ) (otherlv_37= ',' ( ( ruleUnrestrictedName ) ) )* otherlv_39= ';' ) | (otherlv_40= 'derivation' ( ruleUnrestrictedName )? otherlv_42= ':' ( (lv_ownedDefaultExpression_43_0= ruleSpecificationCS ) )? otherlv_44= ';' ) | (otherlv_45= 'initial' ( ruleUnrestrictedName )? otherlv_47= ':' ( (lv_ownedDefaultExpression_48_0= ruleSpecificationCS ) )? otherlv_49= ';' ) )* otherlv_50= '}' ) | otherlv_51= ';' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3738:2: ( ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? ) | ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? ) )?
            int alt106=3;
            int LA106_0 = input.LA(1);

            if ( (LA106_0==46) ) {
                alt106=1;
            }
            else if ( (LA106_0==26) ) {
                alt106=2;
            }
            switch (alt106) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3738:3: ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3738:3: ( ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )? )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3738:4: ( (lv_qualifier_0_0= 'static' ) ) ( (lv_qualifier_1_0= 'definition' ) )?
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3738:4: ( (lv_qualifier_0_0= 'static' ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3739:1: (lv_qualifier_0_0= 'static' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3739:1: (lv_qualifier_0_0= 'static' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3740:3: lv_qualifier_0_0= 'static'
                    {
                    lv_qualifier_0_0=(Token)match(input,46,FollowSets000.FOLLOW_46_in_ruleReferenceCS8120); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_qualifier_0_0, grammarAccess.getReferenceCSAccess().getQualifierStaticKeyword_0_0_0_0());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getReferenceCSRule());
                      	        }
                             		addWithLastConsumed(current, "qualifier", lv_qualifier_0_0, "static");
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3753:2: ( (lv_qualifier_1_0= 'definition' ) )?
                    int alt104=2;
                    int LA104_0 = input.LA(1);

                    if ( (LA104_0==26) ) {
                        alt104=1;
                    }
                    switch (alt104) {
                        case 1 :
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3754:1: (lv_qualifier_1_0= 'definition' )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3754:1: (lv_qualifier_1_0= 'definition' )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3755:3: lv_qualifier_1_0= 'definition'
                            {
                            lv_qualifier_1_0=(Token)match(input,26,FollowSets000.FOLLOW_26_in_ruleReferenceCS8151); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                                      newLeafNode(lv_qualifier_1_0, grammarAccess.getReferenceCSAccess().getQualifierDefinitionKeyword_0_0_1_0());
                                  
                            }
                            if ( state.backtracking==0 ) {

                              	        if (current==null) {
                              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                              	        }
                                     		addWithLastConsumed(current, "qualifier", lv_qualifier_1_0, "definition");
                              	    
                            }

                            }


                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3769:6: ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3769:6: ( ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )? )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3769:7: ( (lv_qualifier_2_0= 'definition' ) ) ( (lv_qualifier_3_0= 'static' ) )?
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3769:7: ( (lv_qualifier_2_0= 'definition' ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3770:1: (lv_qualifier_2_0= 'definition' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3770:1: (lv_qualifier_2_0= 'definition' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3771:3: lv_qualifier_2_0= 'definition'
                    {
                    lv_qualifier_2_0=(Token)match(input,26,FollowSets000.FOLLOW_26_in_ruleReferenceCS8191); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_qualifier_2_0, grammarAccess.getReferenceCSAccess().getQualifierDefinitionKeyword_0_1_0_0());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getReferenceCSRule());
                      	        }
                             		addWithLastConsumed(current, "qualifier", lv_qualifier_2_0, "definition");
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3784:2: ( (lv_qualifier_3_0= 'static' ) )?
                    int alt105=2;
                    int LA105_0 = input.LA(1);

                    if ( (LA105_0==46) ) {
                        alt105=1;
                    }
                    switch (alt105) {
                        case 1 :
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3785:1: (lv_qualifier_3_0= 'static' )
                            {
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3785:1: (lv_qualifier_3_0= 'static' )
                            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3786:3: lv_qualifier_3_0= 'static'
                            {
                            lv_qualifier_3_0=(Token)match(input,46,FollowSets000.FOLLOW_46_in_ruleReferenceCS8222); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                                      newLeafNode(lv_qualifier_3_0, grammarAccess.getReferenceCSAccess().getQualifierStaticKeyword_0_1_1_0());
                                  
                            }
                            if ( state.backtracking==0 ) {

                              	        if (current==null) {
                              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                              	        }
                                     		addWithLastConsumed(current, "qualifier", lv_qualifier_3_0, "static");
                              	    
                            }

                            }


                            }
                            break;

                    }


                    }


                    }
                    break;

            }

            otherlv_4=(Token)match(input,42,FollowSets000.FOLLOW_42_in_ruleReferenceCS8251); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_4, grammarAccess.getReferenceCSAccess().getPropertyKeyword_1());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3803:1: ( (lv_name_5_0= ruleUnrestrictedName ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3804:1: (lv_name_5_0= ruleUnrestrictedName )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3804:1: (lv_name_5_0= ruleUnrestrictedName )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3805:3: lv_name_5_0= ruleUnrestrictedName
            {
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getReferenceCSAccess().getNameUnrestrictedNameParserRuleCall_2_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleReferenceCS8272);
            lv_name_5_0=ruleUnrestrictedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElementForParent(grammarAccess.getReferenceCSRule());
              	        }
                     		set(
                     			current, 
                     			"name",
                      		lv_name_5_0, 
                      		"UnrestrictedName");
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3821:2: (otherlv_6= '#' ( ( ruleUnrestrictedName ) ) )?
            int alt107=2;
            int LA107_0 = input.LA(1);

            if ( (LA107_0==78) ) {
                alt107=1;
            }
            switch (alt107) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3821:4: otherlv_6= '#' ( ( ruleUnrestrictedName ) )
                    {
                    otherlv_6=(Token)match(input,78,FollowSets000.FOLLOW_78_in_ruleReferenceCS8285); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_6, grammarAccess.getReferenceCSAccess().getNumberSignKeyword_3_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3825:1: ( ( ruleUnrestrictedName ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3826:1: ( ruleUnrestrictedName )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3826:1: ( ruleUnrestrictedName )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3827:3: ruleUnrestrictedName
                    {
                    if ( state.backtracking==0 ) {
                       
                      		  /* */ 
                      		
                    }
                    if ( state.backtracking==0 ) {

                      			if (current==null) {
                      	            current = createModelElement(grammarAccess.getReferenceCSRule());
                      	        }
                              
                    }
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getReferenceCSAccess().getOppositePropertyCrossReference_3_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleReferenceCS8312);
                    ruleUnrestrictedName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3843:4: (otherlv_8= ':' ( (lv_ownedType_9_0= ruleTypedMultiplicityRefCS ) ) )?
            int alt108=2;
            int LA108_0 = input.LA(1);

            if ( (LA108_0==61) ) {
                alt108=1;
            }
            switch (alt108) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3843:6: otherlv_8= ':' ( (lv_ownedType_9_0= ruleTypedMultiplicityRefCS ) )
                    {
                    otherlv_8=(Token)match(input,61,FollowSets000.FOLLOW_61_in_ruleReferenceCS8327); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_8, grammarAccess.getReferenceCSAccess().getColonKeyword_4_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3847:1: ( (lv_ownedType_9_0= ruleTypedMultiplicityRefCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3848:1: (lv_ownedType_9_0= ruleTypedMultiplicityRefCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3848:1: (lv_ownedType_9_0= ruleTypedMultiplicityRefCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3849:3: lv_ownedType_9_0= ruleTypedMultiplicityRefCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getReferenceCSAccess().getOwnedTypeTypedMultiplicityRefCSParserRuleCall_4_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTypedMultiplicityRefCS_in_ruleReferenceCS8348);
                    lv_ownedType_9_0=ruleTypedMultiplicityRefCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getReferenceCSRule());
                      	        }
                             		set(
                             			current, 
                             			"ownedType",
                              		lv_ownedType_9_0, 
                              		"TypedMultiplicityRefCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3865:4: (otherlv_10= '=' ( (lv_default_11_0= RULE_SINGLE_QUOTED_STRING ) ) )?
            int alt109=2;
            int LA109_0 = input.LA(1);

            if ( (LA109_0==66) ) {
                alt109=1;
            }
            switch (alt109) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3865:6: otherlv_10= '=' ( (lv_default_11_0= RULE_SINGLE_QUOTED_STRING ) )
                    {
                    otherlv_10=(Token)match(input,66,FollowSets000.FOLLOW_66_in_ruleReferenceCS8363); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_10, grammarAccess.getReferenceCSAccess().getEqualsSignKeyword_5_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3869:1: ( (lv_default_11_0= RULE_SINGLE_QUOTED_STRING ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3870:1: (lv_default_11_0= RULE_SINGLE_QUOTED_STRING )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3870:1: (lv_default_11_0= RULE_SINGLE_QUOTED_STRING )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3871:3: lv_default_11_0= RULE_SINGLE_QUOTED_STRING
                    {
                    lv_default_11_0=(Token)match(input,RULE_SINGLE_QUOTED_STRING,FollowSets000.FOLLOW_RULE_SINGLE_QUOTED_STRING_in_ruleReferenceCS8380); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			newLeafNode(lv_default_11_0, grammarAccess.getReferenceCSAccess().getDefaultSINGLE_QUOTED_STRINGTerminalRuleCall_5_1_0()); 
                      		
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getReferenceCSRule());
                      	        }
                             		setWithLastConsumed(
                             			current, 
                             			"default",
                              		lv_default_11_0, 
                              		"SINGLE_QUOTED_STRING");
                      	    
                    }

                    }


                    }


                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3887:4: (otherlv_12= '{' ( ( ( (lv_qualifier_13_0= 'composes' ) ) | ( (lv_qualifier_14_0= '!composes' ) ) | ( (lv_qualifier_15_0= 'derived' ) ) | ( (lv_qualifier_16_0= '!derived' ) ) | ( (lv_qualifier_17_0= 'ordered' ) ) | ( (lv_qualifier_18_0= '!ordered' ) ) | ( (lv_qualifier_19_0= 'readonly' ) ) | ( (lv_qualifier_20_0= '!readonly' ) ) | ( (lv_qualifier_21_0= 'resolve' ) ) | ( (lv_qualifier_22_0= '!resolve' ) ) | ( (lv_qualifier_23_0= 'transient' ) ) | ( (lv_qualifier_24_0= '!transient' ) ) | ( (lv_qualifier_25_0= 'unique' ) ) | ( (lv_qualifier_26_0= '!unique' ) ) | ( (lv_qualifier_27_0= 'unsettable' ) ) | ( (lv_qualifier_28_0= '!unsettable' ) ) | ( (lv_qualifier_29_0= 'volatile' ) ) | ( (lv_qualifier_30_0= '!volatile' ) ) ) (otherlv_31= ',' )? )+ otherlv_32= '}' )?
            int alt113=2;
            int LA113_0 = input.LA(1);

            if ( (LA113_0==64) ) {
                int LA113_1 = input.LA(2);

                if ( (LA113_1==24||LA113_1==28||LA113_1==38||LA113_1==43||LA113_1==45||(LA113_1>=49 && LA113_1<=52)||LA113_1==67||(LA113_1>=69 && LA113_1<=74)||(LA113_1>=79 && LA113_1<=80)) ) {
                    alt113=1;
                }
            }
            switch (alt113) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3887:6: otherlv_12= '{' ( ( ( (lv_qualifier_13_0= 'composes' ) ) | ( (lv_qualifier_14_0= '!composes' ) ) | ( (lv_qualifier_15_0= 'derived' ) ) | ( (lv_qualifier_16_0= '!derived' ) ) | ( (lv_qualifier_17_0= 'ordered' ) ) | ( (lv_qualifier_18_0= '!ordered' ) ) | ( (lv_qualifier_19_0= 'readonly' ) ) | ( (lv_qualifier_20_0= '!readonly' ) ) | ( (lv_qualifier_21_0= 'resolve' ) ) | ( (lv_qualifier_22_0= '!resolve' ) ) | ( (lv_qualifier_23_0= 'transient' ) ) | ( (lv_qualifier_24_0= '!transient' ) ) | ( (lv_qualifier_25_0= 'unique' ) ) | ( (lv_qualifier_26_0= '!unique' ) ) | ( (lv_qualifier_27_0= 'unsettable' ) ) | ( (lv_qualifier_28_0= '!unsettable' ) ) | ( (lv_qualifier_29_0= 'volatile' ) ) | ( (lv_qualifier_30_0= '!volatile' ) ) ) (otherlv_31= ',' )? )+ otherlv_32= '}'
                    {
                    otherlv_12=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleReferenceCS8400); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_12, grammarAccess.getReferenceCSAccess().getLeftCurlyBracketKeyword_6_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3891:1: ( ( ( (lv_qualifier_13_0= 'composes' ) ) | ( (lv_qualifier_14_0= '!composes' ) ) | ( (lv_qualifier_15_0= 'derived' ) ) | ( (lv_qualifier_16_0= '!derived' ) ) | ( (lv_qualifier_17_0= 'ordered' ) ) | ( (lv_qualifier_18_0= '!ordered' ) ) | ( (lv_qualifier_19_0= 'readonly' ) ) | ( (lv_qualifier_20_0= '!readonly' ) ) | ( (lv_qualifier_21_0= 'resolve' ) ) | ( (lv_qualifier_22_0= '!resolve' ) ) | ( (lv_qualifier_23_0= 'transient' ) ) | ( (lv_qualifier_24_0= '!transient' ) ) | ( (lv_qualifier_25_0= 'unique' ) ) | ( (lv_qualifier_26_0= '!unique' ) ) | ( (lv_qualifier_27_0= 'unsettable' ) ) | ( (lv_qualifier_28_0= '!unsettable' ) ) | ( (lv_qualifier_29_0= 'volatile' ) ) | ( (lv_qualifier_30_0= '!volatile' ) ) ) (otherlv_31= ',' )? )+
                    int cnt112=0;
                    loop112:
                    do {
                        int alt112=2;
                        int LA112_0 = input.LA(1);

                        if ( (LA112_0==24||LA112_0==28||LA112_0==38||LA112_0==43||LA112_0==45||(LA112_0>=49 && LA112_0<=52)||LA112_0==67||(LA112_0>=69 && LA112_0<=74)||(LA112_0>=79 && LA112_0<=80)) ) {
                            alt112=1;
                        }


                        switch (alt112) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3891:2: ( ( (lv_qualifier_13_0= 'composes' ) ) | ( (lv_qualifier_14_0= '!composes' ) ) | ( (lv_qualifier_15_0= 'derived' ) ) | ( (lv_qualifier_16_0= '!derived' ) ) | ( (lv_qualifier_17_0= 'ordered' ) ) | ( (lv_qualifier_18_0= '!ordered' ) ) | ( (lv_qualifier_19_0= 'readonly' ) ) | ( (lv_qualifier_20_0= '!readonly' ) ) | ( (lv_qualifier_21_0= 'resolve' ) ) | ( (lv_qualifier_22_0= '!resolve' ) ) | ( (lv_qualifier_23_0= 'transient' ) ) | ( (lv_qualifier_24_0= '!transient' ) ) | ( (lv_qualifier_25_0= 'unique' ) ) | ( (lv_qualifier_26_0= '!unique' ) ) | ( (lv_qualifier_27_0= 'unsettable' ) ) | ( (lv_qualifier_28_0= '!unsettable' ) ) | ( (lv_qualifier_29_0= 'volatile' ) ) | ( (lv_qualifier_30_0= '!volatile' ) ) ) (otherlv_31= ',' )?
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3891:2: ( ( (lv_qualifier_13_0= 'composes' ) ) | ( (lv_qualifier_14_0= '!composes' ) ) | ( (lv_qualifier_15_0= 'derived' ) ) | ( (lv_qualifier_16_0= '!derived' ) ) | ( (lv_qualifier_17_0= 'ordered' ) ) | ( (lv_qualifier_18_0= '!ordered' ) ) | ( (lv_qualifier_19_0= 'readonly' ) ) | ( (lv_qualifier_20_0= '!readonly' ) ) | ( (lv_qualifier_21_0= 'resolve' ) ) | ( (lv_qualifier_22_0= '!resolve' ) ) | ( (lv_qualifier_23_0= 'transient' ) ) | ( (lv_qualifier_24_0= '!transient' ) ) | ( (lv_qualifier_25_0= 'unique' ) ) | ( (lv_qualifier_26_0= '!unique' ) ) | ( (lv_qualifier_27_0= 'unsettable' ) ) | ( (lv_qualifier_28_0= '!unsettable' ) ) | ( (lv_qualifier_29_0= 'volatile' ) ) | ( (lv_qualifier_30_0= '!volatile' ) ) )
                    	    int alt110=18;
                    	    switch ( input.LA(1) ) {
                    	    case 24:
                    	        {
                    	        alt110=1;
                    	        }
                    	        break;
                    	    case 79:
                    	        {
                    	        alt110=2;
                    	        }
                    	        break;
                    	    case 28:
                    	        {
                    	        alt110=3;
                    	        }
                    	        break;
                    	    case 67:
                    	        {
                    	        alt110=4;
                    	        }
                    	        break;
                    	    case 38:
                    	        {
                    	        alt110=5;
                    	        }
                    	        break;
                    	    case 69:
                    	        {
                    	        alt110=6;
                    	        }
                    	        break;
                    	    case 43:
                    	        {
                    	        alt110=7;
                    	        }
                    	        break;
                    	    case 70:
                    	        {
                    	        alt110=8;
                    	        }
                    	        break;
                    	    case 45:
                    	        {
                    	        alt110=9;
                    	        }
                    	        break;
                    	    case 80:
                    	        {
                    	        alt110=10;
                    	        }
                    	        break;
                    	    case 49:
                    	        {
                    	        alt110=11;
                    	        }
                    	        break;
                    	    case 71:
                    	        {
                    	        alt110=12;
                    	        }
                    	        break;
                    	    case 50:
                    	        {
                    	        alt110=13;
                    	        }
                    	        break;
                    	    case 72:
                    	        {
                    	        alt110=14;
                    	        }
                    	        break;
                    	    case 51:
                    	        {
                    	        alt110=15;
                    	        }
                    	        break;
                    	    case 73:
                    	        {
                    	        alt110=16;
                    	        }
                    	        break;
                    	    case 52:
                    	        {
                    	        alt110=17;
                    	        }
                    	        break;
                    	    case 74:
                    	        {
                    	        alt110=18;
                    	        }
                    	        break;
                    	    default:
                    	        if (state.backtracking>0) {state.failed=true; return current;}
                    	        NoViableAltException nvae =
                    	            new NoViableAltException("", 110, 0, input);

                    	        throw nvae;
                    	    }

                    	    switch (alt110) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3891:3: ( (lv_qualifier_13_0= 'composes' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3891:3: ( (lv_qualifier_13_0= 'composes' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3892:1: (lv_qualifier_13_0= 'composes' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3892:1: (lv_qualifier_13_0= 'composes' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3893:3: lv_qualifier_13_0= 'composes'
                    	            {
                    	            lv_qualifier_13_0=(Token)match(input,24,FollowSets000.FOLLOW_24_in_ruleReferenceCS8420); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_13_0, grammarAccess.getReferenceCSAccess().getQualifierComposesKeyword_6_1_0_0_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_13_0, "composes");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 2 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3907:6: ( (lv_qualifier_14_0= '!composes' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3907:6: ( (lv_qualifier_14_0= '!composes' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3908:1: (lv_qualifier_14_0= '!composes' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3908:1: (lv_qualifier_14_0= '!composes' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3909:3: lv_qualifier_14_0= '!composes'
                    	            {
                    	            lv_qualifier_14_0=(Token)match(input,79,FollowSets000.FOLLOW_79_in_ruleReferenceCS8457); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_14_0, grammarAccess.getReferenceCSAccess().getQualifierComposesKeyword_6_1_0_1_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_14_0, "!composes");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 3 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3923:6: ( (lv_qualifier_15_0= 'derived' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3923:6: ( (lv_qualifier_15_0= 'derived' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3924:1: (lv_qualifier_15_0= 'derived' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3924:1: (lv_qualifier_15_0= 'derived' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3925:3: lv_qualifier_15_0= 'derived'
                    	            {
                    	            lv_qualifier_15_0=(Token)match(input,28,FollowSets000.FOLLOW_28_in_ruleReferenceCS8494); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_15_0, grammarAccess.getReferenceCSAccess().getQualifierDerivedKeyword_6_1_0_2_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_15_0, "derived");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 4 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3939:6: ( (lv_qualifier_16_0= '!derived' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3939:6: ( (lv_qualifier_16_0= '!derived' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3940:1: (lv_qualifier_16_0= '!derived' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3940:1: (lv_qualifier_16_0= '!derived' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3941:3: lv_qualifier_16_0= '!derived'
                    	            {
                    	            lv_qualifier_16_0=(Token)match(input,67,FollowSets000.FOLLOW_67_in_ruleReferenceCS8531); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_16_0, grammarAccess.getReferenceCSAccess().getQualifierDerivedKeyword_6_1_0_3_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_16_0, "!derived");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 5 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3955:6: ( (lv_qualifier_17_0= 'ordered' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3955:6: ( (lv_qualifier_17_0= 'ordered' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3956:1: (lv_qualifier_17_0= 'ordered' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3956:1: (lv_qualifier_17_0= 'ordered' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3957:3: lv_qualifier_17_0= 'ordered'
                    	            {
                    	            lv_qualifier_17_0=(Token)match(input,38,FollowSets000.FOLLOW_38_in_ruleReferenceCS8568); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_17_0, grammarAccess.getReferenceCSAccess().getQualifierOrderedKeyword_6_1_0_4_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_17_0, "ordered");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 6 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3971:6: ( (lv_qualifier_18_0= '!ordered' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3971:6: ( (lv_qualifier_18_0= '!ordered' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3972:1: (lv_qualifier_18_0= '!ordered' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3972:1: (lv_qualifier_18_0= '!ordered' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3973:3: lv_qualifier_18_0= '!ordered'
                    	            {
                    	            lv_qualifier_18_0=(Token)match(input,69,FollowSets000.FOLLOW_69_in_ruleReferenceCS8605); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_18_0, grammarAccess.getReferenceCSAccess().getQualifierOrderedKeyword_6_1_0_5_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_18_0, "!ordered");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 7 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3987:6: ( (lv_qualifier_19_0= 'readonly' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3987:6: ( (lv_qualifier_19_0= 'readonly' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3988:1: (lv_qualifier_19_0= 'readonly' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3988:1: (lv_qualifier_19_0= 'readonly' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:3989:3: lv_qualifier_19_0= 'readonly'
                    	            {
                    	            lv_qualifier_19_0=(Token)match(input,43,FollowSets000.FOLLOW_43_in_ruleReferenceCS8642); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_19_0, grammarAccess.getReferenceCSAccess().getQualifierReadonlyKeyword_6_1_0_6_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_19_0, "readonly");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 8 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4003:6: ( (lv_qualifier_20_0= '!readonly' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4003:6: ( (lv_qualifier_20_0= '!readonly' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4004:1: (lv_qualifier_20_0= '!readonly' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4004:1: (lv_qualifier_20_0= '!readonly' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4005:3: lv_qualifier_20_0= '!readonly'
                    	            {
                    	            lv_qualifier_20_0=(Token)match(input,70,FollowSets000.FOLLOW_70_in_ruleReferenceCS8679); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_20_0, grammarAccess.getReferenceCSAccess().getQualifierReadonlyKeyword_6_1_0_7_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_20_0, "!readonly");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 9 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4019:6: ( (lv_qualifier_21_0= 'resolve' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4019:6: ( (lv_qualifier_21_0= 'resolve' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4020:1: (lv_qualifier_21_0= 'resolve' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4020:1: (lv_qualifier_21_0= 'resolve' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4021:3: lv_qualifier_21_0= 'resolve'
                    	            {
                    	            lv_qualifier_21_0=(Token)match(input,45,FollowSets000.FOLLOW_45_in_ruleReferenceCS8716); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_21_0, grammarAccess.getReferenceCSAccess().getQualifierResolveKeyword_6_1_0_8_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_21_0, "resolve");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 10 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4035:6: ( (lv_qualifier_22_0= '!resolve' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4035:6: ( (lv_qualifier_22_0= '!resolve' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4036:1: (lv_qualifier_22_0= '!resolve' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4036:1: (lv_qualifier_22_0= '!resolve' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4037:3: lv_qualifier_22_0= '!resolve'
                    	            {
                    	            lv_qualifier_22_0=(Token)match(input,80,FollowSets000.FOLLOW_80_in_ruleReferenceCS8753); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_22_0, grammarAccess.getReferenceCSAccess().getQualifierResolveKeyword_6_1_0_9_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_22_0, "!resolve");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 11 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4051:6: ( (lv_qualifier_23_0= 'transient' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4051:6: ( (lv_qualifier_23_0= 'transient' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4052:1: (lv_qualifier_23_0= 'transient' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4052:1: (lv_qualifier_23_0= 'transient' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4053:3: lv_qualifier_23_0= 'transient'
                    	            {
                    	            lv_qualifier_23_0=(Token)match(input,49,FollowSets000.FOLLOW_49_in_ruleReferenceCS8790); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_23_0, grammarAccess.getReferenceCSAccess().getQualifierTransientKeyword_6_1_0_10_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_23_0, "transient");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 12 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4067:6: ( (lv_qualifier_24_0= '!transient' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4067:6: ( (lv_qualifier_24_0= '!transient' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4068:1: (lv_qualifier_24_0= '!transient' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4068:1: (lv_qualifier_24_0= '!transient' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4069:3: lv_qualifier_24_0= '!transient'
                    	            {
                    	            lv_qualifier_24_0=(Token)match(input,71,FollowSets000.FOLLOW_71_in_ruleReferenceCS8827); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_24_0, grammarAccess.getReferenceCSAccess().getQualifierTransientKeyword_6_1_0_11_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_24_0, "!transient");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 13 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4083:6: ( (lv_qualifier_25_0= 'unique' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4083:6: ( (lv_qualifier_25_0= 'unique' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4084:1: (lv_qualifier_25_0= 'unique' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4084:1: (lv_qualifier_25_0= 'unique' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4085:3: lv_qualifier_25_0= 'unique'
                    	            {
                    	            lv_qualifier_25_0=(Token)match(input,50,FollowSets000.FOLLOW_50_in_ruleReferenceCS8864); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_25_0, grammarAccess.getReferenceCSAccess().getQualifierUniqueKeyword_6_1_0_12_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_25_0, "unique");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 14 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4099:6: ( (lv_qualifier_26_0= '!unique' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4099:6: ( (lv_qualifier_26_0= '!unique' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4100:1: (lv_qualifier_26_0= '!unique' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4100:1: (lv_qualifier_26_0= '!unique' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4101:3: lv_qualifier_26_0= '!unique'
                    	            {
                    	            lv_qualifier_26_0=(Token)match(input,72,FollowSets000.FOLLOW_72_in_ruleReferenceCS8901); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_26_0, grammarAccess.getReferenceCSAccess().getQualifierUniqueKeyword_6_1_0_13_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_26_0, "!unique");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 15 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4115:6: ( (lv_qualifier_27_0= 'unsettable' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4115:6: ( (lv_qualifier_27_0= 'unsettable' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4116:1: (lv_qualifier_27_0= 'unsettable' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4116:1: (lv_qualifier_27_0= 'unsettable' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4117:3: lv_qualifier_27_0= 'unsettable'
                    	            {
                    	            lv_qualifier_27_0=(Token)match(input,51,FollowSets000.FOLLOW_51_in_ruleReferenceCS8938); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_27_0, grammarAccess.getReferenceCSAccess().getQualifierUnsettableKeyword_6_1_0_14_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_27_0, "unsettable");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 16 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4131:6: ( (lv_qualifier_28_0= '!unsettable' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4131:6: ( (lv_qualifier_28_0= '!unsettable' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4132:1: (lv_qualifier_28_0= '!unsettable' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4132:1: (lv_qualifier_28_0= '!unsettable' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4133:3: lv_qualifier_28_0= '!unsettable'
                    	            {
                    	            lv_qualifier_28_0=(Token)match(input,73,FollowSets000.FOLLOW_73_in_ruleReferenceCS8975); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_28_0, grammarAccess.getReferenceCSAccess().getQualifierUnsettableKeyword_6_1_0_15_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_28_0, "!unsettable");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 17 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4147:6: ( (lv_qualifier_29_0= 'volatile' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4147:6: ( (lv_qualifier_29_0= 'volatile' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4148:1: (lv_qualifier_29_0= 'volatile' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4148:1: (lv_qualifier_29_0= 'volatile' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4149:3: lv_qualifier_29_0= 'volatile'
                    	            {
                    	            lv_qualifier_29_0=(Token)match(input,52,FollowSets000.FOLLOW_52_in_ruleReferenceCS9012); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_29_0, grammarAccess.getReferenceCSAccess().getQualifierVolatileKeyword_6_1_0_16_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_29_0, "volatile");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;
                    	        case 18 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4163:6: ( (lv_qualifier_30_0= '!volatile' ) )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4163:6: ( (lv_qualifier_30_0= '!volatile' ) )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4164:1: (lv_qualifier_30_0= '!volatile' )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4164:1: (lv_qualifier_30_0= '!volatile' )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4165:3: lv_qualifier_30_0= '!volatile'
                    	            {
                    	            lv_qualifier_30_0=(Token)match(input,74,FollowSets000.FOLLOW_74_in_ruleReferenceCS9049); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                      newLeafNode(lv_qualifier_30_0, grammarAccess.getReferenceCSAccess().getQualifierVolatileKeyword_6_1_0_17_0());
                    	                  
                    	            }
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		addWithLastConsumed(current, "qualifier", lv_qualifier_30_0, "!volatile");
                    	              	    
                    	            }

                    	            }


                    	            }


                    	            }
                    	            break;

                    	    }

                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4178:3: (otherlv_31= ',' )?
                    	    int alt111=2;
                    	    int LA111_0 = input.LA(1);

                    	    if ( (LA111_0==63) ) {
                    	        alt111=1;
                    	    }
                    	    switch (alt111) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4178:5: otherlv_31= ','
                    	            {
                    	            otherlv_31=(Token)match(input,63,FollowSets000.FOLLOW_63_in_ruleReferenceCS9076); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	                  	newLeafNode(otherlv_31, grammarAccess.getReferenceCSAccess().getCommaKeyword_6_1_1());
                    	                  
                    	            }

                    	            }
                    	            break;

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    if ( cnt112 >= 1 ) break loop112;
                    	    if (state.backtracking>0) {state.failed=true; return current;}
                                EarlyExitException eee =
                                    new EarlyExitException(112, input);
                                throw eee;
                        }
                        cnt112++;
                    } while (true);

                    otherlv_32=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleReferenceCS9092); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_32, grammarAccess.getReferenceCSAccess().getRightCurlyBracketKeyword_6_2());
                          
                    }

                    }
                    break;

            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4186:3: ( (otherlv_33= '{' ( ( (lv_ownedAnnotation_34_0= ruleAnnotationElementCS ) ) | (otherlv_35= 'key' ( ( ruleUnrestrictedName ) ) (otherlv_37= ',' ( ( ruleUnrestrictedName ) ) )* otherlv_39= ';' ) | (otherlv_40= 'derivation' ( ruleUnrestrictedName )? otherlv_42= ':' ( (lv_ownedDefaultExpression_43_0= ruleSpecificationCS ) )? otherlv_44= ';' ) | (otherlv_45= 'initial' ( ruleUnrestrictedName )? otherlv_47= ':' ( (lv_ownedDefaultExpression_48_0= ruleSpecificationCS ) )? otherlv_49= ';' ) )* otherlv_50= '}' ) | otherlv_51= ';' )
            int alt120=2;
            int LA120_0 = input.LA(1);

            if ( (LA120_0==64) ) {
                alt120=1;
            }
            else if ( (LA120_0==62) ) {
                alt120=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 120, 0, input);

                throw nvae;
            }
            switch (alt120) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4186:4: (otherlv_33= '{' ( ( (lv_ownedAnnotation_34_0= ruleAnnotationElementCS ) ) | (otherlv_35= 'key' ( ( ruleUnrestrictedName ) ) (otherlv_37= ',' ( ( ruleUnrestrictedName ) ) )* otherlv_39= ';' ) | (otherlv_40= 'derivation' ( ruleUnrestrictedName )? otherlv_42= ':' ( (lv_ownedDefaultExpression_43_0= ruleSpecificationCS ) )? otherlv_44= ';' ) | (otherlv_45= 'initial' ( ruleUnrestrictedName )? otherlv_47= ':' ( (lv_ownedDefaultExpression_48_0= ruleSpecificationCS ) )? otherlv_49= ';' ) )* otherlv_50= '}' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4186:4: (otherlv_33= '{' ( ( (lv_ownedAnnotation_34_0= ruleAnnotationElementCS ) ) | (otherlv_35= 'key' ( ( ruleUnrestrictedName ) ) (otherlv_37= ',' ( ( ruleUnrestrictedName ) ) )* otherlv_39= ';' ) | (otherlv_40= 'derivation' ( ruleUnrestrictedName )? otherlv_42= ':' ( (lv_ownedDefaultExpression_43_0= ruleSpecificationCS ) )? otherlv_44= ';' ) | (otherlv_45= 'initial' ( ruleUnrestrictedName )? otherlv_47= ':' ( (lv_ownedDefaultExpression_48_0= ruleSpecificationCS ) )? otherlv_49= ';' ) )* otherlv_50= '}' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4186:6: otherlv_33= '{' ( ( (lv_ownedAnnotation_34_0= ruleAnnotationElementCS ) ) | (otherlv_35= 'key' ( ( ruleUnrestrictedName ) ) (otherlv_37= ',' ( ( ruleUnrestrictedName ) ) )* otherlv_39= ';' ) | (otherlv_40= 'derivation' ( ruleUnrestrictedName )? otherlv_42= ':' ( (lv_ownedDefaultExpression_43_0= ruleSpecificationCS ) )? otherlv_44= ';' ) | (otherlv_45= 'initial' ( ruleUnrestrictedName )? otherlv_47= ':' ( (lv_ownedDefaultExpression_48_0= ruleSpecificationCS ) )? otherlv_49= ';' ) )* otherlv_50= '}'
                    {
                    otherlv_33=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleReferenceCS9108); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_33, grammarAccess.getReferenceCSAccess().getLeftCurlyBracketKeyword_7_0_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4190:1: ( ( (lv_ownedAnnotation_34_0= ruleAnnotationElementCS ) ) | (otherlv_35= 'key' ( ( ruleUnrestrictedName ) ) (otherlv_37= ',' ( ( ruleUnrestrictedName ) ) )* otherlv_39= ';' ) | (otherlv_40= 'derivation' ( ruleUnrestrictedName )? otherlv_42= ':' ( (lv_ownedDefaultExpression_43_0= ruleSpecificationCS ) )? otherlv_44= ';' ) | (otherlv_45= 'initial' ( ruleUnrestrictedName )? otherlv_47= ':' ( (lv_ownedDefaultExpression_48_0= ruleSpecificationCS ) )? otherlv_49= ';' ) )*
                    loop119:
                    do {
                        int alt119=5;
                        switch ( input.LA(1) ) {
                        case 53:
                        case 54:
                        case 58:
                            {
                            alt119=1;
                            }
                            break;
                        case 35:
                            {
                            alt119=2;
                            }
                            break;
                        case 27:
                            {
                            alt119=3;
                            }
                            break;
                        case 33:
                            {
                            alt119=4;
                            }
                            break;

                        }

                        switch (alt119) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4190:2: ( (lv_ownedAnnotation_34_0= ruleAnnotationElementCS ) )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4190:2: ( (lv_ownedAnnotation_34_0= ruleAnnotationElementCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4191:1: (lv_ownedAnnotation_34_0= ruleAnnotationElementCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4191:1: (lv_ownedAnnotation_34_0= ruleAnnotationElementCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4192:3: lv_ownedAnnotation_34_0= ruleAnnotationElementCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getReferenceCSAccess().getOwnedAnnotationAnnotationElementCSParserRuleCall_7_0_1_0_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleAnnotationElementCS_in_ruleReferenceCS9130);
                    	    lv_ownedAnnotation_34_0=ruleAnnotationElementCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getReferenceCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedAnnotation",
                    	              		lv_ownedAnnotation_34_0, 
                    	              		"AnnotationElementCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 2 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4209:6: (otherlv_35= 'key' ( ( ruleUnrestrictedName ) ) (otherlv_37= ',' ( ( ruleUnrestrictedName ) ) )* otherlv_39= ';' )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4209:6: (otherlv_35= 'key' ( ( ruleUnrestrictedName ) ) (otherlv_37= ',' ( ( ruleUnrestrictedName ) ) )* otherlv_39= ';' )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4209:8: otherlv_35= 'key' ( ( ruleUnrestrictedName ) ) (otherlv_37= ',' ( ( ruleUnrestrictedName ) ) )* otherlv_39= ';'
                    	    {
                    	    otherlv_35=(Token)match(input,35,FollowSets000.FOLLOW_35_in_ruleReferenceCS9149); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_35, grammarAccess.getReferenceCSAccess().getKeyKeyword_7_0_1_1_0());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4213:1: ( ( ruleUnrestrictedName ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4214:1: ( ruleUnrestrictedName )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4214:1: ( ruleUnrestrictedName )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4215:3: ruleUnrestrictedName
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      		  /* */ 
                    	      		
                    	    }
                    	    if ( state.backtracking==0 ) {

                    	      			if (current==null) {
                    	      	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	      	        }
                    	              
                    	    }
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getReferenceCSAccess().getKeysPropertyCrossReference_7_0_1_1_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleReferenceCS9176);
                    	    ruleUnrestrictedName();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }

                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4231:2: (otherlv_37= ',' ( ( ruleUnrestrictedName ) ) )*
                    	    loop114:
                    	    do {
                    	        int alt114=2;
                    	        int LA114_0 = input.LA(1);

                    	        if ( (LA114_0==63) ) {
                    	            alt114=1;
                    	        }


                    	        switch (alt114) {
                    	    	case 1 :
                    	    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4231:4: otherlv_37= ',' ( ( ruleUnrestrictedName ) )
                    	    	    {
                    	    	    otherlv_37=(Token)match(input,63,FollowSets000.FOLLOW_63_in_ruleReferenceCS9189); if (state.failed) return current;
                    	    	    if ( state.backtracking==0 ) {

                    	    	          	newLeafNode(otherlv_37, grammarAccess.getReferenceCSAccess().getCommaKeyword_7_0_1_1_2_0());
                    	    	          
                    	    	    }
                    	    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4235:1: ( ( ruleUnrestrictedName ) )
                    	    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4236:1: ( ruleUnrestrictedName )
                    	    	    {
                    	    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4236:1: ( ruleUnrestrictedName )
                    	    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4237:3: ruleUnrestrictedName
                    	    	    {
                    	    	    if ( state.backtracking==0 ) {
                    	    	       
                    	    	      		  /* */ 
                    	    	      		
                    	    	    }
                    	    	    if ( state.backtracking==0 ) {

                    	    	      			if (current==null) {
                    	    	      	            current = createModelElement(grammarAccess.getReferenceCSRule());
                    	    	      	        }
                    	    	              
                    	    	    }
                    	    	    if ( state.backtracking==0 ) {
                    	    	       
                    	    	      	        newCompositeNode(grammarAccess.getReferenceCSAccess().getKeysPropertyCrossReference_7_0_1_1_2_1_0()); 
                    	    	      	    
                    	    	    }
                    	    	    pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleReferenceCS9216);
                    	    	    ruleUnrestrictedName();

                    	    	    state._fsp--;
                    	    	    if (state.failed) return current;
                    	    	    if ( state.backtracking==0 ) {
                    	    	       
                    	    	      	        afterParserOrEnumRuleCall();
                    	    	      	    
                    	    	    }

                    	    	    }


                    	    	    }


                    	    	    }
                    	    	    break;

                    	    	default :
                    	    	    break loop114;
                    	        }
                    	    } while (true);

                    	    otherlv_39=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleReferenceCS9230); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_39, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_1_3());
                    	          
                    	    }

                    	    }


                    	    }
                    	    break;
                    	case 3 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4258:6: (otherlv_40= 'derivation' ( ruleUnrestrictedName )? otherlv_42= ':' ( (lv_ownedDefaultExpression_43_0= ruleSpecificationCS ) )? otherlv_44= ';' )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4258:6: (otherlv_40= 'derivation' ( ruleUnrestrictedName )? otherlv_42= ':' ( (lv_ownedDefaultExpression_43_0= ruleSpecificationCS ) )? otherlv_44= ';' )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4258:8: otherlv_40= 'derivation' ( ruleUnrestrictedName )? otherlv_42= ':' ( (lv_ownedDefaultExpression_43_0= ruleSpecificationCS ) )? otherlv_44= ';'
                    	    {
                    	    otherlv_40=(Token)match(input,27,FollowSets000.FOLLOW_27_in_ruleReferenceCS9250); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_40, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_2_0());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4262:1: ( ruleUnrestrictedName )?
                    	    int alt115=2;
                    	    int LA115_0 = input.LA(1);

                    	    if ( ((LA115_0>=RULE_SIMPLE_ID && LA115_0<=RULE_ESCAPED_ID)||LA115_0==17||(LA115_0>=19 && LA115_0<=58)) ) {
                    	        alt115=1;
                    	    }
                    	    switch (alt115) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4263:2: ruleUnrestrictedName
                    	            {
                    	            if ( state.backtracking==0 ) {
                    	               
                    	              	  /* */ 
                    	              	
                    	            }
                    	            if ( state.backtracking==0 ) {
                    	               
                    	                      newCompositeNode(grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()); 
                    	                  
                    	            }
                    	            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleReferenceCS9270);
                    	            ruleUnrestrictedName();

                    	            state._fsp--;
                    	            if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {
                    	               
                    	                      afterParserOrEnumRuleCall();
                    	                  
                    	            }

                    	            }
                    	            break;

                    	    }

                    	    otherlv_42=(Token)match(input,61,FollowSets000.FOLLOW_61_in_ruleReferenceCS9283); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_42, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4277:1: ( (lv_ownedDefaultExpression_43_0= ruleSpecificationCS ) )?
                    	    int alt116=2;
                    	    int LA116_0 = input.LA(1);

                    	    if ( ((LA116_0>=RULE_INT && LA116_0<=RULE_SINGLE_QUOTED_STRING)||(LA116_0>=RULE_UNQUOTED_STRING && LA116_0<=RULE_ESCAPED_ID)||(LA116_0>=17 && LA116_0<=59)||LA116_0==77||LA116_0==85||(LA116_0>=97 && LA116_0<=110)||(LA116_0>=114 && LA116_0<=117)||LA116_0==121||LA116_0==125||LA116_0==127) ) {
                    	        alt116=1;
                    	    }
                    	    switch (alt116) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4278:1: (lv_ownedDefaultExpression_43_0= ruleSpecificationCS )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4278:1: (lv_ownedDefaultExpression_43_0= ruleSpecificationCS )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4279:3: lv_ownedDefaultExpression_43_0= ruleSpecificationCS
                    	            {
                    	            if ( state.backtracking==0 ) {
                    	               
                    	              	        newCompositeNode(grammarAccess.getReferenceCSAccess().getOwnedDefaultExpressionSpecificationCSParserRuleCall_7_0_1_2_3_0()); 
                    	              	    
                    	            }
                    	            pushFollow(FollowSets000.FOLLOW_ruleSpecificationCS_in_ruleReferenceCS9304);
                    	            lv_ownedDefaultExpression_43_0=ruleSpecificationCS();

                    	            state._fsp--;
                    	            if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElementForParent(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		add(
                    	                     			current, 
                    	                     			"ownedDefaultExpression",
                    	                      		lv_ownedDefaultExpression_43_0, 
                    	                      		"SpecificationCS");
                    	              	        afterParserOrEnumRuleCall();
                    	              	    
                    	            }

                    	            }


                    	            }
                    	            break;

                    	    }

                    	    otherlv_44=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleReferenceCS9317); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_44, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4());
                    	          
                    	    }

                    	    }


                    	    }
                    	    break;
                    	case 4 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4300:6: (otherlv_45= 'initial' ( ruleUnrestrictedName )? otherlv_47= ':' ( (lv_ownedDefaultExpression_48_0= ruleSpecificationCS ) )? otherlv_49= ';' )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4300:6: (otherlv_45= 'initial' ( ruleUnrestrictedName )? otherlv_47= ':' ( (lv_ownedDefaultExpression_48_0= ruleSpecificationCS ) )? otherlv_49= ';' )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4300:8: otherlv_45= 'initial' ( ruleUnrestrictedName )? otherlv_47= ':' ( (lv_ownedDefaultExpression_48_0= ruleSpecificationCS ) )? otherlv_49= ';'
                    	    {
                    	    otherlv_45=(Token)match(input,33,FollowSets000.FOLLOW_33_in_ruleReferenceCS9337); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_45, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_3_0());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4304:1: ( ruleUnrestrictedName )?
                    	    int alt117=2;
                    	    int LA117_0 = input.LA(1);

                    	    if ( ((LA117_0>=RULE_SIMPLE_ID && LA117_0<=RULE_ESCAPED_ID)||LA117_0==17||(LA117_0>=19 && LA117_0<=58)) ) {
                    	        alt117=1;
                    	    }
                    	    switch (alt117) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4305:2: ruleUnrestrictedName
                    	            {
                    	            if ( state.backtracking==0 ) {
                    	               
                    	              	  /* */ 
                    	              	
                    	            }
                    	            if ( state.backtracking==0 ) {
                    	               
                    	                      newCompositeNode(grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()); 
                    	                  
                    	            }
                    	            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleReferenceCS9357);
                    	            ruleUnrestrictedName();

                    	            state._fsp--;
                    	            if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {
                    	               
                    	                      afterParserOrEnumRuleCall();
                    	                  
                    	            }

                    	            }
                    	            break;

                    	    }

                    	    otherlv_47=(Token)match(input,61,FollowSets000.FOLLOW_61_in_ruleReferenceCS9370); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_47, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4319:1: ( (lv_ownedDefaultExpression_48_0= ruleSpecificationCS ) )?
                    	    int alt118=2;
                    	    int LA118_0 = input.LA(1);

                    	    if ( ((LA118_0>=RULE_INT && LA118_0<=RULE_SINGLE_QUOTED_STRING)||(LA118_0>=RULE_UNQUOTED_STRING && LA118_0<=RULE_ESCAPED_ID)||(LA118_0>=17 && LA118_0<=59)||LA118_0==77||LA118_0==85||(LA118_0>=97 && LA118_0<=110)||(LA118_0>=114 && LA118_0<=117)||LA118_0==121||LA118_0==125||LA118_0==127) ) {
                    	        alt118=1;
                    	    }
                    	    switch (alt118) {
                    	        case 1 :
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4320:1: (lv_ownedDefaultExpression_48_0= ruleSpecificationCS )
                    	            {
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4320:1: (lv_ownedDefaultExpression_48_0= ruleSpecificationCS )
                    	            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4321:3: lv_ownedDefaultExpression_48_0= ruleSpecificationCS
                    	            {
                    	            if ( state.backtracking==0 ) {
                    	               
                    	              	        newCompositeNode(grammarAccess.getReferenceCSAccess().getOwnedDefaultExpressionSpecificationCSParserRuleCall_7_0_1_3_3_0()); 
                    	              	    
                    	            }
                    	            pushFollow(FollowSets000.FOLLOW_ruleSpecificationCS_in_ruleReferenceCS9391);
                    	            lv_ownedDefaultExpression_48_0=ruleSpecificationCS();

                    	            state._fsp--;
                    	            if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	              	        if (current==null) {
                    	              	            current = createModelElementForParent(grammarAccess.getReferenceCSRule());
                    	              	        }
                    	                     		add(
                    	                     			current, 
                    	                     			"ownedDefaultExpression",
                    	                      		lv_ownedDefaultExpression_48_0, 
                    	                      		"SpecificationCS");
                    	              	        afterParserOrEnumRuleCall();
                    	              	    
                    	            }

                    	            }


                    	            }
                    	            break;

                    	    }

                    	    otherlv_49=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleReferenceCS9404); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_49, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4());
                    	          
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop119;
                        }
                    } while (true);

                    otherlv_50=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleReferenceCS9419); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_50, grammarAccess.getReferenceCSAccess().getRightCurlyBracketKeyword_7_0_2());
                          
                    }

                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4346:7: otherlv_51= ';'
                    {
                    otherlv_51=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleReferenceCS9438); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_51, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_1());
                          
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleReferenceCS"


    // $ANTLR start "entryRuleSpecificationCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4358:1: entryRuleSpecificationCS returns [EObject current=null] : iv_ruleSpecificationCS= ruleSpecificationCS EOF ;
    public final EObject entryRuleSpecificationCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleSpecificationCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4359:2: (iv_ruleSpecificationCS= ruleSpecificationCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4360:2: iv_ruleSpecificationCS= ruleSpecificationCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getSpecificationCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleSpecificationCS_in_entryRuleSpecificationCS9475);
            iv_ruleSpecificationCS=ruleSpecificationCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleSpecificationCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleSpecificationCS9485); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleSpecificationCS"


    // $ANTLR start "ruleSpecificationCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4367:1: ruleSpecificationCS returns [EObject current=null] : ( ( (lv_ownedExpression_0_0= ruleExpCS ) ) | ( (lv_exprString_1_0= RULE_UNQUOTED_STRING ) ) ) ;
    public final EObject ruleSpecificationCS() throws RecognitionException {
        EObject current = null;

        Token lv_exprString_1_0=null;
        EObject lv_ownedExpression_0_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4370:28: ( ( ( (lv_ownedExpression_0_0= ruleExpCS ) ) | ( (lv_exprString_1_0= RULE_UNQUOTED_STRING ) ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4371:1: ( ( (lv_ownedExpression_0_0= ruleExpCS ) ) | ( (lv_exprString_1_0= RULE_UNQUOTED_STRING ) ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4371:1: ( ( (lv_ownedExpression_0_0= ruleExpCS ) ) | ( (lv_exprString_1_0= RULE_UNQUOTED_STRING ) ) )
            int alt121=2;
            int LA121_0 = input.LA(1);

            if ( ((LA121_0>=RULE_INT && LA121_0<=RULE_SINGLE_QUOTED_STRING)||(LA121_0>=RULE_SIMPLE_ID && LA121_0<=RULE_ESCAPED_ID)||(LA121_0>=17 && LA121_0<=59)||LA121_0==77||LA121_0==85||(LA121_0>=97 && LA121_0<=110)||(LA121_0>=114 && LA121_0<=117)||LA121_0==121||LA121_0==125||LA121_0==127) ) {
                alt121=1;
            }
            else if ( (LA121_0==RULE_UNQUOTED_STRING) ) {
                alt121=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 121, 0, input);

                throw nvae;
            }
            switch (alt121) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4371:2: ( (lv_ownedExpression_0_0= ruleExpCS ) )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4371:2: ( (lv_ownedExpression_0_0= ruleExpCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4372:1: (lv_ownedExpression_0_0= ruleExpCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4372:1: (lv_ownedExpression_0_0= ruleExpCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4373:3: lv_ownedExpression_0_0= ruleExpCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getSpecificationCSAccess().getOwnedExpressionExpCSParserRuleCall_0_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleExpCS_in_ruleSpecificationCS9531);
                    lv_ownedExpression_0_0=ruleExpCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getSpecificationCSRule());
                      	        }
                             		set(
                             			current, 
                             			"ownedExpression",
                              		lv_ownedExpression_0_0, 
                              		"ExpCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4390:6: ( (lv_exprString_1_0= RULE_UNQUOTED_STRING ) )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4390:6: ( (lv_exprString_1_0= RULE_UNQUOTED_STRING ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4391:1: (lv_exprString_1_0= RULE_UNQUOTED_STRING )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4391:1: (lv_exprString_1_0= RULE_UNQUOTED_STRING )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4392:3: lv_exprString_1_0= RULE_UNQUOTED_STRING
                    {
                    lv_exprString_1_0=(Token)match(input,RULE_UNQUOTED_STRING,FollowSets000.FOLLOW_RULE_UNQUOTED_STRING_in_ruleSpecificationCS9554); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			newLeafNode(lv_exprString_1_0, grammarAccess.getSpecificationCSAccess().getExprStringUNQUOTED_STRINGTerminalRuleCall_1_0()); 
                      		
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getSpecificationCSRule());
                      	        }
                             		setWithLastConsumed(
                             			current, 
                             			"exprString",
                              		lv_exprString_1_0, 
                              		"UNQUOTED_STRING");
                      	    
                    }

                    }


                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleSpecificationCS"


    // $ANTLR start "entryRuleStructuralFeatureCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4416:1: entryRuleStructuralFeatureCS returns [EObject current=null] : iv_ruleStructuralFeatureCS= ruleStructuralFeatureCS EOF ;
    public final EObject entryRuleStructuralFeatureCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleStructuralFeatureCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4417:2: (iv_ruleStructuralFeatureCS= ruleStructuralFeatureCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4418:2: iv_ruleStructuralFeatureCS= ruleStructuralFeatureCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getStructuralFeatureCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleStructuralFeatureCS_in_entryRuleStructuralFeatureCS9595);
            iv_ruleStructuralFeatureCS=ruleStructuralFeatureCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleStructuralFeatureCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleStructuralFeatureCS9605); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleStructuralFeatureCS"


    // $ANTLR start "ruleStructuralFeatureCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4425:1: ruleStructuralFeatureCS returns [EObject current=null] : (this_AttributeCS_0= ruleAttributeCS | this_ReferenceCS_1= ruleReferenceCS ) ;
    public final EObject ruleStructuralFeatureCS() throws RecognitionException {
        EObject current = null;

        EObject this_AttributeCS_0 = null;

        EObject this_ReferenceCS_1 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4428:28: ( (this_AttributeCS_0= ruleAttributeCS | this_ReferenceCS_1= ruleReferenceCS ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4429:1: (this_AttributeCS_0= ruleAttributeCS | this_ReferenceCS_1= ruleReferenceCS )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4429:1: (this_AttributeCS_0= ruleAttributeCS | this_ReferenceCS_1= ruleReferenceCS )
            int alt122=2;
            switch ( input.LA(1) ) {
            case 46:
                {
                switch ( input.LA(2) ) {
                case 26:
                    {
                    int LA122_5 = input.LA(3);

                    if ( (LA122_5==20) ) {
                        alt122=1;
                    }
                    else if ( (LA122_5==42) ) {
                        alt122=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return current;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 122, 5, input);

                        throw nvae;
                    }
                    }
                    break;
                case 20:
                    {
                    alt122=1;
                    }
                    break;
                case 42:
                    {
                    alt122=2;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return current;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 122, 1, input);

                    throw nvae;
                }

                }
                break;
            case 26:
                {
                switch ( input.LA(2) ) {
                case 46:
                    {
                    int LA122_6 = input.LA(3);

                    if ( (LA122_6==20) ) {
                        alt122=1;
                    }
                    else if ( (LA122_6==42) ) {
                        alt122=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return current;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 122, 6, input);

                        throw nvae;
                    }
                    }
                    break;
                case 42:
                    {
                    alt122=2;
                    }
                    break;
                case 20:
                    {
                    alt122=1;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return current;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 122, 2, input);

                    throw nvae;
                }

                }
                break;
            case 20:
                {
                alt122=1;
                }
                break;
            case 42:
                {
                alt122=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 122, 0, input);

                throw nvae;
            }

            switch (alt122) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4430:2: this_AttributeCS_0= ruleAttributeCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getStructuralFeatureCSAccess().getAttributeCSParserRuleCall_0()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleAttributeCS_in_ruleStructuralFeatureCS9655);
                    this_AttributeCS_0=ruleAttributeCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_AttributeCS_0; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4443:2: this_ReferenceCS_1= ruleReferenceCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getStructuralFeatureCSAccess().getReferenceCSParserRuleCall_1()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleReferenceCS_in_ruleStructuralFeatureCS9685);
                    this_ReferenceCS_1=ruleReferenceCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_ReferenceCS_1; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleStructuralFeatureCS"


    // $ANTLR start "entryRuleSysMLCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4462:1: entryRuleSysMLCS returns [EObject current=null] : iv_ruleSysMLCS= ruleSysMLCS EOF ;
    public final EObject entryRuleSysMLCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleSysMLCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4463:2: (iv_ruleSysMLCS= ruleSysMLCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4464:2: iv_ruleSysMLCS= ruleSysMLCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getSysMLCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleSysMLCS_in_entryRuleSysMLCS9720);
            iv_ruleSysMLCS=ruleSysMLCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleSysMLCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleSysMLCS9730); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleSysMLCS"


    // $ANTLR start "ruleSysMLCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4471:1: ruleSysMLCS returns [EObject current=null] : ( () otherlv_1= 'sysml' ( ( ( (lv_ownedDetail_2_0= ruleDetailCS ) ) otherlv_3= ';' ) | (otherlv_4= '{' ( ( (lv_ownedDetail_5_0= ruleDetailCS ) ) otherlv_6= ';' )* otherlv_7= '}' ) ) ) ;
    public final EObject ruleSysMLCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_3=null;
        Token otherlv_4=null;
        Token otherlv_6=null;
        Token otherlv_7=null;
        EObject lv_ownedDetail_2_0 = null;

        EObject lv_ownedDetail_5_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4474:28: ( ( () otherlv_1= 'sysml' ( ( ( (lv_ownedDetail_2_0= ruleDetailCS ) ) otherlv_3= ';' ) | (otherlv_4= '{' ( ( (lv_ownedDetail_5_0= ruleDetailCS ) ) otherlv_6= ';' )* otherlv_7= '}' ) ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4475:1: ( () otherlv_1= 'sysml' ( ( ( (lv_ownedDetail_2_0= ruleDetailCS ) ) otherlv_3= ';' ) | (otherlv_4= '{' ( ( (lv_ownedDetail_5_0= ruleDetailCS ) ) otherlv_6= ';' )* otherlv_7= '}' ) ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4475:1: ( () otherlv_1= 'sysml' ( ( ( (lv_ownedDetail_2_0= ruleDetailCS ) ) otherlv_3= ';' ) | (otherlv_4= '{' ( ( (lv_ownedDetail_5_0= ruleDetailCS ) ) otherlv_6= ';' )* otherlv_7= '}' ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4475:2: () otherlv_1= 'sysml' ( ( ( (lv_ownedDetail_2_0= ruleDetailCS ) ) otherlv_3= ';' ) | (otherlv_4= '{' ( ( (lv_ownedDetail_5_0= ruleDetailCS ) ) otherlv_6= ';' )* otherlv_7= '}' ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4475:2: ()
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4476:2: 
            {
            if ( state.backtracking==0 ) {
               
              	  /* */ 
              	
            }
            if ( state.backtracking==0 ) {

                      current = forceCreateModelElement(
                          grammarAccess.getSysMLCSAccess().getSysMLCSAction_0(),
                          current);
                  
            }

            }

            otherlv_1=(Token)match(input,58,FollowSets000.FOLLOW_58_in_ruleSysMLCS9779); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_1, grammarAccess.getSysMLCSAccess().getSysmlKeyword_1());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4488:1: ( ( ( (lv_ownedDetail_2_0= ruleDetailCS ) ) otherlv_3= ';' ) | (otherlv_4= '{' ( ( (lv_ownedDetail_5_0= ruleDetailCS ) ) otherlv_6= ';' )* otherlv_7= '}' ) )
            int alt124=2;
            int LA124_0 = input.LA(1);

            if ( (LA124_0==RULE_SINGLE_QUOTED_STRING||(LA124_0>=RULE_SIMPLE_ID && LA124_0<=RULE_ESCAPED_ID)||LA124_0==17||(LA124_0>=19 && LA124_0<=58)) ) {
                alt124=1;
            }
            else if ( (LA124_0==64) ) {
                alt124=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 124, 0, input);

                throw nvae;
            }
            switch (alt124) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4488:2: ( ( (lv_ownedDetail_2_0= ruleDetailCS ) ) otherlv_3= ';' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4488:2: ( ( (lv_ownedDetail_2_0= ruleDetailCS ) ) otherlv_3= ';' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4488:3: ( (lv_ownedDetail_2_0= ruleDetailCS ) ) otherlv_3= ';'
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4488:3: ( (lv_ownedDetail_2_0= ruleDetailCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4489:1: (lv_ownedDetail_2_0= ruleDetailCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4489:1: (lv_ownedDetail_2_0= ruleDetailCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4490:3: lv_ownedDetail_2_0= ruleDetailCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getSysMLCSAccess().getOwnedDetailDetailCSParserRuleCall_2_0_0_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleDetailCS_in_ruleSysMLCS9802);
                    lv_ownedDetail_2_0=ruleDetailCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getSysMLCSRule());
                      	        }
                             		add(
                             			current, 
                             			"ownedDetail",
                              		lv_ownedDetail_2_0, 
                              		"DetailCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }

                    otherlv_3=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleSysMLCS9814); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_3, grammarAccess.getSysMLCSAccess().getSemicolonKeyword_2_0_1());
                          
                    }

                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4511:6: (otherlv_4= '{' ( ( (lv_ownedDetail_5_0= ruleDetailCS ) ) otherlv_6= ';' )* otherlv_7= '}' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4511:6: (otherlv_4= '{' ( ( (lv_ownedDetail_5_0= ruleDetailCS ) ) otherlv_6= ';' )* otherlv_7= '}' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4511:8: otherlv_4= '{' ( ( (lv_ownedDetail_5_0= ruleDetailCS ) ) otherlv_6= ';' )* otherlv_7= '}'
                    {
                    otherlv_4=(Token)match(input,64,FollowSets000.FOLLOW_64_in_ruleSysMLCS9834); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_4, grammarAccess.getSysMLCSAccess().getLeftCurlyBracketKeyword_2_1_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4515:1: ( ( (lv_ownedDetail_5_0= ruleDetailCS ) ) otherlv_6= ';' )*
                    loop123:
                    do {
                        int alt123=2;
                        int LA123_0 = input.LA(1);

                        if ( (LA123_0==RULE_SINGLE_QUOTED_STRING||(LA123_0>=RULE_SIMPLE_ID && LA123_0<=RULE_ESCAPED_ID)||LA123_0==17||(LA123_0>=19 && LA123_0<=58)) ) {
                            alt123=1;
                        }


                        switch (alt123) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4515:2: ( (lv_ownedDetail_5_0= ruleDetailCS ) ) otherlv_6= ';'
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4515:2: ( (lv_ownedDetail_5_0= ruleDetailCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4516:1: (lv_ownedDetail_5_0= ruleDetailCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4516:1: (lv_ownedDetail_5_0= ruleDetailCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4517:3: lv_ownedDetail_5_0= ruleDetailCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getSysMLCSAccess().getOwnedDetailDetailCSParserRuleCall_2_1_1_0_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleDetailCS_in_ruleSysMLCS9856);
                    	    lv_ownedDetail_5_0=ruleDetailCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getSysMLCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedDetail",
                    	              		lv_ownedDetail_5_0, 
                    	              		"DetailCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }

                    	    otherlv_6=(Token)match(input,62,FollowSets000.FOLLOW_62_in_ruleSysMLCS9868); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_6, grammarAccess.getSysMLCSAccess().getSemicolonKeyword_2_1_1_1());
                    	          
                    	    }

                    	    }
                    	    break;

                    	default :
                    	    break loop123;
                        }
                    } while (true);

                    otherlv_7=(Token)match(input,65,FollowSets000.FOLLOW_65_in_ruleSysMLCS9882); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_7, grammarAccess.getSysMLCSAccess().getRightCurlyBracketKeyword_2_1_2());
                          
                    }

                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleSysMLCS"


    // $ANTLR start "entryRuleTemplateBindingCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4549:1: entryRuleTemplateBindingCS returns [EObject current=null] : iv_ruleTemplateBindingCS= ruleTemplateBindingCS EOF ;
    public final EObject entryRuleTemplateBindingCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleTemplateBindingCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4550:2: (iv_ruleTemplateBindingCS= ruleTemplateBindingCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4551:2: iv_ruleTemplateBindingCS= ruleTemplateBindingCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getTemplateBindingCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleTemplateBindingCS_in_entryRuleTemplateBindingCS9920);
            iv_ruleTemplateBindingCS=ruleTemplateBindingCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleTemplateBindingCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleTemplateBindingCS9930); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleTemplateBindingCS"


    // $ANTLR start "ruleTemplateBindingCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4558:1: ruleTemplateBindingCS returns [EObject current=null] : ( (otherlv_0= '(' ( (lv_ownedParameterSubstitution_1_0= ruleTemplateParameterSubstitutionCS ) ) (otherlv_2= ',' ( (lv_ownedParameterSubstitution_3_0= ruleTemplateParameterSubstitutionCS ) ) )* otherlv_4= ')' ) | (otherlv_5= '<' ( (lv_ownedParameterSubstitution_6_0= ruleTemplateParameterSubstitutionCS ) ) (otherlv_7= ',' ( (lv_ownedParameterSubstitution_8_0= ruleTemplateParameterSubstitutionCS ) ) )* otherlv_9= '>' ) ) ;
    public final EObject ruleTemplateBindingCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        Token otherlv_5=null;
        Token otherlv_7=null;
        Token otherlv_9=null;
        EObject lv_ownedParameterSubstitution_1_0 = null;

        EObject lv_ownedParameterSubstitution_3_0 = null;

        EObject lv_ownedParameterSubstitution_6_0 = null;

        EObject lv_ownedParameterSubstitution_8_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4561:28: ( ( (otherlv_0= '(' ( (lv_ownedParameterSubstitution_1_0= ruleTemplateParameterSubstitutionCS ) ) (otherlv_2= ',' ( (lv_ownedParameterSubstitution_3_0= ruleTemplateParameterSubstitutionCS ) ) )* otherlv_4= ')' ) | (otherlv_5= '<' ( (lv_ownedParameterSubstitution_6_0= ruleTemplateParameterSubstitutionCS ) ) (otherlv_7= ',' ( (lv_ownedParameterSubstitution_8_0= ruleTemplateParameterSubstitutionCS ) ) )* otherlv_9= '>' ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4562:1: ( (otherlv_0= '(' ( (lv_ownedParameterSubstitution_1_0= ruleTemplateParameterSubstitutionCS ) ) (otherlv_2= ',' ( (lv_ownedParameterSubstitution_3_0= ruleTemplateParameterSubstitutionCS ) ) )* otherlv_4= ')' ) | (otherlv_5= '<' ( (lv_ownedParameterSubstitution_6_0= ruleTemplateParameterSubstitutionCS ) ) (otherlv_7= ',' ( (lv_ownedParameterSubstitution_8_0= ruleTemplateParameterSubstitutionCS ) ) )* otherlv_9= '>' ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4562:1: ( (otherlv_0= '(' ( (lv_ownedParameterSubstitution_1_0= ruleTemplateParameterSubstitutionCS ) ) (otherlv_2= ',' ( (lv_ownedParameterSubstitution_3_0= ruleTemplateParameterSubstitutionCS ) ) )* otherlv_4= ')' ) | (otherlv_5= '<' ( (lv_ownedParameterSubstitution_6_0= ruleTemplateParameterSubstitutionCS ) ) (otherlv_7= ',' ( (lv_ownedParameterSubstitution_8_0= ruleTemplateParameterSubstitutionCS ) ) )* otherlv_9= '>' ) )
            int alt127=2;
            int LA127_0 = input.LA(1);

            if ( (LA127_0==59) ) {
                alt127=1;
            }
            else if ( (LA127_0==81) ) {
                alt127=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 127, 0, input);

                throw nvae;
            }
            switch (alt127) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4562:2: (otherlv_0= '(' ( (lv_ownedParameterSubstitution_1_0= ruleTemplateParameterSubstitutionCS ) ) (otherlv_2= ',' ( (lv_ownedParameterSubstitution_3_0= ruleTemplateParameterSubstitutionCS ) ) )* otherlv_4= ')' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4562:2: (otherlv_0= '(' ( (lv_ownedParameterSubstitution_1_0= ruleTemplateParameterSubstitutionCS ) ) (otherlv_2= ',' ( (lv_ownedParameterSubstitution_3_0= ruleTemplateParameterSubstitutionCS ) ) )* otherlv_4= ')' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4562:4: otherlv_0= '(' ( (lv_ownedParameterSubstitution_1_0= ruleTemplateParameterSubstitutionCS ) ) (otherlv_2= ',' ( (lv_ownedParameterSubstitution_3_0= ruleTemplateParameterSubstitutionCS ) ) )* otherlv_4= ')'
                    {
                    otherlv_0=(Token)match(input,59,FollowSets000.FOLLOW_59_in_ruleTemplateBindingCS9968); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_0, grammarAccess.getTemplateBindingCSAccess().getLeftParenthesisKeyword_0_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4566:1: ( (lv_ownedParameterSubstitution_1_0= ruleTemplateParameterSubstitutionCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4567:1: (lv_ownedParameterSubstitution_1_0= ruleTemplateParameterSubstitutionCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4567:1: (lv_ownedParameterSubstitution_1_0= ruleTemplateParameterSubstitutionCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4568:3: lv_ownedParameterSubstitution_1_0= ruleTemplateParameterSubstitutionCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getTemplateBindingCSAccess().getOwnedParameterSubstitutionTemplateParameterSubstitutionCSParserRuleCall_0_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTemplateParameterSubstitutionCS_in_ruleTemplateBindingCS9989);
                    lv_ownedParameterSubstitution_1_0=ruleTemplateParameterSubstitutionCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getTemplateBindingCSRule());
                      	        }
                             		add(
                             			current, 
                             			"ownedParameterSubstitution",
                              		lv_ownedParameterSubstitution_1_0, 
                              		"TemplateParameterSubstitutionCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4584:2: (otherlv_2= ',' ( (lv_ownedParameterSubstitution_3_0= ruleTemplateParameterSubstitutionCS ) ) )*
                    loop125:
                    do {
                        int alt125=2;
                        int LA125_0 = input.LA(1);

                        if ( (LA125_0==63) ) {
                            alt125=1;
                        }


                        switch (alt125) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4584:4: otherlv_2= ',' ( (lv_ownedParameterSubstitution_3_0= ruleTemplateParameterSubstitutionCS ) )
                    	    {
                    	    otherlv_2=(Token)match(input,63,FollowSets000.FOLLOW_63_in_ruleTemplateBindingCS10002); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_2, grammarAccess.getTemplateBindingCSAccess().getCommaKeyword_0_2_0());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4588:1: ( (lv_ownedParameterSubstitution_3_0= ruleTemplateParameterSubstitutionCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4589:1: (lv_ownedParameterSubstitution_3_0= ruleTemplateParameterSubstitutionCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4589:1: (lv_ownedParameterSubstitution_3_0= ruleTemplateParameterSubstitutionCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4590:3: lv_ownedParameterSubstitution_3_0= ruleTemplateParameterSubstitutionCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getTemplateBindingCSAccess().getOwnedParameterSubstitutionTemplateParameterSubstitutionCSParserRuleCall_0_2_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleTemplateParameterSubstitutionCS_in_ruleTemplateBindingCS10023);
                    	    lv_ownedParameterSubstitution_3_0=ruleTemplateParameterSubstitutionCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getTemplateBindingCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedParameterSubstitution",
                    	              		lv_ownedParameterSubstitution_3_0, 
                    	              		"TemplateParameterSubstitutionCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop125;
                        }
                    } while (true);

                    otherlv_4=(Token)match(input,60,FollowSets000.FOLLOW_60_in_ruleTemplateBindingCS10037); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_4, grammarAccess.getTemplateBindingCSAccess().getRightParenthesisKeyword_0_3());
                          
                    }

                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4611:6: (otherlv_5= '<' ( (lv_ownedParameterSubstitution_6_0= ruleTemplateParameterSubstitutionCS ) ) (otherlv_7= ',' ( (lv_ownedParameterSubstitution_8_0= ruleTemplateParameterSubstitutionCS ) ) )* otherlv_9= '>' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4611:6: (otherlv_5= '<' ( (lv_ownedParameterSubstitution_6_0= ruleTemplateParameterSubstitutionCS ) ) (otherlv_7= ',' ( (lv_ownedParameterSubstitution_8_0= ruleTemplateParameterSubstitutionCS ) ) )* otherlv_9= '>' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4611:8: otherlv_5= '<' ( (lv_ownedParameterSubstitution_6_0= ruleTemplateParameterSubstitutionCS ) ) (otherlv_7= ',' ( (lv_ownedParameterSubstitution_8_0= ruleTemplateParameterSubstitutionCS ) ) )* otherlv_9= '>'
                    {
                    otherlv_5=(Token)match(input,81,FollowSets000.FOLLOW_81_in_ruleTemplateBindingCS10057); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_5, grammarAccess.getTemplateBindingCSAccess().getLessThanSignKeyword_1_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4615:1: ( (lv_ownedParameterSubstitution_6_0= ruleTemplateParameterSubstitutionCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4616:1: (lv_ownedParameterSubstitution_6_0= ruleTemplateParameterSubstitutionCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4616:1: (lv_ownedParameterSubstitution_6_0= ruleTemplateParameterSubstitutionCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4617:3: lv_ownedParameterSubstitution_6_0= ruleTemplateParameterSubstitutionCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getTemplateBindingCSAccess().getOwnedParameterSubstitutionTemplateParameterSubstitutionCSParserRuleCall_1_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTemplateParameterSubstitutionCS_in_ruleTemplateBindingCS10078);
                    lv_ownedParameterSubstitution_6_0=ruleTemplateParameterSubstitutionCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getTemplateBindingCSRule());
                      	        }
                             		add(
                             			current, 
                             			"ownedParameterSubstitution",
                              		lv_ownedParameterSubstitution_6_0, 
                              		"TemplateParameterSubstitutionCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4633:2: (otherlv_7= ',' ( (lv_ownedParameterSubstitution_8_0= ruleTemplateParameterSubstitutionCS ) ) )*
                    loop126:
                    do {
                        int alt126=2;
                        int LA126_0 = input.LA(1);

                        if ( (LA126_0==63) ) {
                            alt126=1;
                        }


                        switch (alt126) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4633:4: otherlv_7= ',' ( (lv_ownedParameterSubstitution_8_0= ruleTemplateParameterSubstitutionCS ) )
                    	    {
                    	    otherlv_7=(Token)match(input,63,FollowSets000.FOLLOW_63_in_ruleTemplateBindingCS10091); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_7, grammarAccess.getTemplateBindingCSAccess().getCommaKeyword_1_2_0());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4637:1: ( (lv_ownedParameterSubstitution_8_0= ruleTemplateParameterSubstitutionCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4638:1: (lv_ownedParameterSubstitution_8_0= ruleTemplateParameterSubstitutionCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4638:1: (lv_ownedParameterSubstitution_8_0= ruleTemplateParameterSubstitutionCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4639:3: lv_ownedParameterSubstitution_8_0= ruleTemplateParameterSubstitutionCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getTemplateBindingCSAccess().getOwnedParameterSubstitutionTemplateParameterSubstitutionCSParserRuleCall_1_2_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleTemplateParameterSubstitutionCS_in_ruleTemplateBindingCS10112);
                    	    lv_ownedParameterSubstitution_8_0=ruleTemplateParameterSubstitutionCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getTemplateBindingCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedParameterSubstitution",
                    	              		lv_ownedParameterSubstitution_8_0, 
                    	              		"TemplateParameterSubstitutionCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop126;
                        }
                    } while (true);

                    otherlv_9=(Token)match(input,82,FollowSets000.FOLLOW_82_in_ruleTemplateBindingCS10126); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_9, grammarAccess.getTemplateBindingCSAccess().getGreaterThanSignKeyword_1_3());
                          
                    }

                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleTemplateBindingCS"


    // $ANTLR start "entryRuleTemplateParameterSubstitutionCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4667:1: entryRuleTemplateParameterSubstitutionCS returns [EObject current=null] : iv_ruleTemplateParameterSubstitutionCS= ruleTemplateParameterSubstitutionCS EOF ;
    public final EObject entryRuleTemplateParameterSubstitutionCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleTemplateParameterSubstitutionCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4668:2: (iv_ruleTemplateParameterSubstitutionCS= ruleTemplateParameterSubstitutionCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4669:2: iv_ruleTemplateParameterSubstitutionCS= ruleTemplateParameterSubstitutionCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getTemplateParameterSubstitutionCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleTemplateParameterSubstitutionCS_in_entryRuleTemplateParameterSubstitutionCS10163);
            iv_ruleTemplateParameterSubstitutionCS=ruleTemplateParameterSubstitutionCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleTemplateParameterSubstitutionCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleTemplateParameterSubstitutionCS10173); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleTemplateParameterSubstitutionCS"


    // $ANTLR start "ruleTemplateParameterSubstitutionCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4676:1: ruleTemplateParameterSubstitutionCS returns [EObject current=null] : ( (lv_ownedActualParameter_0_0= ruleTypeRefCS ) ) ;
    public final EObject ruleTemplateParameterSubstitutionCS() throws RecognitionException {
        EObject current = null;

        EObject lv_ownedActualParameter_0_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4679:28: ( ( (lv_ownedActualParameter_0_0= ruleTypeRefCS ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4680:1: ( (lv_ownedActualParameter_0_0= ruleTypeRefCS ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4680:1: ( (lv_ownedActualParameter_0_0= ruleTypeRefCS ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4681:1: (lv_ownedActualParameter_0_0= ruleTypeRefCS )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4681:1: (lv_ownedActualParameter_0_0= ruleTypeRefCS )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4682:3: lv_ownedActualParameter_0_0= ruleTypeRefCS
            {
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getTemplateParameterSubstitutionCSAccess().getOwnedActualParameterTypeRefCSParserRuleCall_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_ruleTypeRefCS_in_ruleTemplateParameterSubstitutionCS10218);
            lv_ownedActualParameter_0_0=ruleTypeRefCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElementForParent(grammarAccess.getTemplateParameterSubstitutionCSRule());
              	        }
                     		set(
                     			current, 
                     			"ownedActualParameter",
                      		lv_ownedActualParameter_0_0, 
                      		"TypeRefCS");
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleTemplateParameterSubstitutionCS"


    // $ANTLR start "entryRuleTemplateSignatureCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4706:1: entryRuleTemplateSignatureCS returns [EObject current=null] : iv_ruleTemplateSignatureCS= ruleTemplateSignatureCS EOF ;
    public final EObject entryRuleTemplateSignatureCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleTemplateSignatureCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4707:2: (iv_ruleTemplateSignatureCS= ruleTemplateSignatureCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4708:2: iv_ruleTemplateSignatureCS= ruleTemplateSignatureCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getTemplateSignatureCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleTemplateSignatureCS_in_entryRuleTemplateSignatureCS10253);
            iv_ruleTemplateSignatureCS=ruleTemplateSignatureCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleTemplateSignatureCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleTemplateSignatureCS10263); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleTemplateSignatureCS"


    // $ANTLR start "ruleTemplateSignatureCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4715:1: ruleTemplateSignatureCS returns [EObject current=null] : ( (otherlv_0= '(' ( (lv_ownedTemplateParameter_1_0= ruleTypeParameterCS ) ) (otherlv_2= ',' ( (lv_ownedTemplateParameter_3_0= ruleTypeParameterCS ) ) )* otherlv_4= ')' ) | (otherlv_5= '<' ( (lv_ownedTemplateParameter_6_0= ruleTypeParameterCS ) ) (otherlv_7= ',' ( (lv_ownedTemplateParameter_8_0= ruleTypeParameterCS ) ) )* otherlv_9= '>' ) ) ;
    public final EObject ruleTemplateSignatureCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        Token otherlv_5=null;
        Token otherlv_7=null;
        Token otherlv_9=null;
        EObject lv_ownedTemplateParameter_1_0 = null;

        EObject lv_ownedTemplateParameter_3_0 = null;

        EObject lv_ownedTemplateParameter_6_0 = null;

        EObject lv_ownedTemplateParameter_8_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4718:28: ( ( (otherlv_0= '(' ( (lv_ownedTemplateParameter_1_0= ruleTypeParameterCS ) ) (otherlv_2= ',' ( (lv_ownedTemplateParameter_3_0= ruleTypeParameterCS ) ) )* otherlv_4= ')' ) | (otherlv_5= '<' ( (lv_ownedTemplateParameter_6_0= ruleTypeParameterCS ) ) (otherlv_7= ',' ( (lv_ownedTemplateParameter_8_0= ruleTypeParameterCS ) ) )* otherlv_9= '>' ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4719:1: ( (otherlv_0= '(' ( (lv_ownedTemplateParameter_1_0= ruleTypeParameterCS ) ) (otherlv_2= ',' ( (lv_ownedTemplateParameter_3_0= ruleTypeParameterCS ) ) )* otherlv_4= ')' ) | (otherlv_5= '<' ( (lv_ownedTemplateParameter_6_0= ruleTypeParameterCS ) ) (otherlv_7= ',' ( (lv_ownedTemplateParameter_8_0= ruleTypeParameterCS ) ) )* otherlv_9= '>' ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4719:1: ( (otherlv_0= '(' ( (lv_ownedTemplateParameter_1_0= ruleTypeParameterCS ) ) (otherlv_2= ',' ( (lv_ownedTemplateParameter_3_0= ruleTypeParameterCS ) ) )* otherlv_4= ')' ) | (otherlv_5= '<' ( (lv_ownedTemplateParameter_6_0= ruleTypeParameterCS ) ) (otherlv_7= ',' ( (lv_ownedTemplateParameter_8_0= ruleTypeParameterCS ) ) )* otherlv_9= '>' ) )
            int alt130=2;
            int LA130_0 = input.LA(1);

            if ( (LA130_0==59) ) {
                alt130=1;
            }
            else if ( (LA130_0==81) ) {
                alt130=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 130, 0, input);

                throw nvae;
            }
            switch (alt130) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4719:2: (otherlv_0= '(' ( (lv_ownedTemplateParameter_1_0= ruleTypeParameterCS ) ) (otherlv_2= ',' ( (lv_ownedTemplateParameter_3_0= ruleTypeParameterCS ) ) )* otherlv_4= ')' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4719:2: (otherlv_0= '(' ( (lv_ownedTemplateParameter_1_0= ruleTypeParameterCS ) ) (otherlv_2= ',' ( (lv_ownedTemplateParameter_3_0= ruleTypeParameterCS ) ) )* otherlv_4= ')' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4719:4: otherlv_0= '(' ( (lv_ownedTemplateParameter_1_0= ruleTypeParameterCS ) ) (otherlv_2= ',' ( (lv_ownedTemplateParameter_3_0= ruleTypeParameterCS ) ) )* otherlv_4= ')'
                    {
                    otherlv_0=(Token)match(input,59,FollowSets000.FOLLOW_59_in_ruleTemplateSignatureCS10301); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_0, grammarAccess.getTemplateSignatureCSAccess().getLeftParenthesisKeyword_0_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4723:1: ( (lv_ownedTemplateParameter_1_0= ruleTypeParameterCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4724:1: (lv_ownedTemplateParameter_1_0= ruleTypeParameterCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4724:1: (lv_ownedTemplateParameter_1_0= ruleTypeParameterCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4725:3: lv_ownedTemplateParameter_1_0= ruleTypeParameterCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getTemplateSignatureCSAccess().getOwnedTemplateParameterTypeParameterCSParserRuleCall_0_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTypeParameterCS_in_ruleTemplateSignatureCS10322);
                    lv_ownedTemplateParameter_1_0=ruleTypeParameterCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getTemplateSignatureCSRule());
                      	        }
                             		add(
                             			current, 
                             			"ownedTemplateParameter",
                              		lv_ownedTemplateParameter_1_0, 
                              		"TypeParameterCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4741:2: (otherlv_2= ',' ( (lv_ownedTemplateParameter_3_0= ruleTypeParameterCS ) ) )*
                    loop128:
                    do {
                        int alt128=2;
                        int LA128_0 = input.LA(1);

                        if ( (LA128_0==63) ) {
                            alt128=1;
                        }


                        switch (alt128) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4741:4: otherlv_2= ',' ( (lv_ownedTemplateParameter_3_0= ruleTypeParameterCS ) )
                    	    {
                    	    otherlv_2=(Token)match(input,63,FollowSets000.FOLLOW_63_in_ruleTemplateSignatureCS10335); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_2, grammarAccess.getTemplateSignatureCSAccess().getCommaKeyword_0_2_0());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4745:1: ( (lv_ownedTemplateParameter_3_0= ruleTypeParameterCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4746:1: (lv_ownedTemplateParameter_3_0= ruleTypeParameterCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4746:1: (lv_ownedTemplateParameter_3_0= ruleTypeParameterCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4747:3: lv_ownedTemplateParameter_3_0= ruleTypeParameterCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getTemplateSignatureCSAccess().getOwnedTemplateParameterTypeParameterCSParserRuleCall_0_2_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleTypeParameterCS_in_ruleTemplateSignatureCS10356);
                    	    lv_ownedTemplateParameter_3_0=ruleTypeParameterCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getTemplateSignatureCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedTemplateParameter",
                    	              		lv_ownedTemplateParameter_3_0, 
                    	              		"TypeParameterCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop128;
                        }
                    } while (true);

                    otherlv_4=(Token)match(input,60,FollowSets000.FOLLOW_60_in_ruleTemplateSignatureCS10370); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_4, grammarAccess.getTemplateSignatureCSAccess().getRightParenthesisKeyword_0_3());
                          
                    }

                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4768:6: (otherlv_5= '<' ( (lv_ownedTemplateParameter_6_0= ruleTypeParameterCS ) ) (otherlv_7= ',' ( (lv_ownedTemplateParameter_8_0= ruleTypeParameterCS ) ) )* otherlv_9= '>' )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4768:6: (otherlv_5= '<' ( (lv_ownedTemplateParameter_6_0= ruleTypeParameterCS ) ) (otherlv_7= ',' ( (lv_ownedTemplateParameter_8_0= ruleTypeParameterCS ) ) )* otherlv_9= '>' )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4768:8: otherlv_5= '<' ( (lv_ownedTemplateParameter_6_0= ruleTypeParameterCS ) ) (otherlv_7= ',' ( (lv_ownedTemplateParameter_8_0= ruleTypeParameterCS ) ) )* otherlv_9= '>'
                    {
                    otherlv_5=(Token)match(input,81,FollowSets000.FOLLOW_81_in_ruleTemplateSignatureCS10390); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_5, grammarAccess.getTemplateSignatureCSAccess().getLessThanSignKeyword_1_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4772:1: ( (lv_ownedTemplateParameter_6_0= ruleTypeParameterCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4773:1: (lv_ownedTemplateParameter_6_0= ruleTypeParameterCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4773:1: (lv_ownedTemplateParameter_6_0= ruleTypeParameterCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4774:3: lv_ownedTemplateParameter_6_0= ruleTypeParameterCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getTemplateSignatureCSAccess().getOwnedTemplateParameterTypeParameterCSParserRuleCall_1_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTypeParameterCS_in_ruleTemplateSignatureCS10411);
                    lv_ownedTemplateParameter_6_0=ruleTypeParameterCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getTemplateSignatureCSRule());
                      	        }
                             		add(
                             			current, 
                             			"ownedTemplateParameter",
                              		lv_ownedTemplateParameter_6_0, 
                              		"TypeParameterCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4790:2: (otherlv_7= ',' ( (lv_ownedTemplateParameter_8_0= ruleTypeParameterCS ) ) )*
                    loop129:
                    do {
                        int alt129=2;
                        int LA129_0 = input.LA(1);

                        if ( (LA129_0==63) ) {
                            alt129=1;
                        }


                        switch (alt129) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4790:4: otherlv_7= ',' ( (lv_ownedTemplateParameter_8_0= ruleTypeParameterCS ) )
                    	    {
                    	    otherlv_7=(Token)match(input,63,FollowSets000.FOLLOW_63_in_ruleTemplateSignatureCS10424); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_7, grammarAccess.getTemplateSignatureCSAccess().getCommaKeyword_1_2_0());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4794:1: ( (lv_ownedTemplateParameter_8_0= ruleTypeParameterCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4795:1: (lv_ownedTemplateParameter_8_0= ruleTypeParameterCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4795:1: (lv_ownedTemplateParameter_8_0= ruleTypeParameterCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4796:3: lv_ownedTemplateParameter_8_0= ruleTypeParameterCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getTemplateSignatureCSAccess().getOwnedTemplateParameterTypeParameterCSParserRuleCall_1_2_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleTypeParameterCS_in_ruleTemplateSignatureCS10445);
                    	    lv_ownedTemplateParameter_8_0=ruleTypeParameterCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getTemplateSignatureCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedTemplateParameter",
                    	              		lv_ownedTemplateParameter_8_0, 
                    	              		"TypeParameterCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop129;
                        }
                    } while (true);

                    otherlv_9=(Token)match(input,82,FollowSets000.FOLLOW_82_in_ruleTemplateSignatureCS10459); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_9, grammarAccess.getTemplateSignatureCSAccess().getGreaterThanSignKeyword_1_3());
                          
                    }

                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleTemplateSignatureCS"


    // $ANTLR start "entryRuleTypeParameterCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4826:1: entryRuleTypeParameterCS returns [EObject current=null] : iv_ruleTypeParameterCS= ruleTypeParameterCS EOF ;
    public final EObject entryRuleTypeParameterCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleTypeParameterCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4827:2: (iv_ruleTypeParameterCS= ruleTypeParameterCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4828:2: iv_ruleTypeParameterCS= ruleTypeParameterCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getTypeParameterCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleTypeParameterCS_in_entryRuleTypeParameterCS10498);
            iv_ruleTypeParameterCS=ruleTypeParameterCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleTypeParameterCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleTypeParameterCS10508); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleTypeParameterCS"


    // $ANTLR start "ruleTypeParameterCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4835:1: ruleTypeParameterCS returns [EObject current=null] : ( ( (lv_name_0_0= ruleUnrestrictedName ) ) ( (otherlv_1= 'extends' ( (lv_ownedExtends_2_0= ruleTypedRefCS ) ) (otherlv_3= '&&' ( (lv_ownedExtends_4_0= ruleTypedRefCS ) ) )* ) | (otherlv_5= 'super' ( (lv_ownedSuper_6_0= ruleTypedRefCS ) ) ) )? ) ;
    public final EObject ruleTypeParameterCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        AntlrDatatypeRuleToken lv_name_0_0 = null;

        EObject lv_ownedExtends_2_0 = null;

        EObject lv_ownedExtends_4_0 = null;

        EObject lv_ownedSuper_6_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4838:28: ( ( ( (lv_name_0_0= ruleUnrestrictedName ) ) ( (otherlv_1= 'extends' ( (lv_ownedExtends_2_0= ruleTypedRefCS ) ) (otherlv_3= '&&' ( (lv_ownedExtends_4_0= ruleTypedRefCS ) ) )* ) | (otherlv_5= 'super' ( (lv_ownedSuper_6_0= ruleTypedRefCS ) ) ) )? ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4839:1: ( ( (lv_name_0_0= ruleUnrestrictedName ) ) ( (otherlv_1= 'extends' ( (lv_ownedExtends_2_0= ruleTypedRefCS ) ) (otherlv_3= '&&' ( (lv_ownedExtends_4_0= ruleTypedRefCS ) ) )* ) | (otherlv_5= 'super' ( (lv_ownedSuper_6_0= ruleTypedRefCS ) ) ) )? )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4839:1: ( ( (lv_name_0_0= ruleUnrestrictedName ) ) ( (otherlv_1= 'extends' ( (lv_ownedExtends_2_0= ruleTypedRefCS ) ) (otherlv_3= '&&' ( (lv_ownedExtends_4_0= ruleTypedRefCS ) ) )* ) | (otherlv_5= 'super' ( (lv_ownedSuper_6_0= ruleTypedRefCS ) ) ) )? )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4839:2: ( (lv_name_0_0= ruleUnrestrictedName ) ) ( (otherlv_1= 'extends' ( (lv_ownedExtends_2_0= ruleTypedRefCS ) ) (otherlv_3= '&&' ( (lv_ownedExtends_4_0= ruleTypedRefCS ) ) )* ) | (otherlv_5= 'super' ( (lv_ownedSuper_6_0= ruleTypedRefCS ) ) ) )?
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4839:2: ( (lv_name_0_0= ruleUnrestrictedName ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4840:1: (lv_name_0_0= ruleUnrestrictedName )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4840:1: (lv_name_0_0= ruleUnrestrictedName )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4841:3: lv_name_0_0= ruleUnrestrictedName
            {
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getTypeParameterCSAccess().getNameUnrestrictedNameParserRuleCall_0_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleTypeParameterCS10554);
            lv_name_0_0=ruleUnrestrictedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElementForParent(grammarAccess.getTypeParameterCSRule());
              	        }
                     		set(
                     			current, 
                     			"name",
                      		lv_name_0_0, 
                      		"UnrestrictedName");
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4857:2: ( (otherlv_1= 'extends' ( (lv_ownedExtends_2_0= ruleTypedRefCS ) ) (otherlv_3= '&&' ( (lv_ownedExtends_4_0= ruleTypedRefCS ) ) )* ) | (otherlv_5= 'super' ( (lv_ownedSuper_6_0= ruleTypedRefCS ) ) ) )?
            int alt132=3;
            int LA132_0 = input.LA(1);

            if ( (LA132_0==30) ) {
                alt132=1;
            }
            else if ( (LA132_0==47) ) {
                alt132=2;
            }
            switch (alt132) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4857:3: (otherlv_1= 'extends' ( (lv_ownedExtends_2_0= ruleTypedRefCS ) ) (otherlv_3= '&&' ( (lv_ownedExtends_4_0= ruleTypedRefCS ) ) )* )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4857:3: (otherlv_1= 'extends' ( (lv_ownedExtends_2_0= ruleTypedRefCS ) ) (otherlv_3= '&&' ( (lv_ownedExtends_4_0= ruleTypedRefCS ) ) )* )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4857:5: otherlv_1= 'extends' ( (lv_ownedExtends_2_0= ruleTypedRefCS ) ) (otherlv_3= '&&' ( (lv_ownedExtends_4_0= ruleTypedRefCS ) ) )*
                    {
                    otherlv_1=(Token)match(input,30,FollowSets000.FOLLOW_30_in_ruleTypeParameterCS10568); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_1, grammarAccess.getTypeParameterCSAccess().getExtendsKeyword_1_0_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4861:1: ( (lv_ownedExtends_2_0= ruleTypedRefCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4862:1: (lv_ownedExtends_2_0= ruleTypedRefCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4862:1: (lv_ownedExtends_2_0= ruleTypedRefCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4863:3: lv_ownedExtends_2_0= ruleTypedRefCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getTypeParameterCSAccess().getOwnedExtendsTypedRefCSParserRuleCall_1_0_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTypedRefCS_in_ruleTypeParameterCS10589);
                    lv_ownedExtends_2_0=ruleTypedRefCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getTypeParameterCSRule());
                      	        }
                             		add(
                             			current, 
                             			"ownedExtends",
                              		lv_ownedExtends_2_0, 
                              		"TypedRefCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }

                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4879:2: (otherlv_3= '&&' ( (lv_ownedExtends_4_0= ruleTypedRefCS ) ) )*
                    loop131:
                    do {
                        int alt131=2;
                        int LA131_0 = input.LA(1);

                        if ( (LA131_0==83) ) {
                            alt131=1;
                        }


                        switch (alt131) {
                    	case 1 :
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4879:4: otherlv_3= '&&' ( (lv_ownedExtends_4_0= ruleTypedRefCS ) )
                    	    {
                    	    otherlv_3=(Token)match(input,83,FollowSets000.FOLLOW_83_in_ruleTypeParameterCS10602); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	          	newLeafNode(otherlv_3, grammarAccess.getTypeParameterCSAccess().getAmpersandAmpersandKeyword_1_0_2_0());
                    	          
                    	    }
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4883:1: ( (lv_ownedExtends_4_0= ruleTypedRefCS ) )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4884:1: (lv_ownedExtends_4_0= ruleTypedRefCS )
                    	    {
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4884:1: (lv_ownedExtends_4_0= ruleTypedRefCS )
                    	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4885:3: lv_ownedExtends_4_0= ruleTypedRefCS
                    	    {
                    	    if ( state.backtracking==0 ) {
                    	       
                    	      	        newCompositeNode(grammarAccess.getTypeParameterCSAccess().getOwnedExtendsTypedRefCSParserRuleCall_1_0_2_1_0()); 
                    	      	    
                    	    }
                    	    pushFollow(FollowSets000.FOLLOW_ruleTypedRefCS_in_ruleTypeParameterCS10623);
                    	    lv_ownedExtends_4_0=ruleTypedRefCS();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      	        if (current==null) {
                    	      	            current = createModelElementForParent(grammarAccess.getTypeParameterCSRule());
                    	      	        }
                    	             		add(
                    	             			current, 
                    	             			"ownedExtends",
                    	              		lv_ownedExtends_4_0, 
                    	              		"TypedRefCS");
                    	      	        afterParserOrEnumRuleCall();
                    	      	    
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop131;
                        }
                    } while (true);


                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4902:6: (otherlv_5= 'super' ( (lv_ownedSuper_6_0= ruleTypedRefCS ) ) )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4902:6: (otherlv_5= 'super' ( (lv_ownedSuper_6_0= ruleTypedRefCS ) ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4902:8: otherlv_5= 'super' ( (lv_ownedSuper_6_0= ruleTypedRefCS ) )
                    {
                    otherlv_5=(Token)match(input,47,FollowSets000.FOLLOW_47_in_ruleTypeParameterCS10645); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_5, grammarAccess.getTypeParameterCSAccess().getSuperKeyword_1_1_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4906:1: ( (lv_ownedSuper_6_0= ruleTypedRefCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4907:1: (lv_ownedSuper_6_0= ruleTypedRefCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4907:1: (lv_ownedSuper_6_0= ruleTypedRefCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4908:3: lv_ownedSuper_6_0= ruleTypedRefCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getTypeParameterCSAccess().getOwnedSuperTypedRefCSParserRuleCall_1_1_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTypedRefCS_in_ruleTypeParameterCS10666);
                    lv_ownedSuper_6_0=ruleTypedRefCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getTypeParameterCSRule());
                      	        }
                             		set(
                             			current, 
                             			"ownedSuper",
                              		lv_ownedSuper_6_0, 
                              		"TypedRefCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleTypeParameterCS"


    // $ANTLR start "entryRuleTypeRefCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4932:1: entryRuleTypeRefCS returns [EObject current=null] : iv_ruleTypeRefCS= ruleTypeRefCS EOF ;
    public final EObject entryRuleTypeRefCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleTypeRefCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4933:2: (iv_ruleTypeRefCS= ruleTypeRefCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4934:2: iv_ruleTypeRefCS= ruleTypeRefCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getTypeRefCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleTypeRefCS_in_entryRuleTypeRefCS10705);
            iv_ruleTypeRefCS=ruleTypeRefCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleTypeRefCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleTypeRefCS10715); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleTypeRefCS"


    // $ANTLR start "ruleTypeRefCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4941:1: ruleTypeRefCS returns [EObject current=null] : (this_TypedRefCS_0= ruleTypedRefCS | this_WildcardTypeRefCS_1= ruleWildcardTypeRefCS ) ;
    public final EObject ruleTypeRefCS() throws RecognitionException {
        EObject current = null;

        EObject this_TypedRefCS_0 = null;

        EObject this_WildcardTypeRefCS_1 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4944:28: ( (this_TypedRefCS_0= ruleTypedRefCS | this_WildcardTypeRefCS_1= ruleWildcardTypeRefCS ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4945:1: (this_TypedRefCS_0= ruleTypedRefCS | this_WildcardTypeRefCS_1= ruleWildcardTypeRefCS )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4945:1: (this_TypedRefCS_0= ruleTypedRefCS | this_WildcardTypeRefCS_1= ruleWildcardTypeRefCS )
            int alt133=2;
            int LA133_0 = input.LA(1);

            if ( ((LA133_0>=RULE_SIMPLE_ID && LA133_0<=RULE_ESCAPED_ID)||LA133_0==17||(LA133_0>=19 && LA133_0<=58)||(LA133_0>=97 && LA133_0<=110)) ) {
                alt133=1;
            }
            else if ( (LA133_0==84) ) {
                alt133=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 133, 0, input);

                throw nvae;
            }
            switch (alt133) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4946:2: this_TypedRefCS_0= ruleTypedRefCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getTypeRefCSAccess().getTypedRefCSParserRuleCall_0()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTypedRefCS_in_ruleTypeRefCS10765);
                    this_TypedRefCS_0=ruleTypedRefCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_TypedRefCS_0; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4959:2: this_WildcardTypeRefCS_1= ruleWildcardTypeRefCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getTypeRefCSAccess().getWildcardTypeRefCSParserRuleCall_1()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleWildcardTypeRefCS_in_ruleTypeRefCS10795);
                    this_WildcardTypeRefCS_1=ruleWildcardTypeRefCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_WildcardTypeRefCS_1; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleTypeRefCS"


    // $ANTLR start "entryRuleTypedRefCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4978:1: entryRuleTypedRefCS returns [EObject current=null] : iv_ruleTypedRefCS= ruleTypedRefCS EOF ;
    public final EObject entryRuleTypedRefCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleTypedRefCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4979:2: (iv_ruleTypedRefCS= ruleTypedRefCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4980:2: iv_ruleTypedRefCS= ruleTypedRefCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getTypedRefCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleTypedRefCS_in_entryRuleTypedRefCS10830);
            iv_ruleTypedRefCS=ruleTypedRefCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleTypedRefCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleTypedRefCS10840); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleTypedRefCS"


    // $ANTLR start "ruleTypedRefCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4987:1: ruleTypedRefCS returns [EObject current=null] : (this_TypeLiteralCS_0= ruleTypeLiteralCS | this_TypedTypeRefCS_1= ruleTypedTypeRefCS ) ;
    public final EObject ruleTypedRefCS() throws RecognitionException {
        EObject current = null;

        EObject this_TypeLiteralCS_0 = null;

        EObject this_TypedTypeRefCS_1 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4990:28: ( (this_TypeLiteralCS_0= ruleTypeLiteralCS | this_TypedTypeRefCS_1= ruleTypedTypeRefCS ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4991:1: (this_TypeLiteralCS_0= ruleTypeLiteralCS | this_TypedTypeRefCS_1= ruleTypedTypeRefCS )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4991:1: (this_TypeLiteralCS_0= ruleTypeLiteralCS | this_TypedTypeRefCS_1= ruleTypedTypeRefCS )
            int alt134=2;
            int LA134_0 = input.LA(1);

            if ( ((LA134_0>=97 && LA134_0<=110)) ) {
                alt134=1;
            }
            else if ( ((LA134_0>=RULE_SIMPLE_ID && LA134_0<=RULE_ESCAPED_ID)||LA134_0==17||(LA134_0>=19 && LA134_0<=58)) ) {
                alt134=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 134, 0, input);

                throw nvae;
            }
            switch (alt134) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:4992:2: this_TypeLiteralCS_0= ruleTypeLiteralCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getTypedRefCSAccess().getTypeLiteralCSParserRuleCall_0()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTypeLiteralCS_in_ruleTypedRefCS10890);
                    this_TypeLiteralCS_0=ruleTypeLiteralCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_TypeLiteralCS_0; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5005:2: this_TypedTypeRefCS_1= ruleTypedTypeRefCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getTypedRefCSAccess().getTypedTypeRefCSParserRuleCall_1()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTypedTypeRefCS_in_ruleTypedRefCS10920);
                    this_TypedTypeRefCS_1=ruleTypedTypeRefCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_TypedTypeRefCS_1; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleTypedRefCS"


    // $ANTLR start "entryRuleTypedMultiplicityRefCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5024:1: entryRuleTypedMultiplicityRefCS returns [EObject current=null] : iv_ruleTypedMultiplicityRefCS= ruleTypedMultiplicityRefCS EOF ;
    public final EObject entryRuleTypedMultiplicityRefCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleTypedMultiplicityRefCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5025:2: (iv_ruleTypedMultiplicityRefCS= ruleTypedMultiplicityRefCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5026:2: iv_ruleTypedMultiplicityRefCS= ruleTypedMultiplicityRefCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getTypedMultiplicityRefCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleTypedMultiplicityRefCS_in_entryRuleTypedMultiplicityRefCS10955);
            iv_ruleTypedMultiplicityRefCS=ruleTypedMultiplicityRefCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleTypedMultiplicityRefCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleTypedMultiplicityRefCS10965); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleTypedMultiplicityRefCS"


    // $ANTLR start "ruleTypedMultiplicityRefCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5033:1: ruleTypedMultiplicityRefCS returns [EObject current=null] : (this_TypedRefCS_0= ruleTypedRefCS ( (lv_multiplicity_1_0= ruleMultiplicityCS ) )? ) ;
    public final EObject ruleTypedMultiplicityRefCS() throws RecognitionException {
        EObject current = null;

        EObject this_TypedRefCS_0 = null;

        EObject lv_multiplicity_1_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5036:28: ( (this_TypedRefCS_0= ruleTypedRefCS ( (lv_multiplicity_1_0= ruleMultiplicityCS ) )? ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5037:1: (this_TypedRefCS_0= ruleTypedRefCS ( (lv_multiplicity_1_0= ruleMultiplicityCS ) )? )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5037:1: (this_TypedRefCS_0= ruleTypedRefCS ( (lv_multiplicity_1_0= ruleMultiplicityCS ) )? )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5038:2: this_TypedRefCS_0= ruleTypedRefCS ( (lv_multiplicity_1_0= ruleMultiplicityCS ) )?
            {
            if ( state.backtracking==0 ) {
               
              	  /* */ 
              	
            }
            if ( state.backtracking==0 ) {
               
                      newCompositeNode(grammarAccess.getTypedMultiplicityRefCSAccess().getTypedRefCSParserRuleCall_0()); 
                  
            }
            pushFollow(FollowSets000.FOLLOW_ruleTypedRefCS_in_ruleTypedMultiplicityRefCS11015);
            this_TypedRefCS_0=ruleTypedRefCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               
                      current = this_TypedRefCS_0; 
                      afterParserOrEnumRuleCall();
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5049:1: ( (lv_multiplicity_1_0= ruleMultiplicityCS ) )?
            int alt135=2;
            int LA135_0 = input.LA(1);

            if ( (LA135_0==112) ) {
                alt135=1;
            }
            switch (alt135) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5050:1: (lv_multiplicity_1_0= ruleMultiplicityCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5050:1: (lv_multiplicity_1_0= ruleMultiplicityCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5051:3: lv_multiplicity_1_0= ruleMultiplicityCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getTypedMultiplicityRefCSAccess().getMultiplicityMultiplicityCSParserRuleCall_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleMultiplicityCS_in_ruleTypedMultiplicityRefCS11035);
                    lv_multiplicity_1_0=ruleMultiplicityCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getTypedMultiplicityRefCSRule());
                      	        }
                             		set(
                             			current, 
                             			"multiplicity",
                              		lv_multiplicity_1_0, 
                              		"MultiplicityCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleTypedMultiplicityRefCS"


    // $ANTLR start "entryRuleTypedTypeRefCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5075:1: entryRuleTypedTypeRefCS returns [EObject current=null] : iv_ruleTypedTypeRefCS= ruleTypedTypeRefCS EOF ;
    public final EObject entryRuleTypedTypeRefCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleTypedTypeRefCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5076:2: (iv_ruleTypedTypeRefCS= ruleTypedTypeRefCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5077:2: iv_ruleTypedTypeRefCS= ruleTypedTypeRefCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getTypedTypeRefCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleTypedTypeRefCS_in_entryRuleTypedTypeRefCS11072);
            iv_ruleTypedTypeRefCS=ruleTypedTypeRefCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleTypedTypeRefCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleTypedTypeRefCS11082); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleTypedTypeRefCS"


    // $ANTLR start "ruleTypedTypeRefCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5084:1: ruleTypedTypeRefCS returns [EObject current=null] : ( ( (lv_pathName_0_0= rulePathNameCS ) ) ( (lv_ownedTemplateBinding_1_0= ruleTemplateBindingCS ) )? ) ;
    public final EObject ruleTypedTypeRefCS() throws RecognitionException {
        EObject current = null;

        EObject lv_pathName_0_0 = null;

        EObject lv_ownedTemplateBinding_1_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5087:28: ( ( ( (lv_pathName_0_0= rulePathNameCS ) ) ( (lv_ownedTemplateBinding_1_0= ruleTemplateBindingCS ) )? ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5088:1: ( ( (lv_pathName_0_0= rulePathNameCS ) ) ( (lv_ownedTemplateBinding_1_0= ruleTemplateBindingCS ) )? )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5088:1: ( ( (lv_pathName_0_0= rulePathNameCS ) ) ( (lv_ownedTemplateBinding_1_0= ruleTemplateBindingCS ) )? )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5088:2: ( (lv_pathName_0_0= rulePathNameCS ) ) ( (lv_ownedTemplateBinding_1_0= ruleTemplateBindingCS ) )?
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5088:2: ( (lv_pathName_0_0= rulePathNameCS ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5089:1: (lv_pathName_0_0= rulePathNameCS )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5089:1: (lv_pathName_0_0= rulePathNameCS )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5090:3: lv_pathName_0_0= rulePathNameCS
            {
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getTypedTypeRefCSAccess().getPathNamePathNameCSParserRuleCall_0_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_rulePathNameCS_in_ruleTypedTypeRefCS11128);
            lv_pathName_0_0=rulePathNameCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElementForParent(grammarAccess.getTypedTypeRefCSRule());
              	        }
                     		set(
                     			current, 
                     			"pathName",
                      		lv_pathName_0_0, 
                      		"PathNameCS");
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5106:2: ( (lv_ownedTemplateBinding_1_0= ruleTemplateBindingCS ) )?
            int alt136=2;
            int LA136_0 = input.LA(1);

            if ( (LA136_0==59||LA136_0==81) ) {
                alt136=1;
            }
            switch (alt136) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5107:1: (lv_ownedTemplateBinding_1_0= ruleTemplateBindingCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5107:1: (lv_ownedTemplateBinding_1_0= ruleTemplateBindingCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5108:3: lv_ownedTemplateBinding_1_0= ruleTemplateBindingCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getTypedTypeRefCSAccess().getOwnedTemplateBindingTemplateBindingCSParserRuleCall_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTemplateBindingCS_in_ruleTypedTypeRefCS11149);
                    lv_ownedTemplateBinding_1_0=ruleTemplateBindingCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getTypedTypeRefCSRule());
                      	        }
                             		set(
                             			current, 
                             			"ownedTemplateBinding",
                              		lv_ownedTemplateBinding_1_0, 
                              		"TemplateBindingCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleTypedTypeRefCS"


    // $ANTLR start "entryRuleWildcardTypeRefCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5132:1: entryRuleWildcardTypeRefCS returns [EObject current=null] : iv_ruleWildcardTypeRefCS= ruleWildcardTypeRefCS EOF ;
    public final EObject entryRuleWildcardTypeRefCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleWildcardTypeRefCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5133:2: (iv_ruleWildcardTypeRefCS= ruleWildcardTypeRefCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5134:2: iv_ruleWildcardTypeRefCS= ruleWildcardTypeRefCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getWildcardTypeRefCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleWildcardTypeRefCS_in_entryRuleWildcardTypeRefCS11186);
            iv_ruleWildcardTypeRefCS=ruleWildcardTypeRefCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleWildcardTypeRefCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleWildcardTypeRefCS11196); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleWildcardTypeRefCS"


    // $ANTLR start "ruleWildcardTypeRefCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5141:1: ruleWildcardTypeRefCS returns [EObject current=null] : ( () otherlv_1= '?' ( (otherlv_2= 'extends' ( (lv_extends_3_0= ruleTypedRefCS ) ) ) | (otherlv_4= 'super' ( (lv_super_5_0= ruleTypedRefCS ) ) ) )? ) ;
    public final EObject ruleWildcardTypeRefCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        EObject lv_extends_3_0 = null;

        EObject lv_super_5_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5144:28: ( ( () otherlv_1= '?' ( (otherlv_2= 'extends' ( (lv_extends_3_0= ruleTypedRefCS ) ) ) | (otherlv_4= 'super' ( (lv_super_5_0= ruleTypedRefCS ) ) ) )? ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5145:1: ( () otherlv_1= '?' ( (otherlv_2= 'extends' ( (lv_extends_3_0= ruleTypedRefCS ) ) ) | (otherlv_4= 'super' ( (lv_super_5_0= ruleTypedRefCS ) ) ) )? )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5145:1: ( () otherlv_1= '?' ( (otherlv_2= 'extends' ( (lv_extends_3_0= ruleTypedRefCS ) ) ) | (otherlv_4= 'super' ( (lv_super_5_0= ruleTypedRefCS ) ) ) )? )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5145:2: () otherlv_1= '?' ( (otherlv_2= 'extends' ( (lv_extends_3_0= ruleTypedRefCS ) ) ) | (otherlv_4= 'super' ( (lv_super_5_0= ruleTypedRefCS ) ) ) )?
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5145:2: ()
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5146:2: 
            {
            if ( state.backtracking==0 ) {
               
              	  /* */ 
              	
            }
            if ( state.backtracking==0 ) {

                      current = forceCreateModelElement(
                          grammarAccess.getWildcardTypeRefCSAccess().getWildcardTypeRefCSAction_0(),
                          current);
                  
            }

            }

            otherlv_1=(Token)match(input,84,FollowSets000.FOLLOW_84_in_ruleWildcardTypeRefCS11245); if (state.failed) return current;
            if ( state.backtracking==0 ) {

                  	newLeafNode(otherlv_1, grammarAccess.getWildcardTypeRefCSAccess().getQuestionMarkKeyword_1());
                  
            }
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5158:1: ( (otherlv_2= 'extends' ( (lv_extends_3_0= ruleTypedRefCS ) ) ) | (otherlv_4= 'super' ( (lv_super_5_0= ruleTypedRefCS ) ) ) )?
            int alt137=3;
            int LA137_0 = input.LA(1);

            if ( (LA137_0==30) ) {
                alt137=1;
            }
            else if ( (LA137_0==47) ) {
                alt137=2;
            }
            switch (alt137) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5158:2: (otherlv_2= 'extends' ( (lv_extends_3_0= ruleTypedRefCS ) ) )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5158:2: (otherlv_2= 'extends' ( (lv_extends_3_0= ruleTypedRefCS ) ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5158:4: otherlv_2= 'extends' ( (lv_extends_3_0= ruleTypedRefCS ) )
                    {
                    otherlv_2=(Token)match(input,30,FollowSets000.FOLLOW_30_in_ruleWildcardTypeRefCS11259); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_2, grammarAccess.getWildcardTypeRefCSAccess().getExtendsKeyword_2_0_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5162:1: ( (lv_extends_3_0= ruleTypedRefCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5163:1: (lv_extends_3_0= ruleTypedRefCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5163:1: (lv_extends_3_0= ruleTypedRefCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5164:3: lv_extends_3_0= ruleTypedRefCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getWildcardTypeRefCSAccess().getExtendsTypedRefCSParserRuleCall_2_0_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTypedRefCS_in_ruleWildcardTypeRefCS11280);
                    lv_extends_3_0=ruleTypedRefCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getWildcardTypeRefCSRule());
                      	        }
                             		set(
                             			current, 
                             			"extends",
                              		lv_extends_3_0, 
                              		"TypedRefCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }


                    }


                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5181:6: (otherlv_4= 'super' ( (lv_super_5_0= ruleTypedRefCS ) ) )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5181:6: (otherlv_4= 'super' ( (lv_super_5_0= ruleTypedRefCS ) ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5181:8: otherlv_4= 'super' ( (lv_super_5_0= ruleTypedRefCS ) )
                    {
                    otherlv_4=(Token)match(input,47,FollowSets000.FOLLOW_47_in_ruleWildcardTypeRefCS11300); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                          	newLeafNode(otherlv_4, grammarAccess.getWildcardTypeRefCSAccess().getSuperKeyword_2_1_0());
                          
                    }
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5185:1: ( (lv_super_5_0= ruleTypedRefCS ) )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5186:1: (lv_super_5_0= ruleTypedRefCS )
                    {
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5186:1: (lv_super_5_0= ruleTypedRefCS )
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5187:3: lv_super_5_0= ruleTypedRefCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	        newCompositeNode(grammarAccess.getWildcardTypeRefCSAccess().getSuperTypedRefCSParserRuleCall_2_1_1_0()); 
                      	    
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleTypedRefCS_in_ruleWildcardTypeRefCS11321);
                    lv_super_5_0=ruleTypedRefCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElementForParent(grammarAccess.getWildcardTypeRefCSRule());
                      	        }
                             		set(
                             			current, 
                             			"super",
                              		lv_super_5_0, 
                              		"TypedRefCS");
                      	        afterParserOrEnumRuleCall();
                      	    
                    }

                    }


                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleWildcardTypeRefCS"


    // $ANTLR start "entryRuleID"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5213:1: entryRuleID returns [String current=null] : iv_ruleID= ruleID EOF ;
    public final String entryRuleID() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleID = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5214:2: (iv_ruleID= ruleID EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5215:2: iv_ruleID= ruleID EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getIDRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleID_in_entryRuleID11363);
            iv_ruleID=ruleID();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleID.getText(); 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleID11374); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleID"


    // $ANTLR start "ruleID"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5222:1: ruleID returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (this_SIMPLE_ID_0= RULE_SIMPLE_ID | this_ESCAPED_ID_1= RULE_ESCAPED_ID ) ;
    public final AntlrDatatypeRuleToken ruleID() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token this_SIMPLE_ID_0=null;
        Token this_ESCAPED_ID_1=null;

         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5225:28: ( (this_SIMPLE_ID_0= RULE_SIMPLE_ID | this_ESCAPED_ID_1= RULE_ESCAPED_ID ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5226:1: (this_SIMPLE_ID_0= RULE_SIMPLE_ID | this_ESCAPED_ID_1= RULE_ESCAPED_ID )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5226:1: (this_SIMPLE_ID_0= RULE_SIMPLE_ID | this_ESCAPED_ID_1= RULE_ESCAPED_ID )
            int alt138=2;
            int LA138_0 = input.LA(1);

            if ( (LA138_0==RULE_SIMPLE_ID) ) {
                alt138=1;
            }
            else if ( (LA138_0==RULE_ESCAPED_ID) ) {
                alt138=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 138, 0, input);

                throw nvae;
            }
            switch (alt138) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5226:6: this_SIMPLE_ID_0= RULE_SIMPLE_ID
                    {
                    this_SIMPLE_ID_0=(Token)match(input,RULE_SIMPLE_ID,FollowSets000.FOLLOW_RULE_SIMPLE_ID_in_ruleID11414); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      		current.merge(this_SIMPLE_ID_0);
                          
                    }
                    if ( state.backtracking==0 ) {
                       
                          newLeafNode(this_SIMPLE_ID_0, grammarAccess.getIDAccess().getSIMPLE_IDTerminalRuleCall_0()); 
                          
                    }

                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5234:10: this_ESCAPED_ID_1= RULE_ESCAPED_ID
                    {
                    this_ESCAPED_ID_1=(Token)match(input,RULE_ESCAPED_ID,FollowSets000.FOLLOW_RULE_ESCAPED_ID_in_ruleID11440); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      		current.merge(this_ESCAPED_ID_1);
                          
                    }
                    if ( state.backtracking==0 ) {
                       
                          newLeafNode(this_ESCAPED_ID_1, grammarAccess.getIDAccess().getESCAPED_IDTerminalRuleCall_1()); 
                          
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleID"


    // $ANTLR start "entryRuleLOWER"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5249:1: entryRuleLOWER returns [String current=null] : iv_ruleLOWER= ruleLOWER EOF ;
    public final String entryRuleLOWER() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleLOWER = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5250:2: (iv_ruleLOWER= ruleLOWER EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5251:2: iv_ruleLOWER= ruleLOWER EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getLOWERRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleLOWER_in_entryRuleLOWER11486);
            iv_ruleLOWER=ruleLOWER();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleLOWER.getText(); 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleLOWER11497); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleLOWER"


    // $ANTLR start "ruleLOWER"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5258:1: ruleLOWER returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : this_INT_0= RULE_INT ;
    public final AntlrDatatypeRuleToken ruleLOWER() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token this_INT_0=null;

         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5261:28: (this_INT_0= RULE_INT )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5262:5: this_INT_0= RULE_INT
            {
            this_INT_0=(Token)match(input,RULE_INT,FollowSets000.FOLLOW_RULE_INT_in_ruleLOWER11536); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              		current.merge(this_INT_0);
                  
            }
            if ( state.backtracking==0 ) {
               
                  newLeafNode(this_INT_0, grammarAccess.getLOWERAccess().getINTTerminalRuleCall()); 
                  
            }

            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleLOWER"


    // $ANTLR start "entryRuleUPPER"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5277:1: entryRuleUPPER returns [String current=null] : iv_ruleUPPER= ruleUPPER EOF ;
    public final String entryRuleUPPER() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleUPPER = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5278:2: (iv_ruleUPPER= ruleUPPER EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5279:2: iv_ruleUPPER= ruleUPPER EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getUPPERRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleUPPER_in_entryRuleUPPER11581);
            iv_ruleUPPER=ruleUPPER();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleUPPER.getText(); 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleUPPER11592); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleUPPER"


    // $ANTLR start "ruleUPPER"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5286:1: ruleUPPER returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (this_INT_0= RULE_INT | kw= '*' ) ;
    public final AntlrDatatypeRuleToken ruleUPPER() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token this_INT_0=null;
        Token kw=null;

         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5289:28: ( (this_INT_0= RULE_INT | kw= '*' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5290:1: (this_INT_0= RULE_INT | kw= '*' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5290:1: (this_INT_0= RULE_INT | kw= '*' )
            int alt139=2;
            int LA139_0 = input.LA(1);

            if ( (LA139_0==RULE_INT) ) {
                alt139=1;
            }
            else if ( (LA139_0==77) ) {
                alt139=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 139, 0, input);

                throw nvae;
            }
            switch (alt139) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5290:6: this_INT_0= RULE_INT
                    {
                    this_INT_0=(Token)match(input,RULE_INT,FollowSets000.FOLLOW_RULE_INT_in_ruleUPPER11632); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      		current.merge(this_INT_0);
                          
                    }
                    if ( state.backtracking==0 ) {
                       
                          newLeafNode(this_INT_0, grammarAccess.getUPPERAccess().getINTTerminalRuleCall_0()); 
                          
                    }

                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5299:2: kw= '*'
                    {
                    kw=(Token)match(input,77,FollowSets000.FOLLOW_77_in_ruleUPPER11656); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getUPPERAccess().getAsteriskKeyword_1()); 
                          
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleUPPER"


    // $ANTLR start "entryRuleNUMBER_LITERAL"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5312:1: entryRuleNUMBER_LITERAL returns [String current=null] : iv_ruleNUMBER_LITERAL= ruleNUMBER_LITERAL EOF ;
    public final String entryRuleNUMBER_LITERAL() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleNUMBER_LITERAL = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5313:2: (iv_ruleNUMBER_LITERAL= ruleNUMBER_LITERAL EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5314:2: iv_ruleNUMBER_LITERAL= ruleNUMBER_LITERAL EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getNUMBER_LITERALRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleNUMBER_LITERAL_in_entryRuleNUMBER_LITERAL11697);
            iv_ruleNUMBER_LITERAL=ruleNUMBER_LITERAL();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleNUMBER_LITERAL.getText(); 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleNUMBER_LITERAL11708); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleNUMBER_LITERAL"


    // $ANTLR start "ruleNUMBER_LITERAL"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5321:1: ruleNUMBER_LITERAL returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : this_INT_0= RULE_INT ;
    public final AntlrDatatypeRuleToken ruleNUMBER_LITERAL() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token this_INT_0=null;

         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5324:28: (this_INT_0= RULE_INT )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5325:5: this_INT_0= RULE_INT
            {
            this_INT_0=(Token)match(input,RULE_INT,FollowSets000.FOLLOW_RULE_INT_in_ruleNUMBER_LITERAL11747); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              		current.merge(this_INT_0);
                  
            }
            if ( state.backtracking==0 ) {
               
                  newLeafNode(this_INT_0, grammarAccess.getNUMBER_LITERALAccess().getINTTerminalRuleCall()); 
                  
            }

            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleNUMBER_LITERAL"


    // $ANTLR start "entryRuleURI"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5340:1: entryRuleURI returns [String current=null] : iv_ruleURI= ruleURI EOF ;
    public final String entryRuleURI() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleURI = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5341:2: (iv_ruleURI= ruleURI EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5342:2: iv_ruleURI= ruleURI EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getURIRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleURI_in_entryRuleURI11792);
            iv_ruleURI=ruleURI();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleURI.getText(); 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleURI11803); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleURI"


    // $ANTLR start "ruleURI"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5349:1: ruleURI returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : this_SINGLE_QUOTED_STRING_0= RULE_SINGLE_QUOTED_STRING ;
    public final AntlrDatatypeRuleToken ruleURI() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token this_SINGLE_QUOTED_STRING_0=null;

         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5352:28: (this_SINGLE_QUOTED_STRING_0= RULE_SINGLE_QUOTED_STRING )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5353:5: this_SINGLE_QUOTED_STRING_0= RULE_SINGLE_QUOTED_STRING
            {
            this_SINGLE_QUOTED_STRING_0=(Token)match(input,RULE_SINGLE_QUOTED_STRING,FollowSets000.FOLLOW_RULE_SINGLE_QUOTED_STRING_in_ruleURI11842); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              		current.merge(this_SINGLE_QUOTED_STRING_0);
                  
            }
            if ( state.backtracking==0 ) {
               
                  newLeafNode(this_SINGLE_QUOTED_STRING_0, grammarAccess.getURIAccess().getSINGLE_QUOTED_STRINGTerminalRuleCall()); 
                  
            }

            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleURI"


    // $ANTLR start "entryRuleEssentialOCLUnaryOperatorCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5370:1: entryRuleEssentialOCLUnaryOperatorCS returns [EObject current=null] : iv_ruleEssentialOCLUnaryOperatorCS= ruleEssentialOCLUnaryOperatorCS EOF ;
    public final EObject entryRuleEssentialOCLUnaryOperatorCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleEssentialOCLUnaryOperatorCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5371:2: (iv_ruleEssentialOCLUnaryOperatorCS= ruleEssentialOCLUnaryOperatorCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5372:2: iv_ruleEssentialOCLUnaryOperatorCS= ruleEssentialOCLUnaryOperatorCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getEssentialOCLUnaryOperatorCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleEssentialOCLUnaryOperatorCS_in_entryRuleEssentialOCLUnaryOperatorCS11888);
            iv_ruleEssentialOCLUnaryOperatorCS=ruleEssentialOCLUnaryOperatorCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleEssentialOCLUnaryOperatorCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleEssentialOCLUnaryOperatorCS11898); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleEssentialOCLUnaryOperatorCS"


    // $ANTLR start "ruleEssentialOCLUnaryOperatorCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5379:1: ruleEssentialOCLUnaryOperatorCS returns [EObject current=null] : ( ( (lv_name_0_1= '-' | lv_name_0_2= 'not' ) ) ) ;
    public final EObject ruleEssentialOCLUnaryOperatorCS() throws RecognitionException {
        EObject current = null;

        Token lv_name_0_1=null;
        Token lv_name_0_2=null;

         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5382:28: ( ( ( (lv_name_0_1= '-' | lv_name_0_2= 'not' ) ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5383:1: ( ( (lv_name_0_1= '-' | lv_name_0_2= 'not' ) ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5383:1: ( ( (lv_name_0_1= '-' | lv_name_0_2= 'not' ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5384:1: ( (lv_name_0_1= '-' | lv_name_0_2= 'not' ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5384:1: ( (lv_name_0_1= '-' | lv_name_0_2= 'not' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5385:1: (lv_name_0_1= '-' | lv_name_0_2= 'not' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5385:1: (lv_name_0_1= '-' | lv_name_0_2= 'not' )
            int alt140=2;
            int LA140_0 = input.LA(1);

            if ( (LA140_0==18) ) {
                alt140=1;
            }
            else if ( (LA140_0==85) ) {
                alt140=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 140, 0, input);

                throw nvae;
            }
            switch (alt140) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5386:3: lv_name_0_1= '-'
                    {
                    lv_name_0_1=(Token)match(input,18,FollowSets000.FOLLOW_18_in_ruleEssentialOCLUnaryOperatorCS11942); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_1, grammarAccess.getEssentialOCLUnaryOperatorCSAccess().getNameHyphenMinusKeyword_0_0());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLUnaryOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_1, null);
                      	    
                    }

                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5398:8: lv_name_0_2= 'not'
                    {
                    lv_name_0_2=(Token)match(input,85,FollowSets000.FOLLOW_85_in_ruleEssentialOCLUnaryOperatorCS11971); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_2, grammarAccess.getEssentialOCLUnaryOperatorCSAccess().getNameNotKeyword_0_1());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLUnaryOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_2, null);
                      	    
                    }

                    }
                    break;

            }


            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleEssentialOCLUnaryOperatorCS"


    // $ANTLR start "entryRuleEssentialOCLInfixOperatorCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5421:1: entryRuleEssentialOCLInfixOperatorCS returns [EObject current=null] : iv_ruleEssentialOCLInfixOperatorCS= ruleEssentialOCLInfixOperatorCS EOF ;
    public final EObject entryRuleEssentialOCLInfixOperatorCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleEssentialOCLInfixOperatorCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5422:2: (iv_ruleEssentialOCLInfixOperatorCS= ruleEssentialOCLInfixOperatorCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5423:2: iv_ruleEssentialOCLInfixOperatorCS= ruleEssentialOCLInfixOperatorCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getEssentialOCLInfixOperatorCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleEssentialOCLInfixOperatorCS_in_entryRuleEssentialOCLInfixOperatorCS12022);
            iv_ruleEssentialOCLInfixOperatorCS=ruleEssentialOCLInfixOperatorCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleEssentialOCLInfixOperatorCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleEssentialOCLInfixOperatorCS12032); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleEssentialOCLInfixOperatorCS"


    // $ANTLR start "ruleEssentialOCLInfixOperatorCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5430:1: ruleEssentialOCLInfixOperatorCS returns [EObject current=null] : ( ( (lv_name_0_1= '*' | lv_name_0_2= '/' | lv_name_0_3= '+' | lv_name_0_4= '-' | lv_name_0_5= '>' | lv_name_0_6= '<' | lv_name_0_7= '>=' | lv_name_0_8= '<=' | lv_name_0_9= '=' | lv_name_0_10= '<>' | lv_name_0_11= 'and' | lv_name_0_12= 'or' | lv_name_0_13= 'xor' | lv_name_0_14= 'implies' ) ) ) ;
    public final EObject ruleEssentialOCLInfixOperatorCS() throws RecognitionException {
        EObject current = null;

        Token lv_name_0_1=null;
        Token lv_name_0_2=null;
        Token lv_name_0_3=null;
        Token lv_name_0_4=null;
        Token lv_name_0_5=null;
        Token lv_name_0_6=null;
        Token lv_name_0_7=null;
        Token lv_name_0_8=null;
        Token lv_name_0_9=null;
        Token lv_name_0_10=null;
        Token lv_name_0_11=null;
        Token lv_name_0_12=null;
        Token lv_name_0_13=null;
        Token lv_name_0_14=null;

         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5433:28: ( ( ( (lv_name_0_1= '*' | lv_name_0_2= '/' | lv_name_0_3= '+' | lv_name_0_4= '-' | lv_name_0_5= '>' | lv_name_0_6= '<' | lv_name_0_7= '>=' | lv_name_0_8= '<=' | lv_name_0_9= '=' | lv_name_0_10= '<>' | lv_name_0_11= 'and' | lv_name_0_12= 'or' | lv_name_0_13= 'xor' | lv_name_0_14= 'implies' ) ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5434:1: ( ( (lv_name_0_1= '*' | lv_name_0_2= '/' | lv_name_0_3= '+' | lv_name_0_4= '-' | lv_name_0_5= '>' | lv_name_0_6= '<' | lv_name_0_7= '>=' | lv_name_0_8= '<=' | lv_name_0_9= '=' | lv_name_0_10= '<>' | lv_name_0_11= 'and' | lv_name_0_12= 'or' | lv_name_0_13= 'xor' | lv_name_0_14= 'implies' ) ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5434:1: ( ( (lv_name_0_1= '*' | lv_name_0_2= '/' | lv_name_0_3= '+' | lv_name_0_4= '-' | lv_name_0_5= '>' | lv_name_0_6= '<' | lv_name_0_7= '>=' | lv_name_0_8= '<=' | lv_name_0_9= '=' | lv_name_0_10= '<>' | lv_name_0_11= 'and' | lv_name_0_12= 'or' | lv_name_0_13= 'xor' | lv_name_0_14= 'implies' ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5435:1: ( (lv_name_0_1= '*' | lv_name_0_2= '/' | lv_name_0_3= '+' | lv_name_0_4= '-' | lv_name_0_5= '>' | lv_name_0_6= '<' | lv_name_0_7= '>=' | lv_name_0_8= '<=' | lv_name_0_9= '=' | lv_name_0_10= '<>' | lv_name_0_11= 'and' | lv_name_0_12= 'or' | lv_name_0_13= 'xor' | lv_name_0_14= 'implies' ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5435:1: ( (lv_name_0_1= '*' | lv_name_0_2= '/' | lv_name_0_3= '+' | lv_name_0_4= '-' | lv_name_0_5= '>' | lv_name_0_6= '<' | lv_name_0_7= '>=' | lv_name_0_8= '<=' | lv_name_0_9= '=' | lv_name_0_10= '<>' | lv_name_0_11= 'and' | lv_name_0_12= 'or' | lv_name_0_13= 'xor' | lv_name_0_14= 'implies' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5436:1: (lv_name_0_1= '*' | lv_name_0_2= '/' | lv_name_0_3= '+' | lv_name_0_4= '-' | lv_name_0_5= '>' | lv_name_0_6= '<' | lv_name_0_7= '>=' | lv_name_0_8= '<=' | lv_name_0_9= '=' | lv_name_0_10= '<>' | lv_name_0_11= 'and' | lv_name_0_12= 'or' | lv_name_0_13= 'xor' | lv_name_0_14= 'implies' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5436:1: (lv_name_0_1= '*' | lv_name_0_2= '/' | lv_name_0_3= '+' | lv_name_0_4= '-' | lv_name_0_5= '>' | lv_name_0_6= '<' | lv_name_0_7= '>=' | lv_name_0_8= '<=' | lv_name_0_9= '=' | lv_name_0_10= '<>' | lv_name_0_11= 'and' | lv_name_0_12= 'or' | lv_name_0_13= 'xor' | lv_name_0_14= 'implies' )
            int alt141=14;
            switch ( input.LA(1) ) {
            case 77:
                {
                alt141=1;
                }
                break;
            case 86:
                {
                alt141=2;
                }
                break;
            case 87:
                {
                alt141=3;
                }
                break;
            case 18:
                {
                alt141=4;
                }
                break;
            case 82:
                {
                alt141=5;
                }
                break;
            case 81:
                {
                alt141=6;
                }
                break;
            case 88:
                {
                alt141=7;
                }
                break;
            case 89:
                {
                alt141=8;
                }
                break;
            case 66:
                {
                alt141=9;
                }
                break;
            case 90:
                {
                alt141=10;
                }
                break;
            case 91:
                {
                alt141=11;
                }
                break;
            case 92:
                {
                alt141=12;
                }
                break;
            case 93:
                {
                alt141=13;
                }
                break;
            case 94:
                {
                alt141=14;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 141, 0, input);

                throw nvae;
            }

            switch (alt141) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5437:3: lv_name_0_1= '*'
                    {
                    lv_name_0_1=(Token)match(input,77,FollowSets000.FOLLOW_77_in_ruleEssentialOCLInfixOperatorCS12076); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_1, grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameAsteriskKeyword_0_0());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLInfixOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_1, null);
                      	    
                    }

                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5449:8: lv_name_0_2= '/'
                    {
                    lv_name_0_2=(Token)match(input,86,FollowSets000.FOLLOW_86_in_ruleEssentialOCLInfixOperatorCS12105); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_2, grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameSolidusKeyword_0_1());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLInfixOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_2, null);
                      	    
                    }

                    }
                    break;
                case 3 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5461:8: lv_name_0_3= '+'
                    {
                    lv_name_0_3=(Token)match(input,87,FollowSets000.FOLLOW_87_in_ruleEssentialOCLInfixOperatorCS12134); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_3, grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNamePlusSignKeyword_0_2());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLInfixOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_3, null);
                      	    
                    }

                    }
                    break;
                case 4 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5473:8: lv_name_0_4= '-'
                    {
                    lv_name_0_4=(Token)match(input,18,FollowSets000.FOLLOW_18_in_ruleEssentialOCLInfixOperatorCS12163); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_4, grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameHyphenMinusKeyword_0_3());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLInfixOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_4, null);
                      	    
                    }

                    }
                    break;
                case 5 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5485:8: lv_name_0_5= '>'
                    {
                    lv_name_0_5=(Token)match(input,82,FollowSets000.FOLLOW_82_in_ruleEssentialOCLInfixOperatorCS12192); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_5, grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameGreaterThanSignKeyword_0_4());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLInfixOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_5, null);
                      	    
                    }

                    }
                    break;
                case 6 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5497:8: lv_name_0_6= '<'
                    {
                    lv_name_0_6=(Token)match(input,81,FollowSets000.FOLLOW_81_in_ruleEssentialOCLInfixOperatorCS12221); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_6, grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameLessThanSignKeyword_0_5());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLInfixOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_6, null);
                      	    
                    }

                    }
                    break;
                case 7 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5509:8: lv_name_0_7= '>='
                    {
                    lv_name_0_7=(Token)match(input,88,FollowSets000.FOLLOW_88_in_ruleEssentialOCLInfixOperatorCS12250); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_7, grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameGreaterThanSignEqualsSignKeyword_0_6());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLInfixOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_7, null);
                      	    
                    }

                    }
                    break;
                case 8 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5521:8: lv_name_0_8= '<='
                    {
                    lv_name_0_8=(Token)match(input,89,FollowSets000.FOLLOW_89_in_ruleEssentialOCLInfixOperatorCS12279); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_8, grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameLessThanSignEqualsSignKeyword_0_7());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLInfixOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_8, null);
                      	    
                    }

                    }
                    break;
                case 9 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5533:8: lv_name_0_9= '='
                    {
                    lv_name_0_9=(Token)match(input,66,FollowSets000.FOLLOW_66_in_ruleEssentialOCLInfixOperatorCS12308); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_9, grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameEqualsSignKeyword_0_8());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLInfixOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_9, null);
                      	    
                    }

                    }
                    break;
                case 10 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5545:8: lv_name_0_10= '<>'
                    {
                    lv_name_0_10=(Token)match(input,90,FollowSets000.FOLLOW_90_in_ruleEssentialOCLInfixOperatorCS12337); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_10, grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameLessThanSignGreaterThanSignKeyword_0_9());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLInfixOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_10, null);
                      	    
                    }

                    }
                    break;
                case 11 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5557:8: lv_name_0_11= 'and'
                    {
                    lv_name_0_11=(Token)match(input,91,FollowSets000.FOLLOW_91_in_ruleEssentialOCLInfixOperatorCS12366); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_11, grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameAndKeyword_0_10());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLInfixOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_11, null);
                      	    
                    }

                    }
                    break;
                case 12 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5569:8: lv_name_0_12= 'or'
                    {
                    lv_name_0_12=(Token)match(input,92,FollowSets000.FOLLOW_92_in_ruleEssentialOCLInfixOperatorCS12395); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_12, grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameOrKeyword_0_11());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLInfixOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_12, null);
                      	    
                    }

                    }
                    break;
                case 13 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5581:8: lv_name_0_13= 'xor'
                    {
                    lv_name_0_13=(Token)match(input,93,FollowSets000.FOLLOW_93_in_ruleEssentialOCLInfixOperatorCS12424); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_13, grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameXorKeyword_0_12());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLInfixOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_13, null);
                      	    
                    }

                    }
                    break;
                case 14 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5593:8: lv_name_0_14= 'implies'
                    {
                    lv_name_0_14=(Token)match(input,94,FollowSets000.FOLLOW_94_in_ruleEssentialOCLInfixOperatorCS12453); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_14, grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameImpliesKeyword_0_13());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLInfixOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_14, null);
                      	    
                    }

                    }
                    break;

            }


            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleEssentialOCLInfixOperatorCS"


    // $ANTLR start "entryRuleEssentialOCLNavigationOperatorCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5616:1: entryRuleEssentialOCLNavigationOperatorCS returns [EObject current=null] : iv_ruleEssentialOCLNavigationOperatorCS= ruleEssentialOCLNavigationOperatorCS EOF ;
    public final EObject entryRuleEssentialOCLNavigationOperatorCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleEssentialOCLNavigationOperatorCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5617:2: (iv_ruleEssentialOCLNavigationOperatorCS= ruleEssentialOCLNavigationOperatorCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5618:2: iv_ruleEssentialOCLNavigationOperatorCS= ruleEssentialOCLNavigationOperatorCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getEssentialOCLNavigationOperatorCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleEssentialOCLNavigationOperatorCS_in_entryRuleEssentialOCLNavigationOperatorCS12504);
            iv_ruleEssentialOCLNavigationOperatorCS=ruleEssentialOCLNavigationOperatorCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleEssentialOCLNavigationOperatorCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleEssentialOCLNavigationOperatorCS12514); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleEssentialOCLNavigationOperatorCS"


    // $ANTLR start "ruleEssentialOCLNavigationOperatorCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5625:1: ruleEssentialOCLNavigationOperatorCS returns [EObject current=null] : ( ( (lv_name_0_1= '.' | lv_name_0_2= '->' ) ) ) ;
    public final EObject ruleEssentialOCLNavigationOperatorCS() throws RecognitionException {
        EObject current = null;

        Token lv_name_0_1=null;
        Token lv_name_0_2=null;

         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5628:28: ( ( ( (lv_name_0_1= '.' | lv_name_0_2= '->' ) ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5629:1: ( ( (lv_name_0_1= '.' | lv_name_0_2= '->' ) ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5629:1: ( ( (lv_name_0_1= '.' | lv_name_0_2= '->' ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5630:1: ( (lv_name_0_1= '.' | lv_name_0_2= '->' ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5630:1: ( (lv_name_0_1= '.' | lv_name_0_2= '->' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5631:1: (lv_name_0_1= '.' | lv_name_0_2= '->' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5631:1: (lv_name_0_1= '.' | lv_name_0_2= '->' )
            int alt142=2;
            int LA142_0 = input.LA(1);

            if ( (LA142_0==95) ) {
                alt142=1;
            }
            else if ( (LA142_0==96) ) {
                alt142=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 142, 0, input);

                throw nvae;
            }
            switch (alt142) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5632:3: lv_name_0_1= '.'
                    {
                    lv_name_0_1=(Token)match(input,95,FollowSets000.FOLLOW_95_in_ruleEssentialOCLNavigationOperatorCS12558); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_1, grammarAccess.getEssentialOCLNavigationOperatorCSAccess().getNameFullStopKeyword_0_0());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLNavigationOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_1, null);
                      	    
                    }

                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5644:8: lv_name_0_2= '->'
                    {
                    lv_name_0_2=(Token)match(input,96,FollowSets000.FOLLOW_96_in_ruleEssentialOCLNavigationOperatorCS12587); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              newLeafNode(lv_name_0_2, grammarAccess.getEssentialOCLNavigationOperatorCSAccess().getNameHyphenMinusGreaterThanSignKeyword_0_1());
                          
                    }
                    if ( state.backtracking==0 ) {

                      	        if (current==null) {
                      	            current = createModelElement(grammarAccess.getEssentialOCLNavigationOperatorCSRule());
                      	        }
                             		setWithLastConsumed(current, "name", lv_name_0_2, null);
                      	    
                    }

                    }
                    break;

            }


            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleEssentialOCLNavigationOperatorCS"


    // $ANTLR start "entryRuleIdentifier"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5667:1: entryRuleIdentifier returns [String current=null] : iv_ruleIdentifier= ruleIdentifier EOF ;
    public final String entryRuleIdentifier() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleIdentifier = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5668:2: (iv_ruleIdentifier= ruleIdentifier EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5669:2: iv_ruleIdentifier= ruleIdentifier EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getIdentifierRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleIdentifier_in_entryRuleIdentifier12639);
            iv_ruleIdentifier=ruleIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleIdentifier.getText(); 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleIdentifier12650); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleIdentifier"


    // $ANTLR start "ruleIdentifier"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5676:1: ruleIdentifier returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : this_ID_0= ruleID ;
    public final AntlrDatatypeRuleToken ruleIdentifier() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        AntlrDatatypeRuleToken this_ID_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5679:28: (this_ID_0= ruleID )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5681:5: this_ID_0= ruleID
            {
            if ( state.backtracking==0 ) {
               
                      newCompositeNode(grammarAccess.getIdentifierAccess().getIDParserRuleCall()); 
                  
            }
            pushFollow(FollowSets000.FOLLOW_ruleID_in_ruleIdentifier12696);
            this_ID_0=ruleID();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              		current.merge(this_ID_0);
                  
            }
            if ( state.backtracking==0 ) {
               
                      afterParserOrEnumRuleCall();
                  
            }

            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleIdentifier"


    // $ANTLR start "entryRuleStringLiteral"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5699:1: entryRuleStringLiteral returns [String current=null] : iv_ruleStringLiteral= ruleStringLiteral EOF ;
    public final String entryRuleStringLiteral() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleStringLiteral = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5700:2: (iv_ruleStringLiteral= ruleStringLiteral EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5701:2: iv_ruleStringLiteral= ruleStringLiteral EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getStringLiteralRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleStringLiteral_in_entryRuleStringLiteral12741);
            iv_ruleStringLiteral=ruleStringLiteral();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleStringLiteral.getText(); 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleStringLiteral12752); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleStringLiteral"


    // $ANTLR start "ruleStringLiteral"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5708:1: ruleStringLiteral returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : this_SINGLE_QUOTED_STRING_0= RULE_SINGLE_QUOTED_STRING ;
    public final AntlrDatatypeRuleToken ruleStringLiteral() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token this_SINGLE_QUOTED_STRING_0=null;

         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5711:28: (this_SINGLE_QUOTED_STRING_0= RULE_SINGLE_QUOTED_STRING )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5712:5: this_SINGLE_QUOTED_STRING_0= RULE_SINGLE_QUOTED_STRING
            {
            this_SINGLE_QUOTED_STRING_0=(Token)match(input,RULE_SINGLE_QUOTED_STRING,FollowSets000.FOLLOW_RULE_SINGLE_QUOTED_STRING_in_ruleStringLiteral12791); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              		current.merge(this_SINGLE_QUOTED_STRING_0);
                  
            }
            if ( state.backtracking==0 ) {
               
                  newLeafNode(this_SINGLE_QUOTED_STRING_0, grammarAccess.getStringLiteralAccess().getSINGLE_QUOTED_STRINGTerminalRuleCall()); 
                  
            }

            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleStringLiteral"


    // $ANTLR start "entryRuleBinaryOperatorCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5727:1: entryRuleBinaryOperatorCS returns [EObject current=null] : iv_ruleBinaryOperatorCS= ruleBinaryOperatorCS EOF ;
    public final EObject entryRuleBinaryOperatorCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleBinaryOperatorCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5728:2: (iv_ruleBinaryOperatorCS= ruleBinaryOperatorCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5729:2: iv_ruleBinaryOperatorCS= ruleBinaryOperatorCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getBinaryOperatorCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleBinaryOperatorCS_in_entryRuleBinaryOperatorCS12835);
            iv_ruleBinaryOperatorCS=ruleBinaryOperatorCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleBinaryOperatorCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleBinaryOperatorCS12845); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleBinaryOperatorCS"


    // $ANTLR start "ruleBinaryOperatorCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5736:1: ruleBinaryOperatorCS returns [EObject current=null] : (this_InfixOperatorCS_0= ruleInfixOperatorCS | this_NavigationOperatorCS_1= ruleNavigationOperatorCS ) ;
    public final EObject ruleBinaryOperatorCS() throws RecognitionException {
        EObject current = null;

        EObject this_InfixOperatorCS_0 = null;

        EObject this_NavigationOperatorCS_1 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5739:28: ( (this_InfixOperatorCS_0= ruleInfixOperatorCS | this_NavigationOperatorCS_1= ruleNavigationOperatorCS ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5740:1: (this_InfixOperatorCS_0= ruleInfixOperatorCS | this_NavigationOperatorCS_1= ruleNavigationOperatorCS )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5740:1: (this_InfixOperatorCS_0= ruleInfixOperatorCS | this_NavigationOperatorCS_1= ruleNavigationOperatorCS )
            int alt143=2;
            int LA143_0 = input.LA(1);

            if ( (LA143_0==18||LA143_0==66||LA143_0==77||(LA143_0>=81 && LA143_0<=82)||(LA143_0>=86 && LA143_0<=94)) ) {
                alt143=1;
            }
            else if ( ((LA143_0>=95 && LA143_0<=96)) ) {
                alt143=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 143, 0, input);

                throw nvae;
            }
            switch (alt143) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5741:2: this_InfixOperatorCS_0= ruleInfixOperatorCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getBinaryOperatorCSAccess().getInfixOperatorCSParserRuleCall_0()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleInfixOperatorCS_in_ruleBinaryOperatorCS12895);
                    this_InfixOperatorCS_0=ruleInfixOperatorCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_InfixOperatorCS_0; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5754:2: this_NavigationOperatorCS_1= ruleNavigationOperatorCS
                    {
                    if ( state.backtracking==0 ) {
                       
                      	  /* */ 
                      	
                    }
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getBinaryOperatorCSAccess().getNavigationOperatorCSParserRuleCall_1()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleNavigationOperatorCS_in_ruleBinaryOperatorCS12925);
                    this_NavigationOperatorCS_1=ruleNavigationOperatorCS();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {
                       
                              current = this_NavigationOperatorCS_1; 
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleBinaryOperatorCS"


    // $ANTLR start "entryRuleInfixOperatorCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5773:1: entryRuleInfixOperatorCS returns [EObject current=null] : iv_ruleInfixOperatorCS= ruleInfixOperatorCS EOF ;
    public final EObject entryRuleInfixOperatorCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleInfixOperatorCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5774:2: (iv_ruleInfixOperatorCS= ruleInfixOperatorCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5775:2: iv_ruleInfixOperatorCS= ruleInfixOperatorCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getInfixOperatorCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleInfixOperatorCS_in_entryRuleInfixOperatorCS12960);
            iv_ruleInfixOperatorCS=ruleInfixOperatorCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleInfixOperatorCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleInfixOperatorCS12970); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleInfixOperatorCS"


    // $ANTLR start "ruleInfixOperatorCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5782:1: ruleInfixOperatorCS returns [EObject current=null] : this_EssentialOCLInfixOperatorCS_0= ruleEssentialOCLInfixOperatorCS ;
    public final EObject ruleInfixOperatorCS() throws RecognitionException {
        EObject current = null;

        EObject this_EssentialOCLInfixOperatorCS_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5785:28: (this_EssentialOCLInfixOperatorCS_0= ruleEssentialOCLInfixOperatorCS )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5787:2: this_EssentialOCLInfixOperatorCS_0= ruleEssentialOCLInfixOperatorCS
            {
            if ( state.backtracking==0 ) {
               
              	  /* */ 
              	
            }
            if ( state.backtracking==0 ) {
               
                      newCompositeNode(grammarAccess.getInfixOperatorCSAccess().getEssentialOCLInfixOperatorCSParserRuleCall()); 
                  
            }
            pushFollow(FollowSets000.FOLLOW_ruleEssentialOCLInfixOperatorCS_in_ruleInfixOperatorCS13019);
            this_EssentialOCLInfixOperatorCS_0=ruleEssentialOCLInfixOperatorCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               
                      current = this_EssentialOCLInfixOperatorCS_0; 
                      afterParserOrEnumRuleCall();
                  
            }

            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleInfixOperatorCS"


    // $ANTLR start "entryRuleNavigationOperatorCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5806:1: entryRuleNavigationOperatorCS returns [EObject current=null] : iv_ruleNavigationOperatorCS= ruleNavigationOperatorCS EOF ;
    public final EObject entryRuleNavigationOperatorCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleNavigationOperatorCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5807:2: (iv_ruleNavigationOperatorCS= ruleNavigationOperatorCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5808:2: iv_ruleNavigationOperatorCS= ruleNavigationOperatorCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getNavigationOperatorCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleNavigationOperatorCS_in_entryRuleNavigationOperatorCS13053);
            iv_ruleNavigationOperatorCS=ruleNavigationOperatorCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleNavigationOperatorCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleNavigationOperatorCS13063); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleNavigationOperatorCS"


    // $ANTLR start "ruleNavigationOperatorCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5815:1: ruleNavigationOperatorCS returns [EObject current=null] : this_EssentialOCLNavigationOperatorCS_0= ruleEssentialOCLNavigationOperatorCS ;
    public final EObject ruleNavigationOperatorCS() throws RecognitionException {
        EObject current = null;

        EObject this_EssentialOCLNavigationOperatorCS_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5818:28: (this_EssentialOCLNavigationOperatorCS_0= ruleEssentialOCLNavigationOperatorCS )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5820:2: this_EssentialOCLNavigationOperatorCS_0= ruleEssentialOCLNavigationOperatorCS
            {
            if ( state.backtracking==0 ) {
               
              	  /* */ 
              	
            }
            if ( state.backtracking==0 ) {
               
                      newCompositeNode(grammarAccess.getNavigationOperatorCSAccess().getEssentialOCLNavigationOperatorCSParserRuleCall()); 
                  
            }
            pushFollow(FollowSets000.FOLLOW_ruleEssentialOCLNavigationOperatorCS_in_ruleNavigationOperatorCS13112);
            this_EssentialOCLNavigationOperatorCS_0=ruleEssentialOCLNavigationOperatorCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               
                      current = this_EssentialOCLNavigationOperatorCS_0; 
                      afterParserOrEnumRuleCall();
                  
            }

            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleNavigationOperatorCS"


    // $ANTLR start "entryRuleUnaryOperatorCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5839:1: entryRuleUnaryOperatorCS returns [EObject current=null] : iv_ruleUnaryOperatorCS= ruleUnaryOperatorCS EOF ;
    public final EObject entryRuleUnaryOperatorCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleUnaryOperatorCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5840:2: (iv_ruleUnaryOperatorCS= ruleUnaryOperatorCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5841:2: iv_ruleUnaryOperatorCS= ruleUnaryOperatorCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getUnaryOperatorCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleUnaryOperatorCS_in_entryRuleUnaryOperatorCS13146);
            iv_ruleUnaryOperatorCS=ruleUnaryOperatorCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleUnaryOperatorCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleUnaryOperatorCS13156); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleUnaryOperatorCS"


    // $ANTLR start "ruleUnaryOperatorCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5848:1: ruleUnaryOperatorCS returns [EObject current=null] : this_EssentialOCLUnaryOperatorCS_0= ruleEssentialOCLUnaryOperatorCS ;
    public final EObject ruleUnaryOperatorCS() throws RecognitionException {
        EObject current = null;

        EObject this_EssentialOCLUnaryOperatorCS_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5851:28: (this_EssentialOCLUnaryOperatorCS_0= ruleEssentialOCLUnaryOperatorCS )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5853:2: this_EssentialOCLUnaryOperatorCS_0= ruleEssentialOCLUnaryOperatorCS
            {
            if ( state.backtracking==0 ) {
               
              	  /* */ 
              	
            }
            if ( state.backtracking==0 ) {
               
                      newCompositeNode(grammarAccess.getUnaryOperatorCSAccess().getEssentialOCLUnaryOperatorCSParserRuleCall()); 
                  
            }
            pushFollow(FollowSets000.FOLLOW_ruleEssentialOCLUnaryOperatorCS_in_ruleUnaryOperatorCS13205);
            this_EssentialOCLUnaryOperatorCS_0=ruleEssentialOCLUnaryOperatorCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               
                      current = this_EssentialOCLUnaryOperatorCS_0; 
                      afterParserOrEnumRuleCall();
                  
            }

            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleUnaryOperatorCS"


    // $ANTLR start "entryRuleEssentialOCLUnrestrictedName"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5872:1: entryRuleEssentialOCLUnrestrictedName returns [String current=null] : iv_ruleEssentialOCLUnrestrictedName= ruleEssentialOCLUnrestrictedName EOF ;
    public final String entryRuleEssentialOCLUnrestrictedName() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleEssentialOCLUnrestrictedName = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5873:2: (iv_ruleEssentialOCLUnrestrictedName= ruleEssentialOCLUnrestrictedName EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5874:2: iv_ruleEssentialOCLUnrestrictedName= ruleEssentialOCLUnrestrictedName EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getEssentialOCLUnrestrictedNameRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleEssentialOCLUnrestrictedName_in_entryRuleEssentialOCLUnrestrictedName13240);
            iv_ruleEssentialOCLUnrestrictedName=ruleEssentialOCLUnrestrictedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleEssentialOCLUnrestrictedName.getText(); 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleEssentialOCLUnrestrictedName13251); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleEssentialOCLUnrestrictedName"


    // $ANTLR start "ruleEssentialOCLUnrestrictedName"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5881:1: ruleEssentialOCLUnrestrictedName returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : this_Identifier_0= ruleIdentifier ;
    public final AntlrDatatypeRuleToken ruleEssentialOCLUnrestrictedName() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        AntlrDatatypeRuleToken this_Identifier_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5884:28: (this_Identifier_0= ruleIdentifier )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5886:5: this_Identifier_0= ruleIdentifier
            {
            if ( state.backtracking==0 ) {
               
                      newCompositeNode(grammarAccess.getEssentialOCLUnrestrictedNameAccess().getIdentifierParserRuleCall()); 
                  
            }
            pushFollow(FollowSets000.FOLLOW_ruleIdentifier_in_ruleEssentialOCLUnrestrictedName13297);
            this_Identifier_0=ruleIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              		current.merge(this_Identifier_0);
                  
            }
            if ( state.backtracking==0 ) {
               
                      afterParserOrEnumRuleCall();
                  
            }

            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleEssentialOCLUnrestrictedName"


    // $ANTLR start "entryRuleEssentialOCLUnreservedName"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5904:1: entryRuleEssentialOCLUnreservedName returns [String current=null] : iv_ruleEssentialOCLUnreservedName= ruleEssentialOCLUnreservedName EOF ;
    public final String entryRuleEssentialOCLUnreservedName() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleEssentialOCLUnreservedName = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5905:2: (iv_ruleEssentialOCLUnreservedName= ruleEssentialOCLUnreservedName EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5906:2: iv_ruleEssentialOCLUnreservedName= ruleEssentialOCLUnreservedName EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getEssentialOCLUnreservedNameRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleEssentialOCLUnreservedName_in_entryRuleEssentialOCLUnreservedName13342);
            iv_ruleEssentialOCLUnreservedName=ruleEssentialOCLUnreservedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleEssentialOCLUnreservedName.getText(); 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleEssentialOCLUnreservedName13353); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleEssentialOCLUnreservedName"


    // $ANTLR start "ruleEssentialOCLUnreservedName"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5913:1: ruleEssentialOCLUnreservedName returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (this_UnrestrictedName_0= ruleUnrestrictedName | this_CollectionTypeIdentifier_1= ruleCollectionTypeIdentifier | this_PrimitiveTypeIdentifier_2= rulePrimitiveTypeIdentifier | kw= 'Tuple' ) ;
    public final AntlrDatatypeRuleToken ruleEssentialOCLUnreservedName() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;
        AntlrDatatypeRuleToken this_UnrestrictedName_0 = null;

        AntlrDatatypeRuleToken this_CollectionTypeIdentifier_1 = null;

        AntlrDatatypeRuleToken this_PrimitiveTypeIdentifier_2 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5916:28: ( (this_UnrestrictedName_0= ruleUnrestrictedName | this_CollectionTypeIdentifier_1= ruleCollectionTypeIdentifier | this_PrimitiveTypeIdentifier_2= rulePrimitiveTypeIdentifier | kw= 'Tuple' ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5917:1: (this_UnrestrictedName_0= ruleUnrestrictedName | this_CollectionTypeIdentifier_1= ruleCollectionTypeIdentifier | this_PrimitiveTypeIdentifier_2= rulePrimitiveTypeIdentifier | kw= 'Tuple' )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5917:1: (this_UnrestrictedName_0= ruleUnrestrictedName | this_CollectionTypeIdentifier_1= ruleCollectionTypeIdentifier | this_PrimitiveTypeIdentifier_2= rulePrimitiveTypeIdentifier | kw= 'Tuple' )
            int alt144=4;
            switch ( input.LA(1) ) {
            case RULE_SIMPLE_ID:
            case RULE_ESCAPED_ID:
            case 17:
            case 19:
            case 20:
            case 21:
            case 22:
            case 23:
            case 24:
            case 25:
            case 26:
            case 27:
            case 28:
            case 29:
            case 30:
            case 31:
            case 32:
            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 38:
            case 39:
            case 40:
            case 41:
            case 42:
            case 43:
            case 44:
            case 45:
            case 46:
            case 47:
            case 48:
            case 49:
            case 50:
            case 51:
            case 52:
            case 53:
            case 54:
            case 55:
            case 56:
            case 57:
            case 58:
                {
                alt144=1;
                }
                break;
            case 106:
            case 107:
            case 108:
            case 109:
            case 110:
                {
                alt144=2;
                }
                break;
            case 98:
            case 99:
            case 100:
            case 101:
            case 102:
            case 103:
            case 104:
            case 105:
                {
                alt144=3;
                }
                break;
            case 97:
                {
                alt144=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 144, 0, input);

                throw nvae;
            }

            switch (alt144) {
                case 1 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5918:5: this_UnrestrictedName_0= ruleUnrestrictedName
                    {
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getEssentialOCLUnreservedNameAccess().getUnrestrictedNameParserRuleCall_0()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleEssentialOCLUnreservedName13400);
                    this_UnrestrictedName_0=ruleUnrestrictedName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      		current.merge(this_UnrestrictedName_0);
                          
                    }
                    if ( state.backtracking==0 ) {
                       
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 2 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5930:5: this_CollectionTypeIdentifier_1= ruleCollectionTypeIdentifier
                    {
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getEssentialOCLUnreservedNameAccess().getCollectionTypeIdentifierParserRuleCall_1()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_ruleCollectionTypeIdentifier_in_ruleEssentialOCLUnreservedName13433);
                    this_CollectionTypeIdentifier_1=ruleCollectionTypeIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      		current.merge(this_CollectionTypeIdentifier_1);
                          
                    }
                    if ( state.backtracking==0 ) {
                       
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 3 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5942:5: this_PrimitiveTypeIdentifier_2= rulePrimitiveTypeIdentifier
                    {
                    if ( state.backtracking==0 ) {
                       
                              newCompositeNode(grammarAccess.getEssentialOCLUnreservedNameAccess().getPrimitiveTypeIdentifierParserRuleCall_2()); 
                          
                    }
                    pushFollow(FollowSets000.FOLLOW_rulePrimitiveTypeIdentifier_in_ruleEssentialOCLUnreservedName13466);
                    this_PrimitiveTypeIdentifier_2=rulePrimitiveTypeIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      		current.merge(this_PrimitiveTypeIdentifier_2);
                          
                    }
                    if ( state.backtracking==0 ) {
                       
                              afterParserOrEnumRuleCall();
                          
                    }

                    }
                    break;
                case 4 :
                    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5954:2: kw= 'Tuple'
                    {
                    kw=(Token)match(input,97,FollowSets000.FOLLOW_97_in_ruleEssentialOCLUnreservedName13490); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                              current.merge(kw);
                              newLeafNode(kw, grammarAccess.getEssentialOCLUnreservedNameAccess().getTupleKeyword_3()); 
                          
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleEssentialOCLUnreservedName"


    // $ANTLR start "entryRuleUnreservedName"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5967:1: entryRuleUnreservedName returns [String current=null] : iv_ruleUnreservedName= ruleUnreservedName EOF ;
    public final String entryRuleUnreservedName() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleUnreservedName = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5968:2: (iv_ruleUnreservedName= ruleUnreservedName EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5969:2: iv_ruleUnreservedName= ruleUnreservedName EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getUnreservedNameRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleUnreservedName_in_entryRuleUnreservedName13531);
            iv_ruleUnreservedName=ruleUnreservedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleUnreservedName.getText(); 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleUnreservedName13542); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleUnreservedName"


    // $ANTLR start "ruleUnreservedName"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5976:1: ruleUnreservedName returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : this_EssentialOCLUnreservedName_0= ruleEssentialOCLUnreservedName ;
    public final AntlrDatatypeRuleToken ruleUnreservedName() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        AntlrDatatypeRuleToken this_EssentialOCLUnreservedName_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5979:28: (this_EssentialOCLUnreservedName_0= ruleEssentialOCLUnreservedName )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5981:5: this_EssentialOCLUnreservedName_0= ruleEssentialOCLUnreservedName
            {
            if ( state.backtracking==0 ) {
               
                      newCompositeNode(grammarAccess.getUnreservedNameAccess().getEssentialOCLUnreservedNameParserRuleCall()); 
                  
            }
            pushFollow(FollowSets000.FOLLOW_ruleEssentialOCLUnreservedName_in_ruleUnreservedName13588);
            this_EssentialOCLUnreservedName_0=ruleEssentialOCLUnreservedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              		current.merge(this_EssentialOCLUnreservedName_0);
                  
            }
            if ( state.backtracking==0 ) {
               
                      afterParserOrEnumRuleCall();
                  
            }

            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleUnreservedName"


    // $ANTLR start "entryRulePathNameCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:5999:1: entryRulePathNameCS returns [EObject current=null] : iv_rulePathNameCS= rulePathNameCS EOF ;
    public final EObject entryRulePathNameCS() throws RecognitionException {
        EObject current = null;

        EObject iv_rulePathNameCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6000:2: (iv_rulePathNameCS= rulePathNameCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6001:2: iv_rulePathNameCS= rulePathNameCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getPathNameCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_rulePathNameCS_in_entryRulePathNameCS13632);
            iv_rulePathNameCS=rulePathNameCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_rulePathNameCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRulePathNameCS13642); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRulePathNameCS"


    // $ANTLR start "rulePathNameCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6008:1: rulePathNameCS returns [EObject current=null] : ( ( (lv_path_0_0= ruleFirstPathElementCS ) ) (otherlv_1= '::' ( (lv_path_2_0= ruleNextPathElementCS ) ) )* ) ;
    public final EObject rulePathNameCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_path_0_0 = null;

        EObject lv_path_2_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6011:28: ( ( ( (lv_path_0_0= ruleFirstPathElementCS ) ) (otherlv_1= '::' ( (lv_path_2_0= ruleNextPathElementCS ) ) )* ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6012:1: ( ( (lv_path_0_0= ruleFirstPathElementCS ) ) (otherlv_1= '::' ( (lv_path_2_0= ruleNextPathElementCS ) ) )* )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6012:1: ( ( (lv_path_0_0= ruleFirstPathElementCS ) ) (otherlv_1= '::' ( (lv_path_2_0= ruleNextPathElementCS ) ) )* )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6012:2: ( (lv_path_0_0= ruleFirstPathElementCS ) ) (otherlv_1= '::' ( (lv_path_2_0= ruleNextPathElementCS ) ) )*
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6012:2: ( (lv_path_0_0= ruleFirstPathElementCS ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6013:1: (lv_path_0_0= ruleFirstPathElementCS )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6013:1: (lv_path_0_0= ruleFirstPathElementCS )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6014:3: lv_path_0_0= ruleFirstPathElementCS
            {
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getPathNameCSAccess().getPathFirstPathElementCSParserRuleCall_0_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_ruleFirstPathElementCS_in_rulePathNameCS13688);
            lv_path_0_0=ruleFirstPathElementCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              	        if (current==null) {
              	            current = createModelElementForParent(grammarAccess.getPathNameCSRule());
              	        }
                     		add(
                     			current, 
                     			"path",
                      		lv_path_0_0, 
                      		"FirstPathElementCS");
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }

            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6030:2: (otherlv_1= '::' ( (lv_path_2_0= ruleNextPathElementCS ) ) )*
            loop145:
            do {
                int alt145=2;
                int LA145_0 = input.LA(1);

                if ( (LA145_0==76) ) {
                    alt145=1;
                }


                switch (alt145) {
            	case 1 :
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6030:4: otherlv_1= '::' ( (lv_path_2_0= ruleNextPathElementCS ) )
            	    {
            	    otherlv_1=(Token)match(input,76,FollowSets000.FOLLOW_76_in_rulePathNameCS13701); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	          	newLeafNode(otherlv_1, grammarAccess.getPathNameCSAccess().getColonColonKeyword_1_0());
            	          
            	    }
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6034:1: ( (lv_path_2_0= ruleNextPathElementCS ) )
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6035:1: (lv_path_2_0= ruleNextPathElementCS )
            	    {
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6035:1: (lv_path_2_0= ruleNextPathElementCS )
            	    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6036:3: lv_path_2_0= ruleNextPathElementCS
            	    {
            	    if ( state.backtracking==0 ) {
            	       
            	      	        newCompositeNode(grammarAccess.getPathNameCSAccess().getPathNextPathElementCSParserRuleCall_1_1_0()); 
            	      	    
            	    }
            	    pushFollow(FollowSets000.FOLLOW_ruleNextPathElementCS_in_rulePathNameCS13722);
            	    lv_path_2_0=ruleNextPathElementCS();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      	        if (current==null) {
            	      	            current = createModelElementForParent(grammarAccess.getPathNameCSRule());
            	      	        }
            	             		add(
            	             			current, 
            	             			"path",
            	              		lv_path_2_0, 
            	              		"NextPathElementCS");
            	      	        afterParserOrEnumRuleCall();
            	      	    
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop145;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "rulePathNameCS"


    // $ANTLR start "entryRuleFirstPathElementCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6060:1: entryRuleFirstPathElementCS returns [EObject current=null] : iv_ruleFirstPathElementCS= ruleFirstPathElementCS EOF ;
    public final EObject entryRuleFirstPathElementCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleFirstPathElementCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6061:2: (iv_ruleFirstPathElementCS= ruleFirstPathElementCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6062:2: iv_ruleFirstPathElementCS= ruleFirstPathElementCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getFirstPathElementCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleFirstPathElementCS_in_entryRuleFirstPathElementCS13760);
            iv_ruleFirstPathElementCS=ruleFirstPathElementCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleFirstPathElementCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleFirstPathElementCS13770); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleFirstPathElementCS"


    // $ANTLR start "ruleFirstPathElementCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6069:1: ruleFirstPathElementCS returns [EObject current=null] : ( ( ruleUnrestrictedName ) ) ;
    public final EObject ruleFirstPathElementCS() throws RecognitionException {
        EObject current = null;

         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6072:28: ( ( ( ruleUnrestrictedName ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6073:1: ( ( ruleUnrestrictedName ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6073:1: ( ( ruleUnrestrictedName ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6074:1: ( ruleUnrestrictedName )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6074:1: ( ruleUnrestrictedName )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6075:3: ruleUnrestrictedName
            {
            if ( state.backtracking==0 ) {
               
              		  /* */ 
              		
            }
            if ( state.backtracking==0 ) {

              			if (current==null) {
              	            current = createModelElement(grammarAccess.getFirstPathElementCSRule());
              	        }
                      
            }
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getFirstPathElementCSAccess().getElementNamedElementCrossReference_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_ruleUnrestrictedName_in_ruleFirstPathElementCS13821);
            ruleUnrestrictedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleFirstPathElementCS"


    // $ANTLR start "entryRuleNextPathElementCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6099:1: entryRuleNextPathElementCS returns [EObject current=null] : iv_ruleNextPathElementCS= ruleNextPathElementCS EOF ;
    public final EObject entryRuleNextPathElementCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleNextPathElementCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6100:2: (iv_ruleNextPathElementCS= ruleNextPathElementCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6101:2: iv_ruleNextPathElementCS= ruleNextPathElementCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getNextPathElementCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleNextPathElementCS_in_entryRuleNextPathElementCS13856);
            iv_ruleNextPathElementCS=ruleNextPathElementCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleNextPathElementCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleNextPathElementCS13866); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleNextPathElementCS"


    // $ANTLR start "ruleNextPathElementCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6108:1: ruleNextPathElementCS returns [EObject current=null] : ( ( ruleUnreservedName ) ) ;
    public final EObject ruleNextPathElementCS() throws RecognitionException {
        EObject current = null;

         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6111:28: ( ( ( ruleUnreservedName ) ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6112:1: ( ( ruleUnreservedName ) )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6112:1: ( ( ruleUnreservedName ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6113:1: ( ruleUnreservedName )
            {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6113:1: ( ruleUnreservedName )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6114:3: ruleUnreservedName
            {
            if ( state.backtracking==0 ) {
               
              		  /* */ 
              		
            }
            if ( state.backtracking==0 ) {

              			if (current==null) {
              	            current = createModelElement(grammarAccess.getNextPathElementCSRule());
              	        }
                      
            }
            if ( state.backtracking==0 ) {
               
              	        newCompositeNode(grammarAccess.getNextPathElementCSAccess().getElementNamedElementCrossReference_0()); 
              	    
            }
            pushFollow(FollowSets000.FOLLOW_ruleUnreservedName_in_ruleNextPathElementCS13917);
            ruleUnreservedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               
              	        afterParserOrEnumRuleCall();
              	    
            }

            }


            }


            }

            if ( state.backtracking==0 ) {
               leaveRule(); 
            }
        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleNextPathElementCS"


    // $ANTLR start "entryRuleURIPathNameCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6138:1: entryRuleURIPathNameCS returns [EObject current=null] : iv_ruleURIPathNameCS= ruleURIPathNameCS EOF ;
    public final EObject entryRuleURIPathNameCS() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleURIPathNameCS = null;


        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6139:2: (iv_ruleURIPathNameCS= ruleURIPathNameCS EOF )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6140:2: iv_ruleURIPathNameCS= ruleURIPathNameCS EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getURIPathNameCSRule()); 
            }
            pushFollow(FollowSets000.FOLLOW_ruleURIPathNameCS_in_entryRuleURIPathNameCS13952);
            iv_ruleURIPathNameCS=ruleURIPathNameCS();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleURIPathNameCS; 
            }
            match(input,EOF,FollowSets000.FOLLOW_EOF_in_entryRuleURIPathNameCS13962); if (state.failed) return current;

            }

        }
         
            catch (RecognitionException re) { 
                recover(input,re); 
                appendSkippedTokens();
            } 
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleURIPathNameCS"


    // $ANTLR start "ruleURIPathNameCS"
    // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6147:1: ruleURIPathNameCS returns [EObject current=null] : ( ( (lv_path_0_0= ruleURIFirstPathElementCS ) ) (otherlv_1= '::' ( (lv_path_2_0= ruleNextPathElementCS ) ) )* ) ;
    public final EObject ruleURIPathNameCS() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_path_0_0 = null;

        EObject lv_path_2_0 = null;


         enterRule(); 
            
        try {
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/antlr/internal/InternalOCLinEcore.g:6150:28: ( ( ( (lv_path_0_0= ruleURIFirstPathElementCS ) ) (otherlv_1= '::' ( (lv_path_2_0= ruleNextPathElementCS ) ) )* ) )
            // ../org.eclipse.ocl.examples.xtext.oclinecore/src-gen/org/eclipse/ocl/examples/xtext/oclinecore/parser/