/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.internal.framework.AliasMapper;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Filter;
import org.osgi.framework.Version;

public class NativeCodeSpecificationImpl
extends VersionConstraintImpl
implements NativeCodeSpecification {
    private static final NativeCodeDescription[] EMPTY_NATIVECODEDESCRIPTIONS = new NativeCodeDescription[0];
    private static AliasMapper aliasMapper = new AliasMapper();
    private NativeCodeDescription[] possibleSuppliers;
    private boolean optional;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeCodeDescription[] getPossibleSuppliers() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.possibleSuppliers == null) {
                return EMPTY_NATIVECODEDESCRIPTIONS;
            }
            return this.possibleSuppliers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPossibleSuppliers(NativeCodeDescription[] possibleSuppliers) {
        Object object = this.monitor;
        synchronized (object) {
            this.possibleSuppliers = possibleSuppliers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOptional() {
        Object object = this.monitor;
        synchronized (object) {
            return this.optional;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOptional(boolean optional) {
        Object object = this.monitor;
        synchronized (object) {
            this.optional = optional;
        }
    }

    @Override
    public boolean isSatisfiedBy(BaseDescription supplier) {
        if (!(supplier instanceof NativeCodeDescription)) {
            return false;
        }
        State containingState = this.getBundle().getContainingState();
        if (containingState == null) {
            return false;
        }
        Dictionary[] platformProps = containingState.getPlatformProperties();
        NativeCodeDescription nativeSupplier = (NativeCodeDescription)supplier;
        Filter filter = nativeSupplier.getFilter();
        boolean match = false;
        int i = 0;
        while (i < platformProps.length && !match) {
            Dictionary props = platformProps[i];
            if (filter == null || filter.matchCase(props)) {
                int n;
                String[] osNames = nativeSupplier.getOSNames();
                if (osNames.length == 0) {
                    match = true;
                } else {
                    Collection<Object> platformOSAliases;
                    Object platformOS = platformProps[i].get("org.osgi.framework.os.name");
                    if (platformOS instanceof Collection) {
                        platformOSAliases = (Set)platformOS;
                    } else if (platformOS instanceof String) {
                        platformOS = aliasMapper.getCanonicalOSName((String)platformOS);
                        platformOSAliases = aliasMapper.getOSNameAliases((String)platformOS);
                    } else {
                        platformOSAliases = Collections.singleton(platformOS);
                    }
                    String[] stringArray = osNames;
                    n = osNames.length;
                    int n2 = 0;
                    block3: while (n2 < n) {
                        String osName = stringArray[n2];
                        String canonicalOSName = aliasMapper.getCanonicalOSName(osName);
                        for (Object osAlias : platformOSAliases) {
                            match = osAlias instanceof String ? ((String)osAlias).equalsIgnoreCase(canonicalOSName) : osAlias.equals(canonicalOSName);
                            if (match) break block3;
                        }
                        ++n2;
                    }
                }
                if (match) {
                    match = false;
                    String[] processors = nativeSupplier.getProcessors();
                    if (processors.length == 0) {
                        match = true;
                    } else {
                        Collection<Object> platformProcessorAliases;
                        Object platformProcessor = platformProps[i].get("org.osgi.framework.processor");
                        if (platformProcessor instanceof Collection) {
                            platformProcessorAliases = (List)platformProcessor;
                        } else if (platformProcessor instanceof String) {
                            platformProcessor = aliasMapper.getCanonicalProcessor((String)platformProcessor);
                            platformProcessorAliases = aliasMapper.getProcessorAliases((String)platformProcessor);
                        } else {
                            platformProcessorAliases = Collections.singletonList(platformProcessor);
                        }
                        String[] stringArray = processors;
                        int n3 = processors.length;
                        n = 0;
                        block5: while (n < n3) {
                            String processor = stringArray[n];
                            String canonicalProcessor = aliasMapper.getCanonicalProcessor(processor);
                            for (Object processorAlias : platformProcessorAliases) {
                                match = processorAlias instanceof String ? ((String)processorAlias).equalsIgnoreCase(canonicalProcessor) : processorAlias.equals(canonicalProcessor);
                                if (match) break block5;
                            }
                            ++n;
                        }
                    }
                    if (match) {
                        match = false;
                        String[] languages = nativeSupplier.getLanguages();
                        if (languages.length == 0) {
                            match = true;
                        } else {
                            Object platformLanguage = platformProps[i].get("org.osgi.framework.language");
                            if (platformLanguage != null) {
                                int j = 0;
                                while (j < languages.length && !match) {
                                    if (platformLanguage instanceof String ? ((String)platformLanguage).equalsIgnoreCase(languages[j]) : platformLanguage.equals(languages[j])) {
                                        match = true;
                                    }
                                    ++j;
                                }
                            }
                        }
                        if (match) {
                            match = false;
                            VersionRange[] osVersions = nativeSupplier.getOSVersions();
                            if (osVersions.length == 0 || platformProps[i].get("org.osgi.framework.os.version") == null) {
                                match = true;
                            } else {
                                Version osversion;
                                try {
                                    osversion = Version.parseVersion((String)((String)platformProps[i].get("org.osgi.framework.os.version")));
                                }
                                catch (Exception exception) {
                                    osversion = Version.emptyVersion;
                                }
                                int j = 0;
                                while (j < osVersions.length && !match) {
                                    if (osVersions[j].isIncluded(osversion)) {
                                        match = true;
                                    }
                                    ++j;
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return match;
    }

    @Override
    protected boolean hasMandatoryAttributes(String[] mandatory) {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        NativeCodeDescription[] suppliers = this.getPossibleSuppliers();
        int i = 0;
        while (i < suppliers.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(suppliers[i].toString());
            ++i;
        }
        return sb.toString();
    }

    @Override
    protected Map<String, String> getInternalDirectives() {
        return Collections.emptyMap();
    }

    @Override
    protected Map<String, Object> getInteralAttributes() {
        return Collections.emptyMap();
    }

    @Override
    protected String getInternalNameSpace() {
        return null;
    }
}

