/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.palette.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.PaletteToolbar;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.customization.palette.dialog.AspectActionsInformationComposite;
import org.eclipse.papyrus.customization.palette.dialog.NewDrawerWizard;
import org.eclipse.papyrus.customization.palette.dialog.PaletteAspectToolEntryProxy;
import org.eclipse.papyrus.customization.palette.dialog.PaletteContainerProxy;
import org.eclipse.papyrus.customization.palette.dialog.PaletteEntryProxy;
import org.eclipse.papyrus.customization.palette.dialog.PaletteEntryProxyInformationComposite;
import org.eclipse.papyrus.customization.palette.dialog.PaletteLocalDrawerProxy;
import org.eclipse.papyrus.customization.palette.dialog.PaletteLocalSeparatorProxy;
import org.eclipse.papyrus.customization.palette.dialog.PaletteLocalStackProxy;
import org.eclipse.papyrus.customization.palette.dialog.UpdateLocalDrawerWizard;
import org.eclipse.papyrus.customization.palette.proxies.XMLPaletteDefinitionProxyFactory;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.Messages;
import org.eclipse.papyrus.uml.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.uml.diagram.common.part.PapyrusPalettePreferences;
import org.eclipse.papyrus.uml.diagram.common.service.AspectCreationEntry;
import org.eclipse.papyrus.uml.diagram.common.service.PapyrusPaletteService;
import org.eclipse.papyrus.uml.diagram.common.service.XMLPaletteDefinitionVisitor;
import org.eclipse.papyrus.uml.diagram.common.service.XMLPaletteDefinitionWalker;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.StereotypeAspectActionProvider;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalPaletteContentPage
extends WizardPage
implements Listener {
    protected IEditorPart editorPart;
    protected TreeViewer availableToolsViewer;
    protected PaletteLabelProvider paletteLabelProvider;
    protected static final String HIDDEN_TOOLS_ICON = "/icons/tools_hidden.gif";
    protected static final String SHOWN_TOOLS_ICON = "/icons/tools_shown.gif";
    protected static final String WIZARD_ICON = "/icons/local_desc_wiz.png";
    protected static final String SHOWN_DRAWERS_ICON = "/icons/drawers_shown.gif";
    protected static final String HIDDEN_DRAWERS_ICON = "/icons/drawers_hidden.gif";
    protected static final String ADD_ICON = "/icons/arrow_right.gif";
    protected static final String REMOVE_ICON = "/icons/arrow_left.gif";
    protected static final String DELETE_ICON = "/icons/delete.gif";
    protected static final String CREATE_DRAWERS_ICON = "/icons/new_drawer.gif";
    protected String CREATE_SEPARATOR_ICON = "/icons/separator.gif";
    protected String CREATE_STACK_ICON = "/icons/stack.gif";
    protected static final String DELETE_DRAWERS_ICON = "/icons/delete.gif";
    protected String SWITCH_CONTENT_PROVIDER_ICON = "/icons/switch_provider.gif";
    protected static final String UML_TOOLS_LABEL = "UML tools";
    protected static final String EDIT_ICON = "/icons/obj16/file.gif";
    protected final ViewerFilter drawerFilter = new DrawerFilter();
    protected final ViewerFilter toolFilter = new ToolFilter();
    protected List<String> storedPreferences;
    protected Button addButton;
    protected Button removeButton;
    protected TreeViewer paletteTreeViewer;
    protected Document document;
    protected PaletteContainerProxy contentNode;
    protected Combo profileCombo;
    protected List<String> profileComboList = new ArrayList<String>();
    protected ToolItem toggleContentProvider;
    protected Set<String> requiredProfiles;
    protected PaletteCustomizer customizer;
    protected PaletteEntryProxy selectedEntryProxy;
    protected PaletteEntryProxyInformationComposite informationComposite = new PaletteEntryProxyInformationComposite();
    protected AspectActionsInformationComposite aspectActionComposite = new AspectActionsInformationComposite();
    protected ToolBar toolbar;
    protected static final String VALIDATOR = "validator";
    protected ProviderPriority priority;

    public LocalPaletteContentPage(IEditorPart part, PaletteCustomizer customizer) {
        super(Messages.Local_Palette_ContentPage_Name, Messages.Local_Palette_ContentPage_Title, Activator.getImageDescriptor((String)WIZARD_ICON));
        this.editorPart = part;
        this.customizer = customizer;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        control.setLayout((Layout)layout);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)control);
        this.createAvailableToolsGroup();
        this.createAddRemoveButtons();
        this.createPalettePreviewGroup();
        this.createToolDescriptionGroup();
        this.createAspectActionComposite();
        ISelectionChangedListener listener = this.createToolsViewerSelectionChangeListener();
        this.availableToolsViewer.addSelectionChangedListener(listener);
        this.paletteTreeViewer.addSelectionChangedListener(listener);
        Dialog.applyDialogFont((Control)control);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)control);
    }

    protected void createAspectActionComposite() {
        this.aspectActionComposite.createComposite((Composite)this.getControl(), this.getAllAppliedProfiles());
    }

    protected void createToolDescriptionGroup() {
        this.informationComposite.createComposite((Composite)this.getControl(), this.getAllAppliedProfiles());
    }

    protected void updatePreferences() {
        this.storedPreferences = PapyrusPalettePreferences.getHiddenPalettes((IEditorPart)this.editorPart);
        for (String id : this.storedPreferences) {
            PapyrusPalettePreferences.changePaletteVisibility((String)id, (IEditorPart)this.editorPart, (boolean)true);
        }
    }

    public void restorePreferences() {
        for (String id : this.storedPreferences) {
            PapyrusPalettePreferences.changePaletteVisibility((String)id, (IEditorPart)this.editorPart, (boolean)false);
        }
    }

    protected void createPalettePreviewGroup() {
        Composite parent = (Composite)this.getControl();
        Composite paletteComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        paletteComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        paletteComposite.setLayoutData((Object)data);
        Label label = new Label(paletteComposite, 0);
        label.setText(Messages.Local_Palette_Palette_Preview);
        data = new GridData(16384, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        this.toolbar = new ToolBar(paletteComposite, 256);
        data = new GridData(131072, 4, false, false);
        this.toolbar.setLayoutData((Object)data);
        this.populatePalettePreviewToolBar(this.toolbar);
        Tree tree = new Tree(paletteComposite, 2052);
        data = new GridData(4, 4, true, true, 2, 1);
        data.widthHint = 185;
        data.heightHint = 200;
        tree.setLayoutData((Object)data);
        this.paletteTreeViewer = new TreeViewer(tree);
        this.paletteTreeViewer.setContentProvider((IContentProvider)new PaletteContentProvider(this.paletteTreeViewer));
        this.paletteTreeViewer.setLabelProvider((IBaseLabelProvider)new PaletteProxyLabelProvider());
        this.paletteTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LocalPaletteContentPage.this.handlePalettePreviewSelectionChanged(event);
            }
        });
        this.addPalettePreviewDropSupport();
        this.addPalettePreviewDragSupport();
        this.addPalettePreviewEditSupport();
        this.paletteTreeViewer.setInput((Object)this.contentNode);
    }

    protected void handlePalettePreviewSelectionChanged(SelectionChangedEvent event) {
        TreeSelection selection = (TreeSelection)event.getSelection();
        Object firstSelected = selection.getFirstElement();
        if (firstSelected instanceof PaletteEntryProxy) {
            this.selectedEntryProxy = (PaletteEntryProxy)firstSelected;
            this.informationComposite.setSelectedEntryProxy(this.selectedEntryProxy);
            this.aspectActionComposite.setSelectedEntryProxy(this.selectedEntryProxy);
        }
        if (this.toolbar != null && !this.toolbar.isDisposed()) {
            int i = 0;
            while (i < this.toolbar.getItemCount()) {
                ToolItem item = this.toolbar.getItem(i);
                Object validator = item.getData(VALIDATOR);
                if (validator instanceof ToolBarItemValidator) {
                    item.setEnabled(((ToolBarItemValidator)validator).isEnable());
                }
                ++i;
            }
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void addPalettePreviewEditSupport() {
        this.paletteTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection selection = (TreeSelection)event.getSelection();
                Object firstSelected = selection.getFirstElement();
                if (firstSelected instanceof PaletteLocalDrawerProxy) {
                    UpdateLocalDrawerWizard wizard = new UpdateLocalDrawerWizard(((PaletteLocalDrawerProxy)firstSelected).getParent(), (PaletteLocalDrawerProxy)firstSelected);
                    WizardDialog dialog = new WizardDialog(LocalPaletteContentPage.this.getShell(), (IWizard)wizard);
                    dialog.open();
                }
            }
        });
    }

    protected void addPalettePreviewDropSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        TreeDropTargetEffect listener = new TreeDropTargetEffect(this.paletteTreeViewer.getTree()){

            public void drop(DropTargetEvent event) {
                IStructuredSelection transferedSelection;
                Object entry;
                PaletteEntryProxy entryProxy;
                super.drop(event);
                PaletteEntryProxy target = (PaletteEntryProxy)((TreeItem)event.item).getData();
                if (target == null) {
                    target = (PaletteContainerProxy)LocalPaletteContentPage.this.paletteTreeViewer.getInput();
                }
                if ((entryProxy = LocalPaletteContentPage.this.createNodeFromEntry(entry = (transferedSelection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().nativeToJava(event.currentDataType)).getFirstElement())) == null) {
                    return;
                }
                if (target instanceof PaletteContainerProxy) {
                    if (entryProxy.getParent() != null) {
                        entryProxy.getParent().removeChild(entryProxy);
                    }
                    ((PaletteContainerProxy)target).addChild(entryProxy);
                    LocalPaletteContentPage.this.paletteTreeViewer.expandToLevel((Object)target, 1);
                } else if (target instanceof PaletteEntryProxy) {
                    if (entryProxy.getParent() != null) {
                        entryProxy.getParent().removeChild(entryProxy);
                    }
                    target.getParent().addChild(entryProxy, target);
                    LocalPaletteContentPage.this.paletteTreeViewer.expandToLevel((Object)target.getParent(), 1);
                } else {
                    target.getParent().addChild(entryProxy);
                    LocalPaletteContentPage.this.paletteTreeViewer.expandToLevel((Object)target.getParent(), -1);
                }
                LocalPaletteContentPage.this.setPageComplete(LocalPaletteContentPage.this.validatePage());
            }

            public void dragOver(DropTargetEvent event) {
                super.dragOver(event);
                IStructuredSelection transferedSelection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().nativeToJava(event.currentDataType);
                TreeItem item = LocalPaletteContentPage.this.paletteTreeViewer.getTree().getItem(LocalPaletteContentPage.this.paletteTreeViewer.getTree().toControl(new Point(event.x, event.y)));
                LocalPaletteContentPage.this.checkSelectionForDrop(transferedSelection, item, event);
            }
        };
        this.paletteTreeViewer.addDropSupport(6, transfers, (DropTargetListener)listener);
    }

    protected void addPalettePreviewDragSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DragSourceAdapter listener = new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                super.dragStart(event);
                event.data = LocalPaletteContentPage.this.paletteTreeViewer.getSelection();
            }

            public void dragSetData(DragSourceEvent event) {
                super.dragSetData(event);
                LocalSelectionTransfer.getTransfer().setSelection(LocalPaletteContentPage.this.paletteTreeViewer.getSelection());
            }
        };
        this.paletteTreeViewer.addDragSupport(2, transfers, (DragSourceListener)listener);
    }

    protected void checkSelectionForDrop(IStructuredSelection transferedSelection, TreeItem item, DropTargetEvent event) {
        event.detail = 0;
        Object entry = transferedSelection.getFirstElement();
        if (item == null) {
            if (entry instanceof PaletteDrawer) {
                event.detail = 4;
            }
        } else {
            PaletteEntryProxy targetProxy = (PaletteEntryProxy)item.getData();
            switch (targetProxy.getType()) {
                case DRAWER: {
                    if (entry instanceof ToolEntry) {
                        event.detail = 4;
                        break;
                    }
                    if (!(entry instanceof PaletteEntryProxy)) break;
                    event.detail = 2;
                    break;
                }
                case STACK: {
                    if (entry instanceof ToolEntry) {
                        event.detail = 4;
                        break;
                    }
                    if (!(entry instanceof PaletteEntryProxy) || entry instanceof PaletteLocalStackProxy) break;
                    event.detail = 2;
                    break;
                }
                case TOOL: {
                    if (entry instanceof ToolEntry) {
                        event.detail = 4;
                        break;
                    }
                    if (!(entry instanceof PaletteEntryProxy)) break;
                    event.detail = 2;
                    break;
                }
                case SEPARATOR: {
                    if (!(entry instanceof PaletteEntryProxy)) break;
                    event.detail = 2;
                    break;
                }
            }
        }
    }

    public void initializeContent() {
        this.contentNode = new PaletteContainerProxy(null);
        PaletteLocalDrawerProxy proxy = new PaletteLocalDrawerProxy("Default", this.generateID("Drawer_"), "/icons/drawer.gif", "Default Drawer");
        this.contentNode.addChild(proxy);
        this.setPageComplete(false);
    }

    public void initializeContent(PapyrusPaletteService.LocalProviderDescriptor descriptor) {
        block7: {
            String xmlPath = PapyrusPalettePreferences.getPalettePathFromID((String)descriptor.getContributionID());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                File file = Activator.getDefault().getStateLocation().append(xmlPath).toFile();
                if (!file.exists()) {
                    Activator.log.error("Impossible to load file: " + file, null);
                    break block7;
                }
                Document document = documentBuilder.parse(file);
                Map entries = PaletteUtil.getAvailableEntriesSet((IEditorPart)this.editorPart, (ProviderPriority)ProviderPriority.HIGHEST);
                XMLPaletteDefinitionProxyFactory factory = new XMLPaletteDefinitionProxyFactory(entries);
                XMLPaletteDefinitionWalker walker = new XMLPaletteDefinitionWalker((XMLPaletteDefinitionVisitor)factory);
                int i = 0;
                while (i < document.getChildNodes().getLength()) {
                    Node node = document.getChildNodes().item(i);
                    if ("paletteDefinition".equals(node.getNodeName())) {
                        walker.walk(node);
                    }
                    ++i;
                }
                this.contentNode = factory.getRootProxy();
                this.setPageComplete(true);
                return;
            }
            catch (ParserConfigurationException e) {
                Activator.log.error((Throwable)e);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
            catch (SAXException e) {
                Activator.log.error((Throwable)e);
            }
        }
        this.contentNode = new PaletteContainerProxy(null);
    }

    protected File loadDocument(Document document, String path) {
        File file = null;
        try {
            file = Activator.getDefault().getStateLocation().append(path).toFile();
            Transformer aTransformer = TransformerFactory.newInstance().newTransformer();
            DOMSource src = new DOMSource(document);
            StreamResult dest = new StreamResult(file);
            aTransformer.transform(src, dest);
        }
        catch (TransformerConfigurationException e) {
            Activator.log.error((Throwable)e);
        }
        catch (TransformerException e) {
            Activator.log.error((Throwable)e);
        }
        return file;
    }

    protected void populatePalettePreviewToolBar(ToolBar toolbar) {
        PaletteEntryProxySelectedValidator validator = new PaletteEntryProxySelectedValidator();
        this.createToolBarItem(toolbar, "/icons/delete.gif", Messages.PapyrusPaletteCustomizerDialog_RemoveButtonTooltip, this.createRemoveElementListener(), validator);
        this.createToolBarItem(toolbar, EDIT_ICON, Messages.PapyrusPaletteCustomizerDialog_EditButtonTooltip, this.createEditElementListener(), new EditElementToolBarItemValidator());
        this.createToolBarItem(toolbar, CREATE_DRAWERS_ICON, Messages.Local_Palette_Create_Drawer_Tooltip, this.createNewDrawerListener(), null);
        this.createToolBarItem(toolbar, this.CREATE_SEPARATOR_ICON, Messages.Local_Palette_Create_Separator_Tooltip, this.createNewSeparatorListener(), validator);
        this.createToolBarItem(toolbar, this.CREATE_STACK_ICON, Messages.Local_Palette_Create_Stack_Tooltip, this.createNewStackListener(), validator);
    }

    protected Listener createEditElementListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = (IStructuredSelection)LocalPaletteContentPage.this.paletteTreeViewer.getSelection();
                if (selection == null || selection.size() < 1) {
                    return;
                }
                Object selected = selection.getFirstElement();
                if (selected instanceof PaletteLocalDrawerProxy) {
                    UpdateLocalDrawerWizard wizard = new UpdateLocalDrawerWizard(((PaletteLocalDrawerProxy)selected).getParent(), (PaletteLocalDrawerProxy)selected);
                    WizardDialog dialog = new WizardDialog(LocalPaletteContentPage.this.getShell(), (IWizard)wizard);
                    dialog.open();
                }
            }
        };
    }

    protected Listener createRemoveElementListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = (IStructuredSelection)LocalPaletteContentPage.this.paletteTreeViewer.getSelection();
                if (selection == null || selection.size() < 1) {
                    return;
                }
                for (Object o : selection) {
                    PaletteEntryProxy proxyToDelete;
                    PaletteContainerProxy parentProxy;
                    if (!(o instanceof PaletteEntryProxy) || (parentProxy = (proxyToDelete = (PaletteEntryProxy)o).getParent()) == null) continue;
                    parentProxy.removeChild(proxyToDelete);
                }
            }
        };
    }

    protected Listener createNewDrawerListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                PaletteContainerProxy containerProxy = (PaletteContainerProxy)LocalPaletteContentPage.this.paletteTreeViewer.getInput();
                NewDrawerWizard wizard = new NewDrawerWizard(containerProxy);
                WizardDialog wizardDialog = new WizardDialog(new Shell(), (IWizard)wizard);
                wizardDialog.open();
                LocalPaletteContentPage.this.setPageComplete(LocalPaletteContentPage.this.validatePage());
            }
        };
    }

    protected Listener createNewStackListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                Object object = ((IStructuredSelection)LocalPaletteContentPage.this.paletteTreeViewer.getSelection()).getFirstElement();
                if (object instanceof PaletteLocalDrawerProxy) {
                    String id = LocalPaletteContentPage.this.generateID("Stack");
                    PaletteLocalStackProxy proxy = new PaletteLocalStackProxy(id);
                    ((PaletteLocalDrawerProxy)object).addChild(proxy);
                } else if (object instanceof PaletteEntryProxy) {
                    String id = LocalPaletteContentPage.this.generateID("Stack");
                    PaletteLocalStackProxy proxy = new PaletteLocalStackProxy(id);
                    PaletteEntryProxy childProxy = (PaletteEntryProxy)object;
                    PaletteContainerProxy parentProxy = childProxy.getParent();
                    parentProxy.addChild(proxy, childProxy);
                }
                LocalPaletteContentPage.this.setPageComplete(LocalPaletteContentPage.this.validatePage());
            }
        };
    }

    protected String generateID(String base) {
        StringBuffer id = new StringBuffer();
        id.append(base);
        id.append("_");
        id.append(System.currentTimeMillis());
        return id.toString();
    }

    protected Listener createNewSeparatorListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                Object object = ((IStructuredSelection)LocalPaletteContentPage.this.paletteTreeViewer.getSelection()).getFirstElement();
                if (object instanceof PaletteLocalDrawerProxy) {
                    String id = LocalPaletteContentPage.this.generateID("Separator");
                    PaletteLocalSeparatorProxy proxy = new PaletteLocalSeparatorProxy(id);
                    ((PaletteLocalDrawerProxy)object).addChild(proxy);
                } else if (object instanceof PaletteEntryProxy) {
                    String id = LocalPaletteContentPage.this.generateID("Separator");
                    PaletteLocalSeparatorProxy proxy = new PaletteLocalSeparatorProxy(id);
                    PaletteEntryProxy childProxy = (PaletteEntryProxy)object;
                    PaletteContainerProxy parentProxy = childProxy.getParent();
                    parentProxy.addChild(proxy, childProxy);
                }
                LocalPaletteContentPage.this.setPageComplete(LocalPaletteContentPage.this.validatePage());
            }
        };
    }

    protected void createToolBarItem(ToolBar toolbar, String itemIcon, String tooltip, Listener listener, ToolBarItemValidator validator) {
        ToolItem item = new ToolItem(toolbar, 2048);
        item.setImage(Activator.getPluginIconImage((String)"org.eclipse.papyrus.uml.diagram.common", (String)itemIcon));
        item.setToolTipText(tooltip);
        item.addListener(13, listener);
        item.setData(VALIDATOR, (Object)validator);
    }

    protected void createAddRemoveButtons() {
        Composite composite = new Composite((Composite)this.getControl(), 0);
        GridLayout layout = new GridLayout(1, true);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(0x1000000, 0x1000000, false, true);
        composite.setLayoutData((Object)data);
        this.addButton = new Button(composite, 0);
        this.addButton.setImage(Activator.getPluginIconImage((String)"org.eclipse.papyrus.uml.diagram.common", (String)ADD_ICON));
        this.addButton.setToolTipText(Messages.PapyrusPaletteCustomizerDialog_AddButtonTooltip);
        this.addButton.addMouseListener(this.createAddButtonListener());
        this.addButton.setEnabled(false);
        this.addButton.addListener(4, (Listener)this);
        this.removeButton = new Button(composite, 0);
        this.removeButton.setImage(Activator.getPluginIconImage((String)"org.eclipse.papyrus.uml.diagram.common", (String)REMOVE_ICON));
        this.removeButton.setToolTipText(Messages.PapyrusPaletteCustomizerDialog_RemoveButtonTooltip);
        this.removeButton.addMouseListener(this.createRemoveButtonListener());
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(4, (Listener)this);
    }

    protected ISelectionChangedListener createToolsViewerSelectionChangeListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object target;
                Object source = ((IStructuredSelection)LocalPaletteContentPage.this.availableToolsViewer.getSelection()).getFirstElement();
                if (this.isAddValidTarget(source, target = ((IStructuredSelection)LocalPaletteContentPage.this.paletteTreeViewer.getSelection()).getFirstElement())) {
                    LocalPaletteContentPage.this.addButton.setEnabled(true);
                } else {
                    LocalPaletteContentPage.this.addButton.setEnabled(false);
                }
                if (this.isRemoveValidSource(target)) {
                    LocalPaletteContentPage.this.removeButton.setEnabled(true);
                } else {
                    LocalPaletteContentPage.this.removeButton.setEnabled(false);
                }
            }

            protected boolean isAddValidTarget(Object source, Object target) {
                if (!(source instanceof PaletteEntry)) {
                    return false;
                }
                if (source instanceof PaletteDrawer) {
                    return target == null;
                }
                if (source instanceof ToolEntry) {
                    if (target instanceof PaletteEntryProxy) {
                        EntryType type = ((PaletteEntryProxy)target).getType();
                        switch (type) {
                            case DRAWER: 
                            case STACK: {
                                return true;
                            }
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }

            protected boolean isRemoveValidSource(Object source) {
                return source instanceof PaletteEntryProxy;
            }
        };
    }

    protected MouseListener createAddButtonListener() {
        return new MouseListener(){

            public void mouseUp(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)LocalPaletteContentPage.this.availableToolsViewer.getSelection();
                if (selection == null || selection.size() < 1) {
                    return;
                }
                PaletteEntry entry = (PaletteEntry)selection.getFirstElement();
                if (entry == null) {
                    return;
                }
                selection = (IStructuredSelection)LocalPaletteContentPage.this.paletteTreeViewer.getSelection();
                PaletteEntryProxy parentNode = (PaletteEntryProxy)selection.getFirstElement();
                if (parentNode == null && entry instanceof PaletteDrawer) {
                    parentNode = (PaletteContainerProxy)LocalPaletteContentPage.this.paletteTreeViewer.getInput();
                }
                if (!(parentNode instanceof PaletteContainerProxy)) {
                    return;
                }
                PaletteEntryProxy proxy = LocalPaletteContentPage.this.createNodeFromEntry(entry);
                ((PaletteContainerProxy)parentNode).addChild(proxy);
                LocalPaletteContentPage.this.paletteTreeViewer.expandToLevel((Object)parentNode, 1);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
    }

    protected PaletteEntryProxy createNodeFromEntry(Object entry) {
        PaletteEntryProxy entryProxy = null;
        if (entry instanceof AspectCreationEntry) {
            entryProxy = new PaletteAspectToolEntryProxy(((AspectCreationEntry)entry).clone());
        } else if (entry instanceof CombinedTemplateCreationEntry) {
            CombinedTemplateCreationEntry originalEntry = (CombinedTemplateCreationEntry)entry;
            AspectCreationEntry aspectEntry = new AspectCreationEntry(originalEntry.getLabel(), originalEntry.getDescription(), String.valueOf(originalEntry.getId()) + "_" + System.currentTimeMillis(), originalEntry.getSmallIcon(), originalEntry, new HashMap());
            entryProxy = new PaletteAspectToolEntryProxy(aspectEntry);
        } else if (entry instanceof PaletteContainer) {
            entryProxy = new PaletteContainerProxy((PaletteContainer)entry);
        } else if (entry instanceof PaletteEntryProxy) {
            entryProxy = (PaletteEntryProxy)entry;
        }
        return entryProxy;
    }

    protected MouseListener createRemoveButtonListener() {
        return new MouseListener(){

            public void mouseUp(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)LocalPaletteContentPage.this.paletteTreeViewer.getSelection();
                if (selection == null || selection.size() < 1) {
                    return;
                }
                PaletteEntryProxy proxyToDelete = (PaletteEntryProxy)selection.getFirstElement();
                if (proxyToDelete == null) {
                    return;
                }
                PaletteContainerProxy parentProxy = proxyToDelete.getParent();
                parentProxy.removeChild(proxyToDelete);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
    }

    protected void createAvailableToolsGroup() {
        Composite parent = (Composite)this.getControl();
        Composite availableToolsComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        availableToolsComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        availableToolsComposite.setLayoutData((Object)data);
        Label label = new Label(availableToolsComposite, 0);
        label.setText(Messages.Local_Palette_Available_Tools);
        data = new GridData(16384, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        ToolBar toolbar = new ToolBar(availableToolsComposite, 256);
        data = new GridData(131072, 4, false, false);
        toolbar.setLayoutData((Object)data);
        this.populateAvailableToolsToolBar(toolbar);
        this.createProfileCombo(availableToolsComposite);
        Tree tree = new Tree(availableToolsComposite, 2052);
        data = new GridData(4, 4, true, true, 2, 1);
        data.widthHint = 185;
        data.heightHint = 200;
        tree.setLayoutData((Object)data);
        this.availableToolsViewer = new TreeViewer(tree);
        this.availableToolsViewer.setContentProvider((IContentProvider)new UMLToolsTreeContentProvider());
        this.paletteLabelProvider = new PaletteLabelProvider();
        this.availableToolsViewer.setLabelProvider((IBaseLabelProvider)this.paletteLabelProvider);
        LabelViewerComparator labelComparator = new LabelViewerComparator();
        this.availableToolsViewer.setComparator((ViewerComparator)labelComparator);
        this.availableToolsViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof PaletteStack && "noteStack".equals(((PaletteStack)element).getId())) {
                    return false;
                }
                return !(element instanceof PaletteToolbar) || !"standardGroup".equals(((PaletteToolbar)element).getId());
            }
        });
        this.availableToolsViewer.addFilter((ViewerFilter)new DrawerFilter());
        this.addAvailableToolsDragSupport();
    }

    protected Combo createProfileCombo(Composite availableToolsComposite) {
        this.profileCombo = new Combo(availableToolsComposite, 2056);
        GridData data = new GridData(4, 4, true, false, 2, 1);
        this.profileCombo.setLayoutData((Object)data);
        List<Profile> profiles = this.getAllAppliedProfiles();
        int profileNumber = profiles.size();
        int i = 0;
        while (i < profileNumber) {
            this.profileComboList.add(i, profiles.get(i).getName());
            ++i;
        }
        this.profileComboList.add(UML_TOOLS_LABEL);
        this.profileCombo.setItems(this.profileComboList.toArray(new String[0]));
        ProfileComboSelectionListener listener = new ProfileComboSelectionListener();
        this.profileCombo.addSelectionListener((SelectionListener)listener);
        this.profileCombo.addModifyListener((ModifyListener)listener);
        return this.profileCombo;
    }

    protected List<Profile> getAllAppliedProfiles() {
        EObject element;
        Package topPackage = null;
        if (this.editorPart instanceof DiagramEditorWithFlyOutPalette && (element = ((DiagramEditorWithFlyOutPalette)this.editorPart).getDiagram().getElement()) instanceof org.eclipse.uml2.uml.Element) {
            topPackage = ((org.eclipse.uml2.uml.Element)element).getNearestPackage();
        }
        if (topPackage != null) {
            return topPackage.getAllAppliedProfiles();
        }
        return Collections.EMPTY_LIST;
    }

    protected void addAvailableToolsDragSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DragSourceAdapter listener = new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                super.dragStart(event);
                event.data = LocalPaletteContentPage.this.availableToolsViewer.getSelection();
            }

            public void dragSetData(DragSourceEvent event) {
                super.dragSetData(event);
                LocalSelectionTransfer.getTransfer().setSelection(LocalPaletteContentPage.this.availableToolsViewer.getSelection());
            }
        };
        this.availableToolsViewer.addDragSupport(4, transfers, (DragSourceListener)listener);
    }

    protected void populateAvailableToolsToolBar(ToolBar toolbar) {
        this.toggleContentProvider = this.createCheckToolBarItem(toolbar, this.SWITCH_CONTENT_PROVIDER_ICON, Messages.Local_Palette_SwitchToolsContentProvider_Tooltip, this.createSwitchToolsContentProviderListener());
        this.toggleContentProvider.setSelection(true);
        this.toggleContentProvider.setEnabled(false);
        this.createCheckToolBarItem(toolbar, SHOWN_TOOLS_ICON, Messages.Local_Palette_ShowTools_Tooltip, this.createsShowToolListener());
    }

    protected Listener createSwitchToolsContentProviderListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (!(event.widget instanceof ToolItem)) {
                    return;
                }
                ToolItem item = (ToolItem)event.widget;
                int index = LocalPaletteContentPage.this.profileCombo.getSelectionIndex();
                Collection<PaletteEntry> standardEntries = LocalPaletteContentPage.this.getAllVisibleStandardEntries();
                Profile profile = LocalPaletteContentPage.this.getAllAppliedProfiles().get(index);
                if (item.getSelection()) {
                    LocalPaletteContentPage.this.availableToolsViewer.setContentProvider((IContentProvider)new ProfileToolsStereotypeMetaclassTreeContentProvider(profile, standardEntries));
                    item.setSelection(true);
                } else {
                    LocalPaletteContentPage.this.availableToolsViewer.setContentProvider((IContentProvider)new ProfileToolsMetaclassStereotypeTreeContentProvider(profile, standardEntries));
                    item.setSelection(false);
                }
                LocalPaletteContentPage.this.availableToolsViewer.setInput((Object)profile);
            }
        };
    }

    protected Listener createShowDrawerListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (!(event.widget instanceof ToolItem)) {
                    return;
                }
                ToolItem item = (ToolItem)event.widget;
                if (item.getSelection()) {
                    LocalPaletteContentPage.this.availableToolsViewer.addFilter(LocalPaletteContentPage.this.drawerFilter);
                    item.setSelection(true);
                } else {
                    LocalPaletteContentPage.this.availableToolsViewer.removeFilter(LocalPaletteContentPage.this.drawerFilter);
                    item.setSelection(false);
                }
            }
        };
    }

    protected Listener createsShowToolListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (!(event.widget instanceof ToolItem)) {
                    return;
                }
                ToolItem item = (ToolItem)event.widget;
                if (item.getSelection()) {
                    LocalPaletteContentPage.this.availableToolsViewer.addFilter(LocalPaletteContentPage.this.toolFilter);
                    item.setSelection(true);
                } else {
                    LocalPaletteContentPage.this.availableToolsViewer.removeFilter(LocalPaletteContentPage.this.toolFilter);
                    item.setSelection(false);
                }
            }
        };
    }

    protected ToolItem createCheckToolBarItem(ToolBar toolbar, String shownElementsIcon, String tooltip, Listener listener) {
        ToolItem item = new ToolItem(toolbar, 2080);
        item.setImage(Activator.getPluginIconImage((String)"org.eclipse.papyrus.uml.diagram.common", (String)shownElementsIcon));
        item.setToolTipText(tooltip);
        item.addListener(13, listener);
        return item;
    }

    protected boolean validatePage() {
        boolean valid = true;
        if (valid) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return valid;
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    public void performFinish(String path) {
        Document document = this.createXMLDocumentFromPalettePreview();
        this.saveDocument(document, path);
        this.requiredProfiles = this.collectRequiredProfiles();
    }

    protected Set<String> collectRequiredProfiles() {
        HashSet<String> profiles = new HashSet<String>();
        PaletteContainerProxy rootProxy = (PaletteContainerProxy)this.paletteTreeViewer.getInput();
        this.collectRequiredProfiles(rootProxy.getChildren(), profiles);
        return profiles;
    }

    protected void collectRequiredProfiles(List<PaletteEntryProxy> proxies, Set<String> requiredProfiles) {
        for (PaletteEntryProxy proxy : proxies) {
            if (proxy instanceof PaletteAspectToolEntryProxy) {
                for (String stereotypeQN : ((PaletteAspectToolEntryProxy)proxy).getStereotypesQNList()) {
                    String profileName = PaletteUtil.findProfileNameFromStereotypeName((String)stereotypeQN);
                    requiredProfiles.add(profileName);
                }
            }
            if (proxy.getChildren() == null) continue;
            this.collectRequiredProfiles(proxy.getChildren(), requiredProfiles);
        }
    }

    protected File saveDocument(Document document, String path) {
        File file = null;
        try {
            file = Activator.getDefault().getStateLocation().append(path).toFile();
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer aTransformer = tranFactory.newTransformer();
            DOMSource src = new DOMSource(document);
            StreamResult dest = new StreamResult(file);
            aTransformer.transform(src, dest);
        }
        catch (TransformerConfigurationException e) {
            Activator.log.error((Throwable)e);
        }
        catch (TransformerException e) {
            Activator.log.error((Throwable)e);
        }
        return file;
    }

    protected Document createXMLDocumentFromPalettePreview() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.document = documentBuilder.newDocument();
            Element paletteDefElement = this.document.createElement("paletteDefinition");
            this.document.appendChild(paletteDefElement);
            Element contentElement = this.document.createElement("content");
            paletteDefElement.appendChild(contentElement);
            this.generateXMLPaletteContent(this.document, contentElement);
            return this.document;
        }
        catch (ParserConfigurationException e) {
            Activator.getDefault().logError("impossible to create the palette tree viewer content", (Throwable)e);
            return null;
        }
    }

    protected void generateXMLPaletteContent(Document document, Element contentElement) {
        PaletteContainerProxy rootProxy = (PaletteContainerProxy)this.paletteTreeViewer.getInput();
        for (PaletteEntryProxy proxy : rootProxy.getChildren()) {
            this.generateXMLPaletteContainerProxy(document, contentElement, proxy);
        }
    }

    protected void generateXMLPaletteContainerProxy(Document document, Element contentElement, PaletteEntryProxy containerProxy) {
        Element element = null;
        List<PaletteEntryProxy> children = containerProxy.getChildren();
        switch (containerProxy.getType()) {
            case DRAWER: {
                element = document.createElement("drawer");
                element.setAttribute("name", containerProxy.getLabel());
                if (!(containerProxy instanceof PaletteLocalDrawerProxy)) break;
                element.setAttribute("iconpath", ((PaletteLocalDrawerProxy)containerProxy).getImagePath());
                break;
            }
            case TOOL: {
                element = document.createElement("tool");
                break;
            }
            case SEPARATOR: {
                element = document.createElement("separator");
                break;
            }
            case STACK: {
                element = document.createElement("stack");
                break;
            }
            case ASPECT_TOOL: {
                element = document.createElement("aspectTool");
                if (!(containerProxy instanceof PaletteAspectToolEntryProxy)) break;
                PaletteAspectToolEntryProxy aspectEntryProxy = (PaletteAspectToolEntryProxy)containerProxy;
                element.setAttribute("name", aspectEntryProxy.getLabel());
                element.setAttribute("description", aspectEntryProxy.getEntry().getDescription());
                element.setAttribute("refToolId", aspectEntryProxy.getReferencedPaletteID());
                if (aspectEntryProxy.getImagePath() != null && !aspectEntryProxy.getImagePath().equals("")) {
                    element.setAttribute("iconpath", aspectEntryProxy.getImagePath());
                }
                for (IAspectAction iAspectAction : ((PaletteAspectToolEntryProxy)containerProxy).getPostActions()) {
                    Element postActionNode = document.createElement("postAction");
                    postActionNode.setAttribute("id", iAspectAction.getFactoryId());
                    iAspectAction.save((Node)postActionNode);
                    element.appendChild(postActionNode);
                }
                for (IAspectAction iAspectAction : ((PaletteAspectToolEntryProxy)containerProxy).getPreActions()) {
                    Element preActionNode = document.createElement("preAction");
                    preActionNode.setAttribute("id", iAspectAction.getFactoryId());
                    iAspectAction.save((Node)preActionNode);
                    element.appendChild(preActionNode);
                }
                break;
            }
        }
        element.setAttribute("id", containerProxy.getId());
        contentElement.appendChild(element);
        if (children != null) {
            for (PaletteEntryProxy proxy : children) {
                this.generateXMLPaletteContainerProxy(document, element, proxy);
            }
        }
    }

    protected Collection<PaletteEntry> getAllVisibleStandardEntries() {
        HashSet<PaletteEntry> result = new HashSet<PaletteEntry>();
        for (PaletteEntry entry : PaletteUtil.getAvailableEntriesSet((IEditorPart)this.editorPart, (ProviderPriority)this.priority).values()) {
            if (this.getRootParent(entry) == null) continue;
            result.add(entry);
        }
        return result;
    }

    protected PaletteRoot getRootParent(PaletteEntry entry) {
        PaletteContainer parent = entry.getParent();
        if (parent instanceof PaletteRoot) {
            return (PaletteRoot)parent;
        }
        if (parent != null) {
            return this.getRootParent((PaletteEntry)parent);
        }
        return null;
    }

    public Set<String> getRequiredProfiles() {
        return this.requiredProfiles;
    }

    public void setPriority(ProviderPriority priority) {
        this.priority = priority;
    }

    public class DrawerFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof PaletteDrawer);
        }
    }

    protected class EditElementToolBarItemValidator
    extends ToolBarItemValidator {
        protected EditElementToolBarItemValidator() {
        }

        public boolean isEnable() {
            if (LocalPaletteContentPage.this.paletteTreeViewer != null && !LocalPaletteContentPage.this.paletteTreeViewer.getControl().isDisposed()) {
                IStructuredSelection selection = (IStructuredSelection)LocalPaletteContentPage.this.paletteTreeViewer.getSelection();
                if (selection == null) {
                    return false;
                }
                return selection.getFirstElement() instanceof PaletteLocalDrawerProxy;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntryType {
        DRAWER,
        TOOL,
        STACK,
        SEPARATOR,
        ASPECT_TOOL;

    }

    public class LabelViewerComparator
    extends ViewerComparator {
        public int compare(Viewer testViewer, Object e1, Object e2) {
            String label1 = "";
            String label2 = "";
            if (e1 instanceof PaletteEntry) {
                label1 = ((PaletteEntry)e1).getLabel();
            } else if (e1 instanceof Stereotype) {
                label1 = ((Stereotype)e1).getName();
            }
            if (e2 instanceof PaletteEntry) {
                label2 = ((PaletteEntry)e2).getLabel();
            } else if (e2 instanceof Stereotype) {
                label2 = ((Stereotype)e2).getName();
            }
            if (label1 == null) {
                return 1;
            }
            if (label2 == null) {
                return -1;
            }
            return label1.compareTo(label2);
        }
    }

    public class PaletteContentProvider
    implements ITreeContentProvider {
        protected final TreeViewer viewer;
        protected PaletteContainerProxy rootProxy;
        protected PropertyChangeListener modelListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PaletteContentProvider.this.handlePropertyChanged(evt);
            }
        };

        public PaletteContentProvider(TreeViewer treeviewer) {
            this.viewer = treeviewer;
        }

        public void dispose() {
            this.traverseModel(this.rootProxy, false);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PaletteEntryProxy) {
                List<PaletteEntryProxy> children = ((PaletteEntryProxy)parentElement).getChildren();
                return children != null ? children.toArray() : new Object[]{};
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof PaletteEntryProxy) {
                return ((PaletteEntryProxy)element).getChildren() != null && !((PaletteEntryProxy)element).getChildren().isEmpty();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = this.getChildren(inputElement);
            if (elements == null) {
                elements = new Object[]{};
            }
            return elements;
        }

        public Object getParent(Object element) {
            if (element instanceof PaletteEntryProxy) {
                return ((PaletteEntryProxy)element).getParent();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (this.rootProxy != null) {
                this.traverseModel(this.rootProxy, false);
            }
            if (newInput != null) {
                this.rootProxy = (PaletteContainerProxy)newInput;
                this.traverseModel(this.rootProxy, true);
            }
        }

        protected void handlePropertyChanged(PropertyChangeEvent evt) {
            PaletteEntryProxy entry = (PaletteEntryProxy)evt.getSource();
            String property = evt.getPropertyName();
            if (property.equals("Name") || property.equals("Small Icon") || property.equals("ICON_PATH")) {
                this.viewer.update((Object)entry, null);
            } else if (property.equals("PROPERTY_ADD_CHILDREN")) {
                this.viewer.refresh((Object)entry.getParent());
                this.traverseModel((PaletteEntryProxy)evt.getNewValue(), true);
            } else if (property.equals("PROPERTY_REMOVE_CHILDREN")) {
                this.viewer.refresh((Object)entry.getParent());
                this.traverseModel((PaletteEntryProxy)evt.getOldValue(), false);
            }
        }

        protected void traverseModel(PaletteEntryProxy entryProxy, boolean isHook) {
            if (entryProxy != null) {
                if (isHook) {
                    entryProxy.addPropertyChangeListener(this.modelListener);
                } else {
                    entryProxy.removePropertyChangeListener(this.modelListener);
                }
            }
            if (entryProxy.getChildren() != null && !entryProxy.getChildren().isEmpty()) {
                for (PaletteEntryProxy proxy : entryProxy.getChildren()) {
                    this.traverseModel(proxy, isHook);
                }
            }
        }
    }

    protected class PaletteEntryProxySelectedValidator
    extends ToolBarItemValidator {
        protected PaletteEntryProxySelectedValidator() {
        }

        public boolean isEnable() {
            if (LocalPaletteContentPage.this.paletteTreeViewer != null && !LocalPaletteContentPage.this.paletteTreeViewer.getControl().isDisposed()) {
                IStructuredSelection selection = (IStructuredSelection)LocalPaletteContentPage.this.paletteTreeViewer.getSelection();
                if (selection == null) {
                    return false;
                }
                Object object = selection.getFirstElement();
                return object instanceof PaletteEntryProxy;
            }
            return false;
        }
    }

    public class PaletteLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            if (element instanceof PaletteEntry) {
                ImageDescriptor descriptor = ((PaletteEntry)element).getSmallIcon();
                if (descriptor == null) {
                    return null;
                }
                return Activator.getPluginIconImage((String)"org.eclipse.papyrus.uml.diagram.common", (ImageDescriptor)descriptor);
            }
            if (element instanceof Stereotype) {
                return Activator.getPluginIconImage((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/stereotype.gif");
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof PaletteEntry) {
                return ((PaletteEntry)element).getLabel();
            }
            if (element instanceof Stereotype) {
                return ((Stereotype)element).getName();
            }
            return "unknown element";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class PaletteProxyLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            if (element instanceof PaletteEntryProxy) {
                return ((PaletteEntryProxy)element).getImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof PaletteEntryProxy) {
                return ((PaletteEntryProxy)element).getLabel();
            }
            return "unknown element";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class ProfileComboSelectionListener
    implements SelectionListener,
    ModifyListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleSelectionChanged();
        }

        public void modifyText(ModifyEvent e) {
            this.handleSelectionChanged();
        }

        protected void handleSelectionChanged() {
            int index = LocalPaletteContentPage.this.profileCombo.getSelectionIndex();
            if (index < 0 || index >= LocalPaletteContentPage.this.profileCombo.getItems().length) {
                return;
            }
            String name = LocalPaletteContentPage.this.profileComboList.get(index);
            Collection<PaletteEntry> standardEntries = LocalPaletteContentPage.this.getAllVisibleStandardEntries();
            if (LocalPaletteContentPage.UML_TOOLS_LABEL.equals(name)) {
                LocalPaletteContentPage.this.availableToolsViewer.setContentProvider((IContentProvider)new UMLToolsTreeContentProvider());
                LocalPaletteContentPage.this.availableToolsViewer.setInput(standardEntries);
                LocalPaletteContentPage.this.toggleContentProvider.setEnabled(false);
            } else {
                if (LocalPaletteContentPage.this.toggleContentProvider != null && !LocalPaletteContentPage.this.toggleContentProvider.isDisposed()) {
                    LocalPaletteContentPage.this.toggleContentProvider.setEnabled(true);
                }
                Profile profile = LocalPaletteContentPage.this.getAllAppliedProfiles().get(index);
                if (LocalPaletteContentPage.this.toggleContentProvider.getSelection()) {
                    LocalPaletteContentPage.this.availableToolsViewer.setContentProvider((IContentProvider)new ProfileToolsStereotypeMetaclassTreeContentProvider(profile, standardEntries));
                } else {
                    LocalPaletteContentPage.this.availableToolsViewer.setContentProvider((IContentProvider)new ProfileToolsMetaclassStereotypeTreeContentProvider(profile, standardEntries));
                }
                LocalPaletteContentPage.this.availableToolsViewer.setInput((Object)profile);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProfileToolsMetaclassStereotypeTreeContentProvider
    implements ITreeContentProvider {
        protected final Collection<PaletteEntry> standardEntries;
        protected final Profile profile;

        public ProfileToolsMetaclassStereotypeTreeContentProvider(Profile profile, Collection<PaletteEntry> standardEntries) {
            this.profile = profile;
            this.standardEntries = standardEntries;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Profile) {
                return this.standardEntries.toArray();
            }
            if (parentElement instanceof AspectCreationEntry) {
                return new Object[0];
            }
            if (parentElement instanceof PaletteEntry) {
                CombinedTemplateCreationEntry entry;
                EClass toolMetaclass;
                ArrayList<AspectCreationEntry> entries = new ArrayList<AspectCreationEntry>();
                if (parentElement instanceof CombinedTemplateCreationEntry && (toolMetaclass = PaletteUtil.getToolMetaclass((ToolEntry)(entry = (CombinedTemplateCreationEntry)parentElement))) != null) {
                    for (Stereotype stereotype : this.profile.getOwnedStereotypes()) {
                        EList metaclasses = stereotype.getAllExtendedMetaclasses();
                        for (Class stMetaclass : metaclasses) {
                            EClassifier metaClassifier;
                            java.lang.Class<?> metaclassClass = stMetaclass.getClass();
                            if (metaclassClass == null || !((EClass)(metaClassifier = UMLPackage.eINSTANCE.getEClassifier(stMetaclass.getName()))).isSuperTypeOf(toolMetaclass)) continue;
                            HashMap<String, NodeList> properties = new HashMap<String, NodeList>();
                            ArrayList stereotypesQNToApply = new ArrayList();
                            properties.put("aspectActions", StereotypeAspectActionProvider.createConfigurationNode((String)stereotype.getQualifiedName()));
                            AspectCreationEntry aspectEntry = new AspectCreationEntry(String.valueOf(stereotype.getName()) + " (" + entry.getLabel() + ")", "Create an element with a stereotype", String.valueOf(entry.getId()) + "_" + System.currentTimeMillis(), entry.getSmallIcon(), entry, properties);
                            entries.add(aspectEntry);
                        }
                    }
                }
                return entries.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof Stereotype) {
                return ((Stereotype)element).getProfile();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Profile) {
                return true;
            }
            if (element instanceof AspectCreationEntry) {
                return false;
            }
            return element instanceof PaletteEntry;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Profile) {
                return this.standardEntries.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProfileToolsStereotypeMetaclassTreeContentProvider
    implements ITreeContentProvider {
        protected final Collection<PaletteEntry> standardEntries;

        public ProfileToolsStereotypeMetaclassTreeContentProvider(Profile profile, Collection<PaletteEntry> standardEntries) {
            this.standardEntries = standardEntries;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Profile) {
                return ((Profile)parentElement).getOwnedStereotypes().toArray();
            }
            if (parentElement instanceof Stereotype) {
                ArrayList<AspectCreationEntry> entries = new ArrayList<AspectCreationEntry>();
                Stereotype stereotype = (Stereotype)parentElement;
                for (PaletteEntry entry : this.standardEntries) {
                    EClass toolMetaclass;
                    if (!(entry instanceof CombinedTemplateCreationEntry) || (toolMetaclass = PaletteUtil.getToolMetaclass((ToolEntry)((CombinedTemplateCreationEntry)entry))) == null) continue;
                    EList metaclasses = stereotype.getAllExtendedMetaclasses();
                    for (Class stMetaclass : metaclasses) {
                        EClassifier metaClassifier;
                        java.lang.Class<?> metaclassClass = stMetaclass.getClass();
                        if (metaclassClass == null || !((EClass)(metaClassifier = UMLPackage.eINSTANCE.getEClassifier(stMetaclass.getName()))).isSuperTypeOf(toolMetaclass)) continue;
                        HashMap<String, NodeList> properties = new HashMap<String, NodeList>();
                        properties.put("aspectActions", StereotypeAspectActionProvider.createConfigurationNode((String)stereotype.getQualifiedName()));
                        AspectCreationEntry aspectEntry = new AspectCreationEntry(String.valueOf(stereotype.getName()) + " (" + entry.getLabel() + ")", "Create an element with a stereotype", String.valueOf(entry.getId()) + "_" + System.currentTimeMillis(), entry.getSmallIcon(), (CombinedTemplateCreationEntry)entry, properties);
                        entries.add(aspectEntry);
                    }
                }
                return entries.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof Stereotype) {
                return ((Stereotype)element).getProfile();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Profile) {
                return true;
            }
            return element instanceof Stereotype;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Profile) {
                EList stereotypes = ((Profile)inputElement).getOwnedStereotypes();
                return stereotypes.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected abstract class ToolBarItemValidator {
        protected ToolBarItemValidator() {
        }

        public abstract boolean isEnable();
    }

    public class ToolFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof ToolEntry);
        }
    }

    public class UMLToolsTreeContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            Object[] elements = null;
            if (inputElement instanceof Collection) {
                elements = ((Collection)inputElement).toArray();
            } else if (inputElement instanceof PaletteRoot) {
                elements = PaletteUtil.getAllToolEntries((PaletteContainer)((PaletteRoot)inputElement)).toArray();
            }
            if (elements == null) {
                elements = new Object[]{};
            }
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] elements = null;
            if (parentElement instanceof Collection) {
                elements = ((Collection)parentElement).toArray();
            } else if (parentElement instanceof PaletteRoot) {
                elements = PaletteUtil.getAllToolEntries((PaletteContainer)((PaletteRoot)parentElement)).toArray();
            }
            return elements;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null && this.getChildren(element).length > 0;
        }
    }
}

