/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.utils.EMFHelper;

public class ProxyModificationTrackingAdapter
extends EContentAdapter {
    protected void setTarget(Resource target) {
        this.basicSetTarget((Notifier)target);
    }

    protected void unsetTarget(Resource target) {
        this.basicUnsetTarget((Notifier)target);
    }

    protected void setTarget(EObject target) {
    }

    protected void unsetTarget(EObject target) {
    }

    public void notifyChanged(Notification n) {
        Object notifier = n.getNotifier();
        if (notifier instanceof Resource.Internal) {
            Resource.Internal r = (Resource.Internal)notifier;
            if (n.getEventType() == 1 && n.getFeatureID(Resource.class) == 1) {
                r.setModified(true);
                TreeIterator properContents = EcoreUtil.getAllProperContents((Resource)r, (boolean)false);
                while (properContents.hasNext()) {
                    Object obj = properContents.next();
                    if (!(obj instanceof EObject)) continue;
                    this.setReferencingResourcesAsModified((EObject)obj);
                }
            } else {
                List objects = new ArrayList<Object>();
                switch (n.getEventType()) {
                    case 5: {
                        objects = (List)n.getNewValue();
                        break;
                    }
                    case 6: {
                        objects = (List)n.getOldValue();
                        break;
                    }
                    case 3: {
                        objects.add(n.getNewValue());
                        break;
                    }
                    case 4: {
                        objects.add(n.getOldValue());
                    }
                }
                if (r.isLoaded() && !r.isLoading()) {
                    if (!objects.isEmpty()) {
                        r.setModified(true);
                    }
                    for (Object o : objects) {
                        if (!(o instanceof EObject)) continue;
                        TreeIterator properContents = EcoreUtil.getAllProperContents((EObject)((EObject)o), (boolean)false);
                        while (properContents.hasNext()) {
                            Object obj = properContents.next();
                            if (!(obj instanceof EObject)) continue;
                            this.setReferencingResourcesAsModified((EObject)obj);
                        }
                    }
                }
            }
        }
        super.notifyChanged(n);
    }

    protected void setReferencingResourcesAsModified(EObject eObj) {
        Collection<EStructuralFeature.Setting> references = EMFHelper.getUsages(eObj);
        for (EStructuralFeature.Setting setting : references) {
            Resource.Internal refResource;
            EStructuralFeature f = setting.getEStructuralFeature();
            if (setting.getEObject() == null || f.isDerived() || f.isTransient() || (refResource = (Resource.Internal)setting.getEObject().eResource()) == null || refResource.isLoading()) continue;
            refResource.setModified(true);
        }
    }
}

