/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.commands.util;

import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.papyrus.commands.INonDirtying;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonDirtyingUtils {
    private NonDirtyingUtils() {
    }

    public static IUndoableOperation wrap(TransactionalEditingDomain domain, Command command) {
        if (command instanceof AbstractCommand.NonDirtying) {
            return new NonDirtyingEMFCommandOperation(domain, command);
        }
        return new EMFCommandOperation(domain, command);
    }

    public static IUndoableOperation wrap(TransactionalEditingDomain domain, Command command, Map<?, ?> options) {
        if (command instanceof AbstractCommand.NonDirtying) {
            return new NonDirtyingEMFCommandOperation(domain, command, options);
        }
        return new EMFCommandOperation(domain, command, options);
    }

    public static CompoundCommand nonDirtyingEMFCompound() {
        return new NonDirtyingEMFCompoundCommand();
    }

    public static ICommand wrap(org.eclipse.gef.commands.Command command) {
        NonDirytingCommandProxy result = command instanceof INonDirtying ? new NonDirytingCommandProxy(command) : new CommandProxy(command);
        return result;
    }

    public static Command chain(Command command1, Command command2) {
        if (command1 instanceof AbstractCommand.NonDirtying && command2 instanceof AbstractCommand.NonDirtying) {
            return new NonDirtyingEMFCompoundCommand().chain(command1).chain(command2);
        }
        return command1.chain(command2);
    }

    public static org.eclipse.gef.commands.CompoundCommand nonDirtyingGEFCompound() {
        return new NonDirtyingGEFCompoundCommand();
    }

    public static org.eclipse.gef.commands.Command chain(org.eclipse.gef.commands.Command command1, org.eclipse.gef.commands.Command command2) {
        if (command1 instanceof INonDirtying && command2 instanceof INonDirtying) {
            return new NonDirtyingGEFCompoundCommand().chain(command1).chain(command2);
        }
        return command1.chain(command2);
    }

    public static CompositeCommand nonDirtyingGMFComposite(String label) {
        return new NonDirtyingGMFCompositeCommand(label);
    }

    public static ICommand compose(ICommand command1, ICommand command2) {
        if (command1 instanceof INonDirtying && command2 instanceof INonDirtying) {
            return new NonDirtyingGMFCompositeCommand(command1.getLabel()).compose((IUndoableOperation)command1).compose((IUndoableOperation)command2);
        }
        return command1.compose((IUndoableOperation)command2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonDirtyingEMFCommandOperation
    extends EMFCommandOperation
    implements INonDirtying {
        NonDirtyingEMFCommandOperation(TransactionalEditingDomain domain, Command command, Map<?, ?> options) {
            super(domain, NonDirtyingEMFCommandOperation.checkCommand(command), options);
        }

        NonDirtyingEMFCommandOperation(TransactionalEditingDomain domain, Command command) {
            super(domain, NonDirtyingEMFCommandOperation.checkCommand(command));
        }

        static Command checkCommand(Command command) {
            if (!(command instanceof AbstractCommand.NonDirtying)) {
                throw new IllegalStateException("Attempt to wrap dirtying command in a non-dirtying operation.");
            }
            return command;
        }
    }

    private static class NonDirtyingEMFCompoundCommand
    extends CompoundCommand
    implements AbstractCommand.NonDirtying {
        private NonDirtyingEMFCompoundCommand() {
        }

        public void append(Command command) {
            this.checkNonDirtying(command);
            super.append(command);
        }

        public boolean appendAndExecute(Command command) {
            this.checkNonDirtying(command);
            return super.appendAndExecute(command);
        }

        public boolean appendIfCanExecute(Command command) {
            this.checkNonDirtying(command);
            return super.appendIfCanExecute(command);
        }

        public Command chain(Command command) {
            this.append(command);
            return this;
        }

        private void checkNonDirtying(Command command) {
            if (!(command instanceof AbstractCommand.NonDirtying)) {
                throw new IllegalArgumentException("Attempt to append a dirtying command to a non-dirtying compound.");
            }
        }
    }

    private static class NonDirtyingGEFCompoundCommand
    extends org.eclipse.gef.commands.CompoundCommand
    implements INonDirtying {
        private NonDirtyingGEFCompoundCommand() {
        }

        public void add(org.eclipse.gef.commands.Command command) {
            if (command != null) {
                this.checkNonDirtying(command);
                super.add(command);
            }
        }

        public org.eclipse.gef.commands.Command chain(org.eclipse.gef.commands.Command command) {
            this.add(command);
            return this;
        }

        private void checkNonDirtying(org.eclipse.gef.commands.Command command) {
            if (!(command instanceof INonDirtying)) {
                throw new IllegalArgumentException("Attempt to append a dirtying command to a non-dirtying compound.");
            }
        }
    }

    private static class NonDirtyingGMFCompositeCommand
    extends CompositeCommand
    implements INonDirtying {
        NonDirtyingGMFCompositeCommand(String label) {
            super(label);
        }

        public void add(IUndoableOperation operation) {
            this.checkNonDirtying(operation);
            super.add(operation);
        }

        private void checkNonDirtying(IUndoableOperation operation) {
            if (!(operation instanceof INonDirtying)) {
                throw new IllegalArgumentException("Attempt to append a dirtying operation to a non-dirtying composite.");
            }
        }
    }

    private static class NonDirytingCommandProxy
    extends CommandProxy
    implements INonDirtying {
        NonDirytingCommandProxy(org.eclipse.gef.commands.Command command) {
            super(command);
        }
    }
}

