/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.figure.edge;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.papyrus.infra.core.editor.CoreMultiDiagramEditor;
import org.eclipse.papyrus.infra.tools.util.EditorHelper;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class PapyrusEdgeFigure
extends PolylineConnectionEx {
    private int bendpointDiameter;

    public PapyrusEdgeFigure() {
        this.setBendPointDiameter(7);
    }

    protected void outlineShape(Graphics g) {
        super.outlineShape(g);
        this.drawConnectionPoint(g);
    }

    public void resetStyle() {
    }

    protected void drawConnectionPoint(Graphics g) {
        Map<?, ?> visualPartMap;
        PointList bendPoints = this.getPoints();
        if (this.getDrawBendpointPreferenceValue() && bendPoints.size() > 2 && this.getBendPointDiameter() > 1 && (visualPartMap = this.getVisualPartMap((IFigure)this)) != null) {
            EObject el;
            EditPart currentEditPart = (EditPart)visualPartMap.get((Object)this);
            EClass eClass = null;
            if (currentEditPart instanceof IGraphicalEditPart && (el = ((IGraphicalEditPart)currentEditPart).resolveSemanticElement()) != null) {
                eClass = el.eClass();
            }
            if (currentEditPart instanceof ConnectionEditPart && eClass != null) {
                EditPart sourceEP = ((ConnectionEditPart)currentEditPart).getSource();
                EditPart targetEP = ((ConnectionEditPart)currentEditPart).getTarget();
                HashSet allConnectionsEP = new HashSet();
                if (sourceEP instanceof AbstractGraphicalEditPart && targetEP instanceof AbstractGraphicalEditPart) {
                    allConnectionsEP.addAll(((AbstractGraphicalEditPart)sourceEP).getSourceConnections());
                    allConnectionsEP.addAll(((AbstractGraphicalEditPart)targetEP).getSourceConnections());
                    allConnectionsEP.addAll(((AbstractGraphicalEditPart)sourceEP).getTargetConnections());
                    allConnectionsEP.addAll(((AbstractGraphicalEditPart)targetEP).getTargetConnections());
                    allConnectionsEP.remove(currentEditPart);
                }
                HashSet<Connection> allConnections = new HashSet<Connection>();
                if (allConnectionsEP.size() > 0) {
                    for (Object current : allConnectionsEP) {
                        IFigure currentFig;
                        EObject resolvedElement;
                        if (!current.getClass().isInstance(currentEditPart) || !currentEditPart.getClass().isInstance(current) || !(current instanceof IGraphicalEditPart) || (resolvedElement = ((IGraphicalEditPart)current).resolveSemanticElement()) != null && eClass != null && resolvedElement.eClass() != eClass || !((currentFig = ((IGraphicalEditPart)current).getFigure()) instanceof Connection)) continue;
                        allConnections.add((Connection)currentFig);
                    }
                }
                if (allConnections.size() > 0) {
                    HashMap<Point, Boolean> visibility = new HashMap<Point, Boolean>();
                    visibility.put(bendPoints.getFirstPoint(), Boolean.FALSE);
                    visibility.put(bendPoints.getLastPoint(), Boolean.FALSE);
                    int i = 1;
                    while (i < bendPoints.size() - 1) {
                        Point currentPt = bendPoints.getPoint(i);
                        visibility.put(currentPt, this.isACommonBendpoint((Connection)this, i, allConnections));
                        ++i;
                    }
                    int indexFirstOne = -1;
                    int i2 = 0;
                    while (i2 < bendPoints.size()) {
                        boolean first = (Boolean)visibility.get(bendPoints.getPoint(i2));
                        if (first && indexFirstOne < 0) {
                            indexFirstOne = i2;
                        }
                        if (!first && indexFirstOne >= 0) {
                            int j = indexFirstOne + 1;
                            while (j < i2 - 1) {
                                visibility.put(bendPoints.getPoint(j), false);
                                ++j;
                            }
                            indexFirstOne = -1;
                        }
                        ++i2;
                    }
                    if (this.getBackgroundColor() != null) {
                        g.setForegroundColor(this.getBackgroundColor());
                    }
                    if (this.getForegroundColor() != null) {
                        g.setBackgroundColor(this.getForegroundColor());
                    }
                    int diameter = this.getBendPointDiameter();
                    int i3 = 1;
                    while (i3 < bendPoints.size() - 1) {
                        Point currentPt = bendPoints.getPoint(i3);
                        if (((Boolean)visibility.get(currentPt)).booleanValue()) {
                            g.fillOval(currentPt.x - (diameter - 1) / 2, currentPt.y - (diameter - 1) / 2, diameter, diameter);
                        }
                        ++i3;
                    }
                    if (this.getBackgroundColor() != null) {
                        g.setBackgroundColor(this.getBackgroundColor());
                    }
                    if (this.getForegroundColor() != null) {
                        g.setForegroundColor(this.getForegroundColor());
                    }
                }
            }
        }
    }

    protected boolean getDrawBendpointPreferenceValue() {
        return false;
    }

    protected Map<?, ?> getVisualPartMap(IFigure figure) {
        block3: {
            IWorkbenchWindow window;
            block2: {
                IEditorPart part = EditorHelper.getCurrentEditor();
                if (!(part instanceof CoreMultiDiagramEditor)) break block2;
                List visibleEditors = ((CoreMultiDiagramEditor)part).getISashWindowsContainer().getVisibleIEditorParts();
                for (IEditorPart current : visibleEditors) {
                    GraphicalViewer viewer = (GraphicalViewer)current.getAdapter(GraphicalViewer.class);
                    Map visualPartMap = viewer.getVisualPartMap();
                    if (!visualPartMap.containsKey(figure)) continue;
                    return visualPartMap;
                }
                break block3;
            }
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench == null || (window = workbench.getActiveWorkbenchWindow()) == null) break block3;
            List editors = EditorService.getInstance().getRegisteredEditorParts();
            for (IEditorPart editor : editors) {
                IDiagramWorkbenchPart de;
                IDiagramGraphicalViewer viewer;
                Map visualPartMap;
                if (editor.getEditorSite().getWorkbenchWindow() != window || !(editor instanceof IDiagramWorkbenchPart) || !(visualPartMap = (viewer = (de = (IDiagramWorkbenchPart)editor).getDiagramGraphicalViewer()).getVisualPartMap()).containsKey(figure)) continue;
                return visualPartMap;
            }
        }
        return null;
    }

    public boolean isACommonBendpoint(Connection figure, int indexOfTheTestedPoint, Collection<Connection> connections) {
        PointList list = figure.getPoints();
        Point thePoint = list.getPoint(indexOfTheTestedPoint);
        for (Connection current : connections) {
            PointList localList = current.getPoints();
            int i = 0;
            while (i < localList.size() - 1) {
                Point tmp2;
                Point tmp1 = localList.getPoint(i);
                boolean isOnSegment = PapyrusEdgeFigure.isOnSegment(thePoint, tmp1, tmp2 = localList.getPoint(i + 1));
                if (isOnSegment) {
                    boolean isOnSegment2 = PapyrusEdgeFigure.isOnSegment(list.getPoint(indexOfTheTestedPoint + 1), tmp1, tmp2);
                    if (isOnSegment2) {
                        return true;
                    }
                    isOnSegment2 = PapyrusEdgeFigure.isOnSegment(list.getPoint(indexOfTheTestedPoint - 1), tmp1, tmp2);
                    if (isOnSegment2) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static final boolean isOnSegment(Point pt, Point pt1, Point pt2) {
        Point second;
        Point first;
        if (pt1.x < pt2.x) {
            first = pt1;
            second = pt2;
        } else {
            first = pt2;
            second = pt1;
        }
        if (pt.x >= first.x && pt.x <= second.x && (pt.y <= first.y && pt.y >= second.y || pt.y >= first.y && pt.y <= second.y)) {
            double firstX = first.preciseX();
            double secondX = second.preciseX();
            double firstY = first.preciseY();
            double secondY = second.preciseY();
            if (secondX == firstX) {
                return pt.preciseX() == secondX;
            }
            double a = (secondY - firstY) / (secondX - firstX);
            double b = firstY - a * firstX;
            return pt.preciseY() == a * pt.preciseX() + b;
        }
        return false;
    }

    public void setBendPointDiameter(int diameter) {
        if (diameter <= 1) {
            this.bendpointDiameter = 0;
        }
        if (diameter % 2 != 0) {
            this.bendpointDiameter = diameter;
        } else {
            this.setBendPointDiameter(diameter + 1);
        }
    }

    protected final int getBendPointDiameter() {
        return this.bendpointDiameter;
    }
}

