/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.providers;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.providers.IThemeInitializer;

public class ThemeInitializerManager {
    private static final String EXTENSION_ID = "org.eclipse.papyrus.infra.gmfdiag.common.initializeView";
    public static IThemeInitializer instance = ThemeInitializerManager.loadThemeInitializer();

    private static IThemeInitializer loadThemeInitializer() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                IThemeInitializer initializer = (IThemeInitializer)e.createExecutableExtension("initializeView");
                if (initializer != null) {
                    return initializer;
                }
            }
            catch (Exception ex) {
                Activator.log.error("The plugin " + e.getContributor().getName() + " contributed an invalid extension for " + EXTENSION_ID, (Throwable)ex);
            }
            ++n2;
        }
        return new DefaultThemeInitializer();
    }

    private static class DefaultThemeInitializer
    implements IThemeInitializer {
        private DefaultThemeInitializer() {
        }

        @Override
        public boolean usePreferenceInitializer(View view) {
            return true;
        }
    }
}

