/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.infra.viewpoints.style.PapyrusViewStyle;
import org.eclipse.papyrus.infra.viewpoints.style.StylePackage;

public class DiagramUtils {
    public static Diagram getDiagramFrom(EditPart part) {
        for (EditPart current = part; current != null; current = current.getParent()) {
            Object model = current.getModel();
            if (model instanceof Diagram) {
                return (Diagram)model;
            }
            if (current.getParent() != null) {
                continue;
            }
            if (current.getChildren().size() == 0) {
                return null;
            }
            model = (current = (EditPart)current.getChildren().get(0)).getModel();
            return model instanceof Diagram ? (Diagram)model : null;
        }
        return null;
    }

    public static EObject getOwner(Diagram diagram) {
        PapyrusViewStyle pvs;
        EObject value;
        Style style = diagram.getStyle(StylePackage.Literals.PAPYRUS_VIEW_STYLE);
        if (style != null && (value = (pvs = (PapyrusViewStyle)style).getOwner()) != null) {
            return value;
        }
        return diagram.getElement();
    }

    public static void setOwner(Diagram diagram, EObject owner) {
        Style style = diagram.getStyle(StylePackage.Literals.PAPYRUS_VIEW_STYLE);
        if (style != null) {
            PapyrusViewStyle pvs = (PapyrusViewStyle)style;
            pvs.setOwner(owner);
        } else {
            PapyrusViewStyle pvs = (PapyrusViewStyle)diagram.createStyle(StylePackage.Literals.PAPYRUS_VIEW_STYLE);
            pvs.setOwner(owner);
        }
    }

    public static ViewPrototype getPrototype(Diagram diagram) {
        Style style = diagram.getStyle(StylePackage.Literals.PAPYRUS_VIEW_STYLE);
        if (style != null) {
            PapyrusViewStyle pvs = (PapyrusViewStyle)style;
            PapyrusView config = pvs.getConfiguration();
            if (config != null) {
                if (PolicyChecker.getCurrent().isInViewpoint(config)) {
                    return ViewPrototype.get((PapyrusView)config);
                }
                return ViewPrototype.UNAVAILABLE_DIAGRAM;
            }
            return ViewPrototype.get((String)diagram.getType(), (EObject)pvs.getOwner(), (EObject)diagram.getElement());
        }
        if ("Package".equals(diagram.getType())) {
            for (ViewPrototype prototype : PolicyChecker.getCurrent().getAllPrototypes()) {
                if (!"UML Package Diagram".equals(prototype.getLabel())) continue;
                return prototype;
            }
        }
        return ViewPrototype.get((String)diagram.getType(), (EObject)diagram.getElement(), (EObject)diagram.getElement());
    }

    public static void setPrototype(Diagram diagram, ViewPrototype prototype) {
        Style style = diagram.getStyle(StylePackage.Literals.PAPYRUS_VIEW_STYLE);
        if (style != null) {
            PapyrusViewStyle pvs = (PapyrusViewStyle)style;
            pvs.setConfiguration(prototype.getConfiguration());
        } else {
            PapyrusViewStyle pvs = (PapyrusViewStyle)diagram.createStyle(StylePackage.Literals.PAPYRUS_VIEW_STYLE);
            pvs.setConfiguration(prototype.getConfiguration());
        }
    }
}

