/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.modelelement;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.providers.LineStyleLabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.providers.UnitsLabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.AbstractDiagramPreferencesObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.BooleanDiagramViewObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.DoubleDiagramViewObservaleValue;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.IntegerDiagramViewObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.RulersUnitObservableValue;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;
import org.eclipse.papyrus.views.properties.modelelement.AbstractModelElement;

public class RulerAndGridModelElement
extends AbstractModelElement {
    private Diagram diagram;
    private IPreferenceStore store;

    public RulerAndGridModelElement(Diagram view, EditingDomain domain, DataContextElement context, IPreferenceStore preferenceStore) {
        this.diagram = view;
        this.store = preferenceStore;
    }

    public void dispose() {
        super.dispose();
        this.diagram = null;
        this.store = null;
    }

    protected IObservable doGetObservable(String propertyPath) {
        AbstractDiagramPreferencesObservableValue observable = null;
        if ("grid.isDisplayingGrid".equals(propertyPath)) {
            observable = new BooleanDiagramViewObservableValue(this.diagram, "rulergrid.viewgrid", this.store);
        }
        if ("rulers.isDisplayingRulers".equals(propertyPath)) {
            observable = new BooleanDiagramViewObservableValue(this.diagram, "rulergrid.viewrulers", this.store);
        }
        if ("grid.isInFront".equals(propertyPath)) {
            observable = new BooleanDiagramViewObservableValue(this.diagram, "rulergrid.gridlevel", this.store);
        }
        if ("grid.color".equals(propertyPath)) {
            observable = new IntegerDiagramViewObservableValue(this.diagram, "rulergrid.gridlinecolor", this.store);
        }
        if ("grid.style".equals(propertyPath)) {
            observable = new IntegerDiagramViewObservableValue(this.diagram, "rulergrid.gridlinestyle", this.store);
        }
        if ("grid.spacing".equals(propertyPath)) {
            observable = new DoubleDiagramViewObservaleValue(this.diagram, "rulergrid.gridspacing", this.store);
        }
        if ("grid.isSnapToGrid".equals(propertyPath)) {
            observable = new BooleanDiagramViewObservableValue(this.diagram, "rulergrid.snaptogrid", this.store);
        }
        if ("grid.isSnapToShapes".equals(propertyPath)) {
            observable = new BooleanDiagramViewObservableValue(this.diagram, "rulergrid.snaptogeometry", this.store);
        }
        if ("rulers.units".equals(propertyPath)) {
            observable = new RulersUnitObservableValue(this.diagram, this.store);
        }
        return observable;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        if ("grid.style".equals(propertyPath)) {
            return new StaticContentProvider(new Object[]{2, 4, 5, 3, 1, 6});
        }
        if ("rulers.units".equals(propertyPath)) {
            return new StaticContentProvider(new Object[]{0, 1, 2});
        }
        return super.getContentProvider(propertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        if ("grid.style".equals(propertyPath)) {
            return new LineStyleLabelProvider();
        }
        if ("rulers.units".equals(propertyPath)) {
            return new UnitsLabelProvider();
        }
        return null;
    }

    public boolean isMandatory(String propertyPath) {
        return "grid.style".equals(propertyPath) || "rulers.units".equals(propertyPath);
    }

    public boolean forceRefresh(String propertyPath) {
        return true;
    }
}

