/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.common.utils.TableEditorInput;
import org.eclipse.papyrus.infra.nattable.listener.NatTableDropListener;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.NattableconfigurationPackage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractEMFNattableEditor
extends EditorPart {
    protected ServicesRegistry servicesRegistry;
    protected final INattableModelManager tableManager;
    private PartNameSynchronizer synchronizer;
    private PreferenceStore workspacePreferenceStore;

    public AbstractEMFNattableEditor(ServicesRegistry servicesRegistry, Table rawModel) {
        this.servicesRegistry = servicesRegistry;
        this.tableManager = new EMFNattableModelManager(rawModel);
        this.synchronizer = new PartNameSynchronizer(rawModel);
        this.workspacePreferenceStore = this.getWorkspaceViewerPreferenceStore();
    }

    public PreferenceStore getWorkspaceViewerPreferenceStore() {
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        TableEditorInput tableEditorInput = new TableEditorInput(this.tableManager.getTable(), this.getEditingDomain());
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(tableEditorInput);
        this.setPartName(this.tableManager.getTable().getName());
    }

    public TransactionalEditingDomain getEditingDomain() {
        try {
            return ServiceUtils.getInstance().getTransactionalEditingDomain((Object)this.servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }

    public void createPartControl(Composite parent) {
        this.tableManager.createNattable(parent, 0, this.getSite());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == INattableModelManager.class) {
            return this.tableManager;
        }
        if (adapter == Table.class && this.tableManager != null) {
            return this.tableManager.getTable();
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        this.saveLocalPreferenceStoreValues();
        this.tableManager.dispose();
        this.synchronizer.dispose();
        super.dispose();
    }

    protected void saveLocalPreferenceStoreValues() {
        try {
            if (this.getWorkspaceViewerPreferenceStore() != null && this.getWorkspaceViewerPreferenceStore().needsSaving()) {
                this.getWorkspaceViewerPreferenceStore().save();
            }
        }
        catch (IOException ioe) {
            Activator.log.warn("Preferences can' be saved");
        }
    }

    private static class EMFNattableModelManager
    extends NattableModelManager {
        EMFNattableModelManager(Table rawModel) {
            super(rawModel);
        }

        protected NatTableDropListener createDropListener() {
            return new NatTableDropListener((INattableModelManager)this){

                protected Collection<?> extractSelectedObjects(IStructuredSelection structuredSelection) {
                    ArrayList<EObject> result = new ArrayList<EObject>(structuredSelection.size());
                    Iterator iter = structuredSelection.iterator();
                    while (iter.hasNext()) {
                        EObject eObject = EMFHelper.getEObject(iter.next());
                        if (eObject == null) continue;
                        result.add(eObject);
                    }
                    return result;
                }
            };
        }
    }

    public class PartNameSynchronizer {
        private Table papyrusTable;
        private final Adapter tableNameListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeature() == NattableconfigurationPackage.eINSTANCE.getTableNamedElement_Name()) {
                    AbstractEMFNattableEditor.this.setPartName(PartNameSynchronizer.this.papyrusTable.getName());
                }
            }
        };

        public PartNameSynchronizer(Table papyrusTable) {
            this.setTable(papyrusTable);
        }

        public void dispose() {
            this.papyrusTable.eAdapters().remove((Object)this.tableNameListener);
            this.papyrusTable = null;
        }

        public void setTable(Table papyrusTable) {
            if (this.papyrusTable != null) {
                papyrusTable.eAdapters().remove((Object)this.tableNameListener);
            }
            this.papyrusTable = papyrusTable;
            AbstractEMFNattableEditor.this.setPartName(papyrusTable.getName());
            papyrusTable.eAdapters().add((Object)this.tableNameListener);
        }
    }
}

