/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.configuration;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.tools.util.EclipseCommandUtils;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PapyrusPopupMenuAction
extends PopupMenuAction {
    private final String category;

    public PapyrusPopupMenuAction(String categoryId) {
        super(null);
        this.category = categoryId;
    }

    public void run(NatTable natTable, MouseEvent event) {
        Menu menu = new Menu((Control)natTable.getShell());
        this.buildMenu(menu, event.data);
        menu.setData(event.data);
        menu.setVisible(true);
    }

    private void buildMenu(Menu popupMenu, Object eventData) {
        Collection commands = EclipseCommandUtils.getAllExistingCommandsInCategory((String)this.category);
        for (final Command command : commands) {
            final IHandler handler = command.getHandler();
            if (handler == null || !(handler instanceof AbstractHandler)) continue;
            ((AbstractHandler)handler).setEnabled(null);
            boolean isEnabled = handler.isEnabled();
            if (!isEnabled) continue;
            MenuItem item = new MenuItem(popupMenu, 8);
            item.setEnabled(true);
            item.setImage(EclipseCommandUtils.getCommandIcon((Command)command).createImage());
            try {
                item.setText(command.getName());
            }
            catch (NotDefinedException e) {
                Activator.log.error((Throwable)e);
            }
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        Map parameters = Collections.emptyMap();
                        handler.execute(new ExecutionEvent(command, parameters, null, null));
                    }
                    catch (ExecutionException e1) {
                        Activator.log.error((Throwable)e1);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }
}

