/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.ICompositeAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.IIdAxisManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.utils.AxisComparator;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.providers.CompoundFilteredRestrictedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;

public class CompositeAxisManager
extends AbstractAxisManager
implements ICompositeAxisManager {
    private static final String MANAGER_ID = "org.eclipse.papyrus.infra.nattable.composite.axis.manager";
    protected List<IAxisManager> subManagers;
    protected Comparator<Object> axisComparator;

    @Override
    protected void axisManagerHasChanged(Notification notification) {
        if (notification.isTouch()) {
            return;
        }
        ArrayList<Object> newListValue = new ArrayList<Object>(this.managedObject);
        boolean needRefresh = false;
        int eventType = notification.getEventType();
        switch (eventType) {
            case 3: {
                Object addedValue = notification.getNewValue();
                int index = notification.getPosition();
                newListValue.add(index, addedValue);
                needRefresh = true;
                break;
            }
            case 5: {
                Collection addedValues = (Collection)notification.getNewValue();
                newListValue.addAll(addedValues);
                needRefresh = true;
                break;
            }
            case 10: {
                break;
            }
            case 7: {
                Object movedObject = notification.getNewValue();
                int newPos = notification.getPosition();
                newListValue.remove(movedObject);
                newListValue.add(newPos, movedObject);
                needRefresh = true;
                break;
            }
            case 4: {
                Object removedObject = notification.getOldValue();
                newListValue.remove(removedObject);
                needRefresh = true;
                break;
            }
            case 6: {
                Collection removedValues = (Collection)notification.getOldValue();
                newListValue.removeAll(removedValues);
                needRefresh = true;
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        if (needRefresh) {
            this.managedObject.clear();
            this.managedObject.addAll(newListValue);
            newListValue.clear();
            this.getTableManager().updateAxisContents(this.getRepresentedContentProvider());
        }
    }

    @Override
    protected void initializeManagedObjectList() {
        for (IAxis current : this.getRepresentedContentProvider().getAxis()) {
            this.managedObject.add(current);
        }
    }

    @Override
    public void setSubAxisManager(List<IAxisManager> managers) {
        this.subManagers = managers;
        this.updateAxisContents();
    }

    @Override
    public void dispose() {
        super.dispose();
        for (IAxisManager current : this.subManagers) {
            current.dispose();
        }
        this.subManagers.clear();
    }

    @Override
    public boolean canBeUsedAsRowManager() {
        boolean answer = true;
        Iterator<IAxisManager> iter = this.subManagers.iterator();
        while (iter.hasNext() && answer) {
            answer = iter.next().canBeUsedAsRowManager();
        }
        return answer;
    }

    @Override
    public boolean canBeUsedAsColumnManager() {
        boolean answer = true;
        Iterator<IAxisManager> iter = this.subManagers.iterator();
        while (iter.hasNext() && answer) {
            answer = iter.next().canBeUsedAsColumnManager();
        }
        return answer;
    }

    @Override
    public boolean canCreateAxisElement(String elementId) {
        boolean canCreateAxisElement = false;
        for (IAxisManager manager : this.subManagers) {
            canCreateAxisElement |= manager.canCreateAxisElement(elementId);
        }
        return canCreateAxisElement;
    }

    @Override
    public Command getAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        CompoundCommand cmd = new CompoundCommand(Messages.CompositeAxisManager_AddAxisCommand);
        for (IAxisManager current : this.subManagers) {
            Command tmp = current.getAddAxisCommand(domain, objectToAdd);
            if (tmp == null) continue;
            cmd.append(tmp);
        }
        if (cmd.isEmpty()) {
            return null;
        }
        return cmd;
    }

    @Override
    public Command getComplementaryAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        CompoundCommand cmd = new CompoundCommand(Messages.CompositeAxisManager_AddAxisCommand);
        for (IAxisManager current : this.subManagers) {
            Command tmp = current.getComplementaryAddAxisCommand(domain, objectToAdd);
            if (tmp == null) continue;
            cmd.append(tmp);
        }
        if (cmd.isEmpty()) {
            return null;
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateAxisContents() {
        List<Object> displayedElement;
        List<Object> list = displayedElement = this.getElements();
        synchronized (list) {
            displayedElement.clear();
            displayedElement.addAll(this.managedObject);
            if (this.subManagers != null) {
                for (IAxisManager current : this.subManagers) {
                    if (!current.isDynamic()) continue;
                    displayedElement.addAll(current.getAllManagedAxis());
                }
            }
            if (this.axisComparator != null) {
                Collections.sort(displayedElement, this.axisComparator);
            }
        }
    }

    @Override
    public boolean isAllowedContents(Object object) {
        for (IAxisManager current : this.subManagers) {
            if (!current.isAllowedContents(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canMoveAxis() {
        for (IAxisManager current : this.subManagers) {
            if (current.canMoveAxis() && !current.isDynamic()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void sortAxisByName(boolean alphabeticOrder, IConfigRegistry configRegistry) {
        if (this.canMoveAxis()) {
            ArrayList axis = new ArrayList(this.getRepresentedContentProvider().getAxis());
            Collections.sort(axis, new AxisComparator(alphabeticOrder, configRegistry));
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.getRepresentedContentProvider());
            SetRequest request = new SetRequest(domain, (EObject)this.getRepresentedContentProvider(), (EStructuralFeature)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), axis);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.getRepresentedContentProvider());
            ICommand cmd = provider.getEditCommand((IEditCommandRequest)request);
            domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(cmd));
        }
    }

    @Override
    public IRestrictedContentProvider createPossibleAxisContentProvider(boolean isRestricted) {
        CompoundFilteredRestrictedContentProvider compoundContentProvider = null;
        for (IAxisManager current : this.subManagers) {
            IRestrictedContentProvider contentProvider = current.createPossibleAxisContentProvider(isRestricted);
            if (contentProvider == null) continue;
            if (compoundContentProvider == null) {
                compoundContentProvider = new CompoundFilteredRestrictedContentProvider();
            }
            compoundContentProvider.add(contentProvider);
        }
        return compoundContentProvider;
    }

    @Override
    public Command getDestroyAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToDestroy) {
        CompoundCommand cmd = new CompoundCommand(Messages.CompositeAxisManager_DestroyAxisCommand);
        for (IAxisManager current : this.subManagers) {
            Command tmp = current.getDestroyAxisCommand(domain, objectToDestroy);
            if (tmp == null) continue;
            cmd.append(tmp);
        }
        if (cmd.isEmpty()) {
            return null;
        }
        return cmd;
    }

    @Override
    public List<Object> getAllManagedAxis() {
        ArrayList<Object> allExistingAxis = new ArrayList<Object>();
        for (IAxisManager manager : this.subManagers) {
            List<Object> managerPossibleElements = manager.getAllManagedAxis();
            if (managerPossibleElements == null) continue;
            allExistingAxis.addAll(managerPossibleElements);
        }
        return allExistingAxis;
    }

    public List<Object> getAllManagedAxis(boolean resolve) {
        ArrayList<Object> allExistingAxis = new ArrayList<Object>();
        for (IAxis current : this.getRepresentedContentProvider().getAxis()) {
            Object representedElement = AxisUtils.getRepresentedElement(current);
            if (resolve && current instanceof IdAxis) {
                representedElement = this.getResolvedPath((IdAxis)current);
            }
            allExistingAxis.add(representedElement);
        }
        for (IAxisManager manager : this.subManagers) {
            List<Object> managerPossibleElements;
            if (!manager.isDynamic() || (managerPossibleElements = manager.getAllManagedAxis()) == null) continue;
            allExistingAxis.addAll(managerPossibleElements);
        }
        return allExistingAxis;
    }

    @Override
    public boolean isSlave() {
        for (IAxisManager manager : this.subManagers) {
            if (!manager.isSlave()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDynamic() {
        for (IAxisManager manager : this.subManagers) {
            if (!manager.isDynamic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canDropAxisElement(Collection<Object> objectsToAdd) {
        for (IAxisManager current : this.subManagers) {
            if (!current.canDropAxisElement(objectsToAdd)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void moveAxis(Object elementToMove, int newIndex) {
        if (!this.isDynamic() && elementToMove instanceof IAxis) {
            TransactionalEditingDomain domain = this.getTableEditingDomain();
            Command command = MoveCommand.create((EditingDomain)domain, (Object)this.getRepresentedContentProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), (Object)elementToMove, (int)newIndex);
            domain.getCommandStack().execute(command);
        }
    }

    @Override
    public boolean canEditAxisHeader(NatEventData axisIndex) {
        axisIndex.getColumnPosition();
        return this.canEditAxisHeader();
    }

    @Override
    public boolean canEditAxisHeader() {
        for (IAxisManager current : this.subManagers) {
            if (current.canEditAxisHeader()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getElementAxisName(IAxis axis) {
        AxisManagerRepresentation manager = axis.getManager();
        for (IAxisManager man : this.subManagers) {
            if (man.getAxisManagerRepresentation() != manager) continue;
            return man.getElementAxisName(axis);
        }
        if (this.canEditAxisHeader()) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    protected IAxisManager getAxisManager(IAxis axis) {
        AxisManagerRepresentation rep = axis.getManager();
        for (IAxisManager man : this.subManagers) {
            if (man.getAxisManagerRepresentation() != rep) continue;
            return man;
        }
        return null;
    }

    @Override
    public boolean canDestroyAxis(Integer axisPosition) {
        List<Object> elements = this.getElements();
        Object element = elements.get(axisPosition);
        if (element instanceof IAxis) {
            return this.getAxisManager((IAxis)element).canDestroyAxis(axisPosition);
        }
        return false;
    }

    @Override
    public boolean canDestroyAxisElement(Integer axisPosition) {
        List<Object> elements = this.getElements();
        Object element = elements.get(axisPosition);
        if (element instanceof IAxis) {
            return this.getAxisManager((IAxis)element).canDestroyAxisElement(axisPosition);
        }
        if (this.subManagers.size() == 1) {
            return this.subManagers.get(0).canDestroyAxisElement(axisPosition);
        }
        return false;
    }

    @Override
    public Command getDestroyAxisElementCommand(TransactionalEditingDomain domain, Integer axisPosition) {
        List<Object> elements = this.getElements();
        Object element = elements.get(axisPosition);
        if (element instanceof IAxis) {
            return this.getAxisManager((IAxis)element).getDestroyAxisElementCommand(domain, axisPosition);
        }
        if (this.subManagers.size() == 1) {
            return this.subManagers.get(0).getDestroyAxisElementCommand(domain, axisPosition);
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public boolean canBeSavedAsConfig() {
        boolean canBeSavedAsConfig = true;
        for (IAxisManager manager : this.subManagers) {
            canBeSavedAsConfig &= manager.canBeSavedAsConfig();
        }
        return canBeSavedAsConfig;
    }

    @Override
    public Object getAdapter(Class adapter) {
        for (IAxisManager current : this.subManagers) {
            if (current.getClass() != adapter) continue;
            return current;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public boolean isInSortedState() {
        return this.axisComparator != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAxisComparator(Comparator<Object> comp) {
        this.axisComparator = comp;
        if (this.axisComparator != null) {
            List<Object> displayedElement;
            List<Object> list = displayedElement = this.getElements();
            synchronized (list) {
                Collections.sort(displayedElement, comp);
                this.getTableManager().refreshNatTable();
            }
        } else {
            this.getTableManager().updateAxisContents(this.getRepresentedContentProvider());
        }
    }

    @Override
    public boolean isAlreadyManaged(Object object) {
        for (IAxisManager current : this.subManagers) {
            if (!current.isAlreadyManaged(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Command getSetNewAxisOrderCommand(final List<Object> newOrder) {
        if (this.canMoveAxis() && !this.isDynamic()) {
            return new RecordingCommand(this.getTableEditingDomain()){

                protected void doExecute() {
                    TreeMap<Integer, IAxis> order = new TreeMap<Integer, IAxis>();
                    AbstractAxisProvider provider = CompositeAxisManager.this.getRepresentedContentProvider();
                    int i = 0;
                    while (i < provider.getAxis().size()) {
                        IAxis currentAxis = (IAxis)provider.getAxis().get(i);
                        int index = newOrder.indexOf(currentAxis);
                        if (index != -1) {
                            order.put(index, currentAxis);
                        } else {
                            Object resolvedObject = AxisUtils.getRepresentedElement(currentAxis);
                            if (currentAxis instanceof IdAxis) {
                                resolvedObject = CompositeAxisManager.this.getResolvedPath((IdAxis)currentAxis);
                            }
                            if ((index = newOrder.indexOf(resolvedObject)) == -1) {
                                throw new IndexOutOfBoundsException("A reordered element can't be resolved");
                            }
                            order.put(index, currentAxis);
                        }
                        ++i;
                    }
                    ArrayList newValues = new ArrayList();
                    newValues.addAll(order.values());
                    SetCommand.create((EditingDomain)CompositeAxisManager.this.getTableEditingDomain(), (Object)provider, (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), newValues).execute();
                }
            };
        }
        return null;
    }

    protected IAxisManager findAxisManager(IAxis axis) {
        String axisManagerId = axis.getManager().getAxisManagerId();
        for (IAxisManager currentManager : this.subManagers) {
            if (!currentManager.getAxisManagerRepresentation().getAxisManagerId().equals(axisManagerId)) continue;
            return currentManager;
        }
        return null;
    }

    protected Object getResolvedPath(IdAxis idAxis) {
        Object resolvedElement;
        String path = idAxis.getElement();
        IAxisManager manager = this.findAxisManager((IAxis)idAxis);
        if (manager instanceof IIdAxisManager && (resolvedElement = ((IIdAxisManager)((Object)manager)).resolvedPath(path)) != null) {
            return resolvedElement;
        }
        return path;
    }
}

