/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.table;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.EditableRule;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataToClipboardCommand;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.export.command.ExportCommand;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.print.command.PrintCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOffCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.print.config.DefaultPrintBindings;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.reorder.event.ColumnReorderEvent;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectAllCommand;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.configuration.CornerConfiguration;
import org.eclipse.papyrus.infra.nattable.configuration.PapyrusClickSortConfiguration;
import org.eclipse.papyrus.infra.nattable.configuration.PapyrusHeaderMenuConfiguration;
import org.eclipse.papyrus.infra.nattable.dataprovider.AbstractDataProvider;
import org.eclipse.papyrus.infra.nattable.dataprovider.BodyDataProvider;
import org.eclipse.papyrus.infra.nattable.dataprovider.ColumnHeaderDataProvider;
import org.eclipse.papyrus.infra.nattable.dataprovider.RowHeaderDataProvider;
import org.eclipse.papyrus.infra.nattable.layer.PapyrusGridLayer;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.nattable.layerstack.ColumnHeaderLayerStack;
import org.eclipse.papyrus.infra.nattable.layerstack.RowHeaderLayerStack;
import org.eclipse.papyrus.infra.nattable.listener.NatTableDropListener;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.provider.PapyrusNatTableToolTipProvider;
import org.eclipse.papyrus.infra.nattable.provider.TableSelectionProvider;
import org.eclipse.papyrus.infra.nattable.sort.ColumnSortModel;
import org.eclipse.papyrus.infra.nattable.sort.IPapyrusSortModel;
import org.eclipse.papyrus.infra.nattable.utils.LocationValue;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.TableGridRegion;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class AbstractNattableWidgetManager
implements INattableModelManager {
    private Table table;
    private EObject tableContext;
    protected NatTable natTable;
    private GridLayer gridLayer;
    private ColumnHeaderLayerStack columnHeaderLayerStack;
    private RowHeaderLayerStack rowHeaderLayerStack;
    private TableSelectionProvider selectionProvider;
    private BodyLayerStack bodyLayerStack;
    private AbstractDataProvider columnHeaderDataProvider;
    private AbstractDataProvider rowHeaderDataProvider;
    private BodyDataProvider bodyDataProvider;
    private IPapyrusSortModel rowSortModel;

    public AbstractNattableWidgetManager(Table table) {
        this.table = table;
        this.tableContext = table.getContext();
    }

    @Override
    public NatTable createNattable(Composite parent, int style, IWorkbenchPartSite site) {
        this.bodyDataProvider = new BodyDataProvider(this);
        this.bodyLayerStack = new BodyLayerStack(this.bodyDataProvider, this);
        this.columnHeaderDataProvider = new ColumnHeaderDataProvider(this);
        this.columnHeaderLayerStack = new ColumnHeaderLayerStack(this.columnHeaderDataProvider, this.bodyLayerStack, this.bodyDataProvider, this.getRowSortModel());
        this.rowHeaderDataProvider = new RowHeaderDataProvider(this);
        this.rowHeaderLayerStack = new RowHeaderLayerStack(this.rowHeaderDataProvider, this.bodyLayerStack);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)this.columnHeaderDataProvider, (IDataProvider)this.rowHeaderDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)cornerDataProvider), (ILayer)this.rowHeaderLayerStack, (ILayer)this.columnHeaderLayerStack);
        cornerLayer.addConfiguration((IConfiguration)new CornerConfiguration(this));
        this.gridLayer = new PapyrusGridLayer(TransactionUtil.getEditingDomain((EObject)this.tableContext), (ILayer)this.bodyLayerStack, (ILayer)this.columnHeaderLayerStack, (ILayer)this.rowHeaderLayerStack, (ILayer)cornerLayer);
        this.gridLayer.addConfiguration((IConfiguration)new DefaultPrintBindings());
        this.natTable = new NatTable(parent, (ILayer)this.gridLayer, false);
        this.natTable.addConfiguration((IConfiguration)new PapyrusHeaderMenuConfiguration());
        this.natTable.addConfiguration((IConfiguration)new CellEditionConfiguration());
        this.natTable.addConfiguration((IConfiguration)new PapyrusClickSortConfiguration());
        this.configureNatTable();
        this.addColumnReorderListener(this.bodyLayerStack.getColumnReorderLayer());
        this.addDragAndDropSupport(this.natTable);
        if (site != null) {
            MenuManager menuMgr = this.createMenuManager(this.natTable);
            Menu menu = menuMgr.createContextMenu((Control)this.natTable);
            this.natTable.setMenu(menu);
            this.selectionProvider = new TableSelectionProvider(this, this.bodyLayerStack.getSelectionLayer());
            site.registerContextMenu(menuMgr, (ISelectionProvider)this.selectionProvider);
            site.setSelectionProvider((ISelectionProvider)this.selectionProvider);
        }
        new PapyrusNatTableToolTipProvider(this.natTable, "BODY", "COLUMN_HEADER", "ROW_HEADER");
        return this.natTable;
    }

    protected void configureNatTable() {
        if (this.natTable != null && !this.natTable.isDisposed()) {
            ConfigRegistry configRegistry = new ConfigRegistry();
            configRegistry.registerConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, (Object)this, "NORMAL", "nattable_model_manager_id");
            configRegistry.registerConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, (Object)this.getLabelProviderService(), "NORMAL", "label_provider_service_id");
            this.natTable.setConfigRegistry((IConfigRegistry)configRegistry);
            this.natTable.setUiBindingRegistry(new UiBindingRegistry(this.natTable));
            this.natTable.configure();
        }
    }

    private LabelProviderService getLabelProviderService() {
        try {
            ServicesRegistry serviceRegistry = ServiceUtilsForEObject.getInstance().getServiceRegistry(this.table.getContext());
            return (LabelProviderService)serviceRegistry.getService(LabelProviderService.class);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    public MenuManager createMenuManager(NatTable natTable) {
        MenuManager menuManager = new MenuManager("#PopUp", "org.eclipse.papyrus.infra.nattable.widget.menu"){

            public void add(IAction action) {
                super.add(action);
            }

            public void add(IContributionItem item) {
                super.add(item);
            }
        };
        menuManager.add((IContributionItem)new GroupMarker("additions"));
        menuManager.setRemoveAllWhenShown(true);
        return menuManager;
    }

    protected void addDragAndDropSupport(NatTable nattable) {
        int operations = 19;
        DropTarget target = new DropTarget((Control)nattable, 19);
        LocalTransfer localTransfer = LocalTransfer.getInstance();
        LocalSelectionTransfer localSelectionTransfer = LocalSelectionTransfer.getTransfer();
        Transfer[] types = new Transfer[]{localSelectionTransfer, localTransfer};
        target.setTransfer(types);
        NatTableDropListener dropListener = this.createDropListener();
        target.addDropListener((DropTargetListener)dropListener);
    }

    protected NatTableDropListener createDropListener() {
        return new NatTableDropListener(this);
    }

    private void addColumnReorderListener(ColumnReorderLayer columnReorderLayer) {
        columnReorderLayer.addLayerListener(new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof ColumnReorderEvent) {
                    ColumnReorderEvent columnReorderEvent = (ColumnReorderEvent)event;
                    int start = -1;
                    int end = columnReorderEvent.getBeforeToColumnPosition();
                    Iterator iterator = columnReorderEvent.getBeforeFromColumnPositionRanges().iterator();
                    if (iterator.hasNext()) {
                        Range range = (Range)iterator.next();
                        start = range.start;
                    }
                    if (start != -1) {
                        IAxis axisToMove;
                        EList allAxis = AbstractNattableWidgetManager.this.getColumnAxisManager().getRepresentedContentProvider().getAxis();
                        if (start >= 0 && start < end && columnReorderEvent.isReorderToLeftEdge()) {
                            --end;
                        }
                        if ((axisToMove = (IAxis)allAxis.get(start)) != null) {
                            AbstractNattableWidgetManager.this.moveColumnElement(axisToMove, end);
                        }
                    }
                }
            }
        });
    }

    @Override
    public LocationValue getLocationInTheTable(Point absolutePoint) {
        Point widgetPoint = this.natTable.toControl(absolutePoint.x, absolutePoint.y);
        TableGridRegion kind = TableGridRegion.UNKNOWN;
        int columnPosition = this.natTable.getColumnPositionByX(widgetPoint.x);
        int columnIndex = this.natTable.getColumnIndexByPosition(columnPosition);
        int rowPosition = this.natTable.getRowPositionByY(widgetPoint.y);
        int rowIndex = this.natTable.getRowIndexByPosition(rowPosition);
        ILayerCell cell = this.natTable.getCellByPosition(columnPosition, rowPosition);
        Object columnObject = null;
        Object rowObject = null;
        if (rowIndex == -1 && columnIndex == -1) {
            kind = TableGridRegion.UNKNOWN;
        } else if (rowIndex == -1) {
            kind = TableGridRegion.AFTER_ROW_HEADER;
        } else if (columnIndex == -1) {
            kind = TableGridRegion.AFTER_COLUMN_HEADER;
        } else if (cell != null) {
            LabelStack label = cell.getConfigLabels();
            if (label.hasLabel("ROW_HEADER")) {
                kind = TableGridRegion.ROW_HEADER;
            } else if (label.hasLabel("COLUMN_HEADER")) {
                kind = TableGridRegion.COLUMN_HEADER;
            } else if (label.hasLabel("CORNER")) {
                kind = TableGridRegion.CORNER;
            } else if (label.hasLabel("BODY")) {
                kind = TableGridRegion.CELL;
                columnObject = this.getColumnElement(columnIndex);
                rowObject = this.getRowElement(rowIndex);
            }
        }
        return new LocationValue(absolutePoint, widgetPoint, kind, cell, columnIndex, rowIndex, columnObject, rowObject);
    }

    public GridLayer getGridLayer() {
        return this.gridLayer;
    }

    @Override
    public void print() {
        this.natTable.doCommand((ILayerCommand)new TurnViewportOffCommand());
        this.natTable.doCommand((ILayerCommand)new PrintCommand(this.natTable.getConfigRegistry(), this.natTable.getShell()));
        this.natTable.doCommand((ILayerCommand)new TurnViewportOnCommand());
    }

    @Override
    public void selectAll() {
        this.natTable.doCommand((ILayerCommand)new SelectAllCommand());
    }

    @Override
    public void exportToXLS() {
        this.natTable.doCommand((ILayerCommand)new ExportCommand(this.natTable.getConfigRegistry(), this.natTable.getShell()));
    }

    public void copyToClipboard() {
        this.natTable.doCommand((ILayerCommand)new CopyDataToClipboardCommand("\t", "\n", this.natTable.getConfigRegistry()));
    }

    @Override
    public BodyLayerStack getBodyLayerStack() {
        return this.bodyLayerStack;
    }

    public void dispose() {
        if (this.bodyDataProvider != null) {
            this.bodyDataProvider.dispose();
        }
        if (this.rowHeaderDataProvider != null) {
            this.rowHeaderDataProvider.dispose();
        }
        if (this.columnHeaderDataProvider != null) {
            this.columnHeaderDataProvider.dispose();
        }
        this.tableContext = null;
    }

    public EObject getTableContext() {
        return this.tableContext;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    protected IPapyrusSortModel getRowSortModel() {
        if (this.rowSortModel == null) {
            this.rowSortModel = new ColumnSortModel(this);
        }
        return this.rowSortModel;
    }

    private class CellEditionConfiguration
    extends AbstractRegistryConfiguration {
        private CellEditionConfiguration() {
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)new EditableRule(){

                public boolean isEditable(int columnIndex, int rowIndex) {
                    Object rowElement = AbstractNattableWidgetManager.this.getRowElement(rowIndex);
                    Object columnElement = AbstractNattableWidgetManager.this.getColumnElement(columnIndex);
                    return CellManagerFactory.INSTANCE.isCellEditable(columnElement, rowElement);
                }
            });
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, null, "EDIT", "");
        }
    }
}

