/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.papyrus.infra.nattable.provider.AbstractNattableCellLabelProvider;
import org.eclipse.papyrus.infra.nattable.utils.ILabelProviderCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.ILabelProviderContextElementWrapper;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;

public class GenericCellLabelProvider
extends AbstractNattableCellLabelProvider {
    public static final int MAX_DISPLAYED_ELEMENTS = 10;

    @Override
    public boolean accept(Object element) {
        return element instanceof ILabelProviderCellContextElementWrapper;
    }

    @Override
    public String getText(Object element) {
        ILabelProviderCellContextElementWrapper contextElement = (ILabelProviderCellContextElementWrapper)element;
        IConfigRegistry registry = ((ILabelProviderContextElementWrapper)element).getConfigRegistry();
        Object value = contextElement.getObject();
        StringBuffer label = new StringBuffer();
        LabelProviderService service = this.getLabelProviderService(registry);
        if (value instanceof Collection) {
            Iterator iter = ((Collection)value).iterator();
            label.append("[");
            int i = 1;
            while (iter.hasNext()) {
                if (i > 10) {
                    label.append("...");
                    break;
                }
                Object current = iter.next();
                label.append(service.getLabelProvider(current).getText(current));
                if (iter.hasNext()) {
                    label.append(", ");
                }
                ++i;
            }
            label.append("]");
        } else {
            label.append(service.getLabelProvider(value).getText(value));
        }
        return label.toString();
    }
}

