/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.commands.CheckedOperationHistory;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.parsers.CSVParser;
import org.eclipse.papyrus.infra.nattable.parsers.CellIterator;
import org.eclipse.papyrus.infra.nattable.parsers.RowIterator;
import org.eclipse.papyrus.infra.nattable.paste.IValueSetter;
import org.eclipse.papyrus.infra.nattable.paste.PastePostActionRegistry;
import org.eclipse.papyrus.infra.nattable.utils.AxisConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.tools.converter.AbstractStringValueConverter;

public class PasteEObjectAxisInNattableCommandProvider {
    private static final int MIN_AXIS_FOR_PROGRESS_MONITOR = 5;
    private EStructuralFeature containmentFeature;
    private IElementType typeToCreate;
    private INattableModelManager tableManager;
    private boolean detachedMode;
    private List<String> postActions;
    private final CSVPasteHelper pasteHelper;
    private Map<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter> existingConverters;
    private static final String PASTE_ACTION_TASK_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteAction;
    private static final String PASTE_ROWS_JOB_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteRows;
    private static final String PASTE_COLUMNS_JOB_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteColumns;
    private static final String PASTE_COMMAND_HAS_BEEN_CANCELLED = Messages.PasteEObjectAxisInTableCommandProvider_CommandCreationHasBeenCancelled;
    private static final String PASTE_COMMAND_CANT_BE_EXECUTED = "The Paste command can't be executed";
    private static final String PASTE_COMMAND_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteFromStringCommand;
    private static final String CREATING_ELEMENT_A_NUMBER_X_Y = Messages.PasteEObjectAxisInTableCommandProvider_CreatingAnumberXonY;
    protected final boolean pasteColumn;
    private final int nbOperationsToDo;
    private int refreshEachReadChar = 1000;
    private boolean isDisposed = false;
    private final Reader reader;
    private CSVParser parser;
    int factor;
    private Table table;
    final TransactionalEditingDomain tableEditingDomain;
    final TransactionalEditingDomain contextEditingDomain;
    final EObject tableContext;
    List<Object> secondAxis;

    public PasteEObjectAxisInNattableCommandProvider(INattableModelManager tableManager, boolean pasteColumn, Reader reader, CSVPasteHelper pasteHelper2, long totalSize) {
        this.tableManager = tableManager;
        this.existingConverters = new HashMap<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter>();
        this.pasteHelper = pasteHelper2;
        this.reader = reader;
        this.pasteColumn = pasteColumn;
        this.table = tableManager.getTable();
        this.tableContext = this.table.getContext();
        this.tableEditingDomain = TableEditingDomainUtils.getTableEditingDomain(this.table);
        this.contextEditingDomain = TableEditingDomainUtils.getTableContextEditingDomain(this.table);
        long div = -1L;
        if (totalSize > Integer.MAX_VALUE) {
            div = totalSize / Integer.MAX_VALUE;
            if (div > Integer.MAX_VALUE) {
                div *= 2L;
            }
            this.factor = (int)div;
            this.nbOperationsToDo = (int)(totalSize / div);
        } else {
            this.factor = 1;
            this.nbOperationsToDo = (int)totalSize;
        }
        this.parser = this.pasteHelper.createParser(reader);
        this.init();
    }

    private void init() {
        PasteEObjectConfiguration configuration = null;
        if (this.pasteColumn) {
            configuration = (PasteEObjectConfiguration)AxisConfigurationUtils.getIAxisConfigurationUsedInTable(this.table, NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), true);
            this.secondAxis = this.tableManager.getRowElementsList();
        } else {
            configuration = (PasteEObjectConfiguration)AxisConfigurationUtils.getIAxisConfigurationUsedInTable(this.table, NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), false);
            this.secondAxis = this.tableManager.getColumnElementsList();
        }
        if (configuration != null) {
            this.containmentFeature = configuration.getPasteElementContainementFeature();
            this.typeToCreate = ElementTypeRegistry.getInstance().getType(configuration.getPastedElementId());
            this.postActions = configuration.getPostActions();
            this.detachedMode = configuration.isDetachedMode();
        }
    }

    public void executePasteFromStringCommand(boolean useProgressMonitor) {
        if (this.pasteColumn) {
            return;
        }
        if (this.isDisposed) {
            throw new RuntimeException("The command provider is disposed");
        }
        String pasteJobName = this.pasteColumn ? PASTE_COLUMNS_JOB_NAME : PASTE_ROWS_JOB_NAME;
        if (this.detachedMode) {
            this.executePasteFromStringCommandInDetachedMode(useProgressMonitor, pasteJobName);
        } else {
            this.executePasteFromStringCommandInAttachedMode(useProgressMonitor, pasteJobName);
        }
    }

    private void executePasteFromStringCommandInDetachedMode(boolean useProgressMonitor, String pasteJobName) {
        final HashMap<Object, Object> sharedMap = new HashMap<Object, Object>();
        sharedMap.put("pastedElementContainer", this.tableContext);
        sharedMap.put("referencesToSet", new ArrayList());
        sharedMap.put("cellsToAdd", new ArrayList());
        sharedMap.put("additionnal_post_actions_to_conclude_paste", new ArrayList());
        if (!useProgressMonitor) {
            ICommand pasteCommand = this.getPasteFromStringCommandInDetachedMode(this.contextEditingDomain, this.tableEditingDomain, (IProgressMonitor)new NullProgressMonitor(), sharedMap);
            try {
                CheckedOperationHistory.getInstance().execute((IUndoableOperation)pasteCommand, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
            sharedMap.clear();
        } else {
            Job job = new Job(pasteJobName){

                protected IStatus run(IProgressMonitor monitor) {
                    ICommand pasteCommand = PasteEObjectAxisInNattableCommandProvider.this.getPasteFromStringCommandInDetachedMode(PasteEObjectAxisInNattableCommandProvider.this.contextEditingDomain, PasteEObjectAxisInNattableCommandProvider.this.tableEditingDomain, monitor, sharedMap);
                    if (pasteCommand == null) {
                        return new Status(8, "org.eclipse.papyrus.infra.nattable", PASTE_COMMAND_HAS_BEEN_CANCELLED);
                    }
                    if (pasteCommand.canExecute()) {
                        try {
                            try {
                                CheckedOperationHistory.getInstance().execute((IUndoableOperation)pasteCommand, monitor, null);
                            }
                            catch (ExecutionException e) {
                                Status status = new Status(4, "org.eclipse.papyrus.infra.nattable", "An exception occured during the paste", (Throwable)e);
                                sharedMap.clear();
                                return status;
                            }
                        }
                        finally {
                            sharedMap.clear();
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                    sharedMap.clear();
                    return new Status(4, "org.eclipse.papyrus.infra.nattable", PasteEObjectAxisInNattableCommandProvider.PASTE_COMMAND_CANT_BE_EXECUTED);
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private void executePasteFromStringCommandInAttachedMode(boolean useProgressMonitor, String pasteJobName) {
        if (!useProgressMonitor) {
            ICommand pasteCommand = this.getPasteFromStringCommandInAttachedMode(this.contextEditingDomain, this.tableEditingDomain, (IProgressMonitor)new NullProgressMonitor());
            try {
                CheckedOperationHistory.getInstance().execute((IUndoableOperation)pasteCommand, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        } else {
            Job job = new Job(pasteJobName){

                protected IStatus run(IProgressMonitor monitor) {
                    ICommand pasteCommand = PasteEObjectAxisInNattableCommandProvider.this.getPasteFromStringCommandInAttachedMode(PasteEObjectAxisInNattableCommandProvider.this.contextEditingDomain, PasteEObjectAxisInNattableCommandProvider.this.tableEditingDomain, monitor);
                    if (pasteCommand == null) {
                        return new Status(8, "org.eclipse.papyrus.infra.nattable", PASTE_COMMAND_HAS_BEEN_CANCELLED);
                    }
                    if (pasteCommand.canExecute()) {
                        try {
                            CheckedOperationHistory.getInstance().execute((IUndoableOperation)pasteCommand, monitor, null);
                        }
                        catch (ExecutionException e) {
                            return new Status(4, "org.eclipse.papyrus.infra.nattable", "An exception occured during the paste", (Throwable)e);
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                    return new Status(4, "org.eclipse.papyrus.infra.nattable", PasteEObjectAxisInNattableCommandProvider.PASTE_COMMAND_CANT_BE_EXECUTED);
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private ICommand getPasteRowFromStringCommandInDetachedMode(final TransactionalEditingDomain contextEditingDomain, final TransactionalEditingDomain tableEditingDomain, final IProgressMonitor progressMonitor, final Map<Object, Object> sharedMap) {
        if (progressMonitor != null) {
            progressMonitor.beginTask(PASTE_ACTION_TASK_NAME, this.nbOperationsToDo);
        }
        final ArrayList<EObject> createdElements = new ArrayList<EObject>();
        EClass eClassToCreate = this.typeToCreate.getEClass();
        EFactory eFactory = eClassToCreate.getEPackage().getEFactoryInstance();
        int nbCreatedElements = 0;
        long readChar = 0L;
        long previousreadChar = 0L;
        RowIterator rowIter = this.parser.parse();
        while (rowIter.hasNext()) {
            CellIterator cellIter = (CellIterator)rowIter.next();
            if (!cellIter.hasNext()) continue;
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                return null;
            }
            previousreadChar = this.parser.getReadCharacters();
            if (progressMonitor != null && (readChar += this.parser.getReadCharacters() - previousreadChar) > (long)this.refreshEachReadChar) {
                readChar = 0L;
                progressMonitor.subTask(NLS.bind((String)"{0} {1} have been created.", (Object[])new Object[]{nbCreatedElements, this.typeToCreate.getEClass().getName()}));
                progressMonitor.worked(this.refreshEachReadChar);
            }
            ++nbCreatedElements;
            EObject createdElement = eFactory.create(eClassToCreate);
            createdElements.add(createdElement);
            ++nbCreatedElements;
            for (String currentPostActions : this.postActions) {
                PastePostActionRegistry.INSTANCE.doPostAction(this.tableManager, currentPostActions, this.tableContext, createdElement, sharedMap, null);
            }
            Iterator<Object> secondAxisIterator = this.secondAxis.iterator();
            while (secondAxisIterator.hasNext() && cellIter.hasNext()) {
                Object rowObject;
                Object columnObject;
                Object currentAxis = secondAxisIterator.next();
                String valueAsString = (String)cellIter.next();
                if (this.pasteColumn) {
                    columnObject = createdElement;
                    rowObject = currentAxis;
                } else {
                    columnObject = currentAxis;
                    rowObject = createdElement;
                }
                boolean isEditable = CellManagerFactory.INSTANCE.isCellEditable(columnObject, rowObject, sharedMap);
                if (!isEditable) continue;
                AbstractStringValueConverter converter = CellManagerFactory.INSTANCE.getOrCreateStringValueConverterClass(columnObject, rowObject, this.tableManager, this.existingConverters, this.pasteHelper.getMultiValueSeparator());
                CellManagerFactory.INSTANCE.setStringValue(columnObject, rowObject, valueAsString, converter, this.tableManager, sharedMap);
            }
            while (cellIter.hasNext()) {
                cellIter.next();
            }
        }
        AbstractTransactionalCommand pasteCommand = new AbstractTransactionalCommand(tableEditingDomain, PASTE_COMMAND_NAME, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Collection postActions = PasteEObjectAxisInNattableCommandProvider.this.getPostActions();
                Collection postActionsAddedByCellManagers = (Collection)sharedMap.get("additionnal_post_actions_to_conclude_paste");
                postActions.addAll(postActionsAddedByCellManagers);
                List cells = (List)sharedMap.get("cellsToAdd");
                List valueToSet = (List)sharedMap.get("referencesToSet");
                int nbTasks = 1;
                ++nbTasks;
                nbTasks += postActions.size();
                ++nbTasks;
                nbTasks += valueToSet.size();
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        PasteEObjectAxisInNattableCommandProvider.this.localDispose();
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.beginTask(Messages.PasteEObjectAxisInTableCommandProvider_FinishingThePaste, nbTasks);
                }
                AddCommand.create((EditingDomain)contextEditingDomain, (Object)PasteEObjectAxisInNattableCommandProvider.this.tableContext, (Object)PasteEObjectAxisInNattableCommandProvider.this.containmentFeature, (Collection)createdElements).execute();
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.worked(1);
                    progressMonitor.subTask(Messages.PasteEObjectAxisInTableCommandProvider_AddingElementToTheTable);
                }
                Command cmd = null;
                cmd = PasteEObjectAxisInNattableCommandProvider.this.pasteColumn ? PasteEObjectAxisInNattableCommandProvider.this.tableManager.getAddColumnElementCommand(createdElements) : PasteEObjectAxisInNattableCommandProvider.this.tableManager.getAddRowElementCommand(createdElements);
                if (cmd != null) {
                    cmd.execute();
                }
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.worked(1);
                    progressMonitor.subTask(Messages.PasteEObjectAxisInTableCommandProvider_DoingAdditionalActions);
                }
                for (String currentPostActions : postActions) {
                    PastePostActionRegistry.INSTANCE.concludePostAction(PasteEObjectAxisInNattableCommandProvider.this.tableManager, currentPostActions, sharedMap);
                    progressMonitor.worked(1);
                }
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.worked(1);
                    progressMonitor.subTask(Messages.PasteEObjectAxisInTableCommandProvider_LinkingReferencesToTheModel);
                }
                if (valueToSet.size() > 0) {
                    for (IValueSetter current : valueToSet) {
                        current.doSetValue((EditingDomain)contextEditingDomain);
                        if (progressMonitor == null) continue;
                        if (progressMonitor.isCanceled()) {
                            return CommandResult.newCancelledCommandResult();
                        }
                        progressMonitor.worked(1);
                    }
                }
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.worked(1);
                }
                AddCommand.create((EditingDomain)tableEditingDomain, (Object)PasteEObjectAxisInNattableCommandProvider.this.table, (Object)NattablePackage.eINSTANCE.getTable_Cells(), (Collection)cells).execute();
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
                PasteEObjectAxisInNattableCommandProvider.this.localDispose();
                return CommandResult.newOKCommandResult();
            }
        };
        return pasteCommand;
    }

    private ICommand getPasteFromStringCommandInDetachedMode(TransactionalEditingDomain contextEditingDomain, TransactionalEditingDomain tableEditingDomain, IProgressMonitor progressMonitor, Map<Object, Object> sharedMap) {
        if (!this.pasteColumn) {
            return this.getPasteRowFromStringCommandInDetachedMode(contextEditingDomain, tableEditingDomain, progressMonitor, sharedMap);
        }
        return null;
    }

    private ICommand getPasteColumnFromStringInAttachedModeCommand(final TransactionalEditingDomain contextEditingDomain, TransactionalEditingDomain tableEditingDomain, final IProgressMonitor progressMonitor) {
        if (progressMonitor != null) {
            progressMonitor.beginTask(PASTE_ACTION_TASK_NAME, this.nbOperationsToDo);
        }
        final CreateElementRequest createRequest = new CreateElementRequest(contextEditingDomain, this.tableContext, this.typeToCreate, (EReference)this.containmentFeature);
        final IElementEditService tableContextCommandProvider = ElementEditServiceUtils.getCommandProvider((Object)this.tableContext);
        AbstractTransactionalCommand pasteAllCommand = new AbstractTransactionalCommand(contextEditingDomain, PASTE_COMMAND_NAME, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                long readChar = 0L;
                long previousreadChar = 0L;
                RowIterator rowIter = PasteEObjectAxisInNattableCommandProvider.this.parser.parse();
                int nbCreatedElements = 0;
                while (rowIter.hasNext()) {
                    CellIterator cellIter = (CellIterator)rowIter.next();
                    if (!cellIter.hasNext()) continue;
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        progressMonitor.done();
                        PasteEObjectAxisInNattableCommandProvider.this.localDispose();
                        return CommandResult.newCancelledCommandResult();
                    }
                    previousreadChar = PasteEObjectAxisInNattableCommandProvider.this.parser.getReadCharacters();
                    if (progressMonitor != null && (readChar += PasteEObjectAxisInNattableCommandProvider.this.parser.getReadCharacters() - previousreadChar) > (long)PasteEObjectAxisInNattableCommandProvider.this.refreshEachReadChar) {
                        readChar = 0L;
                        progressMonitor.subTask(NLS.bind((String)"{0} {1} have been created.", (Object[])new Object[]{PasteEObjectAxisInNattableCommandProvider.this.typeToCreate.getEClass().getName(), nbCreatedElements}));
                        progressMonitor.worked(PasteEObjectAxisInNattableCommandProvider.this.refreshEachReadChar);
                    }
                    ++nbCreatedElements;
                    ICommand commandCreation = tableContextCommandProvider.getEditCommand((IEditCommandRequest)createRequest);
                    if (!commandCreation.canExecute()) continue;
                    commandCreation.execute(monitor, info);
                    CommandResult res = commandCreation.getCommandResult();
                    commandCreation.dispose();
                    EObject createdElement = (EObject)res.getReturnValue();
                    Command addCommand = PasteEObjectAxisInNattableCommandProvider.this.pasteColumn ? PasteEObjectAxisInNattableCommandProvider.this.tableManager.getAddColumnElementCommand(Collections.singleton(createdElement)) : PasteEObjectAxisInNattableCommandProvider.this.tableManager.getAddRowElementCommand(Collections.singleton(createdElement));
                    if (addCommand != null) {
                        addCommand.execute();
                        addCommand.dispose();
                    }
                    Iterator<Object> secondAxisIterator = PasteEObjectAxisInNattableCommandProvider.this.secondAxis.iterator();
                    while (secondAxisIterator.hasNext() && cellIter.hasNext()) {
                        AbstractStringValueConverter converter;
                        Command setValueCommand;
                        Object rowObject;
                        Object columnObject;
                        Object currentAxis = secondAxisIterator.next();
                        String valueAsString = (String)cellIter.next();
                        if (PasteEObjectAxisInNattableCommandProvider.this.pasteColumn) {
                            columnObject = createdElement;
                            rowObject = currentAxis;
                        } else {
                            columnObject = currentAxis;
                            rowObject = createdElement;
                        }
                        boolean isEditable = CellManagerFactory.INSTANCE.isCellEditable(columnObject, rowObject);
                        if (!isEditable || (setValueCommand = CellManagerFactory.INSTANCE.getSetStringValueCommand(contextEditingDomain, columnObject, rowObject, valueAsString, converter = CellManagerFactory.INSTANCE.getOrCreateStringValueConverterClass(columnObject, rowObject, PasteEObjectAxisInNattableCommandProvider.this.tableManager, PasteEObjectAxisInNattableCommandProvider.this.existingConverters, PasteEObjectAxisInNattableCommandProvider.this.pasteHelper.getMultiValueSeparator()), PasteEObjectAxisInNattableCommandProvider.this.tableManager)) == null || !setValueCommand.canExecute()) continue;
                        setValueCommand.execute();
                        setValueCommand.dispose();
                    }
                    while (cellIter.hasNext()) {
                        cellIter.next();
                    }
                }
                progressMonitor.done();
                PasteEObjectAxisInNattableCommandProvider.this.localDispose();
                return CommandResult.newOKCommandResult();
            }
        };
        return pasteAllCommand;
    }

    private ICommand getPasteRowFromStringInAttachedModeCommand(final TransactionalEditingDomain contextEditingDomain, TransactionalEditingDomain tableEditingDomain, final IProgressMonitor progressMonitor) {
        if (progressMonitor != null) {
            progressMonitor.beginTask(PASTE_ACTION_TASK_NAME, this.nbOperationsToDo);
        }
        final CreateElementRequest createRequest = new CreateElementRequest(contextEditingDomain, this.tableContext, this.typeToCreate, (EReference)this.containmentFeature);
        final IElementEditService tableContextCommandProvider = ElementEditServiceUtils.getCommandProvider((Object)this.tableContext);
        AbstractTransactionalCommand pasteAllCommand = new AbstractTransactionalCommand(contextEditingDomain, PASTE_COMMAND_NAME, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                long readChar = 0L;
                long previousreadChar = 0L;
                RowIterator rowIter = PasteEObjectAxisInNattableCommandProvider.this.parser.parse();
                int nbCreatedElements = 0;
                while (rowIter.hasNext()) {
                    CellIterator cellIter = (CellIterator)rowIter.next();
                    if (!cellIter.hasNext()) continue;
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        progressMonitor.done();
                        PasteEObjectAxisInNattableCommandProvider.this.localDispose();
                        return CommandResult.newCancelledCommandResult();
                    }
                    previousreadChar = PasteEObjectAxisInNattableCommandProvider.this.parser.getReadCharacters();
                    if (progressMonitor != null && (readChar += PasteEObjectAxisInNattableCommandProvider.this.parser.getReadCharacters() - previousreadChar) > (long)PasteEObjectAxisInNattableCommandProvider.this.refreshEachReadChar) {
                        readChar = 0L;
                        progressMonitor.subTask(NLS.bind((String)"{0} {1} have been created.", (Object[])new Object[]{PasteEObjectAxisInNattableCommandProvider.this.typeToCreate.getEClass().getName(), nbCreatedElements}));
                        progressMonitor.worked(PasteEObjectAxisInNattableCommandProvider.this.refreshEachReadChar);
                    }
                    ++nbCreatedElements;
                    ICommand commandCreation = tableContextCommandProvider.getEditCommand((IEditCommandRequest)createRequest);
                    if (!commandCreation.canExecute()) continue;
                    commandCreation.execute(monitor, info);
                    CommandResult res = commandCreation.getCommandResult();
                    commandCreation.dispose();
                    EObject createdElement = (EObject)res.getReturnValue();
                    Command addCommand = PasteEObjectAxisInNattableCommandProvider.this.pasteColumn ? PasteEObjectAxisInNattableCommandProvider.this.tableManager.getAddColumnElementCommand(Collections.singleton(createdElement)) : PasteEObjectAxisInNattableCommandProvider.this.tableManager.getAddRowElementCommand(Collections.singleton(createdElement));
                    if (addCommand != null) {
                        addCommand.execute();
                        addCommand.dispose();
                    }
                    Iterator<Object> secondAxisIterator = PasteEObjectAxisInNattableCommandProvider.this.secondAxis.iterator();
                    while (secondAxisIterator.hasNext() && cellIter.hasNext()) {
                        AbstractStringValueConverter converter;
                        Command setValueCommand;
                        Object rowObject;
                        Object columnObject;
                        Object currentAxis = secondAxisIterator.next();
                        String valueAsString = (String)cellIter.next();
                        if (PasteEObjectAxisInNattableCommandProvider.this.pasteColumn) {
                            columnObject = createdElement;
                            rowObject = currentAxis;
                        } else {
                            columnObject = currentAxis;
                            rowObject = createdElement;
                        }
                        boolean isEditable = CellManagerFactory.INSTANCE.isCellEditable(columnObject, rowObject);
                        if (!isEditable || (setValueCommand = CellManagerFactory.INSTANCE.getSetStringValueCommand(contextEditingDomain, columnObject, rowObject, valueAsString, converter = CellManagerFactory.INSTANCE.getOrCreateStringValueConverterClass(columnObject, rowObject, PasteEObjectAxisInNattableCommandProvider.this.tableManager, PasteEObjectAxisInNattableCommandProvider.this.existingConverters, PasteEObjectAxisInNattableCommandProvider.this.pasteHelper.getMultiValueSeparator()), PasteEObjectAxisInNattableCommandProvider.this.tableManager)) == null || !setValueCommand.canExecute()) continue;
                        setValueCommand.execute();
                        setValueCommand.dispose();
                    }
                    while (cellIter.hasNext()) {
                        cellIter.next();
                    }
                }
                progressMonitor.done();
                PasteEObjectAxisInNattableCommandProvider.this.localDispose();
                return CommandResult.newOKCommandResult();
            }
        };
        return pasteAllCommand;
    }

    private ICommand getPasteFromStringCommandInAttachedMode(TransactionalEditingDomain contextEditingDomain, TransactionalEditingDomain tableEditingDomain, IProgressMonitor progressMonitor) {
        if (!this.pasteColumn) {
            return this.getPasteRowFromStringInAttachedModeCommand(contextEditingDomain, tableEditingDomain, progressMonitor);
        }
        return null;
    }

    private Collection<String> getPostActions() {
        return this.postActions;
    }

    private void localDispose() {
        this.isDisposed = true;
        this.tableManager = null;
        this.typeToCreate = null;
        this.containmentFeature = null;
        for (AbstractStringValueConverter current : this.existingConverters.values()) {
            current.dispose();
        }
        this.existingConverters.clear();
        try {
            this.reader.close();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

