/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.wizard.pages;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.StringFileSelector;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ImportFilePage
extends WizardPage {
    private static final String[] allowedFiles = new String[]{"*.csv"};
    private String selectedFilePath;
    private final INattableModelManager tableManager;

    public ImportFilePage(String pageName, String title, ImageDescriptor titleImage, INattableModelManager tableManager) {
        super(pageName, title, titleImage);
        this.setDescription(Messages.ImportFilePage_SelectTheFileToImport);
        this.tableManager = tableManager;
        this.selectedFilePath = null;
    }

    public void createControl(Composite parent) {
        Composite localComposite = new Composite(parent, 0);
        this.setControl((Control)localComposite);
        ILabelProvider labelProvider = this.getLabelProvider();
        Composite localParent = new Composite(localComposite, 0);
        Label label = new Label(localParent, 0);
        label.setText(Messages.ImportFilePage_YourFileWillBeImported);
        CLabel cLabel = new CLabel(localParent, 0);
        cLabel.setText(this.tableManager.getTableName());
        Label label2 = new Label(localParent, 0);
        label2.setText(Messages.ImportFilePage_TheImportedElementWillBeAddedTo);
        CLabel cLabel2 = new CLabel(localParent, 0);
        cLabel2.setText(labelProvider.getText((Object)this.tableManager.getTable().getContext()));
        cLabel2.setImage(labelProvider.getImage((Object)this.tableManager.getTable().getContext()));
        cLabel.setImage(labelProvider.getImage((Object)this.tableManager.getTable()));
        localParent.setLayout((Layout)new GridLayout(2, true));
        final StringFileSelector selector = new StringFileSelector(localComposite, 0);
        selector.setAllowFileSystem(true);
        selector.setAllowWorkspace(true);
        selector.setFilterExtensions(allowedFiles);
        localComposite.setLayout((Layout)new GridLayout(1, true));
        selector.setLayoutData((Object)new GridData(4, 4, true, false));
        selector.getText().setEditable(false);
        selector.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                Object value = selector.getValue();
                if (value instanceof String && ((String)value).length() > 0) {
                    ImportFilePage.this.setFilePath((String)value);
                    ImportFilePage.this.setPageComplete(ImportFilePage.this.isPageComplete());
                }
            }
        });
        CLabel warningLabel = new CLabel(localComposite, 0);
        warningLabel.setText(Messages.ImportFilePage_BeSureThatYourImportFileHasTheSameNumberOfColumns);
        warningLabel.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrus.infra.nattable", "/icons/warning.gif"));
    }

    protected ILabelProvider getLabelProvider() {
        LabelProviderService labelService = null;
        try {
            labelService = (LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)this.tableManager.getTable());
        }
        catch (ServiceException e) {
            Activator.log.error("Label Provider Service Not Found", (Throwable)e);
        }
        if (labelService != null) {
            return labelService.getLabelProvider();
        }
        return null;
    }

    public boolean isPageComplete() {
        return this.getFilePath() != null;
    }

    public String getFilePath() {
        return this.selectedFilePath;
    }

    protected void setFilePath(String filePath) {
        this.selectedFilePath = filePath == null || filePath.length() == 0 ? null : filePath;
    }
}

