/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.commands;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;

public class BasicUncontrolCommand
extends AbstractControlCommand {
    public BasicUncontrolCommand(ControlModeRequest request) {
        super("Basic uncontrol files", Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)request.getTargetObject().eResource())), request);
    }

    public boolean canExecute() {
        return this.getRequest().getTargetObject().eResource() != null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EObject uncontroledObject = this.getRequest().getTargetObject();
        Resource resource = uncontroledObject.eResource();
        if (resource != null) {
            resource.getContents().remove((Object)uncontroledObject);
            return CommandResult.newOKCommandResult();
        }
        return CommandResult.newErrorCommandResult((String)"The object is not contained in a resource");
    }
}

