/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.validation.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommandHandler
extends AbstractHandler {
    protected abstract Command getCommand();

    protected EObject getSelectedElement() {
        EObject eObject = null;
        Object selection = null;
        selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selection = structuredSelection.getFirstElement();
        }
        if (selection != null) {
            Object businessObject;
            if (selection instanceof IAdaptable) {
                selection = EMFHelper.getEObject((Object)selection);
            }
            if ((businessObject = BusinessModelResolver.getInstance().getBusinessModel(selection)) instanceof EObject) {
                eObject = (EObject)businessObject;
            }
        }
        return eObject;
    }

    protected List<EObject> getSelectedElements() {
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object current = objectArray[n2];
                if (current instanceof IAdaptable) {
                    selectedEObjects.add(EMFHelper.getEObject((Object)current));
                }
                ++n2;
            }
        } else if (selection != null && selection instanceof IAdaptable) {
            selectedEObjects.add(EMFHelper.getEObject((Object)selection));
        }
        return selectedEObjects;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.getCommand().execute();
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(this.getCommand().canExecute());
    }

    public boolean isVisible() {
        return this.getCommand().canExecute();
    }
}

