/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.swt.widgets.Display;

public class UIUtil {
    private UIUtil() {
    }

    public static ExecutorService createUIExecutor(Display display) {
        return new UIExecutorService(display);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UIExecutorService
    extends AbstractExecutorService {
        private final Lock lock = new ReentrantLock();
        private final Condition emptyCond = this.lock.newCondition();
        private final Queue<RunnableWrapper> pending = new LinkedList<RunnableWrapper>();
        private final Display display;
        private volatile boolean shutdown;

        UIExecutorService(Display display) {
            this.display = display;
        }

        @Override
        public void execute(Runnable command) {
            if (this.isShutdown()) {
                throw new RejectedExecutionException("Executor service is shut down");
            }
            this.display.asyncExec((Runnable)this.enqueue(command));
        }

        @Override
        public List<Runnable> shutdownNow() {
            ArrayList<Runnable> result = new ArrayList<Runnable>();
            this.shutdown();
            RunnableWrapper dequeued = this.dequeue();
            while (dequeued != null) {
                result.add(dequeued);
                dequeued = this.dequeue();
            }
            return result;
        }

        private RunnableWrapper enqueue(Runnable task) {
            RunnableWrapper result = new RunnableWrapper(task);
            this.lock.lock();
            try {
                boolean wasEmpty = this.pending.isEmpty();
                this.pending.offer(result);
                if (wasEmpty) {
                    this.emptyCond.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
            return result;
        }

        private RunnableWrapper dequeue() {
            RunnableWrapper result = null;
            this.lock.lock();
            try {
                result = this.pending.poll();
                if (result == null) {
                    this.emptyCond.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
            return result;
        }

        boolean dequeue(RunnableWrapper task) {
            boolean result = false;
            this.lock.lock();
            try {
                result = this.pending.remove(task);
                if (result && this.pending.isEmpty()) {
                    this.emptyCond.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
            return result;
        }

        @Override
        public void shutdown() {
            this.shutdown = true;
        }

        @Override
        public boolean isTerminated() {
            this.lock.lock();
            try {
                boolean bl = this.isShutdown() && this.pending.isEmpty();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean isShutdown() {
            return this.shutdown;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            if (timeout < 0L) {
                throw new IllegalArgumentException("negative timeout");
            }
            Date deadline = timeout == 0L ? null : new Date(System.currentTimeMillis() + unit.toMillis(timeout));
            boolean result = false;
            this.lock.lock();
            try {
                block9: {
                    boolean stillWaiting;
                    block8: {
                        stillWaiting = true;
                        result = this.isTerminated();
                        if (!true) break block8;
                        if (result) return result;
                        if (!stillWaiting) break block9;
                    }
                    do {
                        if (deadline == null) {
                            this.emptyCond.await();
                        } else {
                            stillWaiting = this.emptyCond.awaitUntil(deadline);
                        }
                        result = this.isTerminated();
                        if (result) return result;
                    } while (stillWaiting);
                }
                return result;
            }
            finally {
                this.lock.unlock();
            }
        }

        private class RunnableWrapper
        implements Runnable {
            private final Runnable delegate;

            RunnableWrapper(Runnable delegate) {
                this.delegate = delegate;
            }

            public void run() {
                if (UIExecutorService.this.dequeue(this)) {
                    this.delegate.run();
                }
            }
        }
    }
}

