/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.validator.AbstractValidator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractValueEditor
extends AbstractEditor {
    protected IObservableValue modelProperty;
    protected IObservableValue widgetObservable;
    protected UpdateValueStrategy targetToModelStrategy;
    protected UpdateValueStrategy modelToTargetStrategy;
    protected AbstractValidator targetValidator;
    protected IValidator modelValidator;
    protected boolean errorBinding = false;
    protected ControlDecoration controlDecoration;
    protected static final Color VALID = new Color((Device)Display.getCurrent(), 144, 238, 144);
    protected static final Color DEFAULT = Display.getCurrent().getSystemColor(1);
    protected static final Color EDIT = new Color((Device)Display.getCurrent(), 255, 204, 153);
    protected static final Color ERROR = new Color((Device)Display.getCurrent(), 255, 153, 153);

    protected AbstractValueEditor(Composite parent) {
        super(parent);
    }

    protected AbstractValueEditor(Composite parent, int style, String label) {
        super(parent, style, label);
    }

    protected AbstractValueEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected AbstractValueEditor(Composite parent, String label) {
        super(parent, label);
    }

    protected void setWidgetObservable(IObservableValue widgetObservable, IConverter targetToModel, IConverter modelToTarget) {
        this.widgetObservable = widgetObservable;
        this.setConverters(targetToModel, modelToTarget);
    }

    protected void setWidgetObservable(IObservableValue widgetObservable, boolean commitOnChange) {
        this.widgetObservable = widgetObservable;
        if (commitOnChange) {
            this.widgetObservable.addChangeListener(new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    AbstractValueEditor.this.commit();
                }
            });
        }
    }

    protected void setWidgetObservable(IObservableValue widgetObservable) {
        this.setWidgetObservable(widgetObservable, false);
    }

    public void setModelObservable(IObservableValue modelProperty) {
        this.modelProperty = modelProperty;
        this.doBinding();
    }

    @Override
    public void setConverters(IConverter targetToModel, IConverter modelToTarget) {
        if (this.targetToModelStrategy == null) {
            this.targetToModelStrategy = new UpdateValueStrategy();
        }
        if (this.modelToTargetStrategy == null) {
            this.modelToTargetStrategy = new UpdateValueStrategy();
        }
        this.targetToModelStrategy.setConverter(targetToModel);
        this.modelToTargetStrategy.setConverter(modelToTarget);
    }

    public void setUpdateStrategies(UpdateValueStrategy targetToModelStrategy, UpdateValueStrategy modelToTargetStrategy) {
        this.targetToModelStrategy = targetToModelStrategy;
        this.modelToTargetStrategy = modelToTargetStrategy;
    }

    @Override
    protected void doBinding() {
        if (this.modelProperty == null || this.widgetObservable == null) {
            return;
        }
        this.setBinding();
    }

    public abstract Object getValue();

    private void setBinding() {
        this.binding = this.getBindingContext().bindValue(this.widgetObservable, this.modelProperty, this.targetToModelStrategy, this.modelToTargetStrategy);
        this.binding.getValidationStatus().addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                if (!AbstractValueEditor.this.isDisposed() && !AbstractValueEditor.this.isReadOnly()) {
                    IStatus status = (IStatus)AbstractValueEditor.this.binding.getValidationStatus().getValue();
                    AbstractValueEditor.this.updateStatus(status);
                    AbstractValueEditor.this.changeColorField();
                }
            }
        });
    }

    public void updateStatus(IStatus status) {
    }

    public void setTargetAfterGetValidator(AbstractValidator targetToModelValidator) {
        if (targetToModelValidator != null) {
            this.targetToModelStrategy.setAfterGetValidator((IValidator)targetToModelValidator);
        }
    }

    public void setModelValidator(IValidator targetToModelValidator) {
        if (targetToModelValidator != null) {
            this.modelValidator = targetToModelValidator;
            this.targetToModelStrategy.setBeforeSetValidator(targetToModelValidator);
            this.modelToTargetStrategy.setAfterGetValidator(targetToModelValidator);
        }
    }

    public void setStrategies() {
        if (this.modelToTargetStrategy == null) {
            this.modelToTargetStrategy = new UpdateValueStrategy();
        }
        if (this.targetToModelStrategy == null) {
            this.targetToModelStrategy = new UpdateValueStrategy();
        }
    }

    @Override
    protected Object getContextElement() {
        return this.modelProperty instanceof IObserving ? ((IObserving)this.modelProperty).getObserved() : null;
    }
}

