/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.gmf.diagram.common.parser.IMaskManagedSemanticParser;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.common.parser.NamedElementLabelParser;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.UMLPackage;

public class ReceptionLabelParser
extends NamedElementLabelParser
implements IMaskManagedSemanticParser {
    protected static final String PREFIX = "\u00absignal\u00bb ";
    protected static final String NAME_FORMAT = "%s%s";
    protected static final String TYPE_FORMAT = "%s: %s";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Collection<String> maskValues = this.getMaskValues(element);
        if (maskValues.isEmpty()) {
            return "<empty label>";
        }
        String result = PREFIX;
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject != null && eObject instanceof Reception) {
            Reception reception = (Reception)eObject;
            if (maskValues.contains("name") && reception.isSetName()) {
                String name = reception.getName();
                result = String.format(NAME_FORMAT, result, name);
            }
            if (maskValues.contains("signal")) {
                String type = "<Undefined>";
                if (reception.getSignal() != null) {
                    type = reception.getSignal().getName();
                }
                result = String.format(TYPE_FORMAT, result, type);
            }
        }
        return result;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return UMLPackage.eINSTANCE.getReception_Signal().equals(feature) || super.isAffectingEvent(event, flags);
        }
        return false;
    }

    @Override
    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> semanticElementsBeingParsed = new ArrayList<EObject>();
        if (element != null && element instanceof Reception) {
            Reception semElement = (Reception)element;
            semanticElementsBeingParsed.add((EObject)semElement);
            if (semElement.getSignal() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getSignal());
            }
        }
        return semanticElementsBeingParsed;
    }

    @Override
    public Map<String, String> getMasks() {
        HashMap<String, String> masks = new HashMap<String, String>();
        masks.put("name", "Name");
        masks.put("signal", "Signal");
        return masks;
    }

    @Override
    public Collection<String> getDefaultValue(IAdaptable element) {
        return Arrays.asList("name", "signal");
    }
}

