/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ScalablePolygonShape;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.uml.diagram.activity.draw2d.CenteredColumnConstraint;
import org.eclipse.papyrus.uml.diagram.activity.draw2d.CenteredColumnLayout;
import org.eclipse.papyrus.uml.diagram.common.draw2d.CenterLayout;
import org.eclipse.papyrus.uml.diagram.common.figure.node.CenteredWrappedLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypeFigureHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class AcceptEventActionFigure
extends ScalablePolygonShape
implements IPapyrusNodeUMLElementFigure,
IPapyrusNodeFigure {
    private CenteredWrappedLabel fAcceptEventActionLabel;
    private final Insets marginTemplate;
    private StereotypeFigureHelper stereotypeHelper;
    private final PointList myTemplate = new PointList();
    private Rectangle myTemplateBounds;
    String stereotypeDisplayText = null;
    Image stereotypeDisplayImg = null;
    String stereotypePropertiesInBrace = null;
    String stereotypePropertiesInCompartment = null;
    private final PointList myTemplateTime = new PointList();
    private boolean useTemplateTime = false;
    private Rectangle myTemplateTimeBounds;

    public AcceptEventActionFigure() {
        CenteredColumnLayout layoutThis = new CenteredColumnLayout();
        this.setLayoutManager((LayoutManager)layoutThis);
        this.addPoint(new Point(0, 0));
        this.addPoint(new Point(200, 0));
        this.addPoint(new Point(200, 50));
        this.addPoint(new Point(0, 50));
        this.addPoint(new Point(50, 25));
        this.addTimePoint(new Point(0, 0));
        this.addTimePoint(new Point(100, 0));
        this.addTimePoint(new Point(50, 25));
        this.addTimePoint(new Point(100, 50));
        this.addTimePoint(new Point(0, 50));
        this.addTimePoint(new Point(50, 25));
        this.setFill(true);
        this.setLineWidth(1);
        this.marginTemplate = new Insets(0, 50, 0, 0);
        this.setBorder((Border)new MarginBorder(this.marginTemplate));
        this.createContents();
        this.stereotypeHelper = new StereotypeFigureHelper((IFigure)this){

            public Object getStereotypeRectangleConstraint() {
                CenteredColumnConstraint constraintStereotypeRect0 = new CenteredColumnConstraint(false);
                return constraintStereotypeRect0;
            }
        };
    }

    private void createContents() {
        RectangleFigure labelRect0 = new RectangleFigure();
        labelRect0.setFill(false);
        labelRect0.setOutline(false);
        labelRect0.setLineWidth(1);
        CenteredColumnConstraint constraintLabelRect0 = new CenteredColumnConstraint(true);
        this.add((IFigure)labelRect0, constraintLabelRect0);
        CenterLayout layoutLabelRect0 = new CenterLayout();
        labelRect0.setLayoutManager((LayoutManager)layoutLabelRect0);
        this.fAcceptEventActionLabel = new CenteredWrappedLabel();
        labelRect0.add((IFigure)this.fAcceptEventActionLabel);
    }

    public void addPoint(Point point) {
        this.myTemplate.addPoint(point);
        this.myTemplateBounds = null;
    }

    protected void refreshLayout() {
    }

    public void setStereotypeDisplay(String stereotypes, Image image) {
        if (!this.isTemplateForAcceptTimeEventActionUsed()) {
            this.stereotypeHelper.setStereotypeDisplay(stereotypes, image);
            this.refreshLayout();
        }
        this.stereotypeDisplayText = stereotypes;
        this.stereotypeDisplayImg = image;
    }

    public void setStereotypePropertiesInBrace(String stereotypeProperties) {
        if (!this.isTemplateForAcceptTimeEventActionUsed()) {
            this.stereotypeHelper.setStereotypePropertiesInBrace(stereotypeProperties);
            this.refreshLayout();
        }
        this.stereotypePropertiesInBrace = stereotypeProperties;
    }

    public void setStereotypePropertiesInCompartment(String stereotypeProperties) {
        if (!this.isTemplateForAcceptTimeEventActionUsed()) {
            this.stereotypeHelper.setStereotypePropertiesInCompartment(stereotypeProperties);
            this.refreshLayout();
        }
        this.stereotypePropertiesInCompartment = stereotypeProperties;
    }

    @Deprecated
    public Label getStereotypesLabel() {
        return null;
    }

    public void useTemplateForAcceptTimeEventAction(boolean useAcceptTimeEventActionTemplate) {
        if (useAcceptTimeEventActionTemplate) {
            this.stereotypeHelper.setStereotypeDisplay(null, null);
            this.stereotypeHelper.setStereotypePropertiesInBrace(null);
            this.stereotypeHelper.setStereotypePropertiesInCompartment(null);
        } else {
            this.stereotypeHelper.setStereotypeDisplay(this.stereotypeDisplayText, this.stereotypeDisplayImg);
            this.stereotypeHelper.setStereotypePropertiesInBrace(this.stereotypePropertiesInBrace);
            this.stereotypeHelper.setStereotypePropertiesInCompartment(this.stereotypePropertiesInCompartment);
        }
        this.useTemplateTime = useAcceptTimeEventActionTemplate;
    }

    public boolean isTemplateForAcceptTimeEventActionUsed() {
        return this.useTemplateTime;
    }

    public void addTimePoint(Point point) {
        this.myTemplateTime.addPoint(point);
        this.myTemplateTimeBounds = null;
    }

    protected void fillShape(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        graphics.pushState();
        graphics.translate(bounds.x, bounds.y);
        graphics.fillPolygon(this.scalePointList());
        graphics.popState();
        Insets newInsets = this.scaleMargin();
        if (!newInsets.equals((Object)this.getBorder().getInsets((IFigure)this))) {
            this.setBorder((Border)new MarginBorder(this.scaleMargin()));
        }
    }

    protected void outlineShape(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        graphics.pushState();
        graphics.translate(bounds.x, bounds.y);
        graphics.setLineWidth(Math.max(1, this.getLineWidth()));
        graphics.drawPolygon(this.scalePointList());
        graphics.popState();
    }

    private Insets scaleMargin() {
        Rectangle pointsBounds = this.getTemplateBounds();
        Rectangle actualBounds = this.getBounds();
        float xScale = (float)actualBounds.width / (float)pointsBounds.width;
        float yScale = (float)actualBounds.height / (float)pointsBounds.height;
        if (xScale == 1.0f && yScale == 1.0f) {
            return this.marginTemplate;
        }
        Insets scaled = new Insets(this.marginTemplate);
        scaled.top = (int)Math.floor((float)scaled.top * yScale);
        scaled.left = (int)Math.floor((float)scaled.left * xScale);
        scaled.bottom = (int)Math.floor((float)scaled.bottom * yScale);
        scaled.right = (int)Math.floor((float)scaled.right * xScale);
        return scaled;
    }

    private Rectangle getTemplateBounds() {
        if (this.myTemplateBounds == null) {
            this.myTemplateBounds = this.myTemplate.getBounds().getCopy().union(0, 0);
            if (this.myTemplateBounds.width < 1) {
                this.myTemplateBounds.width = 1;
            }
            if (this.myTemplateBounds.height < 1) {
                this.myTemplateBounds.height = 1;
            }
        }
        if (this.myTemplateTimeBounds == null) {
            this.myTemplateTimeBounds = this.myTemplateTime.getBounds().getCopy().union(0, 0);
            if (this.myTemplateTimeBounds.width < 1) {
                this.myTemplateTimeBounds.width = 1;
            }
            if (this.myTemplateTimeBounds.height < 1) {
                this.myTemplateTimeBounds.height = 1;
            }
        }
        if (this.useTemplateTime) {
            return this.myTemplateTimeBounds;
        }
        return this.myTemplateBounds;
    }

    private int[] scalePointList() {
        Rectangle pointsBounds = this.getTemplateBounds();
        Rectangle actualBounds = this.getBounds();
        float xScale = (float)actualBounds.width / (float)pointsBounds.width;
        float yScale = (float)actualBounds.height / (float)pointsBounds.height;
        if (xScale == 1.0f && yScale == 1.0f) {
            if (this.useTemplateTime) {
                return this.myTemplateTime.toIntArray();
            }
            return this.myTemplate.toIntArray();
        }
        int[] scaled = this.useTemplateTime ? (int[])this.myTemplateTime.toIntArray().clone() : (int[])this.myTemplate.toIntArray().clone();
        int i = 0;
        while (i < scaled.length) {
            scaled[i] = (int)Math.floor((float)scaled[i] * xScale);
            scaled[i + 1] = (int)Math.floor((float)scaled[i + 1] * yScale);
            i += 2;
        }
        return scaled;
    }

    public CenteredWrappedLabel getAcceptEventActionLabel() {
        return this.fAcceptEventActionLabel;
    }

    public Color getBorderColor() {
        return null;
    }

    public boolean isShadow() {
        return false;
    }

    public void setBorderColor(Color borderColor) {
    }

    public void setShadow(boolean shadow) {
    }

    public void setTransparency(int transparency) {
    }

    public void setGradientData(int gradientColor1, int gradientColor2, int gradientStyle) {
    }

    public void setIsUsingGradient(boolean b) {
    }
}

