/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;
import org.eclipse.papyrus.uml.diagram.clazz.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.uml.diagram.clazz/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PapyrusUMLClassDiagram".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        return 1000;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLClassDiagram".equals(containerModelID)) {
            return -1;
        }
        if ("PapyrusUMLClassDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
                    return 2014;
                }
                if (UMLPackage.eINSTANCE.getAssociationClass().isSuperTypeOf(domainElement.eClass())) {
                    return 2013;
                }
                if (UMLPackage.eINSTANCE.getAssociation().isSuperTypeOf(domainElement.eClass())) {
                    return 2015;
                }
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2004;
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 2006;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 2007;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 2099;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 2008;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 2009;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 2010;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2011;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 2012;
                }
                if (NotationPackage.eINSTANCE.getDiagram().isSuperTypeOf(domainElement.eClass())) {
                    return 2016;
                }
                if (UMLPackage.eINSTANCE.getDurationObservation().isSuperTypeOf(domainElement.eClass())) {
                    return 2095;
                }
                if (UMLPackage.eINSTANCE.getTimeObservation().isSuperTypeOf(domainElement.eClass())) {
                    return 2096;
                }
                if (!UMLPackage.eINSTANCE.getNamedElement().isSuperTypeOf(domainElement.eClass())) break;
                return 2097;
            }
            case 2002: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 2003: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 2004: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 2005: {
                if (UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) {
                    return 3015;
                }
                if (!UMLPackage.eINSTANCE.getTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3033;
            }
            case 2007: {
                if (UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) {
                    return 3015;
                }
                if (!UMLPackage.eINSTANCE.getTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3033;
            }
            case 2008: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 2010: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 3021: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 3022: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 3023: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 3024: {
                if (UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) {
                    return 3015;
                }
                if (!UMLPackage.eINSTANCE.getTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3033;
            }
            case 3009: {
                if (UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) {
                    return 3015;
                }
                if (!UMLPackage.eINSTANCE.getTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3033;
            }
            case 3010: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 3027: {
                if (!UMLPackage.eINSTANCE.getRedefinableTemplateSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 7011: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3012;
            }
            case 7012: {
                if (UMLPackage.eINSTANCE.getReception().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3013;
            }
            case 7013: {
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3014;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3047;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3044;
                }
                if (!UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) break;
                return 3050;
            }
            case 7023: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7024: {
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (!UMLPackage.eINSTANCE.getReception().isSuperTypeOf(domainElement.eClass())) break;
                return 3011;
            }
            case 7025: {
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3053;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3046;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3045;
                }
                if (!UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) break;
                return 3051;
            }
            case 7026: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3005;
            }
            case 7027: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3006;
            }
            case 7028: {
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (!UMLPackage.eINSTANCE.getReception().isSuperTypeOf(domainElement.eClass())) break;
                return 3039;
            }
            case 7029: {
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3054;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3048;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3043;
                }
                if (!UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) break;
                return 3049;
            }
            case 7041: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3041;
            }
            case 7042: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3042;
            }
            case 7032: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3018;
            }
            case 7033: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3019;
            }
            case 7030: {
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3020;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3021;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3022;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3023;
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 3024;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3025;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3026;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3027;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3028;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3029;
                }
                if (!UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) break;
                return 3040;
            }
            case 7010: {
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3020;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3021;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3022;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3023;
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 3024;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3025;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3026;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3027;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3028;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3029;
                }
                if (!UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) break;
                return 3040;
            }
            case 7031: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3017;
            }
            case 7035: {
                if (!UMLPackage.eINSTANCE.getSlot().isSuperTypeOf(domainElement.eClass())) break;
                return 3030;
            }
            case 7017: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3012;
            }
            case 7018: {
                if (UMLPackage.eINSTANCE.getReception().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3013;
            }
            case 7019: {
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3014;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3047;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3044;
                }
                if (!UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) break;
                return 3050;
            }
            case 7002: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7003: {
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (!UMLPackage.eINSTANCE.getReception().isSuperTypeOf(domainElement.eClass())) break;
                return 3011;
            }
            case 7004: {
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3053;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3046;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3045;
                }
                if (!UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) break;
                return 3051;
            }
            case 7006: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3006;
            }
            case 7007: {
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (!UMLPackage.eINSTANCE.getReception().isSuperTypeOf(domainElement.eClass())) break;
                return 3039;
            }
            case 7008: {
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3054;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3048;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3043;
                }
                if (!UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) break;
                return 3049;
            }
            case 7039: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3041;
            }
            case 7040: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3042;
            }
            case 7020: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3018;
            }
            case 7021: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3019;
            }
            case 7034: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7001: {
                if (!UMLPackage.eINSTANCE.getSlot().isSuperTypeOf(domainElement.eClass())) break;
                return 3030;
            }
            case 7005: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3005;
            }
            case 7009: {
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3020;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3021;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3022;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3023;
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 3024;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3025;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3026;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3027;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3028;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3029;
                }
                if (!UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) break;
                return 3040;
            }
            case 7016: {
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3020;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3021;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3022;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3023;
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 3024;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3025;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3026;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3027;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3028;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3029;
                }
                if (!UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) break;
                return 3040;
            }
            case 7015: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3017;
            }
            case 7036: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7037: {
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 7014: {
                if (UMLPackage.eINSTANCE.getClassifierTemplateParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3031;
                }
                if (UMLPackage.eINSTANCE.getConnectableElementTemplateParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getOperationTemplateParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3035;
                }
                if (!UMLPackage.eINSTANCE.getTemplateParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3016;
            }
            case 7038: {
                if (UMLPackage.eINSTANCE.getClassifierTemplateParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3031;
                }
                if (UMLPackage.eINSTANCE.getOperationTemplateParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3035;
                }
                if (!UMLPackage.eINSTANCE.getTemplateParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3016;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLClassDiagram".equals(containerModelID)) {
            return false;
        }
        if ("PapyrusUMLClassDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2014 == nodeVisualID) {
                    return true;
                }
                if (2013 == nodeVisualID) {
                    return true;
                }
                if (2015 == nodeVisualID) {
                    return true;
                }
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2004 == nodeVisualID) {
                    return true;
                }
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2007 == nodeVisualID) {
                    return true;
                }
                if (2099 == nodeVisualID) {
                    return true;
                }
                if (2008 == nodeVisualID) {
                    return true;
                }
                if (2009 == nodeVisualID) {
                    return true;
                }
                if (2010 == nodeVisualID) {
                    return true;
                }
                if (2011 == nodeVisualID) {
                    return true;
                }
                if (2012 == nodeVisualID) {
                    return true;
                }
                if (2016 == nodeVisualID) {
                    return true;
                }
                if (2095 == nodeVisualID) {
                    return true;
                }
                if (2096 == nodeVisualID) {
                    return true;
                }
                if (2097 != nodeVisualID) break;
                return true;
            }
            case 2014: {
                if (1 != nodeVisualID) break;
                return true;
            }
            case 2013: {
                if (5066 == nodeVisualID) {
                    return true;
                }
                if (7034 == nodeVisualID) {
                    return true;
                }
                if (7036 == nodeVisualID) {
                    return true;
                }
                if (7037 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (7001 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (7002 == nodeVisualID) {
                    return true;
                }
                if (7003 == nodeVisualID) {
                    return true;
                }
                if (7004 == nodeVisualID) {
                    return true;
                }
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5008 == nodeVisualID) {
                    return true;
                }
                if (7005 == nodeVisualID) {
                    return true;
                }
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 2004: {
                if (5011 == nodeVisualID) {
                    return true;
                }
                if (7006 == nodeVisualID) {
                    return true;
                }
                if (7007 == nodeVisualID) {
                    return true;
                }
                if (7008 == nodeVisualID) {
                    return true;
                }
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (5020 == nodeVisualID) {
                    return true;
                }
                if (7009 == nodeVisualID) {
                    return true;
                }
                if (3015 == nodeVisualID) {
                    return true;
                }
                if (3033 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (5023 == nodeVisualID) {
                    return true;
                }
                if (7015 != nodeVisualID) break;
                return true;
            }
            case 2007: {
                if (5026 == nodeVisualID) {
                    return true;
                }
                if (7016 == nodeVisualID) {
                    return true;
                }
                if (3015 == nodeVisualID) {
                    return true;
                }
                if (3033 != nodeVisualID) break;
                return true;
            }
            case 2099: {
                if (5161 != nodeVisualID) break;
                return true;
            }
            case 2008: {
                if (5029 == nodeVisualID) {
                    return true;
                }
                if (7017 == nodeVisualID) {
                    return true;
                }
                if (7018 == nodeVisualID) {
                    return true;
                }
                if (7019 == nodeVisualID) {
                    return true;
                }
                if (3015 == nodeVisualID) {
                    return true;
                }
                if (3032 != nodeVisualID) break;
                return true;
            }
            case 2009: {
                if (5032 == nodeVisualID) {
                    return true;
                }
                if (7039 == nodeVisualID) {
                    return true;
                }
                if (7040 != nodeVisualID) break;
                return true;
            }
            case 2010: {
                if (5035 == nodeVisualID) {
                    return true;
                }
                if (7020 == nodeVisualID) {
                    return true;
                }
                if (7021 == nodeVisualID) {
                    return true;
                }
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 2011: {
                if (5037 == nodeVisualID) {
                    return true;
                }
                if (5159 != nodeVisualID) break;
                return true;
            }
            case 2012: {
                if (5038 != nodeVisualID) break;
                return true;
            }
            case 2016: {
                if (nodeVisualID != 0) break;
                return true;
            }
            case 2095: {
                if (5155 == nodeVisualID) {
                    return true;
                }
                if (5156 != nodeVisualID) break;
                return true;
            }
            case 2096: {
                if (5153 == nodeVisualID) {
                    return true;
                }
                if (5154 != nodeVisualID) break;
                return true;
            }
            case 2097: {
                if (5157 != nodeVisualID) break;
                return true;
            }
            case 3015: {
                if (7014 != nodeVisualID) break;
                return true;
            }
            case 3033: {
                if (7038 != nodeVisualID) break;
                return true;
            }
            case 3020: {
                if (5040 == nodeVisualID) {
                    return true;
                }
                if (7035 != nodeVisualID) break;
                return true;
            }
            case 3021: {
                if (5043 == nodeVisualID) {
                    return true;
                }
                if (7023 == nodeVisualID) {
                    return true;
                }
                if (7024 == nodeVisualID) {
                    return true;
                }
                if (7025 == nodeVisualID) {
                    return true;
                }
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 3022: {
                if (5046 == nodeVisualID) {
                    return true;
                }
                if (7026 == nodeVisualID) {
                    return true;
                }
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 3023: {
                if (5049 == nodeVisualID) {
                    return true;
                }
                if (7027 == nodeVisualID) {
                    return true;
                }
                if (7028 == nodeVisualID) {
                    return true;
                }
                if (7029 == nodeVisualID) {
                    return true;
                }
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 3024: {
                if (5052 == nodeVisualID) {
                    return true;
                }
                if (7030 == nodeVisualID) {
                    return true;
                }
                if (3015 == nodeVisualID) {
                    return true;
                }
                if (3033 != nodeVisualID) break;
                return true;
            }
            case 3025: {
                if (5055 == nodeVisualID) {
                    return true;
                }
                if (7031 != nodeVisualID) break;
                return true;
            }
            case 3009: {
                if (5017 == nodeVisualID) {
                    return true;
                }
                if (7010 == nodeVisualID) {
                    return true;
                }
                if (3015 == nodeVisualID) {
                    return true;
                }
                if (3033 != nodeVisualID) break;
                return true;
            }
            case 3040: {
                if (5162 != nodeVisualID) break;
                return true;
            }
            case 3010: {
                if (5014 == nodeVisualID) {
                    return true;
                }
                if (7011 == nodeVisualID) {
                    return true;
                }
                if (7012 == nodeVisualID) {
                    return true;
                }
                if (7013 == nodeVisualID) {
                    return true;
                }
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 3026: {
                if (5058 == nodeVisualID) {
                    return true;
                }
                if (7041 == nodeVisualID) {
                    return true;
                }
                if (7042 != nodeVisualID) break;
                return true;
            }
            case 3027: {
                if (5061 == nodeVisualID) {
                    return true;
                }
                if (7032 == nodeVisualID) {
                    return true;
                }
                if (7033 == nodeVisualID) {
                    return true;
                }
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 3028: {
                if (5063 != nodeVisualID) break;
                return true;
            }
            case 3029: {
                if (5064 == nodeVisualID) {
                    return true;
                }
                if (5160 != nodeVisualID) break;
                return true;
            }
            case 7011: {
                if (3012 != nodeVisualID) break;
                return true;
            }
            case 7012: {
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3013 != nodeVisualID) break;
                return true;
            }
            case 7013: {
                if (3014 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3047 == nodeVisualID) {
                    return true;
                }
                if (3044 == nodeVisualID) {
                    return true;
                }
                if (3050 != nodeVisualID) break;
                return true;
            }
            case 7023: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 7024: {
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3011 != nodeVisualID) break;
                return true;
            }
            case 7025: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3053 == nodeVisualID) {
                    return true;
                }
                if (3046 == nodeVisualID) {
                    return true;
                }
                if (3045 == nodeVisualID) {
                    return true;
                }
                if (3051 != nodeVisualID) break;
                return true;
            }
            case 7026: {
                if (3005 != nodeVisualID) break;
                return true;
            }
            case 7027: {
                if (3006 != nodeVisualID) break;
                return true;
            }
            case 7028: {
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3039 != nodeVisualID) break;
                return true;
            }
            case 7029: {
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3054 == nodeVisualID) {
                    return true;
                }
                if (3048 == nodeVisualID) {
                    return true;
                }
                if (3043 == nodeVisualID) {
                    return true;
                }
                if (3049 != nodeVisualID) break;
                return true;
            }
            case 7041: {
                if (3041 != nodeVisualID) break;
                return true;
            }
            case 7042: {
                if (3042 != nodeVisualID) break;
                return true;
            }
            case 7032: {
                if (3018 != nodeVisualID) break;
                return true;
            }
            case 7033: {
                if (3019 != nodeVisualID) break;
                return true;
            }
            case 7030: {
                if (3020 == nodeVisualID) {
                    return true;
                }
                if (3021 == nodeVisualID) {
                    return true;
                }
                if (3022 == nodeVisualID) {
                    return true;
                }
                if (3023 == nodeVisualID) {
                    return true;
                }
                if (3024 == nodeVisualID) {
                    return true;
                }
                if (3025 == nodeVisualID) {
                    return true;
                }
                if (3009 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3026 == nodeVisualID) {
                    return true;
                }
                if (3027 == nodeVisualID) {
                    return true;
                }
                if (3028 == nodeVisualID) {
                    return true;
                }
                if (3029 == nodeVisualID) {
                    return true;
                }
                if (3040 != nodeVisualID) break;
                return true;
            }
            case 7010: {
                if (3020 == nodeVisualID) {
                    return true;
                }
                if (3021 == nodeVisualID) {
                    return true;
                }
                if (3022 == nodeVisualID) {
                    return true;
                }
                if (3023 == nodeVisualID) {
                    return true;
                }
                if (3024 == nodeVisualID) {
                    return true;
                }
                if (3025 == nodeVisualID) {
                    return true;
                }
                if (3009 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3026 == nodeVisualID) {
                    return true;
                }
                if (3027 == nodeVisualID) {
                    return true;
                }
                if (3028 == nodeVisualID) {
                    return true;
                }
                if (3029 == nodeVisualID) {
                    return true;
                }
                if (3040 != nodeVisualID) break;
                return true;
            }
            case 7031: {
                if (3017 != nodeVisualID) break;
                return true;
            }
            case 7035: {
                if (3030 != nodeVisualID) break;
                return true;
            }
            case 7017: {
                if (3012 != nodeVisualID) break;
                return true;
            }
            case 7018: {
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3013 != nodeVisualID) break;
                return true;
            }
            case 7019: {
                if (3014 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3047 == nodeVisualID) {
                    return true;
                }
                if (3044 == nodeVisualID) {
                    return true;
                }
                if (3050 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3011 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3053 == nodeVisualID) {
                    return true;
                }
                if (3046 == nodeVisualID) {
                    return true;
                }
                if (3045 == nodeVisualID) {
                    return true;
                }
                if (3051 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3006 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3039 != nodeVisualID) break;
                return true;
            }
            case 7008: {
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3054 == nodeVisualID) {
                    return true;
                }
                if (3048 == nodeVisualID) {
                    return true;
                }
                if (3043 == nodeVisualID) {
                    return true;
                }
                if (3049 != nodeVisualID) break;
                return true;
            }
            case 7039: {
                if (3041 != nodeVisualID) break;
                return true;
            }
            case 7040: {
                if (3042 != nodeVisualID) break;
                return true;
            }
            case 7020: {
                if (3018 != nodeVisualID) break;
                return true;
            }
            case 7021: {
                if (3019 != nodeVisualID) break;
                return true;
            }
            case 7034: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3030 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3005 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3020 == nodeVisualID) {
                    return true;
                }
                if (3021 == nodeVisualID) {
                    return true;
                }
                if (3022 == nodeVisualID) {
                    return true;
                }
                if (3023 == nodeVisualID) {
                    return true;
                }
                if (3024 == nodeVisualID) {
                    return true;
                }
                if (3025 == nodeVisualID) {
                    return true;
                }
                if (3009 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3026 == nodeVisualID) {
                    return true;
                }
                if (3027 == nodeVisualID) {
                    return true;
                }
                if (3028 == nodeVisualID) {
                    return true;
                }
                if (3029 == nodeVisualID) {
                    return true;
                }
                if (3040 != nodeVisualID) break;
                return true;
            }
            case 7016: {
                if (3020 == nodeVisualID) {
                    return true;
                }
                if (3021 == nodeVisualID) {
                    return true;
                }
                if (3022 == nodeVisualID) {
                    return true;
                }
                if (3023 == nodeVisualID) {
                    return true;
                }
                if (3024 == nodeVisualID) {
                    return true;
                }
                if (3025 == nodeVisualID) {
                    return true;
                }
                if (3009 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3026 == nodeVisualID) {
                    return true;
                }
                if (3027 == nodeVisualID) {
                    return true;
                }
                if (3028 == nodeVisualID) {
                    return true;
                }
                if (3029 == nodeVisualID) {
                    return true;
                }
                if (3040 != nodeVisualID) break;
                return true;
            }
            case 7015: {
                if (3017 != nodeVisualID) break;
                return true;
            }
            case 7036: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7037: {
                if (3004 != nodeVisualID) break;
                return true;
            }
            case 7014: {
                if (3031 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3016 != nodeVisualID) break;
                return true;
            }
            case 7038: {
                if (3031 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3016 != nodeVisualID) break;
                return true;
            }
            case 4017: {
                if (6031 == nodeVisualID) {
                    return true;
                }
                if (6032 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6001 == nodeVisualID) {
                    return true;
                }
                if (6002 == nodeVisualID) {
                    return true;
                }
                if (6003 == nodeVisualID) {
                    return true;
                }
                if (6005 == nodeVisualID) {
                    return true;
                }
                if (6033 == nodeVisualID) {
                    return true;
                }
                if (6034 != nodeVisualID) break;
                return true;
            }
            case 4019: {
                if (6024 == nodeVisualID) {
                    return true;
                }
                if (6035 != nodeVisualID) break;
                return true;
            }
            case 4002: {
                if (6007 != nodeVisualID) break;
                return true;
            }
            case 4003: {
                if (6008 == nodeVisualID) {
                    return true;
                }
                if (6009 != nodeVisualID) break;
                return true;
            }
            case 4004: {
                if (6010 == nodeVisualID) {
                    return true;
                }
                if (6011 != nodeVisualID) break;
                return true;
            }
            case 4005: {
                if (6012 == nodeVisualID) {
                    return true;
                }
                if (6013 != nodeVisualID) break;
                return true;
            }
            case 4006: {
                if (6014 == nodeVisualID) {
                    return true;
                }
                if (6015 != nodeVisualID) break;
                return true;
            }
            case 4007: {
                if (6016 == nodeVisualID) {
                    return true;
                }
                if (6017 != nodeVisualID) break;
                return true;
            }
            case 4008: {
                if (6026 == nodeVisualID) {
                    return true;
                }
                if (6027 != nodeVisualID) break;
                return true;
            }
            case 4009: {
                if (6020 == nodeVisualID) {
                    return true;
                }
                if (6021 != nodeVisualID) break;
                return true;
            }
            case 4010: {
                if (6022 != nodeVisualID) break;
                return true;
            }
            case 4011: {
                if (6030 != nodeVisualID) break;
                return true;
            }
            case 4015: {
                if (6023 == nodeVisualID) {
                    return true;
                }
                if (6036 != nodeVisualID) break;
                return true;
            }
            case 4020: {
                if (5067 == nodeVisualID) {
                    return true;
                }
                if (6037 != nodeVisualID) break;
                return true;
            }
            case 4021: {
                if (6039 == nodeVisualID) {
                    return true;
                }
                if (6038 != nodeVisualID) break;
                return true;
            }
            case 4026: {
                if (6040 == nodeVisualID) {
                    return true;
                }
                if (6041 != nodeVisualID) break;
                return true;
            }
            case 8500: {
                if (8501 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getAssociationClass().isSuperTypeOf(domainElement.eClass())) {
            return 4017;
        }
        if (UMLPackage.eINSTANCE.getAssociation().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        if (UMLPackage.eINSTANCE.getAssociation().isSuperTypeOf(domainElement.eClass())) {
            return 4019;
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return 4002;
        }
        if (UMLPackage.eINSTANCE.getInterfaceRealization().isSuperTypeOf(domainElement.eClass())) {
            return 4003;
        }
        if (UMLPackage.eINSTANCE.getSubstitution().isSuperTypeOf(domainElement.eClass())) {
            return 4004;
        }
        if (UMLPackage.eINSTANCE.getRealization().isSuperTypeOf(domainElement.eClass())) {
            return 4005;
        }
        if (UMLPackage.eINSTANCE.getAbstraction().isSuperTypeOf(domainElement.eClass())) {
            return 4006;
        }
        if (UMLPackage.eINSTANCE.getUsage().isSuperTypeOf(domainElement.eClass())) {
            return 4007;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
            return 4008;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
            return 4018;
        }
        if (UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass())) {
            return 4009;
        }
        if (UMLPackage.eINSTANCE.getPackageImport().isSuperTypeOf(domainElement.eClass())) {
            return 4010;
        }
        if (UMLPackage.eINSTANCE.getPackageMerge().isSuperTypeOf(domainElement.eClass())) {
            return 4011;
        }
        if (UMLPackage.eINSTANCE.getProfileApplication().isSuperTypeOf(domainElement.eClass())) {
            return 4012;
        }
        if (UMLPackage.eINSTANCE.getTemplateBinding().isSuperTypeOf(domainElement.eClass())) {
            return 4015;
        }
        if (UMLPackage.eINSTANCE.getGeneralizationSet().isSuperTypeOf(domainElement.eClass())) {
            return 4020;
        }
        if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
            return 4021;
        }
        if (UMLPackage.eINSTANCE.getInformationFlow().isSuperTypeOf(domainElement.eClass())) {
            return 4026;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7001: 
            case 7002: 
            case 7003: 
            case 7004: 
            case 7005: 
            case 7006: 
            case 7007: 
            case 7008: 
            case 7009: 
            case 7010: 
            case 7011: 
            case 7012: 
            case 7013: 
            case 7014: 
            case 7015: 
            case 7016: 
            case 7017: 
            case 7018: 
            case 7019: 
            case 7020: 
            case 7021: 
            case 7023: 
            case 7024: 
            case 7025: 
            case 7026: 
            case 7027: 
            case 7028: 
            case 7029: 
            case 7030: 
            case 7031: 
            case 7032: 
            case 7033: 
            case 7034: 
            case 7035: 
            case 7036: 
            case 7037: 
            case 7038: 
            case 7039: 
            case 7040: 
            case 7041: 
            case 7042: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1000: {
                return false;
            }
            case 2011: 
            case 2012: 
            case 2014: 
            case 2015: 
            case 2016: 
            case 2095: 
            case 2096: 
            case 2097: 
            case 2099: 
            case 3002: 
            case 3003: 
            case 3004: 
            case 3005: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3011: 
            case 3012: 
            case 3013: 
            case 3014: 
            case 3016: 
            case 3017: 
            case 3018: 
            case 3019: 
            case 3028: 
            case 3029: 
            case 3030: 
            case 3031: 
            case 3032: 
            case 3034: 
            case 3035: 
            case 3036: 
            case 3037: 
            case 3038: 
            case 3039: 
            case 3040: 
            case 3041: 
            case 3042: 
            case 3043: 
            case 3044: 
            case 3045: 
            case 3046: 
            case 3047: 
            case 3048: 
            case 3049: 
            case 3050: 
            case 3051: 
            case 3052: 
            case 3053: 
            case 3054: {
                return true;
            }
        }
        return false;
    }
}

