/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.actions;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.commands.wrappers.EMFtoGEFCommandWrapper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.ui.IWorkbenchPage;

public class MoveCompartmentObjectAction
extends DiagramAction {
    private int actionType = 0;
    public static final int MOVE_TOP = 3;
    public static final int MOVE_UP = 2;
    public static final int MOVE_DOWN = 1;
    public static final int MOVE_BOTTOM = 0;
    private static final String MOVE_TOP_STR = "Move Top";
    private static final String MOVE_UP_STR = "Move Up";
    private static final String MOVE_DOWN_STR = "Move Down";
    private static final String MOVE_BOTTOM_STR = "Move Bottom";
    private static final String MOVE_TOP_IMG = "/icons/move_top.gif";
    private static final String MOVE_UP_IMG = "/icons/move_up.gif";
    private static final String MOVE_DOWN_IMG = "/icons/move_down.gif";
    private static final String MOVE_BOTTOM_IMG = "/icons/move_bottom.gif";

    public MoveCompartmentObjectAction(IWorkbenchPage workbenchPage, int actionType) {
        super(workbenchPage);
        this.actionType = actionType > 3 || actionType < 0 ? this.getDefaultAction() : actionType;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected org.eclipse.gef.commands.Command getCommand() {
        View view;
        IGraphicalEditPart selEP = this.getSelectedEditPart();
        if (selEP == null || selEP.getEditingDomain() == null) {
            return null;
        }
        TransactionalEditingDomain eDomain = selEP.getEditingDomain();
        Object model = selEP.getModel();
        if (model instanceof View && (view = (View)model).eContainer() != null && view.eContainer() instanceof View) {
            View viewParent = (View)view.eContainer();
            int pos = 0;
            switch (this.actionType) {
                case 3: {
                    pos = 0;
                    break;
                }
                case 2: {
                    pos = viewParent.getPersistedChildren().indexOf((Object)view) - 1;
                    break;
                }
                case 1: {
                    pos = viewParent.getPersistedChildren().indexOf((Object)view) + 1;
                    break;
                }
                case 0: {
                    pos = viewParent.getPersistedChildren().size() - 1;
                }
            }
            MoveCommand moveCmd = new MoveCommand((EditingDomain)eDomain, (EObject)viewParent, (EStructuralFeature)NotationPackage.eINSTANCE.getView_PersistedChildren(), (Object)view, pos);
            return new EMFtoGEFCommandWrapper((Command)moveCmd);
        }
        return null;
    }

    public boolean isEnabled() {
        IGraphicalEditPart selEP = this.getSelectedEditPart();
        if (selEP == null || selEP.getParent() == null) {
            return false;
        }
        if (!(selEP.getParent() instanceof ListCompartmentEditPart)) {
            return false;
        }
        if (selEP.getParent().getChildren().size() <= 1) {
            return false;
        }
        return selEP.getModel() != null && selEP.getModel() instanceof View;
    }

    public void refresh() {
        super.refresh();
        this.setText(this.calculateText());
        this.setImageDescriptor(this.calculateImage());
    }

    protected int getDefaultAction() {
        return 3;
    }

    protected String getDefaultActionStr() {
        return MOVE_TOP_STR;
    }

    protected String getDefaultActionImgPath() {
        return MOVE_TOP_IMG;
    }

    private String calculateText() {
        switch (this.actionType) {
            case 3: {
                return MOVE_TOP_STR;
            }
            case 2: {
                return MOVE_UP_STR;
            }
            case 1: {
                return MOVE_DOWN_STR;
            }
            case 0: {
                return MOVE_BOTTOM_STR;
            }
        }
        return this.getDefaultActionStr();
    }

    private ImageDescriptor calculateImage() {
        String imgPath = this.getDefaultActionImgPath();
        switch (this.actionType) {
            case 3: {
                imgPath = MOVE_TOP_IMG;
                break;
            }
            case 2: {
                imgPath = MOVE_UP_IMG;
                break;
            }
            case 1: {
                imgPath = MOVE_DOWN_IMG;
                break;
            }
            case 0: {
                imgPath = MOVE_BOTTOM_IMG;
            }
        }
        ImageDescriptor descriptor = Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)imgPath);
        return descriptor;
    }

    private IGraphicalEditPart getSelectedEditPart() {
        for (Object next : this.getSelectedObjects()) {
            if (!(next instanceof IGraphicalEditPart)) continue;
            IGraphicalEditPart editPart = (IGraphicalEditPart)next;
            return editPart;
        }
        return null;
    }
}

