/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.papyrus.uml.diagram.common.editparts.BorderNodeEditPart;
import org.eclipse.papyrus.uml.diagram.common.editparts.IUMLEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ApplyStereotypeEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.common.helper.ICompartmentLayoutHelper;
import org.eclipse.papyrus.uml.diagram.common.service.ApplyStereotypeRequest;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.uml2.uml.Element;

public abstract class BorderUMLNodeEditPart
extends BorderNodeEditPart
implements IUMLEditPart {
    private FontDescriptor cachedFontDescriptor;
    private ICompartmentLayoutHelper compartmentLayoutHelper;

    protected ICompartmentLayoutHelper getCompartmentLayoutHelper() {
        return this.compartmentLayoutHelper;
    }

    protected void setCompartmentLayoutHelper(ICompartmentLayoutHelper compartmentLayoutHelper) {
        this.compartmentLayoutHelper = compartmentLayoutHelper;
    }

    public BorderUMLNodeEditPart(View view) {
        super(view);
    }

    public void refresh() {
        super.refresh();
        this.changeLayoutCompartment();
    }

    @Override
    public Element getUMLElement() {
        return (Element)this.resolveSemanticElement();
    }

    @Override
    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        if (event.getNotifier() instanceof EAnnotation && "layoutFigure".equals(((EAnnotation)event.getNotifier()).getSource())) {
            this.changeLayoutCompartment();
        }
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            this.refreshFontColor();
        }
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy(ApplyStereotypeRequest.APPLY_STEREOTYPE_REQUEST, (EditPolicy)new ApplyStereotypeEditPolicy());
    }

    protected void changeLayoutCompartment() {
        if (this.getCompartmentLayoutHelper() != null) {
            for (EditPart currentEditPart : this.getChildren()) {
                if (!(currentEditPart instanceof ListCompartmentEditPart)) continue;
                this.getCompartmentLayoutHelper().applyLayout((AbstractGraphicalEditPart)((ListCompartmentEditPart)currentEditPart));
            }
        }
    }

    public EditPart getTargetEditPart(Request request) {
        if (ApplyStereotypeRequest.APPLY_STEREOTYPE_REQUEST.equals(request.getType())) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshShadow();
        this.refreshFontColor();
    }

    protected void refreshFont() {
        FontStyle style = (FontStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FONT_STYLE);
        if (style != null) {
            FontDescriptor fontDescriptor = FontDescriptor.createFrom((FontData)this.getFontData(style));
            Font newFont = this.getResourceManager().createFont(fontDescriptor);
            this.refreshLabelsFont(newFont);
            if (this.cachedFontDescriptor != null) {
                this.getResourceManager().destroyFont(this.cachedFontDescriptor);
            }
            this.cachedFontDescriptor = fontDescriptor;
        }
    }

    protected void refreshLabelsFont(Font font) {
        Label stereotypesLabel = ((IPapyrusNodeUMLElementFigure)this.getPrimaryShape()).getStereotypesLabel();
        if (stereotypesLabel != null) {
            stereotypesLabel.setFont(font);
        }
    }

    protected FontData getFontData(FontStyle style) {
        return new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0));
    }

    @Override
    protected void setFontColor(Color color) {
        super.setFontColor(color);
        Label stereotypesLabel = ((IPapyrusNodeUMLElementFigure)this.getPrimaryShape()).getStereotypesLabel();
        if (stereotypesLabel != null) {
            stereotypesLabel.setForegroundColor(color);
        }
    }
}

