/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.ConnectionEditPart;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.editparts.IEditpartListenerAccess;
import org.eclipse.papyrus.uml.diagram.common.editparts.IUMLEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ApplyStereotypeEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.edge.UMLEdgeFigure;
import org.eclipse.papyrus.uml.diagram.common.service.ApplyStereotypeRequest;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public abstract class UMLConnectionNodeEditPart
extends ConnectionEditPart
implements IUMLEditPart,
IEditpartListenerAccess {
    public UMLConnectionNodeEditPart(View view) {
        super(view);
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        Element element = this.getUMLElement();
        if (element == null) {
            return;
        }
        this.addListenerFilter("StereotypableElement", (NotificationListener)this, this.resolveSemanticElement());
        for (EObject stereotypeApplication : element.getStereotypeApplications()) {
            this.addListenerFilter("StereotypedElement", (NotificationListener)this, stereotypeApplication);
        }
    }

    @Override
    public final Iterator getEventListenerIterator(Class clazz) {
        return this.getEventListeners(clazz);
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        int eventType = event.getEventType();
        if (eventType == 20) {
            this.addListenerFilter("StereotypedElement", (NotificationListener)this, (EObject)event.getNewValue());
        }
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy(ApplyStereotypeRequest.APPLY_STEREOTYPE_REQUEST, (EditPolicy)new ApplyStereotypeEditPolicy());
        this.installEditPolicy("ConnectionLabelsPolicy", (EditPolicy)new ShowHideLabelEditPolicy());
    }

    public EditPart getTargetEditPart(Request request) {
        if (ApplyStereotypeRequest.APPLY_STEREOTYPE_REQUEST.equals(request.getType())) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    public abstract UMLEdgeFigure getPrimaryShape();

    public void refreshAppliedStereotypes() {
        String stereotypesToDisplay = this.stereotypesToDisplay();
        Image imageToDisplay = this.stereotypeIconToDisplay();
        if (stereotypesToDisplay != "" || imageToDisplay != null) {
            this.getPrimaryShape().setStereotypeDisplay(stereotypesToDisplay, imageToDisplay);
        }
    }

    protected void removeSemanticListeners() {
        super.removeSemanticListeners();
        this.removeListenerFilter("StereotypableElement");
        this.removeListenerFilter("StereotypedElement");
    }

    @Override
    public Element getUMLElement() {
        return (Element)this.resolveSemanticElement();
    }

    public String stereotypesToDisplay() {
        String stereotypesToDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)((View)this.getModel()));
        String stereotypespresentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)((View)this.getModel()));
        if ("IconStereotype".equals(stereotypespresentationKind)) {
            return "";
        }
        String stereotypesToDisplayWithQN = AppliedStereotypeHelper.getStereotypesQNToDisplay((EModelElement)((View)this.getModel()));
        if ("VerticalStereo".equals(stereotypespresentationKind)) {
            return this.stereotypesToDisplay(String.valueOf(Activator.ST_RIGHT) + "\n" + Activator.ST_LEFT, stereotypesToDisplay, stereotypesToDisplayWithQN);
        }
        return this.stereotypesToDisplay(", ", stereotypesToDisplay, stereotypesToDisplayWithQN);
    }

    public Image stereotypeIconToDisplay() {
        String stereotypesToDisplay;
        StringTokenizer tokenizer;
        String stereotypespresentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)((View)this.getModel()));
        if (stereotypespresentationKind == null) {
            return null;
        }
        if ((stereotypespresentationKind.equals("IconStereotype") || stereotypespresentationKind.equals("TextIconStereotype")) && (tokenizer = new StringTokenizer(stereotypesToDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)((View)this.getModel())), ",")).hasMoreTokens()) {
            String firstStereotypeName = tokenizer.nextToken();
            Stereotype stereotype = this.getUMLElement().getAppliedStereotype(firstStereotypeName);
            return Activator.getIconElement(this.getUMLElement(), stereotype, false);
        }
        return null;
    }

    public String stereotypesToDisplay(String separator, String stereotypesToDisplay, String stereotypeWithQualifiedName) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        assert (store != null) : "The preference store was not found";
        if (store == null) {
            return "";
        }
        String sNameAppearance = store.getString("ProfileApplicationPreferenceConstants.stereotype.name.appearance");
        StringTokenizer strQualifiedName = new StringTokenizer(stereotypesToDisplay, ",");
        String out = "";
        while (strQualifiedName.hasMoreElements()) {
            String currentStereotype = strQualifiedName.nextToken();
            Element umlElement = this.getUMLElement();
            Stereotype stereotype = umlElement.getAppliedStereotype(currentStereotype);
            if (stereotype == null) continue;
            String name = currentStereotype;
            if (stereotypeWithQualifiedName.indexOf(currentStereotype) == -1) {
                StringTokenizer strToken = new StringTokenizer(currentStereotype, "::");
                while (strToken.hasMoreTokens()) {
                    name = strToken.nextToken();
                }
            }
            if (sNameAppearance.equals("User Controlled")) {
                if (out.indexOf(name) != -1) continue;
                out = String.valueOf(out) + name + separator;
                continue;
            }
            if (out.indexOf(name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1, name.length())) != -1) continue;
            out = String.valueOf(out) + name + separator;
        }
        if (out.endsWith(",")) {
            out = out.substring(0, out.length() - 1);
        }
        if (out.endsWith(separator)) {
            out = out.substring(0, out.length() - separator.length());
        }
        if (out != "") {
            out = String.valueOf(Activator.ST_LEFT) + out + Activator.ST_RIGHT;
        }
        return out;
    }

    protected void setLineWidth(int width) {
        if (width < 0) {
            width = 1;
        }
        this.getPrimaryShape().setLineWidth(width);
    }
}

