/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.RefreshConnectionsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.commands.AddEObjectReferencesToDiagram;
import org.eclipse.papyrus.uml.diagram.common.commands.UpdateDiagramCommand;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ViewResolver;
import org.eclipse.papyrus.uml.diagram.common.util.MDTUtil;

public class DragDropEditPolicy
extends org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy {
    private ViewResolver viewResolver = null;

    public DragDropEditPolicy(ViewResolver resolver) {
        this.viewResolver = resolver;
    }

    protected ViewResolver getViewResolver() {
        return this.viewResolver;
    }

    public IGraphicalEditPart getGraphicalHost() {
        if (this.getHost() instanceof IGraphicalEditPart) {
            return (IGraphicalEditPart)this.getHost();
        }
        return null;
    }

    protected Command getDropCommand(ChangeBoundsRequest request) {
        if (request.getType() != null && request.getType().equals("drop")) {
            for (Object o : request.getEditParts()) {
                EObject element = MDTUtil.resolveSemantic(o);
                if (this.getViewResolver().isEObjectNode(element)) continue;
                return UnexecutableCommand.INSTANCE;
            }
        }
        return super.getDropCommand(request);
    }

    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        List<EObject> nodeObjects = this.findNodesInDrop(dropRequest);
        List<CreateViewRequest.ViewDescriptor> viewDescriptors = this.createViewDescriptors(nodeObjects);
        List<EObject> edgeObjects = this.findEdgesInDrop(dropRequest);
        Command command = this.buildDropCommand(dropRequest, nodeObjects, viewDescriptors, edgeObjects);
        return command;
    }

    protected List<EObject> findNodesInDrop(DropObjectsRequest request) {
        ArrayList<EObject> nodes = new ArrayList<EObject>();
        for (Object object : request.getObjects()) {
            if (!(object instanceof EObject)) continue;
            EObject element = (EObject)object;
            if (!this.getViewResolver().isEObjectNode(element)) continue;
            nodes.add(element);
        }
        return nodes;
    }

    protected List<EObject> findEdgesInDrop(DropObjectsRequest request) {
        ArrayList<EObject> edges = new ArrayList<EObject>();
        for (Object object : request.getObjects()) {
            if (!(object instanceof EObject)) continue;
            EObject element = (EObject)object;
            if (!this.getViewResolver().isEObjectLink(element)) continue;
            edges.add(element);
        }
        return edges;
    }

    protected List<CreateViewRequest.ViewDescriptor> createViewDescriptors(List<EObject> elements) {
        ArrayList<CreateViewRequest.ViewDescriptor> viewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
        for (EObject element : elements) {
            int semanticHint = this.viewResolver.getEObjectSemanticHint(element);
            if (semanticHint <= -1) continue;
            CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(element), Node.class, String.valueOf(semanticHint), this.getGraphicalHost().getDiagramPreferencesHint());
            viewDescriptors.add(viewDescriptor);
        }
        return viewDescriptors;
    }

    protected Command buildDropCommand(DropObjectsRequest request, List<EObject> nodes, List<CreateViewRequest.ViewDescriptor> views, List<EObject> edges) {
        Command command = this.buildAddEObjectsReferencesCommand(nodes);
        Command edgesCommand = this.buildAddEObjectsReferencesCommand(edges);
        Command command2 = command = command == null ? edgesCommand : command.chain(edgesCommand);
        if (command == null) {
            return null;
        }
        Command viewsCommand = this.createViewsAndArrangeCommand(request, views);
        if (viewsCommand != null && viewsCommand.canExecute()) {
            command = command.chain(viewsCommand);
        }
        command = command.chain((Command)new UpdateDiagramCommand(this.getGraphicalHost()));
        return command;
    }

    protected Command buildAddEObjectsReferencesCommand(List<EObject> elements) {
        if (elements != null && elements.size() > 0) {
            TransactionalEditingDomain domain = this.getGraphicalHost().getEditingDomain();
            View view = this.getGraphicalHost().getNotationView();
            if (view != null) {
                return new ICommandProxy((ICommand)new AddEObjectReferencesToDiagram(domain, view.getDiagram(), elements));
            }
        }
        return null;
    }

    protected Command createViewsAndArrangeCommand(DropObjectsRequest dropRequest, List viewDescriptors) {
        CreateViewRequest createViewRequest = new CreateViewRequest(viewDescriptors);
        createViewRequest.setLocation(dropRequest.getLocation());
        Command createCommand = this.getHost().getCommand((Request)createViewRequest);
        if (createCommand != null) {
            List result = (List)createViewRequest.getNewObject();
            dropRequest.setResult((Object)result);
            RefreshConnectionsRequest refreshRequest = new RefreshConnectionsRequest(result);
            Command refreshCommand = this.getHost().getCommand((Request)refreshRequest);
            ArrangeRequest arrangeRequest = new ArrangeRequest("arrange_deferred");
            arrangeRequest.setViewAdaptersToArrange(result);
            Command arrangeCommand = this.getHost().getCommand((Request)arrangeRequest);
            CompoundCommand cc = new CompoundCommand(createCommand.getLabel());
            cc.add(createCommand.chain(refreshCommand));
            cc.add(arrangeCommand);
            return cc;
        }
        return null;
    }
}

