/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.common.figure.node.RectangularShadowBorder;
import org.eclipse.swt.graphics.Color;

public class RoundedRectangleDashedShadowBorder
extends RectangularShadowBorder {
    protected int cornerWidth;
    protected int cornerHeight;

    public RoundedRectangleDashedShadowBorder(int borderwidth, Color color, int arcWidth, int arcHeight) {
        super(borderwidth, color);
        this.cornerWidth = arcWidth;
        this.cornerHeight = arcHeight;
        this.setWidth(1);
    }

    @Override
    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        graphics.setLineStyle(2);
        graphics.pushState();
        tempRect.setBounds(RoundedRectangleDashedShadowBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        if (this.getWidth() % 2 == 1) {
            --RoundedRectangleDashedShadowBorder.tempRect.width;
            --RoundedRectangleDashedShadowBorder.tempRect.height;
        }
        tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
        graphics.setLineWidth(this.getWidth());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        graphics.drawRoundRectangle(tempRect, this.cornerWidth, this.cornerHeight);
        Rectangle newRect = new Rectangle(tempRect);
        newRect.width += this.borderwidth;
        newRect.height += this.borderwidth;
        graphics.setClip(newRect);
        PointList plt = new PointList();
        plt.addPoint(RoundedRectangleDashedShadowBorder.tempRect.x + RoundedRectangleDashedShadowBorder.tempRect.width, RoundedRectangleDashedShadowBorder.tempRect.y + this.cornerHeight / 2);
        plt.addPoint(RoundedRectangleDashedShadowBorder.tempRect.x + RoundedRectangleDashedShadowBorder.tempRect.width, RoundedRectangleDashedShadowBorder.tempRect.y + RoundedRectangleDashedShadowBorder.tempRect.height - this.cornerHeight / 2);
        plt.addPoint(RoundedRectangleDashedShadowBorder.tempRect.x + RoundedRectangleDashedShadowBorder.tempRect.width - this.cornerWidth / 2, RoundedRectangleDashedShadowBorder.tempRect.y + RoundedRectangleDashedShadowBorder.tempRect.height);
        plt.addPoint(RoundedRectangleDashedShadowBorder.tempRect.x + this.cornerWidth / 2, RoundedRectangleDashedShadowBorder.tempRect.y + RoundedRectangleDashedShadowBorder.tempRect.height);
        plt.addPoint(RoundedRectangleDashedShadowBorder.tempRect.x + this.cornerWidth, RoundedRectangleDashedShadowBorder.tempRect.y + RoundedRectangleDashedShadowBorder.tempRect.height + this.borderwidth);
        plt.addPoint(RoundedRectangleDashedShadowBorder.tempRect.x + RoundedRectangleDashedShadowBorder.tempRect.width, RoundedRectangleDashedShadowBorder.tempRect.y + RoundedRectangleDashedShadowBorder.tempRect.height + this.borderwidth);
        plt.addPoint(RoundedRectangleDashedShadowBorder.tempRect.x + RoundedRectangleDashedShadowBorder.tempRect.width + this.borderwidth, RoundedRectangleDashedShadowBorder.tempRect.y + RoundedRectangleDashedShadowBorder.tempRect.height);
        plt.addPoint(RoundedRectangleDashedShadowBorder.tempRect.x + RoundedRectangleDashedShadowBorder.tempRect.width + this.borderwidth, RoundedRectangleDashedShadowBorder.tempRect.y + this.cornerHeight);
        plt.addPoint(RoundedRectangleDashedShadowBorder.tempRect.x + RoundedRectangleDashedShadowBorder.tempRect.width, RoundedRectangleDashedShadowBorder.tempRect.y + this.cornerHeight / 2);
        if (this.getColor() != null) {
            graphics.setBackgroundColor(this.getColor());
        } else {
            graphics.setBackgroundColor(ColorConstants.black);
        }
        graphics.fillPolygon(plt);
        graphics.popState();
    }
}

