/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.layout;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.papyrus.uml.diagram.common.layout.EditPartTree;
import org.eclipse.papyrus.uml.diagram.common.layout.LayoutUtils;

public class AlignmentTree
extends EditPartTree {
    private static final long serialVersionUID = 3095221342551975246L;
    private PrecisionRectangle newPosition = null;

    public AlignmentTree(Object editpart, boolean isSelected) {
        super(editpart, isSelected);
    }

    public AlignmentTree(List<EditPart> editparts) {
        super(editparts);
    }

    public PrecisionRectangle getNewPosition() {
        return this.newPosition;
    }

    public PrecisionRectangle getNewContainerBounds() {
        PrecisionRectangle newContainerBounds;
        AlignmentTree treeParent = (AlignmentTree)this.getParent();
        if (treeParent.getEditPart() != null) {
            Point oldParentLocation = LayoutUtils.getAbsolutePosition(treeParent.getEditPart()).getLocation();
            Point newParentLocation = treeParent.getNewPosition().getLocation();
            Point shift = newParentLocation.getTranslated(oldParentLocation.getNegated());
            PrecisionRectangle oldContainerBounds = LayoutUtils.getAbsolutePosition(this.getEditPart().getParent());
            newContainerBounds = new PrecisionRectangle((Rectangle)oldContainerBounds);
            newContainerBounds.translate(shift);
        } else {
            EditPart containerEditPart = this.getEditPart().getParent();
            newContainerBounds = LayoutUtils.getAbsolutePosition(containerEditPart);
        }
        return newContainerBounds;
    }

    public PrecisionRectangle getAbsolutePositionInTheNewContainerPosition() {
        PrecisionRectangle newPosition = new PrecisionRectangle((Rectangle)LayoutUtils.getAbsolutePosition(this.getEditPart()));
        PrecisionRectangle newContainerPosition = this.getNewContainerBounds();
        PrecisionRectangle oldContainerPosition = LayoutUtils.getAbsolutePosition(this.getEditPart().getParent());
        PrecisionRectangle distance = (PrecisionRectangle)newContainerPosition.translate(oldContainerPosition.getLocation().getNegated());
        return (PrecisionRectangle)newPosition.translate(distance.getLocation());
    }

    public void setNewPosition(PrecisionRectangle newPosition) {
        this.newPosition = newPosition;
    }

    @Override
    protected EditPartTree createChildrenTree(List<EditPart> editparts, List<EditPart> parentsList) {
        AlignmentTree childTree = null;
        for (EditPart editpart : parentsList) {
            if (!editparts.contains(editpart) && (editparts.contains(editpart) || !ToolUtilities.isAncestorContainedIn(editparts, (EditPart)editpart))) continue;
            boolean isSelected = editparts.contains(editpart);
            AlignmentTree parentTree = new AlignmentTree(editpart, isSelected);
            if (!isSelected) {
                parentTree.setNewPosition(LayoutUtils.getAbsolutePosition(editpart));
            }
            if (childTree != null) {
                parentTree.add(childTree);
            }
            childTree = parentTree;
        }
        return childTree;
    }

    @Override
    protected void postBuildOperations(List<EditPart> editparts) {
        ((AlignmentTree)this.getTree(editparts.get(editparts.size() - 1))).setNewPosition(LayoutUtils.getAbsolutePosition(editparts.get(editparts.size() - 1)));
    }
}

