/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.custom.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.component.custom.messages.Messages;
import org.eclipse.papyrus.uml.diagram.component.custom.ui.NewElementRepresentation;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateUmlElementDialog
extends ElementTreeSelectionDialog {
    private IHintedType hintedType;
    private Object parentContainer;
    private String type;
    private Package pack;
    private Text text;
    private TransactionalEditingDomain domain;
    private NewElementRepresentation elementToCreate;
    private List<String> forbiddenNames;

    public CreateUmlElementDialog(Shell parent, TransactionalEditingDomain domain, ILabelProvider labelProvider, ITreeContentProvider contentProvider, Package pack, IHintedType hintedType) {
        super(parent, labelProvider, contentProvider);
        Assert.isNotNull((Object)pack);
        Assert.isNotNull((Object)hintedType);
        this.pack = pack;
        this.hintedType = hintedType;
        this.domain = domain;
        this.init();
    }

    protected void init() {
        EClass eClass = this.hintedType.getEClass();
        this.type = eClass.getName();
        this.parentContainer = null;
        this.forbiddenNames = null;
    }

    public void setForbiddenNames(List<String> forbiddenNames) {
        this.forbiddenNames = forbiddenNames;
    }

    protected Control createDialogArea(Composite parent) {
        GridData data = (GridData)parent.getLayoutData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        GridData dat = new GridData(1808);
        composite.setLayoutData((Object)dat);
        this.createNameSection(parent);
        return composite;
    }

    protected void createNameSection(Composite parent) {
        Composite nameSection = new Composite(parent, 0);
        Label label = new Label(nameSection, 0);
        label.setText(Messages.CreateUmlElementDialog_New_Element_Name);
        this.text = new Text(nameSection, 2048);
        this.text.setText(this.getDefaultName());
        GridData textData = new GridData(768);
        this.text.setLayoutData((Object)textData);
        GridLayout layout = new GridLayout(2, false);
        GridData data = new GridData(1808);
        nameSection.setLayout((Layout)layout);
        nameSection.setLayoutData((Object)data);
        nameSection.moveAbove(null);
    }

    protected String getDefaultName() {
        String defaultName;
        boolean existsInterface = false;
        int max = 0;
        do {
            List allInterface = ElementUtil.getInstancesFilteredByType((Package)this.pack, Interface.class, null);
            for (Object object : allInterface) {
                String name = NamedElementUtil.getName((NamedElement)((NamedElement)object));
                if (name == null || !name.startsWith(this.type)) continue;
                name = name.substring(this.type.length());
                Integer val = null;
                try {
                    val = Integer.parseInt(name);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (val == null) continue;
                max = Math.max(val, max);
                existsInterface = true;
            }
            defaultName = existsInterface ? String.valueOf(this.type) + new Integer(max + 1).toString() : String.valueOf(this.type) + new Integer(max).toString();
            ++max;
        } while (!this.isCorrectName(defaultName));
        return defaultName;
    }

    protected boolean isCorrectName(String name) {
        if (this.forbiddenNames == null) {
            return true;
        }
        return !this.forbiddenNames.contains(name);
    }

    public Command getCommand() {
        CompositeCommand cmd = new CompositeCommand("Create new element command");
        if (this.elementToCreate.getCreateElementRequest() != null) {
            ICommand command = this.getCommand((IEditCommandRequest)this.elementToCreate.getCreateElementRequest());
            if (command.canExecute()) {
                cmd.add((IUndoableOperation)command);
                SetNameCommand nameCommand = new SetNameCommand(this.domain, "Set Name Command", null, null, this.elementToCreate);
                if (nameCommand.canExecute()) {
                    cmd.add((IUndoableOperation)nameCommand);
                }
            }
            return new ICommandProxy((ICommand)cmd);
        }
        return new ICommandProxy((ICommand)new CustomCreateElementCommand(this.domain, "CustomCreateElementCommand", null, this.elementToCreate));
    }

    protected void computeResult() {
        ArrayList<NewElementRepresentation> result = new ArrayList<NewElementRepresentation>();
        result.add(this.elementToCreate);
        this.setResult(result);
    }

    protected void okPressed() {
        ISelection selection = this.getTreeViewer().getSelection();
        this.parentContainer = ((IStructuredSelection)selection).getFirstElement();
        CreateElementRequest request = null;
        if (this.parentContainer instanceof EObject) {
            request = new CreateElementRequest(this.domain, (EObject)this.parentContainer, (IElementType)this.hintedType);
        }
        this.elementToCreate = new NewElementRepresentation(this.text.getText(), this.parentContainer, this.hintedType, request);
        super.okPressed();
    }

    private ICommand getCommand(IEditCommandRequest request) {
        ICommand cmd;
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)UMLPackage.eINSTANCE.getNamedElement());
        if (provider != null && (cmd = provider.getEditCommand(request)) != null && cmd.canExecute()) {
            return cmd;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public class CustomCreateElementCommand
    extends AbstractTransactionalCommand {
        private NewElementRepresentation elementToCreate;

        public CustomCreateElementCommand(TransactionalEditingDomain domain, String label, List<?> affectedFiles, NewElementRepresentation elementToCreate) {
            super(domain, label, affectedFiles);
            this.elementToCreate = elementToCreate;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            EObject container = this.elementToCreate.getEObjectParent();
            CreateElementRequest request = new CreateElementRequest(CreateUmlElementDialog.this.domain, container, (IElementType)CreateUmlElementDialog.this.hintedType);
            ICommand command = CreateUmlElementDialog.this.getCommand((IEditCommandRequest)request);
            command.execute((IProgressMonitor)new NullProgressMonitor(), null);
            EObject newEl = request.getNewElement();
            if (newEl instanceof NamedElement) {
                ((NamedElement)newEl).setName(this.elementToCreate.getName());
            }
            this.elementToCreate.setCreateElement(request.getNewElement());
            return CommandResult.newOKCommandResult((Object)this.elementToCreate);
        }
    }

    public class SetNameCommand
    extends AbstractTransactionalCommand {
        private NewElementRepresentation representation;

        public SetNameCommand(TransactionalEditingDomain domain, String label, List<?> affectedFiles, CreateElementRequest previousRequest, NewElementRepresentation representation) {
            super(domain, label, affectedFiles);
            this.representation = representation;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.representation.getEObject() instanceof NamedElement) {
                NamedElement el = (NamedElement)this.representation.getEObject();
                el.setName(this.representation.getName());
            }
            return CommandResult.newOKCommandResult((Object)this.representation);
        }
    }
}

