/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.edit.policies;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.GMFUnsafe;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.composite.custom.edit.command.CreateBehaviorPortCommand;
import org.eclipse.papyrus.uml.diagram.composite.custom.locators.BehaviorPortLocator;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.UMLPackage;

public class BehaviorPortEditPolicy
extends GraphicalEditPolicy
implements NotificationListener,
IPapyrusListener {
    public static String BEHAVIOR_PORT = "BehaviorPortPolicy";
    private Port hostSemanticElement;

    public void notifyChanged(Notification notification) {
        if (UMLPackage.eINSTANCE.getPort_IsBehavior().equals(notification.getFeature())) {
            this.udaptePortBehavior();
        }
    }

    protected void udaptePortBehavior() {
        ShapeCompartmentEditPart targetEditPart = this.getPossibleCompartment(((GraphicalEditPart)this.getHost()).getParent());
        if (targetEditPart != null) {
            Node behaviorPort = this.getBehaviorPortNode();
            if (this.hostSemanticElement.isBehavior() && behaviorPort == null) {
                BehaviorPortLocator locator = new BehaviorPortLocator(((GraphicalEditPart)this.getHost().getParent()).getFigure(), 0);
                locator.setBorderItemOffset(60);
                Rectangle rectBehavior = locator.getPreferredLocation(((GraphicalEditPart)this.getHost()).getFigure().getBounds());
                Rectangle rectContainer = targetEditPart.getContentPane().getParent().getBounds();
                rectBehavior = rectBehavior.getTranslated(-rectContainer.x, -rectContainer.y);
                this.executeBehaviorPortCreation((EditPart)targetEditPart, (EditPart)((GraphicalEditPart)this.getHost()), ((GraphicalEditPart)this.getHost()).getEditingDomain(), rectBehavior);
            } else if (!this.hostSemanticElement.isBehavior()) {
                this.executeBehaviorPortDeletion(((GraphicalEditPart)this.getHost()).getEditingDomain(), (View)behaviorPort);
            }
        }
    }

    protected void executeBehaviorPortDeletion(TransactionalEditingDomain domain, View behaviorNode) {
        if (behaviorNode != null && TransactionUtil.getEditingDomain((EObject)behaviorNode) == domain) {
            DeleteCommand command = new DeleteCommand(behaviorNode);
            try {
                GMFUnsafe.write((TransactionalEditingDomain)domain, (ICommand)command);
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected Node getBehaviorPortNode() {
        View SemanticView = (View)this.getHost().getModel();
        Edge behaviorPortLink = null;
        for (Edge edge : SemanticView.getSourceEdges()) {
            if (!edge.getType().equals("4022")) continue;
            behaviorPortLink = edge;
        }
        if (behaviorPortLink == null) {
            return null;
        }
        return (Node)behaviorPortLink.getTarget();
    }

    protected ShapeCompartmentEditPart getPossibleCompartment(EditPart parent) {
        ShapeCompartmentEditPart found = null;
        int i = 0;
        while (found == null && i < parent.getChildren().size()) {
            if (parent.getChildren().get(i) instanceof ShapeCompartmentEditPart) {
                found = (ShapeCompartmentEditPart)parent.getChildren().get(i);
            }
            ++i;
        }
        return found;
    }

    protected void executeBehaviorPortCreation(EditPart editPart, EditPart port, TransactionalEditingDomain domain, Rectangle position) {
        CreateBehaviorPortCommand command = new CreateBehaviorPortCommand(domain, (View)editPart.getModel(), (View)port.getModel(), position);
        try {
            GMFUnsafe.write((TransactionalEditingDomain)domain, (Command)command);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void activate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.hostSemanticElement = this.getUMLElement();
        this.getDiagramEventBroker().addNotificationListener((EObject)view, (NotificationListener)this);
        if (this.hostSemanticElement == null) {
            return;
        }
        this.getDiagramEventBroker().addNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
        this.udaptePortBehavior();
    }

    public void deactivate() {
        super.deactivate();
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    protected Port getUMLElement() {
        EObject element = this.getView().getElement();
        if (element instanceof Port) {
            return (Port)element;
        }
        return null;
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }
}

