/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.edit.policies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.extendedtypes.types.IExtendedHintedElementType;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.composite.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.composite.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.composite.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InformationFlow;
import org.eclipse.uml2.uml.InformationItem;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Manifestation;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.UseCase;

public class UMLBaseItemSemanticEditPolicy
extends SemanticEditPolicy {
    public static final String VISUAL_ID_KEY = "visual_id";
    public static final String GRAPHICAL_RECONNECTED_EDGE = "graphical_edge";
    private final IElementType myElementType;

    protected UMLBaseItemSemanticEditPolicy(IElementType elementType) {
        this.myElementType = elementType;
    }

    public Command getCommand(Request request) {
        Object view;
        if (request instanceof ReconnectRequest && (view = ((ReconnectRequest)request).getConnectionEditPart().getModel()) instanceof View) {
            Integer id = new Integer(UMLVisualIDRegistry.getVisualID((View)view));
            request.getExtendedData().put(VISUAL_ID_KEY, id);
            request.getExtendedData().put(GRAPHICAL_RECONNECTED_EDGE, (View)view);
        }
        return super.getCommand(request);
    }

    protected int getVisualID(IEditCommandRequest request) {
        Object id = request.getParameter(VISUAL_ID_KEY);
        return id instanceof Integer ? (Integer)id : -1;
    }

    protected Command getSemanticCommand(IEditCommandRequest request) {
        IEditCommandRequest completedRequest = this.completeRequest(request);
        Command semanticCommand = this.getSemanticCommandSwitch(completedRequest);
        semanticCommand = this.getEditHelperCommand(completedRequest, semanticCommand);
        if (completedRequest instanceof DestroyRequest) {
            DestroyRequest destroyRequest = (DestroyRequest)completedRequest;
            return this.shouldProceed(destroyRequest) ? this.addDeleteViewCommand(semanticCommand, destroyRequest) : null;
        }
        return semanticCommand;
    }

    protected Command addDeleteViewCommand(Command mainCommand, DestroyRequest completedRequest) {
        Command deleteViewCommand = this.getGEFWrapper((ICommand)new DeleteCommand(this.getEditingDomain(), (View)this.getHost().getModel()));
        return mainCommand == null ? deleteViewCommand : mainCommand.chain(deleteViewCommand);
    }

    private Command getEditHelperCommand(IEditCommandRequest request, Command editPolicyCommand) {
        if (editPolicyCommand != null) {
            CommandProxy command = editPolicyCommand instanceof ICommandProxy ? ((ICommandProxy)editPolicyCommand).getICommand() : new CommandProxy(editPolicyCommand);
            request.setParameter("edit policy command", (Object)command);
        }
        IElementType requestContextElementType = this.getContextElementType(request);
        request.setParameter("context element type", (Object)requestContextElementType);
        ICommand command = requestContextElementType.getEditCommand(request);
        request.setParameter("edit policy command", null);
        request.setParameter("context element type", null);
        if (command != null) {
            if (!(command instanceof CompositeTransactionalCommand)) {
                command = new CompositeTransactionalCommand(this.getEditingDomain(), command.getLabel()).compose((IUndoableOperation)command);
            }
            return new ICommandProxy(command);
        }
        return editPolicyCommand;
    }

    protected IElementType getContextElementType(IEditCommandRequest request) {
        IElementType requestContextElementType = UMLElementTypes.getElementType(this.getVisualID(request));
        return requestContextElementType != null ? requestContextElementType : this.myElementType;
    }

    protected Command getSemanticCommandSwitch(IEditCommandRequest req) {
        if (req instanceof CreateRelationshipRequest) {
            return this.getCreateRelationshipCommand((CreateRelationshipRequest)req);
        }
        if (req instanceof CreateElementRequest) {
            return this.getCreateCommand((CreateElementRequest)req);
        }
        if (req instanceof ConfigureRequest) {
            return this.getConfigureCommand((ConfigureRequest)req);
        }
        if (req instanceof DestroyElementRequest) {
            return this.getDestroyElementCommand((DestroyElementRequest)req);
        }
        if (req instanceof DestroyReferenceRequest) {
            return this.getDestroyReferenceCommand((DestroyReferenceRequest)req);
        }
        if (req instanceof DuplicateElementsRequest) {
            return this.getDuplicateCommand((DuplicateElementsRequest)req);
        }
        if (req instanceof GetEditContextRequest) {
            return this.getEditContextCommand((GetEditContextRequest)req);
        }
        if (req instanceof MoveRequest) {
            return this.getMoveCommand((MoveRequest)req);
        }
        if (req instanceof ReorientReferenceRelationshipRequest) {
            return this.getReorientReferenceRelationshipCommand((ReorientReferenceRelationshipRequest)req);
        }
        if (req instanceof ReorientRelationshipRequest) {
            return this.getReorientRelationshipCommand((ReorientRelationshipRequest)req);
        }
        if (req instanceof SetRequest) {
            return this.getSetCommand((SetRequest)req);
        }
        return null;
    }

    protected Command getConfigureCommand(ConfigureRequest req) {
        return null;
    }

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        return null;
    }

    protected Command getCreateCommand(CreateElementRequest req) {
        ICommand command;
        IElementEditService commandProvider;
        IElementType requestElementType = req.getElementType();
        if (requestElementType instanceof IExtendedHintedElementType && (commandProvider = ElementEditServiceUtils.getCommandProvider((Object)req.getContainer())) != null && (command = commandProvider.getEditCommand((IEditCommandRequest)req)) != null && command.canExecute()) {
            return new ICommandProxy(command);
        }
        return null;
    }

    protected Command getExtendedTypeCreationCommand(CreateElementRequest request, IExtendedHintedElementType requestElementType) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)request.getContainer());
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
        return this.getGEFWrapper(createGMFCommand);
    }

    protected Command getExtendedStartCreateRelationshipCommand(CreateElementRequest request, IExtendedHintedElementType requestElementType) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)requestElementType);
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
        return this.getGEFWrapper(createGMFCommand);
    }

    protected Command getExtendedCompleteCreateRelationshipCommand(CreateElementRequest request, IExtendedHintedElementType requestElementType) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)requestElementType);
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
        return this.getGEFWrapper(createGMFCommand);
    }

    protected Command getSetCommand(SetRequest req) {
        return null;
    }

    protected Command getEditContextCommand(GetEditContextRequest req) {
        return null;
    }

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        return null;
    }

    protected Command getDestroyReferenceCommand(DestroyReferenceRequest req) {
        return null;
    }

    protected Command getDuplicateCommand(DuplicateElementsRequest req) {
        return null;
    }

    protected Command getMoveCommand(MoveRequest req) {
        EObject targetCEObject = req.getTargetContainer();
        if (targetCEObject != null) {
            ICommand moveCommand;
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)targetCEObject);
            if (provider != null && (moveCommand = provider.getEditCommand((IEditCommandRequest)req)) != null) {
                return new ICommandProxy(moveCommand);
            }
            return UnexecutableCommand.INSTANCE;
        }
        return this.getGEFWrapper((ICommand)new MoveElementsCommand(req));
    }

    protected Command getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected final Command getGEFWrapper(ICommand cmd) {
        return new ICommandProxy(cmd);
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected void addDestroyShortcutsCommand(ICompositeCommand cmd, View view) {
        assert (view.getEAnnotation("Shortcut") == null);
        for (View nextView : view.getDiagram().getChildren()) {
            if (nextView.getEAnnotation("Shortcut") == null || !nextView.isSetElement() || nextView.getElement() != view.getElement()) continue;
            cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), nextView));
        }
    }

    public static LinkConstraints getLinkConstraints() {
        LinkConstraints cached = UMLDiagramEditorPlugin.getInstance().getLinkConstraints();
        if (cached == null) {
            cached = new LinkConstraints();
            UMLDiagramEditorPlugin.getInstance().setLinkConstraints(cached);
        }
        return cached;
    }

    public static class LinkConstraints {
        public boolean canCreateLink_4022() {
            return this.canExistLink_4022();
        }

        public boolean canCreateLink_4001() {
            return this.canExistLink_4001();
        }

        public boolean canCreateCommentAnnotatedElement_4002(Comment source, Element target) {
            if (source != null && source.getAnnotatedElements().contains((Object)target)) {
                return false;
            }
            return this.canExistCommentAnnotatedElement_4002(source, target);
        }

        public boolean canCreateConstraintConstrainedElement_4003(Constraint source, Element target) {
            if (source != null && source.getConstrainedElements().contains((Object)target)) {
                return false;
            }
            return this.canExistConstraintConstrainedElement_4003(source, target);
        }

        public boolean canCreateComponentRealization_4004(Package container, NamedElement source, NamedElement target) {
            return this.canExistComponentRealization_4004(container, null, source, target);
        }

        public boolean canCreateInterfaceRealization_4005(Package container, NamedElement source, NamedElement target) {
            return this.canExistInterfaceRealization_4005(container, null, source, target);
        }

        public boolean canCreateSubstitution_4011(Package container, NamedElement source, NamedElement target) {
            return this.canExistSubstitution_4011(container, null, source, target);
        }

        public boolean canCreateRealization_4006(Package container, NamedElement source, NamedElement target) {
            return this.canExistRealization_4006(container, null, source, target);
        }

        public boolean canCreateManifestation_4012(Package container, NamedElement source, NamedElement target) {
            return this.canExistManifestation_4012(container, null, source, target);
        }

        public boolean canCreateAbstraction_4007(Package container, NamedElement source, NamedElement target) {
            return this.canExistAbstraction_4007(container, null, source, target);
        }

        public boolean canCreateUsage_4008(Package container, NamedElement source, NamedElement target) {
            return this.canExistUsage_4008(container, null, source, target);
        }

        public boolean canCreateDeployment_4009(Package container, NamedElement source, NamedElement target) {
            return this.canExistDeployment_4009(container, null, source, target);
        }

        public boolean canCreateDependency_4017(Package container, NamedElement source, NamedElement target) {
            return this.canExistDependency_4017(container, null, source, target);
        }

        public boolean canCreateDependency_4010(Package container, NamedElement source, NamedElement target) {
            return this.canExistDependency_4010(container, null, source, target);
        }

        public boolean canCreateConnector_4013(StructuredClassifier container, ConnectorEnd source, ConnectorEnd target) {
            return this.canExistConnector_4013(container, null, source, target);
        }

        public boolean canCreateGeneralization_4015(Classifier container, Classifier source, Classifier target) {
            return this.canExistGeneralization_4015(container, null, source, target);
        }

        public boolean canCreateTimeObservationEvent_4018(TimeObservation source, NamedElement target) {
            if (source != null && source.getEvent() != null) {
                return false;
            }
            return this.canExistTimeObservationEvent_4018(source, target);
        }

        public boolean canCreateDurationObservationEvent_4019(DurationObservation source, NamedElement target) {
            if (source != null && (source.getEvents().size() >= 2 || source.getEvents().contains((Object)target))) {
                return false;
            }
            return this.canExistDurationObservationEvent_4019(source, target);
        }

        public boolean canCreateInformationItemRepresented_4020(InformationItem source, Classifier target) {
            if (source != null && source.getRepresenteds().contains((Object)target)) {
                return false;
            }
            return this.canExistInformationItemRepresented_4020(source, target);
        }

        public boolean canCreateInformationFlow_4021(Package container, NamedElement source, NamedElement target) {
            return this.canExistInformationFlow_4021(container, null, source, target);
        }

        public boolean canExistLink_4022() {
            return true;
        }

        public boolean canExistLink_4001() {
            return true;
        }

        public boolean canExistCommentAnnotatedElement_4002(Comment source, Element target) {
            return true;
        }

        public boolean canExistConstraintConstrainedElement_4003(Constraint source, Element target) {
            return true;
        }

        public boolean canExistComponentRealization_4004(Package container, ComponentRealization linkInstance, NamedElement source, NamedElement target) {
            return true;
        }

        public boolean canExistInterfaceRealization_4005(Package container, InterfaceRealization linkInstance, NamedElement source, NamedElement target) {
            return true;
        }

        public boolean canExistSubstitution_4011(Package container, Substitution linkInstance, NamedElement source, NamedElement target) {
            return true;
        }

        public boolean canExistRealization_4006(Package container, Realization linkInstance, NamedElement source, NamedElement target) {
            return true;
        }

        public boolean canExistManifestation_4012(Package container, Manifestation linkInstance, NamedElement source, NamedElement target) {
            return true;
        }

        public boolean canExistAbstraction_4007(Package container, Abstraction linkInstance, NamedElement source, NamedElement target) {
            return true;
        }

        public boolean canExistUsage_4008(Package container, Usage linkInstance, NamedElement source, NamedElement target) {
            return true;
        }

        public boolean canExistDeployment_4009(Package container, Deployment linkInstance, NamedElement source, NamedElement target) {
            return true;
        }

        public boolean canExistDependency_4017(Package container, Dependency linkInstance, NamedElement source, NamedElement target) {
            block7: {
                block6: {
                    block5: {
                        try {
                            if (source == null || source instanceof CollaborationUse) break block5;
                            return false;
                        }
                        catch (Exception e) {
                            UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                            return false;
                        }
                    }
                    if (source == null || ((CollaborationUse)source).getType() != null) break block6;
                    return false;
                }
                if (target == null || target instanceof ConnectableElement) break block7;
                return false;
            }
            return source == null || target == null || source.getOwner() == target.getOwner();
        }

        public boolean canExistDependency_4010(Package container, Dependency linkInstance, NamedElement source, NamedElement target) {
            return true;
        }

        public boolean canExistConnector_4013(StructuredClassifier container, Connector linkInstance, ConnectorEnd source, ConnectorEnd target) {
            return true;
        }

        public boolean canExistGeneralization_4015(Classifier container, Generalization linkInstance, Classifier source, Classifier target) {
            return true;
        }

        public boolean canExistTimeObservationEvent_4018(TimeObservation source, NamedElement target) {
            return true;
        }

        public boolean canExistDurationObservationEvent_4019(DurationObservation source, NamedElement target) {
            return true;
        }

        public boolean canExistInformationItemRepresented_4020(InformationItem source, Classifier target) {
            try {
                return target == null || target instanceof Class || target instanceof Interface || target instanceof InformationItem || target instanceof Signal || target instanceof Component;
            }
            catch (Exception e) {
                UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean canExistInformationFlow_4021(Package container, InformationFlow linkInstance, NamedElement source, NamedElement target) {
            try {
                int i;
                EList classes;
                if (source != null) {
                    if (!(source instanceof Actor || source instanceof Node || source instanceof UseCase || source instanceof Artifact || source instanceof Class || source instanceof Component || source instanceof Port || source instanceof Property || source instanceof Interface || source instanceof Package || source instanceof ActivityNode || source instanceof ActivityPartition || source instanceof InstanceSpecification)) {
                        return false;
                    }
                    if (source instanceof InstanceSpecification) {
                        classes = ((InstanceSpecification)source).getClassifiers();
                        i = 0;
                        while (i < classes.size()) {
                            if (classes.get(i) instanceof Relationship) {
                                return false;
                            }
                            ++i;
                        }
                    }
                }
                if (target != null) {
                    if (!(target instanceof Actor || target instanceof Node || target instanceof UseCase || target instanceof Artifact || target instanceof Class || target instanceof Component || target instanceof Port || target instanceof Property || target instanceof Interface || target instanceof Package || target instanceof ActivityNode || target instanceof ActivityPartition || target instanceof InstanceSpecification)) {
                        return false;
                    }
                    if (target instanceof InstanceSpecification) {
                        classes = ((InstanceSpecification)target).getClassifiers();
                        i = 0;
                        while (i < classes.size()) {
                            if (classes.get(i) instanceof Relationship) {
                                return false;
                            }
                            ++i;
                        }
                    }
                }
                return true;
            }
            catch (Exception e) {
                UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                return false;
            }
        }
    }
}

