/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.css.dom;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.css.dom.GMFElementAdapter;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;

public class GMFUMLElementAdapter
extends GMFElementAdapter {
    public static final String APPLIED_STEREOTYPES_PROPERTY = "appliedStereotypes";
    public static final String QUALIFIER_SEPARATOR = "--";

    public GMFUMLElementAdapter(View view, ExtendedCSSEngine engine) {
        super(view, engine);
    }

    protected String doGetAttribute(String attr) {
        String parentValue = super.doGetAttribute(attr);
        if (parentValue != null) {
            return parentValue;
        }
        if (this.semanticElement instanceof Element) {
            Element currentElement = (Element)this.semanticElement;
            if (APPLIED_STEREOTYPES_PROPERTY.equals(attr)) {
                LinkedList<String> appliedStereotypes = new LinkedList<String>();
                for (Iterator stereotype : currentElement.getAppliedStereotypes()) {
                    appliedStereotypes.add(stereotype.getName());
                    appliedStereotypes.add(stereotype.getQualifiedName());
                }
                if (!appliedStereotypes.isEmpty()) {
                    return ListHelper.deepToString(appliedStereotypes, (String)" ");
                }
            }
            for (EObject stereotypeApplication : currentElement.getStereotypeApplications()) {
                EStructuralFeature feature = stereotypeApplication.eClass().getEStructuralFeature(attr);
                if (feature == null) continue;
                if (feature.isMany()) {
                    List values = (List)stereotypeApplication.eGet(feature);
                    LinkedList<String> cssValues = new LinkedList<String>();
                    for (Object value : values) {
                        cssValues.add(this.getCSSValue(feature, value));
                    }
                    return ListHelper.deepToString(cssValues, (String)" ");
                }
                Object value = stereotypeApplication.eGet(feature);
                String cssValue = this.getCSSValue(feature, value);
                return cssValue;
            }
            if (attr.contains(QUALIFIER_SEPARATOR)) {
                EObject stereotypeApplication;
                EStructuralFeature feature;
                List qualifiers = ListHelper.asList((Object[])attr.split(QUALIFIER_SEPARATOR));
                String propertyName = (String)qualifiers.remove(qualifiers.size() - 1);
                String stereotypeName = ListHelper.deepToString((List)qualifiers, (String)"::");
                Stereotype appliedStereotype = currentElement.getAppliedStereotype(stereotypeName);
                if (appliedStereotype != null && (feature = (stereotypeApplication = currentElement.getStereotypeApplication(appliedStereotype)).eClass().getEStructuralFeature(propertyName)) != null) {
                    Object value = stereotypeApplication.eGet(feature);
                    return this.getCSSValue(feature, value);
                }
            }
        }
        return null;
    }

    protected String getCSSValue(EStructuralFeature feature, Object value) {
        if (feature instanceof EReference && value instanceof NamedElement) {
            return ((NamedElement)value).getName();
        }
        return super.getCSSValue(feature, value);
    }
}

