/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.deployment.edit.policies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.extendedtypes.types.IExtendedHintedElementType;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.deployment.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.deployment.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.deployment.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.DeploymentTarget;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Manifestation;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;

public class UMLBaseItemSemanticEditPolicy
extends SemanticEditPolicy {
    public static final String VISUAL_ID_KEY = "visual_id";
    public static final String GRAPHICAL_RECONNECTED_EDGE = "graphical_edge";
    private final IElementType myElementType;

    protected UMLBaseItemSemanticEditPolicy(IElementType elementType) {
        this.myElementType = elementType;
    }

    public Command getCommand(Request request) {
        Object view;
        if (request instanceof ReconnectRequest && (view = ((ReconnectRequest)request).getConnectionEditPart().getModel()) instanceof View) {
            Integer id = new Integer(UMLVisualIDRegistry.getVisualID((View)view));
            request.getExtendedData().put(VISUAL_ID_KEY, id);
            request.getExtendedData().put(GRAPHICAL_RECONNECTED_EDGE, (View)view);
        }
        return super.getCommand(request);
    }

    protected int getVisualID(IEditCommandRequest request) {
        Object id = request.getParameter(VISUAL_ID_KEY);
        return id instanceof Integer ? (Integer)id : -1;
    }

    protected Command getSemanticCommand(IEditCommandRequest request) {
        IEditCommandRequest completedRequest = this.completeRequest(request);
        Command semanticCommand = this.getSemanticCommandSwitch(completedRequest);
        semanticCommand = this.getEditHelperCommand(completedRequest, semanticCommand);
        if (completedRequest instanceof DestroyRequest) {
            DestroyRequest destroyRequest = (DestroyRequest)completedRequest;
            return this.shouldProceed(destroyRequest) ? this.addDeleteViewCommand(semanticCommand, destroyRequest) : null;
        }
        return semanticCommand;
    }

    protected Command addDeleteViewCommand(Command mainCommand, DestroyRequest completedRequest) {
        Command deleteViewCommand = this.getGEFWrapper((ICommand)new DeleteCommand(this.getEditingDomain(), (View)this.getHost().getModel()));
        return mainCommand == null ? deleteViewCommand : mainCommand.chain(deleteViewCommand);
    }

    private Command getEditHelperCommand(IEditCommandRequest request, Command editPolicyCommand) {
        if (editPolicyCommand != null) {
            CommandProxy command = editPolicyCommand instanceof ICommandProxy ? ((ICommandProxy)editPolicyCommand).getICommand() : new CommandProxy(editPolicyCommand);
            request.setParameter("edit policy command", (Object)command);
        }
        IElementType requestContextElementType = this.getContextElementType(request);
        request.setParameter("context element type", (Object)requestContextElementType);
        ICommand command = requestContextElementType.getEditCommand(request);
        request.setParameter("edit policy command", null);
        request.setParameter("context element type", null);
        if (command != null) {
            if (!(command instanceof CompositeTransactionalCommand)) {
                command = new CompositeTransactionalCommand(this.getEditingDomain(), command.getLabel()).compose((IUndoableOperation)command);
            }
            return new ICommandProxy(command);
        }
        return editPolicyCommand;
    }

    protected IElementType getContextElementType(IEditCommandRequest request) {
        IElementType requestContextElementType = UMLElementTypes.getElementType(this.getVisualID(request));
        return requestContextElementType != null ? requestContextElementType : this.myElementType;
    }

    protected Command getSemanticCommandSwitch(IEditCommandRequest req) {
        if (req instanceof CreateRelationshipRequest) {
            return this.getCreateRelationshipCommand((CreateRelationshipRequest)req);
        }
        if (req instanceof CreateElementRequest) {
            return this.getCreateCommand((CreateElementRequest)req);
        }
        if (req instanceof ConfigureRequest) {
            return this.getConfigureCommand((ConfigureRequest)req);
        }
        if (req instanceof DestroyElementRequest) {
            return this.getDestroyElementCommand((DestroyElementRequest)req);
        }
        if (req instanceof DestroyReferenceRequest) {
            return this.getDestroyReferenceCommand((DestroyReferenceRequest)req);
        }
        if (req instanceof DuplicateElementsRequest) {
            return this.getDuplicateCommand((DuplicateElementsRequest)req);
        }
        if (req instanceof GetEditContextRequest) {
            return this.getEditContextCommand((GetEditContextRequest)req);
        }
        if (req instanceof MoveRequest) {
            return this.getMoveCommand((MoveRequest)req);
        }
        if (req instanceof ReorientReferenceRelationshipRequest) {
            return this.getReorientReferenceRelationshipCommand((ReorientReferenceRelationshipRequest)req);
        }
        if (req instanceof ReorientRelationshipRequest) {
            return this.getReorientRelationshipCommand((ReorientRelationshipRequest)req);
        }
        if (req instanceof SetRequest) {
            return this.getSetCommand((SetRequest)req);
        }
        return null;
    }

    protected Command getConfigureCommand(ConfigureRequest req) {
        return null;
    }

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        return null;
    }

    protected Command getCreateCommand(CreateElementRequest req) {
        ICommand command;
        IElementEditService commandProvider;
        IElementType requestElementType = req.getElementType();
        if (requestElementType instanceof IExtendedHintedElementType && (commandProvider = ElementEditServiceUtils.getCommandProvider((Object)req.getContainer())) != null && (command = commandProvider.getEditCommand((IEditCommandRequest)req)) != null && command.canExecute()) {
            return new ICommandProxy(command);
        }
        return null;
    }

    protected Command getExtendedTypeCreationCommand(CreateElementRequest request, IExtendedHintedElementType requestElementType) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)request.getContainer());
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
        return this.getGEFWrapper(createGMFCommand);
    }

    protected Command getExtendedStartCreateRelationshipCommand(CreateElementRequest request, IExtendedHintedElementType requestElementType) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)requestElementType);
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
        return this.getGEFWrapper(createGMFCommand);
    }

    protected Command getExtendedCompleteCreateRelationshipCommand(CreateElementRequest request, IExtendedHintedElementType requestElementType) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)requestElementType);
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
        return this.getGEFWrapper(createGMFCommand);
    }

    protected Command getSetCommand(SetRequest req) {
        return null;
    }

    protected Command getEditContextCommand(GetEditContextRequest req) {
        return null;
    }

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        return null;
    }

    protected Command getDestroyReferenceCommand(DestroyReferenceRequest req) {
        return null;
    }

    protected Command getDuplicateCommand(DuplicateElementsRequest req) {
        return null;
    }

    protected Command getMoveCommand(MoveRequest req) {
        EObject targetCEObject = req.getTargetContainer();
        if (targetCEObject != null) {
            ICommand moveCommand;
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)targetCEObject);
            if (provider != null && (moveCommand = provider.getEditCommand((IEditCommandRequest)req)) != null) {
                return new ICommandProxy(moveCommand);
            }
            return UnexecutableCommand.INSTANCE;
        }
        return this.getGEFWrapper((ICommand)new MoveElementsCommand(req));
    }

    protected Command getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected final Command getGEFWrapper(ICommand cmd) {
        return new ICommandProxy(cmd);
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected void addDestroyShortcutsCommand(ICompositeCommand cmd, View view) {
        assert (view.getEAnnotation("Shortcut") == null);
        for (View nextView : view.getDiagram().getChildren()) {
            if (nextView.getEAnnotation("Shortcut") == null || !nextView.isSetElement() || nextView.getElement() != view.getElement()) continue;
            cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), nextView));
        }
    }

    public static LinkConstraints getLinkConstraints() {
        LinkConstraints cached = UMLDiagramEditorPlugin.getInstance().getLinkConstraints();
        if (cached == null) {
            cached = new LinkConstraints();
            UMLDiagramEditorPlugin.getInstance().setLinkConstraints(cached);
        }
        return cached;
    }

    public static class LinkConstraints {
        public boolean canCreateLink_4005() {
            return this.canExistLink_4005();
        }

        public boolean canCreateCommentAnnotatedElement_4008(Comment source, Element target) {
            if (source != null && source.getAnnotatedElements().contains((Object)target)) {
                return false;
            }
            return this.canExistCommentAnnotatedElement_4008(source, target);
        }

        public boolean canCreateConstraintConstrainedElement_4009(Constraint source, Element target) {
            if (source != null && source.getConstrainedElements().contains((Object)target)) {
                return false;
            }
            return this.canExistConstraintConstrainedElement_4009(source, target);
        }

        public boolean canCreateDeployment_4001(DeploymentTarget container, NamedElement source, NamedElement target) {
            return this.canExistDeployment_4001(container, null, source, target);
        }

        public boolean canCreateManifestation_4002(Artifact container, NamedElement source, NamedElement target) {
            return this.canExistManifestation_4002(container, null, source, target);
        }

        public boolean canCreateGeneralization_4003(Classifier container, Classifier source, Classifier target) {
            return this.canExistGeneralization_4003(container, null, source, target);
        }

        public boolean canCreateDependency_4004(Package container, NamedElement source, NamedElement target) {
            return this.canExistDependency_4004(container, null, source, target);
        }

        public boolean canCreateDependency_4010(Package container, NamedElement source, NamedElement target) {
            return this.canExistDependency_4010(container, null, source, target);
        }

        public boolean canExistLink_4005() {
            return true;
        }

        public boolean canExistCommentAnnotatedElement_4008(Comment source, Element target) {
            return true;
        }

        public boolean canExistConstraintConstrainedElement_4009(Constraint source, Element target) {
            return true;
        }

        public boolean canExistDeployment_4001(DeploymentTarget container, Deployment linkInstance, NamedElement source, NamedElement target) {
            return true;
        }

        public boolean canExistManifestation_4002(Artifact container, Manifestation linkInstance, NamedElement source, NamedElement target) {
            return true;
        }

        public boolean canExistGeneralization_4003(Classifier container, Generalization linkInstance, Classifier source, Classifier target) {
            return true;
        }

        public boolean canExistDependency_4004(Package container, Dependency linkInstance, NamedElement source, NamedElement target) {
            return true;
        }

        public boolean canExistDependency_4010(Package container, Dependency linkInstance, NamedElement source, NamedElement target) {
            return true;
        }
    }
}

