/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.interactionoverview.utils;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramImageGenerator;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.FilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.uml.diagram.communication.edit.parts.LifelineEditPartCN;
import org.eclipse.papyrus.uml.diagram.interactionoverview.Activator;
import org.eclipse.papyrus.uml.diagram.interactionoverview.part.Messages;
import org.eclipse.papyrus.uml.diagram.interactionoverview.utils.CallBehaviorUtil;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.NamedElement;

public class CreateDiagramImage {
    public static org.eclipse.swt.graphics.Image getDiagramImage(Diagram diagram, PreferencesHint preferencesHint, ImageFigure imageFigure, View callBehaviorActionView) {
        org.eclipse.swt.graphics.Image image = null;
        DiagramEditPart diagramEditPart = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, new Shell(), preferencesHint);
        if (diagramEditPart != null) {
            image = CreateDiagramImage.getDiagramImage(diagramEditPart, imageFigure, callBehaviorActionView);
            diagramEditPart.deactivate();
        }
        return image;
    }

    public static org.eclipse.swt.graphics.Image getDiagramImage(DiagramEditPart diagramEP, ImageFigure imageFigure, View callBehaviorActionView) {
        List editParts = diagramEP.getPrimaryEditParts();
        CreateDiagramImage.getAllChildren((GraphicalEditPart)diagramEP, editParts);
        List<GraphicalEditPart> lifelines = CreateDiagramImage.getAllLifeline(editParts);
        DiagramImageGenerator gen = new DiagramImageGenerator(diagramEP);
        if (CallBehaviorUtil.isBehaviorNew(callBehaviorActionView)) {
            CallBehaviorUtil.setBehaviorAsNonNew(callBehaviorActionView);
            List<Object> selectedLifelines = Arrays.asList(CreateDiagramImage.selectLifelines(lifelines));
            ArrayList<GraphicalEditPart> removedLifeline = new ArrayList<GraphicalEditPart>(lifelines);
            removedLifeline.removeAll(selectedLifelines);
            ArrayList<GraphicalEditPart> removedLifelineCopyForIterate = new ArrayList<GraphicalEditPart>(removedLifeline);
            for (Object e : removedLifelineCopyForIterate) {
                CreateDiagramImage.getAllChildren((GraphicalEditPart)e, removedLifeline);
            }
            ArrayList filteredEditParts = new ArrayList(editParts);
            for (GraphicalEditPart graphicalEditPart : editParts) {
                if (!removedLifeline.contains(graphicalEditPart)) continue;
                graphicalEditPart.getFigure().setVisible(false);
                View view = (View)graphicalEditPart.getModel();
                if (view.getElement() != null && view.getElement() instanceof NamedElement) {
                    CallBehaviorUtil.addLifelineQualifiedNames(callBehaviorActionView, ((NamedElement)view.getElement()).getQualifiedName());
                }
                for (GraphicalEditPart source : graphicalEditPart.getSourceConnections()) {
                    source.getFigure().setVisible(false);
                }
                for (GraphicalEditPart source : graphicalEditPart.getTargetConnections()) {
                    source.getFigure().setVisible(false);
                }
            }
        } else {
            List<String> qualifiedNames = CallBehaviorUtil.getRemovedLifelinesQualifiedNames(callBehaviorActionView);
            for (GraphicalEditPart graphicalEditPart : editParts) {
                String string;
                View view = (View)graphicalEditPart.getModel();
                if (view.getElement() == null || !(view.getElement() instanceof Lifeline) || !qualifiedNames.contains(string = ((Lifeline)view.getElement()).getQualifiedName())) continue;
                graphicalEditPart.getFigure().setVisible(false);
                for (GraphicalEditPart source : graphicalEditPart.getSourceConnections()) {
                    source.getFigure().setVisible(false);
                }
                for (GraphicalEditPart source : graphicalEditPart.getTargetConnections()) {
                    source.getFigure().setVisible(false);
                }
            }
        }
        Rectangle rectangle = gen.calculateImageRectangle(diagramEP.getPrimaryEditParts());
        ImageDescriptor descriptor = gen.createSWTImageDescriptorForParts(diagramEP.getPrimaryEditParts(), rectangle);
        return CreateDiagramImage.resize(descriptor.createImage(), rectangle.width, rectangle.height);
    }

    private static Object[] selectLifelines(List<GraphicalEditPart> lifelines) {
        Object[] result;
        ServicesRegistry servicesRegistry = ((IMultiDiagramEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getServicesRegistry();
        ReferenceSelector referenceSelector = new ReferenceSelector(true);
        StaticContentProvider semanticProvider = new StaticContentProvider(lifelines.toArray());
        FilteredContentProvider filteredProvider = new FilteredContentProvider((IStructuredContentProvider)semanticProvider);
        referenceSelector.setContentProvider((IStaticContentProvider)filteredProvider);
        MultipleValueSelectorDialog dialog = null;
        ILabelProvider serv = null;
        try {
            serv = ((LabelProviderService)servicesRegistry.getService(LabelProviderService.class)).getLabelProvider();
        }
        catch (ServiceException e) {
            Activator.log.error("LabelProviderServiceNotFound", (Throwable)e);
        }
        referenceSelector.setLabelProvider(serv);
        dialog = new MultipleValueSelectorDialog(Display.getDefault().getActiveShell(), (IElementSelector)referenceSelector, Messages.CreateDiagramImage_MultipleValueSelectorDialog, true, false, -1);
        dialog.setLabelProvider(serv);
        dialog.setMessage(Messages.CreateDiagramImage_LifelineDialogMessage);
        dialog.setTitle(Messages.CreateDiagramImage_LifelineDialogTitle);
        dialog.setInitialElementSelections(lifelines);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0) {
            return result;
        }
        return new Object[0];
    }

    private static List<GraphicalEditPart> getAllLifeline(List<GraphicalEditPart> editParts) {
        ArrayList<GraphicalEditPart> allChild = new ArrayList<GraphicalEditPart>();
        for (GraphicalEditPart editPart : editParts) {
            CreateDiagramImage.getAllChildren(editPart, allChild);
        }
        ArrayList<GraphicalEditPart> lifelines = new ArrayList<GraphicalEditPart>();
        for (GraphicalEditPart graphicalEditPart : allChild) {
            if (!CreateDiagramImage.isValidLifelineEditPart(graphicalEditPart)) continue;
            lifelines.add(graphicalEditPart);
        }
        return lifelines;
    }

    private static boolean isValidLifelineEditPart(GraphicalEditPart graphicalEditPart) {
        return graphicalEditPart instanceof LifelineEditPart || graphicalEditPart instanceof LifelineEditPartCN || graphicalEditPart instanceof org.eclipse.papyrus.uml.diagram.timing.edit.parts.LifelineEditPart;
    }

    private static List<GraphicalEditPart> getAllChildren(GraphicalEditPart ep, List<GraphicalEditPart> result) {
        for (Object object : ep.getChildren()) {
            GraphicalEditPart gep = (GraphicalEditPart)object;
            if (!result.contains(gep)) {
                result.add(gep);
            }
            if (gep.getChildren().isEmpty()) continue;
            CreateDiagramImage.getAllChildren(gep, result);
        }
        return result;
    }

    public static org.eclipse.swt.graphics.Image resize(org.eclipse.swt.graphics.Image image, int newWidth, int newHeight) {
        BufferedImage img = CreateDiagramImage.convertToAWT(image.getImageData());
        Image scaledImage = img.getScaledInstance(newWidth, newHeight, 16);
        img = new BufferedImage(newWidth, newHeight, 1);
        img.getGraphics().drawImage(scaledImage, 0, 0, null);
        ImageData imageData = CreateDiagramImage.convertToSWT(img);
        return new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), imageData);
    }

    public static BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    pixelArray[0] = rgb.red;
                    pixelArray[1] = rgb.green;
                    pixelArray[2] = rgb.blue;
                    raster.setPixels(x, y, 1, 1, pixelArray);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    public static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    int pixel = palette.getPixel(new RGB(pixelArray[0], pixelArray[1], pixelArray[2]));
                    data.setPixel(x, y, pixel);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }
}

