/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.requests.SetAllBendpointRequest;
import org.eclipse.papyrus.uml.diagram.common.editparts.BorderNamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.layout.DistributionConstants;
import org.eclipse.papyrus.uml.diagram.common.layout.LayoutUtils;
import org.eclipse.papyrus.uml.diagram.common.layout.LinkRepresentationForLayoutAction;
import org.eclipse.papyrus.uml.diagram.common.util.Util;
import org.eclipse.papyrus.uml.diagram.menu.Activator;
import org.eclipse.papyrus.uml.diagram.menu.actions.AbstractDistributeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributeAffixedChildNodeLinkAction
extends AbstractDistributeAction {
    private List<NodeRepresentation> commonParentRepresentations;
    private int mode;
    public static final int DISTRIBUTE_ON_ONE_END = 1;
    public static final int DISTRIBUTE_ON_TWO_END = 2;

    public DistributeAffixedChildNodeLinkAction(int distribution, List<IGraphicalEditPart> selectedElements) {
        super(distribution, selectedElements);
    }

    @Override
    protected void buildAction(List<?> list) {
        this.commonParentRepresentations = new ArrayList<NodeRepresentation>();
        Collections.sort(list, new TypeComparator());
        this.mode = this.getMode(list);
        block4: for (Object current : list) {
            NodeRepresentation representation;
            if (current instanceof ConnectionEditPart) {
                switch (this.mode) {
                    case 1: {
                        representation = this.getCorrespondingRepresentation((EditPart)current);
                        if (representation == null) continue block4;
                        LinkRepresentationForLayoutAction link = new LinkRepresentationForLayoutAction((ConnectionEditPart)current);
                        representation.addElements(link);
                        break;
                    }
                    case 2: {
                        NodeRepresentation representationSource = this.getCorrespondingRepresentation(((ConnectionEditPart)current).getSource());
                        NodeRepresentation representationTarget = this.getCorrespondingRepresentation(((ConnectionEditPart)current).getTarget());
                        LinkRepresentationForLayoutAction linkRep = new LinkRepresentationForLayoutAction((ConnectionEditPart)current);
                        if (representationSource == null) {
                            representationSource = new NodeRepresentation(((ConnectionEditPart)current).getSource());
                            this.commonParentRepresentations.add(representationSource);
                        }
                        if (representationTarget == null) {
                            representationTarget = new NodeRepresentation(((ConnectionEditPart)current).getTarget());
                            this.commonParentRepresentations.add(representationTarget);
                        }
                        representationSource.addElements(linkRep);
                        representationTarget.addElements(linkRep);
                        break;
                    }
                }
                continue;
            }
            if (Util.isAffixedChildNode((EditPart)((EditPart)current))) {
                representation = this.getCorrespondingRepresentation((EditPart)current);
                if (representation != null) {
                    representation.addElements(new AffixedChildNodeRepresentation((EditPart)current));
                    continue;
                }
                representation = new NodeRepresentation(((EditPart)current).getParent());
                this.commonParentRepresentations.add(representation);
                representation.addElements(new AffixedChildNodeRepresentation((EditPart)current));
                continue;
            }
            this.commonParentRepresentations.add(new NodeRepresentation((EditPart)current));
        }
    }

    protected int getMode(List<?> list) {
        for (Object current : list) {
            if (!(current instanceof ConnectionEditPart)) continue;
            EditPart source = ((ConnectionEditPart)current).getSource();
            EditPart target = ((ConnectionEditPart)current).getTarget();
            if (!list.contains(source) && !list.contains(target)) continue;
            return 1;
        }
        return 2;
    }

    @Override
    public Command getCommand() {
        CompoundCommand command = new CompoundCommand("Distribute Affixed Child Nodes and Links");
        if (this.canExistCommand(this.selectedElements) && this.onOppositeSide()) {
            for (NodeRepresentation current : this.commonParentRepresentations) {
                Command cmd = current.getCommand();
                if (cmd == null || !cmd.canExecute()) continue;
                command.add(cmd);
            }
        }
        return command.isEmpty() ? UnexecutableCommand.INSTANCE : command;
    }

    protected boolean onOppositeSide() {
        for (NodeRepresentation current : this.commonParentRepresentations) {
            if (current.onCorrectSide()) continue;
            return false;
        }
        return true;
    }

    protected NodeRepresentation getCorrespondingRepresentation(EditPart ep) {
        if (ep instanceof ConnectionEditPart) {
            EditPart source = ((ConnectionEditPart)ep).getSource();
            EditPart target = ((ConnectionEditPart)ep).getTarget();
            for (NodeRepresentation current : this.commonParentRepresentations) {
                EditPart node = current.getRepresentedNode();
                if (node != source && node != target) continue;
                return current;
            }
        } else if (Util.isAffixedChildNode((EditPart)ep)) {
            EditPart parent = ep.getParent();
            for (NodeRepresentation current : this.commonParentRepresentations) {
                if (current.getRepresentedNode() != parent) continue;
                return current;
            }
        } else {
            for (NodeRepresentation current : this.commonParentRepresentations) {
                EditPart node = current.getRepresentedNode();
                if (node != ep) continue;
                return current;
            }
        }
        return null;
    }

    protected class AffixedChildNodeRepresentation {
        private EditPart affixedChildNode;
        private Point newLocation;

        public AffixedChildNodeRepresentation(EditPart affixedChildNode) {
            this.affixedChildNode = affixedChildNode;
        }

        public Point getAbsoluteLocation() {
            return this.getAbsolutePosition().getTopLeft();
        }

        public int getSideOnParent() {
            IBorderItemLocator loc = ((BorderNamedElementEditPart)this.affixedChildNode).getBorderItemLocator();
            return loc.getCurrentSideOfParent();
        }

        public PrecisionRectangle getAbsolutePosition() {
            return LayoutUtils.getAbsolutePosition((EditPart)this.affixedChildNode);
        }

        public Command getCommand() {
            Request req = this.getRequest();
            if (req == null) {
                return UnexecutableCommand.INSTANCE;
            }
            return this.affixedChildNode.getCommand(req);
        }

        public Request getRequest() {
            if (this.newLocation != null) {
                ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move");
                req.setEditParts(this.affixedChildNode);
                PrecisionRectangle absolutePosition = LayoutUtils.getAbsolutePosition((EditPart)this.affixedChildNode);
                PrecisionPoint oldLocation = new PrecisionPoint(absolutePosition.preciseX, absolutePosition.preciseY);
                Dimension delta = this.newLocation.getDifference((Point)oldLocation);
                req.setMoveDelta(new Point(delta.width, delta.height));
                req.setSizeDelta(absolutePosition.getSize().getDifference(absolutePosition.getSize()));
                return req;
            }
            return null;
        }

        public void setNewLocation(Point pt) {
            this.newLocation = pt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CoordinatesComparator
    implements Comparator<Object> {
        private EditPart reference;

        public CoordinatesComparator(EditPart ep) {
            this.reference = ep;
        }

        @Override
        public int compare(Object o1, Object o2) {
            Point location1 = new Point();
            Point location2 = new Point();
            if (o1 instanceof LinkRepresentationForLayoutAction) {
                location1 = ((LinkRepresentationForLayoutAction)o1).getAbsoluteLocationOn(this.reference);
            } else if (o1 instanceof AffixedChildNodeRepresentation) {
                location1 = ((AffixedChildNodeRepresentation)o1).getAbsoluteLocation();
            }
            if (o2 instanceof LinkRepresentationForLayoutAction) {
                location2 = ((LinkRepresentationForLayoutAction)o2).getAbsoluteLocationOn(this.reference);
            } else if (o2 instanceof AffixedChildNodeRepresentation) {
                location2 = ((AffixedChildNodeRepresentation)o2).getAbsoluteLocation();
            }
            if (DistributeAffixedChildNodeLinkAction.this.distribution == 64 || DistributeAffixedChildNodeLinkAction.this.distribution == 66) {
                if (location1.x < location2.x) {
                    return -1;
                }
                if (location1.x == location2.x) {
                    return 0;
                }
                return 1;
            }
            if (location1.y < location2.y) {
                return -1;
            }
            if (location1.y == location2.y) {
                return 0;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NodeRepresentation {
        private EditPart representedNode;
        private List<Object> elementsToDistribute;

        public NodeRepresentation(EditPart representedNode) {
            this.representedNode = representedNode;
            this.elementsToDistribute = new ArrayList<Object>();
        }

        public boolean onCorrectSide() {
            for (Object current : this.elementsToDistribute) {
                if (current instanceof AffixedChildNodeRepresentation) {
                    int side = ((AffixedChildNodeRepresentation)current).getSideOnParent();
                    if (!(DistributeAffixedChildNodeLinkAction.this.distribution == 64 || DistributeAffixedChildNodeLinkAction.this.distribution == 66 ? !DistributionConstants.horizontalValuesList.contains(side) : !DistributionConstants.verticalValuesList.contains(side))) continue;
                    return false;
                }
                if (!(current instanceof LinkRepresentationForLayoutAction)) continue;
                int sourceSide = ((LinkRepresentationForLayoutAction)current).getSideOnSource();
                int targetSide = ((LinkRepresentationForLayoutAction)current).getSideOnTarget();
                if (!(DistributeAffixedChildNodeLinkAction.this.distribution == 64 || DistributeAffixedChildNodeLinkAction.this.distribution == 66 ? !DistributionConstants.horizontalValuesList.contains(sourceSide) && !DistributionConstants.horizontalValuesList.contains(targetSide) : !DistributionConstants.verticalValuesList.contains(sourceSide) && !DistributionConstants.verticalValuesList.contains(targetSide))) continue;
                return false;
            }
            return true;
        }

        public void calculateNewLocations() {
            Collections.sort(this.elementsToDistribute, new CoordinatesComparator(this.representedNode));
            PrecisionRectangle boundsArea = this.calcultateArea(this.representedNode);
            double[] hSpaceAndvSpace = this.calculatesSpaceBetweenNodes(boundsArea, this.elementsToDistribute, this.representedNode);
            double newPosition = 0.0;
            switch (DistributeAffixedChildNodeLinkAction.this.distribution) {
                case 64: {
                    newPosition = !DistributeAffixedChildNodeLinkAction.this.horizontalDegradedMode ? boundsArea.preciseX + hSpaceAndvSpace[0] : boundsArea.preciseX();
                    break;
                }
                case 66: {
                    newPosition = boundsArea.preciseX;
                    break;
                }
                case 128: {
                    newPosition = !DistributeAffixedChildNodeLinkAction.this.verticalDegradedMode ? boundsArea.preciseY + hSpaceAndvSpace[1] : boundsArea.preciseY();
                    break;
                }
                case 144: {
                    newPosition = boundsArea.preciseY;
                    break;
                }
            }
            boolean eastPort = false;
            boolean westPort = false;
            boolean northPort = false;
            boolean southPort = false;
            for (Object current : this.elementsToDistribute) {
                int side = 0;
                PrecisionRectangle absolutePosition = null;
                PrecisionPoint ptLocation = null;
                if (current instanceof LinkRepresentationForLayoutAction) {
                    side = ((LinkRepresentationForLayoutAction)current).getCurrentSideOn(this.representedNode);
                    absolutePosition = ((LinkRepresentationForLayoutAction)current).getAbsolutePositionOn(this.representedNode);
                } else if (current instanceof AffixedChildNodeRepresentation) {
                    side = ((AffixedChildNodeRepresentation)current).getSideOnParent();
                    absolutePosition = ((AffixedChildNodeRepresentation)current).getAbsolutePosition();
                }
                switch (DistributeAffixedChildNodeLinkAction.this.distribution) {
                    case 64: {
                        if (!DistributionConstants.horizontalValuesList.contains(side)) break;
                        ptLocation = new PrecisionPoint(newPosition, absolutePosition.preciseY);
                        newPosition += absolutePosition.preciseWidth() + hSpaceAndvSpace[0];
                        break;
                    }
                    case 66: {
                        if (DistributionConstants.horizontalValuesList.contains(side)) {
                            ptLocation = new PrecisionPoint(newPosition, absolutePosition.preciseY);
                            newPosition += absolutePosition.preciseWidth() + hSpaceAndvSpace[0];
                            break;
                        }
                        if (!eastPort && side == 16) {
                            eastPort = true;
                            ptLocation = new PrecisionPoint(absolutePosition.preciseX, absolutePosition.preciseY);
                            newPosition += absolutePosition.preciseWidth() + hSpaceAndvSpace[0];
                            break;
                        }
                        if (westPort || side != 8) break;
                        westPort = true;
                        ptLocation = new PrecisionPoint(absolutePosition.preciseX, absolutePosition.preciseY);
                        newPosition += absolutePosition.preciseWidth() + hSpaceAndvSpace[0];
                        break;
                    }
                    case 128: {
                        if (!DistributionConstants.verticalValuesList.contains(side)) break;
                        ptLocation = new PrecisionPoint(absolutePosition.preciseX, newPosition);
                        newPosition += absolutePosition.preciseHeight() + hSpaceAndvSpace[1];
                        break;
                    }
                    case 144: {
                        if (DistributionConstants.verticalValuesList.contains(side)) {
                            ptLocation = new PrecisionPoint(absolutePosition.preciseX, newPosition);
                            newPosition += absolutePosition.preciseHeight() + hSpaceAndvSpace[1];
                            break;
                        }
                        if (!northPort && side == 1) {
                            northPort = true;
                            ptLocation = new PrecisionPoint(absolutePosition.preciseX, absolutePosition.preciseY);
                            newPosition += absolutePosition.preciseHeight() + hSpaceAndvSpace[1];
                            break;
                        }
                        if (southPort || side != 4) break;
                        southPort = true;
                        ptLocation = new PrecisionPoint(absolutePosition.preciseX, absolutePosition.preciseY);
                        newPosition += absolutePosition.preciseHeight() + hSpaceAndvSpace[1];
                        break;
                    }
                }
                if (current instanceof LinkRepresentationForLayoutAction) {
                    ((LinkRepresentationForLayoutAction)current).setNewLocationFor(this.representedNode, ptLocation);
                    continue;
                }
                if (!(current instanceof AffixedChildNodeRepresentation)) continue;
                ((AffixedChildNodeRepresentation)current).setNewLocation((Point)ptLocation);
            }
        }

        public Command getCommand() {
            this.calculateNewLocations();
            CompoundCommand command = new CompoundCommand("Distribute Command");
            for (Object obj : this.elementsToDistribute) {
                Command cmd = null;
                if (obj instanceof AffixedChildNodeRepresentation) {
                    cmd = ((AffixedChildNodeRepresentation)obj).getCommand();
                } else if (obj instanceof LinkRepresentationForLayoutAction) {
                    cmd = new CompoundCommand("Move Link and remove bendpoints");
                    ((CompoundCommand)cmd).add(((LinkRepresentationForLayoutAction)obj).getCommand());
                    SetAllBendpointRequest noBendpoints = new SetAllBendpointRequest("set_all_connection_bendpoint", new PointList(), null, null);
                    ((CompoundCommand)cmd).add(((LinkRepresentationForLayoutAction)obj).getRepresentedLink().getCommand((Request)noBendpoints));
                }
                if (cmd == null || !cmd.canExecute()) continue;
                command.add(cmd);
            }
            return command;
        }

        protected PrecisionRectangle calcultateArea(EditPart node) {
            PrecisionRectangle bounds = new PrecisionRectangle();
            Object first = this.elementsToDistribute.get(0);
            Object last = this.elementsToDistribute.get(this.elementsToDistribute.size() - 1);
            Point locStart = new Point();
            PrecisionRectangle locEnd = new PrecisionRectangle();
            switch (DistributeAffixedChildNodeLinkAction.this.distribution) {
                case 64: 
                case 128: {
                    bounds = LayoutUtils.getAbsolutePosition((EditPart)node);
                    break;
                }
                case 66: {
                    if (first instanceof LinkRepresentationForLayoutAction) {
                        locStart = ((LinkRepresentationForLayoutAction)first).getAbsoluteLocationOn(this.representedNode);
                    } else if (first instanceof AffixedChildNodeRepresentation) {
                        locStart = ((AffixedChildNodeRepresentation)first).getAbsoluteLocation();
                    }
                    if (last instanceof LinkRepresentationForLayoutAction) {
                        locEnd = ((LinkRepresentationForLayoutAction)last).getAbsolutePositionOn(this.representedNode);
                    } else if (last instanceof AffixedChildNodeRepresentation) {
                        locEnd = ((AffixedChildNodeRepresentation)last).getAbsolutePosition();
                    }
                    bounds.setLocation(locStart);
                    bounds.setHeight(0);
                    bounds.setWidth(locEnd.getRight().preciseX() - locStart.preciseX());
                    break;
                }
                case 144: {
                    if (first instanceof LinkRepresentationForLayoutAction) {
                        locStart = ((LinkRepresentationForLayoutAction)first).getAbsoluteLocationOn(this.representedNode);
                    } else if (first instanceof AffixedChildNodeRepresentation) {
                        locStart = ((AffixedChildNodeRepresentation)first).getAbsoluteLocation();
                    }
                    if (last instanceof LinkRepresentationForLayoutAction) {
                        locEnd = ((LinkRepresentationForLayoutAction)last).getAbsolutePositionOn(this.representedNode);
                    } else if (last instanceof AffixedChildNodeRepresentation) {
                        locEnd = ((AffixedChildNodeRepresentation)last).getAbsolutePosition();
                    }
                    bounds.setLocation(locStart);
                    bounds.setHeight(locEnd.getBottom().preciseY() - locStart.preciseY());
                    bounds.setWidth(0);
                    break;
                }
            }
            return bounds;
        }

        public void addElements(Object obj) {
            if (!(obj instanceof AffixedChildNodeRepresentation) && !(obj instanceof LinkRepresentationForLayoutAction)) {
                Activator.log.debug("The added element has not a correct type");
            }
            this.elementsToDistribute.add(obj);
        }

        public EditPart getRepresentedNode() {
            return this.representedNode;
        }

        protected double[] calculatesSpaceBetweenNodes(PrecisionRectangle boundsArea, List<Object> nodeChild, EditPart node) {
            DistributeAffixedChildNodeLinkAction.this.setHorizontalDegradedMode(false);
            DistributeAffixedChildNodeLinkAction.this.setVerticalDegradedMode(false);
            double vertical = 0.0;
            double horizontal = 0.0;
            double vSpace = 0.0;
            double hSpace = 0.0;
            double[] hSpaceAndvSpace = new double[]{0.0, 0.0};
            double nbPort = 0.0;
            boolean eastPort = false;
            boolean westPort = false;
            boolean northPort = false;
            boolean southPort = false;
            block6: for (Object current : nodeChild) {
                PrecisionRectangle rect = new PrecisionRectangle();
                int side = 0;
                if (current instanceof LinkRepresentationForLayoutAction) {
                    rect = ((LinkRepresentationForLayoutAction)current).getAbsolutePositionOn(node);
                    side = ((LinkRepresentationForLayoutAction)current).getCurrentSideOn(node);
                } else if (current instanceof AffixedChildNodeRepresentation) {
                    rect = ((AffixedChildNodeRepresentation)current).getAbsolutePosition();
                    side = ((AffixedChildNodeRepresentation)current).getSideOnParent();
                }
                switch (DistributeAffixedChildNodeLinkAction.this.distribution) {
                    case 64: {
                        if (!DistributionConstants.horizontalValuesList.contains(side)) break;
                        vertical += rect.preciseHeight();
                        horizontal += rect.preciseWidth();
                        nbPort += 1.0;
                        break;
                    }
                    case 66: {
                        if (DistributionConstants.horizontalValuesList.contains(side)) {
                            vertical += rect.preciseHeight();
                            horizontal += rect.preciseWidth();
                            nbPort += 1.0;
                            break;
                        }
                        if (side == 16 && !eastPort) {
                            eastPort = true;
                            vertical += rect.preciseHeight();
                            horizontal += rect.preciseWidth();
                            nbPort += 1.0;
                            break;
                        }
                        if (side != 8 || westPort) continue block6;
                        westPort = true;
                        vertical += rect.preciseHeight();
                        horizontal += rect.preciseWidth();
                        nbPort += 1.0;
                        break;
                    }
                    case 128: {
                        if (!DistributionConstants.verticalValuesList.contains(side)) break;
                        vertical += rect.preciseHeight();
                        horizontal += rect.preciseWidth();
                        nbPort += 1.0;
                        break;
                    }
                    case 144: {
                        if (DistributionConstants.verticalValuesList.contains(side)) {
                            vertical += rect.preciseHeight();
                            horizontal += rect.preciseWidth();
                            nbPort += 1.0;
                            break;
                        }
                        if (side == 1 && !northPort) {
                            northPort = true;
                            vertical += rect.preciseHeight();
                            horizontal += rect.preciseWidth();
                            nbPort += 1.0;
                            break;
                        }
                        if (side != 4 || southPort) continue block6;
                        southPort = true;
                        vertical += rect.preciseHeight();
                        horizontal += rect.preciseWidth();
                        nbPort += 1.0;
                        break;
                    }
                }
            }
            double divisor = DistributeAffixedChildNodeLinkAction.this.distribution == 64 || DistributeAffixedChildNodeLinkAction.this.distribution == 128 ? nbPort + 1.0 : nbPort - 1.0;
            hSpace = (boundsArea.preciseWidth() - horizontal) / divisor;
            vSpace = (boundsArea.preciseHeight() - vertical) / divisor;
            if (hSpace < 0.0) {
                DistributeAffixedChildNodeLinkAction.this.setHorizontalDegradedMode(true);
                double diff = boundsArea.preciseWidth() - horizontal;
                hSpace = diff / (divisor - 2.0);
            }
            if (vSpace < 0.0) {
                DistributeAffixedChildNodeLinkAction.this.setVerticalDegradedMode(true);
                double diff = boundsArea.preciseHeight() - vertical;
                vSpace = diff / (divisor - 2.0);
            }
            hSpaceAndvSpace[0] = hSpace;
            hSpaceAndvSpace[1] = vSpace;
            return hSpaceAndvSpace;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TypeComparator
    implements Comparator<Object> {
        protected TypeComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int index2;
            int index1 = this.getIndex((EditPart)o1);
            if (index1 == (index2 = this.getIndex((EditPart)o2))) {
                return 0;
            }
            if (index1 < index2) {
                return -1;
            }
            return 1;
        }

        protected int getIndex(EditPart ep) {
            if (ep instanceof ConnectionEditPart) {
                return 2;
            }
            if (Util.isAffixedChildNode((EditPart)ep)) {
                return 3;
            }
            return 1;
        }
    }
}

